Rem cwm2valu.pls
Rem
Rem Copyright (c) 1900, 2004, Oracle Corporation.  All rights reserved.  
Rem
Rem    NAME
Rem      cwm2valu.pls 
Rem
Rem    DESCRIPTION
Rem      validate utility package (not for public use)
Rem
Rem    NOTES
Rem      <other useful comments, qualifications, etc.>
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    awesley     06/08/04 - move table OLAPSYS.CwM2$OLAPValidateTable back
Rem    awesley     03/24/04 - move table OLAPSYS.CwM2$OLAPValidateTable to cwm2valu.sql, add version
Rem    awesley     11/17/03 - add Level_Key_Position to OLAPSYS.CwM2$OLAPValidateTable
Rem    awesley     03/27/03 - 
Rem    awesley     03/26/03 -
Rem    awesley     03/07/03 -
Rem    awesley     03/03/03 -
Rem    awesley     10/16/02 - awesley_txn104113
Rem    awesley     09/11/02 - Created
Rem

drop table OLAPSYS.CwM2$OLAPValidateTable
/
show errors;

create global temporary table OLAPSYS.CwM2$OLAPValidateTable
  (Entity_Sequence         number
  ,Entity_IRID             number
  ,Entity_Type             varchar2(30)  
  ,Entity_Status           varchar2(30)
  ,Entity_Comment          varchar2(4000)
  ,Cube_Owner              varchar2(30)
  ,Cube_Name               varchar2(30)
  ,Dimension_Owner         varchar2(30)
  ,Dimension_Name          varchar2(30)
  ,DimensionAttribute_Name varchar2(30)
  ,Hierarchy_Name          varchar2(30)
  ,Hierarchy_Sort_Position number
  ,Hierarchy_Sort_SortPos  number
  ,Level_Name              varchar2(30)
  ,Level_Depth             number
  ,Level_Key_Position      number
  ,LevelAttribute_Name     varchar2(30)
  ,FactTable_Owner         varchar2(30)
  ,FactTable_Name          varchar2(30)
  ,FactTableMeasure_Name   varchar2(30)
  )
  on commit delete rows
/
show errors;
 
create or replace package cwm2_olap_validate_utility as
  VALIDATE_VERSION varchar2(6) := '040401';

  procedure Save_Null_Status(p_Entity_IRID number
                            ,p_Entity_Type varchar2
                            ,p_Entity_Comment varchar2 default null
                            );

  procedure Save_Valid_Status(p_Entity_IRID number
                             ,p_Entity_Type varchar2
                             ,p_Entity_Name OLAPSYS.CwM2$OLAPValidateTable%rowtype
                             ,p_Entity_Comment varchar2 default null
                             ,p_Verbose_Report varchar2 default 'NO'
                             );

  procedure Save_Invalid_Status(p_Entity_IRID number
                               ,p_Entity_Type varchar2
                               ,p_Entity_Name OLAPSYS.CwM2$OLAPValidateTable%rowtype
                               ,p_Entity_Comment varchar2 default null
                               );

  procedure Save_Note_Status(p_Entity_IRID number 
                            ,p_Entity_Type varchar2
                            ,p_Entity_Name OLAPSYS.CwM2$OLAPValidateTable%rowtype
                            ,p_Entity_Comment varchar2 default null
                            );

  procedure Init_Validate(p_Verbose_Report varchar2
                         );

  procedure Report_Validate;

end cwm2_olap_validate_utility;
/

show errors;

