--
-- $Header: onepdim.pls 27-apr-2000.11:20:51 dthompso Exp $
--
-- onepdim.pls
--
-- Copyright (c) Oracle Corporation 2000. All Rights Reserved.
--
--   NAME
--     onepdim.pls cwm$olap$dimension
--
--   DESCRIPTION
--     Extended metadata properties for Dimension objects.
--
--   RETURNS
--
--   NOTES
--     
--
--   MODIFIED   (MM/DD/YY)
--   dthompso    04/27/00 - Initial Version
--   dthompso    01/00/00 - Creation
--


create or replace package cwm$olap$dimension as
 
  -- Set a plural name for a dimension.
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param plural_name           new plural name for the dimension
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise dimension_not_found   if dimension doesn't exist
  procedure set_plural_name(owner varchar2
                          , dimension_name varchar2
                          , plural_name varchar2);

  -- Set a display name for a dimension.
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param display_name          new display name for the dimension
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise dimension_not_found   if dimension doesn't exist
  procedure set_display_name(owner varchar2
                           , dimension_name varchar2
                           , display_name varchar2);

  -- Set the description for a dimension.
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param description           new descriptive text for the dimension
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise dimension_not_found   if dimension doesn't exist
  procedure set_description(owner varchar2
                          , dimension_name varchar2
                          , description varchar2);

  -- Set a new default display hierarcy for the dimension
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param hierarchy_name        name of the default display hierarchy
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise dimension_not_found   if dimension doesn't exist
  procedure set_default_display_hierarchy(owner varchar2
                                         ,dimension_name varchar2
                                         ,hierarchy_name varchar2);

  -- Lock the dimension metadata for update
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param wait_for_lock         wait for lock if acquired by other user
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise dimension_not_found   if dimension does not exist
  -- raise failed_to_gain_lock   if lock could not be acquired
  procedure lock_dimension(owner varchar2
                         , dimension_name varchar2
                         , wait_for_lock boolean := false);
                    
  -- Internal function to get the id of a dimension, creating a CWM
  -- dimension instance if it doesn't already exist.
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  --
  -- raise dimension_not_found   if dimension doesn't exist 
  function get_dimension_id(owner varchar2
                          , dimension_name varchar2) return number;
                          
end;
/
