--
-- $Header: onepexpt.pls 07-jul-2000.14:02:45 dthompso Exp $
--
-- onepexpt.pls
--
-- Copyright (c) Oracle Corporation 1900, 2000. All Rights Reserved.
--
--   NAME
--     onepexpt.pls - cwm$export
--
--   DESCRIPTION
--     Export functionality - generates API script corresponding to
--     the stored metadata, allowing re-creation on seperate instance.
--
--   RETURNS
--
--   NOTES
--     
--
--   MODIFIED   (MM/DD/YY)
--   dthompso    07/07/00 - Pass export lob back as parameter
--   dthompso    04/27/00 - Initial Version
--   dthompso    01/00/00 - Creation
--


create or replace package cwm$export as

  -- Generate a script of API calls to recreate the contents of the repository.
  --
  -- param script               handle to database clob containing script
  procedure export_all(script out nocopy clob);

  -- Generate a script of API calls to recreate the contents of a catalog 
  --
  -- param catalog_id          the id of the catalog to export
  -- param script               handle to database clob containing script
  procedure export_catalog(catalog_id number, script out nocopy clob);
end;
.
/
