--
-- $Header: onephie.pls 27-apr-2000.11:20:54 dthompso Exp $
--
-- onephie.pls
--
-- Copyright (c) Oracle Corporation 2000. All Rights Reserved.
--
--   NAME
--     onephie.pls - cwm$olap$hierarchy
--
--   DESCRIPTION
--     Extended metadata properties for dimension hierarchies
--
--   RETURNS
--
--   NOTES
--     
--
--   MODIFIED   (MM/DD/YY)
--   dthompso    04/27/00 - Initial Version
--   dthompso    01/00/00 - Creation
--


create or replace package cwm$olap$hierarchy as
 
  -- set display name for hierarchy.
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param hierarchy_name        name of the hierarchy within the dimension
  -- param display_name          new display name for the hierarchy
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise hierarchy_not_found   if hierarchy doesn't exist
  procedure set_display_name(owner varchar2
                            ,dimension_name varchar2
                            ,hierarchy_name varchar2
                            ,display_name varchar2);

  -- set descriptive text for hierarchy.
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param hierarchy_name        name of the hierarchy within the dimension
  -- param description           new description for the hierarchy
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise hierarchy_not_found   if hierarchy doesn't exist
  procedure set_description(owner varchar2
                           ,dimension_name varchar2
                           ,hierarchy_name varchar2
                           ,description varchar2);

  -- Lock the dimension hierarchy
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param hierarchy_name        name of the hierarchy within the dimension
  -- param wait_for_lock         wait for lock if acquired by other user
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise hierarchy_not_found   if hierarchy doesn't exist
  -- raise failed_to_gain_lock   if lock could not be acquired
  procedure lock_hierarchy(owner varchar2
                         , dimension_name varchar2
                         , hierarchy_name varchar2
                         , wait_for_lock boolean := false);
                                   
  -- internal function to return the internal id of the cwm hierarchy object
  -- creating it if it does not already exist.
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param hierarchy_name        name of the hierarchy within the dimension
  --
  -- raise hierarchy_not_found   if hierarchy doesn't exist  
  function get_hierarchy_id(owner varchar2
                          , dimension_name varchar2
                          , hierarchy_name varchar2) return number;
end;
/
