--
-- $Header: oneplat.pls 30-may-2000.16:01:59 dthompso Exp $
--
-- oneplat.pls
--
-- Copyright (c) Oracle Corporation 2000. All Rights Reserved.
--
--   NAME
--     oneplat.pls - cwm$olap$level$attribute
--
--   DESCRIPTION
--     Extended metadata properties for attributes of dimension levels
--
--   RETURNS
--
--   NOTES
--     
--
--   MODIFIED   (MM/DD/YY)
--   dthompso    05/30/00 - Correct Exceptions raised
--   dthompso    05/03/00 - Level attributes must be qualified by level name
--   dthompso    04/27/00 - Initial Version
--   dthompso    01/00/00 - Creation
--

create or replace package cwm$olap$level$attribute as
 
  -- Set the name of a level attribute
  --
  -- param owner                     dimension owner
  -- param dimension_name            name of dimension containing level
  -- param level_name                name of level defining attribute
  -- param attribute_column          column of level attribute
  -- param attribute_name            name to set for the level attribute
  --
  -- raise no_access_privileges      if no privileges to edit the dimension
  -- raise attribute_not_found       if attribute doesn't exist
  -- raise invalid_name              if name is not valid
  procedure set_name(owner varchar2
                   , dimension_name varchar2
                   , level_name varchar2
                   , attribute_column varchar2
                   , attribute_name varchar2);

  -- Set description text for a level attribute
  --
  -- param owner                dimension owner
  -- param dimension_name       name of dimension containing level
  -- param level_name                name of level defining attribute
  -- param attribute_name       name of level attribute
  -- param description          the description text to be set
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise attribute_not_found   if attribute doesn't exist
  procedure set_description(owner varchar2
                          , dimension_name varchar2
                          , level_name varchar2
                          , attribute_name varchar2
                          , description varchar2);
 
  -- Set the display name for a level attribute
  --
  -- param owner                dimension owner
  -- param dimension_name       name of dimension containing level
  -- param level_name                name of level defining attribute
  -- param attribute_name       name of level attribute
  -- param display_name         the display name for the attribute
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise attribute_not_found   if attribute doesn't exist
  procedure set_display_name(owner varchar2
                           , dimension_name varchar2
                           , level_name varchar2
                           , attribute_name varchar2
                           , display_name varchar2);

  -- Lock the level attribute
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param level_name                name of level defining attribute
  -- param attribute_name       name of level attribute
  -- param wait_for_lock         wait for lock if acquired by other user
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise attribute_not_found   if attribute doesn't exist
  -- raise failed_to_gain_lock   if lock could not be acquired
  procedure lock_attribute(owner varchar2
                         , dimension_name varchar2
                         , level_name varchar2
                         , attribute_name varchar2
                         , wait_for_lock boolean := false);


  -- PRIVATE function to get internal id of the level attribute
  function get_attribute_id(owner varchar2
                          , dimension_name varchar2
                          , level_name varchar2
                          , attribute_name varchar2) return number;               
end;
/
