--
-- $Header: oneplev.pls 27-apr-2000.11:20:57 dthompso Exp $
--
-- oneplev.pls
--
-- Copyright (c) Oracle Corporation  2000. All Rights Reserved.
--
--   NAME
--     oneplev.pls - cwm$olap$level
--
--   DESCRIPTION
--     Extended metadata properties for dimension levels
--
--   RETURNS
--
--   NOTES
--     
--
--   MODIFIED   (MM/DD/YY)
--   dthompso    04/27/00 - Initial Version
--   dthompso    01/00/00 - Creation
--


create or replace package cwm$olap$level as
 

  -- Set description for a level
  --
  -- param dimension_owner        owner of the dimension
  -- param dimension_name         name of the dimension
  -- param level_name             name of the level
  -- param description            description text for the measure
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise dimension_not_found    if the dimension does not exist in catalog
  -- raise level_not_found        if the level cannot be found within dimension
  procedure set_description(dimension_owner            varchar2
                           ,dimension_name   varchar2
                           ,level_name       varchar2
                           ,description      varchar2);

  -- Set display name for a level
  --
  -- param dimension_owner        owner of the dimension
  -- param dimension_name         name of the dimension
  -- param level_name             name of the level
  -- param display_name           display name for the measure
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise dimension_not_found    if the dimension does not exist in catalog
  -- raise level_not_found        if the level cannot be found within dimension
  procedure set_display_name(dimension_owner            varchar2
                            ,dimension_name   varchar2
                            ,level_name       varchar2
                            ,display_name     varchar2);

  -- Lock the level 
  --
  -- param owner                 owner of the dimension
  -- param dimension_name        name of the dimension
  -- param level_name            name of level 
  -- param wait_for_lock         wait for lock if acquired by other user
  --
  -- raise no_access_privileges  if no privileges to edit the dimension
  -- raise level_not_found   if attribute doesn't exist
  -- raise failed_to_gain_lock   if lock could not be acquired
  procedure lock_level(owner varchar2
                     , dimension_name varchar2
                     , level_name varchar2
                     , wait_for_lock boolean := false);


  -- PRIVATE function to get internal id of the level 
  function get_level_id(owner varchar2
                      , dimension_name varchar2
                      , level_name varchar2) return number;    
                     
end;
/
