--
-- $Header: onepxcpn.pls 23-dec-2002.13:00:53 dbardwel Exp $
--
-- onepxcpn.pls
--
-- Copyright (c) Oracle Corporation 1900, 2000. All Rights Reserved.
--
--   NAME
--     onepxcpn.pls - cwm$exceptions
--
--   DESCRIPTION
--     All exceptions raised by API methods.
--
--   RETURNS
--
--   NOTES
--    
--
--   MODIFIED   (MM/DD/YY)
--   dbardwel    12/23/02 - fix multiple occurances of descriptor_undefined 
--   dthompso    06/01/00 - add duplicate_instance.
--   dthompso    05/24/00 - Add cannot_override_fact_mappings.
--   dthompso    04/27/00 - Initial Version
--   dthompso    01/00/00 - Creation
--


create or replace package cwm$exceptions as

-- the function with this name cannot be found
function_not_found EXCEPTION;
-- the function with this usage id cannot be found
function_usage_not_found EXCEPTION;
-- the parameter with this name cannot be found
parameter_not_found EXCEPTION;
-- cube with this name does not exist in the database
cube_not_found EXCEPTION;
-- dimension with this name does not exist in the database
dimension_not_found EXCEPTION;
-- level with this name does not exist for this dimension in the database
level_not_found EXCEPTION;
-- hierarchy with this name does not exist for this dimension in the database
hierarchy_not_found EXCEPTION;
-- attribute with this name does not exist for this dimension in the database
attribute_not_found EXCEPTION;
-- the entity cannot be found in the database
entity_not_found EXCEPTION;
-- the table cannot be found in the database
table_not_found EXCEPTION;
-- the schema(user) does not exist in the database
schema_not_found EXCEPTION;
-- the descriptor identifier does not exist in the database
descriptor_undefined EXCEPTION;
-- the catalog identifier does not exist in the database
catalog_not_found EXCEPTION;
-- the parent catalog identifier does not exist in the database
parent_catalog_not_found EXCEPTION;
-- the element does not exist in catalog
element_does_not_exist EXCEPTION;
-- a descriptor type with that name not found
descriptor_type_not_found EXCEPTION;
-- a descriptor with this value already exists
descriptor_with_value_exists EXCEPTION;
-- fact table not defined for cube
fact_table_not_defined EXCEPTION;
-- column not found in fact table
column_not_found EXCEPTION;
-- measure with the same name is not found in the cube
measure_not_found EXCEPTION;
-- foreign key cannot be found for fact table
foreign_key_not_found EXCEPTION;
-- No column map exists for that column
column_map_not_found EXCEPTION;
-- the descriptor is undefined check list of valid descriptors
-- descriptor_undefined EXCEPTION;
-- name cannot be null or empty string ''
invalid_name EXCEPTION;
-- only COLUMN supported, invalid object type
invalid_object_type EXCEPTION;
-- The use between a dimension attribute and level attribute does not exist
attribute_use_not_found EXCEPTION;
-- the cube already exists, cannot create duplicate with same name
cube_already_exists EXCEPTION;
-- the attribute already exists, cannot create duplicate with same name
attribute_already_exists EXCEPTION;
attcol_map_cannot_be_changed EXCEPTION;
-- the measure already exists, cannot create duplicate with same name
measure_already_exists EXCEPTION;
-- the dimension cannot be added again to code use alias to ensure uniqueness
dimension_already_exist EXCEPTION;
-- a catalog with this name already exists in database
catalog_already_exists EXCEPTION;
-- cube is already defined in this catalog
element_already_exists EXCEPTION;
-- a descriptor type with the same name already exists
descriptor_type_already_exists EXCEPTION;
-- the method is not a recognized aggregation method
invalid_aggregation_method EXCEPTION;
-- drop the child catalogs first, or use cascade parameter
catalog_has_sub_catalogs EXCEPTION;
-- a recursive dependency would be created, this is not allowed
circular_dependency EXCEPTION;
-- entity type is not within the types supported for this release
entity_type_not_allowed EXCEPTION;
export_not_allowed EXCEPTION;
rebuild_failed EXCEPTION;
--
must_issue_ddl_to_change EXCEPTION;

-- the descriptor type is currently in use elsewhere
descriptor_type_in_use EXCEPTION;

-- user has no access privileges to perform the operation
no_access_privileges EXCEPTION;
-- username does not exist in database
user_not_found EXCEPTION;
-- dimension alias within cube dimension use is not unique
alias_not_unique EXCEPTION;
-- multiple uses of the same dimension exist within the cube and the 
-- alias must be specified to qualify the particular use for the operation
multiple_uses_exist EXCEPTION;
-- A dependent cube dimension use must be defined within the same cube
use_not_in_same_cube EXCEPTION;
-- The dimension use within the cube specified does not exist
dimension_usage_not_found EXCEPTION;
-- feature not yet supported
unsupported_feature EXCEPTION;
-- the project cannot be found, this is bootstrap data
project_not_found EXCEPTION;
-- Failed to gain lock on metadata
failed_to_gain_lock EXCEPTION;
-- Cube is already mapped to a fact table but this operation tried to map
-- to a different fact table.
cannot_override_fact_mappings EXCEPTION;
-- OLAP instance has already been added to list
duplicate_instance EXCEPTION;
end;
/
