Rem
Rem $Header: onetabs.sql 22-jun-2000.11:53:25 dthompso Exp $
Rem
Rem onetabs.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      onetabs.sql
Rem
Rem    DESCRIPTION
Rem      Create metadata tables and indexs.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dthompso    06/22/00 - Add cwm$classificationentry.tertiary_object_name.
Rem    dthompso    05/05/00 - Correct LevelAttribute FK
Rem    dthompso    04/27/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE TABLE CWM$HIERARCHY
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,DISPLAYNAME VARCHAR2(240)
 ,DIMENSION_IRID_1 NUMBER(38)
 ,DIMENSION_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$DIMENSIONATTRIBUTE
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,PHYSICALNAME VARCHAR2(240)
 ,TYPE_IRID NUMBER(38)
 ,PRECISION NUMBER
 ,COMPLEXITEM_IRID NUMBER(38)
 ,ISUNIQUE VARCHAR2(1)
 ,ISMANDATORY VARCHAR2(1)
 ,SCALE NUMBER
 ,LENGTH NUMBER
 ,PICTURE VARCHAR2(240)
 ,DISPLAYNAME VARCHAR2(240)
 ,ITEMCONTAINER_IRID NUMBER(38) NOT NULL
 ,LOOKUPDOMAIN_IRID NUMBER(38)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,HASITEM_FK_SEQ NUMBER(28,10)
 ,ITEMCONTAINER_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$FUNCTION
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,PROCESSMODEL_IRID NUMBER(38)
 ,TYPE_IRID NUMBER(38)
 ,PRECEDENCE NUMBER DEFAULT 1
 ,SYMBOL VARCHAR2(240)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$FACTUSE
 (OBJECT_OWNER VARCHAR2(30)
 ,IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,TYPE_IRID NUMBER(38)
 ,NODE_IRID_1 NUMBER(38)
 ,NODE_IRID NUMBER(38)
 ,COMPLEXITEM_IRID NUMBER(38)
 ,SCRIPT VARCHAR2(240)
 ,ARGUMENT_IRID NUMBER(38)
 ,FUNCTIONIMPLEMENTATION_IRID NUMBER(38)
 ,GENERATEDOBJECT_IRID NUMBER(38)
 ,MAP_IRID NUMBER(38)
 ,OPERATION_IRID NUMBER(38)
 ,OPERATION_IRID_1 NUMBER(38)
 ,MAPPABLE_IRID NUMBER(38)
 ,MODELUSE_IRID NUMBER(38)
 ,PREDICATEEXPRESSION_IRID NUMBER(38)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,FUNCTIONIMPLEMENTATION_FK_SEQ NUMBER(28,10)
 ,GENERATEDOBJECT_FK_SEQ NUMBER(28,10)
 ,INPUT_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,MAP_FK_SEQ NUMBER(28,10)
 ,NOTM NUMBER(38)
 ,OUTPUT_FK_SEQ NUMBER(28,10)
 ,OBJECT_NAME VARCHAR2(30)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 ,SECONDARY_OBJECT_NAME VARCHAR2(30)
 )
/

CREATE TABLE CWM$DOMAIN
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,TYPE_IRID NUMBER(38)
 ,MAXIMUMPRECISION NUMBER
 ,AVERAGEPRECISION NUMBER
 ,SCALE NUMBER
 ,AVERAGELENGTH NUMBER
 ,MAXIMUMLENGTH NUMBER
 ,DEFINITIONMODEL_IRID NUMBER(38) NOT NULL
 ,ITEM_IRID_1 NUMBER(38)
 ,ITEM_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$ARGUMENT
 (IRID NUMBER(38) NOT NULL
 ,FUNCTIONUSE_IRID NUMBER(38) NOT NULL
 ,PARAMETER_IRID NUMBER(38)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,HASARGUMENT_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 ,ELEMENT_IRID NUMBER NOT NULL
 ,OBJECT_OWNER VARCHAR2(30) NOT NULL
 ,OBJECT_NAME VARCHAR2(30) NOT NULL
 ,SECONDARY_OBJECT_NAME VARCHAR2(30)
 )
/

CREATE TABLE CWM$MEASURE
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,PHYSICALNAME VARCHAR2(240)
 ,TYPE_IRID NUMBER(38)
 ,PRECISION NUMBER
 ,COMPLEXITEM_IRID NUMBER(38)
 ,ISUNIQUE VARCHAR2(1)
 ,ISMANDATORY VARCHAR2(1)
 ,SCALE NUMBER
 ,LENGTH NUMBER
 ,PICTURE VARCHAR2(240)
 ,DISPLAYNAME VARCHAR2(240)
 ,ITEMCONTAINER_IRID NUMBER(38) NOT NULL
 ,LOOKUPDOMAIN_IRID NUMBER(38)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,HASITEM_FK_SEQ NUMBER(28,10)
 ,ITEMCONTAINER_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$CLASSIFICATIONTYPE
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,PROJECT_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$PARAMETER
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,PHYSICALNAME VARCHAR2(240)
 ,TYPE_IRID NUMBER(38)
 ,PRECISION NUMBER
 ,COMPLEXITEM_IRID NUMBER(38)
 ,ISUNIQUE VARCHAR2(1)
 ,ISMANDATORY VARCHAR2(1)
 ,SCALE NUMBER
 ,LENGTH NUMBER
 ,PICTURE VARCHAR2(240)
 ,DISPLAYNAME VARCHAR2(240)
 ,ITEMCONTAINER_IRID NUMBER(38)
 ,LOOKUPDOMAIN_IRID NUMBER(38)
 ,OCCURS NUMBER
 ,OPERATION_IRID NUMBER(38)
 ,OPERATION_IRID_1 NUMBER(38)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,HASITEM_FK_SEQ NUMBER(28,10)
 ,INPUT_FK_SEQ NUMBER(28,10)
 ,ITEMCONTAINER_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,OUTPUT_FK_SEQ NUMBER(28,10)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$CUBE
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,DISPLAYNAME VARCHAR2(240)
 ,DATAMODEL_IRID NUMBER(38) NOT NULL
 ,PHYSICALNAME VARCHAR2(240)
 ,ISDEPLOYABLE VARCHAR2(1)
 ,ISREADONLY VARCHAR2(1)
 ,FACTTABLEMAP_IRID NUMBER(38)
 ,DATAMODEL_FK_SEQ NUMBER(28,10)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$LEVEL
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,DISPLAYNAME VARCHAR2(240)
 ,DATAMODEL_IRID NUMBER(38) NOT NULL
 ,PHYSICALNAME VARCHAR2(240)
 ,ISDEPLOYABLE VARCHAR2(1)
 ,ISREADONLY VARCHAR2(1)
 ,DIMENSION_IRID NUMBER(38) NOT NULL
 ,DATAMODEL_FK_SEQ NUMBER(28,10)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,DIMENSION_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$CUBEDIMENSIONUSE
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,CUBEDIMENSIONUSE_IRID NUMBER(38)
 ,HIERARCHY_IRID NUMBER(38)
 ,CUBE_IRID NUMBER(38) NOT NULL
 ,ABSTRACTDIMENSION_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,DIMENSION_OWNER VARCHAR2(30) NOT NULL
 ,DIMENSION_NAME VARCHAR2(30) NOT NULL
 ,CALC_HIERARCHY_NAME VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$FUNCTIONUSE
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,TYPE_IRID NUMBER(38)
 ,NODE_IRID_1 NUMBER(38)
 ,NODE_IRID NUMBER(38)
 ,COMPLEXITEM_IRID NUMBER(38)
 ,SCRIPT VARCHAR2(240)
 ,ARGUMENT_IRID NUMBER(38)
 ,FUNCTIONIMPLEMENTATION_IRID NUMBER(38)
 ,GENERATEDOBJECT_IRID NUMBER(38)
 ,MAP_IRID NUMBER(38)
 ,OPERATION_IRID NUMBER(38)
 ,OPERATION_IRID_1 NUMBER(38)
 ,MAPPABLE_IRID NUMBER(38)
 ,FUNCTION_IRID NUMBER(38) NOT NULL
 ,MEASUREDIMENSIONUSE_IRID NUMBER(38)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,FUNCTIONIMPLEMENTATION_FK_SEQ NUMBER(28,10)
 ,GENERATEDOBJECT_FK_SEQ NUMBER(28,10)
 ,INPUT_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,MAP_FK_SEQ NUMBER(28,10)
 ,NOTM NUMBER(38)
 ,OUTPUT_FK_SEQ NUMBER(28,10)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$CLASSIFICATIONENTRY
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,OBJECT_NAME VARCHAR2(30)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,ELEMENT_IRID NUMBER(38) NOT NULL
 ,CLASSIFICATION_IRID NUMBER(38) NOT NULL
 ,CONTAINSENTRY_FK_SEQ NUMBER(28,10)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 ,SECONDARY_OBJECT_NAME VARCHAR2(30)
 ,OBJECT_OWNER VARCHAR2(30)
 ,tertiary_object_name VARCHAR2(30) 
 )
/

CREATE TABLE CWM$ITEMUSE
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,TYPE_IRID NUMBER(38)
 ,NODE_IRID_1 NUMBER(38)
 ,NODE_IRID NUMBER(38)
 ,COMPLEXITEM_IRID NUMBER(38)
 ,SCRIPT VARCHAR2(240)
 ,ARGUMENT_IRID NUMBER(38)
 ,FUNCTIONIMPLEMENTATION_IRID NUMBER(38)
 ,GENERATEDOBJECT_IRID NUMBER(38)
 ,MAP_IRID NUMBER(38)
 ,OPERATION_IRID NUMBER(38)
 ,OPERATION_IRID_1 NUMBER(38)
 ,MAPPABLE_IRID NUMBER(38)
 ,ENTITYUSE_IRID NUMBER(38)
 ,ITEMUSE_IRID NUMBER(38)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,FUNCTIONIMPLEMENTATION_FK_SEQ NUMBER(28,10)
 ,GENERATEDOBJECT_FK_SEQ NUMBER(28,10)
 ,INPUT_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,MAP_FK_SEQ NUMBER(28,10)
 ,NOTM NUMBER(38)
 ,OUTPUT_FK_SEQ NUMBER(28,10)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 ,OBJECT_OWNER VARCHAR2(30)
 ,OBJECT_NAME VARCHAR2(30)
 ,SECONDARY_OBJECT_NAME VARCHAR2(30)
 )
/

CREATE TABLE CWM$PROJECT
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$CLASSIFICATION
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,PROJECT_IRID NUMBER(38) NOT NULL
 ,PHYSICALNAME VARCHAR2(240)
 ,ELEMENT_IRID NUMBER(38)
 ,CLASSIFICATIONTYPE_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$FACTTABLEMAP
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,MAPCONTAINER_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,MAPCONTAINER_FK_SEQ NUMBER(28,10)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$MEASUREDIMENSIONUSE
 (IRID NUMBER(38) NOT NULL
 ,MEASURE_IRID NUMBER(38) NOT NULL
 ,CUBEDIMENSIONUSE_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 ,DIMENSION_OWNER VARCHAR2(30) NOT NULL
 ,DIMENSION_NAME VARCHAR2(30) NOT NULL
 )
/

CREATE TABLE CWM$FACTLEVELGROUP
 (IRID NUMBER(38) NOT NULL
 ,FACTUSE_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$MODEL
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,PROJECT_IRID NUMBER(38) NOT NULL
 ,MODEL_IRID NUMBER(38)
 ,PHYSICALNAME VARCHAR2(240)
 ,DEFAULTSCHEMANAME VARCHAR2(240)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$LEVELATTRIBUTE
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,PHYSICALNAME VARCHAR2(240)
 ,TYPE_IRID NUMBER(38)
 ,PRECISION NUMBER
 ,COMPLEXITEM_IRID NUMBER(38)
 ,ISUNIQUE VARCHAR2(1)
 ,ISMANDATORY VARCHAR2(1)
 ,SCALE NUMBER
 ,LENGTH NUMBER
 ,PICTURE VARCHAR2(240)
 ,DISPLAYNAME VARCHAR2(240)
 ,ITEMCONTAINER_IRID NUMBER(38)
 ,LOOKUPDOMAIN_IRID NUMBER(38)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,HASITEM_FK_SEQ NUMBER(28,10)
 ,ITEMCONTAINER_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

CREATE TABLE CWM$FACTLEVELUSE
 (IRID NUMBER(38) NOT NULL
 ,FACTLEVELGROUP_IRID NUMBER(38) NOT NULL
 ,LEVEL_IRID NUMBER(38) NOT NULL
 ,FOREIGNKEY_IRID NUMBER(38) NOT NULL
 ,CUBEDIMENSIONUSE_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 ,DIMENSION_OWNER VARCHAR2(30) NOT NULL
 ,DIMENSION_NAME VARCHAR2(30) NOT NULL
 ,LEVEL_NAME VARCHAR2(30) NOT NULL
 ,FOREIGN_KEY_OWNER VARCHAR2(30) NOT NULL
 ,FOREIGN_KEY_NAME VARCHAR2(30) NOT NULL
 )
/

CREATE TABLE CWM$DIMENSION
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,DISPLAYNAME VARCHAR2(240)
 ,DATAMODEL_IRID NUMBER(38) NOT NULL
 ,PHYSICALNAME VARCHAR2(240)
 ,ISDEPLOYABLE VARCHAR2(1)
 ,ISREADONLY VARCHAR2(1)
 ,DIMENSIONTABLEMAP_IRID NUMBER(38)
 ,PLURALNAME VARCHAR2(240)
 ,DATAMODEL_FK_SEQ NUMBER(28,10)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 ,DISPLAY_HIERARCHY_NAME VARCHAR2(30)
 )
/

CREATE TABLE CWM$OBJECTTYPE
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,PROJECT_IRID NUMBER(38) NOT NULL
 ,CONFIGURATIONTEMPLATESET_IRID NUMBER(38)
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 ,CLASSIFICATIONTYPE_IRID NUMBER(38)
 )
/

CREATE TABLE CWM$ITEMMAP
 (IRID NUMBER(38) NOT NULL
 ,NAME VARCHAR2(240)
 ,SHORTDESCRIPTION VARCHAR2(240)
 ,DESCRIPTION VARCHAR2(4000)
 ,CREATEDBY VARCHAR2(240)
 ,CREATEDON DATE
 ,LASTMODIFIEDBY VARCHAR2(240)
 ,LASTMODIFIEDON DATE
 ,ENTITYMAP_IRID NUMBER(38) NOT NULL
 ,DATE_CHANGED DATE
 ,DATE_CREATED DATE
 ,ENTITYMAP_FK_SEQ NUMBER(28,10)
 ,IVID NUMBER(38)
 ,NOTM NUMBER(38)
 ,TYPES NUMBER(38)
 ,USER_CHANGED_BY VARCHAR2(30)
 ,USER_CREATED_BY VARCHAR2(30)
 )
/

ALTER TABLE CWM$HIERARCHY
 ADD (CONSTRAINT CWM$HIERARCHY_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$DIMENSIONATTRIBUTE
 ADD (CONSTRAINT CWM$DIMENSIONATTRIBUTE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$FUNCTION
 ADD (CONSTRAINT CWM$FUNCTION_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$FACTUSE
 ADD (CONSTRAINT CWM$FACTUSE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$DOMAIN
 ADD (CONSTRAINT CWM$DOMAIN_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$ARGUMENT
 ADD (CONSTRAINT CWM$ARGUMENT_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$MEASURE
 ADD (CONSTRAINT CWM$MEASURE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$CLASSIFICATIONTYPE
 ADD (CONSTRAINT CWM$CLASSIFICATIONTYPE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$PARAMETER
 ADD (CONSTRAINT CWM$PARAMETER_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$CUBE
 ADD (CONSTRAINT CWM$CUBE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$LEVEL
 ADD (CONSTRAINT CWM$LEVEL_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$CUBEDIMENSIONUSE
 ADD (CONSTRAINT CWM$CUBEDIMENSIONUSE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$FUNCTIONUSE
 ADD (CONSTRAINT CWM$FUNCTIONUSE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$CLASSIFICATIONENTRY
 ADD (CONSTRAINT CWM$CLASSIFICATIONENTRY_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$ITEMUSE
 ADD (CONSTRAINT CWM$ITEMUSE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$PROJECT
 ADD (CONSTRAINT CWM$PROJECT_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$CLASSIFICATION
 ADD (CONSTRAINT CWM$CLASSIFICATION_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$FACTTABLEMAP
 ADD (CONSTRAINT CWM$FACTTABLEMAP_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$MEASUREDIMENSIONUSE
 ADD (CONSTRAINT CWM$MEASUREDIMENSIONUSE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$FACTLEVELGROUP
 ADD (CONSTRAINT CWM$FACTLEVELGROUP_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$MODEL
 ADD (CONSTRAINT CWM$MODEL_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$LEVELATTRIBUTE
 ADD (CONSTRAINT CWM$LEVELATTRIBUTE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$FACTLEVELUSE
 ADD (CONSTRAINT CWM$FACTLEVELUSE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$DIMENSION
 ADD (CONSTRAINT CWM$DIMENSION_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$OBJECTTYPE
 ADD (CONSTRAINT CWM$OBJECTTYPE_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$ITEMMAP
 ADD (CONSTRAINT CWM$ITEMMAP_PK PRIMARY KEY 
  (IRID))
/

ALTER TABLE CWM$HIERARCHY 
 ADD ( CONSTRAINT CWM$HIERARCHY_UK UNIQUE 
  (NAME
  ,DIMENSION_IRID))
/

ALTER TABLE CWM$DIMENSIONATTRIBUTE 
 ADD ( CONSTRAINT CWM$DIMENSIONATTRIBUTE_UK UNIQUE 
  (PHYSICALNAME
  ,ITEMCONTAINER_IRID))
/

ALTER TABLE CWM$DOMAIN 
 ADD ( CONSTRAINT CWM$DOMAIN_UK UNIQUE 
  (NAME
  ,DEFINITIONMODEL_IRID)
  DISABLE)
/

ALTER TABLE CWM$MEASURE 
 ADD ( CONSTRAINT CWM$MEASURE_UK UNIQUE 
  (ITEMCONTAINER_IRID
  ,PHYSICALNAME))
/

ALTER TABLE CWM$PARAMETER 
 ADD ( CONSTRAINT CWM$PARAMETER_UK UNIQUE 
  (NAME
  ,OPERATION_IRID))
/

ALTER TABLE CWM$CUBE 
 ADD ( CONSTRAINT CWM$CUBE_UK UNIQUE 
  (PHYSICALNAME
  ,DATAMODEL_IRID))
/

ALTER TABLE CWM$LEVEL 
 ADD ( CONSTRAINT CWM$LEVEL_UK UNIQUE 
  (PHYSICALNAME
  ,DIMENSION_IRID))
/

ALTER TABLE CWM$PROJECT 
 ADD ( CONSTRAINT CWM$PROJECT_UK UNIQUE 
  (NAME))
/

ALTER TABLE CWM$CLASSIFICATION 
 ADD ( CONSTRAINT CWM$CLASSIFICATION_UK UNIQUE 
  (NAME
  ,PROJECT_IRID))
/

ALTER TABLE CWM$MODEL 
 ADD ( CONSTRAINT CWM$MODEL_UK UNIQUE 
  (PHYSICALNAME
  ,PROJECT_IRID))
/

ALTER TABLE CWM$LEVELATTRIBUTE 
 ADD ( CONSTRAINT CWM$LEVELATTRIBUTE_UK UNIQUE 
  (ITEMCONTAINER_IRID
  ,PHYSICALNAME))
/

ALTER TABLE CWM$DIMENSION 
 ADD ( CONSTRAINT CWM$DIMENSION_UK UNIQUE 
  (PHYSICALNAME
  ,DATAMODEL_IRID))
/
  
ALTER TABLE CWM$DIMENSIONATTRIBUTE
 ADD (CONSTRAINT AVCON_603194_ISUNI_000 CHECK (ISUNIQUE IN ('Y', 'N')))
 ADD (CONSTRAINT AVCON_603194_ISMAN_000 CHECK (ISMANDATORY IN ('Y', 'N')))
/
     
ALTER TABLE CWM$MEASURE
 ADD (CONSTRAINT AVCON_602686_ISUNI_000 CHECK (ISUNIQUE IN ('Y', 'N')))
 ADD (CONSTRAINT AVCON_602686_ISMAN_000 CHECK (ISMANDATORY IN ('Y', 'N')))
/
  
ALTER TABLE CWM$PARAMETER
 ADD (CONSTRAINT AVCON_603014_ISUNI_000 CHECK (ISUNIQUE IN ('Y', 'N')))
 ADD (CONSTRAINT AVCON_603014_ISMAN_000 CHECK (ISMANDATORY IN ('Y', 'N')))
/
 
ALTER TABLE CWM$CUBE
 ADD (CONSTRAINT AVCON_603132_ISDEP_000 CHECK (ISDEPLOYABLE IN ('Y', 'N')))
 ADD (CONSTRAINT AVCON_603132_ISREA_000 CHECK (ISREADONLY IN ('Y', 'N')))
/
 
ALTER TABLE CWM$LEVEL
 ADD (CONSTRAINT AVCON_602945_ISDEP_000 CHECK (ISDEPLOYABLE IN ('Y', 'N')))
 ADD (CONSTRAINT AVCON_602945_ISREA_000 CHECK (ISREADONLY IN ('Y', 'N')))
/
           
ALTER TABLE CWM$LEVELATTRIBUTE
 ADD (CONSTRAINT AVCON_603189_ISUNI_000 CHECK (ISUNIQUE IN ('Y', 'N')))
 ADD (CONSTRAINT AVCON_603189_ISMAN_000 CHECK (ISMANDATORY IN ('Y', 'N')))
/
  
ALTER TABLE CWM$DIMENSION
 ADD (CONSTRAINT AVCON_603122_ISDEP_000 CHECK (ISDEPLOYABLE IN ('Y', 'N')))
 ADD (CONSTRAINT AVCON_603122_ISREA_000 CHECK (ISREADONLY IN ('Y', 'N')))
/
  
ALTER TABLE CWM$HIERARCHY ADD CONSTRAINT
 CWM$HIERARCHY_FK FOREIGN KEY 
  (DIMENSION_IRID) REFERENCES CWM$DIMENSION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$DIMENSIONATTRIBUTE ADD CONSTRAINT
 CWM$DIMENSIONATTRIBUTE_FK FOREIGN KEY 
  (ITEMCONTAINER_IRID) REFERENCES CWM$DIMENSION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$FUNCTION ADD CONSTRAINT
 CWM$FUNCTION_FK FOREIGN KEY 
  (PROCESSMODEL_IRID) REFERENCES CWM$MODEL
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$FACTUSE ADD CONSTRAINT
 CWM$FACTUSE_FK FOREIGN KEY 
  (OPERATION_IRID) REFERENCES CWM$FACTTABLEMAP
  (IRID) ON DELETE CASCADE ADD CONSTRAINT
 CWM$FACTUSE_FK_1 FOREIGN KEY 
  (OPERATION_IRID_1) REFERENCES CWM$FACTTABLEMAP
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$DOMAIN ADD CONSTRAINT
 CWM$DOMAIN_FK FOREIGN KEY 
  (DEFINITIONMODEL_IRID) REFERENCES CWM$MODEL
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$ARGUMENT ADD CONSTRAINT
 CWM$ARGUMENT_FK FOREIGN KEY 
  (PARAMETER_IRID) REFERENCES CWM$PARAMETER
  (IRID) ADD CONSTRAINT
 CWM$ARGUMENT_FK_1 FOREIGN KEY 
  (FUNCTIONUSE_IRID) REFERENCES CWM$FUNCTIONUSE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$MEASURE ADD CONSTRAINT
 CWM$MEASURE_FK FOREIGN KEY 
  (ITEMCONTAINER_IRID) REFERENCES CWM$CUBE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$CLASSIFICATIONTYPE ADD CONSTRAINT
 CWM$CLASSIFICATIONTYPE_FK FOREIGN KEY 
  (PROJECT_IRID) REFERENCES CWM$PROJECT
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$PARAMETER ADD CONSTRAINT
 CWM$PARAMETER_FK FOREIGN KEY 
  (OPERATION_IRID) REFERENCES CWM$FUNCTION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$CUBE ADD CONSTRAINT
 CWM$CUBE_FK FOREIGN KEY 
  (DATAMODEL_IRID) REFERENCES CWM$MODEL
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$LEVEL ADD CONSTRAINT
 CWM$LEVEL_FK FOREIGN KEY 
  (DIMENSION_IRID) REFERENCES CWM$DIMENSION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$CUBEDIMENSIONUSE ADD CONSTRAINT
 CWM$CUBEDIMENSIONUSE_FK_1 FOREIGN KEY 
  (CUBEDIMENSIONUSE_IRID) REFERENCES CWM$CUBEDIMENSIONUSE
  (IRID) ADD CONSTRAINT
 CWM$CUBEDIMENSIONUSE_FK FOREIGN KEY 
  (CUBE_IRID) REFERENCES CWM$CUBE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$FUNCTIONUSE ADD CONSTRAINT
 CWM$FUNCTIONUSE_FK_1 FOREIGN KEY 
  (FUNCTION_IRID) REFERENCES CWM$FUNCTION
  (IRID) ADD CONSTRAINT
 CWM$FUNCTIONUSE_FK FOREIGN KEY 
  (MEASUREDIMENSIONUSE_IRID) REFERENCES CWM$MEASUREDIMENSIONUSE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$CLASSIFICATIONENTRY ADD CONSTRAINT
 CWM$CLASSIFICATIONENTRY_FK FOREIGN KEY 
  (CLASSIFICATION_IRID) REFERENCES CWM$CLASSIFICATION
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$ITEMUSE ADD CONSTRAINT
 CWM$ITEMUSE_FK FOREIGN KEY 
  (OPERATION_IRID) REFERENCES CWM$ITEMMAP
  (IRID) ON DELETE CASCADE ADD CONSTRAINT
 CWM$ITEMUSE_FK_1 FOREIGN KEY 
  (OPERATION_IRID_1) REFERENCES CWM$ITEMMAP
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$CLASSIFICATION ADD CONSTRAINT
 CWM$CLASSIFICATION_FK_1 FOREIGN KEY 
  (CLASSIFICATIONTYPE_IRID) REFERENCES CWM$CLASSIFICATIONTYPE
  (IRID) ADD CONSTRAINT
 CWM$CLASSIFICATION_FK FOREIGN KEY 
  (PROJECT_IRID) REFERENCES CWM$PROJECT
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$FACTTABLEMAP ADD CONSTRAINT
 CWM$FACTTABLEMAP_FK FOREIGN KEY 
  (MAPCONTAINER_IRID) REFERENCES CWM$CUBE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$MEASUREDIMENSIONUSE ADD CONSTRAINT
 CWM$MEASUREDIMENSIONUSE_FK_1 FOREIGN KEY 
  (MEASURE_IRID) REFERENCES CWM$MEASURE
  (IRID) ON DELETE CASCADE ADD CONSTRAINT
 CWM$MEASUREDIMENSIONUSE_FK FOREIGN KEY 
  (CUBEDIMENSIONUSE_IRID) REFERENCES CWM$CUBEDIMENSIONUSE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$FACTLEVELGROUP ADD CONSTRAINT
 CWM$FACTLEVELGROUP_FK FOREIGN KEY 
  (FACTUSE_IRID) REFERENCES CWM$FACTUSE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$MODEL ADD CONSTRAINT
 CWM$MODEL_FK_1 FOREIGN KEY 
  (MODEL_IRID) REFERENCES CWM$MODEL
  (IRID) ADD CONSTRAINT
 CWM$MODEL_FK FOREIGN KEY 
  (PROJECT_IRID) REFERENCES CWM$PROJECT
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$LEVELATTRIBUTE ADD CONSTRAINT
 CWM$LEVELATTRIBUTE_FK FOREIGN KEY 
  (ITEMCONTAINER_IRID) REFERENCES CWM$LEVEL
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$FACTLEVELUSE ADD CONSTRAINT
 CWM$FACTLEVELUSE_FK FOREIGN KEY 
  (FACTLEVELGROUP_IRID) REFERENCES CWM$FACTLEVELGROUP
  (IRID) ON DELETE CASCADE ADD CONSTRAINT
 CWM$FACTLEVELUSE_FK_1 FOREIGN KEY 
  (CUBEDIMENSIONUSE_IRID) REFERENCES CWM$CUBEDIMENSIONUSE
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$DIMENSION ADD CONSTRAINT
 CWM$DIMENSION_FK FOREIGN KEY 
  (DATAMODEL_IRID) REFERENCES CWM$MODEL
  (IRID) ON DELETE CASCADE
/

ALTER TABLE CWM$OBJECTTYPE ADD CONSTRAINT
 CWM$OBJECTTYPE_FK FOREIGN KEY 
  (PROJECT_IRID) REFERENCES CWM$PROJECT
  (IRID) ON DELETE CASCADE ADD CONSTRAINT
 CWM$OBJECTTYPE_FK_1 FOREIGN KEY 
  (CLASSIFICATIONTYPE_IRID) REFERENCES CWM$CLASSIFICATIONTYPE
  (IRID) ON DELETE CASCADE
/

CREATE UNIQUE INDEX CWM$FUNCTION_IDX ON CWM$FUNCTION
 (NAME)
/

CREATE INDEX CWM$FACTUSE_IDX ON CWM$FACTUSE
 (MAPPABLE_IRID)
/

CREATE INDEX CWM$FACTUSE_IDX_1 ON CWM$FACTUSE
 (OBJECT_OWNER
 ,OBJECT_NAME)
/

CREATE INDEX CWM$FACTUSE_IDX_2 ON CWM$FACTUSE
 (OPERATION_IRID)
/

CREATE INDEX CWM$FACTUSE_IDX_3 ON CWM$FACTUSE
 (OPERATION_IRID_1)
/

CREATE INDEX CWM$ARGUMENT_IDX_1 ON CWM$ARGUMENT
 (OBJECT_NAME
 ,OBJECT_OWNER
 ,SECONDARY_OBJECT_NAME)
/

CREATE INDEX CWM$ARGUMENT_IDX ON CWM$ARGUMENT
 (FUNCTIONUSE_IRID)
/

CREATE INDEX CWM$CLASSIFICATIONTYPE_IDX ON CWM$CLASSIFICATIONTYPE
 (NAME)
/

CREATE INDEX CWM$CUBEDIMENSIONUSE_IDX ON CWM$CUBEDIMENSIONUSE
 (ABSTRACTDIMENSION_IRID)
/

CREATE INDEX CWM$CUBEDIMENSIONUSE_IDX_2 ON CWM$CUBEDIMENSIONUSE
 (CUBE_IRID)
/

CREATE INDEX CWM$CUBEDIMENSIONUSE_IDX_3 ON CWM$CUBEDIMENSIONUSE
 (CUBEDIMENSIONUSE_IRID)
/

CREATE INDEX CWM$CUBEDIMENSIONUSE_IDX_1 ON CWM$CUBEDIMENSIONUSE
 (DIMENSION_OWNER
 ,DIMENSION_NAME
 ,NAME)
/

CREATE INDEX CWM$FUNCTIONUSE_IDX ON CWM$FUNCTIONUSE
 (MEASUREDIMENSIONUSE_IRID)
/

CREATE INDEX CWM$FUNCTIONUSE_IDX_1 ON CWM$FUNCTIONUSE
 (FUNCTION_IRID)
/

CREATE INDEX CWM$CLASSIFICATIONENTRY_IDX_1 ON CWM$CLASSIFICATIONENTRY
 (OBJECT_OWNER
 ,OBJECT_NAME
  ,SECONDARY_OBJECT_name
 ,tertiary_object_name)
/

CREATE INDEX CWM$CLASSIFICATIONENTRY_IDX ON CWM$CLASSIFICATIONENTRY
 (ELEMENT_IRID)
/

CREATE INDEX CWM$ITEMUSE_IDX_3 ON CWM$ITEMUSE
 (OPERATION_IRID_1)
/

CREATE INDEX CWM$ITEMUSE_IDX ON CWM$ITEMUSE
 (MAPPABLE_IRID)
/

CREATE INDEX CWM$ITEMUSE_IDX_1 ON CWM$ITEMUSE
 (OBJECT_OWNER
 ,OBJECT_NAME
 ,SECONDARY_OBJECT_NAME)
/

CREATE INDEX CWM$ITEMUSE_IDX_2 ON CWM$ITEMUSE
 (OPERATION_IRID)
/

CREATE INDEX CWM$CLASSIFICATION_IDX_1 ON CWM$CLASSIFICATION
 (CLASSIFICATIONTYPE_IRID)
/

CREATE INDEX CWM$FACTTABLEMAP_IDX ON CWM$FACTTABLEMAP
 (MAPCONTAINER_IRID)
/

CREATE INDEX CWM$MEASUREDIMENSIONUSE_IDX ON CWM$MEASUREDIMENSIONUSE
 (CUBEDIMENSIONUSE_IRID)
/

CREATE INDEX CWM$MEASUREDIMENSIONUSE_IDX_1 ON CWM$MEASUREDIMENSIONUSE
 (MEASURE_IRID)
/

CREATE INDEX CWM$FACTLEVELUSE_IDX ON CWM$FACTLEVELUSE
 (FOREIGNKEY_IRID)
/

CREATE INDEX CWM$FACTLEVELUSE_IDX_1 ON CWM$FACTLEVELUSE
 (CUBEDIMENSIONUSE_IRID)
/

CREATE INDEX CWM$FACTLEVELUSE_IDX_2 ON CWM$FACTLEVELUSE
 (LEVEL_NAME)
/

CREATE INDEX CWM$OBJECTTYPE_IDX ON CWM$OBJECTTYPE
 (NAME
 ,CLASSIFICATIONTYPE_IRID)
/

CREATE SEQUENCE OLAP_ID_SEQ
 NOMAXVALUE
 NOMINVALUE
 NOCYCLE
 NOCACHE
/
