Rem
Rem $Header: cwmlite/admin/onevadat.sql /main/3 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevadat.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000, 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      onevadat.sql - all$olap_dim_attributes
Rem
Rem    DESCRIPTION
Rem      Dimension Attributes that apply to multiple level attributes.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_dim_attributes AS SELECT 
  u.username owner
, d.name dimension_name
, att.physicalname attribute_name
, att.displayname display_name
, att.description description
FROM 
  dba_users u
, sys.obj$ d
, cwm$dimensionattribute att
WHERE u.user_id = d.owner#
AND d.type# = 43 /* DIMENSION */
AND (   cwm$util.dimension_tables_visible(d.obj#) = 'Y'
     OR EXISTS /* SELECT ANY TABLE, CREATE, ALTER, DROP ANY DIMENSION */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number IN (-47,-215,-216,-217)))
AND d.obj# = att.itemcontainer_irid
WITH READ ONLY
/
