Rem
Rem $Header: onevafnu.sql 27-feb-01.16:35:11 dthompso Exp $
Rem
Rem onevafnu.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000, 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      onevafnu.sql - all$olap_function_usages
Rem
Rem    DESCRIPTION
Rem      Use of a function as an aggregation method
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_function_usages AS SELECT 
  u.irid function_usage_id
, f.name function_name
FROM
  cwm$function f
, cwm$functionuse u
, cwm$measuredimensionuse mdu
, cwm$measure msr
WHERE f.irid = u.function_irid
AND u.measuredimensionuse_irid = mdu.irid
AND mdu.measure_irid = msr.irid
AND (    cwm$util.fact_table_visible(msr.itemcontainer_irid) = 'Y'
     OR EXISTS /* SELECT ANY TABLE */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number = -47))
UNION ALL SELECT
  u.irid function_usage_id
, f.name function_name
FROM
  cwm$function f
, cwm$functionuse u 
WHERE f.irid = u.function_irid
AND u.measuredimensionuse_irid IS NULL
WITH READ ONLY
/
