Rem
Rem $Header: cwmlite/admin/onevahlu.sql /main/3 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevahlu.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000, 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      onevahlu.sql - all$olap_dim_hier_level_uses
Rem
Rem    DESCRIPTION
Rem      Dimension Levels used within a hierarchy
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_dim_hier_level_uses AS SELECT /*+ORDERED*/
  u.username owner
, d.name dimension_name
, h.hiername hierarchy_name
, pdl.levelname parent_level_name
, cdl.levelname child_level_name
, chl.pos# position
FROM 
  dba_users u
, sys.obj$ d
, sys.hier$ h
, sys.hierlevel$ phl
, sys.hierlevel$ chl
, sys.dimlevel$ pdl
, sys.dimlevel$ cdl
WHERE u.user_id = d.owner#
AND d.type# = 43 /* DIMENSION */
AND (   cwm$util.dimension_tables_visible(d.obj#) = 'Y'
     OR EXISTS /* SELECT ANY TABLE, CREATE, ALTER, DROP ANY DIMENSION */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number IN (-47,-215,-216,-217)))
AND d.obj# = h.dimobj#
AND d.obj# = phl.dimobj#
AND h.hierid# = phl.hierid#
AND d.obj# = pdl.dimobj#
AND phl.levelid# = pdl.levelid#
AND d.obj# = chl.dimobj#
AND h.hierid# = chl.hierid#
AND chl.levelid# = cdl.levelid#
AND d.obj# = cdl.dimobj#
AND phl.pos# = chl.pos# + 1
WITH READ ONLY
/
