Rem
Rem $Header: cwmlite/admin/onevakey.sql /main/3 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevakey.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000, 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      onevakey.sql - all$olap_keys
Rem
Rem    DESCRIPTION
Rem      Physical keys, ie primary and unique.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_keys AS SELECT 
  u.username owner
, t.name table_name
, c.name key_name
, decode(bitand(cd.defer,32),32, 'Y', 'N') is_rely
FROM
  dba_users u
, sys.obj$ t
, sys.con$ c
, sys.cdef$ cd
WHERE u.user_id = t.owner#
AND t.type# IN (2,4) /* table, view */
AND t.obj# = cd.obj#
AND cd.con# = c.con#
AND cd.type# IN (2, 3) /* primary, unique */
AND (   t.owner# = UID
     OR t.obj# IN 
       (SELECT obj# FROM sys.objauth$ 
        WHERE (   grantee# = UID
               OR grantee# IN 
                 (SELECT privilege# 
                  FROM sys.sysauth$ 
                  WHERE privilege# > 0
                  START WITH grantee# = UID 
                  CONNECT BY PRIOR privilege# = grantee#)))
     OR EXISTS /* SELECT ANY TABLE */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number = -47))
WITH READ ONLY
/
