Rem
Rem $Header: cwmlite/admin/onevalev.sql /main/3 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevalev.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000, 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      onevalev.sql - all$olap_dim_levels
Rem
Rem    DESCRIPTION
Rem      Dimension Levels.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_dim_levels AS SELECT /*+ORDERED*/
  u.username owner
, d.name dimension_name
, l.levelname level_name
, lev.displayname display_name
, lev.description description
, tu.username level_table_owner
, t.name level_table_name
FROM 
  dba_users u
, sys.obj$ d
, sys.dimlevel$ l
, sys.dimlevelkey$ k
, sys.obj$ t
, dba_users tu
, cwm$level lev
WHERE u.user_id = d.owner#
AND d.type# = 43 /* DIMENSION */
AND (   cwm$util.dimension_tables_visible(d.obj#) = 'Y'
     OR EXISTS /* SELECT ANY TABLE, CREATE, ALTER, DROP ANY DIMENSION */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number IN (-47,-215,-216,-217)))
AND d.obj# = l.dimobj#
AND l.dimobj# = k.dimobj#
AND l.levelid# = k.levelid#
AND k.detailobj# = t.obj#
AND t.owner# = tu.user_id
AND k.keypos# = 1
AND l.dimobj# = lev.dimension_irid (+)
AND l.levelname = lev.physicalname (+)
WITH READ ONLY
/
