Rem
Rem $Header: cwmlite/admin/onevalkc.sql /main/3 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevalkc.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000, 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      onevalkc.sql - all$olap_level_key_column_uses
Rem
Rem    DESCRIPTION
Rem      Mapping of dimension levels to dimension table columns.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    02/27/01 - change security implementation
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW all$olap_level_key_column_uses AS SELECT /*+ORDERED*/
  u.username owner
, d.name dimension_name
, l.levelname level_name
, c.name column_name
, k.keypos# position
FROM
  dba_users u
, sys.obj$ d
, sys.dimlevel$ l
, sys.dimlevelkey$ k
, sys.col$ c
WHERE u.user_id = d.owner#
AND d.type# = 43 /* DIMENSION */
AND (   cwm$util.dimension_tables_visible(d.obj#) = 'Y'
     OR EXISTS /* SELECT ANY TABLE, CREATE, ALTER, DROP ANY DIMENSION */
       (SELECT null FROM v$enabledprivs 
        WHERE priv_number IN (-47,-215,-216,-217)))
AND d.obj# = l.dimobj#
AND l.dimobj# = k.dimobj#
AND l.levelid# = k.levelid#
AND k.detailobj# = c.obj#
AND k.col# = c.col#
WITH READ ONLY
/
