Rem
Rem $Header: cwmlite/admin/onevdcdu.sql /main/3 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevdcdu.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000, 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      onevdcdu.sql - dba$olap_cube_dim_uses
Rem
Rem    DESCRIPTION
Rem      Dimension uses within a cube.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    05/22/01 - B1771957: Should not project rows if cube owner d
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_cube_dim_uses AS SELECT 
  cdu.irid cube_dimension_use_id
, sch.physicalname owner
, cub.physicalname cube_name
, cdu.dimension_owner
, cdu.dimension_name
, cdu.name dimension_alias
, cdu.cubedimensionuse_irid dependent_on_dim_use_id
, cdu.calc_hierarchy_name default_calc_hierarchy_name
FROM
  dba_users u    
, cwm$model sch
, cwm$cube cub
, cwm$cubedimensionuse cdu
WHERE u.username = sch.physicalname
AND sch.irid = cub.datamodel_irid
AND cub.irid = cdu.cube_irid
WITH READ ONLY
/
