Rem
Rem $Header: cwmlite/admin/onevdcmm.sql /main/3 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevdcmm.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000, 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      onevdcmm.sql - dba$olap_cube_measure_maps
Rem
Rem    DESCRIPTION
Rem      Mapping of cube measures to fact table columns.
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    05/22/01 - B1771957: Should not project rows if cube owner d
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_cube_measure_maps AS SELECT 
  sch.physicalname owner
, cub.physicalname cube_name
, msr.physicalname measure_name
, use2.object_owner fact_table_owner
, use2.object_name fact_table_name
, use2.secondary_object_name column_name
FROM
  dba_users u  
, cwm$model sch
, cwm$cube  cub
, cwm$measure msr
, cwm$itemuse use1
, cwm$itemuse use2
WHERE u.username = sch.physicalname 
AND sch.irid = cub.datamodel_irid
AND cub.irid = msr.itemcontainer_irid
AND msr.irid = use1.mappable_irid
AND use1.operation_irid = use2.operation_irid_1
WITH READ ONLY
/
