Rem
Rem $Header: cwmlite/admin/onevddim.sql /main/5 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevddim.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      onevddim.sql - dba$olap_dimensions
Rem
Rem    DESCRIPTION
Rem      Dimensions
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    10/26/00 - modify how validate dimension invoked
Rem    dallan      08/19/00 - Change dimension valid call.
Rem    dthompso    08/18/00 - add olap_valid column
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_dimensions AS SELECT 
  u.username owner
, o.name dimension_name
, dim.pluralname plural_name
, dim.displayname display_name
, dim.description description
, display_hierarchy_name default_display_hierarchy
, decode(o.status, 5, 'Y', 'N') invalid
, cwm$util.dim_valid(o.obj#) olap_valid
FROM 
  dba_users u
, sys.obj$ o
, sys.dim$ d
, cwm$dimension dim
WHERE u.user_id = o.owner#
AND o.obj# = d.obj#
AND d.obj# = dim.irid (+)
WITH READ ONLY
/
