Rem
Rem $Header: cwmlite/admin/onevdedu.sql /main/5 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevdedu.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000, 2001. All Rights Reserved.
Rem
Rem    NAME
Rem      onevdedu.sql - dba$olap_entity_desc_uses
Rem
Rem    DESCRIPTION
Rem      Uses of a descriptor value against a metadata element
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    05/22/01 - B1771957: Should not project rows if cube owner d
Rem    dthompso    07/19/00 - use correct classificationentry
Rem    dthompso    06/22/00 - Add secondary_child_entity_name
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_entity_desc_uses AS SELECT 
  ce.classification_irid descriptor_id
, sch.physicalname entity_owner
, cub.physicalname entity_name
, null child_entity_name
, NULL secondary_child_entity_name   
FROM /* CUBE */
  cwm$classification c
, cwm$classificationentry ce
, cwm$classificationtype cty
, cwm$cube cub
, cwm$model sch
, dba_users u
WHERE cty.irid = c.classificationtype_irid
AND cty.name <> 'ORACLE_OLAP_CATALOG'
AND c.irid = ce.classification_irid
AND ce.name = 'CUBE'    
AND ce.element_irid = cub.irid
AND cub.datamodel_irid = sch.irid
AND sch.physicalname = u.username
UNION ALL SELECT
  ce.classification_irid descriptor_id
, sch.physicalname entity_owner
, cub.physicalname entity_name
, msr.physicalname child_entity_name
, NULL secondary_child_entity_name
FROM  /* MEASURE */
  cwm$classification c
, cwm$classificationentry ce
, cwm$classificationtype cty
, cwm$measure msr
, cwm$cube cub
, cwm$model sch
, dba_users u
WHERE cty.irid = c.classificationtype_irid
AND cty.name <> 'ORACLE_OLAP_CATALOG'
AND c.irid = ce.classification_irid
AND ce.name = 'MEASURE'    
AND ce.element_irid = msr.irid
AND msr.itemcontainer_irid = cub.irid
AND cub.datamodel_irid = sch.irid
AND sch.physicalname = u.username
UNION ALL SELECT
  ce.classification_irid descriptor_id
, u.username entity_owner
, d.name entity_name
, dat.physicalname child_entity_name
, NULL secondary_child_entity_name
FROM  /* DIMENSIONATTRIBUTE */
  cwm$classification c
, cwm$classificationentry ce
, cwm$classificationtype cty
, cwm$dimensionattribute dat
, dba_users u
, sys.obj$ d
WHERE cty.irid = c.classificationtype_irid
AND cty.name <> 'ORACLE_OLAP_CATALOG'
AND c.irid = ce.classification_irid
AND ce.name = 'DIMENSION ATTRIBUTE'    
AND ce.element_irid = dat.irid
AND dat.itemcontainer_irid = d.obj#
AND d.owner# = u.user_id
AND d.type# = 43 /* DIMENSION */
UNION ALL SELECT
  ce.classification_irid descriptor_id
, u.username entity_owner
, d.name entity_name
, ce.secondary_object_name child_entity_name
, ce.tertiary_object_name secondary_child_entity_name
FROM  /* LEVELATTRIBUTE */
  cwm$classification c
, cwm$classificationentry ce
, cwm$classificationtype cty
, cwm$levelattribute lat
, cwm$level lvl
, dba_users u
, sys.obj$ d
WHERE cty.irid = c.classificationtype_irid
AND cty.name <> 'ORACLE_OLAP_CATALOG'
AND c.irid = ce.classification_irid
AND ce.name = 'LEVEL ATTRIBUTE'    
AND ce.element_irid = lat.irid
AND lat.itemcontainer_irid = lvl.irid
AND lvl.dimension_irid = d.obj#
AND d.owner# = u.user_id
AND d.type# = 43 /* DIMENSION */  
UNION ALL SELECT
  ce.classification_irid descriptor_id
, u.username entity_owner
, d.name entity_name
, ce.secondary_object_name child_entity_name
, null secondary_child_entity_name
FROM /* DIMENSION, LEVEL, HIERARCHY */
  cwm$classification c
, cwm$classificationentry ce
, cwm$classificationtype cty
, dba_users u
, sys.obj$ d
WHERE cty.irid = c.classificationtype_irid
AND cty.name <> 'ORACLE_OLAP_CATALOG'
AND c.irid = ce.classification_irid
AND ce.name IN ('DIMENSION', 'LEVEL',  'HIERARCHY')      
AND ce.element_irid = d.obj#
AND d.owner# = u.user_id
AND d.type# = 43 /* DIMENSION */
UNION ALL SELECT
  ce.classification_irid descriptor_id
, f.name entity_owner
, p.name entity_name
, null child_entity_name
, NULL secondary_child_entity_name
FROM /* FUNCTION PARAMETER */
  cwm$classification c
, cwm$classificationentry ce
, cwm$classificationtype cty
, cwm$function f
, cwm$parameter p
WHERE cty.irid = c.classificationtype_irid
AND cty.name <> 'ORACLE_OLAP_CATALOG'
AND c.irid = ce.classification_irid
AND ce.name = 'PARAMETER'    
AND ce.element_irid = p.irid
AND p.operation_irid = f.irid 
WITH READ ONLY
/
