Rem
Rem $Header: cwmlite/admin/onevdhlu.sql /main/2 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevdhlu.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      onevdhlu.sql - dba$olap_dim_hier_level_uses
Rem
Rem    DESCRIPTION
Rem     Dimension Levels used within a hierarchy
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_dim_hier_level_uses AS SELECT 
  u.username owner
, d.name dimension_name
, h.hiername hierarchy_name
, pdl.levelname parent_level_name
, cdl.levelname child_level_name
, chl.pos# position
FROM 
  dba_users u
, sys.obj$ d
, sys.hier$ h
, sys.hierlevel$ phl
, sys.hierlevel$ chl
, sys.dimlevel$ pdl
, sys.dimlevel$ cdl
WHERE d.type# = 43 /* DIMENSION */
AND u.user_id = d.owner#
AND d.obj# = h.dimobj#
AND d.obj# = phl.dimobj#
AND h.hierid# = phl.hierid#
AND d.obj# = pdl.dimobj#
AND phl.levelid# = pdl.levelid#
AND d.obj# = chl.dimobj#
AND h.hierid# = chl.hierid#
AND chl.levelid# = cdl.levelid#
AND d.obj# = cdl.dimobj#
AND phl.pos# = chl.pos# + 1
WITH READ ONLY
/
