Rem
Rem $Header: cwmlite/admin/onevdkcu.sql /main/2 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevdkcu.sql
Rem
Rem  Copyright (c) Oracle Corporation 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      onevdkcu.sql - dba$olap_key_column_uses
Rem
Rem    DESCRIPTION
Rem      Columns within Physical keys, i.e. primary, unique, foreign.
Rem
Rem    NOTES
Rem     
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_key_column_uses AS SELECT 
/*+ ORDERED */
  u.username owner
, t.name table_name
, c.name key_name
, col.name column_name
, ccol.pos# position
FROM 
  dba_users u
, sys.obj$ t
, sys.con$ c
, sys.cdef$ cd
, sys.col$ col
, sys.ccol$ ccol
WHERE u.user_id = c.owner#
AND c.con# = cd.con#
AND cd.con# = ccol.con#
AND cd.obj# = t.obj#
AND ccol.intcol# = col.intcol#
AND col.obj# = t.obj#
AND cd.type# IN (2,3,4) /* primary, unique, referential */
AND t.type# IN (2,4) /* table, view */
WITH READ ONLY
/
