Rem
Rem $Header: cwmlite/admin/onevdlev.sql /main/2 2008/07/28 13:25:50 glyon Exp $
Rem
Rem onevdlev.sql
Rem
Rem  Copyright (c) Oracle Corporation 1900, 2000. All Rights Reserved.
Rem
Rem    NAME
Rem      onevdlev.sql - dba$olap_dim_levels
Rem
Rem    DESCRIPTION
Rem      Dimension levels
Rem
Rem    NOTES
Rem      
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    glyon       06/24/08 - bug 7204558: eliminate references to sys.user$
Rem    dthompso    04/26/00 - Initial Version
Rem    dthompso    01/00/00 - Created
Rem

CREATE OR REPLACE VIEW dba$olap_dim_levels AS SELECT 
  u.username owner
, d.name dimension_name
, l.levelname level_name
, lev.displayname display_name
, lev.description description
, tu.username level_table_owner
, t.name level_table_name
FROM 
  dba_users u
, sys.obj$ d
, sys.dimlevel$ l
, sys.dimlevelkey$ k
, sys.obj$ t
, dba_users tu
, cwm$level lev
WHERE d.type# = 43 /* DIMENSION */
AND u.user_id = d.owner#
AND d.obj# = l.dimobj#
AND l.dimobj# = k.dimobj#
AND l.levelid# = k.levelid#
AND k.detailobj# = t.obj#
AND t.owner# = tu.user_id
AND k.keypos# = 1
AND l.dimobj# = lev.dimension_irid (+)
AND l.levelname = lev.physicalname (+)
WITH READ ONLY
/
