// EmployeeClientObject.java
/* This class represents an employee reference on the Client side */

import java.sql.*;

public class EmployeeClientObject 
{
  Integer id = null;
  Connection conn = null;

  public EmployeeClientObject(String conn_url, String user, String password,
                              boolean autocom) 
    throws SQLException
  {
    DriverManager.registerDriver (new oracle.jdbc.OracleDriver ());
    conn = DriverManager.getConnection(conn_url,user,password);
    conn.setAutoCommit(autocom);
  }
  public void getEmployee (int empno)
       throws SQLException
  {
    CallableStatement cs = null;
    try{
      cs = conn.prepareCall("{ ? = call empbyref.getemp ( ? ) }");
      cs.registerOutParameter(1,Types.INTEGER);
      cs.setInt(2,empno);
      cs.executeUpdate();
      id = new Integer(cs.getInt(1));
      if(cs.wasNull())
        id = null;
    }
    finally
    {
      if(cs != null)
        cs.close();
    }
  }

  public int salary ()
       throws SQLException
  {
    Integer salary;
    CallableStatement cs = null;
    try{
      cs = conn.prepareCall("BEGIN ? := empbyref.empsal(?); END;");
      cs.registerOutParameter(1,Types.INTEGER);
      if(id == null)
        cs.setNull(2,Types.INTEGER);
      else
        cs.setInt(2,id.intValue());
      cs.executeUpdate();
      salary = new Integer(cs.getInt(1));
      if(cs.wasNull())
        salary = null;
    }
    finally
    {
      if(cs != null)
        cs.close();
    }
    return salary.intValue ();
  }

  public void raise (float percent)
       throws SQLException
  {
    CallableStatement cs = null;
    try{
      cs = conn.prepareCall("{call empbyref.raiseemp ( ?,? )}");
      if(id == null)
        cs.setNull(1,Types.INTEGER);
      else
        cs.setInt(1,id.intValue());
      cs.setFloat(2,percent);
      cs.executeUpdate();
    }
    finally
    {
      if(cs != null)
        cs.close();
    }
  }

  public void update ()
       throws SQLException
  {
    CallableStatement cs = null;
    try{
      cs = conn.prepareCall("{call empbyref.updateemp ( ? )}");
      if(id == null)
        cs.setNull(1,Types.INTEGER);
      else
        cs.setInt(1,id.intValue());
      cs.executeUpdate();
    }
    finally
    {
      if(cs != null)
        cs.close();
    }
  }
}
