<xsl:stylesheet version="1.0" 
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fn="http://www.w3.org/2005/02/xpath-functions">

  <xsl:strip-space elements="*"/> 
  <xsl:include href="../xplan/xplHtml.xsl"/>
  <xsl:preserve-space elements="indent"/>
  <xsl:decimal-format name="kecpr"
                      decimal-separator="."
                      grouping-separator="," 
                      infinity="0"
                      minus-sign="-"
                      NaN="0"
                      percent="%"
                      zero-digit="0"
                      digit="9"/>

  <!-- Define globals here -->
  <xsl:variable name="max_count_plus1" select="'6'"/>

  <xsl:template match="/">

  <html>
    <head>
      <title> DB Replay Report </title>

      <script type="text/javascript">
        function toggle_visibility(id) {
          var e = document.getElementById(id);
          if(e.style.display == 'none') {
            e.style.display = '';
          }
          else {
            e.style.display = 'none';
          }
        }
      </script>

      <style type="text/css">

        body, table {
          font-size:          8pt;
          font-family:        Verdana,Arial;
          text-decoration:    none;
          color:              #000000;
          background-color:   #ffffff;
        }

        th {
          color:            #ffffff;
          background-color: #0066CC;
          padding:          2px;
        }

        td {
          padding:          2px;
        }

        .report_title {
          font-size:          20pt;
          font-weight:        bold;
          color:              #336699;
        }

        .chapter_title {
          font-size:          14pt;
          font-weight:        bold;
          color:              #336699;
          text-decoration:    underline;
        }

        .section_title {
          font-size:          12pt;
          font-weight:        bold;
          color:              #336699;
        }

        .subsection_title {
          font-size:          10pt;
          font-weight:        bold;
          color:              #336699;
          padding-left:       8px;
        }

        .no_data_message {
          font-size:          8pt;
          font-weight:        bold;
          padding-left:       4px;
          color:              #000000;
          background-color:   #ffffff;
        }

        .hide_this {
          display:            none;
        }

        .same_fg_bg {
          color:   #ffffff;
          background-color: #ffffff;
        }

        .row0 {
          background-color:  #ffffbb;
        }

        .row1 {
          background-color:  #ffffff;
        }

      </style>
    </head>
    <body>

      <xsl:apply-templates select="report/header"/>
      <xsl:apply-templates select="report/summary"/>
      <xsl:apply-templates select="report/body"/>

      <br/>
      <b> End of Report. </b>
    </body>
  </html>

  </xsl:template>

  <!-- report header  -->
  <xsl:template match="header">

    <!-- report title -->
    <div class="report_title">
      DB Replay Report for 
      <xsl:value-of select="replay_info/name"/>
    </div>

    <hr/>
    <p/>

    <!-- show database header -->
    <table cellspacing="0" cellpadding="0" border="2">
      <tr>
        <th> DB Name </th>
        <th> DB Id </th>
        <th> Release </th>
        <th> RAC </th>
        <th> Replay Name </th>
        <th> Replay Status </th>
      </tr>
      <tr>
        <td> 
          <xsl:value-of select="database_header/database_name"/>
        </td>
        <td> 
          <xsl:value-of select="database_header/database_id"/>
        </td>
        <td> 
          <xsl:value-of select="database_header/database_version"/>
        </td>
        <td> 
          <xsl:value-of select="database_header/database_parallel"/>
        </td>
        <td> 
          <xsl:value-of select="replay_info/name"/>
        </td>
        <td> 
          <xsl:value-of select="replay_info/status"/>
        </td>
      </tr>
    </table>
 
    <p/>

    <div class="subsection_title">
      Replay Information
    </div>

    <!-- show capture/replay header -->
    <table cellspacing="0" cellpadding="0" border="2">
      <tr>
        <th align="center">
          Information
        </th>
        <th> 
          Replay
        </th>
        <th> 
          Capture
        </th>
      </tr>
      <tr class="row1">
        <td>
          Name
        </td>
        <td> 
          <xsl:value-of select="replay_info/name"/>
        </td>
        <td> 
          <xsl:value-of select="capture_info/name"/>
        </td>
      </tr>
      <tr class="row0">
        <td>
          Status
        </td>
        <td> 
          <xsl:value-of select="replay_info/status"/>
        </td>
        <td> 
          <xsl:value-of select="capture_info/status"/>
        </td>
      </tr>
      <tr class="row1">
        <td>
          Database Name
        </td>
        <td> 
          <xsl:value-of select="replay_info/database_name"/>
        </td>
        <td> 
          <xsl:value-of select="capture_info/database_name"/>
        </td>
      </tr>
      <tr class="row0">
        <td>
          Database Version
        </td>
        <td> 
          <xsl:value-of select="replay_info/database_version"/>
        </td>
        <td> 
          <xsl:value-of select="capture_info/database_version"/>
        </td>
      </tr>

      <xsl:if test="replay_info/error_code != ''">
      <tr class="row1">
        <td>
          Error Code
        </td>
        <td> 
          <xsl:value-of select="replay_info/error_code"/>
        </td>
        <td> 
        </td>
      </tr>
      <tr class="row0">
        <td>
          Error Message
        </td>
        <td> 
          <xsl:value-of select="replay_info/error_message"/>
        </td>
        <td> 
        </td>
      </tr>
      </xsl:if>

      <tr class="row1">
        <td>
          Start Time
        </td>
        <td> 
          <xsl:value-of select="replay_info/start_time"/>
        </td>
        <td> 
          <xsl:value-of select="capture_info/start_time"/>
        </td>
      </tr>
      <tr class="row0">
        <td>
          End Time
        </td>
        <td> 
          <xsl:value-of select="replay_info/end_time"/>
        </td>
        <td> 
          <xsl:value-of select="capture_info/end_time"/>
        </td>
      </tr>
      <tr class="row1">
        <td>
          Duration
        </td>
        <td> 
          <xsl:value-of select="replay_info/duration"/>
        </td>
        <td> 
          <xsl:value-of select="capture_info/duration"/>
        </td>
      </tr>
      <tr class="row0">
        <td>
          Directory Object
        </td>
        <td> 
          <xsl:value-of select="replay_info/directory"/>
        </td>
        <td> 
          <xsl:value-of select="capture_info/directory"/>
        </td>
      </tr>
      <tr class="row1">
        <td>
          Directory Path
        </td>
        <td> 
          <xsl:value-of select="replay_info/dir_path"/>
        </td>
        <td> 
          <xsl:value-of select="capture_info/dir_path"/>
        </td>
      </tr>
    </table>

    <p/>

    <div class="subsection_title">
      Replay Options
    </div>

    <!-- show replay configuration  -->
    <table cellspacing="0" cellpadding="0" border="2">
      <tr>
        <th align="center">
          Option Name
        </th>
        <th>
          Value
        </th>
      </tr>
      <tr class="row1">
        <td>
          Synchronization
        </td>
        <td>
          <xsl:value-of select="replay_info/synchronization"/>
        </td>
      </tr>
      <tr class="row0">
        <td>
          Connect Time
        </td>
        <td>
          <xsl:value-of select="replay_info/connect_time_scale"/>%
        </td>
      </tr>
      <tr class="row1">
        <td>
          Think Time
        </td>
        <td>
          <xsl:value-of select="replay_info/think_time_scale"/>%
        </td>
      </tr>
      <tr class="row0">
        <td>
          Think Time Auto Correct
        </td>
        <td>
          <xsl:value-of select="replay_info/think_time_auto_correct"/>
        </td>
      </tr>
      <tr class="row1">
        <td>
          Number of WRC Clients
        </td>
        <td>
          <xsl:value-of select="replay_info/num_clients"/>
          (<xsl:value-of select="replay_info/num_clients_done"/> Completed,
           <xsl:choose>
             <xsl:when test="replay_info/num_clients
                             &gt; 
                             replay_info/num_clients_done">
               <xsl:value-of select="replay_info/num_clients 
                                     - replay_info/num_clients_done"/>
             </xsl:when>
             <xsl:otherwise>
               0
             </xsl:otherwise>
           </xsl:choose>
           Running
          )
        </td>
      </tr>
    </table>

    <p/>

    <div class="subsection_title">
      Replay Statistics
    </div>

    <!-- show capture/replay stats -->
    <table cellspacing="0" cellpadding="0" border="2">
      <tr>
        <th align="center">
          Statistic
        </th>
        <th>
          Replay
        </th>
        <th>
          Capture
        </th>
      </tr>
      <tr class="row1">
        <td>
          DB Time
        </td>
        <td align="right"> 
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="replay_info/dbtime div 1000000"/>
            <xsl:with-param  name="round_to"
                             select="3"/>
          </xsl:call-template> seconds
        </td>
        <td align="right"> 
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="capture_info/dbtime div 1000000"/>
            <xsl:with-param  name="round_to"
                             select="3"/>
          </xsl:call-template> seconds
        </td>
      </tr>
      <tr class="row0">
        <td>
          Average Active Sessions
        </td>
        <td align="right"> 
          <xsl:value-of select="replay_info/average_active_sessions"/>
        </td>
        <td align="right"> 
          <xsl:value-of select="capture_info/average_active_sessions"/>
        </td>
      </tr>
      <tr class="row1">
        <td>
          User calls
        </td>
        <td align="right"> 
          <xsl:value-of select="replay_info/user_calls"/>
        </td>
        <td align="right"> 
          <xsl:value-of select="capture_info/user_calls"/>
        </td>
      </tr>
      <tr class="row0">
        <td>
          Network Time
        </td>
        <td align="right"> 
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="replay_info/network_time div 1000000"/>
            <xsl:with-param  name="round_to"
                             select="3"/>
          </xsl:call-template> seconds
        </td>
        <td>
          <span class="same_fg_bg">.</span>
        </td>
      </tr>
      <tr class="row1">
        <td>
          Think Time
        </td>
        <td align="right"> 
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="replay_info/think_time div 1000000"/>
            <xsl:with-param  name="round_to"
                             select="3"/>
          </xsl:call-template> seconds
        </td>
        <td> 
          <span class="same_fg_bg">.</span>
        </td>
      </tr>
    </table>

  </xsl:template>

  <!-- report summary  -->
  <xsl:template match="summary">

    <p/>

    <div class="subsection_title">
      Replay Divergence Summary
    </div>

    <!-- show replay divergence summary -->
    <table cellspacing="0" cellpadding="0" border="2">
      <tr>
        <th align="center">
          Divergence Type
        </th>
        <th>
          Count
        </th>
        <th>
          % Total
        </th>
      </tr>
      <tr class="row1">
        <td>
          Session Failures During Replay
        </td>
        <td align="right">
          <xsl:value-of select="divergence/session_failures/count"/>
        </td>
        <td align="right">
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="divergence/session_failures/count * 100
                                     div
                                     /report/header/capture_info/user_calls"/>
            <xsl:with-param  name="round_to"
                             select="2"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr class="row0">
        <td>
          Errors No Longer Seen During Replay
        </td>
        <td align="right">
          <xsl:value-of select="divergence/error/capture_only"/>
        </td>
        <td align="right">
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="divergence/error/capture_only * 100
                                     div
                                     /report/header/capture_info/user_calls"/>
            <xsl:with-param  name="round_to"
                             select="2"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr class="row1">
        <td>
          New Errors Seen During Replay
        </td>
        <td align="right">
          <xsl:value-of select="divergence/error/new_errors"/>
        </td>
        <td align="right">
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="divergence/error/new_errors * 100
                                     div
                                     /report/header/capture_info/user_calls"/>
            <xsl:with-param  name="round_to"
                             select="2"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr class="row0">
        <td>
          Errors Mutated During Replay
        </td>
        <td align="right">
          <xsl:value-of select="divergence/error/mutated_errors"/>
        </td>
        <td align="right">
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="divergence/error/mutated_errors * 100
                                     div
                                     /report/header/capture_info/user_calls"/>
            <xsl:with-param  name="round_to"
                             select="2"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr class="row1">
        <td>
          DMLs with Different Number of Rows Modified
        </td>
        <td align="right">
          <xsl:value-of select="divergence/dml_data/count"/>
        </td>
        <td align="right">
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="divergence/dml_data/count * 100
                                     div
                                     /report/header/capture_info/user_calls"/>
            <xsl:with-param  name="round_to"
                             select="2"/>
          </xsl:call-template>
        </td>
      </tr>
      <tr class="row0">
        <td>
          SELECTs with Different Number of Rows Fetched
        </td>
        <td align="right">
          <xsl:value-of select="divergence/query_data/count"/>
        </td>
        <td align="right">
          <xsl:call-template name="ora_round">
            <xsl:with-param  name="number"
                             select="divergence/query_data/count * 100
                                     div
                                     /report/header/capture_info/user_calls"/>
            <xsl:with-param  name="round_to"
                             select="2"/>
          </xsl:call-template>
        </td>
      </tr>
    </table>

    <p/>

    <hr/>

  </xsl:template>

  <!-- report body  -->
  <xsl:template match="body">
     <div class="chapter_title">
       Workload Profile
     </div>
    <xsl:apply-templates select="workload_profile"/>
     <div class="chapter_title">
       Replay Divergence
     </div>
    <xsl:apply-templates select="divergence"/>
     <div class="chapter_title">
       Replay Clients Alerts
     </div>
    <xsl:apply-templates select="alerts"/>
     <div class="chapter_title">
       Replay Filters
     </div>
    <xsl:apply-templates select="filters"/>
  </xsl:template>

  <!-- render workload profile -->
  <xsl:template match="workload_profile">
     <div class="section_title">
       Top Events
     </div>
    <xsl:apply-templates select="top_events"/>
     <div class="section_title">
       Top Service/Module/Action
     </div>
    <xsl:apply-templates select="top_service_module_actions"/>
     <div class="section_title">
       Top SQL with Top Events
     </div>
    <xsl:apply-templates select="top_sql_events"/>
     <div class="section_title">
       Top Sessions with Top Events
     </div>
    <xsl:apply-templates select="top_session_events"/>
  </xsl:template>

  <!-- render top events profile -->
  <xsl:template match="top_events">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'top_events'"/>
    </xsl:call-template>

    <table id="top_events" cellpadding="0" cellspacing="0" border="2">

    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'Event'"/>
        <xsl:with-param name="heading2"      select="'Event Class'"/>
        <xsl:with-param name="heading3"      select="'% Activity'"/>
      </xsl:call-template>
    </tr>

    <xsl:call-template name="show_1d_rows">
      <xsl:with-param name="element"       select="'event'"/>
      <xsl:with-param name="prm1"          select="'event_name'"/>
      <xsl:with-param name="prm2"          select="'wait_class'"/>
      <xsl:with-param name="count"         select="'ash_count'"/>
    </xsl:call-template>

    </table>
  </xsl:template>

  <!-- render top service/module/action profile -->
  <xsl:template match="top_service_module_actions">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'top_service_module_actions'"/>
    </xsl:call-template>

    <table id="top_service_module_actions"
           cellpadding="0" cellspacing="0" border="2">
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'Service Name'"/>
        <xsl:with-param name="heading2"      select="'Module Name'"/>
        <xsl:with-param name="heading3"      select="'% Activity'"/>
        <xsl:with-param name="heading4"      select="'Action Drilldown'"/>
      </xsl:call-template>
    </tr>

    <xsl:call-template name="show_2d_rows">
      <xsl:with-param name="element"       select="'service_module'"/>
      <xsl:with-param name="prm1"          select="'service_name'"/>
      <xsl:with-param name="prm2"          select="'module_name'"/>
      <xsl:with-param name="count"         select="'ash_count'"/>
      <xsl:with-param name="delement"      select="'action'"/>
      <xsl:with-param name="dprm1_heading" select="'Action Name'"/>
      <xsl:with-param name="dprm1"         select="'action_name'"/>
      <xsl:with-param name="dcount_heading" select="'% Activity'"/>
      <xsl:with-param name="dcount"         select="'ash_count'"/>
    </xsl:call-template>
    </table>
  </xsl:template>

  <!-- render top sql with events profile -->
  <xsl:template match="top_sql_events">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'top_sql_events'"/>
    </xsl:call-template>

    <table id="top_sql_events" cellpadding="0" cellspacing="0" border="2">
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'SQL ID'"/>
        <xsl:with-param name="heading2"      select="'Planhash'"/>
        <xsl:with-param name="heading3"      select="'Sampled Number of Executions'"/>
        <xsl:with-param name="heading4"      select="'% Activity'"/>
        <xsl:with-param name="heading5"      select="'Event Drilldown'"/>
      </xsl:call-template>
    </tr>

    <xsl:call-template name="show_2d_rows">
        <xsl:with-param name="element"       select="'sql"/>
        <xsl:with-param name="prm1"          select="'sql_id'"/>
        <xsl:with-param name="prm2"          select="'planhash'"/>
        <xsl:with-param name="prm3"          select="'ash_num_executions'"/>
        <xsl:with-param name="count"         select="'ash_count'"/>
        <xsl:with-param name="delement"      select="'event'"/>
        <xsl:with-param name="dprm1_heading" select="'Event'"/>
        <xsl:with-param name="dprm1"         select="'event_name'"/>
        <xsl:with-param name="dcount_heading" select="'% Activity'"/>
        <xsl:with-param name="dcount"         select="'ash_count'"/>
    </xsl:call-template>
    </table>
  </xsl:template>

  <!-- render top session with events profile -->
  <xsl:template match="top_session_events">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'top_session_events'"/>
    </xsl:call-template>

    <table id="top_session_events" cellpadding="0" cellspacing="0" border="2">
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'Session ID'"/>
        <xsl:with-param name="heading2"      select="'Session Serial'"/>
        <xsl:with-param name="heading3"      select="'Username'"/>
        <xsl:with-param name="heading4"      select="'Program'"/>
        <xsl:with-param name="heading5"      select="'% Activity'"/>
        <xsl:with-param name="heading6"      select="'Event Drilldown'"/>
      </xsl:call-template>
    </tr>

      <xsl:call-template name="show_2d_rows">
        <xsl:with-param name="element"       select="'session'"/>
        <xsl:with-param name="prm1"          select="'session_id'"/>
        <xsl:with-param name="prm2"          select="'session_serial'"/>
        <xsl:with-param name="prm3"          select="'user_name'"/>
        <xsl:with-param name="prm4"          select="'program_name'"/>
        <xsl:with-param name="count"         select="'ash_count'"/>
        <xsl:with-param name="delement"      select="'event'"/>
        <xsl:with-param name="dprm1_heading" select="'Event'"/>
        <xsl:with-param name="dprm1"         select="'event_name'"/>
        <xsl:with-param name="dcount_heading" select="'% Activity'"/>
        <xsl:with-param name="dcount"         select="'ash_count'"/>
      </xsl:call-template>
    </table>
  </xsl:template>

  <!-- render divergence details -->
  <xsl:template match="divergence">
     <div class="section_title">
       Session Failures 
     </div>
    <xsl:apply-templates select="session_failures"/>
     <div class="section_title">
       Error Divergence
     </div>
    <xsl:apply-templates select="error"/>
     <div class="section_title">
       DML Data Divergence
     </div>
    <xsl:apply-templates select="dml_data"/>
     <div class="section_title">
       SELECT Data Divergence
     </div>
    <xsl:apply-templates select="query_data"/>
  </xsl:template>

  <!-- render session failures divergence details -->
  <xsl:template match="session_failures">
     <div class="subsection_title">
       By Application
     </div>
    <xsl:apply-templates select="by_app"/>
  </xsl:template>

  <!-- render error divergence details -->
  <xsl:template match="error">
     <div class="subsection_title">
       By Application
     </div>
    <xsl:apply-templates select="by_app"/>
     <div class="subsection_title">
       By SQL
     </div>
    <xsl:apply-templates select="by_sql"/>
     <div class="subsection_title">
       By Session
     </div>
    <xsl:apply-templates select="by_session"/>
  </xsl:template>

  <!-- render DML data divergence details -->
  <xsl:template match="dml_data">
     <div class="subsection_title">
       By Application
     </div>
    <xsl:apply-templates select="by_app"/>
     <div class="subsection_title">
       By SQL
     </div>
    <xsl:apply-templates select="by_sql"/>
     <div class="subsection_title">
       By Divergence magnitude
     </div>
    <xsl:apply-templates select="bucketized"/>
  </xsl:template>

  <!-- render SELECT data divergence details -->
  <xsl:template match="query_data">
     <div class="subsection_title">
       By Application
     </div>
    <xsl:apply-templates select="by_app"/>
     <div class="subsection_title">
       By Divergence magnitude
     </div>
    <xsl:apply-templates select="bucketized"/>
  </xsl:template>

  <xsl:template match="session_failures/by_app">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'session_failures_by_app'"/>
    </xsl:call-template>

    <table id="session_failures_by_app"
           cellpadding="0" cellspacing="0" border="2">
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'Error'"/>
        <xsl:with-param name="heading2"      select="'Module Name'"/>
        <xsl:with-param name="heading3"      select="'Action Name'"/>
        <xsl:with-param name="heading4"      select="'Count'"/>
        <xsl:with-param name="heading5"      select="'First Occurrence'"/>
        <xsl:with-param name="heading6"      select="'Last Occurrence'"/>
      </xsl:call-template>
    </tr>

    <xsl:for-each select="row">
    <tr>
      <xsl:call-template name="show_divergence_row">
        <xsl:with-param name="prm1"          select="error_number"/>
        <xsl:with-param name="prm2"          select="module_name"/>
        <xsl:with-param name="prm3"          select="action_name"/>
        <xsl:with-param name="count"         select="count"/>
        <xsl:with-param name="first_occur"   select="first_occurrence"/>
        <xsl:with-param name="last_occur"    select="last_occurrence"/>
      </xsl:call-template>
    </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="error/by_app">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'error_by_app'"/>
    </xsl:call-template>

    <table id="error_by_app" cellpadding="0" cellspacing="0" border="2">
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'Service Name"/>
        <xsl:with-param name="heading2"      select="'Module Name"/>
        <xsl:with-param name="heading3"      select="'Action Name"/>
        <xsl:with-param name="heading4"      select="'Capture Error'"/>
        <xsl:with-param name="heading5"      select="'Replay Error'"/>
        <xsl:with-param name="heading6"      select="'Count'"/>
        <xsl:with-param name="heading7"      select="'First Occurrence'"/>
        <xsl:with-param name="heading8"      select="'Last Occurrence'"/>
      </xsl:call-template>
    </tr>
    <xsl:for-each select="row">
    <tr>
      <xsl:call-template name="show_divergence_row">
        <xsl:with-param name="prm1"          select="service_name"/>
        <xsl:with-param name="prm2"          select="module_name"/>
        <xsl:with-param name="prm3"          select="action_name"/>
        <xsl:with-param name="prm4"          select="capture_error"/>
        <xsl:with-param name="prm5"          select="replay_error"/>
        <xsl:with-param name="count"         select="count"/>
        <xsl:with-param name="first_occur"   select="first_occurrence"/>
        <xsl:with-param name="last_occur"    select="last_occurrence"/>
      </xsl:call-template>
    </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="error/by_sql">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'error_by_sql'"/>
    </xsl:call-template>

    <table id="error_by_sql" cellpadding="0" cellspacing="0" border="2">
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'SQL ID'"/>
        <xsl:with-param name="heading2"      select="'Capture Error'"/>
        <xsl:with-param name="heading3"      select="'Replay Error'"/>
        <xsl:with-param name="heading4"      select="'Count'"/>
        <xsl:with-param name="heading5"      select="'First Occurrence'"/>
        <xsl:with-param name="heading6"      select="'Last Occurrence'"/>
      </xsl:call-template>
    </tr>
    <xsl:for-each select="row">
    <tr>
      <xsl:call-template name="show_divergence_row">
        <xsl:with-param name="prm1"          select="sql_id"/>
        <xsl:with-param name="prm2"          select="capture_error"/>
        <xsl:with-param name="prm3"          select="replay_error"/>
        <xsl:with-param name="count"         select="count"/>
        <xsl:with-param name="first_occur"   select="first_occurrence"/>
        <xsl:with-param name="last_occur"    select="last_occurrence"/>
      </xsl:call-template>
    </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="error/by_session">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'error_by_session'"/>
    </xsl:call-template>

    <table id="error_by_session" cellpadding="0" cellspacing="0" border="2">
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'Session ID'"/>
        <xsl:with-param name="heading2"      select="'Session Serial'"/>
        <xsl:with-param name="heading3"      select="'Capture Error'"/>
        <xsl:with-param name="heading4"      select="'Replay Error'"/>
        <xsl:with-param name="heading5"      select="'Count'"/>
        <xsl:with-param name="heading6"      select="'First Occurrence'"/>
        <xsl:with-param name="heading7"      select="'Last Occurrence'"/>
      </xsl:call-template>
    </tr>
    <xsl:for-each select="row">
    <tr>
      <xsl:call-template name="show_divergence_row">
        <xsl:with-param name="prm1"          select="session_id"/>
        <xsl:with-param name="prm2"          select="session_serial"/>
        <xsl:with-param name="prm3"          select="capture_error"/>
        <xsl:with-param name="prm4"          select="replay_error"/>
        <xsl:with-param name="count"         select="count"/>
        <xsl:with-param name="first_occur"   select="first_occurrence"/>
        <xsl:with-param name="last_occur"    select="last_occurrence"/>
      </xsl:call-template>
    </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="dml_data/by_app|query_data/by_app">
    <xsl:variable name="id_name"
                  select="concat(name(parent::*), name(self::*))"/>

    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="$id_name"/>
    </xsl:call-template>

    <table id="$id_name" cellpadding="0" cellspacing="0" border="2">
      <xsl:attribute name="id">
        <xsl:value-of select="$id_name"/>
      </xsl:attribute>
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'Service Name'"/>
        <xsl:with-param name="heading2"      select="'Module Name'"/>
        <xsl:with-param name="heading3"      select="'Action Name'"/>
        <xsl:with-param name="heading4"      select="'Avg Rows Affected"/>
        <xsl:with-param name="heading5"      select="'Avg Absolute Rows Affected"/>
        <xsl:with-param name="heading6"      select="'Number of Distinct Sessions'"/>
        <xsl:with-param name="heading7"      select="'Count'"/>
        <xsl:with-param name="heading8"      select="'First Occurrence'"/>
        <xsl:with-param name="heading9"      select="'Last Occurrence'"/>
      </xsl:call-template>
    </tr>
    <xsl:for-each select="row">
    <tr>
      <xsl:call-template name="show_divergence_row">
        <xsl:with-param name="prm1"          select="service_name"/>
        <xsl:with-param name="prm2"          select="module_name"/>
        <xsl:with-param name="prm3"          select="action_name"/>
        <xsl:with-param name="prm4"          select="avg_row_divergence"/>
        <xsl:with-param name="prm5"          select="avg_abs_row_divergence"/>
        <xsl:with-param name="prm6"          select="session_count"/>
        <xsl:with-param name="count"         select="count"/>
        <xsl:with-param name="first_occur"   select="first_occurrence"/>
        <xsl:with-param name="last_occur"    select="last_occurrence"/>
      </xsl:call-template>
    </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="dml_data/bucketized|query_data/bucketized">
    <xsl:variable name="id_name"
                  select="concat(name(parent::*), name(self::*))"/>

    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="$id_name"/>
    </xsl:call-template>

    <table id="$id_name" cellpadding="0" cellspacing="0" border="2">
      <xsl:attribute name="id">
        <xsl:value-of select="$id_name"/>
      </xsl:attribute>
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'Max divergence magnitude'"/>
        <xsl:with-param name="heading2"      select="'Divergence distribution
(%)'"/>
        <xsl:with-param name="heading3"      select="'Count'"/>
      </xsl:call-template>
    </tr>
    <xsl:for-each select="row">
    <tr>
      <xsl:call-template name="show_divergence_row">
        <xsl:with-param name="prm1"           select="max_divergence"/>
        <xsl:with-param name="prm2"           select="div_percentage"/>
        <xsl:with-param name="count"          select="counts"/>
      </xsl:call-template>
    </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

  <xsl:template match="dml_data/by_sql">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'dml_data_by_sql"/>
    </xsl:call-template>

    <table id="dml_data_by_sql" cellpadding="0" cellspacing="0" border="2">
    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'SQL ID'"/>
        <xsl:with-param name="heading2"      select="'Avg Rows Affected"/>
        <xsl:with-param name="heading3"      select="'Avg Absolute Rows Affected"/>
        <xsl:with-param name="heading4"      select="'Number of Distinct Sessions'"/>
        <xsl:with-param name="heading5"      select="'Count'"/>
        <xsl:with-param name="heading6"      select="'First Occurrence'"/>
        <xsl:with-param name="heading7"      select="'Last Occurrence'"/>
      </xsl:call-template>
    </tr>
    <xsl:for-each select="row">
    <tr>
      <xsl:call-template name="show_divergence_row">
        <xsl:with-param name="prm1"          select="sql_id"/>
        <xsl:with-param name="prm2"          select="avg_row_divergence"/>
        <xsl:with-param name="prm3"          select="avg_abs_row_divergence"/>
        <xsl:with-param name="prm4"          select="session_count"/>
        <xsl:with-param name="count"         select="count"/>
        <xsl:with-param name="first_occur"   select="first_occurrence"/>
        <xsl:with-param name="last_occur"    select="last_occurrence"/>
      </xsl:call-template>
    </tr>
    </xsl:for-each>
    </table>
  </xsl:template>

  <!-- render alerts -->
  <xsl:template match="alerts">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'alerts'"/>
    </xsl:call-template>

    <table id="alerts" cellpadding="0" cellspacing="0" border="2">

    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'Alert Name'"/>
      </xsl:call-template>
    </tr>

    <xsl:call-template name="show_1d_rows">
      <xsl:with-param name="element"       select="'alert'"/>
      <xsl:with-param name="prm1"          select="'alert_name'"/>
    </xsl:call-template>

    </table>
  </xsl:template>

  <!-- render filters -->
  <xsl:template match="filters">
    <xsl:call-template name="show_hide_controls">
      <xsl:with-param  name="id"  select="'filters'"/>
    </xsl:call-template>

    <table id="filters" cellpadding="0" cellspacing="0" border="2">

    <tr>
      <xsl:call-template name="show_table_header">
        <xsl:with-param name="heading1"      select="'#'"/>
        <xsl:with-param name="heading2"      select="'Type'"/>
        <xsl:with-param name="heading3"      select="'Attribute'"/>
        <xsl:with-param name="heading4"      select="'Value'"/>
      </xsl:call-template>
    </tr>

    <xsl:call-template name="show_1d_rows">
      <xsl:with-param name="element"       select="'filter'"/>
      <xsl:with-param name="prm1"          select="'fnumber'"/>
      <xsl:with-param name="prm2"          select="'type'"/>
      <xsl:with-param name="prm3"          select="'attribute'"/>
      <xsl:with-param name="prm4"          select="'value'"/>
    </xsl:call-template>

    </table>
  </xsl:template>

  <xsl:template name="ora_round">
    <xsl:param name="number"  select=""/>
    <xsl:param name="round_to"   select=""/>

    <xsl:variable name="format_string">
      <xsl:choose>
        <xsl:when test="$round_to = 0">999999999999999999999990</xsl:when>
        <xsl:when test="$round_to = 1">999999999999999999999990.0</xsl:when>
        <xsl:when test="$round_to = 2">999999999999999999999990.00</xsl:when>
        <xsl:when test="$round_to = 3">999999999999999999999990.000</xsl:when>
      </xsl:choose>
    </xsl:variable>

    <xsl:value-of select="format-number($number,
                                        $format_string, 
                                        'kecpr')"/>

  </xsl:template>

  <xsl:template name="show_hide_controls">
    <xsl:param name="id"      select=""/>

    <xsl:variable name="id_show_divname"
                  select="concat($id, '_show')"/>
    <xsl:variable name="id_hide_divname"
                  select="concat($id, '_hide')"/>
    <xsl:variable name="javascript_onclick_code"
                  select='concat("toggle_visibility(&apos;", 
                                                    $id,
                                                    "&apos;); ",
                                 "toggle_visibility(&apos;",
                                                    $id_show_divname, 
                                                    "&apos;); ",
                                 "toggle_visibility(&apos;",
                                                    $id_hide_divname, 
                                                    "&apos;); "
                                )'/>

    <ora_invisible>
    <xsl:element name="div">
      <xsl:attribute name="id">
        <xsl:value-of select="$id_show_divname"/>
      </xsl:attribute>
      <xsl:attribute name="style">
        <xsl:value-of select="'display: none;'"/>
      </xsl:attribute>

      <xsl:element name="a">
        <xsl:attribute name="href">#anchor_<xsl:value-of select="$id_show_divname"/></xsl:attribute> 
        <xsl:attribute name="name">anchor_<xsl:value-of select="$id_show_divname"/></xsl:attribute> 
        <xsl:attribute name="onclick">
          <xsl:value-of select="$javascript_onclick_code"
                        disable-output-escaping="yes"/>
        </xsl:attribute> 
        (+) Show
      </xsl:element>

    </xsl:element>
    </ora_invisible>

    <ora_invisible>
    <xsl:element name="div">
      <xsl:attribute name="id">
        <xsl:value-of select="$id_hide_divname"/>
      </xsl:attribute>

      <xsl:element name="a">
        <xsl:attribute name="href">#anchor_<xsl:value-of select="$id_hide_divname"/></xsl:attribute> 
        <xsl:attribute name="name">anchor_<xsl:value-of select="$id_hide_divname"/></xsl:attribute> 
        <xsl:attribute name="onclick">
          <xsl:value-of select="$javascript_onclick_code"
                        disable-output-escaping="yes"/>
        </xsl:attribute> 
        (-) Hide
      </xsl:element>

    </xsl:element>
    </ora_invisible>

  </xsl:template>

  <xsl:template name="show_table_header">
    <xsl:param name="element"    select=""/>
    <xsl:param name="heading1"   select=""/>
    <xsl:param name="heading2"   select=""/>
    <xsl:param name="heading3"   select=""/>
    <xsl:param name="heading4"   select=""/>
    <xsl:param name="heading5"   select=""/>
    <xsl:param name="heading6"   select=""/>
    <xsl:param name="heading7"   select=""/>
    <xsl:param name="heading8"   select=""/>
    <xsl:param name="heading9"   select=""/>
    <xsl:param name="heading10"  select=""/>

    <xsl:choose>
      <xsl:when test="count(child::*) = 0">
      <td>
      <div class="no_data_message">
          No data exists for this section of the report.
      </div>
      </td>
      </xsl:when>

      <xsl:otherwise>

      <xsl:if test="$heading1 != ''">
        <th>
          <xsl:value-of select="$heading1"/>
        </th>
      </xsl:if>
      <xsl:if test="$heading2 != ''">
      <th>
        <xsl:value-of select="$heading2"/>
      </th>
      </xsl:if>
      <xsl:if test="$heading3 != ''">
      <th>
        <xsl:value-of select="$heading3"/>
      </th>
      </xsl:if>
      <xsl:if test="$heading4 != ''">
      <th>
        <xsl:value-of select="$heading4"/>
      </th>
      </xsl:if>
      <xsl:if test="$heading5 != ''">
      <th>
        <xsl:value-of select="$heading5"/>
      </th>
      </xsl:if>
      <xsl:if test="$heading6 != ''">
      <th>
        <xsl:value-of select="$heading6"/>
      </th>
      </xsl:if>
      <xsl:if test="$heading7 != ''">
      <th>
        <xsl:value-of select="$heading7"/>
      </th>
      </xsl:if>
      <xsl:if test="$heading8 != ''">
      <th>
        <xsl:value-of select="$heading8"/>
      </th>
      </xsl:if>
      <xsl:if test="$heading9 != ''">
      <th>
        <xsl:value-of select="$heading9"/>
      </th>
      </xsl:if>
      <xsl:if test="$heading10 != ''">
      <th>
        <xsl:value-of select="$heading10"/>
      </th>
      </xsl:if>

      </xsl:otherwise>
    </xsl:choose>

  </xsl:template>

  <xsl:template name="show_1d_1row">
    <xsl:param name="prm1"          select=""/>
    <xsl:param name="prm2"          select=""/>
    <xsl:param name="prm3"          select=""/>
    <xsl:param name="prm4"          select=""/>
    <xsl:param name="prm5"          select=""/>
    <xsl:param name="prm6"          select=""/>
    <xsl:param name="count"         select=""/>
      <xsl:if test="$prm1 != ''">
      <td>
        <xsl:value-of select="$prm1"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm2 != ''">
      <td>
        <xsl:value-of select="$prm2"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm3 != ''">
      <td>
        <xsl:value-of select="$prm3"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm4 != ''">
      <td>
        <xsl:value-of select="$prm4"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm5 != ''">
      <td>
        <xsl:value-of select="$prm5"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm6 != ''">
      <td>
        <xsl:value-of select="$prm6"/>
      </td> 
      </xsl:if>
      <xsl:if test="$count != ''">
      <td align="right"> 
        <xsl:call-template name="ora_round">
          <xsl:with-param name="number"
                          select="$count * 100
                                  div
                                  /report/body/workload_profile/ash/total_ash_count"/>
          <xsl:with-param name="round_to"
                          select="2"/>
        </xsl:call-template>
      </td> 
      </xsl:if>
  </xsl:template>

  <xsl:template name="show_1d_rows">
    <xsl:param name="element"       select=""/>
    <xsl:param name="prm1"          select=""/>
    <xsl:param name="prm2"          select=""/>
    <xsl:param name="prm3"          select=""/>
    <xsl:param name="prm4"          select=""/>
    <xsl:param name="prm5"          select=""/>
    <xsl:param name="prm6"          select=""/>
    <xsl:param name="count"         select=""/>

    <xsl:for-each select="child::*[name() = $element and
                                   position() &lt; $max_count_plus1]">
      <xsl:variable name="odd_or_even" 
                    select="position() mod 2"/>
      <tr>
        <xsl:attribute name="class">
          row<xsl:value-of select="$odd_or_even"/>
        </xsl:attribute>

        <xsl:call-template name="show_1d_1row">
          <xsl:with-param name="prm1"          
                          select="attribute::*[name() = $prm1]"/>
          <xsl:with-param name="prm2"
                          select="attribute::*[name() = $prm2]"/>
          <xsl:with-param name="prm3"
                          select="attribute::*[name() = $prm3]"/>
          <xsl:with-param name="prm4"
                          select="attribute::*[name() = $prm4]"/>
          <xsl:with-param name="prm5"
                          select="attribute::*[name() = $prm5]"/>
          <xsl:with-param name="prm6"
                          select="attribute::*[name() = $prm6]"/>
          <xsl:with-param name="count"
                          select="attribute::*[name() = $count]"/>
        </xsl:call-template>

      </tr>
    </xsl:for-each>
  </xsl:template>

  <xsl:template name="show_2d_rows">
    <xsl:param name="element"       select=""/>
    <xsl:param name="prm1"          select=""/>
    <xsl:param name="prm2"          select=""/>
    <xsl:param name="prm3"          select=""/>
    <xsl:param name="prm4"          select=""/>
    <xsl:param name="prm5"          select=""/>
    <xsl:param name="prm6"          select=""/>
    <xsl:param name="count"         select=""/>
    <xsl:param name="delement"      select=""/>
    <xsl:param name="dprm1_heading" select=""/>
    <xsl:param name="dprm1"         select=""/>
    <xsl:param name="dprm2_heading" select=""/>
    <xsl:param name="dprm2"         select=""/>
    <xsl:param name="dprm3_heading" select=""/>
    <xsl:param name="dprm3"         select=""/>
    <xsl:param name="dprm4_heading" select=""/>
    <xsl:param name="dprm4"         select=""/>
    <xsl:param name="dprm5_heading" select=""/>
    <xsl:param name="dprm5"         select=""/>
    <xsl:param name="dprm6_heading" select=""/>
    <xsl:param name="dprm6"         select=""/>
    <xsl:param name="dcount_heading" select=""/>
    <xsl:param name="dcount"         select=""/>

    <xsl:for-each select="child::*[name() = $element and
                                   position() &lt; $max_count_plus1]">
      <xsl:variable name="odd_or_even" 
                    select="position() mod 2"/>
      <tr valign="top">

        <xsl:attribute name="class">
          row<xsl:value-of select="$odd_or_even"/>
        </xsl:attribute>

      <xsl:call-template name="show_1d_1row">
          <xsl:with-param name="prm1"          
                          select="attribute::*[name() = $prm1]"/>
          <xsl:with-param name="prm2"
                          select="attribute::*[name() = $prm2]"/>
          <xsl:with-param name="prm3"
                          select="attribute::*[name() = $prm3]"/>
          <xsl:with-param name="prm4"
                          select="attribute::*[name() = $prm4]"/>
          <xsl:with-param name="prm5"
                          select="attribute::*[name() = $prm5]"/>
          <xsl:with-param name="prm6"
                          select="attribute::*[name() = $prm6]"/>
          <xsl:with-param name="count"
                          select="attribute::*[name() = $count]"/>
      </xsl:call-template>

      <td>
        <table cellpadding="0" cellspacing="0" border="2" width="100%">
        <tr>
          <xsl:call-template name="show_table_header">
            <xsl:with-param name="heading1"      select="$dprm1_heading"/>
            <xsl:with-param name="heading2"      select="$dprm2_heading"/>
            <xsl:with-param name="heading3"      select="$dprm3_heading"/>
            <xsl:with-param name="heading4"      select="$dprm4_heading"/>
            <xsl:with-param name="heading5"      select="$dprm5_heading"/>
            <xsl:with-param name="heading6"      select="$dprm6_heading"/>
            <xsl:with-param name="heading7"      select="$dcount_heading"/>
          </xsl:call-template>
        </tr>

        <xsl:call-template name="show_1d_rows">
          <xsl:with-param name="element"       select="$delement"/>
          <xsl:with-param name="prm1"          select="$dprm1"/>
          <xsl:with-param name="prm2"          select="$dprm2"/>
          <xsl:with-param name="prm3"          select="$dprm3"/>
          <xsl:with-param name="prm4"          select="$dprm4"/>
          <xsl:with-param name="prm5"          select="$dprm5"/>
          <xsl:with-param name="prm6"          select="$dprm6"/>
          <xsl:with-param name="count"         select="$dcount"/>
        </xsl:call-template>

        </table>
      </td>

      </tr>
    </xsl:for-each>

  </xsl:template>

  <xsl:template name="show_divergence_row">
    <xsl:param name="prm1"          select=""/>
    <xsl:param name="prm2"          select=""/>
    <xsl:param name="prm3"          select=""/>
    <xsl:param name="prm4"          select=""/>
    <xsl:param name="prm5"          select=""/>
    <xsl:param name="prm6"          select=""/>
    <xsl:param name="count"         select=""/>
    <xsl:param name="first_occur"   select=""/>
    <xsl:param name="last_occur"    select=""/>
      <xsl:if test="$prm1 != ''">
      <td>
        <xsl:value-of select="$prm1"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm2 != ''">
      <td>
        <xsl:value-of select="$prm2"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm3 != ''">
      <td>
        <xsl:value-of select="$prm3"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm4 != ''">
      <td>
        <xsl:value-of select="$prm4"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm5 != ''">
      <td>
        <xsl:value-of select="$prm5"/>
      </td> 
      </xsl:if>
      <xsl:if test="$prm6 != ''">
      <td>
        <xsl:value-of select="$prm6"/>
      </td> 
      </xsl:if>
      <td> 
        <xsl:value-of select="$count"/>
      </td> 
      <xsl:if test="$first_occur != ''">
      <td> 
        <xsl:value-of select="$first_occur"/>
      </td> 
      </xsl:if>
      <xsl:if test="$last_occur != ''">
      <td> 
        <xsl:value-of select="$last_occur"/>
      </td>
      </xsl:if>
  </xsl:template>

</xsl:stylesheet>
