set define off
set verify off
set serveroutput on size 1000000
set feedback off
begin wwv_flow.g_import_in_progress := true; end; 
/
 
 
--application/set_environment
prompt  APPLICATION 4411 - APEX  - System Messages
--
-- Application Export:
--   Application:     4411
--   Name:            APEX  - System Messages
--   Date and Time:   07:46 Tuesday May 19, 2009
--   Exported By:     
--   Flashback:       0
--   Export Type:     Application Export
--   Version: 3.2.1.00.08
 
-- Import:
--   Using application builder
--   or
--   Using SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
 
-- Application Statistics:
--   Pages:                 1
--     Items:               0
--     Computations:        0
--     Validations:         0
--     Processes:           0
--     Regions:             1
--     Buttons:             0
--   Shared Components
--     Breadcrumbs:         0
--        Entries           0
--     Items:               0
--     Computations:        0
--     Processes:           0
--     Parent Tabs:         0
--     Tab Sets:            0
--        Tabs:             0
--     NavBars:             0
--     Lists:               0
--     Shortcuts:           0
--     Themes:              1
--     Templates:
--        Page:             9
--        List:            14
--        Report:           7
--        Label:            5
--        Region:          21
--     Messages:        3,706
--     Build Options:       0
 
 
--       AAAA       PPPPP   EEEEEE  XX      XX
--      AA  AA      PP  PP  EE       XX    XX
--     AA    AA     PP  PP  EE        XX  XX
--    AAAAAAAAAA    PPPPP   EEEE       XXXX
--   AA        AA   PP      EE        XX  XX
--  AA          AA  PP      EE       XX    XX
--  AA          AA  PP      EEEEEE  XX      XX
prompt  Set Credentials...
 
begin
 
  -- Assumes you are running the script connected to SQL*Plus as the Oracle user APEX_030200 or as the owner (parsing schema) of the application.
  wwv_flow_api.set_security_group_id(p_security_group_id=>10);
 
end;
/

begin wwv_flow.g_import_in_progress := true; end;
/
begin 

select value into wwv_flow_api.g_nls_numeric_chars from nls_session_parameters where parameter='NLS_NUMERIC_CHARACTERS';

end;

/
begin execute immediate 'alter session set nls_numeric_characters=''.,''';

end;

/
begin wwv_flow.g_browser_language := 'en-us'; end;
/
prompt  Check Compatibility...
 
begin
 
-- This date identifies the minimum version required to import this file.
wwv_flow_api.set_version(p_version_yyyy_mm_dd=>'2009.01.12');
 
end;
/

prompt  Set Application ID...
 
begin
 
   -- SET APPLICATION ID
   wwv_flow.g_flow_id := 4411;
   wwv_flow_api.g_id_offset := 0;
null;
 
end;
/

--application/delete_application
 
begin
 
   -- Remove Application
wwv_flow_api.remove_flow(4411);
 
end;
/

 
begin
 
wwv_flow_audit.remove_audit_trail(4411);
null;
 
end;
/

--application/create_application
 
begin
 
wwv_flow_api.create_flow(
  p_id    => 4411,
  p_display_id=> 4411,
  p_owner => 'APEX_030200',
  p_name  => 'APEX  - System Messages',
  p_alias => '4411',
  p_application_group=>91050719712959059,
  p_application_group_name=>'APEX Product',
  p_application_group_comment=>'Applications shipped with the APEX product distribution',
  p_page_view_logging => 'YES',
  p_default_page_template=> 91626406749381989 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=> 91626529080381989 + wwv_flow_api.g_id_offset,
  p_default_region_template=> 91632832228382001 + wwv_flow_api.g_id_offset,
  p_error_template    => 91626406749381989 + wwv_flow_api.g_id_offset,
  p_charset           => 'utf-8',
  p_checksum_salt_last_reset => '20090519073429',
  p_max_session_length_sec=> 28800,
  p_home_link         => 'f?p=4411:1:&SESSION.',
  p_flow_language     => 'en-us',
  p_flow_language_derived_from=> 'BROWSER',
  p_flow_image_prefix => '/i/',
  p_documentation_banner=> 'Developers:'||chr(10)||
''||chr(10)||
'Michael Hichwa, Joel Kallman, Sergio Leunissen, Christina Cho, Scott Spadafore, Marc Sewtz, Jason Straub, Tyler Muth, Raj Mattamal, Sharon Kennedy, Carl Backstrom, Kris Rice, Syme Kutz, Karen Ryan, Scott Spendolini, Terri Winters.'||chr(10)||
''||chr(10)||
'Contributors:'||chr(10)||
''||chr(10)||
'William Dwight, Tim Hoechst, Thomas Kyte, Chris Beck, David Bliss, Jason Rhodes, Sean Dillon, Ken Jacobs, Darcy Menard, Sudha Kannan.',
  p_authentication    => 'CUSTOM2',
  p_login_url         => '',
  p_logout_url        => '',
  p_application_tab_set=> 1,
  p_public_url_prefix => '',
  p_public_user       => 'APEX_PUBLIC_USER',
  p_dbauth_url_prefix => '',
  p_proxy_server      => '',
  p_cust_authentication_process=> '.'||to_char(91645213681389498 + wwv_flow_api.g_id_offset)||'.',
  p_cust_authentication_page=> '',
  p_custom_auth_login_url=> '',
  p_flow_version      => '&PRODUCT_NAME. 3.2.1.00.08',
  p_flow_status       => 'AVAILABLE_W_EDIT_LINK',
  p_flow_unavailable_text=> 'This application is currently unavailable.',
  p_build_status      => 'RUN_AND_BUILD',
  p_exact_substitutions_only=> 'Y',
  p_vpd               => '',
  p_rejoin_existing_sessions   => 'N',
  p_theme_id => 1,
  p_default_label_template => 91641225667382016 + wwv_flow_api.g_id_offset,
  p_default_report_template => 91638400927382012 + wwv_flow_api.g_id_offset,
  p_default_list_template => 91636711305382010 + wwv_flow_api.g_id_offset,
  p_default_menu_template => 91641814330382017 + wwv_flow_api.g_id_offset,
  p_default_button_template => 91626823864381990 + wwv_flow_api.g_id_offset,
  p_default_chart_template => 91631622717381999 + wwv_flow_api.g_id_offset,
  p_default_form_template => 91630725782381998 + wwv_flow_api.g_id_offset,
  p_default_wizard_template => 91632204784382001 + wwv_flow_api.g_id_offset,
  p_default_tabform_template => 91632832228382001 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>91632832228382001 + wwv_flow_api.g_id_offset,
  p_default_menur_template => 91633105066382001 + wwv_flow_api.g_id_offset,
  p_default_listr_template => 91627727983381992 + wwv_flow_api.g_id_offset,
  p_last_updated_by => '',
  p_last_upd_yyyymmddhh24miss=> '20090518132449',
  p_required_roles=> wwv_flow_utilities.string_to_table2(''));
 
 
end;
/

prompt  ...authorization schemes
--
 
begin
 
null;
 
end;
/

--application/shared_components/navigation/navigation_bar
prompt  ...navigation bar entries
--
 
begin
 
null;
 
end;
/

prompt  ...application processes
--
prompt  ...application items
--
prompt  ...application level computations
--
 
begin
 
null;
 
end;
/

prompt  ...Application Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Application Parent Tabs
--
 
begin
 
null;
 
end;
/

prompt  ...Shared Lists of values
--
prompt  ...Application Trees
--
--application/pages/page_groups
prompt  ...page groups
--
 
begin
 
null;
 
end;
/

 
--application/pages/page_00001
prompt  ...PAGE 1: Messages
--
 
begin
 
declare
    h varchar2(32767) := null;
    ph varchar2(32767) := null;
begin
h := null;
ph := null;
wwv_flow_api.create_page(
  p_id     => 1,
  p_flow_id=> wwv_flow.g_flow_id,
  p_tab_set=> '',
  p_name   => 'Messages',
  p_step_title=> 'Messages',
  p_step_sub_title_type => 'TEXT_WITH_SUBSTITUTIONS',
  p_first_item=> 'AUTO_FIRST_ITEM',
  p_include_apex_css_js_yn=>'Y',
  p_autocomplete_on_off => '',
  p_help_text => '',
  p_html_page_header => '',
  p_step_template => 91626406749381989+ wwv_flow_api.g_id_offset,
  p_required_patch=> null + wwv_flow_api.g_id_offset,
  p_last_updated_by => 'CBCHO',
  p_last_upd_yyyymmddhh24miss => '20071120070419',
  p_page_is_public_y_n=> 'N',
  p_page_comment  => '');
 
end;
 
end;
/

declare
  s varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
s:=s||'<h1>APEX Development</h1>'||chr(10)||
'<p>'||chr(10)||
'This application is used to manage APEX system messages.  Click Shared components, then click messages.'||chr(10)||
'</p>';

wwv_flow_api.create_page_plug (
  p_id=> 91624704892377483 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_page_id=> 1,
  p_plug_name=> 'System Messages',
  p_region_name=>'',
  p_plug_template=> 0,
  p_plug_display_sequence=> 10,
  p_plug_display_column=> 1,
  p_plug_display_point=> 'AFTER_SHOW_ITEMS',
  p_plug_source=> s,
  p_plug_source_type=> 'STATIC_TEXT',
  p_translate_title=> 'Y',
  p_plug_display_error_message=> '#SQLERRM#',
  p_plug_query_row_template=> 1,
  p_plug_query_headings_type=> 'QUERY_COLUMNS',
  p_plug_query_num_rows_type => 'NEXT_PREVIOUS_LINKS',
  p_plug_query_row_count_max => 500,
  p_plug_query_show_nulls_as => ' - ',
  p_plug_display_condition_type => '',
  p_pagination_display_position=>'BOTTOM_RIGHT',
  p_plug_customized=>'0',
  p_plug_caching=> 'NOT_CACHED',
  p_plug_comment=> '');
end;
/
 
begin
 
null;
 
end;
/

 
begin
 
null;
 
end;
/

 
begin
 
---------------------------------------
-- ...updatable report columns for page 1
--
 
begin
 
null;
end;
null;
 
end;
/

prompt  ...lists
--
--application/shared_components/navigation/breadcrumbs
prompt  ...breadcrumbs
--
prompt  ...page templates for application: 4411
--
--application/shared_components/user_interface/templates/page/login
prompt  ......Page template 91625820476381987
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><br /></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO#</td>'||chr(10)||
'    <td align="right" valign="top"><br /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br /></td>'||chr(10)||
' ';

c3:=c3||'   <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">';

c3:=c3||'#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_03##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625820476381987 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Login',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0"',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_template_comment => '18');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs
prompt  ......Page template 91625930032381988
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src=';

c3:=c3||'"#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle"><br />#REGION_POSITION_01#</td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table class="t1PageBody" cellpadding="0" cellspacing="0" border="0" summary="" width="100%" height="70%">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1PageCenter" valign="top"><table summary="" cellpadd';

c3:=c3||'ing="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_template(
  p_id=> 91625930032381988 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1Notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs
prompt  ......Page template 91626019499381988
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td align="right" class="t1topbarLeft"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table border="0" cellpadding="0" cellspacing="0" su';

c3:=c3||'mmary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign';

c3:=c3||'="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626019499381988 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/two_level_tabs_with_side_bar
prompt  ......Page template 91626101050381989
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#PARENT_TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/';

c3:=c3||'top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20">#TAB_CELLS#</td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td v';

c3:=c3||'align="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1Pag';

c3:=c3||'eBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626101050381989 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Two Level Tabs with Side Bar',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<span class="t1ChildTab">[&nbsp;#TAB_LABEL#&nbsp;]</span>#TAB_INLINE_EDIT#',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<a href="#TAB_LINK#" class="t1ChildTab">#TAB_LABEL#</a>#TAB_INLINE_EDIT#',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs_with_side_bar
prompt  ......Page template 91626232237381989
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/t';

c3:=c3||'heme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table';

c3:=c3||'></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REGION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="t';

c3:=c3||'op" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626232237381989 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs with Side Bar',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t2notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/no_tabs_with_side_bar
prompt  ......Page template 91626321000381989
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_far_left.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" colspan="2"  valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_1.png" alt="" /></td>'||chr(10)||
'    <td align="right" class="t1topbarLeft" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_barleft2_2.png" alt="" /></td>'||chr(10)||
'    <td class';

c3:=c3||'="t1topbarMiddle" valign="top"><table height="100%" cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="20"><br /></td></tr><tr><td valign="bottom" height="20">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td class="t1PageLeft" colspan="3" align="left" valign="top">#REG';

c3:=c3||'ION_POSITION_02#</td>'||chr(10)||
'    <td><br /></td>'||chr(10)||
'    <td class="t1PageRight" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody"><div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03';

c3:=c3||'#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626321000381989 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'No Tabs with Side Bar',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> 'summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_sidebar_def_reg_pos => 'REGION_POSITION_02',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/one_level_tabs
prompt  ......Page template 91626406749381989
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/theme_1/bot_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1user">&APP_USER.</div></td>'||chr(10)||
'    <td class="t1BotbarMiddle"><div id="t1copy"><!-- Copyright Here --><span class="t1Customize">#CUSTOMIZE#</span></div></td>'||chr(10)||
'    <td><img src="#IMAGE_PREFIX#themes/th';

c2:=c2||'eme_1/bot_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<br />'||chr(10)||
'#REGION_POSITION_05#'||chr(10)||
'#FORM_CLOSE# '||chr(10)||
'</body>'||chr(10)||
'</html>';

c3:=c3||'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top" class="t1Logo">#LOGO##REGION_POSITION_06#</td>'||chr(10)||
'	<td valign="top" width="100%">#REGION_POSITION_07#</td>'||chr(10)||
'    <td align="right" valign="top">#NAVIGATION_BAR##REGION_POSITION_08#</td>'||chr(10)||
'  </tr>'||chr(10)||
'</table>'||chr(10)||
'<table width="100%" cellpadding="0" cellspacing="0" border="0" summary="" height="70%">'||chr(10)||
'  <tr>'||chr(10)||
'    ';

c3:=c3||'<td colspan="5" class="t1ParentTabHolder"><table border="0" cellpadding="0" cellspacing="0" summary="" align="right"><tr><td><br /></td>#TAB_CELLS#</tr></table></td>'||chr(10)||
'  </tr>'||chr(10)||
'  <tr>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_left.png" alt="" /></td>'||chr(10)||
'    <td class="t1topbarMiddle" valign="bottom"><table cellpadding="0" cellspacing="0" border="0" summary=""><tr><td height="50';

c3:=c3||'%"><br /></td></tr><tr><td height="50%">#REGION_POSITION_01#</td></tr></table></td>'||chr(10)||
'    <td valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/top_bar_right.png" alt="" /></td>'||chr(10)||
'  </tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><br /></td>'||chr(10)||
'<td class="t1PageCenter" colspan="2" valign="top" height="100%"><table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top" class="t1PageBody">';

c3:=c3||'<div class="t1messages">#GLOBAL_NOTIFICATION##SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_02##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626406749381989 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'One Level Tabs',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOn">#TAB_LABEL##TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_on_right.png" border="0" alt="" /></td>'||chr(10)||
''||chr(10)||
'',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_left.png" border="0" alt="" /></td>'||chr(10)||
'<td class="t1ParentTabCenterOff"><a href="#TAB_LINK#">#TAB_LABEL#</a>#TAB_INLINE_EDIT#</td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/tab_off_right.png" border="0" alt="" /></td>'||chr(10)||
'',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '<div class="t1NavigationBar">#BAR_BODY#</div>',
  p_navbar_entry=> '<a href="#LINK#" class="t1NavigationBar">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_breadcrumb_def_reg_pos => 'REGION_POSITION_01',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comment => '12');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/printer_friendly
prompt  ......Page template 91626529080381989
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top">'||chr(10)||
'<div style="border:1px solid black;">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>'||chr(10)||
'#BOX_BODY##REGION_POSITION_04#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626529080381989 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Printer Friendly',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '',
  p_navigation_bar=> '',
  p_navbar_entry=> '',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_template_comment => '3');
end;
 
null;
 
end;
/

--application/shared_components/user_interface/templates/page/popup
prompt  ......Page template 91626623032381989
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
c1:=c1||'<html lang="&BROWSER_LANGUAGE." xmlns:htmldb="http://htmldb.oracle.com">'||chr(10)||
'<head>'||chr(10)||
'<title>#TITLE#</title>'||chr(10)||
'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V3.css" type="text/css" />'||chr(10)||
'#HEAD#'||chr(10)||
'</head>'||chr(10)||
'<body #ONLOAD#>#FORM_OPEN#';

c2:=c2||'#FORM_CLOSE#</body>'||chr(10)||
'</html>';

c3:=c3||'<table summary="" cellpadding="0" width="100%" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td width="100%" valign="top"><div class="t1messages">#SUCCESS_MESSAGE##NOTIFICATION_MESSAGE#</div>#BOX_BODY##REGION_POSITION_01##REGION_POSITION_02##REGION_POSITION_04##REGION_POSITION_05##REGION_POSITION_06##REGION_POSITION_07##REGION_POSITION_08#</td>'||chr(10)||
'<td valign="top">#REGION_POSITION_03#<br /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_template(
  p_id=> 91626623032381989 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=> 'Popup',
  p_body_title=> '',
  p_header_template=> c1,
  p_box=> c3,
  p_footer_template=> c2,
  p_success_message=> '<div class="t1success">#SUCCESS_MESSAGE#</div>',
  p_current_tab=> '',
  p_current_tab_font_attr=> '',
  p_non_current_tab=> '',
  p_non_current_tab_font_attr => '',
  p_top_current_tab=> '',
  p_top_current_tab_font_attr => '',
  p_top_non_curr_tab=> '',
  p_top_non_curr_tab_font_attr=> '',
  p_current_image_tab=> '',
  p_non_current_image_tab=> '',
  p_notification_message=> '<div class="t1notification">#MESSAGE#</div>',
  p_navigation_bar=> '#BAR_BODY#',
  p_navbar_entry=> '<a href="#LINK#">#TEXT#</a>',
  p_app_tab_before_tabs=>'',
  p_app_tab_current_tab=>'',
  p_app_tab_non_current_tab=>'',
  p_app_tab_after_tabs=>'',
  p_region_table_cattributes=> ' summary="" cellpadding="0" border="0" cellspacing="0" width="100%"',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_template_comment => '');
end;
 
null;
 
end;
/

prompt  ...button templates
--
--application/shared_components/user_interface/templates/button/button
prompt  ......Button Template 91626823864381990
declare
  t varchar2(32767) := null;
  l_clob clob;
  l_length number := 1;
begin
t:=t||'<table class="t1Button" cellspacing="0" cellpadding="0" border="0"  summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_left.gif" alt="" width="4" height="24" /></a></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#">#LABEL#</a></td>'||chr(10)||
'<td class="t1R"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/theme_1/button_right.gif" width="4" height="24" alt="" /></a></td>'||chr(10)||
'</tr';

t:=t||'>'||chr(10)||
'</table>';

wwv_flow_api.create_button_templates (
  p_id=>91626823864381990 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_template=>t,
  p_template_name=> 'Button',
  p_translate_this_template => 'N',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_template_comment       => '');
end;
/
---------------------------------------
prompt  ...region templates
--
--application/shared_components/user_interface/templates/region/report_list
prompt  ......region template 91627404948381991
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr>'||chr(10)||
'<td valign="top"><img src="#';

t:=t||'IMAGE_PREFIX#themes/theme_1/report.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627404948381991 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Report List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627404948381991 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_list
prompt  ......region template 91627727983381992
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ListRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" ><tr><td valign="top"><img src="#I';

t:=t||'MAGE_PREFIX#themes/theme_1/chart.gif" alt=""/></td>'||chr(10)||
'<td>#BODY#</td></tr></table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91627727983381992 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart List',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 29,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91627727983381992 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_title
prompt  ......region template 91628005149381992
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1RegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628005149381992 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 11,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628005149381992 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/hide_and_show_region
prompt  ......region template 91628313436381993
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1HideandShowRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#<a style="margin-left:5px;" href="javascript:hideShow(''region#REGION_SEQUENCE_ID#'',''shIMG#REGION_SEQUENCE_ID#'',''#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif'',''#IMAG';

t:=t||'E_PREFIX#themes/theme_1/rollup_minus_dgray.gif'');" class="t1HideandShowRegionLink"><img src="#IMAGE_PREFIX#themes/theme_1/rollup_plus_dgray.gif" '||chr(10)||
'  id="shIMG#REGION_SEQUENCE_ID#" alt="" /></a></td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body"><div class="t1Hide" id="region#REGION_SEQU';

t:=t||'ENCE_ID#">#BODY#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628313436381993 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Hide and Show Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Gray Head, white body');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628313436381993 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_without_title
prompt  ......region template 91628622914381993
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithoutTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td></tr>'||chr(10)||
'</table>'||chr(10)||
'#BODY#';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628622914381993 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region without Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628622914381993 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/region_without_buttons_and_titles
prompt  ......region template 91628912641381993
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table summary="" cellpadding="0" cellspacing="0" border="0" class="t1RegionwithoutButtonsandTitles" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
''||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91628912641381993 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Region without Buttons and Titles',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91628912641381993 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_alternative_1
prompt  ......region template 91629226514381996
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629226514381996 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region, Alternative 1',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 10,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629226514381996 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/borderless_region
prompt  ......region template 91629526498381997
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BorderlessRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629526498381997 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Borderless Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content without a border.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629526498381997 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/button_region_with_title
prompt  ......region template 91629802954381997
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ButtonRegionwithTitle" id="#REGION_ID#">'||chr(10)||
'<tr><td class="t1RegionHeader">#TITLE#</td></tr>'||chr(10)||
'<tr><td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##CREATE2##COPY##EXPAND##HELP#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /';

t:=t||'></td></tr>'||chr(10)||
'</table>#BODY#'||chr(10)||
'';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91629802954381997 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Button Region with Title',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91629802954381997 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region_alternative_1
prompt  ......region template 91630115446381997
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegionAlternative1" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="';

t:=t||'10" height="20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630115446381997 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region, Alternative 1',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630115446381997 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/sidebar_region
prompt  ......region template 91630411450381997
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellspacing="0" cellpadding="0" border="0" class="t1SidebarRegion" summary="" id="#REGION_ID#" align="right">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/left_curve.gif" width="10" height="20" alt="" /></td>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1EndCaps" valign="top"><img src="#IMAGE_PREFIX#themes/theme_1/right_curve.gif" width="10" height="';

t:=t||'20" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table><br />';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630411450381997 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Sidebar Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => '<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tl_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'          <td bgcolor="#000000" height="1"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="2" valign="top" width="4" bgcolor="#FF0000"><img src="#IMAGE_PREFIX#tr_img.gif" border="0" width="4" height="18" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#FF0000" height="16">'||chr(10)||
'            <table border="0" cellpadding="0" cellspacing="0" width="100%">'||chr(10)||
'              <tr>'||chr(10)||
'                <td align=middle valign="top">'||chr(10)||
'                  <div align="center">'||chr(10)||
'                     <font color="#ffffff" face="Arial, Helvetica, sans-serif" size="1">'||chr(10)||
'                      <b>#TITLE# </b></font></div>'||chr(10)||
'                </td>'||chr(10)||
'              </tr>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'<table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'   <tr>'||chr(10)||
'   <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'   <td valign="top" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="146" height="1" border="0" alt="" /><br />'||chr(10)||
'            <table border="0" cellpadding="1" cellspacing="0" width="146" summary="">'||chr(10)||
'              <tr>'||chr(10)||
'                <td colspan="2">'||chr(10)||
'                  <table border="0" cellpadding="2" cellspacing="0" width="124" summary="">'||chr(10)||
'                    <tr>'||chr(10)||
'                      <td>&nbsp;</td>'||chr(10)||
'                      <td valign="top" width="106">'||chr(10)||
'                        <P><FONT face="arial, helvetica" size="1">'||chr(10)||
'                            #BODY#'||chr(10)||
'                           </font>'||chr(10)||
'                        </P>'||chr(10)||
'                      </td>'||chr(10)||
'                    </tr>'||chr(10)||
'                  </table>'||chr(10)||
'            </table>'||chr(10)||
'          </td>'||chr(10)||
'          <td bgcolor="#000000" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="96"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'      </table>'||chr(10)||
'      <table border="0" cellpadding="0" cellspacing="0">'||chr(10)||
'        <tr>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#bl_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'          <td bgcolor="#ffffff" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="142" height="1" border="0" alt="" /></td>'||chr(10)||
'          <td rowspan="4" valign="top" width="4"><img src="#IMAGE_PREFIX#br_img.gif" border="0" width="4" height="6" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#000000" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#9a9c9a" width="1"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'        <tr>'||chr(10)||
'          <td bgcolor="#b3b4b3" width="1" height="2"><img src="#IMAGE_PREFIX#stretch.gif" width="1" height="1" border="0" alt="" /></td>'||chr(10)||
'        </tr>'||chr(10)||
'</table>'||chr(10)||
'');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630411450381997 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/form_region
prompt  ......region template 91630725782381998
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1FormRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="400" alt="" /><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CH';

t:=t||'ANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#<img src="#IMAGE_PREFIX#/themes/theme_1/1px_trans.gif" height="1" width="600" style="display:block;" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91630725782381998 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Form Region',
  p_plug_table_bgcolor     => '#f7f7e7',
  p_theme_id  => 1,
  p_theme_class_id => 8,
  p_plug_heading_bgcolor => '#f7f7e7',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91630725782381998 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region_alternative_1
prompt  ......region template 91631001900381998
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1NavigationRegionAlternative1" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631001900381998 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region, Alternative 1',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 16,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631001900381998 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region_with_icon
prompt  ......region template 91631304733381999
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegionwithIcon" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2"><table summary="" cellpadding="0" cellspacing="0" border="0">'||chr(10)||
'<tr>'||chr(10)||
'<td valign="top"><img src=';

t:=t||'"#IMAGE_PREFIX#themes/theme_1/wizard_icon.gif" alt=""/></td>'||chr(10)||
'<td width="100%" valign="top">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631304733381999 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region with Icon',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631304733381999 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/chart_region
prompt  ......region template 91631622717381999
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ChartRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td><table width="100%" cellpadding="0" cellspacing="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body">#BODY#</td';

t:=t||'>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631622717381999 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Chart Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 30,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631622717381999 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/bracketed_region
prompt  ......region template 91631925531382001
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1BracketedRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##COPY##CREATE##CREATE2##EXPAND##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td colspan="2"><table cellpadding="0" cellspacing="0" border="0" summary="" width="100%">'||chr(10)||
'<tr>'||chr(10)||
'<td class=';

t:=t||'"t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td rowspan="3" class="t1Body">#BODY#</td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'<td><img src="#IMAGE_PREFIX#themes/the';

t:=t||'me_1/1px_trans.gif" height="1" width="1" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'<td class="t1bracket"><img src="" height="5" width="1" alt="#IMAGE_PREFIX#themes/theme_1/1px_trans.gif" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91631925531382001 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Bracketed Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template when you want to contain content with a bracket UI.'||chr(10)||
''||chr(10)||
'TITLE=YES'||chr(10)||
'BUTTONS=YES'||chr(10)||
'100% WIDTH=NO');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91631925531382001 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/wizard_region
prompt  ......region template 91632204784382001
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1WizardRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632204784382001 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Wizard Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 12,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632204784382001 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region_100_width
prompt  ......region template 91632529189382001
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion100Width" width="100%" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632529189382001 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region 100% Width',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632529189382001 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/reports_region
prompt  ......region template 91632832228382001
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ReportsRegion" id="#REGION_ID#">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1RegionHeader">#TITLE#</td>'||chr(10)||
'<td class="t1ButtonHolder">#CLOSE#&nbsp;&nbsp;&nbsp;#PREVIOUS##NEXT##DELETE##EDIT##CHANGE##CREATE##HELP#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1Body" colspan="2">#BODY#</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91632832228382001 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Reports Region',
  p_plug_table_bgcolor     => '#ffffff',
  p_theme_id  => 1,
  p_theme_class_id => 9,
  p_plug_heading_bgcolor => '#ffffff',
  p_plug_font_size => '-1',
  p_translate_this_template => 'N',
  p_template_comment       => 'Red Theme');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91632832228382001 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/breadcrumb_region
prompt  ......region template 91633105066382001
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1BreadcrumbRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633105066382001 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Breadcrumb Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => 'Use this region template to contain breadcrumb menus.  Breadcrumb menus are implemented using breadcrumbs.  Breadcrumb menus are designed to displayed in #REGION_POSITION_01#');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633105066382001 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/region/navigation_region
prompt  ......region template 91633419116382002
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_length number := 1;
begin
t:=t||'<div class="t1NavigationRegion" id="#REGION_ID#">#BODY#</div>';

t2 := null;
wwv_flow_api.create_plug_template (
  p_id       => 91633419116382002 + wwv_flow_api.g_id_offset,
  p_flow_id  => wwv_flow.g_flow_id,
  p_template => t,
  p_page_plug_template_name=> 'Navigation Region',
  p_plug_table_bgcolor     => '',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_plug_heading_bgcolor => '',
  p_plug_font_size => '',
  p_translate_this_template => 'N',
  p_template_comment       => '');
end;
null;
 
end;
/

 
begin
 
declare
    t2 varchar2(32767) := null;
begin
t2 := null;
wwv_flow_api.set_plug_template_tab_attr (
  p_id=> 91633419116382002 + wwv_flow_api.g_id_offset,
  p_form_table_attr=> t2 );
exception when others then null;
end;
null;
 
end;
/

prompt  ...List Templates
--
--application/shared_components/user_interface/templates/list/dhtml_list_image_with_sublist
prompt  ......list template 91633715033382002
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# / alt=""></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t2:=t2||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_nochild.gif" width="22" height="75" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t3:=t3||'<li class="dhtmlMenuSep"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt=""  class="dhtmlMenuSep" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t6:=t6||'<div class="dhtmlMenuItem"><a href="#LINK#"><img src="#IMAGE_PREFIX#themes/generic_list.gif" #IMAGE_ATTR# alt="" / ></a><img src="#IMAGE_PREFIX#themes/generic_open.gif" width="22" height="75" class="dhtmlMenu" onclick="app_AppMenuMultiOpenBottom(this,''#LIST_ITEM_ID#'',false)" alt="" / ><a href="#LINK#" class="dhtmlBottom">#TEXT#</a></div>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif"  alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91633715033382002 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML List (Image) with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 21,
  p_list_template_before_rows=>'<div class="dhtmlMenuLG">',
  p_list_template_after_rows=>'</div><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;"><li class="dhtmlSubMenuP" onmouseover="dhtml_CloseAllSubMenusL(this)">#PARENT_TEXT#</li>',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_menu_with_sublist
prompt  ......list template 91634003460382007
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li class="dhtmlMenuItem"><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li class="dhtmlMenuSep2"><img src="#IMAGE_PREFIX#themes/theme_13/1px_trans.gif"  width="1" height="1" alt="" class="dhtmlMenuSep2" /></li>';

t4:=t4||'<li><a href="#LINK#" class="dhtmlSubMenuN" onmouseover="dhtml_CloseAllSubMenusL(this)">#TEXT#</a></li>';

t5:=t5||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t6:=t6||'<li class="dhtmlMenuItem1"><a href="#LINK#">#TEXT#</a><img src="#IMAGE_PREFIX#themes/theme_13/menu_small.gif" alt="Expand" onclick="app_AppMenuMultiOpenBottom2(this,''#LIST_ITEM_ID#'',false)" /></li>';

t7:=t7||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" /></a></li>';

t8:=t8||'<li class="dhtmlSubMenuS"><a href="#LINK#" class="dhtmlSubMenuS" onmouseover="dhtml_MenuOpen(this,''#LIST_ITEM_ID#'',true,''Left'')"><span style="float:left;">#TEXT#</span><img class="t13MIMG" src="#IMAGE_PREFIX#menu_open_right2.gif" alt="" / ></a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634003460382007 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Menu with Sublist',
  p_theme_id  => 1,
  p_theme_class_id => 20,
  p_list_template_before_rows=>'<ul class="dhtmlMenuLG2">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" class="dhtmlSubMenu2" style="display:none;">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/dhtml_tree
prompt  ......list template 91634310642382007
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif" align="middle"  alt="" /><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><img src="#IMAGE_PREFIX#themes/theme_13/node.gif"  align="middle" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" align="middle"  onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><img src="#IMAGE_PREFIX#themes/theme_13/plus.gif" onclick="htmldb_ToggleWithImage(this,''#LIST_ITEM_ID#'')" align="middle" class="pseudoButtonInactive" alt="" /><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91634310642382007 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'DHTML Tree',
  p_theme_id  => 1,
  p_theme_class_id => 22,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#" style="display:none;" class="dhtmlTree">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/wizard_progress_list
prompt  ......list template 91634602833382007
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td><div class="t1current">#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t2:=t2||'<tr><td><div>#TEXT#</div><img src="#IMAGE_PREFIX#themes/theme_1/arrow_down.gif" alt="Down" /></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634602833382007 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Wizard Progress List',
  p_theme_id  => 1,
  p_theme_class_id => 17,
  p_list_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="" class="t1WizardProgressList">',
  p_list_template_after_rows=>'<tr><td>&DONE.</td></tr>'||chr(10)||
'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_ordered_list
prompt  ......list template 91634920736382008
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91634920736382008 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Ordered List',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_list_template_before_rows=>'<ol class="t1VerticalOrderedList">',
  p_list_template_after_rows=>'</ol>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/button_list
prompt  ......list template 91635207728382008
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left_hl.gif" alt="" /></td>'||chr(10)||
'<td class="t1C"><a href="#LINK#" style="color:#FFFFFF;">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right_hl.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t2:=t2||'<table class="t1ButtonList" cellspacing="0" cellpadding="0" border="0" summary="">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1L"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_left.gif" alt="" /></td>'||chr(10)||
'<td class="t1NC"><a href="#LINK#">#TEXT#</a></td>'||chr(10)||
'<td class="t1R"><img src="#IMAGE_PREFIX#/themes/theme_1/list_button_right.gif" alt="" /></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635207728382008 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Button List',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_list_template_before_rows=>'<div class="t1ButtonList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_links_list
prompt  ......list template 91635520047382008
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1current">#TEXT#</a>';

t2:=t2||'<a href="#LINK#">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635520047382008 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Links List',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_list_template_before_rows=>'<div class="t1HorizontalLinksList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_images_list
prompt  ......list template 91635830396382009
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<tr><td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</td></tr>';

t2:=t2||'<tr><td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / >#TEXT#</a></td></tr>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91635830396382009 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Images List',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_list_template_before_rows=>'<table cellpadding="0" cellspacing="0" border="0" summary="0" class="t1VerticalImagesList">',
  p_list_template_after_rows=>'</table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_sidebar_list
prompt  ......list template 91636106164382009
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<a href="#LINK#" class="t1navcurrent">#TEXT#</a>';

t2:=t2||'<a href="#LINK#" class="t1nav">#TEXT#</a>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636106164382009 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Sidebar List',
  p_theme_id  => 1,
  p_theme_class_id => 19,
  p_list_template_before_rows=>'<div class="t1VerticalSidebarList">',
  p_list_template_after_rows=>'</div>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_without_bullet
prompt  ......list template 91636400543382009
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636400543382009 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List without Bullet',
  p_theme_id  => 1,
  p_theme_class_id => 18,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithoutBullet">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/vertical_unordered_list_with_bullets
prompt  ......list template 91636711305382010
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li class="t1current">#TEXT#</li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91636711305382010 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Vertical Unordered List with Bullets',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_list_template_before_rows=>'<ul class="t1VerticalUnorderedListwithBullets">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/tabbed_navigation_list
prompt  ......list template 91637003772382010
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a class="t1current" href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637003772382010 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Tabbed Navigation List',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_list_template_before_rows=>'<ul class="t1TabbedNavigationList">',
  p_list_template_after_rows=>'</ul>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/hierarchical_expanded
prompt  ......list template 91637324450382010
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<li><a href="#LINK#">#TEXT#</a></li>';

t2:=t2||'<li><a href="#LINK#">#TEXT#</a></li>';

t3:=t3||'<li><a href="#LINK#">#TEXT#</a></li>';

t4:=t4||'<li><a href="#LINK#">#TEXT#</a></li>';

t5:=t5||'<li><a href="#LINK#">#TEXT#</a></li>';

t6:=t6||'<li><a href="#LINK#">#TEXT#</a></li>';

t7:=t7||'<li><a href="#LINK#">#TEXT#</a></li>';

t8:=t8||'<li><a href="#LINK#">#TEXT#</a></li>';

wwv_flow_api.create_list_template (
  p_id=>91637324450382010 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Hierarchical Expanded',
  p_theme_id  => 1,
  p_theme_class_id => 23,
  p_list_template_before_rows=>'<ul class="dhtmlTree">',
  p_list_template_after_rows=>'</ul><br style="clear:both;"/><br style="clear:both;"/>',
  p_before_sub_list=>'<ul id="#PARENT_LIST_ITEM_ID#" htmldb:listlevel="#LEVEL#">',
  p_after_sub_list=>'</ul>',
  p_sub_list_item_current=> t3,
  p_sub_list_item_noncurrent=> t4,
  p_item_templ_curr_w_child=> t5,
  p_item_templ_noncurr_w_child=> t6,
  p_sub_templ_curr_w_child=> t7,
  p_sub_templ_noncurr_w_child=> t8,
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/list/horizontal_images_with_label_list
prompt  ......list template 91637614810382010
 
begin
 
declare
  t varchar2(32767) := null;
  t2 varchar2(32767) := null;
  t3 varchar2(32767) := null;
  t4 varchar2(32767) := null;
  t5 varchar2(32767) := null;
  t6 varchar2(32767) := null;
  t7 varchar2(32767) := null;
  t8 varchar2(32767) := null;
  l_clob clob;
  l_clob2 clob;
  l_clob3 clob;
  l_clob4 clob;
  l_clob5 clob;
  l_clob6 clob;
  l_clob7 clob;
  l_clob8 clob;
  l_length number := 1;
begin
t:=t||'<td class="t1current"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ><br />#TEXT#</td>';

t2:=t2||'<td><a href="#LINK#"><img src="#IMAGE_PREFIX##IMAGE#" #IMAGE_ATTR# alt="" / ></a><br /><a href="#LINK#">#TEXT#</a></td>';

t3 := null;
t4 := null;
t5 := null;
t6 := null;
t7 := null;
t8 := null;
wwv_flow_api.create_list_template (
  p_id=>91637614810382010 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_list_template_current=>t,
  p_list_template_noncurrent=> t2,
  p_list_template_name=>'Horizontal Images with Label List',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_list_template_before_rows=>'<table cellspacing="0" cellpadding="0" border="0" class="t1HorizontalImageswithLabelList" summary=""><tr>',
  p_list_template_after_rows=>'</tr></table>',
  p_translate_this_template => 'N',
  p_list_template_comment=>'');
end;
null;
 
end;
/

prompt  ...report templates
--
--application/shared_components/user_interface/templates/report/one_column_unordered_list
prompt  ......report template 91637905071382010
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<li>#COLUMN_VALUE#</li>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91637905071382010 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'One Column Unordered List',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><ul class="t1OneColumnUnorderedList">',
  p_row_template_after_rows =>'</ul><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'NOT_CONDITIONAL',
  p_row_template_display_cond2=>'NOT_CONDITIONAL',
  p_row_template_display_cond3=>'NOT_CONDITIONAL',
  p_row_template_display_cond4=>'NOT_CONDITIONAL',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91637905071382010 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'OMIT');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard
prompt  ......report template 91638400927382012
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638400927382012 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91638400927382012 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_alternating_row_colors
prompt  ......report template 91638924547382013
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td class="t1data"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c2:=c2||'<td class="t1dataalt"#ALIGNMENT#>#COLUMN_VALUE#</td>';

c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91638924547382013 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard, Alternating Row Colors',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table border="0" cellpadding="0" cellspacing="0" summary="" class="t1standardalternatingrowcolors">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'OMIT',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'ODD_ROW_NUMBERS',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'ODD_ROW_NUMBERS',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 5,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/standard_ppr
prompt  ......report template 91639203883382013
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639203883382013 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Standard (PPR)',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<div id="report#REGION_ID#"><htmldb:#REGION_ID#><table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" border="0" cellspacing="0" summary="" class="t1standard">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>'||chr(10)||
'<script language=JavaScript type=text/javascript>'||chr(10)||
'<!--'||chr(10)||
'init_htmlPPRReport(''#REGION_ID#'');'||chr(10)||
''||chr(10)||
'//-->'||chr(10)||
'</script>'||chr(10)||
'</htmldb:#REGION_ID#>'||chr(10)||
'</div>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="javascript:html_PPR_Report_Page(this,''#REGION_ID#'',''#LINK#'')"  class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 7,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639203883382013 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/horizontal_border
prompt  ......report template 91639730548382014
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91639730548382014 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Horizontal Border',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table cellpadding="0" cellspacing="0" border="0" class="t1HorizontalBorder" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th#ALIGNMENT# id="#COLUMN_HEADER_NAME#" class="t1header">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>'||chr(10)||
'',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91639730548382014 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/value_attribute_pairs
prompt  ......report template 91640211522382014
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<tr><th class="t1header">#COLUMN_HEADER#</th><td class="t1data">#COLUMN_VALUE#</td></tr>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640211522382014 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Value Attribute Pairs',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr><td><table cellpadding="0" cellspacing="0" border="0" summary="" class="t1ValueAttributePairs">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td></tr>#PAGINATION#</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_theme_id  => 1,
  p_theme_class_id => 6,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640211522382014 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'OMIT',
  p_row_template_after_last =>'<tr><td colspan="2" class="t1seperate"><hr /></td></tr>');
exception when others then null;
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/report/borderless
prompt  ......report template 91640708921382015
 
begin
 
declare
  c1 varchar2(32767) := null;
  c2 varchar2(32767) := null;
  c3 varchar2(32767) := null;
  c4 varchar2(32767) := null;
begin
c1:=c1||'<td#ALIGNMENT# headers="#COLUMN_HEADER_NAME#" class="t1data">#COLUMN_VALUE#</td>';

c2 := null;
c3 := null;
c4 := null;
wwv_flow_api.create_row_template (
  p_id=> 91640708921382015 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_row_template_name=> 'Borderless',
  p_row_template1=> c1,
  p_row_template_condition1=> '',
  p_row_template2=> c2,
  p_row_template_condition2=> '',
  p_row_template3=> c3,
  p_row_template_condition3=> '',
  p_row_template4=> c4,
  p_row_template_condition4=> '',
  p_row_template_before_rows=>'<table cellpadding="0" border="0" cellspacing="0" summary="">'||chr(10)||
'#TOP_PAGINATION#'||chr(10)||
'<tr>'||chr(10)||
'<td><table class="t1borderless" cellpadding="0" border="0" cellspacing="0" summary="">',
  p_row_template_after_rows =>'</table><div class="t1CVS">#EXTERNAL_LINK##CSV_LINK#</div></td>'||chr(10)||
'</tr>'||chr(10)||
'#PAGINATION#'||chr(10)||
'</table>',
  p_row_template_table_attr =>'',
  p_row_template_type =>'GENERIC_COLUMNS',
  p_column_heading_template=>'<th class="t1header"#ALIGNMENT# id="#COLUMN_HEADER_NAME#">#COLUMN_HEADER#</th>',
  p_row_template_display_cond1=>'0',
  p_row_template_display_cond2=>'0',
  p_row_template_display_cond3=>'0',
  p_row_template_display_cond4=>'0',
  p_next_page_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_page_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS#</a>',
  p_next_set_template=>'<a href="#LINK#" class="t1pagination">#PAGINATION_NEXT_SET#<img src="#IMAGE_PREFIX#themes/theme_1/paginate_next.gif" alt="Next"></a>',
  p_previous_set_template=>'<a href="#LINK#" class="t1pagination"><img src="#IMAGE_PREFIX#themes/theme_1/paginate_prev.gif" alt="Previous">#PAGINATION_PREVIOUS_SET#</a>',
  p_row_style_checked=>'#CCCCCC',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_row_template_comment=> '');
end;
null;
 
end;
/

 
begin
 
begin
wwv_flow_api.create_row_template_patch (
  p_id => 91640708921382015 + wwv_flow_api.g_id_offset,
  p_row_template_before_first =>'<tr #HIGHLIGHT_ROW#>',
  p_row_template_after_last =>'</tr>');
exception when others then null;
end;
null;
 
end;
/

prompt  ...label templates
--
--application/shared_components/user_interface/templates/label/optional_with_help
prompt  ......label template 91641225667382016
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641225667382016 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><a class="t1OptionalwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/no_label
prompt  ......label template 91641313897382017
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641313897382017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'No Label',
  p_template_body1=>'<span class="t1NoLabel">',
  p_template_body2=>'</span>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 13,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/optional
prompt  ......label template 91641421336382017
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641421336382017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Optional',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><span class="t1Optional">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required_with_help
prompt  ......label template 91641529261382017
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641529261382017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required with help',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><a class="t1RequiredwithHelp" href="javascript:popupFieldHelp(''#CURRENT_ITEM_ID#'',''&SESSION.'')" tabindex="999">',
  p_template_body2=>'</a></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/label/required
prompt  ......label template 91641600810382017
 
begin
 
begin
wwv_flow_api.create_field_template (
  p_id=> 91641600810382017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_template_name=>'Required',
  p_template_body1=>'<label for="#CURRENT_ITEM_NAME#" tabindex="999"><img src="#IMAGE_PREFIX#themes/theme_1/required.gif" alt="Required Field Icon" tabindex="999" /><span class="t1Required">',
  p_template_body2=>'</span></label>',
  p_on_error_before_label=>'<div class="t1InlineError">',
  p_on_error_after_label=>'<br/>#ERROR_MESSAGE#</div>',
  p_theme_id  => 1,
  p_theme_class_id => 4,
  p_translate_this_template=> 'N',
  p_template_comment=> '');
end;
null;
 
end;
/

prompt  ...breadcrumb templates
--
--application/shared_components/user_interface/templates/breadcrumb/hierarchical_menu
prompt  ......template 91641730492382017
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641730492382017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Hierarchical Menu',
  p_before_first=>'<ul class="t1HierarchicalMenu">',
  p_current_page_option=>'<li class="t1current">#NAME#</li>',
  p_non_current_page_option=>'<li><a href="#LINK#">#NAME#</a></li>',
  p_menu_link_attributes=>'',
  p_between_levels=>'',
  p_after_last=>'</ul>',
  p_max_levels=>11,
  p_start_with_node=>'CHILD_MENU',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/breadcrumb/breadcrumb_menu
prompt  ......template 91641814330382017
 
begin
 
begin
wwv_flow_api.create_menu_template (
  p_id=> 91641814330382017 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_name=>'Breadcrumb Menu',
  p_before_first=>'<div class="t1BreadcrumbMenu">',
  p_current_page_option=>'<span class="t1current">#NAME#</span>',
  p_non_current_page_option=>'<a href="#LINK#">#NAME#</a>',
  p_menu_link_attributes=>'',
  p_between_levels=>'&nbsp;&gt;&nbsp;',
  p_after_last=>'</div>',
  p_max_levels=>12,
  p_start_with_node=>'PARENT_TO_LEAF',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_template_comments=>'');
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/popuplov
prompt  ...popup list of values templates
--
prompt  ......template 91642503902382024
 
begin
 
begin
wwv_flow_api.create_popup_lov_template (
  p_id=> 91642503902382024 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_popup_icon=>'#IMAGE_PREFIX#list_gray.gif',
  p_popup_icon_attr=>'width="13" height="13" alt="Popup Lov"',
  p_popup_icon2=>'',
  p_popup_icon_attr2=>'',
  p_page_name=>'winlov',
  p_page_title=>'Search Dialog',
  p_page_html_head=>'<link rel="stylesheet" href="#IMAGE_PREFIX#themes/theme_1/theme_V2.css" type="text/css">'||chr(10)||
'',
  p_page_body_attr=>'onload="first_field()" style="margin:0;"',
  p_before_field_text=>'<div class="t1PopupHead">',
  p_page_heading_text=>'',
  p_page_footer_text =>'',
  p_filter_width     =>'20',
  p_filter_max_width =>'100',
  p_filter_text_attr =>'',
  p_find_button_text =>'Search',
  p_find_button_image=>'',
  p_find_button_attr =>'',
  p_close_button_text=>'Close',
  p_close_button_image=>'',
  p_close_button_attr=>'',
  p_next_button_text =>'Next >',
  p_next_button_image=>'',
  p_next_button_attr =>'',
  p_prev_button_text =>'< Previous',
  p_prev_button_image=>'',
  p_prev_button_attr =>'',
  p_after_field_text=>'</div>',
  p_scrollbars=>'1',
  p_resizable=>'1',
  p_width =>'400',
  p_height=>'450',
  p_result_row_x_of_y=>'<br /><div style="padding:2px; font-size:8pt;">Row(s) #FIRST_ROW# - #LAST_ROW#</div>',
  p_result_rows_per_pg=>500,
  p_before_result_set=>'<div class="t1PopupBody">',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_translate_this_template => 'N',
  p_after_result_set   =>'</div>');
end;
null;
 
end;
/

prompt  ...calendar templates
--
--application/shared_components/user_interface/templates/calendar/small_calendar
prompt  ......template 91641910982382018
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91641910982382018 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Small Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#DY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallCalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="1" summary="" class="t1SmallCalendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallWeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br />#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="1" summary="0" class="t1SmallWeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1SmallDayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="1" summary="0" class="t1SmallDayCalendar">',
  p_daily_month_close_format => '</table></td></tr></table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 3,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar
prompt  ......template 91642102481382020
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642102481382020 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarHolder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1Calendar">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarHolder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="0" summary="0" class="t1WeekCalendar">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="0" summary="0" class="t1DayCalendar">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 1,
  p_reference_id=> null);
end;
null;
 
end;
/

--application/shared_components/user_interface/templates/calendar/calendar_alternative_1
prompt  ......template 91642303533382020
 
begin
 
begin
wwv_flow_api.create_calendar_template(
  p_id=> 91642303533382020 + wwv_flow_api.g_id_offset,
  p_flow_id=> wwv_flow.g_flow_id,
  p_cal_template_name=>'Calendar, Alternative 1',
  p_translate_this_template=> 'N',
  p_day_of_week_format=> '<th valign="bottom" class="t1DayOfWeek">#IDAY#</th>',
  p_month_title_format=> '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1CalendarAlternative1Holder"> '||chr(10)||
' <tr>'||chr(10)||
'   <td class="t1MonthTitle">#IMONTH# #YYYY#</td>'||chr(10)||
' </tr>'||chr(10)||
' <tr>'||chr(10)||
' <td>',
  p_month_open_format=> '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1CalendarAlternative1">',
  p_month_close_format=> '</table></td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'',
  p_day_title_format=> '<div class="t1DayTitle">#DD#</div>',
  p_day_open_format=> '<td class="t1Day" valign="top" height="100" height="100">',
  p_day_close_format=> '</td>',
  p_today_open_format=> '<td valign="top" class="t1Today">',
  p_weekend_title_format=> '<div class="t1WeekendDayTitle">#DD#</div>',
  p_weekend_open_format => '<td valign="top" class="t1WeekendDay">',
  p_weekend_close_format => '</td>',
  p_nonday_title_format => '<div class="t1NonDayTitle">#DD#</div>',
  p_nonday_open_format => '<td class="t1NonDay" valign="top">',
  p_nonday_close_format => '</td>',
  p_week_title_format => '',
  p_week_open_format => '<tr>',
  p_week_close_format => '</tr> ',
  p_daily_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarHolder"> <tr> <td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td> </tr> <tr> <td>',
  p_daily_open_format => '<tr>',
  p_daily_close_format => '</tr>',
  p_weekly_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1WeekCalendarAlternative1Holder">'||chr(10)||
'<tr>'||chr(10)||
'<td class="t1MonthTitle" id="test">#WTITLE#</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>',
  p_weekly_day_of_week_format => '<th class="t1DayOfWeek">#IDAY#<br>#MM#/#DD#</th>',
  p_weekly_month_open_format => '<table border="0" cellpadding="0" cellspacing="2" summary="0" class="t1WeekCalendarAlternative1">',
  p_weekly_month_close_format => '</table></td></tr></table>',
  p_weekly_day_title_format => '',
  p_weekly_day_open_format => '<td class="t1Day" valign="top">',
  p_weekly_day_close_format => '<br /></td>',
  p_weekly_today_open_format => '<td class="t1Today" valign="top">',
  p_weekly_weekend_title_format => '',
  p_weekly_weekend_open_format => '<td valign="top" class="t1NonDay">',
  p_weekly_weekend_close_format => '<br /></td>',
  p_weekly_time_open_format => '<th class="t1Hour">',
  p_weekly_time_close_format => '<br /></th>',
  p_weekly_time_title_format => '#TIME#',
  p_weekly_hour_open_format => '<tr>',
  p_weekly_hour_close_format => '</tr>',
  p_daily_day_of_week_format => '<th class="t1DayOfWeek">#IDAY# #DD#/#MM#</th>',
  p_daily_month_title_format => '<table cellspacing="0" cellpadding="0" border="0" summary="" class="t1DayCalendarAlternative1Holder"> <tr><td class="t1MonthTitle">#IMONTH# #DD#, #YYYY#</td></tr><tr><td>'||chr(10)||
'',
  p_daily_month_open_format => '<table border="0" cellpadding="2" cellspacing="2" summary="0" class="t1DayCalendarAlternative1">',
  p_daily_month_close_format => '</table></td> </tr> </table>',
  p_daily_day_title_format => '',
  p_daily_day_open_format => '<td valign="top" class="t1Day">',
  p_daily_day_close_format => '<br /></td>',
  p_daily_today_open_format => '<td valign="top" class="t1Today">',
  p_daily_time_open_format => '<th class="t1Hour">',
  p_daily_time_close_format => '<br /></th>',
  p_daily_time_title_format => '#TIME#',
  p_daily_hour_open_format => '<tr>',
  p_daily_hour_close_format => '</tr>',
  p_theme_id  => 1,
  p_theme_class_id => 2,
  p_reference_id=> null);
end;
null;
 
end;
/

prompt  ...application themes
--
--application/shared_components/user_interface/themes/red
prompt  ......theme 91642708702382024
begin
wwv_flow_api.create_theme (
  p_id =>91642708702382024 + wwv_flow_api.g_id_offset,
  p_flow_id =>wwv_flow.g_flow_id,
  p_theme_id  => 1,
  p_theme_name=>'Red',
  p_default_page_template=>91626406749381989 + wwv_flow_api.g_id_offset,
  p_error_template=>91626406749381989 + wwv_flow_api.g_id_offset,
  p_printer_friendly_template=>91626529080381989 + wwv_flow_api.g_id_offset,
  p_breadcrumb_display_point=>'REGION_POSITION_01',
  p_sidebar_display_point=>'REGION_POSITION_02',
  p_login_template=>91625820476381987 + wwv_flow_api.g_id_offset,
  p_default_button_template=>91626823864381990 + wwv_flow_api.g_id_offset,
  p_default_region_template=>91632832228382001 + wwv_flow_api.g_id_offset,
  p_default_chart_template =>91631622717381999 + wwv_flow_api.g_id_offset,
  p_default_form_template  =>91630725782381998 + wwv_flow_api.g_id_offset,
  p_default_reportr_template   =>91632832228382001 + wwv_flow_api.g_id_offset,
  p_default_tabform_template=>91632832228382001 + wwv_flow_api.g_id_offset,
  p_default_wizard_template=>91632204784382001 + wwv_flow_api.g_id_offset,
  p_default_menur_template=>91633105066382001 + wwv_flow_api.g_id_offset,
  p_default_listr_template=>91627727983381992 + wwv_flow_api.g_id_offset,
  p_default_report_template   =>91638400927382012 + wwv_flow_api.g_id_offset,
  p_default_label_template=>91641225667382016 + wwv_flow_api.g_id_offset,
  p_default_menu_template=>91641814330382017 + wwv_flow_api.g_id_offset,
  p_default_calendar_template=>91642102481382020 + wwv_flow_api.g_id_offset,
  p_default_list_template=>91636711305382010 + wwv_flow_api.g_id_offset,
  p_default_option_label=>91641225667382016 + wwv_flow_api.g_id_offset,
  p_default_required_label=>91641529261382017 + wwv_flow_api.g_id_offset);
end;
/
 
prompt  ...build options used by application 4411
--
 
begin
 
null;
 
end;
/

--application/shared_components/globalization/messages
prompt  ...messages used by application: 4411
--
prompt  ......Message master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master Detail';

wwv_flow_api.create_message (
  p_id=>1271527567810900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit %0';

wwv_flow_api.create_message (
  p_id=>1272629907830432 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_EDIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message master_detail_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Detail';

wwv_flow_api.create_message (
  p_id=>1273802941851037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MASTER_DETAIL_DETAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_empty_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You cannot edit an empty SQL script.';

wwv_flow_api.create_message (
  p_id=>1312817603958878 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_EMPTY_SCRIPT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sw_greater_than_30k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You cannot edit script greater than 30,000 bytes.';

wwv_flow_api.create_message (
  p_id=>1313326953961572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SW_GREATER_THAN_30K',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create master detail pages with the following attributes. Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>1807521688165980 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MASTER_DETAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_3_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Three page master detail';

wwv_flow_api.create_message (
  p_id=>1818612871276983 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.3_PAGE_MASTER_DETAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_2_page_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Two page master detail';

wwv_flow_api.create_message (
  p_id=>1819119104278786 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.2_PAGE_MASTER_DETAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master Table';

wwv_flow_api.create_message (
  p_id=>1819830532282011 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master Display Column(s)';

wwv_flow_api.create_message (
  p_id=>1820208846285276 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DISPLAY_COLUMNS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail Table';

wwv_flow_api.create_message (
  p_id=>1820614733286910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail Display Column(s)';

wwv_flow_api.create_message (
  p_id=>1821022698289204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLUMNS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigate master record by';

wwv_flow_api.create_message (
  p_id=>1821400320292291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_SORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_include_master_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Include master report?';

wwv_flow_api.create_message (
  p_id=>1821807592294307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INCLUDE_MASTER_REPORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_master_detail_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Master Detail Layout';

wwv_flow_api.create_message (
  p_id=>1822214518296327 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MASTER_DETAIL_LAYOUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_master_detail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create master detail page. %0';

wwv_flow_api.create_message (
  p_id=>2401917549947375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_MASTER_DETAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_sql_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valid';

wwv_flow_api.create_message (
  p_id=>2435903555544446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_SQL_VALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_code_compiled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Code successfully compiled';

wwv_flow_api.create_message (
  p_id=>2436202536544449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_CODE_COMPILED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Static Reference';

wwv_flow_api.create_message (
  p_id=>2481916523923367 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dynamic Reference';

wwv_flow_api.create_message (
  p_id=>2482320333924478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Failed to parse SQL query:'||chr(10)||
'<p>%0</p>'||chr(10)||
'<p>%1</p>'||chr(10)||
'Certain queries can only be executed when running your application, if your query appears syntactically correct, you can save your query without validation (see options below query source).';

wwv_flow_api.create_message (
  p_id=>2953401799093358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid chart query: %0<br><br>'||chr(10)||
'Use the following syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text that goes with the bar</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>Numeric column that defines bar size</td></tr>'||chr(10)||
'</table>'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>2958109427171268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Flash Chart';

wwv_flow_api.create_message (
  p_id=>3080521800886749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.FLASH_CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page zero components are shared over all pages within an application.';

wwv_flow_api.create_message (
  p_id=>3267030017882614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ZERO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Builder';

wwv_flow_api.create_message (
  p_id=>4659903166223659 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILDER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Home';

wwv_flow_api.create_message (
  p_id=>4660510092225697 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message nav_app_builder_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigate to the Application Builder home page';

wwv_flow_api.create_message (
  p_id=>4683114491444583 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAV_APP_BUILDER_HOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_nav
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Express Home';

wwv_flow_api.create_message (
  p_id=>4685131422496765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_NAV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>4803109192360849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a Flash chart page with the following attributes. Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>5019508618462728 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FLASH_CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Group';

wwv_flow_api.create_message (
  p_id=>5148603366407413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_GROUP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form';

wwv_flow_api.create_message (
  p_id=>5373709776864896 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_sga_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error while setting new SGA target. %0';

wwv_flow_api.create_message (
  p_id=>5517322027678913 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_SGA_TARGET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_xe_config_set_pga_agg_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error while setting new PGA aggregate target. %0';

wwv_flow_api.create_message (
  p_id=>5590417429371347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_XE_CONFIG.SET_PGA_AGG_TARGET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View All Page Groups';

wwv_flow_api.create_message (
  p_id=>5692917266320002 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE GROUPS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_all_page_types
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View All Page Types';

wwv_flow_api.create_message (
  p_id=>5694020167330300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW ALL PAGE TYPES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_pages_of_this_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View pages of this type';

wwv_flow_api.create_message (
  p_id=>5752219264916088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_PAGES_OF_THIS_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page 0';

wwv_flow_api.create_message (
  p_id=>5825203972474852 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_ZERO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset_4000
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Reset';

wwv_flow_api.create_message (
  p_id=>5845819303536058 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET_4000',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message blank
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Blank';

wwv_flow_api.create_message (
  p_id=>5910016279942038 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BLANK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_page_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit Page Group';

wwv_flow_api.create_message (
  p_id=>5961703297676406 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT PAGE GROUP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - Layout';

wwv_flow_api.create_message (
  p_id=>6165132766856070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Processing your request, please wait';

wwv_flow_api.create_message (
  p_id=>7646519991882620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_pool
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Shared Pool';

wwv_flow_api.create_message (
  p_id=>7691321432337239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED POOL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buffer_cache
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Buffer Cache';

wwv_flow_api.create_message (
  p_id=>7691925242338300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUFFER CACHE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Other';

wwv_flow_api.create_message (
  p_id=>7692428705339319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OTHER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message navigation_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigation Page';

wwv_flow_api.create_message (
  p_id=>7731807202589607 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NAVIGATION_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Breadcrumbs';

wwv_flow_api.create_message (
  p_id=>7736108821793101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_MENUS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lists';

wwv_flow_api.create_message (
  p_id=>7736904103801199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_page_groups
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Manage Page Groups';

wwv_flow_api.create_message (
  p_id=>7749009626940369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE PAGE GROUPS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No lists used.';

wwv_flow_api.create_message (
  p_id=>7760503336895556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_menus
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Breadcrumbs used.';

wwv_flow_api.create_message (
  p_id=>7761507491896772 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_MENUS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p374_pos_5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pos.5';

wwv_flow_api.create_message (
  p_id=>7839310130588292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P374.POS.5',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reassign_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Reassign Pages';

wwv_flow_api.create_message (
  p_id=>7896209998918062 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REASSIGN_PAGES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message static_html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Static HTML';

wwv_flow_api.create_message (
  p_id=>7907222474997295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STATIC_HTML',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_must_be_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The password for this account must be changed.';

wwv_flow_api.create_message (
  p_id=>8161512663886891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MUST_BE_CHANGED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Dynamic Form';

wwv_flow_api.create_message (
  p_id=>8483313274523015 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apex_wizard_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigation Form';

wwv_flow_api.create_message (
  p_id=>8485712413560636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEX_WIZARD_FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_htmldb_user_guide
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Builder User''s Guide';

wwv_flow_api.create_message (
  p_id=>8548528577832833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.HTMLDB_USER_GUIDE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 Day Developer';

wwv_flow_api.create_message (
  p_id=>8549314856838395 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DEV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_2_day_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'2 Day DBA';

wwv_flow_api.create_message (
  p_id=>8549824552841148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.2_DAY_DBA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_referential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Referential';

wwv_flow_api.create_message (
  p_id=>8662002623439149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_REFERENTIAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message inactive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inactive';

wwv_flow_api.create_message (
  p_id=>8804725089048621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INACTIVE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1220_script_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Results of %0, run %1';

wwv_flow_api.create_message (
  p_id=>8942925019019788 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1220_SCRIPT_RESULT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dml_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DML Form';

wwv_flow_api.create_message (
  p_id=>9200522165667512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DML_FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This item is needed for Get Next or Previous Primary Key Value process.';

wwv_flow_api.create_message (
  p_id=>9275804960632165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This button is needed for Get Next or Previous Primary Key Value process.';

wwv_flow_api.create_message (
  p_id=>9279405222651106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Get Next or Previous Primary Key Value';

wwv_flow_api.create_message (
  p_id=>9293304754717218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_show_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show/Hide Columns';

wwv_flow_api.create_message (
  p_id=>9295405496503444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_SHOW_COLS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_remove_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Remove';

wwv_flow_api.create_message (
  p_id=>9295919348507481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_REMOVE_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join_hint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Click here to select column for join';

wwv_flow_api.create_message (
  p_id=>9296531469510943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN_HINT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run Get Next or Previous Primary Key Value process.';

wwv_flow_api.create_message (
  p_id=>9312418653749676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_get_next_or_prev_pk_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to get next or previous primary key value. %0';

wwv_flow_api.create_message (
  p_id=>9335300046801064 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.GET_NEXT_OR_PREV_PK_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_form_control_check_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Check your process definition again. %0';

wwv_flow_api.create_message (
  p_id=>9339227058808865 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORM_CONTROL.CHECK_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_stmt_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Statement processed.';

wwv_flow_api.create_message (
  p_id=>9525312362919889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.STMT_PROCESSED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deinstall Script';

wwv_flow_api.create_message (
  p_id=>9745431570194925 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Column';

wwv_flow_api.create_message (
  p_id=>9768218827164295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_COLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alias';

wwv_flow_api.create_message (
  p_id=>9769223806175173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_ALIAS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Object';

wwv_flow_api.create_message (
  p_id=>9769730386177026 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OBJECT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Condition';

wwv_flow_api.create_message (
  p_id=>9770107314179814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_CONDITION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sort Type';

wwv_flow_api.create_message (
  p_id=>9770515280182137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_sort_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sort Order';

wwv_flow_api.create_message (
  p_id=>9771224630184824 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_SORT_ORDER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_output
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show';

wwv_flow_api.create_message (
  p_id=>9771831902186993 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_OUTPUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Function';

wwv_flow_api.create_message (
  p_id=>9772910562190200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_FUNCTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_clone_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Group By';

wwv_flow_api.create_message (
  p_id=>9773819913192934 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_CLONE_GROUP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message file_too_big
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This text file is too large to edit. To change the content, you must edit the file on your local machine and upload it again.';

wwv_flow_api.create_message (
  p_id=>9947229840693675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FILE_TOO_BIG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_total_sessions2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Total Sessions: %0';

wwv_flow_api.create_message (
  p_id=>10370229736979001 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_TOTAL_SESSIONS2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_prefs_exists_for2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Preferences exist for %1 users';

wwv_flow_api.create_message (
  p_id=>10376412599011993 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_PREFS_EXISTS_FOR2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_to_create_tablespace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create the tablespace at this time.  Please try again later.';

wwv_flow_api.create_message (
  p_id=>10629322413967513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_TO_CREATE_TABLESPACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid query, no select statement found';

wwv_flow_api.create_message (
  p_id=>10732429433808116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY_REQUIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_join
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Join';

wwv_flow_api.create_message (
  p_id=>10964410371662927 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_JOIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'to';

wwv_flow_api.create_message (
  p_id=>10964702537670191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_TO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_1002_qb_max_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A maximum of 60 columns may be selected.';

wwv_flow_api.create_message (
  p_id=>11155203668127634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_1002_QB_MAX_COLS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message application_x
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application %0';

wwv_flow_api.create_message (
  p_id=>11212531906149315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APPLICATION_X',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_executing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Executing';

wwv_flow_api.create_message (
  p_id=>11883124508481828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.EXECUTING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message clear_command
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Clear Command';

wwv_flow_api.create_message (
  p_id=>12272112996747369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CLEAR_COMMAND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message find_tables
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Find Tables';

wwv_flow_api.create_message (
  p_id=>12272820961749624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FIND_TABLES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_get_next_prev_pk_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Are you sure you want to leave this page without saving?';

wwv_flow_api.create_message (
  p_id=>12313530078134639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.GET_NEXT_PREV_PK_SHORTCUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message download
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Download';

wwv_flow_api.create_message (
  p_id=>12363527035828372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DOWNLOAD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_for_printing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View for Printing';

wwv_flow_api.create_message (
  p_id=>12364907904841704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_FOR_PRINTING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_developer_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Developer Privilege';

wwv_flow_api.create_message (
  p_id=>12448003249747214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DEVELOPER_PRIV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password Valid';

wwv_flow_api.create_message (
  p_id=>12449306890786107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_VALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password Expired';

wwv_flow_api.create_message (
  p_id=>12449711392787388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_EXPIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_completed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Completed';

wwv_flow_api.create_message (
  p_id=>12617010562857360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.COMPLETED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_in_progress
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In Progress';

wwv_flow_api.create_message (
  p_id=>12617824068861274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.IN_PROGRESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 row.';

wwv_flow_api.create_message (
  p_id=>12622714305028750 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_result_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 rows.';

wwv_flow_api.create_message (
  p_id=>12623718938039553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RESULT_ROWS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_elapsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 seconds';

wwv_flow_api.create_message (
  p_id=>12625022879050187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ELAPSED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Developer Defined';

wwv_flow_api.create_message (
  p_id=>12749202396995794 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SCHEME_DESC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Normal, successful authentication';

wwv_flow_api.create_message (
  p_id=>12751723006039634 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_SUCCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unknown User Name';

wwv_flow_api.create_message (
  p_id=>12752130279041717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_USER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Account Locked';

wwv_flow_api.create_message (
  p_id=>12752503051043328 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_LOCKED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_account_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Account Expired';

wwv_flow_api.create_message (
  p_id=>12752907900044741 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ACCOUNT_EXPIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_incorrect
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Incorrect Password';

wwv_flow_api.create_message (
  p_id=>12753318289047745 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_INCORRECT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_password_first_use
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password First Use';

wwv_flow_api.create_message (
  p_id=>12753725561049781 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_PASSWORD_FIRST_USE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_attempts_exceeded
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Maximum Login Attempts Exceeded';

wwv_flow_api.create_message (
  p_id=>12754102836052690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_ATTEMPTS_EXCEEDED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_internal_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unknown Internal Error';

wwv_flow_api.create_message (
  p_id=>12754509762054706 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_INTERNAL_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Site Administration';

wwv_flow_api.create_message (
  p_id=>12757112327140649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_LOGIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace Login';

wwv_flow_api.create_message (
  p_id=>12757517521142166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE_LOGIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Access Control Administration Page';

wwv_flow_api.create_message (
  p_id=>13038822941882315 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_confirm_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create Table';

wwv_flow_api.create_message (
  p_id=>13047625590949379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CONFIRM_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Administration';

wwv_flow_api.create_message (
  p_id=>13164129717423676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_ADMIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Full access to all, access control list not used.';

wwv_flow_api.create_message (
  p_id=>13164713572428457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Restricted access. Only users defined in the access control list are allowed.';

wwv_flow_api.create_message (
  p_id=>13165400543434154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Public read only. Edit and administrative privileges controlled by access control list.';

wwv_flow_api.create_message (
  p_id=>13166015088438389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_mode4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administrative access only.';

wwv_flow_api.create_message (
  p_id=>13166623100469024 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_MODE4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Identify how access to this application will be controlled.';

wwv_flow_api.create_message (
  p_id=>13167215958476490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Mode';

wwv_flow_api.create_message (
  p_id=>13167830503480662 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_set_app_mode
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Set Application Mode';

wwv_flow_api.create_message (
  p_id=>13168516436486095 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_SET_APP_MODE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dbaccount_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Database Account';

wwv_flow_api.create_message (
  p_id=>13168625276730447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DBACCOUNT_AUTH_SCHEME_DESC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Access Control List';

wwv_flow_api.create_message (
  p_id=>13169100290490889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ldap_auth_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP';

wwv_flow_api.create_message (
  p_id=>13169617011756491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LDAP_AUTH_SCHEME_DESC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Username';

wwv_flow_api.create_message (
  p_id=>13169925917498281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USERNAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Privilege';

wwv_flow_api.create_message (
  p_id=>13170831374518767 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_PRIV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administrator';

wwv_flow_api.create_message (
  p_id=>13171516960524093 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_last_changed_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Last Changed By';

wwv_flow_api.create_message (
  p_id=>13174505447539669 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_LAST_CHANGED_BY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_find_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enter case insensitive query criteria, then press the <b>Go</b> button.';

wwv_flow_api.create_message (
  p_id=>13175605925549284 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_FIND_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_get_app_mode_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to get application administration mode.';

wwv_flow_api.create_message (
  p_id=>13183519140007243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_GET_APP_MODE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No privilege for attempted action.';

wwv_flow_api.create_message (
  p_id=>13188211353042819 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_NO_PRIV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to process set application mode request.';

wwv_flow_api.create_message (
  p_id=>13190231008067472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_app_mode_set_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Mode Set.';

wwv_flow_api.create_message (
  p_id=>13190621789074218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_APP_MODE_SET_SUCCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_util_invalid_proxy_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The printing engine could not be reached because either the URL specified is incorrect or a proxy URL needs to be specified.';

wwv_flow_api.create_message (
  p_id=>13540912301658420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PRINT_UTIL.INVALID_PROXY_URL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_object_browser_only_n_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'First %0 columns displayed.';

wwv_flow_api.create_message (
  p_id=>14084928671830801 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_OBJECT_BROWSER_ONLY_N_COLS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to run the following script.  Please confirm your request.';

wwv_flow_api.create_message (
  p_id=>14409918408338346 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RUN_SCRIPT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_script_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Script Name';

wwv_flow_api.create_message (
  p_id=>14415329106388731 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_SCRIPT_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p10_num_stmts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Number of Statements';

wwv_flow_api.create_message (
  p_id=>14417206166401083 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P10_NUM_STMTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View Details';

wwv_flow_api.create_message (
  p_id=>14532632213920428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_DETAILS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Remove';

wwv_flow_api.create_message (
  p_id=>15092706680478500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEINSTALL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4050_31_log_count
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Login Access Log entries';

wwv_flow_api.create_message (
  p_id=>15389030604151768 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4050_31_LOG_COUNT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ob_compile_errors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Errors.';

wwv_flow_api.create_message (
  p_id=>15565224141747922 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OB_COMPILE_ERRORS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Color Palette';

wwv_flow_api.create_message (
  p_id=>15772413581087385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_file_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run script. %0';

wwv_flow_api.create_message (
  p_id=>15871319229863606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_FILE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in run_statement. %0';

wwv_flow_api.create_message (
  p_id=>15872307024879013 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.RUN_STMT_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql_arr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in run_sql_arr. %0';

wwv_flow_api.create_message (
  p_id=>15907709682021738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL_ARR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Success';

wwv_flow_api.create_message (
  p_id=>16172528111282569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.SUCCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_script_fail
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Errors';

wwv_flow_api.create_message (
  p_id=>16173009195286580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SCRIPT.FAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit All';

wwv_flow_api.create_message (
  p_id=>17524809329912576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT_ALL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_query_limit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SELECT statement cannot be greater than 32KB.';

wwv_flow_api.create_message (
  p_id=>17705323851566742 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.QUERY_LIMIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message administator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace Administrator';

wwv_flow_api.create_message (
  p_id=>17810000592953257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADMINISTATOR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message developer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Developer';

wwv_flow_api.create_message (
  p_id=>17810404748954428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEVELOPER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message end_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'End User';

wwv_flow_api.create_message (
  p_id=>17810808211955434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'END_USER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_nosgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Security group ID is null.';

wwv_flow_api.create_message (
  p_id=>17907628863168637 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NOSGID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_rows_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 rows selected.';

wwv_flow_api.create_message (
  p_id=>18521015940098072 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.ROWS_SELECTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Welcome';

wwv_flow_api.create_message (
  p_id=>19137111953029949 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_existence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Existence Check Failure';

wwv_flow_api.create_message (
  p_id=>19137918533031875 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.EXISTENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Substitutions';

wwv_flow_api.create_message (
  p_id=>19138426498034185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Build Options';

wwv_flow_api.create_message (
  p_id=>19138931693035629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation';

wwv_flow_api.create_message (
  p_id=>19139703081036834 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Install Confirmation';

wwv_flow_api.create_message (
  p_id=>19140908621038448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Post Install Success';

wwv_flow_api.create_message (
  p_id=>19141413816039978 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Post Install Failure';

wwv_flow_api.create_message (
  p_id=>19142219703041632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_license
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'License';

wwv_flow_api.create_message (
  p_id=>19144411869048877 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.LICENSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirm_deinstall
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deinstall Confirmation';

wwv_flow_api.create_message (
  p_id=>19145418103050626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRM_DEINSTALL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deinstall Success';

wwv_flow_api.create_message (
  p_id=>19146124336052424 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2613_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password Expired';

wwv_flow_api.create_message (
  p_id=>19164605018620778 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2613_EXPIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manual
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Manual';

wwv_flow_api.create_message (
  p_id=>19246514177089179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANUAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_flow_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Database Account';

wwv_flow_api.create_message (
  p_id=>19313909795983710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_FLOW.DBACCOUNT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dbaccount
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use database account credentials.';

wwv_flow_api.create_message (
  p_id=>19341201520634212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DBACCOUNT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use Existing Table';

wwv_flow_api.create_message (
  p_id=>19726026001641114 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create Authorization Scheme';

wwv_flow_api.create_message (
  p_id=>19726902022653116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_AUTH_SCHEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_script_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Script not found.';

wwv_flow_api.create_message (
  p_id=>19756420239947016 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.SCRIPT_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_nest_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 Scripts cannot be nested more than %0 levels.';

wwv_flow_api.create_message (
  p_id=>19758423964967007 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_NEST_LEVEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_cannot_run_cmd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 command blocked.  Cannot run from SQL Workshop.';

wwv_flow_api.create_message (
  p_id=>19771124963890987 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CANNOT_RUN_CMD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_dbaccount_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Click to populate Auth Function with -DBACCOUNT-'||chr(10)||
''||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>19777300539415376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P802.DBACCOUNT_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_dbauth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use database account username and password to authenticate.';

wwv_flow_api.create_message (
  p_id=>19804220938385447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_DBAUTH_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parsing_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parsing Schema';

wwv_flow_api.create_message (
  p_id=>19806830869044005 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARSING_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_use_auth_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use Existing Authorization Scheme';

wwv_flow_api.create_message (
  p_id=>19825416155827552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_USE_AUTH_SCHEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_rpt_region_header
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Identify usernames which correspond to this application''s authentication scheme.';

wwv_flow_api.create_message (
  p_id=>19873728462944627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_RPT_REGION_HEADER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Check the username and password entered into the login form against Oracle database accounts. This technique is convenient when the users of your application have accounts in the database.';

wwv_flow_api.create_message (
  p_id=>20150808646887943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15A',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The account is locked.';

wwv_flow_api.create_message (
  p_id=>20152105108981523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_LOCKED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unknown_authentication_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'An unrecognized authentication error has occurred.';

wwv_flow_api.create_message (
  p_id=>20152500737989770 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNKNOWN_AUTHENTICATION_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_before_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Before Body';

wwv_flow_api.create_message (
  p_id=>20277501181584167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BEFORE_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_after_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'After Body';

wwv_flow_api.create_message (
  p_id=>20278126461591468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.AFTER_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_script_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 The script output reached the maximum size limit.  Please change your script to generate less output or contact your administrator to increase the maximum script result size.';

wwv_flow_api.create_message (
  p_id=>20365028491013772 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_SCRIPT_OUTPUT_REACHED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_max_workspace_output_reached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 The script output reached the maximum workspace result size limit. Please delete existing results or contact your administrator to increase the maximum workspace result size.';

wwv_flow_api.create_message (
  p_id=>20367712393046913 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.MAX_WORKSPACE_OUTPUT_REACHED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hr_account_unlocked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HR account unlocked.';

wwv_flow_api.create_message (
  p_id=>20387325317948551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HR_ACCOUNT_UNLOCKED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Express 2 Day Plus Developer Guide.';

wwv_flow_api.create_message (
  p_id=>20429928742346966 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD HTMLDB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day DBA.';

wwv_flow_api.create_message (
  p_id=>20432100261357601 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DBA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Developer Guide.';

wwv_flow_api.create_message (
  p_id=>20432505802359273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD DEV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus Java Developer Guide.';

wwv_flow_api.create_message (
  p_id=>20433018615362986 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD JAVA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus .NET Developer Guide.';

wwv_flow_api.create_message (
  p_id=>20433423810364408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD NET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_hd_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Database Express Edition 2 Day Plus PHP Developer.';

wwv_flow_api.create_message (
  p_id=>20433828658365814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 HD PHP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dba
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Discusses common day-to-day administrative tasks.';

wwv_flow_api.create_message (
  p_id=>20434315976371693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DBA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Explains how to take advantage of the Oracle Database Express Edition development environment.';

wwv_flow_api.create_message (
  p_id=>20434826711374726 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG DEV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_htmldb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Offers a series to tutorials that describe how to build database-centric Web applications.';

wwv_flow_api.create_message (
  p_id=>20435308834379034 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG HTMLDB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_php
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This document provides a tutorial that shows you how to download and install Apache and the Zend Core PHP drivers, and then how to use PHP to connect to Oracle Database XE, and demonstrates how to use PHP to develop a simple application that accesses and modifies data.';

wwv_flow_api.create_message (
  p_id=>20435718185381740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG PHP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_java
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This document provides a tutorial that shows you how to use Java and JDBC to connect to Oracle Database XE, and demonstrates how to use to develop a simple Java application that accesses and modifies data.';

wwv_flow_api.create_message (
  p_id=>20436611043389140 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG JAVA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_800_msg_net
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This document describes the key features of Oracle Data Provider for .NET and Oracle Developer Tools for Visual Studio .NET. It leads you through installation and configuration, shows how to build basic applications using Oracle Data Provider for .NET and Oracle Developer Tools for Visual Studio .NET, and how to create and use both PL/SQL and .NET stored procedures.';

wwv_flow_api.create_message (
  p_id=>20437122471392467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500 800 MSG NET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Account created.';

wwv_flow_api.create_message (
  p_id=>20472403022632871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_invalid_context
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This procedure must be invoked from within an application session.';

wwv_flow_api.create_message (
  p_id=>20580011080272889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.INVALID_CONTEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_foreign
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Foreign';

wwv_flow_api.create_message (
  p_id=>20617205117621379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_FOREIGN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_requires_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This WSDL requires authentication credentials. Please supply the username and password below.';

wwv_flow_api.create_message (
  p_id=>20990404520659349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_REQUIRES_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Attempt to save item %0 in session state during show processing. Item protection level indicates "%1". No checksum was passed in or the checksum passed in would be suitable for an item with protection level "%2".';

wwv_flow_api.create_message (
  p_id=>20999902634644494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_SHOW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item has no protection.';

wwv_flow_api.create_message (
  p_id=>21000318218648903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.UNPROTECTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_public_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item may be set when accompanied by an "application-level bookmark" checksum.';

wwv_flow_api.create_message (
  p_id=>21001526361689148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PUBLIC_BOOKMARK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_private_bookmark
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item may be set when accompanied by a "user-level bookmark" checksum.';

wwv_flow_api.create_message (
  p_id=>21001908484693445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.PRIVATE_BOOKMARK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item may be set when accompanied by a "session" checksum.';

wwv_flow_api.create_message (
  p_id=>21002317142695970 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SESSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_internal_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item may be not be set by passing arguments to the application.';

wwv_flow_api.create_message (
  p_id=>21002726492698648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.INTERNAL_ONLY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_unprotected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page has no protection';

wwv_flow_api.create_message (
  p_id=>21003101689700943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.UNPROTECTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_checksum_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page may be requested with arguments if a checksum is passed to the show procedure';

wwv_flow_api.create_message (
  p_id=>21003510000703384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.CHECKSUM_REQUIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page may be accessed only without arguments';

wwv_flow_api.create_message (
  p_id=>21003919697706131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.NO_ARGS_ALLOWED ',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_direct_branch_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page may be accessed only using a "Branch to Page" type branch, from another page';

wwv_flow_api.create_message (
  p_id=>21004329740709008 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.DIRECT_BRANCH_ONLY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No checksum was provided to show processing for a page that requires a checksum when one or more request, clear cache, or argument values are passed as parameters.';

wwv_flow_api.create_message (
  p_id=>21004705976711696 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISSING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_checksum_mismatch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The checksum computed on the request, clear cache, argument names, and argument values (%0) did not match the checksum passed into the show procedure (%1).';

wwv_flow_api.create_message (
  p_id=>21005116019714586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_CHECKSUM_MISMATCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_args_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Arguments were passed to a page that does not accept arguments (request, clear cache, item values).';

wwv_flow_api.create_message (
  p_id=>21005526408717534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_ARGS_ALLOWED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_protection_show_no_url_allowed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This page cannot be invoked using a URL or using a GET or POST to the show procedure, it must be called using a "Branch to Page" branch type.';

wwv_flow_api.create_message (
  p_id=>21005901258719729 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_PROTECTION.SHOW_NO_URL_ALLOWED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Attempt to save item %0 in session state during accept processing, item has Internal Only protection or is not a form item that can be POSTed.';

wwv_flow_api.create_message (
  p_id=>21006331518737908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_ACCEPT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_no_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(No checksum was provided)';

wwv_flow_api.create_message (
  p_id=>21008320848914683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.NO_CHECKSUM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_invalid_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Found invalid date value, please verify date format.';

wwv_flow_api.create_message (
  p_id=>21095423729473639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.INVALID_DATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4500_ui_def_hint_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User Interface Defaults are used by the Application Builder to populate initial values for region and item properties providing consistency across multiple pages in an application or multiple applications.';

wwv_flow_api.create_message (
  p_id=>21299607759967144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4500_UI_DEF_HINT_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Open';

wwv_flow_api.create_message (
  p_id=>21303313793800716 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_OPEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Locked';

wwv_flow_api.create_message (
  p_id=>21303718988802297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_LOCKED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Expired';

wwv_flow_api.create_message (
  p_id=>21304229377805231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p2610_expired_and_locked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Expired and Locked';

wwv_flow_api.create_message (
  p_id=>21304600896815983 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P2610_EXPIRED_AND_LOCKED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Would you like to perform this delete action?';

wwv_flow_api.create_message (
  p_id=>21614331722420760 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE_MSG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Size';

wwv_flow_api.create_message (
  p_id=>21687822556891571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIZE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message length
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Length';

wwv_flow_api.create_message (
  p_id=>21688225673892504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LENGTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message lines
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lines';

wwv_flow_api.create_message (
  p_id=>21688628097893180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calendar';

wwv_flow_api.create_message (
  p_id=>21776104512624097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_easy_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Easy Calendar';

wwv_flow_api.create_message (
  p_id=>21777513516626683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR_EASY_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please click on the link:'||chr(10)||
''||chr(10)||
'%0 '||chr(10)||
''||chr(10)||
'to complete the approval process and receive your credentials.';

wwv_flow_api.create_message (
  p_id=>22123827073845070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.EMAIL_CLICK_ON_LINK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_accepted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'DELETE';

wwv_flow_api.create_message (
  p_id=>22139822636023550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.ACCEPTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a form on a Web service reference page with the following attributes.   Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>22395309050346102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_web_service_ref
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Web Service Reference, Operation';

wwv_flow_api.create_message (
  p_id=>22396020094396573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WEB_SERVICE_REF',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form Items';

wwv_flow_api.create_message (
  p_id=>22397929884456194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_ITEMS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_output_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Output Items';

wwv_flow_api.create_message (
  p_id=>22398303004457852 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OUTPUT_ITEMS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_no_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'An Oracle view has not been found to correspond with the Microsoft Access query.  The Microsoft Access query syntax has been loaded into the edit window.  Modify this syntax in order to create an Oracle view.';

wwv_flow_api.create_message (
  p_id=>22947104612901728 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_NO_VIEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p30_view_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A view must have a status of VALID before it can be used during the migration process.';

wwv_flow_api.create_message (
  p_id=>22951700026919334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P30_VIEW_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message storage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Storage:';

wwv_flow_api.create_message (
  p_id=>22954819368102115 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STORAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message memory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Memory:';

wwv_flow_api.create_message (
  p_id=>22955624909103798 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MEMORY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message home_page_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Users:';

wwv_flow_api.create_message (
  p_id=>22961825480170112 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOME_PAGE_USERS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sessions:';

wwv_flow_api.create_message (
  p_id=>22969323730368374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SESSIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message active
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Active';

wwv_flow_api.create_message (
  p_id=>23004506192614313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACTIVE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p3_find_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Locate the file generated by the Exporter Tool';

wwv_flow_api.create_message (
  p_id=>23033703140670650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P3_FIND_FILE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>1. Export Microsoft Access metadata.</b><br />'||chr(10)||
'Run the Exporter for Microsoft Access and extract the metadata from the .mdb file. This creates database (.xml) and application (.sql) output files.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>23038005611699829 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>2. Migrate the Microsoft Access database to Oracle.</b><br />'||chr(10)||
'Run the Oracle Migration Workbench and load the database metadata from Step 1. This migrates the schema and data to Oracle.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>23041516824712514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>3. Create an Oracle Application Express Workspace.</b><br />'||chr(10)||
'Run Oracle Application Express and create a workspace. Associate the workspace with the newly created schema from Step 2.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>23042704834718509 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>4. Create a migration project.</b><br />'||chr(10)||
'Log in to the workspace created in Step 3 and run the Application Migration Workshop. Create a migration project and load the application metadata from Step 1.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>23043216262721840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>5. Analyze the Microsoft Access application.</b><br />'||chr(10)||
'From the Application Migration Workshop, verify and adjust the Access application metadata. Refine the scope of migration and fix any invalid objects. '||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>23044427606743947 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP5',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>6. Generate the Oracle Application Express Application.</b><br />'||chr(10)||
'Create either an application based on valid forms and reports or a maintenance application based on valid tables and views.'||chr(10)||
'<p />';

wwv_flow_api.create_message (
  p_id=>23045806266747267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP6',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p12_howto_step7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>7. Customize your Application Express application.</b><br />'||chr(10)||
'Open your application in the Application Builder part of Application Express, and customize your migrated application. You can change application attributes or add new pages to the application.';

wwv_flow_api.create_message (
  p_id=>23046724967752688 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P12_HOWTO_STEP7',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message internal_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Internal';

wwv_flow_api.create_message (
  p_id=>23062808231712501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERNAL_USERS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message database_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Database';

wwv_flow_api.create_message (
  p_id=>23063210655713253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DATABASE_USERS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_obj_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'"%0" has been successfully created.';

wwv_flow_api.create_message (
  p_id=>23133330338492253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_OBJ_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p10_queries_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use the far left column to select the queries you want to include in the migration. '||chr(10)||
'<br><br>'||chr(10)||
'To include a query, it must have a status of Valid. By default, all queries with a Valid status are selected.'||chr(10)||
'<br><br>'||chr(10)||
'If you do not select a query for inclusion, any forms or reports based on this query will not be included in the migration.'||chr(10)||
'<br><br>'||chr(10)||
'Click the <b>Attempt to compile invalid queries</b> li';

h:=h||'nk to run a bulk process that tries to compile all the queries.'||chr(10)||
'<br><br>'||chr(10)||
'Click <b>Apply Changes</b> to save your selections or updates.';

wwv_flow_api.create_message (
  p_id=>23194305479740580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P10_QUERIES_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p9_tables_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use the far left column to select the tables you want to include in the migration.'||chr(10)||
'<br><br>'||chr(10)||
'To include a table, it must have a status of Valid. By default, all tables with a Valid status are selected.'||chr(10)||
'<br><br>'||chr(10)||
'If you do not select a table for inclusion, all forms and reports based on this table are excluded from the migration.'||chr(10)||
'<br><br>Click <b>Apply Changes</b> to save your selections or updates.';

wwv_flow_api.create_message (
  p_id=>23198212189751931 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P9_TABLES_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_table_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'If a table does not have a primary key, click the <b>Create Primary Key</b> link to add one. All tables should have a primary key before they are migrated.';

wwv_flow_api.create_message (
  p_id=>23199412667761560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_TABLE_INFO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p8_forms_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'1. Use the far left column to select the forms you want to include in the migration.'||chr(10)||
'<br /><br />'||chr(10)||
'To include a form, the source of the form must have a status of Valid. By default, all forms based on valid source objects are selected.'||chr(10)||
'<br /><br />'||chr(10)||
'2. Click the <b>Attempt to compile invalid SQL queries</b> link to run a bulk process that tries to compile all invalid SQL queries.'||chr(10)||
'<br /><br />'||chr(10)||
'3. In ';

h:=h||'the <b>Migrate to</b> column, select the type of Oracle Application Express object that you want to migrate your Microsoft Access form to:  '||chr(10)||
'<li>Form (default option)</li>'||chr(10)||
'<li>Tabular Form</li>'||chr(10)||
'<li>Report and Form</li>'||chr(10)||
'<br><br>'||chr(10)||
'These options appear for valid tables and queries.'||chr(10)||
'<br><br>'||chr(10)||
'4. Click <b>Apply Changes</b> to save your selections or updates. '||chr(10)||
'<p />'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>23201800462776957 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P8_FORMS_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p20_reports_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use the far left column to select the reports you want to include in the migration.'||chr(10)||
'<br><br>'||chr(10)||
'To include a report, the source of the report must have a status of Valid. By default, all reports based on valid source objects are selected.'||chr(10)||
'<br><br>'||chr(10)||
'Click the <b>Attempt to compile invalid SQL queries</b> link to run a bulk process that tries to compile all invalid SQL queries.'||chr(10)||
'<br><br>'||chr(10)||
'Click <b>Apply C';

h:=h||'hanges</b> to save your selections or updates.';

wwv_flow_api.create_message (
  p_id=>23204224488793368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P20_REPORTS_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_defs_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'When new applications are created, these defaults will be used.';

wwv_flow_api.create_message (
  p_id=>23297107622920952 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_DEFS_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_protection_save_item_internal_only_show
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Attempt to save item %0 in session state during show processing, item has Internal Only protection.';

wwv_flow_api.create_message (
  p_id=>23680232504124313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ITEM_PROTECTION.SAVE_ITEM_INTERNAL_ONLY_SHOW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_parser_line_exceeds_32k
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Script line exceeds 32767 bytes';

wwv_flow_api.create_message (
  p_id=>23729007242618562 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_PARSER.LINE_EXCEEDS_32K',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv_obj
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema %0 has no select privilege on table or view %1.';

wwv_flow_api.create_message (
  p_id=>23744021322864616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV_OBJ',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_approved_account_req_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your request for a workspace has been approved and credentials emailed to %0.';

wwv_flow_api.create_message (
  p_id=>23911325230448901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.APPROVED_ACCOUNT_REQ_DISPLAY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message archivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Log Archiving: On';

wwv_flow_api.create_message (
  p_id=>23929717128314457 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ARCHIVELOG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message noarchivelog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Log Archiving: Off';

wwv_flow_api.create_message (
  p_id=>23930121630315793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOARCHIVELOG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_search
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Search';

wwv_flow_api.create_message (
  p_id=>24029500571407704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SEARCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show Chart By';

wwv_flow_api.create_message (
  p_id=>24031117671422080 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_CHART_BY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_choose_a_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Choose a Column';

wwv_flow_api.create_message (
  p_id=>24032206027428180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHOOSE_A_COLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analysis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Analysis';

wwv_flow_api.create_message (
  p_id=>24117630971511091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYSIS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Chart';

wwv_flow_api.create_message (
  p_id=>24122707469532693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Insert Form';

wwv_flow_api.create_message (
  p_id=>24204805138588835 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create New %0';

wwv_flow_api.create_message (
  p_id=>24207031804596451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Update Form';

wwv_flow_api.create_message (
  p_id=>24207930896605734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE_FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Update %0';

wwv_flow_api.create_message (
  p_id=>24209428256614394 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.UPDATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 must have some value.';

wwv_flow_api.create_message (
  p_id=>24211211549628455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.NOT_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_is_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 must be number.';

wwv_flow_api.create_message (
  p_id=>24211700252634648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.IS_NUM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Success Page';

wwv_flow_api.create_message (
  p_id=>24215519561659194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The data has been inserted successfully.';

wwv_flow_api.create_message (
  p_id=>24216309649665793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_SUCCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_another
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Insert Another';

wwv_flow_api.create_message (
  p_id=>24218426618670698 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ANOTHER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_view_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View Report';

wwv_flow_api.create_message (
  p_id=>24219718438677763 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.VIEW_REPORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Return Home';

wwv_flow_api.create_message (
  p_id=>24222707141683995 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_HOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Success';

wwv_flow_api.create_message (
  p_id=>24225028612690214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SUCCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_help_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This page displays help for a page.';

wwv_flow_api.create_message (
  p_id=>24242505727806565 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.HELP_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_return_prev_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Return to previous page';

wwv_flow_api.create_message (
  p_id=>24243527545812868 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RETURN_PREV_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Breadcrumb';

wwv_flow_api.create_message (
  p_id=>24244320403820324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.MENU',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Insert %0';

wwv_flow_api.create_message (
  p_id=>24246403350834252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to show report.';

wwv_flow_api.create_message (
  p_id=>24251816903866620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_csv_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spread Sheet';

wwv_flow_api.create_message (
  p_id=>24253920151876948 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CSV_LINK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_clear_cache_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to clear cache.';

wwv_flow_api.create_message (
  p_id=>24255325130887840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CLEAR_CACHE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_reset_pagination_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to reset pagination.';

wwv_flow_api.create_message (
  p_id=>24256512794893740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.RESET_PAGINATION_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to insert a row to %0.';

wwv_flow_api.create_message (
  p_id=>24258011324912269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.INSERT_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_analyze
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analyze';

wwv_flow_api.create_message (
  p_id=>24371807833034300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.ANALYZE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_report_and_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report and Edit';

wwv_flow_api.create_message (
  p_id=>24372423071038731 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.REPORT_AND_EDIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_new2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create New';

wwv_flow_api.create_message (
  p_id=>24373206579043384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NEW2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p22_no_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The associated Microsoft Access table was not successfully migrated to Oracle.  Review the Oracle Migration Workbench logfile for further information.';

wwv_flow_api.create_message (
  p_id=>24499616247914891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P22_NO_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Database user %0 created with default tablespace %1 using datafile %2';

wwv_flow_api.create_message (
  p_id=>24593407723308270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p42_validate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'To validate the syntax of the SQL query, click <b>Validate</b>. The displayed syntax has been extracted from your Microsoft Access database.'||chr(10)||
'<br><br>'||chr(10)||
'Ensure that the query uses valid Oracle syntax. Only SQL queries with a status of Valid can be included in the migration process. ';

wwv_flow_api.create_message (
  p_id=>24820631746638468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P42_VALIDATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_show_menu_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to show breadcrumb.';

wwv_flow_api.create_message (
  p_id=>25100127058795395 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.SHOW_MENU_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_display_region_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to display page region.';

wwv_flow_api.create_message (
  p_id=>25197630886947900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DISPLAY_REGION_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_ws_entire_response_doc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Entire Response Document';

wwv_flow_api.create_message (
  p_id=>25361907636262929 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_WS_ENTIRE_RESPONSE_DOC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_invalid_wsdl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The URL provided did not return a valid WSDL document.';

wwv_flow_api.create_message (
  p_id=>25441900737188165 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.INVALID_WSDL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_min_len_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password must contain at least %0 characters.';

wwv_flow_api.create_message (
  p_id=>25510416966192448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_MIN_LEN_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_differs_by_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'New password must differ from old password by at least %0 characters.';

wwv_flow_api.create_message (
  p_id=>25510823855241766 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_DIFFERS_BY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_alpha_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password must contain at least one alphabetic character (%0).';

wwv_flow_api.create_message (
  p_id=>25511230781243730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_ALPHA_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password must contain at least one numeric character (0123456789).';

wwv_flow_api.create_message (
  p_id=>25511604246245532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_NUMERIC_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_punctuation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password must contain at least one punctuation character (%0).';

wwv_flow_api.create_message (
  p_id=>25512011519247602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_PUNCTUATION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_upper_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password must contain at least one upper-case alphabetic character.';

wwv_flow_api.create_message (
  p_id=>25512417752249481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_UPPER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_one_lower_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password must contain at least one lower-case alphabetic character.';

wwv_flow_api.create_message (
  p_id=>25512824678251451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_ONE_LOWER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_username_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password must not contain username.';

wwv_flow_api.create_message (
  p_id=>25513230912253210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_USERNAME_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_workspace_name_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password must not contain workspace name.';

wwv_flow_api.create_message (
  p_id=>25513604724255167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORKSPACE_NAME_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_like_words_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password contains a prohibited simple word.';

wwv_flow_api.create_message (
  p_id=>25514019961259582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_LIKE_WORDS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'EXISTS SQL Query';

wwv_flow_api.create_message (
  p_id=>25594709605436753 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXISTS_SQL_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_exists_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'NOT EXISTS SQL Query';

wwv_flow_api.create_message (
  p_id=>25595122418440396 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_EXISTS_SQL_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item in Expression 1 is NULL';

wwv_flow_api.create_message (
  p_id=>25595504888444851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_in_exp1_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item in Expression 1 is NOT NULL';

wwv_flow_api.create_message (
  p_id=>25595917701448578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_IN_EXP1_NOT_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message func_ret_boolean
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL Function Returning Boolean';

wwv_flow_api.create_message (
  p_id=>25596327398451371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNC_RET_BOOLEAN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_eq_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Value of Preference in Expression';

wwv_flow_api.create_message (
  p_id=>25596704672454203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_EQ_EXP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pref_ne_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Value of Preference in Expression 1 Does NOT Equal Expression 2';

wwv_flow_api.create_message (
  p_id=>25597114023456931 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREF_NE_EXP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_eq_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Value of item in Expression 1 Equals Expression 2';

wwv_flow_api.create_message (
  p_id=>25597522680459407 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_EQ_EXP2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_exp1_ne_exp2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Value of item in Expression 1 Does NOT Equal Expression 2';

wwv_flow_api.create_message (
  p_id=>25598030645461738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_EXP1_NE_EXP2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_page_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Evaluate for every page view';

wwv_flow_api.create_message (
  p_id=>25598506881464331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_PAGE_VIEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authz_cache_per_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Evaluate once per session';

wwv_flow_api.create_message (
  p_id=>25598915885466909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHZ_CACHE_PER_SESSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_complexity_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password does not conform to this site''s password complexity rules.';

wwv_flow_api.create_message (
  p_id=>25620017217886184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_COMPLEXITY_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_export
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Export';

wwv_flow_api.create_message (
  p_id=>25624919110466918 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.EXPORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This application was exported from the current workspace.';

wwv_flow_api.create_message (
  p_id=>25626813971569587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_CURR_WS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_app_export_non_curr_ws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This application was exported from another workspace.';

wwv_flow_api.create_message (
  p_id=>25627206137576727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APP_EXPORT_NON_CURR_WS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace will not be created because it already exists.';

wwv_flow_api.create_message (
  p_id=>25628922114609795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_tobe_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace will be created.';

wwv_flow_api.create_message (
  p_id=>25629303891613922 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_TOBE_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Back';

wwv_flow_api.create_message (
  p_id=>25708712654726011 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BACK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message today
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Today';

wwv_flow_api.create_message (
  p_id=>25709226853730149 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TODAY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message forward
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Forward';

wwv_flow_api.create_message (
  p_id=>25709701357732201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORWARD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use database authentication (user identified by DAD).';

wwv_flow_api.create_message (
  p_id=>25805531839284899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_DAD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_auth_scheme_desc_internal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use internal %0 account credentials and login page in this application.';

wwv_flow_api.create_message (
  p_id=>25806518942300171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.AUTH_SCHEME_DESC_INTERNAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sample Application';

wwv_flow_api.create_message (
  p_id=>25831504818551543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_sample_app_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A sample application that highlights common design concepts.';

wwv_flow_api.create_message (
  p_id=>25831920055555978 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.SAMPLE.APP.DESCR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_collect_descr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Learn about shopping cart concepts.';

wwv_flow_api.create_message (
  p_id=>25832517547574167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO.COLLECT.DESCR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message bytes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'bytes';

wwv_flow_api.create_message (
  p_id=>26057215633754454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BYTES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rows_returned_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'rows returned in';

wwv_flow_api.create_message (
  p_id=>26069125459601000 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROWS_RETURNED_IN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message invalid_object
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Object %0 is Invalid.';

wwv_flow_api.create_message (
  p_id=>26135121181016158 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INVALID_OBJECT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_builder
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Query Builder';

wwv_flow_api.create_message (
  p_id=>26331015907250250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY BUILDER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'no List of Values';

wwv_flow_api.create_message (
  p_id=>26361120781308414 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'no shortcut';

wwv_flow_api.create_message (
  p_id=>26362213424325207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_SHORTCUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_authorization_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'no authorization scheme';

wwv_flow_api.create_message (
  p_id=>26362702473331569 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_AUTHORIZATION_SCHEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_reset_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Reset your session state if you wish to run your application without any preset values.';

wwv_flow_api.create_message (
  p_id=>26373928259575502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350_RESET_SESSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cancel Button Display Text';

wwv_flow_api.create_message (
  p_id=>26432930710153401 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Finish Button Display Text';

wwv_flow_api.create_message (
  p_id=>26433415388167940 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_previous_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Previous Button Display Text';

wwv_flow_api.create_message (
  p_id=>26433829241171919 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.PREVIOUS_BUTTON_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_next_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Next Button Display Text';

wwv_flow_api.create_message (
  p_id=>26434516343187176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.NEXT_BUTTON_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_cancel_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cancel Button Branch';

wwv_flow_api.create_message (
  p_id=>26435015781196447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.CANCEL_BUTTON_BRANCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p111_finish_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Finish Button Branch';

wwv_flow_api.create_message (
  p_id=>26435510718204416 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P111.FINISH_BUTTON_BRANCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message form_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 of %1';

wwv_flow_api.create_message (
  p_id=>26443419609348986 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FORM_OF',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML Button';

wwv_flow_api.create_message (
  p_id=>26503403314893043 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message one
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'One';

wwv_flow_api.create_message (
  p_id=>26543532244014911 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message my_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'My Page';

wwv_flow_api.create_message (
  p_id=>26566108620102788 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MY_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copyright
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copyright &copy; %0, All rights reserved.';

wwv_flow_api.create_message (
  p_id=>26569212233264608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPYRIGHT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regions';

wwv_flow_api.create_message (
  p_id=>26572412757302692 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message processes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Processes';

wwv_flow_api.create_message (
  p_id=>26572819337304567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCESSES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message computations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Computations';

wwv_flow_api.create_message (
  p_id=>26573222107305330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COMPUTATIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message validations
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validations';

wwv_flow_api.create_message (
  p_id=>26573624185305934 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALIDATIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message branches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branches';

wwv_flow_api.create_message (
  p_id=>26574026263306547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BRANCHES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Items';

wwv_flow_api.create_message (
  p_id=>26574728687307265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEMS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Buttons';

wwv_flow_api.create_message (
  p_id=>26575631804308135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 - %1 of %2';

wwv_flow_api.create_message (
  p_id=>26630013475930364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z_2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_p74_provision1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace %0 provisioned with administrator %1.';

wwv_flow_api.create_message (
  p_id=>26640504268629944 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_P74_PROVISION1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unretrievable
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The WSDL document was unretrievable because either the URL you supplied was invalid, your environment requires a valid proxy server address for HTTP requests and you have not defined one for this application, or a wallet needs to be configured for this instance of &PRODUCT_NAME. for HTTPS requests.';

wwv_flow_api.create_message (
  p_id=>26736714862399592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNRETRIEVABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_no_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The WSDL document did not contain a binding for SOAP which is required in order to add the reference.';

wwv_flow_api.create_message (
  p_id=>26750800757452239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_NO_SOAP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drillup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Drill Up';

wwv_flow_api.create_message (
  p_id=>26822328574166869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLUP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drilldown
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Drill Down';

wwv_flow_api.create_message (
  p_id=>26822732038167865 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRILLDOWN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit';

wwv_flow_api.create_message (
  p_id=>26824420525183413 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EDIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message generated_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This table was created using the table wizard.';

wwv_flow_api.create_message (
  p_id=>26824806027207686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'GENERATED_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message series
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Series %0';

wwv_flow_api.create_message (
  p_id=>26870432271659957 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERIES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_fetch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to fetch row.';

wwv_flow_api.create_message (
  p_id=>26903002647887974 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_FETCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_unable_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to process row of table %0.';

wwv_flow_api.create_message (
  p_id=>26904002086897222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UNABLE_TO_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_action_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Action Processed.';

wwv_flow_api.create_message (
  p_id=>26904423903903533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.ACTION_PROCESSED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message to_many_columns_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A maximum of %0 columns can be selected.';

wwv_flow_api.create_message (
  p_id=>27342321613257083 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TO_MANY_COLUMNS_SELECTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_javascript_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This application requires JavaScript to be enabled.';

wwv_flow_api.create_message (
  p_id=>27747406874537909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_JAVASCRIPT_ENABLED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4550_cookies_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This application requires cookies to be enabled.';

wwv_flow_api.create_message (
  p_id=>27776610928855106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4550_COOKIES_ENABLED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_help_unauthorized
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unauthorized access.';

wwv_flow_api.create_message (
  p_id=>28516808103704827 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HELP.UNAUTHORIZED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_no_datatype
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No datatype specified for %0.';

wwv_flow_api.create_message (
  p_id=>28545002787003941 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P602_NO_DATATYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_multiple_soap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The WSDL document contains multiple SOAP bindings. &PRODUCT_NAME. only supports WSDL''s with one SOAP binding. Click Create Web Service Reference Manually to continue creating a reference for this service.';

wwv_flow_api.create_message (
  p_id=>28704815063272714 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.MULTIPLE_SOAP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_html_email_click_on_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please click <a href=''%0''>here</a> to complete the approval process and receive your credentials.';

wwv_flow_api.create_message (
  p_id=>28982224117920311 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.HTML_EMAIL_CLICK_ON_LINK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p1023_parsing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parsing script - please wait.';

wwv_flow_api.create_message (
  p_id=>29685025840567465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P1023_PARSING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_line_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Line Number';

wwv_flow_api.create_message (
  p_id=>29711514899649471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.LINE_NUMBER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_script_invalid_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to run a script containing unknown statement(s).  Please remove the following statement(s).';

wwv_flow_api.create_message (
  p_id=>29715524034661564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_SCRIPT.INVALID_STMT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f400_p107_step
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Step %0';

wwv_flow_api.create_message (
  p_id=>29864930406798821 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F400_P107_STEP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4719_yn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'show Yes / No, return Y and N';

wwv_flow_api.create_message (
  p_id=>29880115309879630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4719.YN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Result Tree to Report On';

wwv_flow_api.create_message (
  p_id=>30326603162445855 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_array_parms
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Result Parameters to Report On';

wwv_flow_api.create_message (
  p_id=>30327010434447956 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ARRAY_PARMS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_collection
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Temporary Result Set Name';

wwv_flow_api.create_message (
  p_id=>30342710322589858 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLLECTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form Region Title';

wwv_flow_api.create_message (
  p_id=>30344620542630727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_input_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form Region Template';

wwv_flow_api.create_message (
  p_id=>30345527815632745 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INPUT_REGION_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report Region Title';

wwv_flow_api.create_message (
  p_id=>30346223790641127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report Region Template';

wwv_flow_api.create_message (
  p_id=>30346630024642892 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_REGION_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_insert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to perform insert operation.  %0  %1';

wwv_flow_api.create_message (
  p_id=>31187225836283229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_INSERT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'default: Look 5';

wwv_flow_api.create_message (
  p_id=>31532527800826069 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME15',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- No Display -';

wwv_flow_api.create_message (
  p_id=>31675201711401266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_DISPLAY_VALUE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message xml_load_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'XML load error.';

wwv_flow_api.create_message (
  p_id=>32081613579269326 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'XML_LOAD_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shared_component
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Shared Component';

wwv_flow_api.create_message (
  p_id=>32088113155199298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHARED_COMPONENT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Delete';

wwv_flow_api.create_message (
  p_id=>32126726517376064 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.DELETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message unexpired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unexpired';

wwv_flow_api.create_message (
  p_id=>32260020191809684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UNEXPIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML Chart';

wwv_flow_api.create_message (
  p_id=>32272117814837371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_slash_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML/Text';

wwv_flow_api.create_message (
  p_id=>32273732144850984 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_SLASH_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text_with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML Text with shortcuts';

wwv_flow_api.create_message (
  p_id=>32281719031875559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT_WITH_SHORTCUTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to save DDL as a script file. %0';

wwv_flow_api.create_message (
  p_id=>32315332225390226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item Name';

wwv_flow_api.create_message (
  p_id=>32495619869837009 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display Type';

wwv_flow_api.create_message (
  p_id=>32496506841842752 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_analyze_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analyze %0';

wwv_flow_api.create_message (
  p_id=>33437617911346313 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.ANALYZE_COLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_data_quick_flow_view_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View By';

wwv_flow_api.create_message (
  p_id=>33742809206665528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATA_QUICK_FLOW.VIEW_BY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_analyze_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create analyze page. %0';

wwv_flow_api.create_message (
  p_id=>33747832109700462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_ANALYZE_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message icon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Icon %0';

wwv_flow_api.create_message (
  p_id=>36685910742707444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ICON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message check
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'row selector';

wwv_flow_api.create_message (
  p_id=>36719205200406055 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHECK$',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'column link';

wwv_flow_api.create_message (
  p_id=>36719618013409814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LINK$',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message derived
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'derived column';

wwv_flow_api.create_message (
  p_id=>36720023900411452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DERIVED$',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'About';

wwv_flow_api.create_message (
  p_id=>37378917844686039 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ABOUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branching';

wwv_flow_api.create_message (
  p_id=>37387408803730748 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.BRANCHING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4731_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Add Row';

wwv_flow_api.create_message (
  p_id=>37390900837540334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4731.ADD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit';

wwv_flow_api.create_message (
  p_id=>37430926689802128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EDIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_numeric
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page must be numeric.';

wwv_flow_api.create_message (
  p_id=>37546123750494308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_NUMERIC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_positive
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page must be positive numbers.';

wwv_flow_api.create_message (
  p_id=>37576114661510664 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_POSITIVE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_page_must_be_whole_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page must be whole numbers.';

wwv_flow_api.create_message (
  p_id=>37578007866518198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P295_PAGE_MUST_BE_WHOLE_NUMBER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application collection %0 does not exist';

wwv_flow_api.create_message (
  p_id=>37732414330875307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NOT_EXIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_not_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Member sequence %0 does not exist in Application collection %1'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>37733025543887978 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_NOT_EXIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Specified member attribute number %0 is invalid';

wwv_flow_api.create_message (
  p_id=>37733411822893511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_INVALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_attribute_number_outside_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Specified member attribute number %0 is invalid.  Attribute number must be between 1 and %1';

wwv_flow_api.create_message (
  p_id=>37733803641900575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ATTRIBUTE_NUMBER_OUTSIDE_RANGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_member_sequence_number_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Member sequence %0 does not exist in application collection "%1"';

wwv_flow_api.create_message (
  p_id=>37734232038908777 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.MEMBER_SEQUENCE_NUMBER_INVALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_array_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application collection array must not be null';

wwv_flow_api.create_message (
  p_id=>37734609313911732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.ARRAY_NOT_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Collection name cannot be null';

wwv_flow_api.create_message (
  p_id=>37739014339951058 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_NOT_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_name_too_large
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Collection name cannot be larger than 255 characters';

wwv_flow_api.create_message (
  p_id=>37739406851958280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_NAME_TOO_LARGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_collection_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application collection exists';

wwv_flow_api.create_message (
  p_id=>37740109407968502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.COLLECTION_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_collection_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cursor is not yet open';

wwv_flow_api.create_message (
  p_id=>37740503304976192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COLLECTION.CURSOR_NOT_OPEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_translation_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find %0 translation of application %1';

wwv_flow_api.create_message (
  p_id=>38242022138821476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.TRANSLATION_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_insert_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seed insert error: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>38243324347831576 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_INSERT_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_seed_translations_seed_delete_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seed delete error: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>38247413873847538 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SEED_TRANSLATIONS.SEED_DELETE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_translations_seed_update_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Seed update error: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>38248309156855596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TRANSLATIONS.SEED_UPDATE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sync_translations_sync_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sync error: %0.%1 %2';

wwv_flow_api.create_message (
  p_id=>38253908426902703 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SYNC_TRANSLATIONS.SYNC_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_sgid_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Security group ID 20 is reserved for workspace ''ORACLE''';

wwv_flow_api.create_message (
  p_id=>38255505094911228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.SGID_RESERVED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger_button_tab_names_not_equal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Button names must not be the same name as an existing tab';

wwv_flow_api.create_message (
  p_id=>38257706264920995 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER.BUTTON_TAB_NAMES_NOT_EQUAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_writing_to_directory
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'There was an error writing to the physical file directory "%0". (%1: %2)';

wwv_flow_api.create_message (
  p_id=>38258504925949023 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_WRITING_TO_DIRECTORY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_no_file_to_write
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'There is no file to write for id %0';

wwv_flow_api.create_message (
  p_id=>38258925011954796 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.NO_FILE_TO_WRITE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The server encountered an error attempting to remove file "%0"';

wwv_flow_api.create_message (
  p_id=>38259319386972127 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_file_api_error_removing_file2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove file %0';

wwv_flow_api.create_message (
  p_id=>38260911552979291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FILE_API.ERROR_REMOVING_FILE2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed_with_checksum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current version of data in database has changed since user initiated update process.  current checksum = "%0" application checksum = "%1"'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>38265417832009477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED_WITH_CHECKSUM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_version_of_data_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current version of data in database has changed since user initiated update process.';

wwv_flow_api.create_message (
  p_id=>38265926490011983 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.VERSION_OF_DATA_CHANGED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_invalid_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid action %0 on this object. (%1)';

wwv_flow_api.create_message (
  p_id=>38383000423297849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.INVALID_ACTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find template (%0) to copy';

wwv_flow_api.create_message (
  p_id=>38384613021310928 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find field template (%0) in application "%1" workspace "%2" to copy';

wwv_flow_api.create_message (
  p_id=>38385014191320724 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unauthorized access.';

wwv_flow_api.create_message (
  p_id=>38396719225016778 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_USER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find breadcrumb template (%0) in application "%1" workspace "%2" to copy';

wwv_flow_api.create_message (
  p_id=>38406909623489707 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find button template (%0) in application "%1" workspace "%2" to copy';

wwv_flow_api.create_message (
  p_id=>38407310793499508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to replace %0 template. %1';

wwv_flow_api.create_message (
  p_id=>38419018374549001 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.TEMPLATE_REPLACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_page_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to replace page template. %0';

wwv_flow_api.create_message (
  p_id=>38423032142571909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.PAGE_TEMPLATE_REPLACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_region_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to replace region template. %0';

wwv_flow_api.create_message (
  p_id=>38423609071574712 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REGION_TEMPLATE_REPLACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_report_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to replace report template. %0';

wwv_flow_api.create_message (
  p_id=>38424017729577229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.REPORT_TEMPLATE_REPLACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_list_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to replace list template. %0';

wwv_flow_api.create_message (
  p_id=>38424525694579499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.LIST_TEMPLATE_REPLACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_field_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to replace field template. %0';

wwv_flow_api.create_message (
  p_id=>38425404700582946 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.FIELD_TEMPLATE_REPLACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_menu_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to replace breadcrumb template. %0';

wwv_flow_api.create_message (
  p_id=>38426022708588077 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.MENU_TEMPLATE_REPLACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_popup_lov_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to replace Popup List of Values Template. %0';

wwv_flow_api.create_message (
  p_id=>38426512796594744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.POPUP_LOV_TEMPLATE_REPLACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_button_template_replace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to replace button template. %0';

wwv_flow_api.create_message (
  p_id=>38427811542603766 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.BUTTON_TEMPLATE_REPLACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p122_cal_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calendar templates referencing this, template';

wwv_flow_api.create_message (
  p_id=>38660710153584840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P122_CAL_TEMPL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove page reference id. %0';

wwv_flow_api.create_message (
  p_id=>38771732252530614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_PAGE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_region_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove region reference id. %0';

wwv_flow_api.create_message (
  p_id=>38774323379537504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REGION_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_list_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove list reference id. %0';

wwv_flow_api.create_message (
  p_id=>38777706195542065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LIST_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_report_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove report reference id. %0';

wwv_flow_api.create_message (
  p_id=>38779329397548740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_REPORT_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_field_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove field reference id. %0';

wwv_flow_api.create_message (
  p_id=>38783117408554701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_FIELD_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_security_scheme_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove security scheme reference id. %0';

wwv_flow_api.create_message (
  p_id=>38785102994560031 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SECURITY_SCHEME_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove shortcut reference id. %0';

wwv_flow_api.create_message (
  p_id=>38786221348565295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_SHORTCUT_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove navigation bar reference id. %0';

wwv_flow_api.create_message (
  p_id=>38788110397571611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_NAVBAR_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove List of Values reference id. %0';

wwv_flow_api.create_message (
  p_id=>38789127020576445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_LOV_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_popup_lov_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove popup List of Values template reference id. %0';

wwv_flow_api.create_message (
  p_id=>38792022649584595 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_POPUP_LOV_TEMPLATE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove Breadcrumb template reference id. %0';

wwv_flow_api.create_message (
  p_id=>38796614469591734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_MENU_TEMPLATE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_button_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove button template reference id. %0';

wwv_flow_api.create_message (
  p_id=>38798227413604893 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_BUTTON_TEMPLATE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_ws_rpt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a form and report on a Web service reference page with the following attributes.   Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>38956009470728152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_WS_RPT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_auth_setup_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove authentication scheme reference id. %0';

wwv_flow_api.create_message (
  p_id=>39037818512802648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_AUTH_SETUP_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove item help reference id. %0';

wwv_flow_api.create_message (
  p_id=>39038211370809972 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_ITEM_HELP_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to page template. %0';

wwv_flow_api.create_message (
  p_id=>39039125700823582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_PAGE_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to region template. %0';

wwv_flow_api.create_message (
  p_id=>39039608169827999 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REGION_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to list template. %0';

wwv_flow_api.create_message (
  p_id=>39040703106835997 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LIST_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to report template. %0';

wwv_flow_api.create_message (
  p_id=>39042106007846299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_REPORT_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to field template. %0';

wwv_flow_api.create_message (
  p_id=>39042528863852961 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_FIELD_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to Popup List of Values Template. %0';

wwv_flow_api.create_message (
  p_id=>39043414796858272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_POPUP_LOV_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to breadcrumb template. %0';

wwv_flow_api.create_message (
  p_id=>39045231072863038 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_MENU_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to button template. %0';

wwv_flow_api.create_message (
  p_id=>39045714234867604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_BUTTON_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to security scheme. %0';

wwv_flow_api.create_message (
  p_id=>39046408478875371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SECURITY_SCHEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to shortcut. %0';

wwv_flow_api.create_message (
  p_id=>39047032373882304 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_SHORTCUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to navigation bar. %0';

wwv_flow_api.create_message (
  p_id=>39047817613887533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_NAVBAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to List of Values. %0';

wwv_flow_api.create_message (
  p_id=>39050827094899740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to authentication scheme. %0';

wwv_flow_api.create_message (
  p_id=>39055407617913034 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_AUTH_SETUP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_subscribe_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to item help. %0';

wwv_flow_api.create_message (
  p_id=>39062920346935568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.SUBSCRIBE_ITEM_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish page template. %0';

wwv_flow_api.create_message (
  p_id=>39068320608954614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_PAGE_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish region template. %0';

wwv_flow_api.create_message (
  p_id=>39068811735961559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REGION_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish list template. %0';

wwv_flow_api.create_message (
  p_id=>39070631128967151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LIST_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish report template. %0';

wwv_flow_api.create_message (
  p_id=>39071519138973094 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_REPORT_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_field_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish field template. %0';

wwv_flow_api.create_message (
  p_id=>39074025849984558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_FIELD_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish popup List of Values template. %0';

wwv_flow_api.create_message (
  p_id=>39076210743989577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_POPUP_LOV_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish button template. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39077424941993691 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_BUTTON_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish Breadcrumb template. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39077905333997519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_MENU_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_security_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish security scheme. %0';

wwv_flow_api.create_message (
  p_id=>39078524380003056 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SECURITY_SCHEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish shortcut. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39079409966008344 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_SHORTCUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish navigation bar. %0';

wwv_flow_api.create_message (
  p_id=>39081225550012786 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_NAVBAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish list of values. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39082114599019102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_auth_setup
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish authentication scheme. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39084922695030908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_AUTH_SETUP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_item_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish item help. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39086204472035108 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_ITEM_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_user_no_privileges
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User %0 does not have privilege on the %1 schema.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39142227964287942 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.USER_NO_PRIVILEGES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No workspace found with workspace ID: %0';

wwv_flow_api.create_message (
  p_id=>39145605810357255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_COMPANY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_no_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No schema assigned for workspace ID: %0';

wwv_flow_api.create_message (
  p_id=>39146215853360122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NO_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_auto_provision_failure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Automatic provisioning failed during the "MAKE_REQUEST" phase';

wwv_flow_api.create_message (
  p_id=>39151626027372532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.AUTO_PROVISION_FAILURE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_user_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'An error occurred adding user to workspace %0';

wwv_flow_api.create_message (
  p_id=>39154627674391948 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_USER_ADD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This request has been processed or is being processed.  Status must equal "%0"';

wwv_flow_api.create_message (
  p_id=>39155504733404174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_PROCESSED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_company_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace %0 is a reserved name, request is denied';

wwv_flow_api.create_message (
  p_id=>39164828975411219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.COMPANY_RESERVED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema name %0 is a reserved schema and cannot be provisioned.';

wwv_flow_api.create_message (
  p_id=>39165418024417535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_RESERVED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_processed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Request %0 could not be processed.  %1';

wwv_flow_api.create_message (
  p_id=>39176518632436651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_PROCESSED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Request %0 could not be processed as the schema %1 exists in the %2 table.';

wwv_flow_api.create_message (
  p_id=>39187527683467658 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.SCHEMA_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_request_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Request %0 not found';

wwv_flow_api.create_message (
  p_id=>39189626429476681 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REQUEST_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_generate_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rem Unable to generate DDL for %0 %1.';

wwv_flow_api.create_message (
  p_id=>39335924705602260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.GENERATE_DDL_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error parsing the DDL script. %0';

wwv_flow_api.create_message (
  p_id=>39368118481676070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL_PARSE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_save_ddl_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Save_ddl error %0';

wwv_flow_api.create_message (
  p_id=>39372909393692461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.SAVE_DDL ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to import database object installation attributes id="%0"';

wwv_flow_api.create_message (
  p_id=>39382816138386133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_install_script_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating installation script id="%0"';

wwv_flow_api.create_message (
  p_id=>39385319385396584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INSTALL_SCRIPT_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_next_prev_pk_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create get next previous primary key value process. %0';

wwv_flow_api.create_message (
  p_id=>39483025801887283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.NEXT_PREV_PK_PROCESS_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_table_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create access control tables. %0';

wwv_flow_api.create_message (
  p_id=>39651309219860229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_TABLE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_create_page_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create access control page. %0';

wwv_flow_api.create_message (
  p_id=>39652705194868521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CREATE_PAGE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message out_of_range
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid set of rows requested, the source data of the report has been modified.';

wwv_flow_api.create_message (
  p_id=>39735323071214364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OUT_OF_RANGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'reset pagination';

wwv_flow_api.create_message (
  p_id=>39735727226215544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RESET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_welcome_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This application installer will guide you through the process of creating your database objects and seed data.';

wwv_flow_api.create_message (
  p_id=>39804020234733947 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.WELCOME_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_configuration_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You can configure the following attributes of your application.';

wwv_flow_api.create_message (
  p_id=>39809119326743151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIGURATION_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_build_options_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You can choose to include the following build options.';

wwv_flow_api.create_message (
  p_id=>39814211838750490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.BUILD_OPTIONS_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_validation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The following validations will be performed to ensure your system is compatible with this application.';

wwv_flow_api.create_message (
  p_id=>39814818765752412 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.VALIDATION_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_confirmation_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please confirm that you would like to install this application''s supporting objects.';

wwv_flow_api.create_message (
  p_id=>39817825129763771 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.CONFIRMATION_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your application''s supporting objects have been installed.';

wwv_flow_api.create_message (
  p_id=>39818911062769191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.SUCCESS_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Installation of database objects and seed data has failed.';

wwv_flow_api.create_message (
  p_id=>39820328723774297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.FAILURE_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_deinstall_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deinstallation complete.';

wwv_flow_api.create_message (
  p_id=>39821608422777847 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.DEINSTALL_SUCCESS_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Method';

wwv_flow_api.create_message (
  p_id=>39870811589427647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_METHOD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Details';

wwv_flow_api.create_message (
  p_id=>39871228211432447 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Built-in session management logic, a built-in login page and user authentication against the internal "cookie user" account repository.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39871607910435989 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_bi2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Built-in session management logic. User authentication is accomplished via the modplsql DAD configuration.'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39872016222438405 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_BI2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This method has been replaced with SCHEME authentication.';

wwv_flow_api.create_message (
  p_id=>39872426957441515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_details_obs2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This method has been deprecated.';

wwv_flow_api.create_message (
  p_id=>39872803540444214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DETAILS_OBS2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_public_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Public Pages';

wwv_flow_api.create_message (
  p_id=>39873231590452290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PUBLIC_PAGES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Action';

wwv_flow_api.create_message (
  p_id=>39873601724462645 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Review or edit';

wwv_flow_api.create_message (
  p_id=>39874012113465584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'or edit';

wwv_flow_api.create_message (
  p_id=>39874420078467963 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'session management attributes';

wwv_flow_api.create_message (
  p_id=>39874828043470260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'of this application on the application attributes page, or use the report above to create and manage authentication schemes that can be used when you change the authentication method to %0.';

wwv_flow_api.create_message (
  p_id=>39875201508472017 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(none)';

wwv_flow_api.create_message (
  p_id=>39875609127474192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_NONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_manage
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Manage authentication schemes using the report above.';

wwv_flow_api.create_message (
  p_id=>39876016053476210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_MANAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_deactivate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Change status to inactive';

wwv_flow_api.create_message (
  p_id=>39878415424046270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_DEACTIVATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(current)';

wwv_flow_api.create_message (
  p_id=>39878821442057486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_CURRENT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Make this scheme current';

wwv_flow_api.create_message (
  p_id=>39879230099059985 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_activate2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'make current';

wwv_flow_api.create_message (
  p_id=>39879605297062332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_ACTIVATE2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_copy_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copied from application';

wwv_flow_api.create_message (
  p_id=>39886304819402862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_COPY_FROM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is the "master" copy of this authentication scheme.';

wwv_flow_api.create_message (
  p_id=>39886714515405621 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_MASTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schemes referencing this authentication scheme';

wwv_flow_api.create_message (
  p_id=>39887124904408640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_SUBSCRIBERS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_no_subscribers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'There are no subscribers to this authentication scheme.';

wwv_flow_api.create_message (
  p_id=>39887530792410336 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_NO_SUBSCRIBERS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_builtin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Built-In)';

wwv_flow_api.create_message (
  p_id=>39890910865641131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_BUILTIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>39891318137643177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pg_sentry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Sentry Function';

wwv_flow_api.create_message (
  p_id=>39891724024644884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PG_SENTRY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_sess_verify
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Session Verification Function';

wwv_flow_api.create_message (
  p_id=>39892106147649238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_SESS_VERIFY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_inv_sess_tgt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid Session Target';

wwv_flow_api.create_message (
  p_id=>39892514459651575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_INV_SESS_TGT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pre-Authentication Process';

wwv_flow_api.create_message (
  p_id=>39892921731653672 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PRE_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentication Function'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>39893331774656582 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP Host';

wwv_flow_api.create_message (
  p_id=>39893709742659693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_HOST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP Port';

wwv_flow_api.create_message (
  p_id=>39894118053662100 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_PORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP Search Base';

wwv_flow_api.create_message (
  p_id=>39894526364664499 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_DN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_ldap_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP Username Edit';

wwv_flow_api.create_message (
  p_id=>39894908487668811 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LDAP_EDIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Post-Authentication Process';

wwv_flow_api.create_message (
  p_id=>39895316106670984 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_POST_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie Name';

wwv_flow_api.create_message (
  p_id=>39895724417673388 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_path
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie Path';

wwv_flow_api.create_message (
  p_id=>39896130651675166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_PATH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_c_domain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cookie Domain';

wwv_flow_api.create_message (
  p_id=>39896502731676578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_C_DOMAIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_logout_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Logout URL';

wwv_flow_api.create_message (
  p_id=>39896908272678205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_LOGOUT_URL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p811_paren_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Database Authentication)';

wwv_flow_api.create_message (
  p_id=>39897316237680472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P811_PAREN_DBAUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_flow_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application ID';

wwv_flow_api.create_message (
  p_id=>39899926767768765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_FLOW_ID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentication Method';

wwv_flow_api.create_message (
  p_id=>39900332654770449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_AUTH_METHOD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_scheme_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Scheme Name';

wwv_flow_api.create_message (
  p_id=>39900709236773101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_SCHEME_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>39901117547775466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_DESCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p822_curr_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current Authentication Method';

wwv_flow_api.create_message (
  p_id=>40267217392815769 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P822_CURR_METHOD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create list template. %0';

wwv_flow_api.create_message (
  p_id=>40679203960767649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create application. %0';

wwv_flow_api.create_message (
  p_id=>40680122792782550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_FLOW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create page template. %0';

wwv_flow_api.create_message (
  p_id=>40680618767790771 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_PAGE_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_label_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create label template. %0';

wwv_flow_api.create_message (
  p_id=>40681013703798862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LABEL_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create report template. %0';

wwv_flow_api.create_message (
  p_id=>40681403791805417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create region template. %0';

wwv_flow_api.create_message (
  p_id=>40681825609811672 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REGION_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create breadcrumb template. %0';

wwv_flow_api.create_message (
  p_id=>40684629465841175 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_button_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create button template. %0';

wwv_flow_api.create_message (
  p_id=>40685116090846807 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_BUTTON_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_popup_lov_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create Popup List of Values Template.';

wwv_flow_api.create_message (
  p_id=>40685703061852488 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.POPUP_LOV_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create standard tabs. %0';

wwv_flow_api.create_message (
  p_id=>40686122108857990 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_TAB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_navbar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create navbar. %0';

wwv_flow_api.create_message (
  p_id=>40686511157864334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_NAVBAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create breadcrumb . %0';

wwv_flow_api.create_message (
  p_id=>40687132628870546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MENU',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create report page. %0';

wwv_flow_api.create_message (
  p_id=>40687520985876566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_REPORT_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create insert form. %0';

wwv_flow_api.create_message (
  p_id=>40687905879881714 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_INSERT_FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_update_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create update form. %0';

wwv_flow_api.create_message (
  p_id=>40688422501886474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_UPDATE_FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create chart page.';

wwv_flow_api.create_message (
  p_id=>40689006010891205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_CHART_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error setting up to edit ldap user name.';

wwv_flow_api.create_message (
  p_id=>40689312433892461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_EDIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_user_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run edit ldap user function.';

wwv_flow_api.create_message (
  p_id=>40689521565892479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_USER_FN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SYS.DBMS_LDAP package does not exist or is invalid.';

wwv_flow_api.create_message (
  p_id=>40689700343892497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_MISSING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_ldap_fix
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please ask your DBA to run $OH/rdbms/admin/catldap.sql.';

wwv_flow_api.create_message (
  p_id=>40689907724892515 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LDAP_FIX',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_ldap_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error executing wwv_flow_custom_auth_ldap.authenticate.';

wwv_flow_api.create_message (
  p_id=>40690125759892533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_LDAP_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_pre_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run custom pre-auth process.';

wwv_flow_api.create_message (
  p_id=>40690325337892551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_PRE_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_setup_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error setting up to run credential check function.';

wwv_flow_api.create_message (
  p_id=>40690514015892568 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SETUP_CRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run authentication credential check function.';

wwv_flow_api.create_message (
  p_id=>40690702718892586 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_CRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_run_post_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run custom post-auth process.';

wwv_flow_api.create_message (
  p_id=>40690904166892604 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_RUN_POST_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Malformed argument to wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.';

wwv_flow_api.create_message (
  p_id=>40691113117892622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_null_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Null p_session_id argument to wwv_flow_custom_auth_std.login--p_flow_page:%0';

wwv_flow_api.create_message (
  p_id=>40691319545892639 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_NULL_LOGIN_ARG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please contact administrator.';

wwv_flow_api.create_message (
  p_id=>40691505543892657 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_CONTACT_ADMIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Illegal p_session in wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1.';

wwv_flow_api.create_message (
  p_id=>40691707982892676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_ARG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_invalid_login_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid p_session in wwv_flow_custom_auth_std.login--p_flow_page:%0 p_session_id:%1.';

wwv_flow_api.create_message (
  p_id=>40691927486892694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_INVALID_LOGIN_ARG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_malformed_login_args2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Illegal entry point arg to wwv_flow_custom_auth_std.login--p_flow_page:p_session_id:p_entry_point:%0:%1:%2.  ';

wwv_flow_api.create_message (
  p_id=>40692100766892713 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_MALFORMED_LOGIN_ARGS2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_login_null_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Null username passed to login procedure.';

wwv_flow_api.create_message (
  p_id=>40692522089892760 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_LOGIN_NULL_USER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_partner_app_unreg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find registered partner application name in authentication scheme.';

wwv_flow_api.create_message (
  p_id=>40692914409892809 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_PARTNER_APP_UNREG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_partner_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please edit the authentication scheme and add the application name.';

wwv_flow_api.create_message (
  p_id=>40693123284892826 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_PARTNER_APP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_wwsec_pkg_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WWSEC_SSO_ENABLER_PRIVATE package does not exist or is invalid.';

wwv_flow_api.create_message (
  p_id=>40693304315892845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_WWSEC_PKG_MISSING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_fix_wwsec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please ask your administrator to configure the engine for Oracle AS Single Sign-On.';

wwv_flow_api.create_message (
  p_id=>40693530024892862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_FIX_WWSEC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_sso_redir
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error executing wwv_flow_custom_auth_sso.portal_sso_redirect.';

wwv_flow_api.create_message (
  p_id=>40693720299892880 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_SSO_REDIR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_err_illegal_login_pg_arg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in p_flow_page argument to login_page procedure.';

wwv_flow_api.create_message (
  p_id=>40693914827892897 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ERR_ILLEGAL_LOGIN_PG_ARG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_home_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create home page. %0';

wwv_flow_api.create_message (
  p_id=>40694425056896765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_HOME_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create list. %0';

wwv_flow_api.create_message (
  p_id=>40694912720902614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_list_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create list item. %0';

wwv_flow_api.create_message (
  p_id=>40695430728907851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_LIST_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_success_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create success page. %0';

wwv_flow_api.create_message (
  p_id=>40695815622912869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_SUCCESS_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_define_default_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please define default templates to create the application.';

wwv_flow_api.create_message (
  p_id=>40696315753922395 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.DEFINE_DEFAULT_TEMPLATES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_use_one_level_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You can only build the application using one level tab.';

wwv_flow_api.create_message (
  p_id=>40696802724928137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.USE_ONE_LEVEL_TAB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_quick_flow_create_modules
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create modules. %0';

wwv_flow_api.create_message (
  p_id=>40697225234934631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_QUICK_FLOW.CREATE_MODULES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'parse error2 %0';

wwv_flow_api.create_message (
  p_id=>40698211429959036 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_parse_error1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ParseErr: %0';

wwv_flow_api.create_message (
  p_id=>40698809136967782 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.PARSE_ERROR1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create updateable report. %0';

wwv_flow_api.create_message (
  p_id=>40699222642971734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_UPDATEABLE_REPORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create form on sp. %0';

wwv_flow_api.create_message (
  p_id=>40699605111976110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_SP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create form on table. %0';

wwv_flow_api.create_message (
  p_id=>40700105935985789 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_insert_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create insert form. %0';

wwv_flow_api.create_message (
  p_id=>40700520479990021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_INSERT_FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_query_and_update_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create query and update page. %0';

wwv_flow_api.create_message (
  p_id=>40700901910994145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_QUERY_AND_UPDATE_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_chart_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create chart page. %0';

wwv_flow_api.create_message (
  p_id=>40701320957999597 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CHART_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid report type.';

wwv_flow_api.create_message (
  p_id=>40701713123006845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.INVALID_REPORT_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create report page. %0';

wwv_flow_api.create_message (
  p_id=>40703206112023732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_REPORT_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_calendar_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create calendar page. %0';

wwv_flow_api.create_message (
  p_id=>40704419965027728 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_CALENDAR_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_form_on_equijoin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create form on equijoin. %0';

wwv_flow_api.create_message (
  p_id=>40706208668033962 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FORM_ON_EQUIJOIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create wizard creating wizard. %0';

wwv_flow_api.create_message (
  p_id=>40711723905038298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_WIZARD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create tree. %0';

wwv_flow_api.create_message (
  p_id=>40717912608044502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_TREE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_excel_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create excel chart. %0';

wwv_flow_api.create_message (
  p_id=>40730007675062030 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_EXCEL_CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create summary page. %0';

wwv_flow_api.create_message (
  p_id=>40731424991067032 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SUMMARY_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create SVG Chart page. %0';

wwv_flow_api.create_message (
  p_id=>40731808845071811 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_SVG_CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_updateable_query_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Updatable SQL Query already exists. You can only add one updatable SQL query per page.';

wwv_flow_api.create_message (
  p_id=>40732321443084954 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.UPDATEABLE_QUERY_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg_handling
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Login Page Handling';

wwv_flow_api.create_message (
  p_id=>41394203574372867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG_HANDLING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This application (%0) uses page %1 as a login page.';

wwv_flow_api.create_message (
  p_id=>41394431501372942 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_login_pg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Whenever page %0 is requested, no further authentication checks are performed and the page is shown or accepted. This allows the login page to be shown before authentication has occurred.';

wwv_flow_api.create_message (
  p_id=>41394630427372975 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LOGIN_PG2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Database Authentication';

wwv_flow_api.create_message (
  p_id=>41394811923373009 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This application uses the DAD configuration for authentication. If the DAD configuration has account information stored with it, then the APP_USER variable will be set to the user associated with the DAD. If the PUBLIC_USER application attribute is set to the same value as the user name stored in the DAD, then useful comparisons of the APP_USER variable with the PUBLIC_USER attribute can be made i';

h:=h||'n application conditions, security scheme evaluation, and other embedded logic. If the DAD does not have user account information stored with it, then the user must pass the basic authentication challenge via a dialog box presented by the browser. After this authentication, The engine will set APP_USER to the name captured by this challenge.';

wwv_flow_api.create_message (
  p_id=>41395021643373047 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_dbauth3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No login page is presented to the user by the engine.';

wwv_flow_api.create_message (
  p_id=>41395208095373079 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.DBAUTH3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_page_sentry_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Sentry Function';

wwv_flow_api.create_message (
  p_id=>41395412237373110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PAGE_SENTRY_FUNCTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_pg_sentry1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use built-in logic to perform page sentry tasks. For each page request, the page sentry function performs session verification and computes a return value.';

wwv_flow_api.create_message (
  p_id=>41395608791373143 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.PG_SENTRY1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Session Verification Function';

wwv_flow_api.create_message (
  p_id=>41395832463373174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY_FUNCTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chk_cookie1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Using built-in logic, check the cookie named [%0]. If the cookie exists and its decoded value locates a row in the internal sessions table, then consider the session valid.';

wwv_flow_api.create_message (
  p_id=>41396000224373209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHK_COOKIE1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sess_verify1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use additional user-provided code to determine if the session if valid. After getting a TRUE result from the built-in session verification check, above, execute the following code and remember its boolean return value:';

wwv_flow_api.create_message (
  p_id=>41396210343373241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SESS_VERIFY1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_compute_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Compute Return Value';

wwv_flow_api.create_message (
  p_id=>41396429487373272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.COMPUTE_RETURN_VALUE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The page sentry function will return the boolean result of the built-in session verification check to the engine. If the result is true, the engine will continue to show or accept the page. If the result is false, the engine will redirect to the invalid session page or URL specified in this authentication scheme (see below).';

wwv_flow_api.create_message (
  p_id=>41396607553373305 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The page sentry function will return the boolean result of the built-in session verification check ANDed with the result of the user-provided session verification check to the engine. If the result is true, the engine will continue to show or accept the page. If the result is false, the engine will redirect to the invalid session target specified in this authentication scheme (see below).';

wwv_flow_api.create_message (
  p_id=>41396803767373391 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use custom logic to perform page sentry tasks. For each page request, the engine will execute the following code:';

wwv_flow_api.create_message (
  p_id=>41397013838373478 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The boolean result of the above block will be returned to the engine. If the result is true, the engine will continue to show or accept the page. If the result is false, the engine will redirect to the invalid session target specified in this authentication scheme (see below).';

wwv_flow_api.create_message (
  p_id=>41397206771373510 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The built-in method for session verification is available to the %0 developer using the API call:';

wwv_flow_api.create_message (
  p_id=>41397407375373543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION5',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This boolean function result can be combined with other checks in the user-provided page sentry function specified in an authentication scheme. If this API is called, it will check the cookie named %0';

wwv_flow_api.create_message (
  p_id=>41397630513373578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION6',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'If the cookie exists and its decoded value locates a row in the internal sessions table, then the session is considered valid and a TRUE value is returned to the page sentry function that called it.';

wwv_flow_api.create_message (
  p_id=>41397800456373610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION7',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_invalid_sess_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid Session Target';

wwv_flow_api.create_message (
  p_id=>41398013612373642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.INVALID_SESS_TARGET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'If the page sentry function returns TRUE, page rendering or processing continues. If the result is FALSE, the engine will show page %0, which is considered to be this application''s login page based on its designation in this authentication scheme as the invalid session page.';

wwv_flow_api.create_message (
  p_id=>41398205449373675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION8',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'the built-in login page';

wwv_flow_api.create_message (
  p_id=>41398420318373707 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.BUILTIN_LOGIN_PG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'the Oracle Application Server Single Sign-On server';

wwv_flow_api.create_message (
  p_id=>41398601479373738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.SSO_SERVER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_the_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'the URL';

wwv_flow_api.create_message (
  p_id=>41398810762373770 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.THE_URL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The page sentry function returns a boolean result to the engine. If the result is TRUE, page rendering or processing continues. If the result is FALSE, the engine will redirect to %0.';

wwv_flow_api.create_message (
  p_id=>41399028933373802 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION9',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action10
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'If the page sentry function returns TRUE, page rendering or processing continues. If the result is FALSE, the engine must quit because no invalid session target is specified in the authentication scheme. In this case, the user-provided page sentry function is presumed to have redirected to a login page outside the %0 environment, possibly to an external authentication portal. The function should a';

h:=h||'lso have set the global variable g_unrecoverable_error := true to instruct the engine to quit without showing an error page.';

wwv_flow_api.create_message (
  p_id=>41399211630373837 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION10',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The engine will execute the following code that is specified as the pre-authentication process of this authentication scheme:';

wwv_flow_api.create_message (
  p_id=>41399432053373869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION11',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is executed as an anonymous block that returns no value.';

wwv_flow_api.create_message (
  p_id=>41399630371373901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION12',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No custom pre-authentication code is specified in this scheme.';

wwv_flow_api.create_message (
  p_id=>41399812564373935 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION13',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_credentials_verification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Credentials Verification (Authentication)';

wwv_flow_api.create_message (
  p_id=>41400028685373967 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CREDENTIALS_VERIFICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Any username/password combination entered into the login form will be considered valid. The username entered will be used as the name of the logged-in user for the life of the session. This technique can be useful while you are developing your application but before any actual user accounts are established.';

wwv_flow_api.create_message (
  p_id=>41400212863374000 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION14',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Check the username and password entered into the login form against the Application Builder (cookie user) accounts. These are the same accounts used in your workspace to log into %0. This technique can be useful when the users of your application are developers who have %0 accounts in the same database and workspace.';

wwv_flow_api.create_message (
  p_id=>41400432750374036 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION15',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Check the username and password entered into the login form using the LDAP directory specified in this authentication scheme.';

wwv_flow_api.create_message (
  p_id=>41400624357374068 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION16',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The LDAP parameters are set to:';

wwv_flow_api.create_message (
  p_id=>41400812027374099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION17',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_host
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP Host:';

wwv_flow_api.create_message (
  p_id=>41401022116374131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_HOST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP Port:';

wwv_flow_api.create_message (
  p_id=>41401200512374162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_PORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_dn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'LDAP Search Base:';

wwv_flow_api.create_message (
  p_id=>41401430584374193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_DN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The following block is used to call a function before the call to DBMS_LDAP.SIMPLE_BIND_S. The username captured in the login form is passed to the function, which returns a value that is used to replace %LDAP_USER% in the LDAP Search Base (see above).';

wwv_flow_api.create_message (
  p_id=>41401604336374226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This code block must have this signature:';

wwv_flow_api.create_message (
  p_id=>41401820735374257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_ldap_edit_fn3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This feature allows you to transform the username entered in the login form into whatever format matches your LDAP directory entry.';

wwv_flow_api.create_message (
  p_id=>41402031493374289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.LDAP_EDIT_FN3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Execute the following custom code to verify credentials:';

wwv_flow_api.create_message (
  p_id=>41402222278374321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION18',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Post-Authentication Processing';

wwv_flow_api.create_message (
  p_id=>41402400687374352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.POST_AUTH_PROC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action19
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Check the built-in sessions table for the session used by the built-in login page. If the session exists and is not owned by another user, mark it as now owned by the authenticated user (using the username from the login form).';

wwv_flow_api.create_message (
  p_id=>41402612307374385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION19',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action20
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Set the cookie named %0 to a value that locates the row in the internal sessions table.';

wwv_flow_api.create_message (
  p_id=>41402811649374417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION20',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Determine the URL to redirect to next. If a "deep link" was recorded in the session state by the rendering engine, use that as the URL to go to. Otherwise go the the URL specified as the home link attribute of the application.';

wwv_flow_api.create_message (
  p_id=>41403202921374481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION22',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_cust_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Custom Post-Authentication Processing';

wwv_flow_api.create_message (
  p_id=>41403410071374513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CUST_POST_AUTH_PROC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action23
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'After credentials verification, the engine will execute the following code that is specified as the post-authentication process of this authentication scheme:';

wwv_flow_api.create_message (
  p_id=>41403605577374545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION23',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action24
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is executed as an anonymous block that returns no value.';

wwv_flow_api.create_message (
  p_id=>41403805668374578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION24',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action25
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No custom post-authentication code is specified in this scheme.';

wwv_flow_api.create_message (
  p_id=>41404014932374609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION25',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_action26
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Redirect to the URL determined above. This marks the end of login processing using the built-in login page and the APIs that it calls.';

wwv_flow_api.create_message (
  p_id=>41404218818374641 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.ACTION26',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A typical approach is for the page to contain a login form to capture the user''s credentials. Then the page''s after-submit processes would call an authentication module to verify the credentials. After authentication, the page would perform any session registration and cookie setting tasks. Finally it would redirect to the start page of the application.';

wwv_flow_api.create_message (
  p_id=>41404428348374675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The %0 API: wwv_flow_custom_auth_std can be called by such after-submit processes to perform any of these steps just described. There are two entry points available:';

wwv_flow_api.create_message (
  p_id=>41404624149374709 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Call the login procedure to have the engine perform all of the steps for you. The engine will use the built-in sessions table and perform session registration and cookie setting for you. Any custom code you provide in this authentication scheme will be run at the pre-authentication, authentication, or post-authentication points.';

wwv_flow_api.create_message (
  p_id=>41404827020374742 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_api_common4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Call the post_login procedure if you are performing authentication yourself but you would like %0 to handle all post-authentication chores for you. With these two entry points you can use any of the built-in login processing steps in combination with your own login page and any processes that run on it. Remember, if you use the built-in post-authentication processing, you can take advantage of bui';

h:=h||'lt-in page sentry and session verification processing as well.';

wwv_flow_api.create_message (
  p_id=>41405026585374778 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.API_COMMON4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'External Login Processing';

wwv_flow_api.create_message (
  p_id=>41405208647374810 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This authentication scheme specifies neither a login page or a URL to be used for the invalid session target. This implies that the page sentry function handles this case. Perhaps it redirects to a single-signon portal or some other login server. Additionally, there are no login processing values in the authentication scheme. If this is not what you intended, please edit this authentication scheme';

h:=h||' and provide an invalid session page or URL, then examine this chart view again.';

wwv_flow_api.create_message (
  p_id=>41405431005374845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This authentication scheme specifies neither a login page or a URL to be used for the invalid session target. This implies that the page sentry function handles this case. Perhaps it redirects to a single-signon portal or some other login server. However, there are values set for login processing in the authentication scheme, as shown below:';

wwv_flow_api.create_message (
  p_id=>41405621034374879 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The login URL:%0 appears to specify an %1 application page as the invalid session target. However, there are no login processing values in the authentication scheme. This page is responsible for performing the following steps:';

wwv_flow_api.create_message (
  p_id=>41405817398374910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'In order for the %0 engine to be able to show or accept the login page in your application, you must select the page attribute ''Yes - This page is public'' on the Page Attributes page of the Application Builder. If you do not do this, the engine will attempt to execute the page sentry function before showing the page. If you have not yet logged in, a redirect to the same URL will be attempted. This';

h:=h||' will cause a most unsatisfying loop. If you code your own page sentry function, you may need to recognize when the current page is this login page and handle it differently from other pages. If you can identify it by page number, fine. A more generic technique is to use the boolean function wwv_flow_custom_auth.current_page_is_public to recognize this public attribute of the login page or any oth';

h:=h||'er page in your application.';

wwv_flow_api.create_message (
  p_id=>41406230828374980 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN6',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The login URL %0 appears to specify an %1 application page as the invalid session target. This page is responsible for performing the following steps:';

wwv_flow_api.create_message (
  p_id=>41406411682375060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN7',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The values set for login processing in the authentication scheme are shown below:';

wwv_flow_api.create_message (
  p_id=>41406632730375093 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN8',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login9
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The Oracle Application Server Single Sign-On Server will redirect back to this application after user authentication. The entry point is the wwv_flow_custom_auth_sso.process_success procedure in the %0 schema. %0 is registered as an Oracle Application Server Single Sign-On partner application and can manage all interfaces to the login server for you. If, however, you would prefer to register your ';

h:=h||'own application in your own schema, you can. You can write your own page sentry or simply create an authentication scheme based on the Portal-SSO scheme (my application as partner app) from the authentication scheme gallery. The resulting scheme will call the built-in SSO page sentry wwv_flow_custom_auth_std.portal_sso_sentry_v1. This function requires that the current authentication scheme knows ';

h:=h||'the name of your partner application, as registered with Oracle Application Server Single Sign-On. The create authentication scheme wizard asks you for the partner application name, or it can be added or changed by editing the scheme after it is created. The name must be entered exactly as registered, observing case. You will also need to write your own URLC receiver procedure and call the wwv_flo';

h:=h||'w_custom_auth_sso.process_success API from it, passing in the name of your application as you registered it with Oracle Application Server Single Sign-On. This will perform session registration with %0 after authentication. If you write your own page sentry, the wwv_flow_custom_auth_sso.portal_sso_redirect API may be called by the page sentry to perform the redirect to the login server when it det';

h:=h||'ermines that authentication is required. You must pass in the registered name of your partner application to this procedure. Please consult the %0 documentation and the %1 documentation for details.';

wwv_flow_api.create_message (
  p_id=>41406821282375137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN9',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The login URL %0 does not appear to specify an %1 application page as the invalid session target. Additionally, there are no login processing values in the authentication scheme. This page is responsible for performing the following steps:';

wwv_flow_api.create_message (
  p_id=>41407430774375234 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN12',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login13
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please note that unless the services invoked at this URL use the %0 wwv_custom_auth_std API to assist with session registration tasks, your application will not be able to use built-in page sentry or session verification processing. You will have to do this work by whatever means you devise on your own.';

wwv_flow_api.create_message (
  p_id=>41407619026375267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN13',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_pre_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pre-authentication processing';

wwv_flow_api.create_message (
  p_id=>41407829529375299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_PRE_AUTH_PROC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_post_auth_proc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Post-authentication processing';

wwv_flow_api.create_message (
  p_id=>41408027049375330 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_POST_AUTH_PROC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login14
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The login URL %0 does not appear to specify an %1 application page as the invalid session target. This page is responsible for performing the following steps:';

wwv_flow_api.create_message (
  p_id=>41408407183375394 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN14',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login15
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The values set for login processing in the authentication scheme are shown below:';

wwv_flow_api.create_message (
  p_id=>41408604564375426 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN15',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login16
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The login page specified in this scheme is page [%0] in this application. This page is responsible for performing the following steps:';

wwv_flow_api.create_message (
  p_id=>41408805285375459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN16',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login17
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'However, there are no login processing values in the authentication scheme.';

wwv_flow_api.create_message (
  p_id=>41409023567375491 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN17',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_std_chart_login18
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Because this page is the designated login page for the application, it is not possible to perform certain actions on the page when the page is first shown, because user authentication has not yet occurred. Also, certain session state and session identification variables are not available to page computations or processes as they would be on ordinary pages that are processed after authentication. F';

h:=h||'or these reasons, the specification of a login page by page number in an authentication scheme is only suitable for pages that have very little or no functionality other than login form processing. If you would prefer to have your login page be more active, please use the login URL designation in the authentication scheme wizard or edit page. So long as you remember to set the public page attribut';

h:=h||'e to ''Yes - This page is public'' using the page attributes form in the Builder the log'||chr(10)||
'in page can use the full range of %0 features in addition to serving as the login page in your application.';

wwv_flow_api.create_message (
  p_id=>41409231736375531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_STD.CHART_LOGIN18',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p817_refresh_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in refreshing authentication schemes.';

wwv_flow_api.create_message (
  p_id=>41469703149528409 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P817_REFRESH_AUTH_SCHEME_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Single Sign-On (Oracle Use Only)';

wwv_flow_api.create_message (
  p_id=>41470109728530360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (%0 as Partner Application)';

wwv_flow_api.create_message (
  p_id=>41470515616531998 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (My Application as Partner Application)';

wwv_flow_api.create_message (
  p_id=>41470923234534243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Built-in Login Page: Use %0 Account Credentials';

wwv_flow_api.create_message (
  p_id=>41471330160536239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Built-in Login Page: Open Door Credentials';

wwv_flow_api.create_message (
  p_id=>41471704319538227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE5',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Built-in Login Page: Use LDAP Directory Credentials';

wwv_flow_api.create_message (
  p_id=>41472110206539962 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Based on authentication scheme from gallery';

wwv_flow_api.create_message (
  p_id=>41472515747541468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE7',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_obj_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find %0 (%1) to copy';

wwv_flow_api.create_message (
  p_id=>41475209223643748 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.OBJ_NOT_FOUND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_cannot_find_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to determine security group ID for specified workspace ID = "%0"'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>41503207935130163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.CANNOT_FIND_SGID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_remove_last_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You cannot use this facility to remove the last schema of a workspace';

wwv_flow_api.create_message (
  p_id=>41504003134157160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.REMOVE_LAST_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_reserved_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to reset password for schema %0';

wwv_flow_api.create_message (
  p_id=>41505504088176339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_RESERVED_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Not permitted to reset password for a schema that is not associated with your workspace.  %0';

wwv_flow_api.create_message (
  p_id=>41506412184188135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_reset_password_not_in_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User name %0 does not exist in workspace %1';

wwv_flow_api.create_message (
  p_id=>41507806082195833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.RESET_PASSWORD_NOT_IN_COMPANY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_page_dev_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Developer does not have privilege to create a component on this page.';

wwv_flow_api.create_message (
  p_id=>41751910508872793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_PAGE_DEV_PRIV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_layout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Report Layout selected';

wwv_flow_api.create_message (
  p_id=>41768324045254472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_LAYOUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unknown Workspace Name';

wwv_flow_api.create_message (
  p_id=>42835024888575920 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_web_services_wsdl_unhandled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The WSDL document could not be understood by the rendering engine. Click Create Web Service Reference Manually to continue creating a reference for this service.';

wwv_flow_api.create_message (
  p_id=>42953707322560680 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WEB_SERVICES.WSDL_UNHANDLED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_last_extended
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'API Last Extended:';

wwv_flow_api.create_message (
  p_id=>43148018597160190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_LAST_EXTENDED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_current_flows_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your Current Version:';

wwv_flow_api.create_message (
  p_id=>43148225164160194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.CURRENT_FLOWS_VERSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_import_compatible_with_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This import is compatible with version:';

wwv_flow_api.create_message (
  p_id=>43148518890160196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.IMPORT_COMPATIBLE_WITH_VERSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_missing_export_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your application import did not supply an export version.';

wwv_flow_api.create_message (
  p_id=>43148802602160196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.MISSING_EXPORT_VERSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_engine_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your engine version could not be established.';

wwv_flow_api.create_message (
  p_id=>43149121549160197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_ENGINE_VERSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_unkown_api_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your engine last API version could not be established.';

wwv_flow_api.create_message (
  p_id=>43149424497160198 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UNKOWN_API_VERSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_upgrade_needed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You will need to upgrade to import this application export.';

wwv_flow_api.create_message (
  p_id=>43150314346160200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.UPGRADE_NEEDED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_invalid_credentials
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid username, password, or workspace combination';

wwv_flow_api.create_message (
  p_id=>43150618340160200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.INVALID_CREDENTIALS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_user_not_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User %0 requires ADMIN privilege to perform this operation.';

wwv_flow_api.create_message (
  p_id=>43150918940160201 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.USER_NOT_ADMIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set_import
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package variable g_security_group_id must be set to import an application.';

wwv_flow_api.create_message (
  p_id=>43151207920160202 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET_IMPORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The procedure %0 was called without a value for p_id -- a application ID must be provided.';

wwv_flow_api.create_message (
  p_id=>43151508956160203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_MISSING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_not_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application %0 was not deleted. Import will not be attempted.';

wwv_flow_api.create_message (
  p_id=>43151804783160203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_NOT_DELETED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_templ_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating template name=%0';

wwv_flow_api.create_message (
  p_id=>43152125270160204 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TEMPL_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating build option name=%0';

wwv_flow_api.create_message (
  p_id=>43152425564160205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_build_option_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error setting build option id="%0"';

wwv_flow_api.create_message (
  p_id=>43152713262160205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUILD_OPTION_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating navigation bar id="%0"';

wwv_flow_api.create_message (
  p_id=>43153010085160206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_nav_bar_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating navigation bar item id="%0"';

wwv_flow_api.create_message (
  p_id=>43153322672160207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_NAV_BAR_ITEM_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating  application process id="%0"';

wwv_flow_api.create_message (
  p_id=>43153630118160207 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_PROCESS_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_process_sql_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error setting process SQL ID="%0"';

wwv_flow_api.create_message (
  p_id=>43153929477160208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PROCESS_SQL_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating application item id="%0"';

wwv_flow_api.create_message (
  p_id=>43154214749160209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_ITEM_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_flow_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating application computation item="%0"';

wwv_flow_api.create_message (
  p_id=>43154501091160209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FLOW_COMPUTATION_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_std_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating standard tab id="%0"';

wwv_flow_api.create_message (
  p_id=>43154809513160210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_STD_TAB_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_tabset_rename
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error renaming tabset %1 to %0';

wwv_flow_api.create_message (
  p_id=>43155102953160211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_TABSET_RENAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_parent_tab_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating parent tab id="%0"';

wwv_flow_api.create_message (
  p_id=>43155403312160212 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PARENT_TAB_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lov_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating list of values id="%0"';

wwv_flow_api.create_message (
  p_id=>43155725353160213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LOV_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating page name="%0" id="%1"';

wwv_flow_api.create_message (
  p_id=>43156000444160214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_help_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating page %0 help text:';

wwv_flow_api.create_message (
  p_id=>43156327569160215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HELP_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_name_upd
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error updating page name="%0" id="%1"';

wwv_flow_api.create_message (
  p_id=>43156613941160217 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_NAME_UPD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_button_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating button name="%0" id="%1"';

wwv_flow_api.create_message (
  p_id=>43156931372160218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUTTON_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating branch id="%0"';

wwv_flow_api.create_message (
  p_id=>43157228933160218 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_branch_args_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating branch args id="%0"';

wwv_flow_api.create_message (
  p_id=>43157516147160219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BRANCH_ARGS_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error page=%0 item="%1" id="%2"';

wwv_flow_api.create_message (
  p_id=>43157814780160220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ITEM_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_computation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating page computation page=%0 item=%1 id="%2"';

wwv_flow_api.create_message (
  p_id=>43158108462160220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_COMPUTATION_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_validation_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating page validation page=%0 name=%1';

wwv_flow_api.create_message (
  p_id=>43158402074160221 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_VALIDATION_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_process_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating page process page=%0 name=%1';

wwv_flow_api.create_message (
  p_id=>43158726796160222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_PROCESS_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_lang_map_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating application translation map';

wwv_flow_api.create_message (
  p_id=>43159007433160223 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_LANG_MAP_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_on_table_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create page on table "%0"';

wwv_flow_api.create_message (
  p_id=>43159330171160225 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_ON_TABLE_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_invalid_report_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid report type';

wwv_flow_api.create_message (
  p_id=>43159625055160226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_INVALID_REPORT_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report page %0 exists, report region added.';

wwv_flow_api.create_message (
  p_id=>43159927661160226 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_page_has_buttons
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page %0 already has buttons.';

wwv_flow_api.create_message (
  p_id=>43160220690160227 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_PAGE_HAS_BUTTONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_form_added_to_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form added to existing page %0 .';

wwv_flow_api.create_message (
  p_id=>43160505612160228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_FORM_ADDED_TO_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_report_page_exists2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page %0 was not created because it already exists.';

wwv_flow_api.create_message (
  p_id=>43160828316160229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_REPORT_PAGE_EXISTS2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_bug_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating bug id="%0"';

wwv_flow_api.create_message (
  p_id=>43161128839160230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_BUG_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_shortcut_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating shortcut id="%0"';

wwv_flow_api.create_message (
  p_id=>43161401659160230 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_SHORTCUT_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_auth_scheme_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating authentication scheme name=%0';

wwv_flow_api.create_message (
  p_id=>43161722749160231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_AUTH_SCHEME_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_sgid_not_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package variable g_security_group_id must be set.';

wwv_flow_api.create_message (
  p_id=>43162319287160233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.SGID_NOT_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flow_id_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application ID %0 is reserved is Oracle Corporation ';

wwv_flow_api.create_message (
  p_id=>43162621072160235 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOW_ID_RESERVED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_flows_api_runtime_incompatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'API operation includes calls that are incompatible with the current runtime.';

wwv_flow_api.create_message (
  p_id=>43247607140629984 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.FLOWS_API_RUNTIME_INCOMPATIBLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'COMPATIBLE (You should be able to run this import without issues.)';

wwv_flow_api.create_message (
  p_id=>43346112185820732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.COMPATIBLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_not_compatible
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'NOT COMPATIBLE (Your export may contain calls not supported by your %0 version.)';

wwv_flow_api.create_message (
  p_id=>43346309752820732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.NOT_COMPATIBLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline_plus_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inline+Notification';

wwv_flow_api.create_message (
  p_id=>44700802474143274 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE_PLUS_NOTIFICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_inline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Inline';

wwv_flow_api.create_message (
  p_id=>44701315118184739 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INLINE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Notification';

wwv_flow_api.create_message (
  p_id=>44701726200187932 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_error_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error Page';

wwv_flow_api.create_message (
  p_id=>44702102090190437 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ERROR_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_location
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Location';

wwv_flow_api.create_message (
  p_id=>44703608632239612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOCATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_above_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Above Box';

wwv_flow_api.create_message (
  p_id=>44704526565339448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.ABOVE_BOX',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_below_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Below Box';

wwv_flow_api.create_message (
  p_id=>44704702905339448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BELOW_BOX',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bottom';

wwv_flow_api.create_message (
  p_id=>44705029784339449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.BOTTOM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Change';

wwv_flow_api.create_message (
  p_id=>44705313948339450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CHANGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Close';

wwv_flow_api.create_message (
  p_id=>44705631841339450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CLOSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Copy';

wwv_flow_api.create_message (
  p_id=>44705918949339451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_COPY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Create';

wwv_flow_api.create_message (
  p_id=>44706203815339451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Delete';

wwv_flow_api.create_message (
  p_id=>44706514748339452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_DELETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Edit';

wwv_flow_api.create_message (
  p_id=>44706832225339453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EDIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Expand';

wwv_flow_api.create_message (
  p_id=>44707100026339454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_EXPAND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Next';

wwv_flow_api.create_message (
  p_id=>44707405818339455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_NEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_region_template_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Previous';

wwv_flow_api.create_message (
  p_id=>44707723003339455 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.REGION_TEMPLATE_PREVIOUS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_button_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Top';

wwv_flow_api.create_message (
  p_id=>44708019235339456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.BUTTON.TOP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branch To Page Accept';

wwv_flow_api.create_message (
  p_id=>44710519133574890 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_ACCEPT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_page_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branch To Page Identified By Item';

wwv_flow_api.create_message (
  p_id=>44710721646574891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PAGE_IDENTIFIED_BY_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_url_identified_by_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branch To URL Identified By Item';

wwv_flow_api.create_message (
  p_id=>44711011339574891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_URL_IDENTIFIED_BY_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branch To Function Returning Page';

wwv_flow_api.create_message (
  p_id=>44711332705574892 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_function_returning_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branch To Function Returning URL';

wwv_flow_api.create_message (
  p_id=>44711619621574893 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_FUNCTION_RETURNING_URL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branch To PL/SQL Procedure';

wwv_flow_api.create_message (
  p_id=>44711918994574893 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PLSQL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'none';

wwv_flow_api.create_message (
  p_id=>44712824393632174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_unconditional
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unconditional';

wwv_flow_api.create_message (
  p_id=>44714303231673362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_UNCONDITIONAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_standard_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'standard condition';

wwv_flow_api.create_message (
  p_id=>44715121501697537 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STANDARD_CONDITION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'never';

wwv_flow_api.create_message (
  p_id=>44717208744797959 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NEVER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4656_default_calendar_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Default Calendar Template';

wwv_flow_api.create_message (
  p_id=>45552716768382833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4656.DEFAULT_CALENDAR_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calendar';

wwv_flow_api.create_message (
  p_id=>45554027073404674 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_no_ddl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No %0 found to generate DDL.';

wwv_flow_api.create_message (
  p_id=>46196218202976259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.NO_DDL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_edit_report_err_updating_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error updating report columns: %0';

wwv_flow_api.create_message (
  p_id=>46523525314509701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_EDIT_REPORT.ERR_UPDATING_COLS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_unknown_workspace_colon
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unknown Workspace Name: %0';

wwv_flow_api.create_message (
  p_id=>46712915547065819 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH_UNKNOWN_WORKSPACE_COLON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_migrate_svg_to_flash_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Migrate SVG chart to Flash chart error. %0';

wwv_flow_api.create_message (
  p_id=>46724629754145642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MIGRATE_SVG_TO_FLASH_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_to_flash
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to migrate the SVG chart to Flash chart.  Please confirm your request.';

wwv_flow_api.create_message (
  p_id=>46897809780048121 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_TO_FLASH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_run_stmt_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Execution  of the statement was unsuccessful. %0'||chr(10)||
'<pre>%1</pre>';

wwv_flow_api.create_message (
  p_id=>46967317318081153 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.RUN_STMT_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_stmt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'GET_STMT error. %0';

wwv_flow_api.create_message (
  p_id=>46969221735101308 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_STMT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_get_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'GET_BLOCK Error. %0';

wwv_flow_api.create_message (
  p_id=>46970011824107886 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.GET_BLOCK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_file_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find the file. %0';

wwv_flow_api.create_message (
  p_id=>46971307106116025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_FILE_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_date_picker
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date Picker';

wwv_flow_api.create_message (
  p_id=>47018929658539168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DATE_PICKER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hidden';

wwv_flow_api.create_message (
  p_id=>47019704639550869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.HIDDEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_file_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'File Browse';

wwv_flow_api.create_message (
  p_id=>47021613428562918 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.FILE_BROWSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_stop_and_start_html_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Stop and start table';

wwv_flow_api.create_message (
  p_id=>47022710096571409 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.STOP_AND_START_HTML_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_list_manager
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'List Manager';

wwv_flow_api.create_message (
  p_id=>47026331052615219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.LIST_MANAGER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_check_box
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Check Box';

wwv_flow_api.create_message (
  p_id=>47029914261648309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.CHECK_BOX',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_display_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display Only';

wwv_flow_api.create_message (
  p_id=>47030321187650283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.DISPLAY_ONLY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_multiple_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Multiple Select';

wwv_flow_api.create_message (
  p_id=>47030930191652908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.MULTIPLE_SELECT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_popup_list_of_values
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup List of Values';

wwv_flow_api.create_message (
  p_id=>47031906427655458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.POPUP_LIST_OF_VALUES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_radio
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Radio';

wwv_flow_api.create_message (
  p_id=>47043021318659776 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.RADIO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Select List';

wwv_flow_api.create_message (
  p_id=>47043630668662450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SELECT_LIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Text';

wwv_flow_api.create_message (
  p_id=>47044303787664128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_text_area
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Text Area';

wwv_flow_api.create_message (
  p_id=>47044909328665739 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.TEXT_AREA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message item_name_shuttle
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Shuttle';

wwv_flow_api.create_message (
  p_id=>47045314869667369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ITEM_NAME.SHUTTLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message copy_list_entry
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copy List Entry';

wwv_flow_api.create_message (
  p_id=>47542815619438356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COPY_LIST_ENTRY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_no_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You do not have privs on the %0 schema.';

wwv_flow_api.create_message (
  p_id=>47875313297451598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.NO_PRIV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_images_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No images found';

wwv_flow_api.create_message (
  p_id=>48095106818801006 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_IMAGES_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_check_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unauthorized access (security group package variable not set).';

wwv_flow_api.create_message (
  p_id=>48282408156372544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CHECK_SGID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_user_group
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User group did not create because it already exists.';

wwv_flow_api.create_message (
  p_id=>48283201492389477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_USER_GROUP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_company
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace did not create because it already exists.';

wwv_flow_api.create_message (
  p_id=>48283924695396263 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_COMPANY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_create_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User was not created for the following reason: %0';

wwv_flow_api.create_message (
  p_id=>48284319631404256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.CREATE_FND_USER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_user_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User %0 does not exist.';

wwv_flow_api.create_message (
  p_id=>48285131190417009 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_USER_EXIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_no_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User %0 has not supplied an e-mail address.';

wwv_flow_api.create_message (
  p_id=>48286117469422535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.NO_EMAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_fetch_fnd_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cannot fetch fnd user information. %0';

wwv_flow_api.create_message (
  p_id=>48286710328429891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.FETCH_FND_USER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'notification message checksum format error: %0';

wwv_flow_api.create_message (
  p_id=>50064830027392530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_notification_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'notification message checksum content error: %0 : %1';

wwv_flow_api.create_message (
  p_id=>50065207995395664 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOTIFICATION_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_format_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'print success message checksum format error: %0';

wwv_flow_api.create_message (
  p_id=>50065620116399137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_FORMAT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_print_success_msg_checksum_content_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'print success message checksum content error: %0 : %1';

wwv_flow_api.create_message (
  p_id=>50066027734401392 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PRINT_SUCCESS_MSG_CHECKSUM_CONTENT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_success
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The %0 demonstration application was created.';

wwv_flow_api.create_message (
  p_id=>50835403776295415 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_SUCCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_flow_created_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'There was not enough space to create this demonstration.  Request additional storage by going to the administration page, and clicking on the "Request Changes to Current Service" link.';

wwv_flow_api.create_message (
  p_id=>50836014165298463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_FLOW.CREATED_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message 4150_column_number
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Column %0';

wwv_flow_api.create_message (
  p_id=>51155503034194159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'4150_COLUMN_NUMBER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message cached
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cached';

wwv_flow_api.create_message (
  p_id=>51319200328373190 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message valid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Valid';

wwv_flow_api.create_message (
  p_id=>51596219494412799 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message expired
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Expired';

wwv_flow_api.create_message (
  p_id=>51596623304413900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EXPIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_enabled
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enabled';

wwv_flow_api.create_message (
  p_id=>55197630736647713 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ENABLED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Highlight Type';

wwv_flow_api.create_message (
  p_id=>55201524765664909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cell
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cell';

wwv_flow_api.create_message (
  p_id=>55204220740673262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CELL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_bgcolor
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Background Color';

wwv_flow_api.create_message (
  p_id=>55205511867680078 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BGCOLOR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yellow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'yellow';

wwv_flow_api.create_message (
  p_id=>55206607150688197 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YELLOW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_green
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'green';

wwv_flow_api.create_message (
  p_id=>55207521349692280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_GREEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_orange
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'orange';

wwv_flow_api.create_message (
  p_id=>55210215939700214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ORANGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_text_color
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Text Color';

wwv_flow_api.create_message (
  p_id=>55268503144847900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TEXT_COLOR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_highlight_when
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Highlight When';

wwv_flow_api.create_message (
  p_id=>55272404660857836 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HIGHLIGHT_WHEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'like';

wwv_flow_api.create_message (
  p_id=>55315230774950512 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_LIKE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'not like';

wwv_flow_api.create_message (
  p_id=>55316921208957189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_LIKE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'is null';

wwv_flow_api.create_message (
  p_id=>55318611989964021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'is not null';

wwv_flow_api.create_message (
  p_id=>55319901038970318 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_NOT_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'in';

wwv_flow_api.create_message (
  p_id=>55347016369031442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'not in';

wwv_flow_api.create_message (
  p_id=>55575725934374869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_NOT_IN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_save
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Save';

wwv_flow_api.create_message (
  p_id=>56101209095079534 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SAVE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_ascending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ascending';

wwv_flow_api.create_message (
  p_id=>56121529817331496 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ASCENDING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_descending
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Descending';

wwv_flow_api.create_message (
  p_id=>56122013325336209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCENDING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Select Category -';

wwv_flow_api.create_message (
  p_id=>56145302739843998 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_CATEGORY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>56650124284172631 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence';

wwv_flow_api.create_message (
  p_id=>56650811256178248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SEQUENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Yes';

wwv_flow_api.create_message (
  p_id=>56651405499186098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_YES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No';

wwv_flow_api.create_message (
  p_id=>56652429741193065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Row';

wwv_flow_api.create_message (
  p_id=>56652902298204065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_blue
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'blue';

wwv_flow_api.create_message (
  p_id=>56653623769210273 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BLUE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_red
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'red';

wwv_flow_api.create_message (
  p_id=>56654520784218910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Displayed';

wwv_flow_api.create_message (
  p_id=>56656312734235446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_other
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Other';

wwv_flow_api.create_message (
  p_id=>56656925201239065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_OTHER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Value';

wwv_flow_api.create_message (
  p_id=>56658211480244598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VALUE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Column';

wwv_flow_api.create_message (
  p_id=>56667712650254418 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cancel';

wwv_flow_api.create_message (
  p_id=>56829327541258698 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CANCEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Delete';

wwv_flow_api.create_message (
  p_id=>56831711873273118 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Select Column -';

wwv_flow_api.create_message (
  p_id=>57104706042725473 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_COLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The application installer has detected that this application''s supporting objects were previously installed.  This wizard will guide you through the process of upgrading these supporting objects.';

wwv_flow_api.create_message (
  p_id=>57756131411818027 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message caching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Caching';

wwv_flow_api.create_message (
  p_id=>57817322051089744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CACHING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branch=';

wwv_flow_api.create_message (
  p_id=>57889413654278690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.BRANCH=',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4045_menu_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Breadcrumb Entry=';

wwv_flow_api.create_message (
  p_id=>57890528545282953 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P4045.MENU_OPTION=',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_success_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your application''s supporting objects have been upgraded.';

wwv_flow_api.create_message (
  p_id=>58028724952450028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_SUCCESS_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_failure_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The upgrade of this application''s supporting objects has failed.';

wwv_flow_api.create_message (
  p_id=>58031908460454743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_FAILURE_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message installer_upgrade_confirm_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please confirm that you would like to upgrade this application''s supporting objects.';

wwv_flow_api.create_message (
  p_id=>58033415386456711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTALLER.UPGRADE_CONFIRM_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message yes_by_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Yes, By User';

wwv_flow_api.create_message (
  p_id=>58422019512981075 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YES_BY_USER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message set_binds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Values for all bind variables must be set when testing a query.';

wwv_flow_api.create_message (
  p_id=>58564323882322968 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SET_BINDS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Newly Created Login Page: Use LDAP Directory Credentials';

wwv_flow_api.create_message (
  p_id=>58960510807244588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6A',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create6b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Existing Login Page: Use LDAP Directory Credentials';

wwv_flow_api.create_message (
  p_id=>58960929854250135 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE6B',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4a
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Newly Created Login Page: Use %0 Account Credentials';

wwv_flow_api.create_message (
  p_id=>58961322020257300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4A',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_create4b
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Existing Login Page: Use %0 Account Credentials';

wwv_flow_api.create_message (
  p_id=>58961731717260145 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_CREATE4B',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_flash_chart_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Flash Chart error: %0';

wwv_flow_api.create_message (
  p_id=>59210915187434711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.FLASH_CHART_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message report_queries_valid_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Query is valid. Bind variables parsed.';

wwv_flow_api.create_message (
  p_id=>59709016412598666 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REPORT_QUERIES.VALID_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No page selected.';

wwv_flow_api.create_message (
  p_id=>59774515813203410 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page';

wwv_flow_api.create_message (
  p_id=>59775309710211150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create';

wwv_flow_api.create_message (
  p_id=>59775824255215297 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CREATE_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit';

wwv_flow_api.create_message (
  p_id=>59776217806222962 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EDIT_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_copy_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copy';

wwv_flow_api.create_message (
  p_id=>59776605817228943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COPY_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_view_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View';

wwv_flow_api.create_message (
  p_id=>59782830844292891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VIEW_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page not found.';

wwv_flow_api.create_message (
  p_id=>59791316440373896 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>59792512415382241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Title';

wwv_flow_api.create_message (
  p_id=>59793124882385840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alias';

wwv_flow_api.create_message (
  p_id=>59794305536408585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ALIAS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template';

wwv_flow_api.create_message (
  p_id=>59794715363420872 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_invalid_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid template';

wwv_flow_api.create_message (
  p_id=>59795129908425096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_INVALID_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Std. TabSet';

wwv_flow_api.create_message (
  p_id=>59795527615433881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TABSET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authorization
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authorization';

wwv_flow_api.create_message (
  p_id=>59795911816438802 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHORIZATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Build Option';

wwv_flow_api.create_message (
  p_id=>59796308138447206 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BUILD_OPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentication';

wwv_flow_api.create_message (
  p_id=>59796719566450507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_AUTHENTICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Public';

wwv_flow_api.create_message (
  p_id=>59797130301453638 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_PUBLIC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Required';

wwv_flow_api.create_message (
  p_id=>59804130254775289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_REQUIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regions';

wwv_flow_api.create_message (
  p_id=>59804516879780938 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display_pt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display&nbsp;Point:&nbsp;';

wwv_flow_api.create_message (
  p_id=>59805009738788295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY_PT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page "%0" has no regions.';

wwv_flow_api.create_message (
  p_id=>59806031555794600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Buttons';

wwv_flow_api.create_message (
  p_id=>59806705423900598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Items';

wwv_flow_api.create_message (
  p_id=>59807114427903172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Computations';

wwv_flow_api.create_message (
  p_id=>59807523084905749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page 0 does not support computations.  Computations which should occur on every page should be handled by application level computations.';

wwv_flow_api.create_message (
  p_id=>59807915943913099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page 0 does not support processes.  Processes which should occur on every page should be handled by application level processes.';

wwv_flow_api.create_message (
  p_id=>59808328410916757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page "%0" has no onLoad computations.';

wwv_flow_api.create_message (
  p_id=>59808811918921420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_COMPUTATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Processes';

wwv_flow_api.create_message (
  p_id=>59809301660927899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onload_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page "%0" has no onLoad processes.';

wwv_flow_api.create_message (
  p_id=>59809813781931382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONLOAD_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_zero_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page 0 does not support branches, computations, processes, or validations.  Computations and processes which should occur on every page should be handled by application level computations and processes.';

wwv_flow_api.create_message (
  p_id=>59839218451245003 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ZERO_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page "%0" has no onSubmit computations.';

wwv_flow_api.create_message (
  p_id=>59839701613249626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_COMPUTATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validations';

wwv_flow_api.create_message (
  p_id=>59841511440261941 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page "%0" has no validations.';

wwv_flow_api.create_message (
  p_id=>59842028409266857 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_onsubmit_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page "%0" has no onSubmit processes.';

wwv_flow_api.create_message (
  p_id=>59842532003277285 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ONSUBMIT_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Branching';

wwv_flow_api.create_message (
  p_id=>59843023823284373 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCHING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page "%0" has no branches.';

wwv_flow_api.create_message (
  p_id=>59843405254288560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BRANCHING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Tabs';

wwv_flow_api.create_message (
  p_id=>59869419255453405 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PARENT_TAB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No parent level tabs';

wwv_flow_api.create_message (
  p_id=>59873130384485037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_PARENT_TAB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard&nbsp;Tabs';

wwv_flow_api.create_message (
  p_id=>59876101210495492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_STD_TAB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tab Set';

wwv_flow_api.create_message (
  p_id=>59876712638498845 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TAB_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page %0 has no tab set.';

wwv_flow_api.create_message (
  p_id=>59878128914503551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TAB_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigation&nbsp;Bar';

wwv_flow_api.create_message (
  p_id=>59878608267507005 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAV_BAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application "%0" has no navBar.';

wwv_flow_api.create_message (
  p_id=>59879123851511553 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_NAV_BAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message region_templates_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Template';

wwv_flow_api.create_message (
  p_id=>59935122259946294 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGION_TEMPLATES_NO_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No page selected.';

wwv_flow_api.create_message (
  p_id=>60033713508237094 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No regions';

wwv_flow_api.create_message (
  p_id=>60035418487248023 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No computations';

wwv_flow_api.create_message (
  p_id=>60038709960255034 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_COMPUTATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No processes';

wwv_flow_api.create_message (
  p_id=>60039722427258589 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No validations';

wwv_flow_api.create_message (
  p_id=>60040203858262737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_flow_no_branching
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Branches';

wwv_flow_api.create_message (
  p_id=>60040615286266028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FLOW_NO_BRANCHING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'warning';

wwv_flow_api.create_message (
  p_id=>60043115071275402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_WARNING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create region';

wwv_flow_api.create_message (
  p_id=>60043724075277999 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create process';

wwv_flow_api.create_message (
  p_id=>60044806890282476 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create computation';

wwv_flow_api.create_message (
  p_id=>60045216587285333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPUTATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create validation';

wwv_flow_api.create_message (
  p_id=>60046926976288329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create branch';

wwv_flow_api.create_message (
  p_id=>60048007021292033 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BRANCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create region';

wwv_flow_api.create_message (
  p_id=>60049119142295555 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create computation';

wwv_flow_api.create_message (
  p_id=>60049801265299778 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_COMPUTATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create process';

wwv_flow_api.create_message (
  p_id=>60051513732303448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create validation';

wwv_flow_api.create_message (
  p_id=>60052628623307730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create branch';

wwv_flow_api.create_message (
  p_id=>60054005206310407 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BRANCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_changed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your password for %0 has been changed.';

wwv_flow_api.create_message (
  p_id=>60159707268527732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_CHANGED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message email_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Email address "%0" was not found.';

wwv_flow_api.create_message (
  p_id=>60160128393533808 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'EMAIL_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message change_pw_request
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Request';

wwv_flow_api.create_message (
  p_id=>60161303637564471 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHANGE_PW_REQUEST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'down';

wwv_flow_api.create_message (
  p_id=>60342825318961257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ARROW_DOWN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create button';

wwv_flow_api.create_message (
  p_id=>60343602939964259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create item';

wwv_flow_api.create_message (
  p_id=>60344311943966813 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'region title';

wwv_flow_api.create_message (
  p_id=>60345020947969391 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create button';

wwv_flow_api.create_message (
  p_id=>60345802031973448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'edit button';

wwv_flow_api.create_message (
  p_id=>60346913460976743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_create_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create item';

wwv_flow_api.create_message (
  p_id=>60347821771979161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_CREATE_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_button_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'edit button item';

wwv_flow_api.create_message (
  p_id=>60348600085982345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_BUTTON_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_title_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'edit item';

wwv_flow_api.create_message (
  p_id=>60350015668986795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TITLE_EDIT_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_on_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace %0 has no privileges to parse as schema %1.';

wwv_flow_api.create_message (
  p_id=>60370026495440424 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ON_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button_w_no_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Buttons with no regions';

wwv_flow_api.create_message (
  p_id=>60458420853612838 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON_W_NO_REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_button
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page "%0" has no buttons.';

wwv_flow_api.create_message (
  p_id=>60459504015617458 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_BUTTON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page "%0" has no items.';

wwv_flow_api.create_message (
  p_id=>60461318213621556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_item_exceeds_max
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item count exceeds maximum of 100.';

wwv_flow_api.create_message (
  p_id=>60463128949624664 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ITEM_EXCEEDS_MAX',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Title';

wwv_flow_api.create_message (
  p_id=>60529224606859949 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit';

wwv_flow_api.create_message (
  p_id=>60531407768864533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EDIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message password_reset_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password Reset Notification';

wwv_flow_api.create_message (
  p_id=>60532511020564521 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PASSWORD_RESET_NOTIFICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_expand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Expand';

wwv_flow_api.create_message (
  p_id=>60532916772867071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_EXPAND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message account_has_been_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your %0 account has been created.';

wwv_flow_api.create_message (
  p_id=>60533207866610929 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCOUNT_HAS_BEEN_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_login_instructions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You can log in to %0 by going to:';

wwv_flow_api.create_message (
  p_id=>60533628083626283 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_LOGIN_INSTRUCTIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create';

wwv_flow_api.create_message (
  p_id=>60534024390869310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_account_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'New %0 Account Notification';

wwv_flow_api.create_message (
  p_id=>60534030638636489 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_ACCOUNT_NOTIFICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_create2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create';

wwv_flow_api.create_message (
  p_id=>60535003397872748 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CREATE2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Close';

wwv_flow_api.create_message (
  p_id=>60535611362874995 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CLOSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Body';

wwv_flow_api.create_message (
  p_id=>60536620019877560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form Open';

wwv_flow_api.create_message (
  p_id=>60537930062880430 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_OPEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form Close';

wwv_flow_api.create_message (
  p_id=>60539809761884027 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_FORM_CLOSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Help';

wwv_flow_api.create_message (
  p_id=>60540718073886389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Delete';

wwv_flow_api.create_message (
  p_id=>60541526384888796 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_DELETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copy';

wwv_flow_api.create_message (
  p_id=>60542502274891307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COPY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Next';

wwv_flow_api.create_message (
  p_id=>60543710239893614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Previous';

wwv_flow_api.create_message (
  p_id=>60544622706897233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PREVIOUS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_change
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Change';

wwv_flow_api.create_message (
  p_id=>60545200327900229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_CHANGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template';

wwv_flow_api.create_message (
  p_id=>60545913833904117 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Themes';

wwv_flow_api.create_message (
  p_id=>60665129251652087 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEMES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Nav Bar';

wwv_flow_api.create_message (
  p_id=>60676502554411798 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NAV_BAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Notification';

wwv_flow_api.create_message (
  p_id=>60677116752415943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_NOTIFICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_global_notification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Global Notification';

wwv_flow_api.create_message (
  p_id=>60677801300420896 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_GLOBAL_NOTIFICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_template_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Body';

wwv_flow_api.create_message (
  p_id=>60679621385426747 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TEMPLATE_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Success Message';

wwv_flow_api.create_message (
  p_id=>60680301431430444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_SUCCESS_MSG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Title';

wwv_flow_api.create_message (
  p_id=>60680711127433265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Body Title';

wwv_flow_api.create_message (
  p_id=>60682621170436122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_BODY_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_region_position
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position';

wwv_flow_api.create_message (
  p_id=>60684806756441376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_REGION_POSITION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabs';

wwv_flow_api.create_message (
  p_id=>60687423033446084 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_STD_TAB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_parent_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Tabs';

wwv_flow_api.create_message (
  p_id=>60688732729448927 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_PARENT_TAB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_application_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Tabs';

wwv_flow_api.create_message (
  p_id=>60690611735452334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_APPLICATION_TAB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_alt_company_img
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace Images';

wwv_flow_api.create_message (
  p_id=>60693522817455506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ALT_COMPANY_IMG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Yes';

wwv_flow_api.create_message (
  p_id=>60695100785458587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_YES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No';

wwv_flow_api.create_message (
  p_id=>60696616368463162 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_header_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Header Template';

wwv_flow_api.create_message (
  p_id=>60697329182466796 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_HEADER_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Body';

wwv_flow_api.create_message (
  p_id=>60697705071469290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_footer_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Footer Template';

wwv_flow_api.create_message (
  p_id=>60698216153472468 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FOOTER_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_substitution
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Substitution';

wwv_flow_api.create_message (
  p_id=>60699127581475776 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUBSTITUTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Referenced';

wwv_flow_api.create_message (
  p_id=>60704106372488603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REFERENCED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'From';

wwv_flow_api.create_message (
  p_id=>60705517800491894 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FROM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>60706709966499159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DESCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_onload
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Onload';

wwv_flow_api.create_message (
  p_id=>60707820009502013 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_ONLOAD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_title2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Title';

wwv_flow_api.create_message (
  p_id=>60709727413513600 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_TITLE2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_head
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Head';

wwv_flow_api.create_message (
  p_id=>60710710228518161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_HEAD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML Form Open';

wwv_flow_api.create_message (
  p_id=>60712610706527720 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_OPEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_notification_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Notification Message';

wwv_flow_api.create_message (
  p_id=>60714130792533516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NOTIFICATION_MSG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_success_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Success Message';

wwv_flow_api.create_message (
  p_id=>60715008759536647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_SUCCESS_MSG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Body';

wwv_flow_api.create_message (
  p_id=>60716019841539852 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_page_body_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Body Title';

wwv_flow_api.create_message (
  p_id=>60717130576542910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PAGE_BODY_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_form_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML Form Close';

wwv_flow_api.create_message (
  p_id=>60719727375560882 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_FORM_CLOSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position1';

wwv_flow_api.create_message (
  p_id=>60722230969571454 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position2';

wwv_flow_api.create_message (
  p_id=>60724917725586474 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position3';

wwv_flow_api.create_message (
  p_id=>60725427422589335 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position4';

wwv_flow_api.create_message (
  p_id=>60726103658591884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position5';

wwv_flow_api.create_message (
  p_id=>60726513701594853 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS5',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position6';

wwv_flow_api.create_message (
  p_id=>60726926168598420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS6',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position7';

wwv_flow_api.create_message (
  p_id=>60727404482601659 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS7',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region_pos8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Position8';

wwv_flow_api.create_message (
  p_id=>60727913832604345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION_POS8',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_detail_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail View';

wwv_flow_api.create_message (
  p_id=>60924217260358256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_DETAIL_VIEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'action';

wwv_flow_api.create_message (
  p_id=>60952132655774337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_ACTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'condition';

wwv_flow_api.create_message (
  p_id=>60952812354777932 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_CONDITION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_exp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'exp';

wwv_flow_api.create_message (
  p_id=>60953424474781389 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_EXP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display';

wwv_flow_api.create_message (
  p_id=>60953900018783866 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_DISPLAY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_button2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'button';

wwv_flow_api.create_message (
  p_id=>60954308329786255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BUTTON2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_branch_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Go To Page';

wwv_flow_api.create_message (
  p_id=>60954819411789444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_BRANCH_TO_PG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_redirect_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Go To Page';

wwv_flow_api.create_message (
  p_id=>60955229107792245 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REDIRECT_TO_PG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_navigate_to_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigates to page';

wwv_flow_api.create_message (
  p_id=>60957530801840050 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NAVIGATE_TO_PG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message views2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Views';

wwv_flow_api.create_message (
  p_id=>61006900001457361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEWS2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation';

wwv_flow_api.create_message (
  p_id=>61008606073097793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_VALIDATION2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_process2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Process';

wwv_flow_api.create_message (
  p_id=>61009617847101231 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_PROCESS2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_computation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Computation';

wwv_flow_api.create_message (
  p_id=>61010529275104511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_COMPUTATION2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_chart_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chart by %0';

wwv_flow_api.create_message (
  p_id=>61013630438513480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_CHART_BY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message quick_app_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'By %0';

wwv_flow_api.create_message (
  p_id=>61016502303524210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUICK_APP_BY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_region2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region';

wwv_flow_api.create_message (
  p_id=>61019220954376530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_REGION2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>61181601208769995 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'THEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application';

wwv_flow_api.create_message (
  p_id=>61406830577491461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_FLOW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_paren_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(deprecated)';

wwv_flow_api.create_message (
  p_id=>61407218634525803 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_PAREN_DEPRECATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_convert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 authentication is a deprecated method. We recommend that you click the "make current" link (shown above) on one of the authentication schemes in this application, or create a new authentication scheme and make it current. The INTERNAL-SETUP authentication scheme is functionally equivalent to the %0 method.';

wwv_flow_api.create_message (
  p_id=>61407622275564684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_CONVERT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit deprecated authentication attributes';

wwv_flow_api.create_message (
  p_id=>61409019186790889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'deprecated attributes';

wwv_flow_api.create_message (
  p_id=>61409427628802834 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'or leave them in place until you are ready to change the authentication method to %0.';

wwv_flow_api.create_message (
  p_id=>61409831700822962 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Review or edit session management attributes'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>61410307851844396 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW5',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_scheme_desc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Uses authentication schemes to control user authentication and all other aspects of session management for your application.';

wwv_flow_api.create_message (
  p_id=>61411327422887901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_SCHEME_DESC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Specifies one or more deprecated authentication attributes.';

wwv_flow_api.create_message (
  p_id=>61412206737938755 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_review6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Review or edit these';

wwv_flow_api.create_message (
  p_id=>61413104575957016 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_REVIEW6',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_edit_deprecated5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'or migrate them to an authentication scheme.';

wwv_flow_api.create_message (
  p_id=>61413803583985128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_EDIT_DEPRECATED5',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message month
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Month';

wwv_flow_api.create_message (
  p_id=>61687704055574299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_version
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Version';

wwv_flow_api.create_message (
  p_id=>61757126897645969 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_VERSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_dbname
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Database Name';

wwv_flow_api.create_message (
  p_id=>61758013522651580 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_DBNAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p13_linked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Linked';

wwv_flow_api.create_message (
  p_id=>61775905632904693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P13_LINKED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_as_app_on_exist_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'As an application on a database table';

wwv_flow_api.create_message (
  p_id=>62016702554585619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_AS_APP_ON_EXIST_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_show_xml
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show XML';

wwv_flow_api.create_message (
  p_id=>63364731340343571 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.SHOW_XML',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_query_headings
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'unable to determine query headings:'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>63428300952482241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_QUERY_HEADINGS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_determine_pagination
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error determining pagination string';

wwv_flow_api.create_message (
  p_id=>63431709525503579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_DETERMINE_PAGINATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_report_footer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'error performing report footer replacements';

wwv_flow_api.create_message (
  p_id=>63433031689509999 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_REPORT_FOOTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_err_proc_function_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'unable to process function body returning query:'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>63435513943523799 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.ERR_PROC_FUNCTION_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_failed_parsing_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'failed to parse SQL query:'||chr(10)||
'%0'||chr(10)||
'%1';

wwv_flow_api.create_message (
  p_id=>63440902262577213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FAILED_PARSING_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_report_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'report error:'||chr(10)||
'%0';

wwv_flow_api.create_message (
  p_id=>63441406071578348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.REPORT_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_invalid_lov_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup List of Values query is invalid, a display and a return value are needed, the column names need to be  different';

wwv_flow_api.create_message (
  p_id=>63684610778544812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INVALID_LOV_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_new_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- New Category -';

wwv_flow_api.create_message (
  p_id=>63857427647172147 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NEW_CATEGORY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_no_edit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(Not Editable)';

wwv_flow_api.create_message (
  p_id=>64444024838131113 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_NO_EDIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p801_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'current';

wwv_flow_api.create_message (
  p_id=>64444629386160793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P801_CURRENT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_wizard_api_create_flash_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create Flash chart. %0';

wwv_flow_api.create_message (
  p_id=>64796427311869122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WIZARD_API.CREATE_FLASH_CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid';

wwv_flow_api.create_message (
  p_id=>64798307750901265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INVALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_included
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Included';

wwv_flow_api.create_message (
  p_id=>64798827143906899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_INCLUDED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p2_databases
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Databases';

wwv_flow_api.create_message (
  p_id=>64809603781013715 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P2_DATABASES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p802_lov_no_scheme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- no scheme -';

wwv_flow_api.create_message (
  p_id=>65386729108453214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P802_LOV_NO_SCHEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message initcap_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Refresh';

wwv_flow_api.create_message (
  p_id=>65392128733576156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INITCAP_REFRESH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message y
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Y';

wwv_flow_api.create_message (
  p_id=>65392502545578032 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'Y',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_schema_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The application''s parsing schema "%0" does not exist in the database.';

wwv_flow_api.create_message (
  p_id=>65559422408024213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SCHEMA_NOT_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Open:';

wwv_flow_api.create_message (
  p_id=>65748223996146025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.OPEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p4790_date_timestamp_note
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(containing Date or Timestamp column)';

wwv_flow_api.create_message (
  p_id=>65785219203598803 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P4790_DATE_TIMESTAMP_NOTE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_bipub_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Printing support must be either STANDARD or ADVANCED';

wwv_flow_api.create_message (
  p_id=>66173618008083723 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_BIPUB_OPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_first_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cannot remove first schema provisioned';

wwv_flow_api.create_message (
  p_id=>66174023549085299 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_FIRST_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_port
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid port number';

wwv_flow_api.create_message (
  p_id=>66174529782087088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_PORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wallet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Wallet path must be in the form file:<filesystempath>';

wwv_flow_api.create_message (
  p_id=>66174904979089370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WALLET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_parm_notfound
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Instance parameter not found';

wwv_flow_api.create_message (
  p_id=>66175510866091123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PARM_NOTFOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_builtin_login_pg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Built-in Login Page';

wwv_flow_api.create_message (
  p_id=>66222117896903331 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_BUILTIN_LOGIN_PG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_page_in_this_flow
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page in This Application';

wwv_flow_api.create_message (
  p_id=>66222528070915744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_PAGE_IN_THIS_FLOW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>66222921275923177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_URL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_sso_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On';

wwv_flow_api.create_message (
  p_id=>66223311363929820 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_SSO_SERVER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p806_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'None';

wwv_flow_api.create_message (
  p_id=>66223700066935976 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P806_NONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_auth_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use %0 account username and password to authenticate.';

wwv_flow_api.create_message (
  p_id=>66225200675955094 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_AUTH_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_no_verify_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Do not verify credentials';

wwv_flow_api.create_message (
  p_id=>66225621930970736 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_NO_VERIFY_CRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use an LDAP server to authenticate.';

wwv_flow_api.create_message (
  p_id=>66226003361974800 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_LDAP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p808_use_custom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use my custom function to authenticate.';

wwv_flow_api.create_message (
  p_id=>66226423793980669 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P808_USE_CUSTOM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_scratch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'From scratch';

wwv_flow_api.create_message (
  p_id=>66228911719005572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_SCRATCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'As a copy of an existing authentication scheme';

wwv_flow_api.create_message (
  p_id=>66229313582015577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_COPY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p815_gallery
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Based on a pre-configured scheme from the gallery';

wwv_flow_api.create_message (
  p_id=>66229703670022247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P815_GALLERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_use_dad
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Authentication (using DAD)';

wwv_flow_api.create_message (
  p_id=>66231916745044942 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_USE_DAD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_moc_sso
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SSO Cookie (my.oracle.com -- Oracle Use Only)';

wwv_flow_api.create_message (
  p_id=>66232328650057784 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MOC_SSO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_account_cred
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show Login Page and Use %0 Account Credentials';

wwv_flow_api.create_message (
  p_id=>66232732245068270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_ACCOUNT_CRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_builtin_pg_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show Built-In Login Page and Use Open Door Credentials';

wwv_flow_api.create_message (
  p_id=>66233124757075644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_BUILTIN_PG_OPEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_show_use_ldap
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show Login Page and Use LDAP Directory Credentials';

wwv_flow_api.create_message (
  p_id=>66233507919080219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SHOW_USE_LDAP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_sso_htmldb_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (%0 Engine as Partner App)';

wwv_flow_api.create_message (
  p_id=>66233902509088076 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_SSO_HTMLDB_PARTNER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p820_my_partner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Application Server Single Sign-On (My Application as Partner App)';

wwv_flow_api.create_message (
  p_id=>66234300562097054 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P820_MY_PARTNER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p826_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'New';

wwv_flow_api.create_message (
  p_id=>66235709959128137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P826_NEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_printsvr_protocol
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Print server protocol must be either http or https';

wwv_flow_api.create_message (
  p_id=>66312611523315675 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_PRINTSVR_PROTOCOL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema does not exist';

wwv_flow_api.create_message (
  p_id=>66313020874318381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_schema_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema is restricted';

wwv_flow_api.create_message (
  p_id=>66313428492320660 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_SCHEMA_RESTRICTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_admin_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'access control - administrator';

wwv_flow_api.create_message (
  p_id=>66768901771821180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_ADMIN_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_edit_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'access control - edit';

wwv_flow_api.create_message (
  p_id=>66770728090828700 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_EDIT_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_view_auth
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'access control - view';

wwv_flow_api.create_message (
  p_id=>66771912075843074 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_VIEW_AUTH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Accounts in the INTERNAL workspace can be used only for';

wwv_flow_api.create_message (
  p_id=>67043411401363710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_service_admin_link_p2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 service administration';

wwv_flow_api.create_message (
  p_id=>67043823175367097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SERVICE_ADMIN_LINK_P2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_ddl_domain_index_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'There is domain index in selected %0.  Generate DDL cannot geneate DDL for domain index.';

wwv_flow_api.create_message (
  p_id=>67198011524964908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_DDL.DOMAIN_INDEX_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_unsupported_data_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'unsupported data type';

wwv_flow_api.create_message (
  p_id=>67350725400574412 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_UNSUPPORTED_DATA_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_exclude_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exclude Null Values';

wwv_flow_api.create_message (
  p_id=>67383311884544977 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_EXCLUDE_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_displayed_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Displayed Columns';

wwv_flow_api.create_message (
  p_id=>67383828160549754 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAYED_COLUMNS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_all_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'All Columns';

wwv_flow_api.create_message (
  p_id=>67384418248556324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ALL_COLUMNS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You may not delete yourself.';

wwv_flow_api.create_message (
  p_id=>67427815913071208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_DELETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_cannot_remove_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You may not remove administrator privilege from yourself.';

wwv_flow_api.create_message (
  p_id=>67430621023091671 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_CANNOT_REMOVE_ADMIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chart Type';

wwv_flow_api.create_message (
  p_id=>67558422880334096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHART_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_hcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Horizontal Column';

wwv_flow_api.create_message (
  p_id=>67558910890340090 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_HCOLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_vcolumn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vertical Column';

wwv_flow_api.create_message (
  p_id=>67559429591345531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_VCOLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pie';

wwv_flow_api.create_message (
  p_id=>67559907558348614 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PIE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Line';

wwv_flow_api.create_message (
  p_id=>67560421064352551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LINE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_3d
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'3D';

wwv_flow_api.create_message (
  p_id=>67560903880357065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_3D',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Label';

wwv_flow_api.create_message (
  p_id=>67561417732360999 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_LABEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Aggregate';

wwv_flow_api.create_message (
  p_id=>67562016132370060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AGGREGATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_do_not_aggregate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Do not aggregate -';

wwv_flow_api.create_message (
  p_id=>67562512107378287 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DO_NOT_AGGREGATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date';

wwv_flow_api.create_message (
  p_id=>67616027671281542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_display
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display';

wwv_flow_api.create_message (
  p_id=>67616512564286660 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DISPLAY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_select_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'- Select Function -';

wwv_flow_api.create_message (
  p_id=>67617018583297858 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_SELECT_FUNCTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_public
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Public';

wwv_flow_api.create_message (
  p_id=>68505405658823689 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_PUBLIC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_delete_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Would you like to delete these report settings?';

wwv_flow_api.create_message (
  p_id=>68506219426846545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DELETE_CONFIRM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_reset_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Restore report to the default settings.';

wwv_flow_api.create_message (
  p_id=>68506600164850479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_RESET_CONFIRM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message access_control_dup_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You may not enter duplicate username.';

wwv_flow_api.create_message (
  p_id=>69251416022747608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ACCESS_CONTROL_DUP_USERNAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enter any string to be used as your user identifier for this session.';

wwv_flow_api.create_message (
  p_id=>69336821132118100 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enter your %0 username and password.';

wwv_flow_api.create_message (
  p_id=>69337502909122300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enter your username and password for verification by LDAP host: %0.';

wwv_flow_api.create_message (
  p_id=>69338606157132723 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_std_login_page_4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enter your database schema username and password.';

wwv_flow_api.create_message (
  p_id=>69354024782232780 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_STD.LOGIN_PAGE_4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_dial_chart_query_syntax_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid chart query: %0<br /><br /> Use the following syntax: <pre> SELECT VALUE, MAX, (LOW), (HIGH) VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>Numeric column that defines dial value.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>MAX</td>'||chr(10)||
'<td>Numeric column that defines Maximum dial value.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>LOW (optional)</td>'||chr(10)||
'<td>Numeric column that defines Minimum previous dial value.';

h:=h||'</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH (optional)</td>'||chr(10)||
'<td>Numeric column that defines Maximum previous dial value.</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>69504705708239462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.DIAL_CHART_QUERY_SYNTAX_INVALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_api_err_dup_page_item_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error page=%0 item="%1" id="%2" has same name as existing application-level item.';

wwv_flow_api.create_message (
  p_id=>69711819790615025 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_API.ERR_DUP_PAGE_ITEM_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_between
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'between';

wwv_flow_api.create_message (
  p_id=>71283707575987937 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_BETWEEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_cursor_not_open
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The query can not be parsed, the cursor is not yet open or a function returning a SQL query returned without a value.';

wwv_flow_api.create_message (
  p_id=>72334222183488035 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.CURSOR_NOT_OPEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_query_cannot_be_parsed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Function returning SQL query: Query cannot be parsed within the Builder. If you believe your query is syntactically correct, check the <b>generic columns</b> checkbox below the region source to proceed without parsing.'||chr(10)||
'<br />'||chr(10)||
'(%0)';

wwv_flow_api.create_message (
  p_id=>72338308162521865 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.QUERY_CANNOT_BE_PARSED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'query column #%0 (%1) is invalid, use column alias';

wwv_flow_api.create_message (
  p_id=>72339702752529737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.USE_COLUMN_ALIAS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_html_use_column_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'query column #%0 (%1) is invalid, columns that use HTML need alias names';

wwv_flow_api.create_message (
  p_id=>72340722145535298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.HTML_USE_COLUMN_ALIAS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>Query cannot be parsed, please check the syntax of your query.'||chr(10)||
'(%0)'||chr(10)||
'</p>';

wwv_flow_api.create_message (
  p_id=>72342525739545811 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_syntax_error2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>Query cannot be parsed within the Builder. If you believe your query is syntactically correct, check the ''''generic columns'''' checkbox below the region source to proceed without parsing.'||chr(10)||
'%0</p>';

wwv_flow_api.create_message (
  p_id=>72345130157566013 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.SYNTAX_ERROR2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Apply';

wwv_flow_api.create_message (
  p_id=>73414320431887353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_APPLY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_migrate_svg_restriction
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG chart will be migrated with the following restrictions:  '||chr(10)||
'<ul>'||chr(10)||
'<li>'||chr(10)||
'Only number formats defined in axis format strings will be migrated.  Date and time formats will be ignored.'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'Number format elements containing the following will be migrated:'||chr(10)||
'<br />'||chr(10)||
'0,9,D,G,, (comma),. (period),$,C,L,FM'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'The label for each series in the Flash chart will be derived from each series'' column ';

h:=h||'alias.  '||chr(10)||
'This differs from SVG charts, where the label for each series was derived from the Series Name attribute.'||chr(10)||
'</li>'||chr(10)||
'<li>'||chr(10)||
'Flash Dial charts display actual values instead of percentages.'||chr(10)||
'</li>'||chr(10)||
'</ul>';

wwv_flow_api.create_message (
  p_id=>73484029469295415 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MIGRATE_SVG_RESTRICTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Close:';

wwv_flow_api.create_message (
  p_id=>73618416318067439 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.CLOSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_high
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'High:';

wwv_flow_api.create_message (
  p_id=>73618820474068649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.HIGH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_flash_chart_low
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Low:';

wwv_flow_api.create_message (
  p_id=>73619225322069984 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FLASH_CHART.LOW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message monthly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Monthly';

wwv_flow_api.create_message (
  p_id=>73691217132846622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MONTHLY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weekly
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Weekly';

wwv_flow_api.create_message (
  p_id=>73692330291850451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKLY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message daily
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Daily';

wwv_flow_api.create_message (
  p_id=>73695111722854518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAILY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'< Previous';

wwv_flow_api.create_message (
  p_id=>73697304580861976 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.PREVIOUS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message calendar_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Next >';

wwv_flow_api.create_message (
  p_id=>73699120857866662 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CALENDAR.NEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p4111_used_on_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This List of Values is used on page(s) %0. Are you sure you want to delete? ';

wwv_flow_api.create_message (
  p_id=>73991322077001182 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P4111_USED_ON_PAGES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_create_ws_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Encountered second create_company call during workspace install.';

wwv_flow_api.create_message (
  p_id=>74251312155282122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.CREATE_WS_SEC_VIOLATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_to_is_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You must supply a message recipient to send mail.';

wwv_flow_api.create_message (
  p_id=>74362228272400319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.TO_IS_REQUIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message must_be_xsl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please ensure that the file type of the report layout file is XSL-FO, using ''.xsl'' as the file extension.';

wwv_flow_api.create_message (
  p_id=>74610218441708686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MUST_BE_XSL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message your_email_iuws
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your email address is registered with a user in the following workspaces:';

wwv_flow_api.create_message (
  p_id=>74915818232893988 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YOUR_EMAIL_IUWS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace Home';

wwv_flow_api.create_message (
  p_id=>75206101896338943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_HOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_workspace_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace Login';

wwv_flow_api.create_message (
  p_id=>75206509861341219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WORKSPACE_LOGIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interactive Report';

wwv_flow_api.create_message (
  p_id=>75583618448331157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DYNAMIC_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Templates';

wwv_flow_api.create_message (
  p_id=>77188403194326734 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_TEMPLATES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lists of Values';

wwv_flow_api.create_message (
  p_id=>77206713920604210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No shared lists of values used.';

wwv_flow_api.create_message (
  p_id=>77220009118981333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message layout_t_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No templates used.';

wwv_flow_api.create_message (
  p_id=>77223101247035776 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAYOUT.T_NO_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message button_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Button Numeric Identifier';

wwv_flow_api.create_message (
  p_id=>77390125296098295 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUTTON_ID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p18_script_rpt_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Report XML File Name';

wwv_flow_api.create_message (
  p_id=>77557030441404493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P18_SCRIPT_RPT_NAME',
  p_message_language=>'en-ie',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p18_script_pld_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL Library File Name';

wwv_flow_api.create_message (
  p_id=>77557907547445252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P18_SCRIPT_PLD_NAME',
  p_message_language=>'en-ie',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid chart query: %0<br /><br />'||chr(10)||
'Use the following syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'Or use the following syntax for a query returning multiple series:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE1 [, VALUE2 [, VALUE3...]]'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text that displays along a chart axis.</td></tr>'||chr(10)||
'<tr><td';

h:=h||'>VALUE1, VALUE2, VALUE3...</td><td>Numeric columns that define the data values.</td></tr>'||chr(10)||
'</table>'||chr(10)||
'Note: The series names for Column and Line charts are derived from the column aliases used in the query.';

wwv_flow_api.create_message (
  p_id=>77597720297336181 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CHART_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_scatter_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid Scatter chart query: %0<br /><br />'||chr(10)||
'Use the following syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, X_VALUE, Y_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text that displays in hints.</td></tr>'||chr(10)||
'<tr><td>X_VALUE</td><td>Numeric column that specifies X coordinate values.</td></tr>'||chr(10)||
'<tr><td>Y_VALUE</td><td>Numeric column that specifies Y ';

h:=h||'coordinate values.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>77607926109432456 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_SCATTER_CHART_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_range_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid Range chart query: %0<br /><br />'||chr(10)||
'Use the following syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN_VALUE, CLOSE_VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text that displays along a chart axis.</td></tr>'||chr(10)||
'<tr><td>OPEN_VALUE</td><td>Numeric column that specifies the start of the range.</td></tr>'||chr(10)||
'<tr><td>CLOSE_VALUE</td><td>Numeric';

h:=h||' column that specifies the end of the range.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>77611904123463963 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_RANGE_CHART_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_candlestick_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid Candlestick chart query: %0<br /><br />'||chr(10)||
'Use the following syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, OPEN, HIGH, LOW, CLOSE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text that displays along a chart axis.</td></tr>'||chr(10)||
'<tr><td>OPEN</td><td>Numeric column that specifies the start of the candlestick.</td></tr>'||chr(10)||
'<tr><td>HIGH</td><td>Numeric c';

h:=h||'olumn that specifies the maximum of the candlestick.</td></tr>'||chr(10)||
'<tr><td>LOW</td><td>Numeric column that specifies the minimum of the candlestick.</td></tr>'||chr(10)||
'<tr><td>CLOSE</td><td>Numeric column that specifies the end of the candlestick.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>77633412528523163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_CANDLESTICK_CHART_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_dial_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid Dial chart query: %0<br /><br /> Use the following syntax:'||chr(10)||
'<pre> SELECT VALUE, MAX [, LOW, HIGH] VALUE FROM ... </pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr>'||chr(10)||
'<td>VALUE</td>'||chr(10)||
'<td>Numeric column that defines dial value.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>MAX</td>'||chr(10)||
'<td>Numeric column that defines Maximum dial value.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>LOW (optional)</td>'||chr(10)||
'<td>Numeric column that defines the low value of a range';

h:=h||' to display on the dial. If this value is defined, a HIGH value is required.</td>'||chr(10)||
'</tr>'||chr(10)||
'<tr>'||chr(10)||
'<td>HIGH (optional)</td>'||chr(10)||
'<td>Numeric column that defines the high value of a range to display on the dial. If this value is defined, a LOW value is required.</td>'||chr(10)||
'</tr>'||chr(10)||
'</table>'||chr(10)||
'This query should return one row.';

wwv_flow_api.create_message (
  p_id=>77637525950545943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_DIAL_CHART_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_invalid_pie_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid chart query: %0<br /><br />'||chr(10)||
'Use the following syntax:'||chr(10)||
'<pre>'||chr(10)||
'SELECT LINK, LABEL, VALUE'||chr(10)||
'FROM   ...'||chr(10)||
'</pre>'||chr(10)||
'<table class="instructiontext">'||chr(10)||
'<tr><td>LINK</td><td>URL</td></tr>'||chr(10)||
'<tr><td>LABEL</td><td>Text that displays in legend text, hint text, and pie slice labels.</td></tr>'||chr(10)||
'<tr><td>VALUE</td><td>Numeric column that defines the data values.</td></tr>'||chr(10)||
'</table>';

wwv_flow_api.create_message (
  p_id=>77644013314580164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.INVALID_PIE_CHART_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message drag_and_drop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Drag and Drop';

wwv_flow_api.create_message (
  p_id=>77645421757592088 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRAG_AND_DROP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_parameter_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Null value supplied for parameter %0.';

wwv_flow_api.create_message (
  p_id=>77817200307221272 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.PARAMETER_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_mail_add_attachment_invalid_mail_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid value for parameter p_mail_id: %0';

wwv_flow_api.create_message (
  p_id=>77819507280251744 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MAIL.ADD_ATTACHMENT.INVALID_MAIL_ID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_category
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Category';

wwv_flow_api.create_message (
  p_id=>78487518065976490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CATEGORY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>78495212617031609 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_DESCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_imp_parser_sec_violation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'API call to remove_page procedure detected within large block in export file.';

wwv_flow_api.create_message (
  p_id=>78523615428273587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_IMP_PARSER.SEC_VIOLATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_fmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The file you attempted to upload to your Forms migration project is not a valid Forms Module (_fmb.XML) file.  Only Forms Module XML files, generated by the Forms2XML Conversion Tool included with Oracle Forms can be uploaded.';

wwv_flow_api.create_message (
  p_id=>78701421190051550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_FMB_CONTENT_INVALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_rpt_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The file you attempted to upload to your Forms migration project is not a valid Report (.XML) file. Only Report XML files, generated by the File Conversion utility included with Oracle Reports Builder can be uploaded.';

wwv_flow_api.create_message (
  p_id=>78703929838328436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_RPT_CONTENT_INVALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL: http(s)://domain/path/doc.(pdf)(html)(etc...)';

wwv_flow_api.create_message (
  p_id=>78812622499937542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'IP Address';

wwv_flow_api.create_message (
  p_id=>78813004622941846 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Phone Number, US: %0';

wwv_flow_api.create_message (
  p_id=>78813422284946942 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Phone Number, US flexible: 999.999.9999, (999)-999-9999, 999 999 9999, etc...';

wwv_flow_api.create_message (
  p_id=>78813810425962453 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ZIP Code: 99999';

wwv_flow_api.create_message (
  p_id=>78814215405973269 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ZIP + 4: 99999-9999';

wwv_flow_api.create_message (
  p_id=>78814602030978955 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date: %0';

wwv_flow_api.create_message (
  p_id=>78815025925985832 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date, flexible: %0 with any separator';

wwv_flow_api.create_message (
  p_id=>78815409087990462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid URL';

wwv_flow_api.create_message (
  p_id=>78816106794999238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_URL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_ip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid IP Address';

wwv_flow_api.create_message (
  p_id=>78816821685003558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_IP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Phone number must be in the form %0';

wwv_flow_api.create_message (
  p_id=>78817210388009717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_phone2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Phone number format not recognized';

wwv_flow_api.create_message (
  p_id=>78817929781015296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_PHONE2_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_zip_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ZIP code must be in the form %0';

wwv_flow_api.create_message (
  p_id=>78818323678023037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_ZIP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date must be in the form %0';

wwv_flow_api.create_message (
  p_id=>78818708226028033 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p430_date2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date format not recognized';

wwv_flow_api.create_message (
  p_id=>78819131428034683 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P430_DATE2_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p819_curr_warn
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warning: You are about to delete the current authentication scheme for this application!';

wwv_flow_api.create_message (
  p_id=>78913212633022862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P819_CURR_WARN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_func_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run custom authentication function in application %0.';

wwv_flow_api.create_message (
  p_id=>79171002345638006 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FUNC_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_custom_auth_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to fetch custom authentication function body in application %0.';

wwv_flow_api.create_message (
  p_id=>79171902738666477 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.CUSTOM_AUTH_FETCH_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_scheme_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to fetch authentication_scheme in application %0.';

wwv_flow_api.create_message (
  p_id=>79172306810686653 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SCHEME_FETCH_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_pg_sentry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run page sentry in application %0.';

wwv_flow_api.create_message (
  p_id=>79172732436693997 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_PG_SENTRY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_auth_sess_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run plugin session verify function from authentication scheme in application %0.';

wwv_flow_api.create_message (
  p_id=>79173121832700399 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.AUTH_SESS_VERIFY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'WWSEC_SSO_ENABLER_PRIVATE package does not exist or is invalid.';

wwv_flow_api.create_message (
  p_id=>79173525688729948 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_missing2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please ask your %0 administrator to configure the engine for Oracle Application Server Single Sign-On.';

wwv_flow_api.create_message (
  p_id=>79173901578732375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_MISSING2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_sso_pkg_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error executing wwv_flow_custom_auth_sso.portal_sso_redirect.';

wwv_flow_api.create_message (
  p_id=>79174630452750203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.SSO_PKG_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_api_deep_link_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unexpected error in remember_deep_link for session %0.';

wwv_flow_api.create_message (
  p_id=>79175003534799229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_API.DEEP_LINK_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_dup_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Duplicate username found for %0.';

wwv_flow_api.create_message (
  p_id=>79175427560815620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.DUP_USER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_load_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error loading users. Failed on user %0.';

wwv_flow_api.create_message (
  p_id=>79176132193826416 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.LOAD_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_mmb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The file you attempted to upload to your Forms migration project is not a valid Forms Menu (_mmb.XML) file. Only Forms Menu XML files, generated by the Form2XML Conversion tool included with Oracle Forms can be uploaded.';

wwv_flow_api.create_message (
  p_id=>79925231426271365 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_MMB_CONTENT_INVALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p18_script_mmb_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Forms Menu XML File Name';

wwv_flow_api.create_message (
  p_id=>79925506538292648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P18_SCRIPT_MMB_NAME',
  p_message_language=>'en-ie',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'row(s) %0 - %1 of %2';

wwv_flow_api.create_message (
  p_id=>80930727681244981 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_Z',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_found_but_not_displayed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Minimum row requested: %0, rows found but not displayed: %1';

wwv_flow_api.create_message (
  p_id=>80936819632261587 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.FOUND_BUT_NOT_DISPLAYED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_x_y_of_more_than_z
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'row(s) %0 - %1 of more than %2';

wwv_flow_api.create_message (
  p_id=>80989604862541265 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.X_Y_OF_MORE_THAN_Z',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application';

wwv_flow_api.create_message (
  p_id=>83629211143452101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page';

wwv_flow_api.create_message (
  p_id=>83630915907472398 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Name';

wwv_flow_api.create_message (
  p_id=>83631600108477324 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Title';

wwv_flow_api.create_message (
  p_id=>83634724050512649 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tab Set';

wwv_flow_api.create_message (
  p_id=>83635112060518636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tab Label';

wwv_flow_api.create_message (
  p_id=>83635525566522484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_LABEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table Owner';

wwv_flow_api.create_message (
  p_id=>83635906650526508 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_OWNER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table Name';

wwv_flow_api.create_message (
  p_id=>83636820502530530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABLE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Columns';

wwv_flow_api.create_message (
  p_id=>83637803318535041 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COLUMNS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_updateable_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Updateable Columns';

wwv_flow_api.create_message (
  p_id=>83638722019540369 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATEABLE_COLUMNS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Primary Key %0';

wwv_flow_api.create_message (
  p_id=>83639108990546076 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_page_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Title';

wwv_flow_api.create_message (
  p_id=>83680707604895771 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGE_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_tabset_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No tab set has been selected for this page.';

wwv_flow_api.create_message (
  p_id=>83681105658904732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO.TABSET.SELECTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A new tab set "%0" will be created and used by this page.';

wwv_flow_api.create_message (
  p_id=>83681504750913953 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE.NEW.TABSET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_use_existing_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This page will use the existing tab set "%0".';

wwv_flow_api.create_message (
  p_id=>83681906612923875 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.USE.EXISTING.TABSET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabset_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warning, tabset information is incomplete.';

wwv_flow_api.create_message (
  p_id=>83682414708935691 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABSET.INCOMPLETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Tab Set';

wwv_flow_api.create_message (
  p_id=>83682916224945610 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Tab Label';

wwv_flow_api.create_message (
  p_id=>83683732501950333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TAB_LABEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Template';

wwv_flow_api.create_message (
  p_id=>83697102466998390 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NO_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Items';

wwv_flow_api.create_message (
  p_id=>83701300173007240 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ITEMS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Template';

wwv_flow_api.create_message (
  p_id=>83706502382017360 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Information Template';

wwv_flow_api.create_message (
  p_id=>83712923160023286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_information_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Information Default Text';

wwv_flow_api.create_message (
  p_id=>83714207361028258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INFORMATION_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Button Display Text';

wwv_flow_api.create_message (
  p_id=>83715032641035557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_button_branch
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 Button Branch';

wwv_flow_api.create_message (
  p_id=>83716430002044177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.BUTTON_BRANCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_suggested_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Suggested Name';

wwv_flow_api.create_message (
  p_id=>83739605816141345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SUGGESTED_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_actual_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Actual Name';

wwv_flow_api.create_message (
  p_id=>83741621054145676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.ACTUAL_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_new_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'New Template';

wwv_flow_api.create_message (
  p_id=>83743214259153187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NEW_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display Columns';

wwv_flow_api.create_message (
  p_id=>83806217048305430 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_COLUMNS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_process_options
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Process Options';

wwv_flow_api.create_message (
  p_id=>83810010945313161 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PROCESS_OPTIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Owner';

wwv_flow_api.create_message (
  p_id=>83830823459345159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.OWNER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_stored_procedure_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Stored Procedure Name';

wwv_flow_api.create_message (
  p_id=>83837400041347840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.STORED_PROCEDURE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL Query';

wwv_flow_api.create_message (
  p_id=>83866207707378452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SQL_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chart Query';

wwv_flow_api.create_message (
  p_id=>83885909270416759 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chart Axis';

wwv_flow_api.create_message (
  p_id=>83890404206424749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_AXIS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Scale';

wwv_flow_api.create_message (
  p_id=>83894412864427252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCALE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_number_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Number Mask';

wwv_flow_api.create_message (
  p_id=>83898511263436179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_NUMBER_MASK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chart Type';

wwv_flow_api.create_message (
  p_id=>83945731059546010 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chart Title';

wwv_flow_api.create_message (
  p_id=>83946611104549672 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Chart Size';

wwv_flow_api.create_message (
  p_id=>83947427380554416 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SIZE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_vertical_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Vertical Bar';

wwv_flow_api.create_message (
  p_id=>83952810327568385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_VERTICAL_BAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_horizontal_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Horizontal Bar';

wwv_flow_api.create_message (
  p_id=>83959621325590507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_HORIZONTAL_BAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_pie
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pie';

wwv_flow_api.create_message (
  p_id=>83960431021593278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_PIE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_line
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Line';

wwv_flow_api.create_message (
  p_id=>83961310028596692 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_LINE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_chart_scatter
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Scatter';

wwv_flow_api.create_message (
  p_id=>83964025611601184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CHART_SCATTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_insert_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Insert';

wwv_flow_api.create_message (
  p_id=>83972424965629402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INSERT_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_update_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Update';

wwv_flow_api.create_message (
  p_id=>83973806050633440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UPDATE_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_delete_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Delete';

wwv_flow_api.create_message (
  p_id=>83974520248637528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DELETE_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tabular_form
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a tabular form page with the following attributes.   Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>83993721381694591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TABULAR_FORM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a page with the following attributes.  Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>83996527399705856 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_wizard
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a wizard with the following attributes.  Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>83997719911713164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_WIZARD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a form on a table page with the following attributes.   Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84009924198723832 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_sp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a form on stored procedure with the following attributes.   Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84012121212732461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_SP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_form_on_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a form on SQL query with the following attributes.   Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84013706452737578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_FORM_ON_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_simple_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create an HTML Bar Chart Page with the following attributes.  Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84015121343741885 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SIMPLE_CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_svg_chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a SVG chart page with the following attributes.  Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84022417665750334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SVG_CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_calendar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a calendar page with the following attributes.   Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84032115287777986 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_CALENDAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_date_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Date Column';

wwv_flow_api.create_message (
  p_id=>84032629271791502 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DATE_COLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_label_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Label Column';

wwv_flow_api.create_message (
  p_id=>84035014164796574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.LABEL_COLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a tree page with the following attributes. Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84043324815818579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_TREE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tree Name';

wwv_flow_api.create_message (
  p_id=>84048902221830992 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tree Type';

wwv_flow_api.create_message (
  p_id=>84050018151835644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_max_level
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Max Levels';

wwv_flow_api.create_message (
  p_id=>84054528672848151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_MAX_LEVEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_start
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Start Tree';

wwv_flow_api.create_message (
  p_id=>84054911141852527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_START',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tree Query';

wwv_flow_api.create_message (
  p_id=>84055323954856200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Based on new item with popup list of values';

wwv_flow_api.create_message (
  p_id=>84056714735863028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Based on a SQL Query';

wwv_flow_api.create_message (
  p_id=>84057626856866535 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_SQL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tree_static
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Static value';

wwv_flow_api.create_message (
  p_id=>84058207940870527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TREE_STATIC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a breadcrumb region and breadcrumb option with the following attributes.  Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84064716513891867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_MENU',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_region_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region Type';

wwv_flow_api.create_message (
  p_id=>84070419415902174 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REGION_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_display_point
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display Point';

wwv_flow_api.create_message (
  p_id=>84073108810908627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DISPLAY_POINT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Breadcrumb Template';

wwv_flow_api.create_message (
  p_id=>84076825779913529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence';

wwv_flow_api.create_message (
  p_id=>84077510673918613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SEQUENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_link
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Breadcrumb Link';

wwv_flow_api.create_message (
  p_id=>84078523140922214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_LINK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Breadcrumb Text';

wwv_flow_api.create_message (
  p_id=>84081702839925828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Breadcrumb';

wwv_flow_api.create_message (
  p_id=>84083520501930905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_query_and_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create form and report pages with the following attributes.  Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84110608342974700 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_QUERY_AND_UPDATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report Page';

wwv_flow_api.create_message (
  p_id=>84122401678991717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report Page Name';

wwv_flow_api.create_message (
  p_id=>84123216223995906 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report Page Tab Set';

wwv_flow_api.create_message (
  p_id=>84125830768000098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report Page Tab Label';

wwv_flow_api.create_message (
  p_id=>84126911852004107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_PAGE_TAB_LABEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form Page';

wwv_flow_api.create_message (
  p_id=>84127322588007244 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form Page Name';

wwv_flow_api.create_message (
  p_id=>84127802979011040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form Page Tab Set';

wwv_flow_api.create_message (
  p_id=>84130613022013946 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_form_page_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Form Page Tab Label';

wwv_flow_api.create_message (
  p_id=>84131125143017377 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.FORM_PAGE_TAB_LABEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_primary_key_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Primary Key Column';

wwv_flow_api.create_message (
  p_id=>84134515924024248 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PRIMARY_KEY_COLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report Columns';

wwv_flow_api.create_message (
  p_id=>84140229907037727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_COLUMNS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_where_clause
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Where Clause';

wwv_flow_api.create_message (
  p_id=>84141114454042698 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.WHERE_CLAUSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_drill_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a drill down report page with the following attributes.   Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84155707575069111 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DRILL_DOWN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Page';

wwv_flow_api.create_message (
  p_id=>84185527408131648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail Page %0';

wwv_flow_api.create_message (
  p_id=>84186212994136871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_tab_label
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail Tab Label %0';

wwv_flow_api.create_message (
  p_id=>84190831825151808 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TAB_LABEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Table Name';

wwv_flow_api.create_message (
  p_id=>84194218450157460 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_TABLE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail Table Name %0';

wwv_flow_api.create_message (
  p_id=>84195110963164711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_TABLE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Display Columns';

wwv_flow_api.create_message (
  p_id=>84197231048170548 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_DISPLAY_COLS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_display_cols
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail %0 Display Columns';

wwv_flow_api.create_message (
  p_id=>84198211094174194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_DISPLAY_COLS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Table Order By';

wwv_flow_api.create_message (
  p_id=>84199705684182098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_ORDER_BY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_order_by
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail Table %0 Order By';

wwv_flow_api.create_message (
  p_id=>84201925770187894 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_ORDER_BY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_inc_bread_crumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Include a Breadcrumb';

wwv_flow_api.create_message (
  p_id=>84204814126194016 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.INC_BREAD_CRUMB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu_root
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Breadcrumb Root';

wwv_flow_api.create_message (
  p_id=>84205224169196952 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU_ROOT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_parent_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Breadcrumb Column';

wwv_flow_api.create_message (
  p_id=>84205803176200356 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PARENT_MENU_COL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_detail_menu_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Detail Breadcrumb Column';

wwv_flow_api.create_message (
  p_id=>84206614257203482 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.DETAIL_MENU_COL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_summary_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a summary page with the following attributes.  Press the "Add More" button to add additional items from other pages and/or regions. Press "Finish" to create the summary items.';

wwv_flow_api.create_message (
  p_id=>84210505862220035 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_SUMMARY_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_copy_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to copy a page with the following attributes.  Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84220229111255163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COPY_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_report_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a report page with the following attributes.  Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84229312367316547 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_REPORT_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tab_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tab Name';

wwv_flow_api.create_message (
  p_id=>84231926696330131 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TAB_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_easy_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create a report page with the following attributes.   Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84279810401524144 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_EASY_REPORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_report_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report Template';

wwv_flow_api.create_message (
  p_id=>84290214818544312 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.REPORT_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_sort_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sort Option';

wwv_flow_api.create_message (
  p_id=>84293027285547888 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.SORT_OPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'default: HTML (standard)';

wwv_flow_api.create_message (
  p_id=>84295815296553924 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'default: vertical report, look 1 (exclude null columns)';

wwv_flow_api.create_message (
  p_id=>84297930533558343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'default: vertical report, look 1 (include null columns)';

wwv_flow_api.create_message (
  p_id=>84299206769560958 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name11
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'default: Look 1';

wwv_flow_api.create_message (
  p_id=>84300617505563987 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME11',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name12
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'default: Look 2';

wwv_flow_api.create_message (
  p_id=>84303328240567119 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME12',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name21
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'export: CSV';

wwv_flow_api.create_message (
  p_id=>84305108285570856 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME21',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_rpt_template_name22
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'export: XML';

wwv_flow_api.create_message (
  p_id=>84306817636573518 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.RPT_TEMPLATE_NAME22',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'template:';

wwv_flow_api.create_message (
  p_id=>84308130103577082 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_col_head_sorting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use Column Heading Sorting';

wwv_flow_api.create_message (
  p_id=>84312222269584337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.COL_HEAD_SORTING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create an application with the following attributes.  Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>84958832256200806 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_APPLICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>84959603774211504 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alias';

wwv_flow_api.create_message (
  p_id=>84960224553217479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_ALIAS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_application_default_lang
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Default Language';

wwv_flow_api.create_message (
  p_id=>84960619143225429 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.APPLICATION_DEFAULT_LANG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentication';

wwv_flow_api.create_message (
  p_id=>84962917542234410 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.AUTHENTICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pages';

wwv_flow_api.create_message (
  p_id=>84963301528248741 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.PAGES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_tabs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tabs';

wwv_flow_api.create_message (
  p_id=>84963718151253552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.TABS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_nav_bar
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigation Bar';

wwv_flow_api.create_message (
  p_id=>84964129232256696 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.NAV_BAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'UI Theme';

wwv_flow_api.create_message (
  p_id=>84964508239260082 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Blue and Tan';

wwv_flow_api.create_message (
  p_id=>84964904214268381 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Red';

wwv_flow_api.create_message (
  p_id=>84965424300274208 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navy and Gray';

wwv_flow_api.create_message (
  p_id=>84965830880276110 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme5
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Olive';

wwv_flow_api.create_message (
  p_id=>84966203306277655 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME5',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme6
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Maroon';

wwv_flow_api.create_message (
  p_id=>84966608501279118 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME6',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme7
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Simple Blue and Tan';

wwv_flow_api.create_message (
  p_id=>84967013349280524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME7',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme8
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Blue';

wwv_flow_api.create_message (
  p_id=>84967421660282932 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME8',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_ui_theme_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'None';

wwv_flow_api.create_message (
  p_id=>84967827894284732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.UI_THEME_NONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_copied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copied from Application';

wwv_flow_api.create_message (
  p_id=>84970116644319357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.COPIED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is the "master" copy of this template.';

wwv_flow_api.create_message (
  p_id=>84970810195326889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.MASTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Label templates referencing this template';

wwv_flow_api.create_message (
  p_id=>84971225086331220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message label_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No templates subscribe to this template.';

wwv_flow_api.create_message (
  p_id=>84971614828337676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LABEL_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_current_auth_method
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current Authentication Method';

wwv_flow_api.create_message (
  p_id=>84975628165379446 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CURRENT_AUTH_METHOD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Login Page';

wwv_flow_api.create_message (
  p_id=>84977318253386052 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'none';

wwv_flow_api.create_message (
  p_id=>84978002454390895 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.NONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_login_url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Login URL';

wwv_flow_api.create_message (
  p_id=>84978925657397584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.LOGIN_URL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_custom_auth_function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Custom Authentication Function';

wwv_flow_api.create_message (
  p_id=>84979308473402072 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CUSTOM_AUTH_FUNCTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message auth_confirm_migrate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You are about to migrate this application''s custom authentication options to an authentication scheme.';

wwv_flow_api.create_message (
  p_id=>84980113452412986 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTH.CONFIRM_MIGRATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_value_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Value must be specified.';

wwv_flow_api.create_message (
  p_id=>85003306900638167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.VALUE_REQUIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>85053030944806028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PLSQL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_e_val
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'item=value';

wwv_flow_api.create_message (
  p_id=>85072900647835157 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_E_VAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_item_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'item not null';

wwv_flow_api.create_message (
  p_id=>85074028352843071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_ITEM_NOT_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_req_e_e1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'request=e1';

wwv_flow_api.create_message (
  p_id=>85075315669848918 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_REQ_E_E1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'page in';

wwv_flow_api.create_message (
  p_id=>85085927837880849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_IN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_page_not_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'page not in';

wwv_flow_api.create_message (
  p_id=>85090223120888950 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_PAGE_NOT_IN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'exists';

wwv_flow_api.create_message (
  p_id=>85091907321893783 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_never
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'never';

wwv_flow_api.create_message (
  p_id=>85094624290898694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NEVER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message conditions_shortcut_none
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'none';

wwv_flow_api.create_message (
  p_id=>85097002603901871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITIONS_SHORTCUT_NONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p688_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Identify the components of an application to be exported. This can be used for backup purposes or to load these components on another instance.';

wwv_flow_api.create_message (
  p_id=>85304523371951756 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P688_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'exists';

wwv_flow_api.create_message (
  p_id=>86096209088897267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_not_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'not exists';

wwv_flow_api.create_message (
  p_id=>86096825711902091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NOT_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create an example application to demonstrate web services.';

wwv_flow_api.create_message (
  p_id=>86097707488906306 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WEB_SERVICES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You are about to (re)create business look Demo Application.';

wwv_flow_api.create_message (
  p_id=>86100731729913303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BUSINESS_LOOK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_worldcup_mania
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You are about to create WorldCup Mania Demo Application.';

wwv_flow_api.create_message (
  p_id=>86102321471919779 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_WORLDCUP_MANIA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Following database objects will be recreated if they exists';

wwv_flow_api.create_message (
  p_id=>86467506711925047 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_RECREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema';

wwv_flow_api.create_message (
  p_id=>86468720217928959 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Object Type';

wwv_flow_api.create_message (
  p_id=>86472916323946682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>86473730175950682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_exist
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exist';

wwv_flow_api.create_message (
  p_id=>86484212645955102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_EXIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table';

wwv_flow_api.create_message (
  p_id=>86492611391964173 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_application_reserved
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application ID''s 3000 through 8999 are reserved.';

wwv_flow_api.create_message (
  p_id=>86495111868973829 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.APPLICATION_RESERVED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence';

wwv_flow_api.create_message (
  p_id=>86503729445997814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.SEQUENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trigger';

wwv_flow_api.create_message (
  p_id=>86505108452001239 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TRIGGER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package';

wwv_flow_api.create_message (
  p_id=>86507026806006531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PACKAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_basic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You are about to create Basic Examples Demo Application.';

wwv_flow_api.create_message (
  p_id=>86510714124012310 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_BASIC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You are about to create Collections Showcase Demo Application.';

wwv_flow_api.create_message (
  p_id=>86512630746017160 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_COLLECTION_SHOWCASE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_create_or_recreate
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'create or recreate in schema %0';

wwv_flow_api.create_message (
  p_id=>86515319927032940 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CREATE_OR_RECREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p19_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Must specify at least one item to create not null validation.';

wwv_flow_api.create_message (
  p_id=>86515621658033438 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P19.VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_object_name2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Object Name';

wwv_flow_api.create_message (
  p_id=>86517915902041262 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.OBJECT_NAME2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_basic_lexer
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'BASIC_LEXER';

wwv_flow_api.create_message (
  p_id=>86521617764051253 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BASIC_LEXER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_context_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'CONTEXT INDEX';

wwv_flow_api.create_message (
  p_id=>86522827461054037 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.CONTEXT_INDEX',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Header must contain <b> &lt;head&gt;</b> and <b>&lt;/head&gt;</b> tags.';

wwv_flow_api.create_message (
  p_id=>86524303351056557 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application';

wwv_flow_api.create_message (
  p_id=>86525609238058166 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.APPLICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_need_7m
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The Presidential Inaugural Address Demonstration requires about 7 MB of free disk space and may take up to two minutes to install in your schema.';

wwv_flow_api.create_message (
  p_id=>86531228977063909 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NEED_7M',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_header_validation2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>#HEAD#</b> substitution string must appear between the <b> &lt;head&gt;</b> and <b>&lt;/head&gt;</b> tags.';

wwv_flow_api.create_message (
  p_id=>86532909715067781 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.HEADER_VALIDATION2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_free_space
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have about %0 MB free.';

wwv_flow_api.create_message (
  p_id=>86535014910069267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.FREE_SPACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_will_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You may experience an error if you are not recreating this demonstration.';

wwv_flow_api.create_message (
  p_id=>86537630971083428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WILL_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p818_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Must select at least one scheme to be copied.';

wwv_flow_api.create_message (
  p_id=>86538323137090640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P818.VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_mand
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Name must be specified.';

wwv_flow_api.create_message (
  p_id=>86544517989117530 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_MAND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copied from Application';

wwv_flow_api.create_message (
  p_id=>86580310726191108 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.COPIED_FROM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup List of Values Template';

wwv_flow_api.create_message (
  p_id=>86581027695196053 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is the "master" copy of this template.';

wwv_flow_api.create_message (
  p_id=>86581705662199154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MASTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_popup_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup List of Values templates referencing this template';

wwv_flow_api.create_message (
  p_id=>86582122631204056 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.POPUP_LOV_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No templates subscribe to this template.';

wwv_flow_api.create_message (
  p_id=>86582618607212348 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.NO_SUBSCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current Application';

wwv_flow_api.create_message (
  p_id=>86583305232217917 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_APPLICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message alias
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alias';

wwv_flow_api.create_message (
  p_id=>86584014582220650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALIAS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Updated';

wwv_flow_api.create_message (
  p_id=>86586006748227826 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_report_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report templates referencing this template';

wwv_flow_api.create_message (
  p_id=>86586710211228862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REPORT_TEMPLATE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Owner';

wwv_flow_api.create_message (
  p_id=>86588116098230549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'OWNER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authentication';

wwv_flow_api.create_message (
  p_id=>86590502377236028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_edit_this_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit this template';

wwv_flow_api.create_message (
  p_id=>86593321078241432 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_EDIT_THIS_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p1_authentication_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'authentication home';

wwv_flow_api.create_message (
  p_id=>86594326618242992 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P1_AUTHENTICATION_HOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template';

wwv_flow_api.create_message (
  p_id=>86596019823250532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_menu_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Breadcrumb templates referencing this template';

wwv_flow_api.create_message (
  p_id=>86617927236337861 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.MENU_TEMPLATE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_table_summary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Demonstration Application Install Status Report';

wwv_flow_api.create_message (
  p_id=>86620423127364980 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.TABLE_SUMMARY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_demo_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Demo Application';

wwv_flow_api.create_message (
  p_id=>86622409060370419 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.DEMO_APP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_status
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Status';

wwv_flow_api.create_message (
  p_id=>86622922219374241 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.STATUS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_action
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Action';

wwv_flow_api.create_message (
  p_id=>86623500533377424 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ACTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_collection_showcase
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Collection Showcase';

wwv_flow_api.create_message (
  p_id=>86624401010387021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.COLLECTION_SHOWCASE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_learn_about
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Learn about %0 shopping cart concepts.';

wwv_flow_api.create_message (
  p_id=>86624920403392658 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.LEARN_ABOUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Installed';

wwv_flow_api.create_message (
  p_id=>86625514647400427 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALLED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_run
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Run';

wwv_flow_api.create_message (
  p_id=>86626029192404645 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.RUN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_not_installed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Not Installed';

wwv_flow_api.create_message (
  p_id=>86627209584408409 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.NOT_INSTALLED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Install';

wwv_flow_api.create_message (
  p_id=>86628122743412220 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page';

wwv_flow_api.create_message (
  p_id=>86628423436412442 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Title';

wwv_flow_api.create_message (
  p_id=>86628826899413422 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message security
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Security';

wwv_flow_api.create_message (
  p_id=>86629230708414559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECURITY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message standard_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Standard Tab Set';

wwv_flow_api.create_message (
  p_id=>86630911446418425 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STANDARD_TAB_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Petstore';

wwv_flow_api.create_message (
  p_id=>86631413870419120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PETSTORE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_petstore
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Example of on-line store built using %0.';

wwv_flow_api.create_message (
  p_id=>86633502920425421 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PETSTORE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_install_now
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Install Now';

wwv_flow_api.create_message (
  p_id=>86637510323437040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.INSTALL_NOW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Business Look';

wwv_flow_api.create_message (
  p_id=>86638504913444896 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.BUSINESS_LOOK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_business_look
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Examples of robust reports and pagination concepts.';

wwv_flow_api.create_message (
  p_id=>86639518073448693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_BUSINESS_LOOK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_web_services
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Web Services';

wwv_flow_api.create_message (
  p_id=>86640725476460289 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.WEB_SERVICES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_webservices
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Learn to use webservices with %0.';

wwv_flow_api.create_message (
  p_id=>86642316257467134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_WEBSERVICES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Presidential Inaugural Addresses';

wwv_flow_api.create_message (
  p_id=>86646724353478911 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PRESIDENTIAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_presidential
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Learn about using Oracle Text with %0.';

wwv_flow_api.create_message (
  p_id=>86647610978484497 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PRESIDENTIAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_select_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Select a time you want to go back to, then click on the source to populate the desired item and close this page.';

wwv_flow_api.create_message (
  p_id=>86651009724493635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_SELECT_TIME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_project_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Project Tracking';

wwv_flow_api.create_message (
  p_id=>86652229463499345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.PROJECT_TRACKING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_flashback_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The undo feature of %0 uses a built in database feature called "Flashback Query", allowing you to query data as of a certain time.';

wwv_flow_api.create_message (
  p_id=>86652803275501185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_FLASHBACK_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message demo_application_about_proj_tracking
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Example of project status tracking application built with %0.';

wwv_flow_api.create_message (
  p_id=>86653513318504148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DEMO_APPLICATION.ABOUT_PROJ_TRACKING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p88_undo_retention
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Based on the database parameter "UNDO_RETENTION", you may only undo changes that occured within the last %0 hour(s).';

wwv_flow_api.create_message (
  p_id=>86654430980509247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P88_UNDO_RETENTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copied from Application';

wwv_flow_api.create_message (
  p_id=>86661027910536765 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.COPIED_FROM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is the "master" copy of this item help.';

wwv_flow_api.create_message (
  p_id=>86662408301540549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.MASTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Items referencing this item help text';

wwv_flow_api.create_message (
  p_id=>86663924578545184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_item_help_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No items subscribe to this item help text.';

wwv_flow_api.create_message (
  p_id=>86665311895551015 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_ITEM_HELP.NO_SUBSCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_confirm_create_std_tab
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Confirm Create-Standard Tab in Application';

wwv_flow_api.create_message (
  p_id=>86681816790580831 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_CONFIRM_CREATE_STD_TAB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_tabset_info_incomplete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warning, tabset information in incomplete.';

wwv_flow_api.create_message (
  p_id=>86685428696593735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_TABSET_INFO_INCOMPLETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copied from Application';

wwv_flow_api.create_message (
  p_id=>86686308395597343 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.COPIED_FROM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_page_will_use_existng_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page %0 will use the existing tab set "%1".';

wwv_flow_api.create_message (
  p_id=>86690108872606883 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_PAGE_WILL_USE_EXISTNG_TABSET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p92_new_tabset_will_be_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A new tab set %0 will be created.';

wwv_flow_api.create_message (
  p_id=>86691826187611948 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P92_NEW_TABSET_WILL_BE_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is the "master" copy of this authorization scheme.';

wwv_flow_api.create_message (
  p_id=>86696126665621536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.MASTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Authorization schemes referencing this authorization scheme';

wwv_flow_api.create_message (
  p_id=>86698817099628250 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_authorization_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No authorization schemes subscribe to this authorization scheme.';

wwv_flow_api.create_message (
  p_id=>86701232683632674 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_AUTHORIZATION.NO_SUBSCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_not_supplied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password and password confirmation must be supplied.';

wwv_flow_api.create_message (
  p_id=>86714217577637814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NOT_SUPPLIED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_no_match
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Passwords not matched, try again.';

wwv_flow_api.create_message (
  p_id=>86718715976646812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_NO_MATCH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copied from Application';

wwv_flow_api.create_message (
  p_id=>86720306757653613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.COPIED_FROM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_chg_only_yours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You may change only your own password.';

wwv_flow_api.create_message (
  p_id=>86720607449653855 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_CHG_ONLY_YOURS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is the "master" copy of this shortcut.';

wwv_flow_api.create_message (
  p_id=>86722222341658068 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.MASTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_change_password_psswd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unexpected error processing your change password request: %0';

wwv_flow_api.create_message (
  p_id=>86722825457658992 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHANGE_PASSWORD.PSSWD_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Shortcuts referencing this shortcut';

wwv_flow_api.create_message (
  p_id=>86723302040661709 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_shortcut_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No shortcuts subscribe to this shortcut.';

wwv_flow_api.create_message (
  p_id=>86725201132670893 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_SHORTCUT.NO_SUBSCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_plsql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 Error processing PLSQL expression.  %0';

wwv_flow_api.create_message (
  p_id=>86837423557696267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_PLSQL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_proc_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1026 Error Processing SQL Expresion: %0';

wwv_flow_api.create_message (
  p_id=>86839409490701736 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_PROC_SQL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tab Set';

wwv_flow_api.create_message (
  p_id=>86840323342705705 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_check_err_orcl
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Oracle Error: %0';

wwv_flow_api.create_message (
  p_id=>86840624381705987 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CHECK.ERR_ORCL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tab Text';

wwv_flow_api.create_message (
  p_id=>86841401656708887 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current Page';

wwv_flow_api.create_message (
  p_id=>86841910313711400 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copied from Application';

wwv_flow_api.create_message (
  p_id=>86843911830721349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.COPIED_FROM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is the "master" copy of this List of Values.';

wwv_flow_api.create_message (
  p_id=>86844826028725406 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.MASTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Lists of Values referencing this List of Values';

wwv_flow_api.create_message (
  p_id=>86845706766729341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_lov_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Lists of Values subscribe to this List of Values.';

wwv_flow_api.create_message (
  p_id=>86846722696733877 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_LOV.NO_SUBSCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Tab Set';

wwv_flow_api.create_message (
  p_id=>86848603434737818 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_set_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Tab Set New';

wwv_flow_api.create_message (
  p_id=>86850007936739163 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_SET_NEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message parent_tab_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parent Tab Text';

wwv_flow_api.create_message (
  p_id=>86852925251744090 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PARENT_TAB_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tab Sequence';

wwv_flow_api.create_message (
  p_id=>86853602180746890 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_SEQUENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current Image';

wwv_flow_api.create_message (
  p_id=>86861115339750755 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CURRENT_IMAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_page_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page templates referencing this template';

wwv_flow_api.create_message (
  p_id=>86861718802751717 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.PAGE_TEMPLATE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message non_current_image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Non Current Image';

wwv_flow_api.create_message (
  p_id=>86862626768753970 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NON_CURRENT_IMAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image_attributes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Image Attributes';

wwv_flow_api.create_message (
  p_id=>86863605081757188 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE_ATTRIBUTES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display Condition';

wwv_flow_api.create_message (
  p_id=>86865117548760809 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message condition_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Condition Type';

wwv_flow_api.create_message (
  p_id=>86865826552763427 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONDITION_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message display_condition_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display Condition Text';

wwv_flow_api.create_message (
  p_id=>86866805212766707 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DISPLAY_CONDITION_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_copied_from
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copied from Application';

wwv_flow_api.create_message (
  p_id=>86867106251767001 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.COPIED_FROM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_table_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table name already exists.';

wwv_flow_api.create_message (
  p_id=>86867509368767945 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.TABLE_ALREADY_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message build_option
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Build Option';

wwv_flow_api.create_message (
  p_id=>86867914216769358 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'BUILD_OPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_master
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is the "master" copy of this Navigation Bar.';

wwv_flow_api.create_message (
  p_id=>86869325298772486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.MASTER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_zero
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Column length cannot be zero.';

wwv_flow_api.create_message (
  p_id=>86869726683772874 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_ZERO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_length_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Column length cannot be null.';

wwv_flow_api.create_message (
  p_id=>86870432570774655 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_LENGTH_NOT_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Navigation Bars referencing this Navigation Bar';

wwv_flow_api.create_message (
  p_id=>86870903958775840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Column names cannot be longer than 30 characters.';

wwv_flow_api.create_message (
  p_id=>86871506036776399 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_col_names_not_null
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Column names cannot be null.';

wwv_flow_api.create_message (
  p_id=>86873212269778193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.COL_NAMES_NOT_NULL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_navbar_no_subscription
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Navigation Bars subscribe to this Navigation Bar.';

wwv_flow_api.create_message (
  p_id=>86874118503779983 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_NAVBAR.NO_SUBSCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_table_names_not_longer_than_30
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table names must be less than 30 characters.';

wwv_flow_api.create_message (
  p_id=>86874519542780298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.TABLE_NAMES_NOT_LONGER_THAN_30',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_not_valid_pk_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> is not a valid primary key name.';

wwv_flow_api.create_message (
  p_id=>86877900626784292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.NOT_VALID_PK_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p173_no_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'no help exists for this item';

wwv_flow_api.create_message (
  p_id=>86879717249789116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P173_NO_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_name_already_used
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> is already used by an existing object.';

wwv_flow_api.create_message (
  p_id=>86881724521791243 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NAME_ALREADY_USED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_err_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 Unable to determine LOV from "declare function x return varchar2 is begin %0 return null; end; begin wwv_flow_utilities.g_query := x; end;".';

wwv_flow_api.create_message (
  p_id=>86934817380798640 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ERR_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_f4500_not_valid_seq_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> is not a valid sequence name.';

wwv_flow_api.create_message (
  p_id=>86935724306800603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300.F4500.NOT_VALID_SEQ_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_add
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Add';

wwv_flow_api.create_message (
  p_id=>86936300195803128 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.ADD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_table_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> is not a valid table name.';

wwv_flow_api.create_message (
  p_id=>86936905044804536 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_TABLE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Remove';

wwv_flow_api.create_message (
  p_id=>86937520974809106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.REMOVE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_not_valid_object_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<b>%0</b> is not a valid object name.';

wwv_flow_api.create_message (
  p_id=>86937925129810271 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NOT_VALID_OBJECT_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_table_not_found_in_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table <b>%0</b> not found in schema <b>%1</b>.';

wwv_flow_api.create_message (
  p_id=>86939707599814700 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.TABLE_NOT_FOUND_IN_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_no_matches
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No matches.';

wwv_flow_api.create_message (
  p_id=>86940214179816619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NO_MATCHES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_prev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Previous';

wwv_flow_api.create_message (
  p_id=>86943301496822375 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.PREV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_need_unique_execution_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enter unique execution order number.';

wwv_flow_api.create_message (
  p_id=>86944204960823452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.NEED_UNIQUE_EXECUTION_ORDER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_copied_from_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Copied from Application';

wwv_flow_api.create_message (
  p_id=>86944606345823810 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_COPIED_FROM_APP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Next';

wwv_flow_api.create_message (
  p_id=>86945812232825486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.NEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_cal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calendar';

wwv_flow_api.create_message (
  p_id=>86949522621828533 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Close';

wwv_flow_api.create_message (
  p_id=>86958204660851671 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CLOSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_ok
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Ok';

wwv_flow_api.create_message (
  p_id=>86958815395854793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.OK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_search_dialog
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Search Dialog';

wwv_flow_api.create_message (
  p_id=>86961900289859951 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SEARCH_DIALOG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_find
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Find%0';

wwv_flow_api.create_message (
  p_id=>86965922799866397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.FIND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_region_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region templates referencing this template';

wwv_flow_api.create_message (
  p_id=>86966528686868101 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.REGION_TEMPLATE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_js_no_support
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'JavaScript not supported';

wwv_flow_api.create_message (
  p_id=>86977321676884980 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.JS_NO_SUPPORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_master_copy
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This is the "master" copy of this template.';

wwv_flow_api.create_message (
  p_id=>86978023754885573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_MASTER_COPY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'List';

wwv_flow_api.create_message (
  p_id=>86980902414888919 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message subscribe_template_list_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'List templates referencing this template';

wwv_flow_api.create_message (
  p_id=>86981504491889566 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUBSCRIBE_TEMPLATE.LIST_TEMPLATE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_button_templ
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Button templates referencing this, template';

wwv_flow_api.create_message (
  p_id=>86985423885895123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_BUTTON_TEMPL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p204_no_subscirbers
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No templates subscribe to this template.';

wwv_flow_api.create_message (
  p_id=>86988520553903630 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P204_NO_SUBSCIRBERS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_lov2_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error: %0 performing List of Values query: "%1".';

wwv_flow_api.create_message (
  p_id=>86994309602909880 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.LOV2_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_region_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>87003402591926859 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REGION_TEMPLATE.THEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_page_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>87040805802984558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_PAGE_TEMPLATE.THEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_list_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>87044415283996684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LIST_TEMPLATE.THEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_label_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>87050526149009278 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_LABEL_TEMPLATE.THEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message select_report_template_theme
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Theme';

wwv_flow_api.create_message (
  p_id=>87059325588018648 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SELECT_REPORT_TEMPLATE.THEME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Items';

wwv_flow_api.create_message (
  p_id=>87075818708044990 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.PAGE_ITEMS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_process_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region';

wwv_flow_api.create_message (
  p_id=>87077500485049266 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PROCESS.REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_default_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Referenced as application default template.';

wwv_flow_api.create_message (
  p_id=>87092429275085900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.DEFAULT_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_printer_friendly_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Referenced as printer friendly template.';

wwv_flow_api.create_message (
  p_id=>87094220749092949 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PRINTER_FRIENDLY_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_error_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Referenced as error template.';

wwv_flow_api.create_message (
  p_id=>87094800794096624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.ERROR_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Referenced in page(s)';

wwv_flow_api.create_message (
  p_id=>87095817070101302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_not_referenced
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This page template is NOT referenced.';

wwv_flow_api.create_message (
  p_id=>87096400233105935 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.NOT_REFERENCED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message template_utilization_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This page template is';

wwv_flow_api.create_message (
  p_id=>87096816163110523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEMPLATE_UTILIZATION.PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tree Name';

wwv_flow_api.create_message (
  p_id=>87100518156129995 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type';

wwv_flow_api.create_message (
  p_id=>87101032008134006 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item';

wwv_flow_api.create_message (
  p_id=>87101410322137176 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_tree_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tree Query';

wwv_flow_api.create_message (
  p_id=>87101824521141279 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.TREE_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_show_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show Source';

wwv_flow_api.create_message (
  p_id=>87105109545155925 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_SHOW_SOURCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_query_hide_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hide Source';

wwv_flow_api.create_message (
  p_id=>87106324090160136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.QUERY_HIDE_SOURCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>87114003574173164 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'List Template';

wwv_flow_api.create_message (
  p_id=>87115117080177017 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_seq
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence';

wwv_flow_api.create_message (
  p_id=>87115503012182392 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_SEQ',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Text';

wwv_flow_api.create_message (
  p_id=>87116415479186021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message page_region_list_item_target
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Target';

wwv_flow_api.create_message (
  p_id=>87117322059187952 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGE_REGION.LIST_ITEM_TARGET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_page_items
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Items';

wwv_flow_api.create_message (
  p_id=>87120925438207806 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PAGE_ITEMS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region';

wwv_flow_api.create_message (
  p_id=>87122506522211862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_set_region
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'click to set region';

wwv_flow_api.create_message (
  p_id=>87123920721215917 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.SET_REGION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_prompt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Prompt';

wwv_flow_api.create_message (
  p_id=>87125001805219905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.PROMPT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_page_item_no_item_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No items found';

wwv_flow_api.create_message (
  p_id=>87126316003224021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PAGE_ITEM.NO_ITEM_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_apply_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'apply permissions';

wwv_flow_api.create_message (
  p_id=>87136902890248573 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_APPLY_PERMISSIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_display_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Display Value';

wwv_flow_api.create_message (
  p_id=>87137303929248901 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISPLAY_VALUE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_return_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Return Value';

wwv_flow_api.create_message (
  p_id=>87139718821253252 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.RETURN_VALUE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_revoke_permissions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'revoke permissions';

wwv_flow_api.create_message (
  p_id=>87140122976254366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_REVOKE_PERMISSIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Default';

wwv_flow_api.create_message (
  p_id=>87140931634256903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DEFAULT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_primary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Primary Sort Column';

wwv_flow_api.create_message (
  p_id=>87147015620271186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.PRIMARY_SORT_COL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message prefs_noaction_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'no action required';

wwv_flow_api.create_message (
  p_id=>87149105015277636 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PREFS_NOACTION_REQUIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_secondary_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Secondary Sort Column';

wwv_flow_api.create_message (
  p_id=>87163501730314472 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SECONDARY_SORT_COL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_select_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Select Column';

wwv_flow_api.create_message (
  p_id=>87164316621318856 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.SELECT_COL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_report_wiz_disable_sort_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Disable Sort Column';

wwv_flow_api.create_message (
  p_id=>87165330127322693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_REPORT_WIZ.DISABLE_SORT_COL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tab_manager_warning
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warning: Parent tab target "%0" appears to reference a page that does not exist.';

wwv_flow_api.create_message (
  p_id=>87169717922338159 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TAB_MANAGER.WARNING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to refresh following item help';

wwv_flow_api.create_message (
  p_id=>87194106672372667 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message publish_item_help_confirm2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'If this is correct, click Refresh All. Otherwise, click Cancel.';

wwv_flow_api.create_message (
  p_id=>87195629874379386 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PUBLISH_ITEM_HELP.CONFIRM2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_confirm_delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You are about to delete an authentication scheme from application %0. If the application is not currently using SCHEME authentication or if the scheme is not the current authentication scheme, deleting the scheme has no effect on the operation of the application. If the application is using SCHEME authentication and this is the current authentication scheme, the application will continue to run us';

h:=h||'ing SCHEME authentication, but with a default authentication scheme. This will use a built-in login page with "open door" credentials verification (that is, anyone will be allowed to run the application). ';

wwv_flow_api.create_message (
  p_id=>87208221048414695 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.CONFIRM_DELETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_dup_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The column names <b>%0</b> are used more than once in this table.';

wwv_flow_api.create_message (
  p_id=>87227127113454296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.DUP_COL_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_nbr
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The precision for the column <b>%0</b> is invalid (1 - 38).<br />';

wwv_flow_api.create_message (
  p_id=>87240403049485169 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_NBR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_scale
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The scale for the column <b>%0</b> is invalid (-84 - 127).<br />';

wwv_flow_api.create_message (
  p_id=>87241207551486541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_SCALE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_precision_char
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The precision for the column <b>%0</b> is invalid (%1 - %2).<br />';

wwv_flow_api.create_message (
  p_id=>87242013092488122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_PRECISION_CHAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_invalid_col_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The column name <b>%0</b> is invalid.<br />';

wwv_flow_api.create_message (
  p_id=>87249017379498849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.INVALID_COL_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p602_enter_at_least_one_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Must enter the name of at least one column.';

wwv_flow_api.create_message (
  p_id=>87252419934509031 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.P602.ENTER_AT_LEAST_ONE_COL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_dup_arg_names
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The argument name <b>%0</b> is used more than once in this function.<br />';

wwv_flow_api.create_message (
  p_id=>87301303321579921 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500.DUP_ARG_NAMES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p232_reset_css
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Reset CSS';

wwv_flow_api.create_message (
  p_id=>87403413025738167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000_P232_RESET_CSS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_native
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Native file format.';

wwv_flow_api.create_message (
  p_id=>87772822417376371 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_NATIVE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_text_file_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View document as text.';

wwv_flow_api.create_message (
  p_id=>87774310212391770 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_TEXT_FILE_FORMAT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_parse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parse this script.';

wwv_flow_api.create_message (
  p_id=>87775006880400316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_PARSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_show_all_workspaces
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show All Workspaces';

wwv_flow_api.create_message (
  p_id=>87844101253467937 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050_SHOW_ALL_WORKSPACES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_columns
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Columns';

wwv_flow_api.create_message (
  p_id=>87878327197948501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.COLUMNS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_conditions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Conditions';

wwv_flow_api.create_message (
  p_id=>87878820056955889 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.CONDITIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Arrow Down';

wwv_flow_api.create_message (
  p_id=>87879208544971469 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_DOWN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_arrow_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Arrow Right';

wwv_flow_api.create_message (
  p_id=>87879626552976677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.ARROW_RIGHT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'AND';

wwv_flow_api.create_message (
  p_id=>87880010753981624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.AND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_or
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'OR';

wwv_flow_api.create_message (
  p_id=>87880424951985732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.OR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_condition_preview
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Preview Condition';

wwv_flow_api.create_message (
  p_id=>87881504089998606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_CONDITION.PREVIEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_refresh
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to refresh the following authentication schemes';

wwv_flow_api.create_message (
  p_id=>87885922059051132 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.REFRESH',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message authentication_make_current
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Click the Make Current button to have your application use this authentication scheme.';

wwv_flow_api.create_message (
  p_id=>87889804014093209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTHENTICATION.MAKE_CURRENT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The create table script for table %0 has been created in the SQL script repository.';

wwv_flow_api.create_message (
  p_id=>87894509255123107 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_script_repository
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Go to Script Repository';

wwv_flow_api.create_message (
  p_id=>87895703499130887 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SCRIPT_REPOSITORY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL Workshop Home';

wwv_flow_api.create_message (
  p_id=>87896421853136195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP_HOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_run_script
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Run Script';

wwv_flow_api.create_message (
  p_id=>87897407785141651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RUN_SCRIPT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Return to';

wwv_flow_api.create_message (
  p_id=>87898129256147797 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.RETURN_TO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;Workshop';

wwv_flow_api.create_message (
  p_id=>87899117959154028 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.SQL_WORKSHOP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_table_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Home';

wwv_flow_api.create_message (
  p_id=>87899628002156915 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_TABLE.HOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The package "%0" has been created in the "%1" schema.';

wwv_flow_api.create_message (
  p_id=>87902231166186180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_browse
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Browse Package';

wwv_flow_api.create_message (
  p_id=>87903006147197894 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BROWSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL Workshop Home';

wwv_flow_api.create_message (
  p_id=>87903418614201542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP_HOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_return_to
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Return to';

wwv_flow_api.create_message (
  p_id=>87903804547206903 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.RETURN_TO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_sql_workshop
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL&nbsp;Workshop';

wwv_flow_api.create_message (
  p_id=>87904223940212505 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.SQL_WORKSHOP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_home
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Home';

wwv_flow_api.create_message (
  p_id=>87904608141217443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.HOME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_back
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Back to Create Table Wizard';

wwv_flow_api.create_message (
  p_id=>87906532513233934 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.BACK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_package_failed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Creating table "%0" failed.';

wwv_flow_api.create_message (
  p_id=>87908128751261177 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_PACKAGE.FAILED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message null_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(null)';

wwv_flow_api.create_message (
  p_id=>87938019026731545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NULL_IN_PAREN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4300_instruct_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'First row contains column names.';

wwv_flow_api.create_message (
  p_id=>87938425952733481 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4300_INSTRUCT_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(table)';

wwv_flow_api.create_message (
  p_id=>87941216171749635 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE_IN_PAREN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view_in_paren
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'(view)';

wwv_flow_api.create_message (
  p_id=>87942426858764735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW_IN_PAREN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_applications
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'All Applications';

wwv_flow_api.create_message (
  p_id=>87983805377032963 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_APPLICATIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message seconds
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'seconds';

wwv_flow_api.create_message (
  p_id=>87996606697203579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SECONDS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minute
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'minute';

wwv_flow_api.create_message (
  p_id=>87997116047206349 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message minutes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'minutes';

wwv_flow_api.create_message (
  p_id=>87997520895207713 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MINUTES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hour
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'hour';

wwv_flow_api.create_message (
  p_id=>87997925051208938 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOUR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'hours';

wwv_flow_api.create_message (
  p_id=>87998329206210072 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HOURS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message day
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Day';

wwv_flow_api.create_message (
  p_id=>87998701979211749 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'days';

wwv_flow_api.create_message (
  p_id=>87999105096212650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DAYS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message week
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Week';

wwv_flow_api.create_message (
  p_id=>87999508559213652 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'weeks';

wwv_flow_api.create_message (
  p_id=>87999912022214596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEEKS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message year
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'year';

wwv_flow_api.create_message (
  p_id=>88000317563216203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'YEAR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_users
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'All Users';

wwv_flow_api.create_message (
  p_id=>88002619472254588 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_USERS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'last';

wwv_flow_api.create_message (
  p_id=>88021328270342361 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LAST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'function';

wwv_flow_api.create_message (
  p_id=>88048600163580167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'index';

wwv_flow_api.create_message (
  p_id=>88049007435582316 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INDEX',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message package
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'package';

wwv_flow_api.create_message (
  p_id=>88049412284583760 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PACKAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'procedure';

wwv_flow_api.create_message (
  p_id=>88049817478585185 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROCEDURE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sequence
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'sequence';

wwv_flow_api.create_message (
  p_id=>88050221288586298 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SEQUENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message synonym
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'synonym';

wwv_flow_api.create_message (
  p_id=>88050624751587352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SYNONYM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'table';

wwv_flow_api.create_message (
  p_id=>88051028214588345 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message trigger
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'trigger';

wwv_flow_api.create_message (
  p_id=>88051431677589329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TRIGGER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'view';

wwv_flow_api.create_message (
  p_id=>88051802026590242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VIEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message insert
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'insert';

wwv_flow_api.create_message (
  p_id=>88055813678659792 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSERT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'update';

wwv_flow_api.create_message (
  p_id=>88056217141660805 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message delete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'delete';

wwv_flow_api.create_message (
  p_id=>88056620604661839 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DELETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not_in_data_dict
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Not in Data Dictionary';

wwv_flow_api.create_message (
  p_id=>88090322335012391 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT_IN_DATA_DICT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_tabset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'New Tabset';

wwv_flow_api.create_message (
  p_id=>88103026987174618 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_TABSET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message not
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Not';

wwv_flow_api.create_message (
  p_id=>88105708249216517 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NOT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Breadcrumb';

wwv_flow_api.create_message (
  p_id=>88111108558263925 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MENU',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message sql_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SQL Query';

wwv_flow_api.create_message (
  p_id=>88137431039743484 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SQL_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message structured_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'structured query';

wwv_flow_api.create_message (
  p_id=>88137819526759156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'STRUCTURED_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message function_body_returning_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL function body returning SQL query';

wwv_flow_api.create_message (
  p_id=>88138201088772751 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FUNCTION_BODY_RETURNING_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML Text';

wwv_flow_api.create_message (
  p_id=>88138621997788233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message plsql_procedure
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL';

wwv_flow_api.create_message (
  p_id=>88139012086794834 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLSQL_PROCEDURE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message anonymous_block
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'anonymous block';

wwv_flow_api.create_message (
  p_id=>88139419358796943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ANONYMOUS_BLOCK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message help_text
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'help text';

wwv_flow_api.create_message (
  p_id=>88140020874806833 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HELP_TEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message web_service_result
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Web Service result';

wwv_flow_api.create_message (
  p_id=>88140408538812764 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WEB_SERVICE_RESULT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'chart';

wwv_flow_api.create_message (
  p_id=>88140824815817440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message simple
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'simple';

wwv_flow_api.create_message (
  p_id=>88141200835829449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SIMPLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message escape_sc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'escape special characters';

wwv_flow_api.create_message (
  p_id=>88141602698839382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ESCAPE_SC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message with_shortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'with shortcuts';

wwv_flow_api.create_message (
  p_id=>88142001790848622 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WITH_SHORTCUTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updateable_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'updateable report';

wwv_flow_api.create_message (
  p_id=>88142427070855867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATEABLE_REPORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'URL';

wwv_flow_api.create_message (
  p_id=>88142806423859428 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message tree
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'tree';

wwv_flow_api.create_message (
  p_id=>88143220968863612 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TREE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'list';

wwv_flow_api.create_message (
  p_id=>88143601359867374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_themes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'all themes';

wwv_flow_api.create_message (
  p_id=>88150006909944679 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_THEMES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML';

wwv_flow_api.create_message (
  p_id=>88170724842044532 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message driven
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'driven';

wwv_flow_api.create_message (
  p_id=>88171105019057676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'DRIVEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message image
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'image';

wwv_flow_api.create_message (
  p_id=>88171504111066905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IMAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No Template';

wwv_flow_api.create_message (
  p_id=>88177025722158291 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message no_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'no item';

wwv_flow_api.create_message (
  p_id=>88178311786173189 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NO_ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message popup_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'popup List of Values';

wwv_flow_api.create_message (
  p_id=>88181523653233378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'POPUP_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message schemes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'schemes';

wwv_flow_api.create_message (
  p_id=>88183510110276832 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SCHEMES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message shortcut
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'shortcut';

wwv_flow_api.create_message (
  p_id=>88184507124285370 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SHORTCUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_page_as_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use page %0 as login page.';

wwv_flow_api.create_message (
  p_id=>88192207826361362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_PAGE_AS_LOGIN_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_new_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create new login page.';

wwv_flow_api.create_message (
  p_id=>88192610381371516 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_NEW_LOGIN_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message use_builtin_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Use built-in login page.';

wwv_flow_api.create_message (
  p_id=>88193031506377596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'USE_BUILTIN_LOGIN_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'workspace';

wwv_flow_api.create_message (
  p_id=>88198018917440193 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WORKSPACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message core
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'core';

wwv_flow_api.create_message (
  p_id=>88198422380441257 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CORE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message all_static_files
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'all static files';

wwv_flow_api.create_message (
  p_id=>88269320723696242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ALL_STATIC_FILES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message associated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'associated';

wwv_flow_api.create_message (
  p_id=>88270128342698420 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ASSOCIATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1816 Unexpected error converting application alias p_flow_alias_or_id (%0).';

wwv_flow_api.create_message (
  p_id=>88273305533720195 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_not_logged_in
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Not logged in.  Cookie required for authentication was missing or invalid.';

wwv_flow_api.create_message (
  p_id=>88281125796763944 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NOT_LOGGED_IN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_click_to_login
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<p>Click <a href="%0">here</a> to login</a>';

wwv_flow_api.create_message (
  p_id=>88288311298788152 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLICK_TO_LOGIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-99900 Could not create unique session ID: %0';

wwv_flow_api.create_message (
  p_id=>88290709698797097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_SESSION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_session_info_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1029 Unable to store session info.  session=%0 item=%1';

wwv_flow_api.create_message (
  p_id=>88319100787851303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SESSION_INFO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_save_routine_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Unexpected error in Save Routine.';

wwv_flow_api.create_message (
  p_id=>88319712215854623 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SAVE_ROUTINE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_deeplinking_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Unexpected error in make_deeplinking_item session=%0';

wwv_flow_api.create_message (
  p_id=>88320705766862172 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DEEPLINKING_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1002 Unable to find item ID for item "%0" in application "%1".';

wwv_flow_api.create_message (
  p_id=>88321930700869418 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_id_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unexpected error, unable to find item name at application or page level.';

wwv_flow_api.create_message (
  p_id=>88323015594874559 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ID_ERR2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1902 Item ID is null in find_item_name routine.';

wwv_flow_api.create_message (
  p_id=>88324312608883071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unexpected error';

wwv_flow_api.create_message (
  p_id=>88326113432892799 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNEXPECTED_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_find_item_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1802 Unable to find item id "%0"';

wwv_flow_api.create_message (
  p_id=>88326621051894974 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIND_ITEM_ERR2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1082 Error in executing authorization scheme code.';

wwv_flow_api.create_message (
  p_id=>88327003174899281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AUTH_SCHEME_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_access_denied
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Access denied by %0 security check';

wwv_flow_api.create_message (
  p_id=>88327623952905309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ACCESS_DENIED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_first_page_data_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You are already at the first page of data.';

wwv_flow_api.create_message (
  p_id=>88333014433940374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FIRST_PAGE_DATA_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1001 Unexpected error creating item: FSP_PROCESS_STATE_%0';

wwv_flow_api.create_message (
  p_id=>88333831402945337 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CREATE_ITEM_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1003 Error executing computation query.';

wwv_flow_api.create_message (
  p_id=>88334227031953545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_QUERY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1030 Error executing computation expression.';

wwv_flow_api.create_message (
  p_id=>88339305130966102 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_EXP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_function_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1004 Unable to compute function. computation_point=%0 computation_type=%1';

wwv_flow_api.create_message (
  p_id=>88344631926983354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_FUNCTION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_comp_unknown_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1005 Unknown computation type.';

wwv_flow_api.create_message (
  p_id=>88350523184999693 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.COMP_UNKNOWN_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_validation_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1006 Error in validation routine.';

wwv_flow_api.create_message (
  p_id=>88351229072001374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VALIDATION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 Unable to run "function body returning text" validation.';

wwv_flow_api.create_message (
  p_id=>88352922277008912 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_TEXT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_func_body_ret_bool_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1021 Unable to run "function body returning boolean" validation.';

wwv_flow_api.create_message (
  p_id=>88353405092013382 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FUNC_BODY_RET_BOOL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_point_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1007 Branch point can not be null: %0';

wwv_flow_api.create_message (
  p_id=>88354902799022211 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_POINT_NULL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1008 Error performing branch to page %0.';

wwv_flow_api.create_message (
  p_id=>88356921500027628 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_PAGE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_accept_recur_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1010 Branch to page accept processing recursion limit exceeded. %0';

wwv_flow_api.create_message (
  p_id=>88358209856033741 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ACCEPT_RECUR_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_to_funct_ret_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 Unable to process branch to function returning page.';

wwv_flow_api.create_message (
  p_id=>88358631805049506 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_TO_FUNCT_RET_PAGE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_func_returning_url_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7744 Unable to process branch to function returning URL.';

wwv_flow_api.create_message (
  p_id=>88359018430055125 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_FUNC_RETURNING_URL_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1009 Error in branch processing.';

wwv_flow_api.create_message (
  p_id=>88359402284059953 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BRANCH_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sql_exp_heading_text_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1910 Error evaluating SQL expression in heading text.';

wwv_flow_api.create_message (
  p_id=>88359825833066738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SQL_EXP_HEADING_TEXT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_eval_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1011 Invalid evaluation type: %0';

wwv_flow_api.create_message (
  p_id=>88360209688071529 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.EVAL_TYPE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error';

wwv_flow_api.create_message (
  p_id=>88360625618076097 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_g_flow_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 Unexpected error assigning G_FLOW_ID (%0).';

wwv_flow_api.create_message (
  p_id=>88361525056085421 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.G_FLOW_ID_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_page_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1412 Unable to resolve page alias (%0).';

wwv_flow_api.create_message (
  p_id=>88361908218089994 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.PAGE_ALIAS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_call_to_show_from_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1430 Call to show from page process unsupported: G_FLOW_STEP_ID (%0).';

wwv_flow_api.create_message (
  p_id=>88362300038097085 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CALL_TO_SHOW_FROM_PROC_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7620 Could not determine workspace for application (%0).';

wwv_flow_api.create_message (
  p_id=>88363420124102961 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Expecting p_company or wwv_flow_company cookie to contain security group id of application owner.';

wwv_flow_api.create_message (
  p_id=>88364207788108795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_FOOTER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 Application not found.';

wwv_flow_api.create_message (
  p_id=>88365228912114920 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace Information';

wwv_flow_api.create_message (
  p_id=>88365720039121793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.WORKSPACE_INFO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_found_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'application=%0  workspace=%1';

wwv_flow_api.create_message (
  p_id=>88366129043124387 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FOUND_FOOTER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>88366503548126467 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_justification
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Justification';

wwv_flow_api.create_message (
  p_id=>88367330906134404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.JUSTIFICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_login_server_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1555 Not logged into to Oracle Login Server.  No public user identified.';

wwv_flow_api.create_message (
  p_id=>88367632638134887 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGIN_SERVER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>88368010259137953 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DESCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administrator Information';

wwv_flow_api.create_message (
  p_id=>88368422033141292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ADMIN_INFO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_first_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'First Name';

wwv_flow_api.create_message (
  p_id=>88368832076144203 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.FIRST_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_last_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Last Name';

wwv_flow_api.create_message (
  p_id=>88369211082147593 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.LAST_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'E-mail';

wwv_flow_api.create_message (
  p_id=>88369621471150584 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.EMAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_phone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Phone';

wwv_flow_api.create_message (
  p_id=>88370032207153677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.PHONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema Information';

wwv_flow_api.create_message (
  p_id=>88370414330157995 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_INFO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Reuse Existing Schema';

wwv_flow_api.create_message (
  p_id=>88370826451161542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.REUSE_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Yes';

wwv_flow_api.create_message (
  p_id=>88371207189165451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.YES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No';

wwv_flow_api.create_message (
  p_id=>88371618270168577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.NO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema Name';

wwv_flow_api.create_message (
  p_id=>88372030045171982 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.SCHEMA_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1333 ASFCOOKIE cound not be fetched.';

wwv_flow_api.create_message (
  p_id=>88372506627174756 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_db_size
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Database Size';

wwv_flow_api.create_message (
  p_id=>88372809051175372 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.DB_SIZE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1201 session ID not set on custom authentication.';

wwv_flow_api.create_message (
  p_id=>88373227752180862 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_session_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'page=%0';

wwv_flow_api.create_message (
  p_id=>88373710221185186 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CUSTOM_AUTH_SESSION_FOOTER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message service_signup_accept
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enter case sensitive Verification Code and click <b>Submit Request</b>.';

wwv_flow_api.create_message (
  p_id=>88374010221185214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SERVICE_SIGNUP.ACCEPT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unsupp_auth_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1444 Unsupported authentication scheme.';

wwv_flow_api.create_message (
  p_id=>88376318448206546 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNSUPP_AUTH_SCHEME_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_new
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to provision a new %0.';

wwv_flow_api.create_message (
  p_id=>88376714770214962 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_workspace_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace Information';

wwv_flow_api.create_message (
  p_id=>88377307282222256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.WORKSPACE_INFO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Name';

wwv_flow_api.create_message (
  p_id=>88377720442226055 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_sgid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Security Group ID';

wwv_flow_api.create_message (
  p_id=>88378101526230060 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SGID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_system_assigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'System Assigned';

wwv_flow_api.create_message (
  p_id=>88378514339233719 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SYSTEM_ASSIGNED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>88379000618239214 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DESCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_inv_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1014 Application not found.  Invalid workspace.';

wwv_flow_api.create_message (
  p_id=>88379304428240302 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_INV_COMP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_admin_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Administrator Information';

wwv_flow_api.create_message (
  p_id=>88379812739242757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.ADMIN_INFO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_user_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User Name';

wwv_flow_api.create_message (
  p_id=>88380225898246558 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.USER_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'E-mail';

wwv_flow_api.create_message (
  p_id=>88380604559249851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.EMAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Title';

wwv_flow_api.create_message (
  p_id=>88381024991255715 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_fnd_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'application=%0 current workspace=%1 requested workspace=%2';

wwv_flow_api.create_message (
  p_id=>88381300880258184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_FND_FOOTER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted_to_dev
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Access to this application is restricted to application developers, please try again later.';

wwv_flow_api.create_message (
  p_id=>88381709538260685 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED_TO_DEV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema Information';

wwv_flow_api.create_message (
  p_id=>88382225814265376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_INFO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_restricted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Access to this application is restricted, please try again later.';

wwv_flow_api.create_message (
  p_id=>88382526853265743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_RESTRICTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_reuse_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Reuse Existing Schema';

wwv_flow_api.create_message (
  p_id=>88383005167268956 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.REUSE_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1181 Unable to set VPD security context on page show.';

wwv_flow_api.create_message (
  p_id=>88383307245269544 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_yes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Yes';

wwv_flow_api.create_message (
  p_id=>88383715902272057 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.YES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_afscookie_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1111 asfcookie must not be null.';

wwv_flow_api.create_message (
  p_id=>88384225945274899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.AFSCOOKIE_NULL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_no
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No';

wwv_flow_api.create_message (
  p_id=>88384526638275154 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.NO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_schema_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema Name';

wwv_flow_api.create_message (
  p_id=>88384905298278380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.SCHEMA_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_create_tblspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tablespace will be created';

wwv_flow_api.create_message (
  p_id=>88385421228283040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.CREATE_TBLSPACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1016 Application "%0" Page "%1" not found (requested language="%2")';

wwv_flow_api.create_message (
  p_id=>88385723652283701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_NOT_FND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_flow_xxx
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'FLOW_XXX';

wwv_flow_api.create_message (
  p_id=>88386203351287333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.FLOW_XXX',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_contact_admin
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Contact your application administrator.';

wwv_flow_api.create_message (
  p_id=>88386509585289082 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CONTACT_ADMIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message provision_request_datafile
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Datafile for tablespace';

wwv_flow_api.create_message (
  p_id=>88386918589291696 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PROVISION_REQUEST.DATAFILE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_required_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Required role not enabled.';

wwv_flow_api.create_message (
  p_id=>88387707984298150 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.REQUIRED_ROLE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_logout
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Logout';

wwv_flow_api.create_message (
  p_id=>88388431533304905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.LOGOUT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1013 No privilege for attempted operation by user %0. Requires role %1, please contact your application administrator.';

wwv_flow_api.create_message (
  p_id=>88391014133318821 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PRIV_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_clear_step_cache_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1018 Error clearing step cache.';

wwv_flow_api.create_message (
  p_id=>88393518813357980 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CLEAR_STEP_CACHE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_resolve_alias_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1512 Unable to resolve page alias (%0).';

wwv_flow_api.create_message (
  p_id=>88394325093388260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_RESOLVE_ALIAS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_company_on_accept_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-7621 Could not determine workspace for application (%0) on application accept.';

wwv_flow_api.create_message (
  p_id=>88394714143394514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMPANY_ON_ACCEPT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_det_comp_for_flow_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Expecting p_company or wwv_flow_company cookie to contain security group id of application owner.';

wwv_flow_api.create_message (
  p_id=>88395103538400931 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.DET_COMP_FOR_FLOW_FOOTER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_set_vpd_context_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1182 Unable to set VPD security context on page accept.';

wwv_flow_api.create_message (
  p_id=>88395704708410684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.SET_VPD_CONTEXT_ERR2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_insufficent_info_on_req_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-9988 Insufficient information provided for this request:  It is likely that you did not wait for your previous page to fully load.  Press your browsers back and reload buttons, or navigate to your applictions home page to continue.';

wwv_flow_api.create_message (
  p_id=>88396129296417854 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.INSUFFICENT_INFO_ON_REQ_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_page_request_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'application=%0 page=%1 request=%2';

wwv_flow_api.create_message (
  p_id=>88407219346471762 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_PAGE_REQUEST_FOOTER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_save_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1022 Unable to save attributes.';

wwv_flow_api.create_message (
  p_id=>88416518916490500 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_SAVE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1023 Unable perform validations.';

wwv_flow_api.create_message (
  p_id=>88419200693494703 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_VALID_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_perf_processing_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1024 Unable perform processing.';

wwv_flow_api.create_message (
  p_id=>88422025627501910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_PERF_PROCESSING_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_to_branch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1777: Page %0 provided no page to branch to.  Please report this error to your application administrator.';

wwv_flow_api.create_message (
  p_id=>88423912598507598 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_TO_BRANCH_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_restart_app
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<a href="f?p=%0">Restart Application</a>';

wwv_flow_api.create_message (
  p_id=>88426830606512828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.RESTART_APP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_no_page_help
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No page help available.';

wwv_flow_api.create_message (
  p_id=>88429213075517199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.NO_PAGE_HELP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1019 Error computing item default value: page=%0 name=%1.';

wwv_flow_api.create_message (
  p_id=>88456316688679104 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_VAL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_plsql_item_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1020 Error in PLSQL item processing (function).';

wwv_flow_api.create_message (
  p_id=>88457323053690425 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.PLSQL_ITEM_PROC_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_default_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1904 Unable to compute item default: type = Function Body computation_type= %0.';

wwv_flow_api.create_message (
  p_id=>88457831149702261 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_DEFAULT_FUNC_BODY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_post_calc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1079 Error in item post calculation computation.';

wwv_flow_api.create_message (
  p_id=>88458219505708300 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_POST_CALC_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_spell_chk
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Spell Check';

wwv_flow_api.create_message (
  p_id=>88458832319712030 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.SPELL_CHK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1025 Error processing PLSQL expression.  %0';

wwv_flow_api.create_message (
  p_id=>88459428556739296 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_plsql_exp_footer_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application=%0 Page=%1 SQLERRM=%2';

wwv_flow_api.create_message (
  p_id=>88459922800747137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PLSQL_EXP_FOOTER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_func_return_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1101 Unable to process function body returning query.';

wwv_flow_api.create_message (
  p_id=>88460325355757354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FUNC_RETURN_QUERY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_proc_curr_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1108 Unable to process item current condition.';

wwv_flow_api.create_message (
  p_id=>88461230812777849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PROC_CURR_COND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unable_set_short_val_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-2904 Unable to set shortcut value.';

wwv_flow_api.create_message (
  p_id=>88462629127805679 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNABLE_SET_SHORT_VAL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_trees_root_not_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warning: Tree root ID "%0" not found.';

wwv_flow_api.create_message (
  p_id=>88464016576820971 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREES.ROOT_NOT_FND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message v_alias_conversion_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1812 Unexpected Error converting application alias (%0).';

wwv_flow_api.create_message (
  p_id=>88479108573866020 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'V.ALIAS_CONVERSION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_application
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application:';

wwv_flow_api.create_message (
  p_id=>88523421302888619 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.APPLICATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page:';

wwv_flow_api.create_message (
  p_id=>88552708966894541 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_plsql_lines_source
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'PL/SQL %0 %1 contains %2 lines of source code.';

wwv_flow_api.create_message (
  p_id=>88558126281899501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PLSQL_LINES_SOURCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'<span class="tiny">No pages found.</font>';

wwv_flow_api.create_message (
  p_id=>88559708404903797 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_PAGES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_pages
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 <font size=-2>Pages</span>';

wwv_flow_api.create_message (
  p_id=>88561922949908002 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.PAGES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_det_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1000 Unable to determine List of Values from "declare function x return varchar2 is begin %0  return null; end; begin wwv_flow_utilities.g_query := x; end;".';

wwv_flow_api.create_message (
  p_id=>88570727021928091 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_DET_LOV_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_js_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'JavaScript not supported.';

wwv_flow_api.create_message (
  p_id=>88572613992933843 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.JS_NOT_SUPPORTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'List';

wwv_flow_api.create_message (
  p_id=>88573524035936761 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.LIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message manage_unassigned
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Manage Unassigned';

wwv_flow_api.create_message (
  p_id=>89492503020021602 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MANAGE_UNASSIGNED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Complementary';

wwv_flow_api.create_message (
  p_id=>89772822887837167 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_split_complementary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Split complementary';

wwv_flow_api.create_message (
  p_id=>89773231544839616 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_SPLIT_COMPLEMENTARY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_triade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Triade';

wwv_flow_api.create_message (
  p_id=>89773606395841873 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TRIADE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_tetrade
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Tetrade';

wwv_flow_api.create_message (
  p_id=>89774118516845404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_TETRADE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_analogic
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Analogic';

wwv_flow_api.create_message (
  p_id=>89774508950852044 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_ANALOGIC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_monotone
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Monotone';

wwv_flow_api.create_message (
  p_id=>89774922456855939 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_MONOTONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message color_palette_complementary_colors
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Complementary Colors';

wwv_flow_api.create_message (
  p_id=>89780016578929941 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'COLOR_PALETTE_COMPLEMENTARY_COLORS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fetch_value_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application error in fetch_value.';

wwv_flow_api.create_message (
  p_id=>90629301848997585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.FETCH_VALUE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_button_temp_fetch_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error fetching button template id=%0';

wwv_flow_api.create_message (
  p_id=>90635200725016256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.BUTTON_TEMP_FETCH_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to trace: %0';

wwv_flow_api.create_message (
  p_id=>90667108784075267 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_TRACE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_set_timed_stat_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to set timed_statistics: %0';

wwv_flow_api.create_message (
  p_id=>90671203374083205 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_SET_TIMED_STAT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_app_not_available
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Not Available';

wwv_flow_api.create_message (
  p_id=>90685113333104969 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.APP_NOT_AVAILABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_to_stop_trace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to stop trace: %0';

wwv_flow_api.create_message (
  p_id=>90690616927115514 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_TO_STOP_TRACE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_view_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application and page must be provided to view help.';

wwv_flow_api.create_message (
  p_id=>90699001174148794 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.VIEW_HELP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_item_not_disp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error: Item "%0" was not displayed because the HTML form was not yet opened.';

wwv_flow_api.create_message (
  p_id=>90711903477215730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.ITEM_NOT_DISP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_unable_cast_value
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to cast value "%0" to date format mask %1.';

wwv_flow_api.create_message (
  p_id=>90713017806229268 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.UNABLE_CAST_VALUE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_edit_item
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Edit item %0 - %1 , Sequence: %2';

wwv_flow_api.create_message (
  p_id=>90739820670286891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.EDIT ITEM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_reset_pag_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to reset region pagination.';

wwv_flow_api.create_message (
  p_id=>90971500041141999 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RESET_PAG_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_print_shortcut_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to print shortcut: %0';

wwv_flow_api.create_message (
  p_id=>90977127530159463 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.PRINT_SHORTCUT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_render_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in rendering chart: %0';

wwv_flow_api.create_message (
  p_id=>90980824890168114 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.RENDER_CHART_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_debug
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Debug:';

wwv_flow_api.create_message (
  p_id=>90983227445178357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.DEBUG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_feature_not_supported
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Feature not supported by this version.';

wwv_flow_api.create_message (
  p_id=>91047208426399878 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.FEATURE_NOT_SUPPORTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_request_for_help_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error 4322- Request for help did not use proper syntax.  Request was null when expecting a valid page number.';

wwv_flow_api.create_message (
  p_id=>91049328989415357 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.REQUEST_FOR_HELP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_help_request_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error 4323- Request for help did not provide a numeric page ID to show help for.';

wwv_flow_api.create_message (
  p_id=>91050926696424133 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.HELP_REQUEST_ERR2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_unable_init_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to initialize query.';

wwv_flow_api.create_message (
  p_id=>91143125479736046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM.UNABLE_INIT_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_company_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace required.';

wwv_flow_api.create_message (
  p_id=>91161404448786667 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.COMPANY_REQUIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_flow_required
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application required.';

wwv_flow_api.create_message (
  p_id=>91336917749893254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.FLOW_REQUIRED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid username "%0" or password.';

wwv_flow_api.create_message (
  p_id=>91337320304903384 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_rows
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rows';

wwv_flow_api.create_message (
  p_id=>91342818872224685 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_ROWS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_axis
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Axis';

wwv_flow_api.create_message (
  p_id=>91343225105226531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AXIS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_average
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Average';

wwv_flow_api.create_message (
  p_id=>91343610345231701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_AVERAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_sum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sum';

wwv_flow_api.create_message (
  p_id=>91344600433238332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_SUM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_maximum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Maximum';

wwv_flow_api.create_message (
  p_id=>91345012554241809 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MAXIMUM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_minimum
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Minimum';

wwv_flow_api.create_message (
  p_id=>91345419480243777 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_MINIMUM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Last';

wwv_flow_api.create_message (
  p_id=>91345823982245118 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_LAST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_first
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'First';

wwv_flow_api.create_message (
  p_id=>91346229523246673 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_FIRST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_chart2_t_go
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Go';

wwv_flow_api.create_message (
  p_id=>91346805413249219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CHART2.T_GO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message chart_invalid_chart_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid chart type.';

wwv_flow_api.create_message (
  p_id=>91347420304253520 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CHART.INVALID_CHART_TYPE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_custom_auth_sso_redirect_to_login_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Redirecting to the Login Server for authentication...';

wwv_flow_api.create_message (
  p_id=>91353529934426579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOM_AUTH_SSO.REDIRECT_TO_LOGIN_SERVER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_line_too_long
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Line length %0 exceeds maximum %1 at line %2';

wwv_flow_api.create_message (
  p_id=>91363029745292775 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.LINE_TOO_LONG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Check the regions you wish to have included on this page.  Checked regions may not display if you are not in the proper application context or do not have proper privileges.';

wwv_flow_api.create_message (
  p_id=>91415531095710840 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_message2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No customizable regions found for this page.';

wwv_flow_api.create_message (
  p_id=>91417117027716228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_MESSAGE2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_close
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Close';

wwv_flow_api.create_message (
  p_id=>91418103306721678 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CLOSE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_apply
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Apply Changes';

wwv_flow_api.create_message (
  p_id=>91418513349724661 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_APPLY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_cust_opt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page Customization Options';

wwv_flow_api.create_message (
  p_id=>91420804476731519 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_CUST_OPT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_default
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Default';

wwv_flow_api.create_message (
  p_id=>91422420406736120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DEFAULT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_disp
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Displayed';

wwv_flow_api.create_message (
  p_id=>91423812226743238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_DISP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_customize_t_hidden
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hidden';

wwv_flow_api.create_message (
  p_id=>91425426424747351 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CUSTOMIZE.T_HIDDEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_func_body_null_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'parse error: Function body must not be null.';

wwv_flow_api.create_message (
  p_id=>91476310681856338 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.FUNC_BODY_NULL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'parse error: %0';

wwv_flow_api.create_message (
  p_id=>91477925703870136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.PARSE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_administration_deprecated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Deprecated';

wwv_flow_api.create_message (
  p_id=>91480001771910490 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMINISTRATION.DEPRECATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Purged %0 sessions.';

wwv_flow_api.create_message (
  p_id=>91486008528950309 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_SESSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_purge_dup_sessions
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Purged %0 duplicate sessions.';

wwv_flow_api.create_message (
  p_id=>91489411430960644 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.PURGE_DUP_SESSIONS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cache_obsolete
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'obsolete';

wwv_flow_api.create_message (
  p_id=>91492119657981881 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CACHE.OBSOLETE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_plsql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid PL/SQL expression condition: %0';

wwv_flow_api.create_message (
  p_id=>91508922951020670 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_PLSQL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_func_body_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid function body condition: %0';

wwv_flow_api.create_message (
  p_id=>91514921351029671 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_FUNC_BODY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_sql_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid SQL expression condition: %0';

wwv_flow_api.create_message (
  p_id=>91523015248037417 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_SQL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_invalid_exists_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid exists/not exists condition: %0';

wwv_flow_api.create_message (
  p_id=>91537111224045759 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.INVALID_EXISTS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable generate Popup List of Values with filter: %0';

wwv_flow_api.create_message (
  p_id=>91733125918210785 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error generating query: %0';

wwv_flow_api.create_message (
  p_id=>91736022371228694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_QUERY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in initializing List of Values: %0 ';

wwv_flow_api.create_message (
  p_id=>91739615361245591 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_LOV_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to bind "%0"';

wwv_flow_api.create_message (
  p_id=>91743214237264260 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.UNABLE_TO_BIND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_disp_only_list_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error: Display Only lists of values must select two columns.';

wwv_flow_api.create_message (
  p_id=>91744004241289737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.DISP_ONLY_LIST_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_auth_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup List of Values authentication failed.';

wwv_flow_api.create_message (
  p_id=>91803510053736096 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_AUTH_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_lov_check_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup List of Values checksum verification failed.';

wwv_flow_api.create_message (
  p_id=>91809514686746943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_LOV_CHECK_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_init_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to initialize query.';

wwv_flow_api.create_message (
  p_id=>91817211054783730 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.INIT_QUERY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_checkbox_query_lov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error evaluating checkbox query: %0';

wwv_flow_api.create_message (
  p_id=>91820318112795228 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.CHECKBOX_QUERY_LOV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_contains
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'contains';

wwv_flow_api.create_message (
  p_id=>91841703439014435 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_CONTAINS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_regexp_like
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'matches regular expression';

wwv_flow_api.create_message (
  p_id=>91881922486369978 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_REGEXP_LIKE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bold
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bold';

wwv_flow_api.create_message (
  p_id=>91936518457145445 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BOLD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_italics
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Italics';

wwv_flow_api.create_message (
  p_id=>91939307422170567 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_ITALICS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_underline
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Underline';

wwv_flow_api.create_message (
  p_id=>91940931664177663 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_UNDERLINE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_no_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Numbered List';

wwv_flow_api.create_message (
  p_id=>91941514133182065 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_NO_LIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_bull_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bulleted List';

wwv_flow_api.create_message (
  p_id=>91942131795187148 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_BULL_LIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Justify Left';

wwv_flow_api.create_message (
  p_id=>91942813918191436 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_LEFT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_cen
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Justify Center';

wwv_flow_api.create_message (
  p_id=>91945008854199462 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_CEN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_just_rt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Justify Right';

wwv_flow_api.create_message (
  p_id=>91947423399203617 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_JUST_RT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_left
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Indent Left';

wwv_flow_api.create_message (
  p_id=>91955405176207766 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_LEFT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_t_ind_right
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Indent Right';

wwv_flow_api.create_message (
  p_id=>91962815219210684 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.T_IND_RIGHT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message new_email_address
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Your new email address for your Application Express account.';

wwv_flow_api.create_message (
  p_id=>91986109686181694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'NEW_EMAIL_ADDRESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_worksheet_show_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error rendering report: %0';

wwv_flow_api.create_message (
  p_id=>92050406919216961 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_WORKSHEET.SHOW_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_create
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create PL/SQL package %0 with the following procedures:'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>92123205569586465 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_CREATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show Specification';

wwv_flow_api.create_message (
  p_id=>92126207085596347 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_SPEC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hide Specification';

wwv_flow_api.create_message (
  p_id=>92126928209602449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_SPEC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_show_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Show Body';

wwv_flow_api.create_message (
  p_id=>92128519683609451 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SHOW_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_hide_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Hide Body';

wwv_flow_api.create_message (
  p_id=>92129513234617015 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_HIDE_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_spec
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Download Specification';

wwv_flow_api.create_message (
  p_id=>92131116267636769 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_SPEC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_down_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Download Body';

wwv_flow_api.create_message (
  p_id=>92131513281645443 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DOWN_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_subprogram
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Subprogram';

wwv_flow_api.create_message (
  p_id=>92133721162666613 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_SUBPROGRAM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_description
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Description';

wwv_flow_api.create_message (
  p_id=>92136327311687332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESCRIPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'use to insert data into %0, primary key needs to be supplied';

wwv_flow_api.create_message (
  p_id=>92138516323740943 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'use to update data in %0 identified by primary key(s)';

wwv_flow_api.create_message (
  p_id=>92141801694755656 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc3
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'use to delete data from %0 based on primary key(s)';

wwv_flow_api.create_message (
  p_id=>92142517624760255 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC3',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_desc4
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'use to retieve data from %0 based on primary key(s)';

wwv_flow_api.create_message (
  p_id=>92144004941766063 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_DESC4',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_t_comment
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'-- table API for application %0, generated %1';

wwv_flow_api.create_message (
  p_id=>92146217193778974 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.T_COMMENT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_no_column_info
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No column information available.';

wwv_flow_api.create_message (
  p_id=>92168806416507513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_NO_COLUMN_INFO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message url_prohibited
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The requested URL has been prohibited. Contact your administrator.';

wwv_flow_api.create_message (
  p_id=>92340729609401286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'URL_PROHIBITED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message html_body
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML Body';

wwv_flow_api.create_message (
  p_id=>92482917543552046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTML_BODY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_item_help_invalid_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid item ID: %0 ';

wwv_flow_api.create_message (
  p_id=>93289421235340020 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ITEM_HELP.INVALID_ITEM_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message p_valid_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'A valid page number must be specified, for example p?n=1234.';

wwv_flow_api.create_message (
  p_id=>93323015704414120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'P.VALID_PAGE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_template_name_already_exists
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Template Name(s) %0 already exists.  Enter a new name.';

wwv_flow_api.create_message (
  p_id=>93404031792355486 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.TEMPLATE_NAME_ALREADY_EXISTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_create_dynamic_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'You have requested to create an Interactive Report page with the following attributes. Please confirm your selections.';

wwv_flow_api.create_message (
  p_id=>93460706616689925 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.CREATE_DYNAMIC_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message htmlwithshortcuts
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'HTML with Shortcuts';

wwv_flow_api.create_message (
  p_id=>93580118576507001 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HTMLWITHSHORTCUTS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message print_server_not_configured
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Report printing is currently not available, there is no print server configured.';

wwv_flow_api.create_message (
  p_id=>95157004818449967 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PRINT SERVER NOT CONFIGURED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message list_templates
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'List Templates';

wwv_flow_api.create_message (
  p_id=>95262601017911818 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'LIST_TEMPLATES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regions_list_template_override
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Regions List Template Override';

wwv_flow_api.create_message (
  p_id=>95263500801921209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIONS_LIST_TEMPLATE_OVERRIDE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message regioin_references
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Region References';

wwv_flow_api.create_message (
  p_id=>95293116741001523 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'REGIOIN_REFERENCES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_max_row_cnt
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'This query returns more than %0 rows, please filter your data to ensure complete results.';

wwv_flow_api.create_message (
  p_id=>95467716029550046 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MAX_ROW_CNT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_doesnot_contain
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'does not contain';

wwv_flow_api.create_message (
  p_id=>95711715731115353 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_DOESNOT_CONTAIN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_is_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'is in the last';

wwv_flow_api.create_message (
  p_id=>95715014261133828 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_IS_IN_LAST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_comparison_isnot_in_last
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'is not in the last';

wwv_flow_api.create_message (
  p_id=>95716705735140886 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPARISON_ISNOT_IN_LAST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_mins
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'minutes';

wwv_flow_api.create_message (
  p_id=>95727122881183611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MINS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_hours
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'hours';

wwv_flow_api.create_message (
  p_id=>95727930500185877 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_HOURS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_days
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'days';

wwv_flow_api.create_message (
  p_id=>95728903619187590 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_DAYS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_weeks
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'weeks';

wwv_flow_api.create_message (
  p_id=>95729808814189019 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_WEEKS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_months
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'months';

wwv_flow_api.create_message (
  p_id=>95730313316190320 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_MONTHS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_time_years
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'years';

wwv_flow_api.create_message (
  p_id=>95730717818191682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_TIME_YEARS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message interactive_report
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Interactive Report';

wwv_flow_api.create_message (
  p_id=>95864124883978910 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INTERACTIVE_REPORT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_and
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'and';

wwv_flow_api.create_message (
  p_id=>96129531770428410 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p33_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Generate Maintenance Application';

wwv_flow_api.create_message (
  p_id=>96713921320187686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P33_BREADCRUMB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_breadcrumb
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Generate Application';

wwv_flow_api.create_message (
  p_id=>96718930895256629 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_BREADCRUMB',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Add Constraint';

wwv_flow_api.create_message (
  p_id=>96747802282607912 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ADD_CONSTRAINT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message create_index
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create Index';

wwv_flow_api.create_message (
  p_id=>96878610610811768 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATE_INDEX',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p49_app_defs
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Defaults';

wwv_flow_api.create_message (
  p_id=>97417719752999856 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P49_APP_DEFS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4500_p24_save_to_worksheet
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Save to Worksheet';

wwv_flow_api.create_message (
  p_id=>98506619730365793 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4500_P24_SAVE_TO_WORKSHEET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_invalid_wksp_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid workspace ID.';

wwv_flow_api.create_message (
  p_id=>98882701388753837 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_INVALID_WKSP_ID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message instadmin_wkspc_not_found
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The workspace was not found.';

wwv_flow_api.create_message (
  p_id=>98891620098834899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'INSTADMIN_WKSPC_NOT_FOUND',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_loading_data
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Loading data...';

wwv_flow_api.create_message (
  p_id=>99425201877114408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.LOADING_DATA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message flash_chart_waiting
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Loading data. Please wait.';

wwv_flow_api.create_message (
  p_id=>99442500417208615 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'FLASH_CHART.WAITING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_check_priv
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User %0 has no privileges on the %1 schema.';

wwv_flow_api.create_message (
  p_id=>100062126437167690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CHECK_PRIV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_plan_table
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'plan table created to facilitate explain plan statement';

wwv_flow_api.create_message (
  p_id=>100072124537204982 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_PLAN_TABLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_error_msg
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error at line %0: %1';

wwv_flow_api.create_message (
  p_id=>100074821205213480 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ERROR_MSG',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_run_sql
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema "%0" does not exist in the database.  Please contact your workspace admin to set correct default schema for you.';

wwv_flow_api.create_message (
  p_id=>100081816619231129 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.RUN_SQL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_insert_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error inserting script to files table.';

wwv_flow_api.create_message (
  p_id=>100086731210263735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.INSERT_SCRIPT_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_parse_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error parsing the script.';

wwv_flow_api.create_message (
  p_id=>100088806885275662 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.PARSE_SCRIPT_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_script_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create script file error.';

wwv_flow_api.create_message (
  p_id=>100091911864286556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_SCRIPT_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_not_implemented
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Not implemented.';

wwv_flow_api.create_message (
  p_id=>100126817077439459 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.NOT_IMPLEMENTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_product_build
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Product Build:';

wwv_flow_api.create_message (
  p_id=>100127609936446841 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.PRODUCT_BUILD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_schema_compatibility
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Schema Compatibility:';

wwv_flow_api.create_message (
  p_id=>100128726212451531 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.SCHEMA_COMPATIBILITY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_last_ddl_time
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Last DDL Time:';

wwv_flow_api.create_message (
  p_id=>100131603749473450 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LAST_DDL_TIME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_host_schema
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Host Schema:';

wwv_flow_api.create_message (
  p_id=>100132516562477137 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.HOST_SCHEMA',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_application_owner
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Application Owner:';

wwv_flow_api.create_message (
  p_id=>100134429029480686 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.APPLICATION_OWNER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_id
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace ID:';

wwv_flow_api.create_message (
  p_id=>100135610113484733 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_ID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_workspace_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace Name:';

wwv_flow_api.create_message (
  p_id=>100136520849487821 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.WORKSPACE_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_user
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current User:';

wwv_flow_api.create_message (
  p_id=>100137907128493307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_USER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_language_preference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Language Preference:';

wwv_flow_api.create_message (
  p_id=>100139015439495682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.LANGUAGE_PREFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_current_time_on_server
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current Time (on server):';

wwv_flow_api.create_message (
  p_id=>100139928252499393 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CURRENT_TIME_ON_SERVER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_add_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Add Memeber Error.';

wwv_flow_api.create_message (
  p_id=>100220809570645402 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.ADD_MEMBER_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_update_member_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Update member error.';

wwv_flow_api.create_message (
  p_id=>100221231734651844 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.UPDATE_MEMBER_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_api_create_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error creating the script.';

wwv_flow_api.create_message (
  p_id=>100222204638662869 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_API.CREATE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in portal_sso_redirect: missing application registration information:';

wwv_flow_api.create_message (
  p_id=>100931501852777682 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_missing_app_reg2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please register this application as described in the installation guide.';

wwv_flow_api.create_message (
  p_id=>100932020206782969 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.MISSING_APP_REG2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_redir_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run portal_sso_redirect procedure as schema: %0 with partner app name: %1.';

wwv_flow_api.create_message (
  p_id=>100932601768796585 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.REDIR_ERR1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err1
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Illegal caller of %0 procedure:';

wwv_flow_api.create_message (
  p_id=>100933316706829275 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR1',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message please_contact_administrator
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Please contact the administrator.';

wwv_flow_api.create_message (
  p_id=>100934031859852611 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PLEASE_CONTACT_ADMINISTRATOR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_process_success_err2
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error determining caller of %0';

wwv_flow_api.create_message (
  p_id=>100934708619893259 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PROCESS_SUCCESS_ERR2',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_invalid_app_session
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid app session in urlc token: %0';

wwv_flow_api.create_message (
  p_id=>100935131176928136 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.INVALID_APP_SESSION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_generic_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in %0';

wwv_flow_api.create_message (
  p_id=>100935527759955492 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO_GENERIC_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_bad_urlc
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Illegal %0 in %1 token returned by sso.';

wwv_flow_api.create_message (
  p_id=>100935918718000178 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.BAD_URLC',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message custom_auth_sso_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run %0 procedure as schema %1 with partner app name %2';

wwv_flow_api.create_message (
  p_id=>100936301880004827 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CUSTOM_AUTH_SSO.PARSE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_render_shortcut_unknown_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error: Unknown shortcut type.';

wwv_flow_api.create_message (
  p_id=>100941205648503960 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_RENDER_SHORTCUT.UNKNOWN_TYPE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_add_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Add Word';

wwv_flow_api.create_message (
  p_id=>100948712453572099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ADD_WORD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_word_added
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Added %0 to your dictionary.';

wwv_flow_api.create_message (
  p_id=>100976710787751452 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.WORD_ADDED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_dup_word_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 already in your dictionary.';

wwv_flow_api.create_message (
  p_id=>100977429964766405 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.DUP_WORD_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Done';

wwv_flow_api.create_message (
  p_id=>100985724480868948 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_DONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cancel';

wwv_flow_api.create_message (
  p_id=>100986114568875507 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_CANCEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_apply_changes
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Apply Changes';

wwv_flow_api.create_message (
  p_id=>100986611928884194 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_APPLY_CHANGES',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_button_add_to_dictionary
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Add To Dictionary';

wwv_flow_api.create_message (
  p_id=>100987012406893825 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.BUTTON_ADD_TO_DICTIONARY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_pick_a_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Pick A Word';

wwv_flow_api.create_message (
  p_id=>100991212106922151 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.PICK_A_WORD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_speling_enter_new_word
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Enter new word.';

wwv_flow_api.create_message (
  p_id=>100995213061941341 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_SPELING.ENTER_NEW_WORD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_tree_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unexpected error %0';

wwv_flow_api.create_message (
  p_id=>100996707398005871 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_TREE.UNEXPECTED_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_window_title
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calculator';

wwv_flow_api.create_message (
  p_id=>101014213426092812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.WINDOW_TITLE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_cancel
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cancel';

wwv_flow_api.create_message (
  p_id=>101017717712103524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.CANCEL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_calculator_done
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Done';

wwv_flow_api.create_message (
  p_id=>101020632257107732 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CALCULATOR.DONE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_no_flow_selected
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No application selected.';

wwv_flow_api.create_message (
  p_id=>101037029374248786 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.NO_FLOW_SELECTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message vertical
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'vertical';

wwv_flow_api.create_message (
  p_id=>101038830329268032 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'VERTICAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message horizontal
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'horizontal';

wwv_flow_api.create_message (
  p_id=>101039603448269690 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'HORIZONTAL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_username
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Username';

wwv_flow_api.create_message (
  p_id=>101073210524432596 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_USERNAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_user_api_t_email
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'E-Mail';

wwv_flow_api.create_message (
  p_id=>101074520567435495 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_USER_API.T_EMAIL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_password
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Password';

wwv_flow_api.create_message (
  p_id=>101075104421440280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PASSWORD',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_privilege
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Privileges';

wwv_flow_api.create_message (
  p_id=>101076509054451106 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_PRIVILEGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_user_api_t_message
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Would have loaded %0 users.';

wwv_flow_api.create_message (
  p_id=>101079002952458838 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_USER_API.T_MESSAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message confirm_menu
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Breadcrumb';

wwv_flow_api.create_message (
  p_id=>101146608951668706 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CONFIRM.MENU',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'error';

wwv_flow_api.create_message (
  p_id=>101346123392240632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_max_rows_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Maximum rows to display must be greater than zero.';

wwv_flow_api.create_message (
  p_id=>101349621923259115 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MAX_ROWS_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_invalid_col_num
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'invalid number of columns defined in query, there are %0 columns required for this region type';

wwv_flow_api.create_message (
  p_id=>101350027810260835 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.INVALID_COL_NUM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Axis max must be greater than axis min.';

wwv_flow_api.create_message (
  p_id=>101350330927261676 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_bar_width_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Bar width must be greater than zero.';

wwv_flow_api.create_message (
  p_id=>101352321707268501 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.BAR_WIDTH_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Axis interval must be greater than zero.';

wwv_flow_api.create_message (
  p_id=>101354615259276070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Axis min must be greater than or equal to zero.';

wwv_flow_api.create_message (
  p_id=>101358009849284018 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Axis max must be greater than zero.';

wwv_flow_api.create_message (
  p_id=>101359617252295603 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message query_invalid_no_select
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'invalid query, no select statement found';

wwv_flow_api.create_message (
  p_id=>101364420500305976 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'QUERY.INVALID_NO_SELECT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_gaps_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Gaps between bars must be greater than or equal to zero.';

wwv_flow_api.create_message (
  p_id=>101374129766327642 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.GAPS_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_min_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Y Axis max must be greater than axis min.';

wwv_flow_api.create_message (
  p_id=>101376400246338026 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_MIN_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: X Axis interval must be greater than zero.';

wwv_flow_api.create_message (
  p_id=>101378023794344805 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_int_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Y Axis interval must be greater than zero.';

wwv_flow_api.create_message (
  p_id=>101383702024366930 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_INT_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: X Axis min must be greater than or equal to zero.';

wwv_flow_api.create_message (
  p_id=>101390321894382120 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_min_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Y Axis min must be greater than or equal to zero.';

wwv_flow_api.create_message (
  p_id=>101398525835392735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MIN_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_x_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: X Axis max must be greater than zero.';

wwv_flow_api.create_message (
  p_id=>101405231507403827 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.X_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_y_axis_max_gt_zero_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Validation Failed: Y Axis max must be greater than zero.';

wwv_flow_api.create_message (
  p_id=>101408925058411368 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.Y_AXIS_MAX_GT_ZERO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_get_color_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to get color: %0';

wwv_flow_api.create_message (
  p_id=>101413001902433070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_GET_COLOR_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_func_ret_sql_qry_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Function returning SQL query: Query cannot be parsed within the Application Builder. %0';

wwv_flow_api.create_message (
  p_id=>101414116924446961 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FUNC_RET_SQL_QRY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_parse_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Parse error: %0 ';

wwv_flow_api.create_message (
  p_id=>101415530561460303 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.PARSE_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_fetch_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Fetch error: %0';

wwv_flow_api.create_message (
  p_id=>101419622035467319 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.FETCH_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_unable_calc_graph_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to calculate graph holder position: %0';

wwv_flow_api.create_message (
  p_id=>101452013686512183 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.UNABLE_CALC_GRAPH_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_svg_chart_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'SVG Chart error: %0';

wwv_flow_api.create_message (
  p_id=>101487929148582948 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.SVG_CHART_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_svg_more_data_fnd_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'More data found, but could not display more than 30 values.';

wwv_flow_api.create_message (
  p_id=>101491025123591251 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SVG.MORE_DATA_FND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_top
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Top';

wwv_flow_api.create_message (
  p_id=>101569303792028866 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_TOP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_bottom
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Bottom';

wwv_flow_api.create_message (
  p_id=>101570118683033179 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_BOTTOM',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_up
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Up';

wwv_flow_api.create_message (
  p_id=>101570627687035778 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_UP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_down
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Down';

wwv_flow_api.create_message (
  p_id=>101571102192037891 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_DOWN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Move';

wwv_flow_api.create_message (
  p_id=>101573222717100578 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_move_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Move All';

wwv_flow_api.create_message (
  p_id=>101573630682102900 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_MOVE_ALL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Remove';

wwv_flow_api.create_message (
  p_id=>101574002070104098 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_remove_all
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Remove All';

wwv_flow_api.create_message (
  p_id=>101574407611105704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_REMOVE_ALL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_shuttle_reset
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Reset';

wwv_flow_api.create_message (
  p_id=>101576614846155070 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.SHUTTLE_RESET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_unable_fnd_userid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find USERID in cookie: %0';

wwv_flow_api.create_message (
  p_id=>101622931927009503 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.UNABLE_FND_USERID_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_exception
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Exception';

wwv_flow_api.create_message (
  p_id=>101624420976015820 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.EXCEPTION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error: %0';

wwv_flow_api.create_message (
  p_id=>101625014527023366 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_asfcookie_invalid_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid ASFCOOKIE please login to your application again.';

wwv_flow_api.create_message (
  p_id=>101640619338072084 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ASFCOOKIE.INVALID_COOKIE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_creating_workspace
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Creating Workspace';

wwv_flow_api.create_message (
  p_id=>101842816264248805 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.CREATING_WORKSPACE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Next';

wwv_flow_api.create_message (
  p_id=>102045308267675215 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_next_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Next Set';

wwv_flow_api.create_message (
  p_id=>102045712769676494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.NEXT_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Previous';

wwv_flow_api.create_message (
  p_id=>102046116578677651 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message pagination_previous_set
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Previous Set';

wwv_flow_api.create_message (
  p_id=>102046721427679006 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'PAGINATION.PREVIOUS_SET',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_security_invalid_user_pass_cookie_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid username or password or expired cookie, please login again.';

wwv_flow_api.create_message (
  p_id=>102638608948350247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SECURITY.INVALID_USER_PASS_COOKIE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_from_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 from query %1';

wwv_flow_api.create_message (
  p_id=>102662624195430307 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FROM_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_in_query
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 in query %1';

wwv_flow_api.create_message (
  p_id=>102663423287439511 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.IN_QUERY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_calendar2_fetch_cal_cursor_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error fetching from calendar cursor: %0';

wwv_flow_api.create_message (
  p_id=>102669424850477770 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_CALENDAR2.FETCH_CAL_CURSOR_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_no_sgid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Security Group ID (your workspace identity) is not set.';

wwv_flow_api.create_message (
  p_id=>102678522126505440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.NO_SGID_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error during execution of wwv_flow_copy: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>102681201479508895 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY.EXECUTION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_button_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error during execution of wwv_flow_copy_button: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>102720203089575632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_BUTTON.EXECUTION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_item_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error during execution of wwv_flow_copy_page_item: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>102730807506595849 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE_ITEM.EXECUTION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_numeric_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'List of Values ID "%0" is not numeric.';

wwv_flow_api.create_message (
  p_id=>102741206383614374 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NUMERIC_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_not_found_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'List of Values ID "%0" not found.';

wwv_flow_api.create_message (
  p_id=>102747529932621210 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.NOT_FOUND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_lov_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error during execution of wwv_flow_copy_lov: %0';

wwv_flow_api.create_message (
  p_id=>102751817942627200 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_LOV.EXECUTION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_util_unable_to_find_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find shortcut (%0) to copy.';

wwv_flow_api.create_message (
  p_id=>102757726862648685 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_UTIL.UNABLE_TO_FIND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4050_ws_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace %0 was created and confirmation email sent to %1 at %2.';

wwv_flow_api.create_message (
  p_id=>102929930842706242 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4050.WS_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message return_to_login_page
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Return to %0 Login Page';

wwv_flow_api.create_message (
  p_id=>103007129381800449 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RETURN_TO_LOGIN_PAGE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4350_disable_work_prov
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Workspace creation has been disabled temporarily.';

wwv_flow_api.create_message (
  p_id=>103022404831297823 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4350.DISABLE.WORK.PROV',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_add_constraint
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Add Constraint %0';

wwv_flow_api.create_message (
  p_id=>103684504081754141 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_ADD_CONSTRAINT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message created_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Created On';

wwv_flow_api.create_message (
  p_id=>103917813250886146 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'CREATED_ON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message updated_on
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Updated On';

wwv_flow_api.create_message (
  p_id=>103918312127904710 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UPDATED_ON',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_order
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Row Order';

wwv_flow_api.create_message (
  p_id=>103919323340917461 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_ORDER',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_as_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'As of %0';

wwv_flow_api.create_message (
  p_id=>103942030470234494 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_AS_OF',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_min_ago
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 minutes ago';

wwv_flow_api.create_message (
  p_id=>103942907530246790 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_MIN_AGO',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_format_mask
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Format Mask';

wwv_flow_api.create_message (
  p_id=>103943829132262564 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_FORMAT_MASK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_computation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Computation';

wwv_flow_api.create_message (
  p_id=>103944510909266740 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_COMPUTATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_choose_download_format
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Choose report download format';

wwv_flow_api.create_message (
  p_id=>103946910047304286 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_CHOOSE_DOWNLOAD_FORMAT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_frm_nav_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to calculate form navigation. %0';

wwv_flow_api.create_message (
  p_id=>103964725088819545 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_FRM_NAV_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_report_view
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'&lt; Report View';

wwv_flow_api.create_message (
  p_id=>103965629374830199 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_REPORT_VIEW',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message apexir_row_of
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Row %0 of %1';

wwv_flow_api.create_message (
  p_id=>103966601932841254 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'APEXIR_ROW_OF',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message ir_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 error. %1';

wwv_flow_api.create_message (
  p_id=>103967323450875850 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'IR_ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_verify_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Verify %0 error: %1';

wwv_flow_api.create_message (
  p_id=>104289218840242539 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.VERIFY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create page): %0 ';

wwv_flow_api.create_message (
  p_id=>104291115639260550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PAGE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_pg_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create page template): %0';

wwv_flow_api.create_message (
  p_id=>104294418325280192 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PG_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create field template): %0';

wwv_flow_api.create_message (
  p_id=>104295411876287788 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_FIELD_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_create_rpt_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create report templates): %0';

wwv_flow_api.create_message (
  p_id=>104296800926294126 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW.CREATE_RPT_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create region templates): %0';

wwv_flow_api.create_message (
  p_id=>104298415948307867 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_REGION_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create list templates): %0';

wwv_flow_api.create_message (
  p_id=>104298917118317743 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_LIST_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create breadcrumb templates): %0';

wwv_flow_api.create_message (
  p_id=>104299324737319899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_MENU_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_popup_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create Popup List of Values Template): %0';

wwv_flow_api.create_message (
  p_id=>104300213093325987 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_POPUP_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_standard_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create standard tabs): %0';

wwv_flow_api.create_message (
  p_id=>104300604567333006 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_STANDARD_TABS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_compute_tab_target_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (compute tab targets): %0';

wwv_flow_api.create_message (
  p_id=>104301726384339352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COMPUTE_TAB_TARGET_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_create_parent_tabs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (create parent tabs): %0';

wwv_flow_api.create_message (
  p_id=>104302811970344626 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.CREATE_PARENT_TABS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_page_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy page template): %0';

wwv_flow_api.create_message (
  p_id=>104304117296355577 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_PAGE_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_field_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy field template): %0';

wwv_flow_api.create_message (
  p_id=>104304806691362045 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_FIELD_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_report_templates_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy report templates): %0 ';

wwv_flow_api.create_message (
  p_id=>104305707168371624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REPORT_TEMPLATES_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_region_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy region templates): %0';

wwv_flow_api.create_message (
  p_id=>104306812625392071 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_REGION_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_list_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy list templates): %0';

wwv_flow_api.create_message (
  p_id=>104307302021398542 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LIST_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_menu_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy breadcrumb templates): %0';

wwv_flow_api.create_message (
  p_id=>104308222106404354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_MENU_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_button_template_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy button templates): %0';

wwv_flow_api.create_message (
  p_id=>104310329164415821 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_BUTTON_TEMPLATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy NavBar): %0';

wwv_flow_api.create_message (
  p_id=>104313027825443863 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_NAVBAR_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy List of Values): %0';

wwv_flow_api.create_message (
  p_id=>104313414104449288 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_LOV_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_security_scheme_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy security scheme): %0';

wwv_flow_api.create_message (
  p_id=>104313801422455099 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_SECURITY_SCHEME_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_crypt_key_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Key must be 8, 16, or 24 bytes.';

wwv_flow_api.create_message (
  p_id=>104322314843477948 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_CRYPT.KEY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_css_api_unable_to_remove_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to remove css: %0';

wwv_flow_api.create_message (
  p_id=>104331413074524751 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CSS_API.UNABLE_TO_REMOVE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_debugtab_biu_fer_invalid_date_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Invalid date format.';

wwv_flow_api.create_message (
  p_id=>104335016799544687 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DEBUGTAB_BIU_FER.INVALID_DATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_dbms_sql_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to bind %0 verify length of item is 30 bytes or less.  Use v() syntax to reference items longer than 30 bytes. %1';

wwv_flow_api.create_message (
  p_id=>104345016369563528 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_DBMS_SQL.UNABLE_TO_BIND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message run_only
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Run Only';

wwv_flow_api.create_message (
  p_id=>104599401770349222 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'RUN_ONLY',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wizapi_delete_checked
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Delete Checked';

wwv_flow_api.create_message (
  p_id=>104784600721973334 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WIZAPI_DELETE_CHECKED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p18_script_olb_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Forms Object Library XML File Name';

wwv_flow_api.create_message (
  p_id=>105949625019874796 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P18_SCRIPT_OLB_NAME',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authorization_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy authorization schemes): %0';

wwv_flow_api.create_message (
  p_id=>106301915301386404 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHORIZATION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_create_flow_api_copy_authentication_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in create application (copy authentication schemes): %0';

wwv_flow_api.create_message (
  p_id=>106302714393395579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CREATE_FLOW_API.COPY_AUTHENTICATION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_cannot_determine_flow_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error, can not determine application given security group id and application alias.';

wwv_flow_api.create_message (
  p_id=>106473329360322863 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.CANNOT_DETERMINE_FLOW_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_convert_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The application alias "%0" can not be converted to a unique application ID.';

wwv_flow_api.create_message (
  p_id=>106475728798332122 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_CONVERT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_alias_exist_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Alias "%0" does not exist.';

wwv_flow_api.create_message (
  p_id=>106476623042339876 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.ALIAS_EXIST_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_unable_home_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to direct you to the home page.';

wwv_flow_api.create_message (
  p_id=>106478118325347989 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UNABLE_HOME_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_update_sub_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in update_substitution_cache: %0';

wwv_flow_api.create_message (
  p_id=>106479002526352937 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW.UPDATE_SUB_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dml_dml_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in DML: p_rowid=%0, p_alt_rowid=%1, p_rowid2=%2, p_alt_rowid2=%3. %4';

wwv_flow_api.create_message (
  p_id=>106485219804405213 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DML.DML_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unable_proc_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to process condition type "%0" in wwv_flow_conditions.';

wwv_flow_api.create_message (
  p_id=>106572910593837829 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNABLE_PROC_COND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_conditions_unexpected_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unexpected error in wwv_flow_conditions.  Function should have returned some value.';

wwv_flow_api.create_message (
  p_id=>106573807954846513 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_CONDITIONS.UNEXPECTED_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_rows_to_process
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'There are no rows to process';

wwv_flow_api.create_message (
  p_id=>106580004715911851 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_ROWS_TO_PROCESS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_owner_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table Owner was not specified';

wwv_flow_api.create_message (
  p_id=>106580518568915814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_OWNER_NOT_SPECIFIED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_table_name_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table Name was not specified';

wwv_flow_api.create_message (
  p_id=>106581428957918814 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.TABLE_NAME_NOT_SPECIFIED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_prim_key_col_not_specified
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Primary key column was not specified';

wwv_flow_api.create_message (
  p_id=>106582623201926606 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.PRIM_KEY_COL_NOT_SPECIFIED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_fcs_missing
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Checksum column ("FCS") is required and was not supplied';

wwv_flow_api.create_message (
  p_id=>106583016405934090 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.FCS_MISSING',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_invalid_prim_key_col
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Primary key column identified was not located in the select list of the query';

wwv_flow_api.create_message (
  p_id=>106583632682938847 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.INVALID_PRIM_KEY_COL',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_prim_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No primary key values were supplied, at least one row must be supplied for updates to occur';

wwv_flow_api.create_message (
  p_id=>106584209264941524 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_PRIM_KEY_VALS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_remove_cal_template_reference
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to subscribe to calendar template. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>106598121568320479 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.REMOVE_CAL_TEMPLATE_REFERENCE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_metadata_publish_cal_template
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to publish calendar template. %0'||chr(10)||
'';

wwv_flow_api.create_message (
  p_id=>106599010402336191 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_METADATA.PUBLISH_CAL_TEMPLATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message autocommit
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Commit statement not applicable.  All statements are automatically committed.';

wwv_flow_api.create_message (
  p_id=>106601517552404527 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'AUTOCOMMIT',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message rollback
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Rollback statement not applicable.  All statements are automatically committed.';

wwv_flow_api.create_message (
  p_id=>106602231058408408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'ROLLBACK',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p254_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Must specify at least one region to create.';

wwv_flow_api.create_message (
  p_id=>106605231530080434 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P254.VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_p295_validation
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Must specify at least one page to create.';

wwv_flow_api.create_message (
  p_id=>106605707420082902 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.P295.VALIDATION',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_sec_key_col_not_in_select_list
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Secondary key column identified was not located in the select list of the query';

wwv_flow_api.create_message (
  p_id=>106611710368121624 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.SEC_KEY_COL_NOT_IN_SELECT_LIST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_no_sec_key_vals
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'No secondary values were supplied for the identified secondary key column';

wwv_flow_api.create_message (
  p_id=>106613731493127723 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.NO_SEC_KEY_VALS',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4000_calendar_column
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Calendar column.';

wwv_flow_api.create_message (
  p_id=>106621422382604572 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4000.CALENDAR_COLUMN',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_menu_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Menu';

wwv_flow_api.create_message (
  p_id=>106629506580605290 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_MENU_FILE_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_error_in_mru
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in MRU: row= %0, %1, %2';

wwv_flow_api.create_message (
  p_id=>106636411725245052 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.ERROR_IN_MRU',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message mru_lost_update
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Current version of data in database has changed since user initiated update process. current checksum = "%0", item checksum = "%1".';

wwv_flow_api.create_message (
  p_id=>106637514973255379 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'MRU.LOST_UPDATE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_job_unauthorized_attempt_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unauthorized attempt to run job %0 by schema: %1 in application: %2';

wwv_flow_api.create_message (
  p_id=>106662023752541784 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_JOB.UNAUTHORIZED_ATTEMPT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_bg_select_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Popup List of Values must begin with "select".';

wwv_flow_api.create_message (
  p_id=>106663409254565988 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_BG_SELECT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error initializing PopUp List of Values: %0 %1';

wwv_flow_api.create_message (
  p_id=>106663913541576724 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_INIT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_popup_filter_init_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error initializing PopUp List of Values with filter: %0 %1';

wwv_flow_api.create_message (
  p_id=>106665108131584627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.POPUP_FILTER_INIT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_utilities_generate_popup_lov_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error generating Popup List of Values: %0 %1';

wwv_flow_api.create_message (
  p_id=>106665920036597526 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_UTILITIES.GENERATE_POPUP_LOV_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item %0 of type combobox has no query.';

wwv_flow_api.create_message (
  p_id=>106669229087628549 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_NO_QUERY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_js_no_query_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item %0 of type combobox w/js redirect has no query.';

wwv_flow_api.create_message (
  p_id=>106669701644639561 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_JS_NO_QUERY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item %0 of type combobox w/URL redirect has no query.';

wwv_flow_api.create_message (
  p_id=>106670508009650783 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_forms_combo_url_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Item %0 of type combobox w/URL redirect to page has no query.';

wwv_flow_api.create_message (
  p_id=>106671132250657812 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FORMS.COMBO_URL_PAGE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generate_table_api_package_invalid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error, package name: %0 is invalid or already taken.';

wwv_flow_api.create_message (
  p_id=>106677607896792738 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERATE_TABLE_API.PACKAGE_INVALID_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p108_prog_file_type
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Program Unit';

wwv_flow_api.create_message (
  p_id=>106679425515752677 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P108_PROG_FILE_TYPE',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_generic_attr_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'error';

wwv_flow_api.create_message (
  p_id=>106696921767948087 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_GENERIC_ATTR.ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p18_script_olb_name
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Object Library XML File Name';

wwv_flow_api.create_message (
  p_id=>106699927667358759 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P18_SCRIPT_OLB_NAME',
  p_message_language=>'en-ie',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message f4400_p52_olb_content_invalid
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'The file you attempted to upload to your Forms migration project is not a valid Object Library (_olb.XML) file. Only Object Library XML files, generated by the Form2XML Conversion tool included with Oracle Forms can be uploaded.';

wwv_flow_api.create_message (
  p_id=>106700319271375219 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'F4400_P52_OLB_CONTENT_INVALID',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_region_layout_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error';

wwv_flow_api.create_message (
  p_id=>106705105584000209 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_REGION_LAYOUT.ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_navbar_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to update NavBar display condition type. %0';

wwv_flow_api.create_message (
  p_id=>106710220522032908 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_NAVBAR_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to update Application process when condition type. %0';

wwv_flow_api.create_message (
  p_id=>106710628141035073 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_PROC_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_flow_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to update Application computation type. %0';

wwv_flow_api.create_message (
  p_id=>106711220307042281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_FLOW_COMP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_subtitle_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to update page sub title type. %0';

wwv_flow_api.create_message (
  p_id=>106711914204049966 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_SUBTITLE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_button_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to update page button condition type. %0';

wwv_flow_api.create_message (
  p_id=>106712800483055560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_BUTTON_COND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_branch_cond_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to update page branching condition type. %0';

wwv_flow_api.create_message (
  p_id=>106714026456063029 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.BRANCH_COND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to update page comutation type. %0';

wwv_flow_api.create_message (
  p_id=>106716319661070525 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_COMP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_valid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to update page validation type. %0';

wwv_flow_api.create_message (
  p_id=>106720714944078592 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_VALID_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_page_proc_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to update page process type. %0';

wwv_flow_api.create_message (
  p_id=>106722602954084627 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_PAGE_PROC_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_migrate_metadata_update_misspell_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error during updating misspelled words. %0';

wwv_flow_api.create_message (
  p_id=>106725327542091699 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_MIGRATE_METADATA.UPDATE_MISSPELL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_disp_page_plugs_unable_to_bind_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to bind %0 verify length of item is 30 bytes or less.  Use v() syntax to reference items longer than 30 bytes. %1';

wwv_flow_api.create_message (
  p_id=>106747002318188466 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DISP_PAGE_PLUGS.UNABLE_TO_BIND_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_convert_id_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1711 Cannot convert popup lov id in request.';

wwv_flow_api.create_message (
  p_id=>106758900286216270 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.CONVERT_ID_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_popup_lov_find_item_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'ERR-1721 Cannot find item for popup lov id in request.';

wwv_flow_api.create_message (
  p_id=>106761314831220551 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_POPUP_LOV.FIND_ITEM_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in drop_tablespace p_name is null.';

wwv_flow_api.create_message (
  p_id=>106766112669238825 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_TABLESPACE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to drop tablespace. Error: %0 \nsql:\n %1';

wwv_flow_api.create_message (
  p_id=>106767414185248762 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_TABLESPACE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in drop_user no l_username.';

wwv_flow_api.create_message (
  p_id=>106768713624258040 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.DROP_USER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_drop_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to drop user. Error: %0 \nsql:\n %1';

wwv_flow_api.create_message (
  p_id=>106770608907266105 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_DROP_USER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_with_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error with: %0 %1';

wwv_flow_api.create_message (
  p_id=>106773204189274258 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.WITH_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create user. %0';

wwv_flow_api.create_message (
  p_id=>106776809515285171 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_USER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_create_tablespace_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create tablespace. %0';

wwv_flow_api.create_message (
  p_id=>106778802374292650 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_CREATE_TABLESPACE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_unable_grant_privs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to grant initial privs. %0';

wwv_flow_api.create_message (
  p_id=>106780225230299229 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.UNABLE_GRANT_PRIVS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provision_remove_company_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in remove_provisioned_company.  Workspace is null.';

wwv_flow_api.create_message (
  p_id=>106782313240305247 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISION.REMOVE_COMPANY_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table created.';

wwv_flow_api.create_message (
  p_id=>106791111424323632 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View created.';

wwv_flow_api.create_message (
  p_id=>106792521813326608 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_provisioning_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'error';

wwv_flow_api.create_message (
  p_id=>106793629086328694 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PROVISIONING.ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trigger created.';

wwv_flow_api.create_message (
  p_id=>106794231510329380 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Function created.';

wwv_flow_api.create_message (
  p_id=>106797912248333364 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Procedure created.';

wwv_flow_api.create_message (
  p_id=>106798425754337256 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_body_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package Body created.';

wwv_flow_api.create_message (
  p_id=>106799603375340168 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_BODY_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package created.';

wwv_flow_api.create_message (
  p_id=>106801613764343233 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Index created.';

wwv_flow_api.create_message (
  p_id=>106802822422345735 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type created.';

wwv_flow_api.create_message (
  p_id=>106817906370407280 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User created.';

wwv_flow_api.create_message (
  p_id=>106818715374409866 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Materialized View created.';

wwv_flow_api.create_message (
  p_id=>106819628534413737 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Role created.';

wwv_flow_api.create_message (
  p_id=>106820106501416775 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence created.';

wwv_flow_api.create_message (
  p_id=>106821217583419980 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Synonym created.';

wwv_flow_api.create_message (
  p_id=>106822200052424385 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_cmd_executed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Command executed.';

wwv_flow_api.create_message (
  p_id=>106823308710426924 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CMD_EXECUTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_table_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table creation failed due to invalid SQL syntax.';

wwv_flow_api.create_message (
  p_id=>106826208841436408 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.TABLE_CREATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_updated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 row(s) updated.';

wwv_flow_api.create_message (
  p_id=>106827309533436646 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_UPDATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_inserted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 row(s) inserted.';

wwv_flow_api.create_message (
  p_id=>106847401699443786 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_INSERTED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_sw_util_package_create_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package creation failed due to invalid SQL syntax.';

wwv_flow_api.create_message (
  p_id=>106848007587445550 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SW_UTIL.PACKAGE_CREATE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_rows_deleted
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'%0 row(s) deleted.';

wwv_flow_api.create_message (
  p_id=>106849420400449196 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROWS_DELETED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_templates_util_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error';

wwv_flow_api.create_message (
  p_id=>106853503347463238 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TEMPLATES_UTIL.ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_fetch_fnd_user_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cannot fetch fnd user information. %0';

wwv_flow_api.create_message (
  p_id=>106860014691485444 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.FETCH_FND_USER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_admin_api_delete_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in delete developer role. %0';

wwv_flow_api.create_message (
  p_id=>106862507549492782 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_ADMIN_API.DELETE_DEV_ROLE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_user_no_priv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User %0 has no privs on the %1 schema.';

wwv_flow_api.create_message (
  p_id=>106871007119511647 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.USER_NO_PRIV_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_builder_updatable_report_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Updatable report parse error: %0';

wwv_flow_api.create_message (
  p_id=>106874705864520757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_BUILDER.UPDATABLE_REPORT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table dropped.';

wwv_flow_api.create_message (
  p_id=>106875414868523321 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_pkg_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package dropped.';

wwv_flow_api.create_message (
  p_id=>106876711536531786 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PKG_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User dropped.';

wwv_flow_api.create_message (
  p_id=>106878301624538383 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View dropped.';

wwv_flow_api.create_message (
  p_id=>106879122403544397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_copy_page_execution_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error during execution of wwv_flow_copy_page: %0 >> %1';

wwv_flow_api.create_message (
  p_id=>106879422749544543 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_COPY_PAGE.EXECUTION_PAGE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence dropped.';

wwv_flow_api.create_message (
  p_id=>106882123357563656 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table altered.';

wwv_flow_api.create_message (
  p_id=>106884904573577121 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_dataload_xml_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'error';

wwv_flow_api.create_message (
  p_id=>106885600202585281 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_DATALOAD_XML.ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Function dropped.';

wwv_flow_api.create_message (
  p_id=>106886021111600850 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Procedure dropped.';

wwv_flow_api.create_message (
  p_id=>106886610853607333 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_credentials_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unauthorized access (wwv_flow_api.set_credentials not set).';

wwv_flow_api.create_message (
  p_id=>106887803365614605 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.CREDENTIALS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_fnd_developer_api_dev_role_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error in delete developer role. %0';

wwv_flow_api.create_message (
  p_id=>106888230377622376 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_FND_DEVELOPER_API.DEV_ROLE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_index_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Index dropped.';

wwv_flow_api.create_message (
  p_id=>106888607306625184 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEX_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_materialized_view_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Materialized view dropped.';

wwv_flow_api.create_message (
  p_id=>106889710553635620 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.MATERIALIZED_VIEW_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_role_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Role dropped.';

wwv_flow_api.create_message (
  p_id=>106890501681642493 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.ROLE_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_synonym_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Synonym dropped.';

wwv_flow_api.create_message (
  p_id=>106891027307649917 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SYNONYM_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trigger dropped.';

wwv_flow_api.create_message (
  p_id=>106891518088656701 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type dropped.';

wwv_flow_api.create_message (
  p_id=>106891906098662727 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_indextype_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Indextype dropped.';

wwv_flow_api.create_message (
  p_id=>106931824630056043 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEXTYPE_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_context_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Context dropped.';

wwv_flow_api.create_message (
  p_id=>106933000650068016 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CONTEXT_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_database_link_dropped
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Database Link dropped.';

wwv_flow_api.create_message (
  p_id=>106934611171080552 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.DATABASE_LINK_DROPPED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_database_link_created
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Database Link created.';

wwv_flow_api.create_message (
  p_id=>106935100912086996 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.DATABASE_LINK_CREATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_renamed
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table renamed.';

wwv_flow_api.create_message (
  p_id=>106942106285126378 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_RENAMED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_view_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'View altered.';

wwv_flow_api.create_message (
  p_id=>106945106547145440 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.VIEW_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_type_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Type altered.';

wwv_flow_api.create_message (
  p_id=>106946631481152574 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TYPE_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_trigger_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Trigger altered.';

wwv_flow_api.create_message (
  p_id=>106947623993159916 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TRIGGER_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_indextype_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Indextype altered.';

wwv_flow_api.create_message (
  p_id=>106949613389166339 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.INDEXTYPE_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_table_truncated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Table truncated.';

wwv_flow_api.create_message (
  p_id=>106955431528181002 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.TABLE_TRUNCATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_cluster_truncated
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cluster truncated.';

wwv_flow_api.create_message (
  p_id=>106957922308187858 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.CLUSTER_TRUNCATED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_package_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Package altered.';

wwv_flow_api.create_message (
  p_id=>106958522917206873 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PACKAGE_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_function_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Function altered.';

wwv_flow_api.create_message (
  p_id=>106958912312213332 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.FUNCTION_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_procedure_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Procedure altered.';

wwv_flow_api.create_message (
  p_id=>106959631705218905 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.PROCEDURE_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_seq_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Sequence altered.';

wwv_flow_api.create_message (
  p_id=>106969721447225397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.SEQ_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message success_msg_user_altered
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User altered.';

wwv_flow_api.create_message (
  p_id=>106991624133245123 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'SUCCESS_MSG.USER_ALTERED',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message test
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Test';

wwv_flow_api.create_message (
  p_id=>107008913948125109 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'TEST',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message up
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Up';

wwv_flow_api.create_message (
  p_id=>107170227381540993 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'UP',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_query_heading_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error getting query headings: %0';

wwv_flow_api.create_message (
  p_id=>107297908494854187 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.QUERY_HEADING_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_render_report3_column_value_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Error fetching column value: %0';

wwv_flow_api.create_message (
  p_id=>107303508278863661 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_RENDER_REPORT3.COLUMN_VALUE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_hint_remove_table_hint_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'remove_table_hint was called without a p_table_id, a table must be provided.';

wwv_flow_api.create_message (
  p_id=>107322625556915884 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HINT.REMOVE_TABLE_HINT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_hint_create_normalize_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Create normalize error: %0';

wwv_flow_api.create_message (
  p_id=>107323210450921064 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_HINT.CREATE_NORMALIZE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'error';

wwv_flow_api.create_message (
  p_id=>107326116384951156 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_find_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find file: %0';

wwv_flow_api.create_message (
  p_id=>107328501886975362 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.FIND_FILE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_find_data_type_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Find data type error: %0';

wwv_flow_api.create_message (
  p_id=>107330909813024913 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.FIND_DATA_TYPE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_get_max_col_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Get max col length error1: %0';

wwv_flow_api.create_message (
  p_id=>107332006828033556 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.GET_MAX_COL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_get_datatype_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Get data type error: %0';

wwv_flow_api.create_message (
  p_id=>107333105920042757 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.GET_DATATYPE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_collection_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to create collection: %0';

wwv_flow_api.create_message (
  p_id=>107333513454063842 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.COLLECTION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_data_load_csv_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Load csv data error:';

wwv_flow_api.create_message (
  p_id=>107333910815072560 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_DATA.LOAD_CSV_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_excel_data_run_ddl_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Excel load run ddl error: %0 %1';

wwv_flow_api.create_message (
  p_id=>107334430601106575 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_EXCEL_DATA.RUN_DDL_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_excel_data_table_info_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to get table info. l_line=%0 %1';

wwv_flow_api.create_message (
  p_id=>107343821559151292 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_EXCEL_DATA.TABLE_INFO_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_load_excel_data_load_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Load excel data error: %0';

wwv_flow_api.create_message (
  p_id=>107348411779167448 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOAD_EXCEL_DATA.LOAD_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_lookup_tables_privs_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'User %0 has no privs on the %1 schema.';

wwv_flow_api.create_message (
  p_id=>107358010141223704 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_LOOKUP_TABLES.PRIVS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_find_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to find the file. %0';

wwv_flow_api.create_message (
  p_id=>107367429721342899 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.FIND_FILE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_unable_get_code_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to get the block of code: %0';

wwv_flow_api.create_message (
  p_id=>107368025003350980 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.UNABLE_GET_CODE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_get_statement_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to get statement: %0';

wwv_flow_api.create_message (
  p_id=>107377214624423711 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.GET_STATEMENT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_save_parameter_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to save the parameter to the database: %0';

wwv_flow_api.create_message (
  p_id=>107378502634429754 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.SAVE_PARAMETER_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_validate_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to validate the file "%0". %1';

wwv_flow_api.create_message (
  p_id=>107390732416438329 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.VALIDATE_FILE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_check_code_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to check whether the code has be parsed or not: %0';

wwv_flow_api.create_message (
  p_id=>107391924928445579 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.CHECK_CODE_PARSE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_control_file_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run the control file: %0';

wwv_flow_api.create_message (
  p_id=>107393206359449691 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.CONTROL_FILE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_run_code_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run the code: %0';

wwv_flow_api.create_message (
  p_id=>107396112031460795 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.RUN_CODE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_bulk_collect_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to bulk collect: %0';

wwv_flow_api.create_message (
  p_id=>107407902428514824 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.BULK_COLLECT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_run_statement_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to run the statement: %0';

wwv_flow_api.create_message (
  p_id=>107410823206520832 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.RUN_STATEMENT_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_package_comp_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Warning: Package Body created with compilation errors.';

wwv_flow_api.create_message (
  p_id=>107412318835529021 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.PACKAGE_COMP_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_execution_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Execution of the statement was unsuccessful: %0';

wwv_flow_api.create_message (
  p_id=>107413207885535352 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.EXECUTION_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_delete_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to delete parsed information: %0';

wwv_flow_api.create_message (
  p_id=>107413624507540116 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.DELETE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_control_file_stats_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to check control file statistics: %0';

wwv_flow_api.create_message (
  p_id=>107415328232560134 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER.CONTROL_FILE_STATS_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_parser_public_parse_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Unable to parse the file. %0';

wwv_flow_api.create_message (
  p_id=>107416714857565750 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_PARSER_PUBLIC.PARSE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_series_attr_error
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'error';

wwv_flow_api.create_message (
  p_id=>107430923393634397 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_SERIES_ATTR.ERROR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_sgid_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Security group id must be set.';

wwv_flow_api.create_message (
  p_id=>107441117207660999 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.SGID_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_old_tabset_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cant find old tabset for tab id = %0.';

wwv_flow_api.create_message (
  p_id=>107443912836669180 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.OLD_TABSET_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_new_tabset_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Cant find new tabset for parent tab id = %0.';

wwv_flow_api.create_message (
  p_id=>107445725995673000 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.NEW_TABSET_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_page_err
declare
  h varchar2(32767) := null;
 
begin
 
h:=h||'Page id: %0 is not a number.';

wwv_flow_api.create_message (
  p_id=>107447311581678354 + wwv_flow_api.g_id_offset,
  p_flow_id=>wwv_flow.g_flow_id,
  p_name=>'WWV_FLOW_TAB_MGR.PAGE_ERR',
  p_message_language=>'en-us',
  p_message_text=>h);
null;
 
end;
/

prompt  ......Message wwv_flow_tab_mgr_spec_new_tabset_err
declare
  h varchar2(3276