#!%s_javapOracleHome%/perl/bin/perl
# 
# $Header: targetdeploy.pl.template 31-oct-2007.03:09:16 ssanklec Exp $
#
# targetdeploy.pl.template
# 
# Copyright (c) 2002, 2004, Oracle. All rights reserved.  
#
#    NAME
#      targetdeploy.pl - deploys targets.xml into different state directories
#
#    DESCRIPTION
#      <short description of component this file declares/defines>
#
#    NOTES
#      <other useful comments, qualifications, etc.>
#
#    MODIFIED   (MM/DD/YY)
#    ssanklec    10/31/07 - bug 6597564
#    ssanklec    03/28/07 - HANDLING USER DEFINED TARGET NAMES DURING UPGRADE
#    rahgupta    09/09/04 - remove 102sa build break workaround 
#    rahgupta    09/02/04 - This is temporary workaround, will be removed when 
#                           txn merged in 10.1.0.4 is available 10.2SA 
#    rahgupta    08/25/04 - Change ORACLE_HOME marker to s_javapOracleHome 
#    clo         11/03/03 - Bug #3231639
#    clo         09/16/03 - clo_emcp_build_files 
#    clo         09/15/03 - Transfer to EM view; extend argument list
#    mwidjaja    05/08/03 - mwidjaja_emrac_cfg_tool_update
#    mwidjaja    05/07/03 - Creation
#

use File::Copy;
use Getopt::Std;

$ORACLE_HOME="%s_javapOracleHome%";

die "ORACLE_HOME var not set.\n" if( $ORACLE_HOME eq "") ;

$EMDROOT = $ORACLE_HOME;

if ($#ARGV < 2) {
    print STDERR <<USAGE;

Usage: targetdeploy.pl [-l <listener>] [-t <listener target>] [-v <VIP>] [-s <asm-sid> -o <asm-oracle-home>] <deploy-dir> <hostname> <sid>
      
       -l <listener>: listener name
       -t <listener target>: listener target name
       -v <VIP>: virtual IP
       -s <asm-sid> : SID for the ASM instance
       -o <asm-oracle-home> : ASM ORACLE_HOME
       -r <user defined name for rac_database>: user-defined-name for rac_database
       -d <user defined name for oracle_database>: user-defined-name for oracle_database
       -n <user defined name for oracle_listener>: user-defined-name for oracle_listener
       -a <user defined name for osm_instance>: user-defined-name for osm_instance
       <deploy-dir> : Directory to create a state-only agent installation
       <hostname> : Hostname where targets.xml needs to be deployed
       <sid> : SID for the rac_database


USAGE
    exit;
}

sub  put_custom_targetName($$;$)
{
my($targetdata,$target_name, $pattern) = @_;
my @putname_var1=();
my @putname_var2=();
my $changed_name = "";
chomp($targetdata);
chomp($target_name);
chomp($pattern);

if ($targetdata =~ /DELETED/)
{ 
  return $targetdata;
}

if ( $pattern =~ /ASSOC_TARGET_TYPE="oracle_database"/)
{
  @putname_var1 = split('ASSOC_TARGET_NAME="',$targetdata);
  @putname_var2 = split('" ',$putname_var1[1]);
  $changed_name= '    '.$putname_var1[0].'ASSOC_TARGET_NAME="'.$target_name.'" ';
}
else{
     if ( $pattern =~ /MemberOf TYPE="rac_database"/)
     {
       @putname_var1 = split('NAME="',$targetdata);
       @putname_var2 = split('" ',$putname_var1[1]);
       $changed_name= '    '.$putname_var1[0].'NAME="'.$target_name.'" ';
      }
      else
      {
        @putname_var1 = split('NAME="',$targetdata);
        @putname_var2 = split('"',$putname_var1[1]);
        $changed_name= '    '.$putname_var1[0].'NAME="'.$target_name.'" ';
      }
    }


for ($i = 1; $i < @putname_var2; $i++) 
{
  $changed_name = $changed_name.$putname_var2[$i];
}
chomp($changed_name);
return($changed_name);
}

#customRACDB:r
#customDB:d
#customOsm:a
#customLsnr:n

getopts('l:t:s:o:v:r:d:n:a:') or die "Aborted\n";

$EMHOME=$ARGV[0];
$HOST=$ARGV[1];
$SID=$ARGV[2];

if(defined($opt_l))
{
  $LISTENER=$opt_l;
}
if(defined($opt_v))
{
  $VIP=$opt_v;
}
if(defined($opt_s))
{
  $ASMSID=$opt_s;
}
if(defined($opt_o))
{
  $ASMOH=$opt_o;
}
if(defined($opt_t))
{
  $TARGET=$opt_t;
}
if(defined($opt_r))
{
  $CUSTOMRACDB=$opt_r;
}
if(defined($opt_d))
{
  $CUSTOMDB=$opt_d;
}
if(defined($opt_a))
{
  $CUSTOMOSM=$opt_a;
}
if(defined($opt_n))
{
  $CUSTOMLSNR=$opt_n;
}



print "Creating targets.xml in state directories...\n";
print "Source location: $EMDROOT\n";
print "Destination : $EMHOME\n\n";

# Create directory structure
# EMHOME = EMDROOT/nodex
#  |
#  `-------sysman
#          |
#          `-------emd
#                  |
#                  `-------targets.xml

print "Creating directories...\n";
-e "$EMHOME" or mkdir "$EMHOME" or die "Unable to create $EMHOME: $!\n";
-e "$EMHOME/sysman" or mkdir "$EMHOME/sysman" or die "Unable to create $EMHOME/sysman: $!\n";
-e "$EMHOME/sysman/emd" or mkdir "$EMHOME/sysman/emd" or die "Unable to create $EMHOME/sysman/emd: $!\n";

#
# Targets.xml original file under $EMDROOT/sysman/emd/
#
print "Creating targets.xml...\n";
open ORIGTARGET,"<$EMDROOT/sysman/emd/targets.xml" or die "Unable to open $EMDROOT/sysman/emd/targets/xml\n";
open TARGETSXML,">$EMHOME/sysman/emd/targets.xml" or die "Unable to create $EMHOME/sysman/emd/targets.xml\n";

while (my $targetdata = <ORIGTARGET> )
{
   if (defined($opt_r))
   {
      $target_pattern='Target TYPE="rac_database"';
      if($targetdata=~ /$target_pattern/)
      {
        my $changed = put_custom_targetName($targetdata,$CUSTOMRACDB);
        $targetdata = $changed ;
      }
      $target_pattern='MemberOf TYPE="rac_database"';
      if($targetdata=~ /$target_pattern/)
      {
        my $changed = put_custom_targetName($targetdata,$CUSTOMRACDB, $target_pattern);
        $targetdata = $changed ;
      }
   }

   if (defined($opt_d))
   {
      $target_pattern='Target TYPE="oracle_database"';
      if($targetdata=~ /$target_pattern/)
      {
        my $changed = put_custom_targetName($targetdata,$CUSTOMDB);
        $targetdata = $changed ;
      }
      $target_pattern='ASSOC_TARGET_TYPE="oracle_database"';
      if($targetdata=~ /$target_pattern/)
      {
        my $changed = put_custom_targetName($targetdata,$CUSTOMDB, $target_pattern);
        $targetdata = $changed ;
      }
   }

   if (defined($opt_n))
   {
      $target_pattern='Target TYPE="oracle_listener"';
      if($targetdata=~ /$target_pattern/)
      {
        my $changed = put_custom_targetName($targetdata,$CUSTOMLSNR);
        $targetdata = $changed ;
      }
   }

   if (defined($opt_a))
   {
      $target_pattern='Target TYPE="osm_instance"';
      if($targetdata=~ /$target_pattern/)
      {
        my $changed = put_custom_targetName($targetdata,$CUSTOMOSM);
        $targetdata = $changed ;
      }
   }


   $targetdata =~ s/%HOSTNAME%/$HOST/g;
   $targetdata =~ s/%EM_REPOS_SID%/$SID/g;


   if(defined($opt_l))
   {
     $targetdata =~ s/%LISTENER%/$LISTENER/g;
   }
   if(defined($opt_v))
   {
     $targetdata =~ s/%VIP%/$VIP/g;
   }
   if(defined($opt_s))
   {
     $targetdata =~ s/%ASM_SID%/$ASMSID/g;
   }
   if(defined($opt_o))
   {
     $targetdata =~ s/%ORACLEHOME%/$ASMOH/g;
   }
   if(defined($opt_t))
   {
     $targetdata =~ s/%LISTENER_TARGET%/$TARGET/g;
   }

   chomp($targetdata);
   print TARGETSXML ("$targetdata\n");
}

print "Done.\n"; # copying targets.xml end
