@echo off
REM ###########################################################################
REM #
REM # Copyright (c) 2001, 2003, Oracle Corporation.  All rights reserved.
REM #
REM # PRODUCT
REM #       Oracle Enterprise Manager, Version 4.0.1
REM #
REM # FILENAME
REM #       RepManager
REM #
REM # DESCRIPTION
REM #       This script is used to manage the EMD repository and environment.
REM #       Enterprise Manager, Version 4.0.1
REM # MODIFIED
REM #    gsbhatia   01/18/06 - Bug 4889196 
REM #    ktlaw      11/30/04 - add OH/sysman/install to PERL5LIB 
REM #    ktlaw      10/22/04 - add emdrep/bin to PERL5LIB 
REM #    njagathe   08/24/04 - Remove references to win arch 
REM #    njagathe   08/16/04 - Fix hardcoded 561 refs 
REM #    rdabbott   07/08/04 - put links to oh 
REM #    rdabbott   06/28/04 - core only create 
REM #    gan        04/29/04 - add OH bin to path 
REM #    vnukal     04/17/03 - vnukal_fix-sure-db-2_mainsa
REM #    vnukal     04/09/03 - Created
REM ###########################################################################
REM #
setlocal

if not defined ORACLE_HOME (
   echo ORACLE_HOME environment variable should be set to create EM repository...
   goto :EOF
)

REM look in OH in both a view and an install
set EMDW_HOME=%ORACLE_HOME%

REM # source commonenv to set common variables
call %EMDW_HOME%\bin\commonenv

set PERL5LIB=%ORACLE_HOME%\%EMPERLOHBIN%;%ORACLE_HOME%\perl\lib;%ORACLE_HOME%\perl\lib\site_perl;%ORACLE_HOME%\perl\site\lib;%ORACLE_HOME%\sysman\admin\emdrep\bin;%ORACLE_HOME%\sysman\install;%PERL5LIB%

set PATH=%ORACLE_HOME%\%EMPERLOHBIN%;%ORACLE_HOME%\bin;%PATH%

perl %EMDW_HOME%\sysman\admin\emdrep\bin\emrepmgr.pl %*

endlocal

REM Windows batch files need to use "exit" for the caller program to reap 
REM the exit code. Otherwise the caller always gets '0' as the exit code.
REM When invoked from command-line exit forces the cmd window to close.
REM Protecting it with a variable defintion
if defined NEED_EXIT_CODE exit %errorlevel%


