Rem Copyright (c) 1998, 2008, Oracle. All rights reserved.  
REM
REM This script installs Oracle Multimedia
REM
REM You must connect as SYSDBA prior to running this script
REM You must run ordinst.sql prior to running this script
REM

REM 
REM Oracle Multimedia depends on JAVAVM functionality for metadata extraction
REM and image processing.  Make sure JAVAVM is installed.
REM 

WHENEVER SQLERROR EXIT;
begin
  IF (dbms_registry.version('JAVAVM') is null) THEN 
    raise_application_error(-20000, 'JServer JAVA Virtual Machine component not found. '||
        'JServer JAVA Virtual Machine must be installed prior to Oracle Multimedia installation.');
  END IF;
end;
/

REM 
REM Oracle Multimedia depends on XDB functionality for DICOM medical 
REM imaging.  Make sure XDB is installed.
REM 

begin
  IF (dbms_registry.version('XDB') is null) THEN 
    raise_application_error(-20000, 'Oracle XML Database component not found. '||
        'Oracle XML Database must be installed prior to Oracle Multimedia installation.');
  END IF;
end;
/

REM 
REM Oracle Multimedia depends on XDK functionality for Audio/Video.
REM Make sure XDK is installed.
REM 

begin
  IF (dbms_registry.version('XML') is null) THEN 
    raise_application_error(-20000, 'Oracle XDK component not found. '||
        'Oracle XDK must be installed prior to Oracle Multimedia installation.');
  END IF;
end;
/

REM 
REM Make sure Oracle Multimedia schemas exist.
REM 

@@imchksch.sql

WHENEVER SQLERROR CONTINUE;

REM Install Media related objects
@@immedins.sql

REM Install and Check Location objects 

COLUMN :script_name NEW_VALUE comp_file NOPRINT
Variable script_name varchar2(50)

declare
  mdsyscnt NUMBER := 0;
begin
  :script_name := dbms_registry.nothing_script;
  -- Check whether MDSYS exists.
  select count(*) into mdsyscnt from dba_users where username='MDSYS';
  if ((dbms_registry.is_valid('SDO') is NULL) and (MDSYSCNT > 0)) then
      -- If SDO is not installed and MDSYS exists, install Locator
      EXECUTE IMMEDIATE 'alter session set current_schema="MDSYS"';
      :script_name := '@imimdloc.sql';
      dbms_registry.loading
        ('ORDIM', 'Oracle Multimedia', 
         'validate_ordim', 'ORDSYS', 
         dbms_registry.schema_list_t('ORDPLUGINS','SI_INFORMTN_SCHEMA',
                                     'MDSYS', 'ORDDATA'));
  end if;
end;
/

select :script_name from dual;
@&comp_file

alter session set current_schema="SYS";

REM Install Oracle Multimedia verification procedure
REM and validate Oracle Multimedia Installation 
@@imvalid.sql

