Rem
Rem imchk.sql
Rem
Rem Copyright (c) 1998, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      imchk.sql - Multimedia CHecK script
Rem
Rem    DESCRIPTION
Rem      This script checks the installation of Multimedia
Rem      components and prints status of the components.
Rem
Rem    NOTES
Rem      Before running this script user must be connected as 
Rem      SYSDBA.
Rem     

REM This script tests the Multimedia components installation

-- tests the Multimedia components installation
set serveroutput on;
EXECUTE SYS.validate_ordim();

declare
  l_flag integer := 1;
BEGIN
  IF dbms_registry.is_valid('ORDIM') = 1
  THEN
    dbms_output.put_line('Multimedia installation is valid');
  ELSE
    dbms_output.put_line('Multimedia installation is invalid');
    
    -- If there are invalid objects, print out the complete list.
    FOR ob IN (SELECT o.name, o.status, o.type# FROM sys.obj$ o, sys.user$ u
          WHERE o.status > 1 
            AND (u.name = 'ORDSYS' 
              OR u.name = 'ORDPLUGINS' 
              OR u.name = 'SI_INFORMTN_SCHEMA'
              OR u.name = 'ORDDATA' )
            AND u.user# = o.owner# ) LOOP
        if (l_flag = 1) then
          dbms_output.put_line ('The following is a complete list of ORDIM invalid objects:');
          l_flag := 0;
        end if; 
        dbms_output.put_line ('Object name: ' || ob.name || ', status: ' || ob.status 
          || ', type: ' || ob.type#);
     END LOOP;

  END IF;
END;
/

REM Addition checking using JAVA script
@@imchkjav
