Rem
Rem $Header: imchkjav.sql 17-jan-2008.17:09:53 rabbott Exp $
Rem
Rem imchkjav.sql
Rem
Rem Copyright (c) 2007, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      imchkjav.sql - Multimedia CHecK JAVa script
Rem
Rem    DESCRIPTION
Rem      This script checks the status Oracle Multimedia 
Rem      libraries.
Rem
Rem    NOTES
Rem      This script is invoked by imchk.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rabbott     01/17/08 - rewrite check for native library
Rem    dolin       10/17/07 - Created
Rem

alter session set current_schema = "ORDSYS";

create or replace and resolve noforce java source named ORDSYS."imchkjav" as
import java.awt.color.ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.image.IndexColorModel;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import com.sun.image.codec.jpeg.JPEGCodec;
import com.sun.image.codec.jpeg.JPEGImageEncoder;
import sun.awt.image.codec.JPEGImageDecoderImpl;
import oracle.ord.media.img.Operations;
public class imchkjav {
  /**
   * Retrieves a Java system property, e.g. java.version.
   */
  public static String getJavaProperty(String propName) {
    if (propName == null || propName.length() == 0) {
      return "Error: null or empty property name specified.";
    }
    try {
      String prop = System.getProperty(propName);
      if (prop != null)
        return propName + " = " + prop;
      else
        return "Error: no System property '" + propName + "'";
    } catch (Exception e) {
      return "Error: " + e.getMessage();
    }
  }

  /**
   * Runs basic tests on the AWT subsystem of the Java VM
   */
  public static String checkAWT() {
    boolean failure = false;
    String result = "";  
    try {
      // Check the presence of the "awt" system library
      // This lib gets loaded as class init for ColorModel,
      // which is an abstract parent of IndexColorModel.
      byte[] arr = new byte[]{(byte)0, (byte)255};
      IndexColorModel icm = new IndexColorModel(8,2,arr,arr,arr);

    } catch (Throwable t1) {
      result += ("Failure creating IndexColorModel instance\n");
      result += ("This may indicate a missing native AWT lib.\n");
      t1.printStackTrace(System.out);
      failure = true;
    }

    try {
      // Check the presence of the "awt" system library
      // This lib gets loaded as class init for ColorModel,
      // which is an abstract parent of IndexColorModel.
      BufferedImage img =
        new BufferedImage(1,1,BufferedImage.TYPE_BYTE_GRAY);

    } catch (Throwable t2) {
      result += ("Failure creating BufferedImage instance\n");
      result += ("This may indicate a missing native AWT lib.\n");
      t2.printStackTrace(System.out);
      failure = true;
    }

    try {
      // Check that ICC_Profiles work
      ICC_Profile theProfile =
        ICC_Profile.getInstance(ColorSpace.CS_GRAY);
      if (theProfile == null)
        throw new Exception("Couldn't load GRAY colorspace");

      ColorSpace cs = ColorSpace.getInstance(ColorSpace.CS_sRGB);
      if (5 != cs.getType())
        throw new Exception("Got wrong type from ColorSpace");

    } catch (Throwable t3) {
      result += ("Failure creating ColorSpace instance\n");
      result += ("This may indicate a missing ICC profiles.\n");
      t3.printStackTrace(System.out);
      failure = true;
    }

    if (failure == false) {
      result += ("AWT check ran without error.");
    }
    return result;
  }

  /* Checks if JDK JPEG encoding/decoding works. */
  public static void checkJPEG() {
    // this is a simple 1x1 jpeg image (a nice lime green)
    byte[] data = new byte[] {
      (byte)0xff, (byte)0xd8, (byte)0xff, (byte)0xe0, 
      (byte)0x00, (byte)0x10, (byte)0x4a, (byte)0x46, 
      (byte)0x49, (byte)0x46, (byte)0x00, (byte)0x01, 
      (byte)0x01, (byte)0x01, (byte)0x00, (byte)0x60, 
      (byte)0x00, (byte)0x60, (byte)0x00, (byte)0x00, 
      (byte)0xff, (byte)0xdb, (byte)0x00, (byte)0x43, 
      (byte)0x00, (byte)0x08, (byte)0x06, (byte)0x06, 
      (byte)0x07, (byte)0x06, (byte)0x05, (byte)0x08, 
      (byte)0x07, (byte)0x07, (byte)0x07, (byte)0x09, 
      (byte)0x09, (byte)0x08, (byte)0x0a, (byte)0x0c, 
      (byte)0x14, (byte)0x0d, (byte)0x0c, (byte)0x0b, 
      (byte)0x0b, (byte)0x0c, (byte)0x19, (byte)0x12, 
      (byte)0x13, (byte)0x0f, (byte)0x14, (byte)0x1d, 
      (byte)0x1a, (byte)0x1f, (byte)0x1e, (byte)0x1d, 
      (byte)0x1a, (byte)0x1c, (byte)0x1c, (byte)0x20, 
      (byte)0x24, (byte)0x2e, (byte)0x27, (byte)0x20, 
      (byte)0x22, (byte)0x2c, (byte)0x23, (byte)0x1c, 
      (byte)0x1c, (byte)0x28, (byte)0x37, (byte)0x29, 
      (byte)0x2c, (byte)0x30, (byte)0x31, (byte)0x34, 
      (byte)0x34, (byte)0x34, (byte)0x1f, (byte)0x27, 
      (byte)0x39, (byte)0x3d, (byte)0x38, (byte)0x32, 
      (byte)0x3c, (byte)0x2e, (byte)0x33, (byte)0x34, 
      (byte)0x32, (byte)0xff, (byte)0xdb, (byte)0x00, 
      (byte)0x43, (byte)0x01, (byte)0x09, (byte)0x09, 
      (byte)0x09, (byte)0x0c, (byte)0x0b, (byte)0x0c, 
      (byte)0x18, (byte)0x0d, (byte)0x0d, (byte)0x18, 
      (byte)0x32, (byte)0x21, (byte)0x1c, (byte)0x21, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0x32, (byte)0x32, 
      (byte)0x32, (byte)0x32, (byte)0xff, (byte)0xc0, 
      (byte)0x00, (byte)0x11, (byte)0x08, (byte)0x00, 
      (byte)0x01, (byte)0x00, (byte)0x01, (byte)0x03, 
      (byte)0x01, (byte)0x22, (byte)0x00, (byte)0x02, 
      (byte)0x11, (byte)0x01, (byte)0x03, (byte)0x11, 
      (byte)0x01, (byte)0xff, (byte)0xc4, (byte)0x00, 
      (byte)0x1f, (byte)0x00, (byte)0x00, (byte)0x01, 
      (byte)0x05, (byte)0x01, (byte)0x01, (byte)0x01, 
      (byte)0x01, (byte)0x01, (byte)0x01, (byte)0x00, 
      (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x00, 
      (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x01, 
      (byte)0x02, (byte)0x03, (byte)0x04, (byte)0x05, 
      (byte)0x06, (byte)0x07, (byte)0x08, (byte)0x09, 
      (byte)0x0a, (byte)0x0b, (byte)0xff, (byte)0xc4, 
      (byte)0x00, (byte)0xb5, (byte)0x10, (byte)0x00, 
      (byte)0x02, (byte)0x01, (byte)0x03, (byte)0x03, 
      (byte)0x02, (byte)0x04, (byte)0x03, (byte)0x05, 
      (byte)0x05, (byte)0x04, (byte)0x04, (byte)0x00, 
      (byte)0x00, (byte)0x01, (byte)0x7d, (byte)0x01, 
      (byte)0x02, (byte)0x03, (byte)0x00, (byte)0x04, 
      (byte)0x11, (byte)0x05, (byte)0x12, (byte)0x21, 
      (byte)0x31, (byte)0x41, (byte)0x06, (byte)0x13, 
      (byte)0x51, (byte)0x61, (byte)0x07, (byte)0x22, 
      (byte)0x71, (byte)0x14, (byte)0x32, (byte)0x81, 
      (byte)0x91, (byte)0xa1, (byte)0x08, (byte)0x23, 
      (byte)0x42, (byte)0xb1, (byte)0xc1, (byte)0x15, 
      (byte)0x52, (byte)0xd1, (byte)0xf0, (byte)0x24, 
      (byte)0x33, (byte)0x62, (byte)0x72, (byte)0x82, 
      (byte)0x09, (byte)0x0a, (byte)0x16, (byte)0x17, 
      (byte)0x18, (byte)0x19, (byte)0x1a, (byte)0x25, 
      (byte)0x26, (byte)0x27, (byte)0x28, (byte)0x29, 
      (byte)0x2a, (byte)0x34, (byte)0x35, (byte)0x36, 
      (byte)0x37, (byte)0x38, (byte)0x39, (byte)0x3a, 
      (byte)0x43, (byte)0x44, (byte)0x45, (byte)0x46, 
      (byte)0x47, (byte)0x48, (byte)0x49, (byte)0x4a, 
      (byte)0x53, (byte)0x54, (byte)0x55, (byte)0x56, 
      (byte)0x57, (byte)0x58, (byte)0x59, (byte)0x5a, 
      (byte)0x63, (byte)0x64, (byte)0x65, (byte)0x66, 
      (byte)0x67, (byte)0x68, (byte)0x69, (byte)0x6a, 
      (byte)0x73, (byte)0x74, (byte)0x75, (byte)0x76, 
      (byte)0x77, (byte)0x78, (byte)0x79, (byte)0x7a, 
      (byte)0x83, (byte)0x84, (byte)0x85, (byte)0x86, 
      (byte)0x87, (byte)0x88, (byte)0x89, (byte)0x8a, 
      (byte)0x92, (byte)0x93, (byte)0x94, (byte)0x95, 
      (byte)0x96, (byte)0x97, (byte)0x98, (byte)0x99, 
      (byte)0x9a, (byte)0xa2, (byte)0xa3, (byte)0xa4, 
      (byte)0xa5, (byte)0xa6, (byte)0xa7, (byte)0xa8, 
      (byte)0xa9, (byte)0xaa, (byte)0xb2, (byte)0xb3, 
      (byte)0xb4, (byte)0xb5, (byte)0xb6, (byte)0xb7, 
      (byte)0xb8, (byte)0xb9, (byte)0xba, (byte)0xc2, 
      (byte)0xc3, (byte)0xc4, (byte)0xc5, (byte)0xc6, 
      (byte)0xc7, (byte)0xc8, (byte)0xc9, (byte)0xca, 
      (byte)0xd2, (byte)0xd3, (byte)0xd4, (byte)0xd5, 
      (byte)0xd6, (byte)0xd7, (byte)0xd8, (byte)0xd9, 
      (byte)0xda, (byte)0xe1, (byte)0xe2, (byte)0xe3, 
      (byte)0xe4, (byte)0xe5, (byte)0xe6, (byte)0xe7, 
      (byte)0xe8, (byte)0xe9, (byte)0xea, (byte)0xf1, 
      (byte)0xf2, (byte)0xf3, (byte)0xf4, (byte)0xf5, 
      (byte)0xf6, (byte)0xf7, (byte)0xf8, (byte)0xf9, 
      (byte)0xfa, (byte)0xff, (byte)0xc4, (byte)0x00, 
      (byte)0x1f, (byte)0x01, (byte)0x00, (byte)0x03, 
      (byte)0x01, (byte)0x01, (byte)0x01, (byte)0x01, 
      (byte)0x01, (byte)0x01, (byte)0x01, (byte)0x01, 
      (byte)0x01, (byte)0x00, (byte)0x00, (byte)0x00, 
      (byte)0x00, (byte)0x00, (byte)0x00, (byte)0x01, 
      (byte)0x02, (byte)0x03, (byte)0x04, (byte)0x05, 
      (byte)0x06, (byte)0x07, (byte)0x08, (byte)0x09, 
      (byte)0x0a, (byte)0x0b, (byte)0xff, (byte)0xc4, 
      (byte)0x00, (byte)0xb5, (byte)0x11, (byte)0x00, 
      (byte)0x02, (byte)0x01, (byte)0x02, (byte)0x04, 
      (byte)0x04, (byte)0x03, (byte)0x04, (byte)0x07, 
      (byte)0x05, (byte)0x04, (byte)0x04, (byte)0x00, 
      (byte)0x01, (byte)0x02, (byte)0x77, (byte)0x00, 
      (byte)0x01, (byte)0x02, (byte)0x03, (byte)0x11, 
      (byte)0x04, (byte)0x05, (byte)0x21, (byte)0x31, 
      (byte)0x06, (byte)0x12, (byte)0x41, (byte)0x51, 
      (byte)0x07, (byte)0x61, (byte)0x71, (byte)0x13, 
      (byte)0x22, (byte)0x32, (byte)0x81, (byte)0x08, 
      (byte)0x14, (byte)0x42, (byte)0x91, (byte)0xa1, 
      (byte)0xb1, (byte)0xc1, (byte)0x09, (byte)0x23, 
      (byte)0x33, (byte)0x52, (byte)0xf0, (byte)0x15, 
      (byte)0x62, (byte)0x72, (byte)0xd1, (byte)0x0a, 
      (byte)0x16, (byte)0x24, (byte)0x34, (byte)0xe1, 
      (byte)0x25, (byte)0xf1, (byte)0x17, (byte)0x18, 
      (byte)0x19, (byte)0x1a, (byte)0x26, (byte)0x27, 
      (byte)0x28, (byte)0x29, (byte)0x2a, (byte)0x35, 
      (byte)0x36, (byte)0x37, (byte)0x38, (byte)0x39, 
      (byte)0x3a, (byte)0x43, (byte)0x44, (byte)0x45, 
      (byte)0x46, (byte)0x47, (byte)0x48, (byte)0x49, 
      (byte)0x4a, (byte)0x53, (byte)0x54, (byte)0x55, 
      (byte)0x56, (byte)0x57, (byte)0x58, (byte)0x59, 
      (byte)0x5a, (byte)0x63, (byte)0x64, (byte)0x65, 
      (byte)0x66, (byte)0x67, (byte)0x68, (byte)0x69, 
      (byte)0x6a, (byte)0x73, (byte)0x74, (byte)0x75, 
      (byte)0x76, (byte)0x77, (byte)0x78, (byte)0x79, 
      (byte)0x7a, (byte)0x82, (byte)0x83, (byte)0x84, 
      (byte)0x85, (byte)0x86, (byte)0x87, (byte)0x88, 
      (byte)0x89, (byte)0x8a, (byte)0x92, (byte)0x93, 
      (byte)0x94, (byte)0x95, (byte)0x96, (byte)0x97, 
      (byte)0x98, (byte)0x99, (byte)0x9a, (byte)0xa2, 
      (byte)0xa3, (byte)0xa4, (byte)0xa5, (byte)0xa6, 
      (byte)0xa7, (byte)0xa8, (byte)0xa9, (byte)0xaa, 
      (byte)0xb2, (byte)0xb3, (byte)0xb4, (byte)0xb5, 
      (byte)0xb6, (byte)0xb7, (byte)0xb8, (byte)0xb9, 
      (byte)0xba, (byte)0xc2, (byte)0xc3, (byte)0xc4, 
      (byte)0xc5, (byte)0xc6, (byte)0xc7, (byte)0xc8, 
      (byte)0xc9, (byte)0xca, (byte)0xd2, (byte)0xd3, 
      (byte)0xd4, (byte)0xd5, (byte)0xd6, (byte)0xd7, 
      (byte)0xd8, (byte)0xd9, (byte)0xda, (byte)0xe2, 
      (byte)0xe3, (byte)0xe4, (byte)0xe5, (byte)0xe6, 
      (byte)0xe7, (byte)0xe8, (byte)0xe9, (byte)0xea, 
      (byte)0xf2, (byte)0xf3, (byte)0xf4, (byte)0xf5, 
      (byte)0xf6, (byte)0xf7, (byte)0xf8, (byte)0xf9, 
      (byte)0xfa, (byte)0xff, (byte)0xda, (byte)0x00, 
      (byte)0x0c, (byte)0x03, (byte)0x01, (byte)0x00, 
      (byte)0x02, (byte)0x11, (byte)0x03, (byte)0x11, 
      (byte)0x00, (byte)0x3f, (byte)0x00, (byte)0xd6, 
      (byte)0xa2, (byte)0x8a, (byte)0x2b, (byte)0xf3, 
      (byte)0x43, (byte)0xf2, (byte)0x03, (byte)0xff, 
      (byte)0xd9};

      // try and decode this image with the decoder
      ByteArrayInputStream jpegStream = new ByteArrayInputStream(data);
      JPEGImageDecoderImpl decoder = new JPEGImageDecoderImpl(jpegStream);
      BufferedImage img = decoder.decodeAsBufferedImage();
      System.out.println("JPEG Data length is " + data.length);
      System.out.println("JPEG Image is " + 
          img.getWidth() + "x" + 
          img.getHeight());
      System.out.println("JPEG Color (R,G,B) is (" +
          img.getData().getSample(0,0,0) + "," +
          img.getData().getSample(0,0,1) + "," +
          img.getData().getSample(0,0,2) + ")");


      // now, try encoding the image
      ByteArrayOutputStream baos = new ByteArrayOutputStream();
      JPEGImageEncoder encoder =
        JPEGCodec.createJPEGEncoder(baos);
      try {
        encoder.encode(img);
        System.out.println("JPEG Image Encoding was fine");
        byte[] arr = baos.toByteArray();
        System.out.println("JPEG Encoded Image length: " + arr.length);
      } catch (IOException e) {
        e.printStackTrace();
      }
  }

  /* Checks if native library can be loaded. */
  public static void checkNativeLib() {
    try {
      Operations.registerOps(false);

      OperationRegistry registry = JAI.getDefaultInstance().getOperationRegistry();
      String factory = registry.getFactory("rendered", "scale").getClass().getName();
      if( "oracle.ord.media.jai.ops.OracleScaleDescriptor".equals(factory) )
      {
        System.out.println("Successfully loaded ordim native lib -- " + 
            "JNI callouts should be enabled");
      }
      else
      {
        System.out.println("ERROR loading ordim native lib " +
           "wrong factory for Oracle scaling: " + factory );
      }
    } catch (Throwable t) {
      System.out.println("ERROR loading ordim native lib");
      t.printStackTrace();
    }
  }
}
/
show errors;


create or replace package ordsys.imchkjav
authid current_user
is

  -- =========================================================
  -- Define the helper Java stored procedure used to
  -- fetch properties.
  --
  function fetchProp(name   IN   VARCHAR2) 
  return VARCHAR2
  as LANGUAGE JAVA
  name 'imchkjav.getJavaProperty
       (java.lang.String) return java.lang.String';

  -- =========================================================
  -- Check the awt javavm subsystem. 
  --
  function checkAWT
  RETURN VARCHAR2
  as LANGUAGE JAVA
  name 'imchkjav.checkAWT() return java.lang.String';

  -- =========================================================
  -- Check the JDK JPEG encoder and decoder subsystem.
  --
  procedure checkJPEG as
  language java
  name 'imchkjav.checkJPEG()';

  -- =========================================================
  -- Verify that native library can be loaded
  --
  procedure checkNativeLib as
  language java
  name 'imchkjav.checkNativeLib()';
end;
/
show errors;

begin
  -- redirect System.out to the server log
  dbms_java.set_output(5000);

  -- print out the java version to the log
  dbms_output.put_line(imchkjav.fetchProp('java.version'));

  -- check that the awt subsystem is ok
  dbms_output.put_line(imchkjav.checkAWT());

  -- check that simple jpeg encoding/decoding works ok
  imchkjav.checkJPEG();

  -- check that we can load the native library for native scaling
  imchkjav.checkNativeLib();

end;
/

REM Clean up created package and JAVA source/class
drop package ordsys.imchkjav;
drop java source ordsys."imchkjav";

alter session set current_schema = "SYS";
