Rem
Rem imchkncj.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      imchkncj.sql - Oracle Multimedia CHecK NComp Java script
Rem
Rem    DESCRIPTION
Rem      This script checks the installation of the Oracle Multimedia
Rem      JAccelerator component and prints its status.
Rem
Rem    NOTES
Rem      This script must be run when connected as SYS

set echo off;
set serveroutput on size 50000;
call dbms_java.set_output(50000);

-- This table defines the dlls Oracle Multimedia expects to be ncomped.
--  name:        the base name of the dll
--  jar:         the jar file with the code that the dll was generated from
--  last_status: the last status of the dll in the jaccelerator$dlls table
--               (filled in by the next anonymous procedure);
create table ord_expected_ncomp_dlls(name varchar2(80), 
                                     jar  varchar2(100), 
                                     last_status varchar2(100));
begin
  insert into ord_expected_ncomp_dlls values ('oracle_ord_media_codec_ccitt',     'ordimimg_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('oracle_ord_media_codec_mmtk',      'ordimimg_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('oracle_ord_media_img',             'ordimimg_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('oracle_ord_media_jai_codec',       'ordimimg_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('oracle_ord_media_jai_io',          'ordimimg_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('oracle_ord_media_jai_ops',         'ordimimg_depl.jar', NULL);
  
  insert into ord_expected_ncomp_dlls values ('javax_media_jai',                  'jai_core_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('javax_media_jai_iterator',         'jai_core_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('javax_media_jai_operator',         'jai_core_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('javax_media_jai_registry',         'jai_core_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('javax_media_jai_tilecodec',        'jai_core_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('javax_media_jai_util',             'jai_core_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('com_sun_media_jai_iterator',       'jai_core_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('com_sun_media_jai_opimage',        'jai_core_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('com_sun_media_jai_tilecodec',      'jai_core_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('com_sun_media_jai_util',           'jai_core_depl.jar', NULL);
  
  insert into ord_expected_ncomp_dlls values ('com_sun_media_jai_codec',          'jai_codec_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('com_sun_media_jai_codecimpl',      'jai_codec_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('com_sun_media_jai_codecimpl_fpx',  'jai_codec_depl.jar', NULL);
  insert into ord_expected_ncomp_dlls values ('com_sun_media_jai_codecimpl_util', 'jai_codec_depl.jar', NULL);
end;
/

---------------------------------------------------------------------
-- This procedure runs through the jaccelerator$dlls table
-- backwards. If the last_status field in ord_expected_ncomp_dlls
-- hasn't been filled in (i.e. is NULL) the last_status field is set
-- to the status of the current jaccelerator$dll entry. Thus, after
-- this procedure, the ord_expected_ncomp_dlls.last_status field
-- contains the status for the last entry for a particular DLL in the
-- jaccelerator$dlls table.
---------------------------------------------------------------------
declare
  cursor crs is 
    select dll_name, status 
    from   jaccelerator$dlls 
    order by timestamp desc;
  current_last_status varchar2(100);
  current_name        varchar2(100);
begin
  -- for each row in jaccelerator$dlls (starting from the most recent entry)
  for rec in crs loop 
    begin
      -- select the name and status from ord_expected_ncomp_dlls table
      select last_status,name 
      into   current_last_status, current_name 
      from   ord_expected_ncomp_dlls 
      where   rec.dll_name like ('%'||name||'.%');
      
      -- if we don't have a last status for this dll, set the status to 
      -- the status of this row in jaccelerator$dlls.
      if (current_last_status is null) then
        update ord_expected_ncomp_dlls set last_status = rec.status where name=current_name;
      end if;
      
    exception 
      when others then
        dbms_output.put_line('error for dll: ' || rec.dll_name);
        dbms_output.put_line('error message: ' || SQLERRM);
    end;
  end loop;
end;
/
show err;
---------------------------------------------------------------------
-- generate an output listing along the same lines as the original imchkncj.sql
-- (order by rowid to ensure consistent output in logs)
---------------------------------------------------------------------
set pagesize 50;
set linesize 100;
column "DLL NAME"      format A60;
column "LAST STATUS"   format A15;
column "JAR"           format A20
select name "DLL NAME", last_status "LAST STATUS", jar "JAR"
 from   ord_expected_ncomp_dlls
 order by rowid;

-- This procedure verifies that all the expected dlls are present and
-- status='enabled'. If this is not the case, then the contents of
-- jaccelerator$dll are dumped to the terminal to facilitate
-- post-mortem debugging.
set serveroutput on;
set linesize 200
declare 
  good_dll_count      number;
  expected_good_count number;
begin
  select count(name) 
  into   expected_good_count 
  from   ord_expected_ncomp_dlls;
  
  select count(name)
  into   good_dll_count
  from   ord_expected_ncomp_dlls
  where  last_status = 'enabled';
  
  -- dump out errors if the expected counts don't match the actual counts;
  if (expected_good_count <> good_dll_count) then
    dbms_output.put_line('ORDIM NCOMP PROBLEMS DETECTED!');
    dbms_output.put_line(good_dll_count || ' good dlls out of ' ||
                         expected_good_count || 
                         ' expected good dlls');
    
    -- dump the content of jaccelerator$dlls;
    dbms_output.put_line('Dumping contents of jaccelerator$dlls!');
    dbms_output.put_line(RPAD('dll_name', 80) || 
                         RPAD('timestamp', 20) || 
                         'status');
    dbms_output.put_line
      ('---------------------------------------------------------------' ||
       '---------------------------------------------------------------');
    for rec in (select * from jaccelerator$dlls order by timestamp) loop
      dbms_output.put_line
        (RPAD(rec.dll_name,80) || RPAD(rec.timestamp,20) || rec.status);
    end loop;
  end if;
end;
/
---------------------------------------------------------------------
-- drop the temporary scratch table
---------------------------------------------------------------------
drop table ord_expected_ncomp_dlls;

---------------------------------------------------------------------
-- Call the internal Oracle Multimedia Java procedure that checks the
-- NCOMP'ed status of each of the Oracle Multimedia java classes using
-- internal ojvm runtime hooks. This is the definitive answer to if the
-- jvm will run a class ncomped or not -- if it says yes, then the jvm will
-- run that class's ncomped version. If it says no, then the jvm will run
-- the class in interpreted mode.
---------------------------------------------------------------------
create or replace procedure runtime_ncomp_check(jarFileNames varchar2) is
  language java
  name 'oracle.ord.media.img.ImgDBUtils.printUnexpectedlyNonNcompedClasses(java.lang.String)';
/
call runtime_ncomp_check
     ('ord/jlib/ordimimg.jar ' ||
      'ord/jlib/jai_core.jar ' ||
      'ord/jlib/jai_codec.jar');
drop procedure runtime_ncomp_check;
