Rem Copyright (c) 2007, Oracle. All rights reserved.  
REM
REM This script checks for the schemas used by Oracle Multimedia
REM
REM You must connect as SYSDBA prior to running this script
REM

REM 
REM Make sure Oracle Multimedia schemas exist.  Note - can't check for
REM SI_INFORMTN_SCHEMA because it won't exist if we're upgrading from
REM a verion before Still Image was added.  We only alter session to
REM SI_INFORMTN_SCHEMA from ORDSYS in order to create synonyms, so the
REM worst that can happen here is we'll create some symonyms in ORDSYS
REM instead of SI_INFORMTN_SCHEMA if this schema has been removed.  Not
REM a terrible thing.
REM 

DECLARE
    lcount    NUMBER;
BEGIN
  BEGIN
    lcount := 0;
    SELECT COUNT(*) INTO lcount
      FROM all_users WHERE username = 'ORDSYS';
    
    IF lcount = 0 THEN 
      raise_application_error(-20000, 'ORDSYS schema not found. ' ||
        'See <Oracle_Home>/ord/im/admin/README.txt for manual ' ||
        'install details');
    END IF;
  END;


  BEGIN
    lcount := 0;
    SELECT COUNT(*) INTO lcount
      FROM all_users WHERE username = 'ORDPLUGINS';

    IF lcount = 0 THEN
      raise_application_error(-20000, 'ORDPLUGINS schema not found. ' ||
        'See <Oracle_Home>/ord/im/admin/README.txt for manual ' ||
        'install details');
    END IF;
  END;

END;
/


