Rem
Rem $Header: imdrg102.sql 16-apr-2007.07:44:13 myalavar Exp $
Rem
Rem imdrg102.sql
Rem
Rem Copyright (c) 2006, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      imdrg102.sql - de-register 11g dicom schemas 
Rem
Rem    DESCRIPTION
Rem       Deletes the schemas installed in 11g dicom by imxreg.sql
Rem
Rem    NOTES
Rem      must be run as sysdba
Rem      schemas are deleted in the reverse order of installation
Rem      This is used in downgrade , called by ime102.sql
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    myalavar    04/14/07 - update namespace
Rem    myalavar    12/08/06 - Deregister dicom 11g schemas during downgrade
Rem    myalavar    12/08/06 - Created
Rem

--delete 11g dicom schemas
-- ok to use force option for downgrade
--   http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0  
--   http://xmlns.oracle.com/ord/dicom/orddicom_1_0  
--   http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0  
--   http://xmlns.oracle.com/ord/dicom/preference_1_0  
--   http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0  
--   http://xmlns.oracle.com/ord/dicom/mapping_1_0  
--   http://xmlns.oracle.com/ord/dicom/metadata_1_0  
--   http://xmlns.oracle.com/ord/dicom/constraint_1_0
--   http://xmlns.oracle.com/ord/dicom/anonymity_1_0  
--   http://xmlns.oracle.com/ord/dicom/datatype_1_0  
--   http://xmlns.oracle.com/ord/dicom/rpdatatype_1_0
--  http://xmlns.oracle.com/ord/dicom/mddatatype_1_0

--ok to use force option during downgrade
declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 
                 'http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0',
                 DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/

declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/dicom/orddicom_1_0',
                                DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/

declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 
     'http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0',
      DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/

declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/dicom/preference_1_0',
                                DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/

declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA(
      'http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0',
       DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/


declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA('http://xmlns.oracle.com/ord/dicom/mapping_1_0',
                              DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/

declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/dicom/metadata_1_0',
                                DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/

declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/dicom/constraint_1_0',
                                DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/

declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/dicom/anonymity_1_0',
                                DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/

declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/dicom/datatype_1_0',
                                DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/


declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 
                 'http://xmlns.oracle.com/ord/dicom/rpdatatype_1_0',
                 DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/

declare
  ex exception;
  --ignore ORA-31000: Resource '..' not an XDB schema document
  pragma exception_init( ex, -31000 );
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 
                 'http://xmlns.oracle.com/ord/dicom/mddatatype_1_0',
                 DBMS_XMLSCHEMA.DELETE_CASCADE_FORCE );

  EXCEPTION
   --ignore ORA-31000: Resource '..' not an XDB schema document
   when ex then
     null;
END;
/
