Rem
Rem $Header: imdrpjp2.sql 22-oct-2007.10:06:45 smavris Exp $
Rem
Rem imdrpjp2.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      imdrpjp2.sql - Removes the JPEG2000 codec installed by initjp2.sql
Rem
Rem    DESCRIPTION
Rem      1. Drops the schema into which the JPEG2000 codec was loaded
Rem      2. Removes all public synonyms that point at the JPEG2000 schema
Rem      3. Revokes the permissions (write to tmpdir) granted by initjp2.sql
Rem
Rem    NOTES
Rem      You must be connected as SYSTEM, SYS, or SYSDBA to run this script
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smavris     10/22/07 - Check to see if Oracle Multimedia schemas have
Rem                           been removed
Rem    alamb       02/04/05 - alamb_test_jpeg_2k_integration_050114
Rem    alamb       01/25/05 - Created
Rem

WHENEVER SQLERROR EXIT;

REM 
REM Make sure Oracle Multimedia schemas exist.
REM 

@@imchksch.sql

WHENEVER SQLERROR CONTINUE;

DEFINE JP2SCHEMA = ORDJP2K


-- Save the original value of CURRENT_SCHEMA before change to ORDSYS
VARIABLE ORDORIGSCHEMA VARCHAR2(2000);
DECLARE 
  t varchar2(2000);
BEGIN
  SELECT sys_context('USERENV', 'CURRENT_SCHEMA') INTO t FROM dual;
  :ORDORIGSCHEMA := t;
END;
/

ALTER SESSION SET CURRENT_SCHEMA = "ORDSYS";

--  Revoke the permissions that were granted in initjp2.sql
CREATE OR REPLACE FUNCTION ordGetJavaProp (propname varchar2)
RETURN varchar2 
AS LANGUAGE java
NAME 'java.lang.System.getProperty(java.lang.String) return java.lang.String';
/

BEGIN
  dbms_java.revoke_permission
     ('ORDSYS', 
     'SYS:java.io.FilePermission',
     ordGetJavaProp('java.io.tmpdir') || ordGetJavaProp('file.separator') || '*',
     'read,write,delete');
  dbms_java.revoke_permission
     ('&JP2SCHEMA', 
     'SYS:java.io.FilePermission',
     ordGetJavaProp('java.io.tmpdir') || ordGetJavaProp('file.separator') || '*',
     'read,write,delete');
END;
/

DROP FUNCTION ordGetJavaProp;

-- Delete all the public synonyms that pointed at the JPEG2000 schema.
-- The reason that we simply can not do a "dropjava('synonym') is that
-- initjp2.sql loads the jai_imageio.jar using the "-genmissing" flag
-- in loadjava. The "-genmissing" flag generates stubs for any missing
-- java classes that are required for resolution. Because this flag is
-- used, there are generated classes (and public synonyms) in the
-- database that are not in jai_imageio.jar, so dropjava'ing the jar
-- with -synonym won't remove all the synonyms, thus our approach
-- here.

DECLARE
  CURSOR crs IS 
    SELECT 'DROP PUBLIC SYNONYM "'|| synonym_name || '"' cmd 
    FROM   all_synonyms 
    WHERE  table_owner = '&JP2SCHEMA';
BEGIN 
  FOR rec IN crs LOOP
    EXECUTE IMMEDIATE rec.cmd;
  END LOOP;
END;
/

-- Drop the JPEG2000 schema from the database
DROP USER &JP2SCHEMA CASCADE;

-- restore the original CURRENT_SCHEMA value
BEGIN
  EXECUTE IMMEDIATE 'ALTER SESSION SET CURRENT_SCHEMA = "'||:ORDORIGSCHEMA||'"';
END;
/

