Rem Copyright (c) 2004, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      ime101.sql
Rem
Rem    DESCRIPTION
Rem      runs as SYS
Rem
Rem      Internal downgrade script for Oracle Multimedia to 10.1.0.
Rem
Rem    NOTES
Rem      This script deletes all objects and types that have been added 
Rem       between 10.1
Rem       and 10.2. After this script is run, the imrelod.sql script
Rem       is run to reload 10.1 Oracle Multimedia in the downgraded database.
Rem

WHENEVER SQLERROR EXIT;

REM 
REM Make sure Oracle Multimedia schemas exist.
REM
REM Note - it is forbidden to exit in a downgrade script.  
REM However, it is an assumed impossible condition that we exist in the 
REM registry (which is the only way this script should be called) and our
REM schemas don't exist.  Therefore, we will exit here if our schemas don't
REM exist so we can figure out how we got in this situation.
REM 

@@imchksch.sql

WHENEVER SQLERROR CONTINUE;
alter session set current_schema="ORDSYS";
EXECUTE dbms_registry.downgrading('ORDIM', 'Oracle interMedia');

REM Invoke 10.2 script to go from 11 to 10.2 (downgrade scripts run as SYS)
alter session set current_schema="SYS";
@@ime102.sql

--
-- Restore previous privileges to ORDSYS, ORDPLUGINS
--
grant create view, create any synonym, drop any synonym to ordsys;
grant create session, create library, create procedure to ordsys;
grant create  operator to ordsys;
grant create  indextype to ordsys;
grant create  type to ordsys;
grant create  table to ordsys;
grant create public synonym to ordsys;
grant drop public synonym to ordsys;
grant create session, unlimited tablespace, create library to ordplugins;
grant create procedure to ordplugins;
grant create operator to ordplugins;
grant create indextype to ordplugins;
grant create type to ordplugins;
grant create table to ordplugins;
grant create public synonym to ordplugins;
grant drop public synonym to ordplugins;

alter session set current_schema="ORDSYS";

REM drop metadata schemas, do not force, ignore exceptions
BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/meta/ordimage',
                               DBMS_XMLSCHEMA.DELETE_CASCADE );
  EXCEPTION
  WHEN OTHERS THEN
    NULL;
END;
/

BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/meta/iptc',
                               DBMS_XMLSCHEMA.DELETE_CASCADE );
  EXCEPTION
  WHEN OTHERS THEN
    NULL;
END;
/

BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/meta/exif',
                               DBMS_XMLSCHEMA.DELETE_CASCADE );
  EXCEPTION
  WHEN OTHERS THEN
    NULL;
END;
/

BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/meta/xmp',
                               DBMS_XMLSCHEMA.DELETE_CASCADE );
  EXCEPTION
  WHEN OTHERS THEN
    NULL;
END;
/

BEGIN
  DBMS_XMLSCHEMA.DELETESCHEMA( 'http://xmlns.oracle.com/ord/meta/dicomImage',
                               DBMS_XMLSCHEMA.DELETE_CASCADE );
  EXCEPTION
  WHEN OTHERS THEN
    NULL;
END;
/


REM Alter existing types back to pre-10gR2 state
ALTER TYPE ORDImage 
  DROP MEMBER FUNCTION getDicomMetadata(
                            SELF IN ORDImage,
                            optionString  IN VARCHAR2) 
      RETURN XMLType CASCADE;

ALTER TYPE ORDImage
  DROP STATIC FUNCTION getDicomMetadata(
                             imageBlob      IN BLOB,
                             optionString IN VARCHAR2) 
      RETURN XMLType CASCADE;

ALTER TYPE ORDImage
  DROP STATIC FUNCTION getDicomMetadata(
                             imageBfile     IN BFILE,
                             optionString IN VARCHAR2) 
      RETURN XMLType CASCADE;

ALTER TYPE ORDImage DROP
  MEMBER FUNCTION getMetadata(SELF          IN ORDImage,
                              metadataType  IN VARCHAR2 DEFAULT 'ALL') 
  RETURN SYS.XMLSEQUENCETYPE CASCADE;

ALTER TYPE ORDImage DROP
  MEMBER PROCEDURE putMetadata(SELF         IN OUT NOCOPY ORDImage,
                               xmlData      IN SYS.XMLType,
                               metadataType IN VARCHAR2 DEFAULT 'XMP',
                               encoding     IN VARCHAR2 DEFAULT 'UTF-8')
  CASCADE;

ALTER TYPE ORDImage DROP
  STATIC FUNCTION getMetadata(imageBlob    IN BLOB,
                              metadataType IN VARCHAR2 DEFAULT 'ALL')
  RETURN SYS.XMLSEQUENCETYPE CASCADE;

ALTER TYPE ORDImage DROP
  STATIC FUNCTION getMetadata(imageBfile   IN BFILE,
                              metadataType IN VARCHAR2 DEFAULT 'ALL')
  RETURN SYS.XMLSEQUENCETYPE CASCADE;

ALTER TYPE ORDImage DROP
  STATIC PROCEDURE putMetadata(imageBlob    IN BLOB,
                               dest         IN OUT NOCOPY BLOB,
                               xmlData      IN SYS.XMLType,
                               metadataType IN VARCHAR2 DEFAULT 'XMP',
                               encoding     IN VARCHAR2 DEFAULT 'UTF-8')
  CASCADE;

ALTER TYPE ORDImage DROP
  STATIC PROCEDURE putMetadata(imageBfile   IN BFILE,
                               dest         IN OUT NOCOPY BLOB,
                               xmlData      IN SYS.XMLType,
                               metadataType IN VARCHAR2 DEFAULT 'XMP',
                               encoding     IN VARCHAR2 DEFAULT 'UTF-8')
  CASCADE;


Rem
Rem Add deprecated ORDImgF and ORDImgB types (ordispec is not run in imrelod)
Rem

CREATE TYPE ORDImgB 
  TIMESTAMP '1997-10-31:08:04:00'
  OID '1EC322A450AA28AAE03400400B4066F3'
  authid current_user
  AS OBJECT
(
-- THE FUNCTIONS, PACKAGES AND TYPES SUPPLIED BY THIS PACKAGE AND ITS EXTERNAL
-- INTERFACE ARE RESERVED BY ORACLE AND ARE SUBJECT TO CHANGE IN FUTURE
-- RELEASES.  THIS PACKAGE MUST NOT BE MODIFIED BY THE CUSTOMER.  DOING SO
-- COULD CAUSE INTERNAL ERRORS AND SECURITY VIOLATIONS IN THE DBMS.

  -------------------
  -- TYPE ATTRIBUTES
  --  
  -- content
  --   Image data
  -- height
  --   Height of the image in pixels 
  -- width
  --   Width of image in pixels
  -- contentLength
  --   Size of image (header and image data) in bytes
  -- fileFormat
  --   File type of image (e.g., TIFF, JFIF) 
  -- contentFormat
  --   Type of image (e.g., monochrome, 8-bit Grayscale)
  -- compressionFormat
  --   Compression used in image
  
  content             BLOB,
  height              INTEGER,  
  width               INTEGER,
  contentLength       INTEGER,
  fileFormat          VARCHAR2(64),
  contentFormat       VARCHAR2(64),
  compressionFormat   VARCHAR2(64),


----------------
-- METHOD DECLARATION
--     

  MEMBER PROCEDURE copyContent(SELF IN OUT NOCOPY ORDImgB,
                               dest IN OUT NOCOPY BLOB),
    
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgB),

  MEMBER PROCEDURE process(SELF    IN OUT NOCOPY ORDImgB,
                           command IN            VARCHAR2),

  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImgB,
                               command IN     VARCHAR2, 
                               dest    IN OUT NOCOPY BLOB)


);
/
 show errors;

ALTER TYPE ORDImgB REPLACE
  authid current_user
  AS OBJECT
(
  content             BLOB,
  height              INTEGER,  
  width               INTEGER,
  contentLength       INTEGER,
  fileFormat          VARCHAR2(64),
  contentFormat       VARCHAR2(64),
  compressionFormat   VARCHAR2(64),
--
--
----------------
-- METHOD DECLARATION
--     
--
  MEMBER PROCEDURE copyContent(SELF IN OUT NOCOPY ORDImgB,
                               dest IN OUT NOCOPY BLOB),
--    
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgB),
--
  MEMBER PROCEDURE process(SELF    IN OUT NOCOPY ORDImgB,
                           command IN            VARCHAR2),
--
  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImgB,
                               command IN            VARCHAR2,
                               dest    IN OUT NOCOPY BLOB),
--
-- Add methods new to 8.1
--
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgB,
                                 description IN VARCHAR2),
--
  MEMBER FUNCTION getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDImgB),
--
  MEMBER FUNCTION getHeight RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getHeight, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getWidth RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getWidth, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getFileFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFileFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getContentFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getContentFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION getCompressionFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionFormat, WNDS, WNPS, RNDS, RNPS), 
--
  MEMBER FUNCTION checkProperties RETURN BOOLEAN
);
 show errors;

-- End ORDImgB


CREATE TYPE ORDImgF
  TIMESTAMP '1997-10-31:08:04:00'
  OID '1EC322A450AB28AAE03400400B4066F3'
  authid current_user
  AS OBJECT
(
  -------------------
  -- TYPE ATTRIBUTES
  -- 
  -- content
  --   Image data
  -- height
  --   Height of the image in pixels 
  -- width
  --   Width of image in pixels
  -- contentLength
  --   Size of image data (headers and image) in bytes
  -- fileFormat
  --   File type of image (e.g., TIFF, JFIF) 
  -- contentFormat
  --   Type of image (e.g., monochrome, 8-bit Grayscale)
  -- compressionFormat
  --   Compression used in image

  content              BFILE,
  height               INTEGER,  
  width                INTEGER,
  contentLength        INTEGER,
  fileFormat           VARCHAR2(64),
  contentFormat        VARCHAR2(64),
  compressionFormat    VARCHAR2(64),


----------------
-- METHOD DECLARATION
-- 
  
  
  MEMBER PROCEDURE copyContent(SELF IN OUT NOCOPY ORDImgF,
                               dest IN OUT NOCOPY BLOB),

  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgF),

  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImgF,
                               command IN            VARCHAR2,
                               dest    IN OUT NOCOPY BLOB)

);
/
show errors;

ALTER TYPE ORDImgF REPLACE
  authid current_user
  AS OBJECT
(
-- Add methods new to 8.1
--
  content              BFILE,
  height               INTEGER,  
  width                INTEGER,
  contentLength        INTEGER,
  fileFormat           VARCHAR2(64),
  contentFormat        VARCHAR2(64),
  compressionFormat    VARCHAR2(64),
--
--
----------------
-- METHOD DECLARATION
-- 
--
  --
  MEMBER PROCEDURE copyContent(SELF IN OUT NOCOPY ORDImgF,
                               dest IN OUT NOCOPY BLOB),
--
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgF),
--
  MEMBER PROCEDURE processCopy(SELF    IN OUT NOCOPY ORDImgF,
                               command IN            VARCHAR2, 
                               dest    IN OUT NOCOPY BLOB),
--
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDImgF,
                                 description IN VARCHAR2),
--
  MEMBER FUNCTION getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getContent RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getHeight RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getHeight, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getWidth RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getWidth, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getFileFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFileFormat, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getContentFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getContentFormat, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION getCompressionFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionFormat, WNDS, WNPS, RNDS, RNPS),
--
  MEMBER FUNCTION checkProperties RETURN BOOLEAN
--
);
show errors;
-- End ORDImgF

Rem
Rem Remove the new NULL_SOURCE Exceptions
Rem

CREATE OR REPLACE PACKAGE ORDAudioExceptions
AS
  AUDIO_PLUGIN_EXCEPTION      EXCEPTION;
  INVALID_DESCRIPTION         EXCEPTION;
  DESCRIPTION_IS_NOT_SET      EXCEPTION;
  INVALID_MIME_TYPE           EXCEPTION;
  METHOD_NOT_SUPPORTED        EXCEPTION;
  NULL_INPUT_VALUE            EXCEPTION;
  AUDIO_FORMAT_IS_NULL        EXCEPTION;
  AUDIO_ENCODING_IS_NULL      EXCEPTION;
  AUDIO_NUM_CHANNELS_IS_NULL  EXCEPTION;
  AUDIO_SAMPLING_RATE_IS_NULL EXCEPTION;
  AUDIO_SAMPLE_SIZE_IS_NULL   EXCEPTION;
  AUDIO_DURATION_IS_NULL      EXCEPTION;
  LOCAL_DATA_SOURCE_REQUIRED  EXCEPTION;
  NULL_LOCAL_DATA             EXCEPTION;
END;
/

CREATE OR REPLACE PACKAGE ORDVideoExceptions
AS
  VIDEO_PLUGIN_EXCEPTION   EXCEPTION;
  INVALID_TITLE            EXCEPTION;
  DESCRIPTION_IS_NOT_SET   EXCEPTION;
  INVALID_MIME_TYPE        EXCEPTION;
  METHOD_NOT_SUPPORTED     EXCEPTION;
  NULL_INPUT_VALUE         EXCEPTION;
  VIDEO_FORMAT_IS_NULL     EXCEPTION;
  LOCAL_DATA_SOURCE_REQUIRED     EXCEPTION;
  NULL_LOCAL_DATA          EXCEPTION;
END;
/

CREATE OR REPLACE PACKAGE ORDDocExceptions
AS
  DOC_PLUGIN_EXCEPTION        EXCEPTION;
  INVALID_MIME_TYPE           EXCEPTION;
  INVALID_FORMAT_TYPE         EXCEPTION;
  METHOD_NOT_SUPPORTED        EXCEPTION;
  NULL_INPUT_VALUE            EXCEPTION;
  NULL_LOCAL_DATA             EXCEPTION;
END;
/

Rem
Rem Add deprecated OrdImage methods
Rem
ALTER TYPE ORDImage ADD
  MEMBER PROCEDURE migrateFromORDImgB(SELF IN OUT ORDImage,
                                      old_object ORDImgB) CASCADE;

ALTER TYPE ORDImage ADD
  MEMBER PROCEDURE migrateFromORDImgF(SELF IN OUT NOCOPY ORDImage,
                                      old_object ORDImgF) CASCADE;  

Rem
REm Add deprecated OrdAudio methods
Rem
ALTER TYPE ORDAudio ADD
  MEMBER FUNCTION getFormat(ctx IN OUT RAW) RETURN VARCHAR2 CASCADE;

ALTER TYPE ORDAudio ADD
  MEMBER FUNCTION getEncoding(ctx IN OUT RAW) RETURN VARCHAR2 CASCADE;

ALTER TYPE ORDAudio ADD
  MEMBER FUNCTION  getNumberOfChannels(ctx IN OUT RAW) RETURN INTEGER CASCADE;


ALTER TYPE ORDAudio ADD
  MEMBER FUNCTION  getSamplingRate(ctx IN OUT RAW) RETURN INTEGER CASCADE;

ALTER TYPE ORDAudio ADD
  MEMBER FUNCTION  getSampleSize(ctx IN OUT RAW) RETURN INTEGER CASCADE;

ALTER TYPE ORDAudio ADD
  MEMBER FUNCTION  getCompressionType(ctx IN OUT RAW) RETURN VARCHAR2 CASCADE;

ALTER TYPE ORDAudio ADD
  MEMBER FUNCTION  getAudioDuration(ctx IN OUT RAW) RETURN INTEGER CASCADE;

Rem
REm Add deprecated OrdVideo methods
Rem
ALTER TYPE ORDVideo ADD
  MEMBER FUNCTION getFormat(ctx IN OUT RAW) RETURN VARCHAR2 CASCADE;

ALTER TYPE ORDVideo ADD
  MEMBER PROCEDURE getFrameSize(SELF IN OUT NOCOPY ORDVideo,
                                ctx IN OUT RAW, 
                                retWidth OUT INTEGER, 
                                retHeight OUT INTEGER) CASCADE;

ALTER TYPE ORDVideo ADD
  MEMBER FUNCTION  getFrameResolution(ctx IN OUT RAW) RETURN INTEGER CASCADE;

ALTER TYPE ORDVideo ADD
  MEMBER FUNCTION  getFrameRate(ctx IN OUT RAW) RETURN INTEGER CASCADE;

ALTER TYPE ORDVideo ADD
  MEMBER FUNCTION  getVideoDuration(ctx IN OUT RAW) RETURN INTEGER CASCADE;

ALTER TYPE ORDVideo ADD
  MEMBER FUNCTION  getNumberOfFrames(ctx IN OUT RAW) RETURN INTEGER CASCADE;

ALTER TYPE ORDVideo ADD
  MEMBER FUNCTION  getCompressionType(ctx IN OUT RAW) RETURN VARCHAR2 CASCADE;

ALTER TYPE ORDVideo ADD
  MEMBER FUNCTION  getNumberOfColors(ctx IN OUT RAW) RETURN INTEGER CASCADE;

ALTER TYPE ORDVideo ADD
  MEMBER FUNCTION  getBitRate(ctx IN OUT RAW) RETURN INTEGER CASCADE;


Rem
Rem Reloading 10.1 package specs since they have changed in 10.2 and 10.1 
Rem reload script does not reload them..
Rem

Rem
Rem Replace 10.1 ORDImg_Pkg spec
Rem

CREATE OR REPLACE PACKAGE ORDImg_Pkg
  authid current_user
AS
  FUNCTION ordimgB_setProperties(
    content       IN     BLOB,
    height        OUT BINARY_INTEGER,
    width         OUT BINARY_INTEGER,
    contentLength OUT BINARY_INTEGER,
    fileFormat    OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2) return BINARY_INTEGER;

  FUNCTION ordimg_headerlessSetProperties(
    description    IN  VARCHAR2,
    height         OUT BINARY_INTEGER,
    width          OUT BINARY_INTEGER,
    fileFormat     OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2,
    mimeType       OUT VARCHAR2)
  return BINARY_INTEGER;

  FUNCTION ordimgB_process(
    command        IN     VARCHAR2,
    headerlessInfo IN     VARCHAR2,
    src            IN     BLOB,
    dest           IN OUT NOCOPY BLOB)
  return BINARY_INTEGER;

  FUNCTION ordimgF_setProperties(
    content        IN     BFILE,
    height         OUT BINARY_INTEGER,
    width          OUT BINARY_INTEGER,
    contentLength  OUT BINARY_INTEGER,
    fileFormat     OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2)
  return BINARY_INTEGER;

  FUNCTION ordimgF_processCopy( 
    command        IN     VARCHAR2,
    headerlessInfo IN     VARCHAR2,
    src            IN     BFILE, 
    dest           IN OUT NOCOPY BLOB)
  return BINARY_INTEGER;

  FUNCTION getMimeType(
    FileFormat IN VARCHAR2) 
  RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS);

  PROCEDURE buildXMLAttributes(
    retAttributes     IN OUT NOCOPY CLOB,
    mimeType          IN VARCHAR2,
    width             IN INTEGER,
    height            IN INTEGER,
    fileFormat        IN VARCHAR2,
    contentFormat     IN VARCHAR2,
    compressionFormat IN VARCHAR2,
    contentLength     IN INTEGER,
    version           IN INTEGER);

  PROCEDURE copy(
    S    IN OUT NOCOPY ORDImage, 
    dest IN OUT NOCOPY ORDImage);

  PROCEDURE process(
    S       IN OUT NOCOPY ORDImage,
    command IN            VARCHAR2);

  PROCEDURE processCopy(
    S       IN OUT NOCOPY ORDImage,
    command IN            VARCHAR2,
    dest    IN OUT NOCOPY ORDImage);

  PROCEDURE setProperties(
    S       IN OUT NOCOPY ORDImage);
  
  PROCEDURE setProperties(
    S           IN OUT NOCOPY ORDImage,
    description IN            VARCHAR2);
  
  FUNCTION checkProperties(
    S IN ORDImage)
  RETURN BOOLEAN;

  PROCEDURE import(
    S              IN OUT NOCOPY ORDImage,
    ctx            IN OUT        RAW);

  PROCEDURE importFrom(
    S               IN OUT NOCOPY ORDImage,
    ctx             IN OUT        RAW,
    source_type     IN            VARCHAR2,
    source_location IN            VARCHAR2,
    source_name     IN            VARCHAR2);

  PROCEDURE getHeaderlessInfo(
          fileFormat        IN  VARCHAR2,
          height            IN  NUMBER,
          width             IN  NUMBER,
          compressionFormat IN  VARCHAR2,
          contentFormat     IN  VARCHAR2,
          info              OUT VARCHAR2);

  PROCEDURE copyContent(source IN OUT BFILE, dest IN OUT NOCOPY BLOB);
  PROCEDURE setProperties(S IN OUT NOCOPY ORDImgF);
  PROCEDURE setProperties(S IN OUT NOCOPY ORDImgF, description IN VARCHAR2);
  PROCEDURE processCopy(S IN OUT NOCOPY ORDImgF,
                        command IN VARCHAR2,
                        dest IN OUT NOCOPY BLOB);
  FUNCTION  checkProperties(S IN ORDImgF) RETURN BOOLEAN;

  PROCEDURE copyContent(source IN OUT NOCOPY BLOB, dest IN OUT NOCOPY BLOB);
  PROCEDURE setProperties(S IN OUT NOCOPY ORDImgB);
  PROCEDURE setProperties(S IN OUT NOCOPY ORDImgB, description IN VARCHAR2);
  PROCEDURE process(S IN OUT NOCOPY ORDImgB, command IN VARCHAR2);
  PROCEDURE processCopy(S IN OUT NOCOPY ORDImgB,
                        command IN VARCHAR2,
                        dest IN OUT NOCOPY BLOB);
  PROCEDURE deleteContent(S IN OUT NOCOPY ORDImgB);
  FUNCTION  checkProperties(S IN ORDImgB) RETURN BOOLEAN;

  PROCEDURE ORDImgB2ORDImage(src IN ORDImgB, dest IN OUT NOCOPY ORDImage); 
  PROCEDURE ORDImgF2ORDImage(src IN ORDImgF, dest IN OUT NOCOPY ORDImage); 

  FUNCTION getImageProperties(
    content       IN     BLOB,
    height        OUT    NUMBER,
    width         OUT    NUMBER,
    contentLength OUT    NUMBER,
    fileFormat    OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2,
    addnlErrorText      OUT VARCHAR2)
  return    NUMBER;

  FUNCTION imageConvert(
    command        IN     VARCHAR2,
    headerlessInfo IN     VARCHAR2,
    src            IN     BLOB,
    dest           IN OUT NOCOPY BLOB,
    addnlErrorText    OUT VARCHAR2)
  return    NUMBER;

  FUNCTION getImageProperties(
    content        IN     BFILE,
    height         OUT    NUMBER,
    width          OUT    NUMBER,
    contentLength  OUT    NUMBER,
    fileFormat     OUT VARCHAR2,
    contentFormat       OUT VARCHAR2,
    compressionFormat   OUT VARCHAR2,
    addnlErrorText      OUT VARCHAR2)
  return    NUMBER;

  FUNCTION imageConvert(
    command        IN     VARCHAR2,
    headerlessInfo IN     VARCHAR2,
    src            IN     BFILE,
    dest           IN OUT NOCOPY BLOB,
    addnlErrorText    OUT VARCHAR2)
  return    NUMBER;

END ORDImg_Pkg;
/
show errors;

Rem
Rem Reloading 10.1 image signature package specs since they 
Rem since they have changed in 10.2 and 10.1 reload script does not
Rem does not reload them..
Rem

CREATE OR REPLACE PACKAGE ORDImgSig_Pkg
  authid current_user
AS
  FUNCTION generateSignatureFunc(content   IN BLOB,
                                 width     IN PLS_INTEGER,
				 height    IN PLS_INTEGER,
				 signature IN OUT BLOB)
  RETURN PLS_INTEGER
  IS
  LANGUAGE C
  NAME "kidigen_sig" LIBRARY ORDIMLIBT
  WITH CONTEXT
  PARAMETERS(
          CONTEXT,
	  content  OCILobLocator,
	  height   sb4,
	  width    sb4,
	  signature OCILobLocator,
	  signature INDICATOR sb4);

  
  -- internal usage only--
  PROCEDURE analyzeFunc(content     IN    ORDSYS.ORDImage,
                        signature   OUT   RAW);


  -- internal usage only--
  FUNCTION generateRawSignatureFunc(content    IN    BLOB,
                                    width      IN    PLS_INTEGER,
                                    height     IN    PLS_INTEGER,
                                    signature  OUT   RAW)
  RETURN PLS_INTEGER 
  IS
  LANGUAGE C
  NAME "kidivir_sig" LIBRARY ORDIMLIBT
  WITH CONTEXT
  PARAMETERS(
             CONTEXT,
             content OCILobLocator,
             height  sb4,
             width   sb4,
             signature RAW,
             signature LENGTH sb4,
             signature MAXLEN sb4,
             signature INDICATOR);

  -- internal usage only--
  FUNCTION Score(Signature1    IN   RAW,
                 Signature2    IN   RAW,
                 Weights       IN   VARCHAR2)
  RETURN FLOAT
  IS
  LANGUAGE C
  NAME "kidivir_scr" LIBRARY ORDIMLIBT
  WITH CONTEXT
  PARAMETERS(
             CONTEXT,
             Signature1    RAW,
             Signature1    LENGTH sb4,
             Signature1    INDICATOR ,
             Signature2    RAW,
             Signature2    LENGTH sb4,
             Signature2    INDICATOR ,
             Weights       String);
  PRAGMA RESTRICT_REFERENCES(Score,WNDS,RNDS,WNPS,RNPS);

  
END ORDImgSig_Pkg;
/
show errors;

BEGIN
  EXECUTE IMMEDIATE
    'grant execute on ORDImgSig_Pkg to public';
  EXCEPTION WHEN OTHERS THEN NULL;
END;
/



Rem
Rem Replace 10.1 ORDAudio_Pkg spec
Rem

CREATE OR REPLACE PACKAGE ORDAudio_Pkg
authid current_user
AS
 

  PROCEDURE getAttributesFromLocal( 
         obj IN ORDSYS.ORDAudio,
         mimeType IN OUT VARCHAR2, 
         format OUT VARCHAR2, 
         comments IN OUT NOCOPY CLOB,
         encoding OUT VARCHAR2, 
         numberOfChannels OUT NUMBER, 
         samplingRate OUT NUMBER, 
         sampleSize OUT NUMBER, 
         compressionType OUT VARCHAR2, 
         audioDuration OUT NUMBER, 
         misc IN OUT NOCOPY CLOB);
  PRAGMA RESTRICT_REFERENCES(getAttributesFromLocal, WNDS, WNPS, RNDS, RNPS);


  PROCEDURE getAttributes( 
         obj IN ORDSYS.ORDAudio,
         mimeType IN OUT VARCHAR2, 
         format OUT VARCHAR2, 
         comments IN OUT NOCOPY CLOB,
         encoding OUT VARCHAR2, 
         numberOfChannels OUT NUMBER, 
         samplingRate OUT NUMBER, 
         sampleSize OUT NUMBER, 
         compressionType OUT VARCHAR2, 
         audioDuration OUT NUMBER, 
         misc IN OUT NOCOPY CLOB);


  PROCEDURE getAttributes( 
         data IN BLOB,
         mimeType IN OUT VARCHAR2, 
         format OUT VARCHAR2, 
         comments IN OUT NOCOPY CLOB,
         encoding OUT VARCHAR2, 
         numberOfChannels OUT NUMBER, 
         samplingRate OUT NUMBER, 
         sampleSize OUT NUMBER, 
         compressionType OUT VARCHAR2, 
         audioDuration OUT NUMBER, 
         misc IN OUT NOCOPY CLOB, 
         exceptionCode OUT NUMBER, 
         exceptionDesc OUT VARCHAR2);
  PRAGMA RESTRICT_REFERENCES(getAttributes, WNDS, WNPS, RNDS, RNPS);


  PROCEDURE getAttributes( 
         data IN BFILE,
         mimeType IN OUT VARCHAR2, 
         format OUT VARCHAR2, 
         comments IN OUT NOCOPY CLOB,
         encoding OUT VARCHAR2, 
         numberOfChannels OUT NUMBER, 
         samplingRate OUT NUMBER, 
         sampleSize OUT NUMBER, 
         compressionType OUT VARCHAR2, 
         audioDuration OUT NUMBER, 
         misc IN OUT NOCOPY CLOB, 
         exceptionCode OUT NUMBER, 
         exceptionDesc OUT VARCHAR2);
  PRAGMA RESTRICT_REFERENCES(getAttributes, WNDS, WNPS, RNDS, RNPS);

  PROCEDURE setOutputToStatus;

  PROCEDURE setOutputToVerbose;

  PROCEDURE setOutputToTrace;

  PROCEDURE setOutputToNull;

  -- The following methods mirror the methods in plugin package


  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio, 
                      mimetype IN VARCHAR2) 
                   RETURN VARCHAR2;

  FUNCTION  getEncoding(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio, 
                        mimetype IN VARCHAR2) 
                   RETURN VARCHAR2;

  FUNCTION  getNumberOfChannels(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio, 
                                mimetype IN VARCHAR2) 
                   RETURN INTEGER;

  FUNCTION  getSamplingRate(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio, 
                            mimetype IN VARCHAR2) 
                   RETURN INTEGER;

  FUNCTION  getSampleSize(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio, 
                          mimetype IN VARCHAR2) 
                   RETURN INTEGER;

  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio, 
                               mimetype IN VARCHAR2)
                   RETURN VARCHAR2;

  FUNCTION  getAudioDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio, 
                             mimetype IN VARCHAR2)
                   RETURN INTEGER;

  PROCEDURE setProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio, 
                          mimetype IN VARCHAR2, 
                          format IN VARCHAR2,
                          setComments IN NUMBER := 0);

  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio, 
                           mimetype IN VARCHAR2) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2, 
                         mimetype IN VARCHAR2) RETURN VARCHAR2;

  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB, 
                             mimetype IN VARCHAR2);
 

  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW, 
                                 mimetype IN VARCHAR2)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS);



END ORDAudio_Pkg;
/
show errors;


Rem
Rem Replace 10.1 ORDVideo_Pkg spec
Rem

CREATE OR REPLACE PACKAGE ORDVideo_Pkg
authid current_user
AS


  PROCEDURE getAttributesFromLocal( 
         obj IN ORDSYS.ORDVideo,
             mimeType IN OUT VARCHAR2, 
             format OUT VARCHAR2, 
             comments IN OUT NOCOPY CLOB,
         width OUT NUMBER, 
         height OUT NUMBER, 
         frameResolution OUT NUMBER, 
         frameRate OUT NUMBER, 
         videoDuration OUT NUMBER, 
         numberOfFrames OUT NUMBER, 
             compressionType OUT VARCHAR2, 
         numberOfColors OUT NUMBER, 
         bitRate  OUT NUMBER, 
             misc IN OUT NOCOPY CLOB);
  PRAGMA RESTRICT_REFERENCES(getAttributesFromLocal, WNDS, WNPS, RNDS, RNPS);


  PROCEDURE getAttributes( 
         obj IN ORDSYS.ORDVideo,
             mimeType IN OUT VARCHAR2, 
             format OUT VARCHAR2, 
             comments IN OUT NOCOPY CLOB,
         width OUT NUMBER, 
         height OUT NUMBER, 
         frameResolution OUT NUMBER, 
         frameRate OUT NUMBER, 
         videoDuration OUT NUMBER, 
         numberOfFrames OUT NUMBER, 
             compressionType OUT VARCHAR2, 
         numberOfColors OUT NUMBER, 
         bitRate  OUT NUMBER, 
             misc IN OUT NOCOPY CLOB);


  PROCEDURE getAttributes( 
         data IN BLOB,
             mimeType IN OUT VARCHAR2, 
             format OUT VARCHAR2, 
             comments IN OUT NOCOPY CLOB,
         width OUT NUMBER, 
         height OUT NUMBER, 
         frameResolution OUT NUMBER, 
         frameRate OUT NUMBER, 
         videoDuration OUT NUMBER, 
         numberOfFrames OUT NUMBER, 
             compressionType OUT VARCHAR2, 
         numberOfColors OUT NUMBER, 
         bitRate  OUT NUMBER, 
             misc IN OUT NOCOPY CLOB, 
         exceptionCode OUT NUMBER, 
         exceptionDesc OUT VARCHAR2);
  PRAGMA RESTRICT_REFERENCES(getAttributes, WNDS, WNPS, RNDS, RNPS);


  PROCEDURE getAttributes( 
         data IN BFILE,
             mimeType IN OUT VARCHAR2, 
             format OUT VARCHAR2, 
             comments IN OUT NOCOPY CLOB,
         width OUT NUMBER, 
         height OUT NUMBER, 
         frameResolution OUT NUMBER, 
         frameRate OUT NUMBER, 
         videoDuration OUT NUMBER, 
         numberOfFrames OUT NUMBER, 
             compressionType OUT VARCHAR2, 
         numberOfColors OUT NUMBER, 
         bitRate  OUT NUMBER, 
             misc IN OUT NOCOPY CLOB, 
         exceptionCode OUT NUMBER, 
         exceptionDesc OUT VARCHAR2);
  PRAGMA RESTRICT_REFERENCES(getAttributes, WNDS, WNPS, RNDS, RNPS);

  PROCEDURE setOutputToStatus;

  PROCEDURE setOutputToVerbose;

  PROCEDURE setOutputToTrace;

  PROCEDURE setOutputToNull;


  -- key value pairs for attributes 
  PROCEDURE getAttributes(
             data       IN BLOB,
             attributes IN OUT CLOB);

  PROCEDURE getAttributes(
             data       IN BFILE,
             attributes IN OUT CLOB);


  -- The following methods mirror the methods in plugin package

  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo, 
                      mimetype IN VARCHAR2) 
  RETURN VARCHAR2;


  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         name IN VARCHAR2, 
                         mimetype IN VARCHAR2) 
  RETURN VARCHAR2;


  PROCEDURE getFrameSize(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         width OUT INTEGER,
                         height OUT INTEGER, 
                         mimetype IN VARCHAR2);


  FUNCTION  getFrameResolution(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo, 
                               mimetype IN VARCHAR2)  
  RETURN INTEGER;

  
  FUNCTION  getFrameRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo, 
                         mimetype IN VARCHAR2)  
  RETURN INTEGER;


  FUNCTION  getVideoDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo, 
                             mimetype IN VARCHAR2)  
  RETURN INTEGER;


  FUNCTION  getNumberOfFrames(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo, 
                              mimetype IN VARCHAR2) 
  RETURN INTEGER;

  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo, 
                               mimetype IN VARCHAR2) 
  RETURN VARCHAR2;


  FUNCTION  getNumberOfColors(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo, 
                              mimetype IN VARCHAR2) 
  RETURN INTEGER;


  FUNCTION  getBitRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo, 
                       mimetype IN VARCHAR2) 
  RETURN INTEGER;


  PROCEDURE setProperties(
    ctx IN OUT RAW, 
    obj IN OUT NOCOPY ORDSYS.ORDVideo,
    mimetype IN VARCHAR2,
    format IN VARCHAR2, 
    setComments IN NUMBER := 0);


  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDVideo, 
                           mimetype IN VARCHAR2) 
  RETURN NUMBER;

  PROCEDURE getAllAttributes(ctx IN OUT RAW, 
                             obj IN ORDSYS.ORDVideo,
                             attributes IN OUT NOCOPY CLOB, 
                             mimetype IN VARCHAR2); 

 
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDVideo,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                 result OUT RAW, 
                                 mimetype IN VARCHAR2)
  RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameResolution, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getVideoDuration, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfFrames, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfColors, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getBitRate, WNDS, WNPS, RNDS, RNPS);

END ORDVideo_Pkg;
/
show errors;

--
-- reload the package spec of ORDIMERRORCODES
--
CREATE OR REPLACE PACKAGE ORDIMErrorCodes
authid current_user
AS
 
   PROCEDURE raiseExceptionWithMsg( 
              facility       IN     VARCHAR2,
              msgNum         IN     BINARY_INTEGER,
              msgEmbed       IN     VARCHAR2);
   PRAGMA RESTRICT_REFERENCES(raiseExceptionWithMsg, WNDS, WNPS, RNDS, RNPS);
 
   PROCEDURE raiseExceptionWithMsg2( 
              product        IN     VARCHAR2,
              facility       IN     VARCHAR2,
              msgNum         IN     BINARY_INTEGER,
              msgEmbed       IN     VARCHAR2,
              msgConcat      IN     VARCHAR2);
   PRAGMA RESTRICT_REFERENCES(raiseExceptionWithMsg2, WNDS, WNPS, RNDS, RNPS);
END;
/
show errors;

--
-- Drop the  common package created in 10.2
--
DROP PACKAGE ORDUTIL;

alter session set current_schema="ORDPLUGINS";
Rem
Rem Replace 10.1 ORDPLUGINS package specs
Rem


CREATE OR REPLACE PACKAGE ORDX_AIFC_AUDIO
authid current_user
AS
 
  --AUDIO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getEncoding(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getNumberOfChannels(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSamplingRate(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSampleSize(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getAudioDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDAudio,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2) RETURN VARCHAR2;
  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB);
 
  -- AUDIO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS);
 
END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_AIFF_AUDIO
authid current_user
AS
 
  --AUDIO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getEncoding(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getNumberOfChannels(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSamplingRate(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSampleSize(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getAudioDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDAudio,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2) RETURN VARCHAR2;
  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB);
 
  -- AUDIO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS);
 
END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_AUFF_AUDIO
authid current_user
AS
 
  --AUDIO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getEncoding(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getNumberOfChannels(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSamplingRate(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSampleSize(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getAudioDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDAudio,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2) RETURN VARCHAR2;
  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB);
 
  -- AUDIO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS);
 
END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_DEFAULT_AUDIO 
authid current_user
AS
 
  --AUDIO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getEncoding(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getNumberOfChannels(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSamplingRate(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSampleSize(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getAudioDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDAudio,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2) RETURN VARCHAR2;
  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB);
 
  -- AUDIO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS);
 
END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_WAVE_AUDIO
authid current_user
AS
 
  --AUDIO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getEncoding(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getNumberOfChannels(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSamplingRate(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSampleSize(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getAudioDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDAudio,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2) RETURN VARCHAR2;
  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB);
 
  -- AUDIO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS);
 
END;
/
show errors;


CREATE OR REPLACE PACKAGE ORDX_MPGA_AUDIO
authid current_user
AS
 
  --AUDIO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getEncoding(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getNumberOfChannels(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSamplingRate(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getSampleSize(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN VARCHAR2;
  FUNCTION  getAudioDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDAudio)
                   RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDAudio,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2) RETURN VARCHAR2;
  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB);
 
  -- AUDIO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS);
 
END;
/
show errors;


CREATE OR REPLACE PACKAGE ORDX_ASF_AUDIO
authid current_user
AS
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDAudio,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2) RETURN VARCHAR2;
  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB);
 
  -- AUDIO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS); 
END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_MP4_AUDIO
authid current_user
AS
  --AUDIO ATTRIBUTES ACCESSORS
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDAudio,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2) RETURN VARCHAR2;
  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB);
 
  -- AUDIO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS); 
END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_RMFF_AUDIO
authid current_user
AS
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDAudio,
                          setComments IN NUMBER := 0);

  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDAudio) 
                   RETURN NUMBER;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDAudio,
                         name IN VARCHAR2) RETURN VARCHAR2;
  -- must return name=value; name=value; ...  pairs

  PROCEDURE getAllAttributes(ctx IN OUT RAW,
                             obj IN ORDSYS.ORDAudio,
                             attributes IN OUT NOCOPY CLOB);
 
  -- AUDIO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDAudio,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS); 
END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_DEFAULT_VIDEO 
authid current_user
AS

 
  --VIDEO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
                   RETURN VARCHAR2;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         name IN VARCHAR2) RETURN VARCHAR2;

  PROCEDURE getFrameSize(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         width OUT INTEGER,
                         height OUT INTEGER);

  FUNCTION  getFrameResolution(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getFrameRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getVideoDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getNumberOfFrames(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;

  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN VARCHAR2;

  FUNCTION  getNumberOfColors(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;

  FUNCTION  getBitRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDVideo,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW,obj IN OUT NOCOPY ORDSYS.ORDVideo) 
  RETURN NUMBER;

  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW, 
                             obj IN ORDSYS.ORDVideo,
                             attributes IN OUT NOCOPY CLOB);
 
  -- VIDEO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDVideo,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
				 result OUT RAW)
             RETURN RAW;
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameResolution, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getVideoDuration, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfFrames, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfColors, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getBitRate, WNDS, WNPS, RNDS, RNPS);

END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_AVI_VIDEO 
authid current_user
AS

 
  --VIDEO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
                   RETURN VARCHAR2;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         name IN VARCHAR2) RETURN VARCHAR2;

  PROCEDURE getFrameSize(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         width OUT INTEGER,
                         height OUT INTEGER);

  FUNCTION  getFrameResolution(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getFrameRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getVideoDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getNumberOfFrames(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;

  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN VARCHAR2;

  FUNCTION  getNumberOfColors(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;

  FUNCTION  getBitRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDVideo,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDVideo) 
  RETURN NUMBER;

  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW, 
                             obj IN ORDSYS.ORDVideo,
                             attributes IN OUT NOCOPY CLOB);
 
  -- VIDEO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDVideo,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
				 result OUT RAW)
             RETURN RAW;
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameResolution, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getVideoDuration, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfFrames, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfColors, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getBitRate, WNDS, WNPS, RNDS, RNPS);

END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_MPEG_VIDEO 
authid current_user
AS
 
  --VIDEO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
                   RETURN VARCHAR2;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         name IN VARCHAR2) RETURN VARCHAR2;

  PROCEDURE getFrameSize(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         width OUT INTEGER,
                         height OUT INTEGER);

  FUNCTION  getFrameResolution(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getFrameRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getVideoDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getNumberOfFrames(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;

  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN VARCHAR2;

  FUNCTION  getNumberOfColors(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;

  FUNCTION  getBitRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;

  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDVideo,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDVideo) 
  RETURN NUMBER;

  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW, 
                             obj IN ORDSYS.ORDVideo,
                             attributes IN OUT NOCOPY CLOB);
 
  -- VIDEO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDVideo,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
				 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameResolution, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getVideoDuration, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfFrames, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfColors, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getBitRate, WNDS, WNPS, RNDS, RNPS);

END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_MOOV_VIDEO 
authid current_user
AS

 
  --VIDEO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
                   RETURN VARCHAR2;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         name IN VARCHAR2) RETURN VARCHAR2;

  PROCEDURE getFrameSize(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         width OUT INTEGER,
                         height OUT INTEGER);

  FUNCTION  getFrameResolution(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getFrameRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getVideoDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getNumberOfFrames(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;

  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN VARCHAR2;

  FUNCTION  getNumberOfColors(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;

  FUNCTION  getBitRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDVideo,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDVideo) 
  RETURN NUMBER;

  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW, 
                             obj IN ORDSYS.ORDVideo,
                             attributes IN OUT NOCOPY CLOB);
 
  -- VIDEO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDVideo,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
				 result OUT RAW)
             RETURN RAW;
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameResolution, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getVideoDuration, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfFrames, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfColors, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getBitRate, WNDS, WNPS, RNDS, RNPS);

END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_RMFF_VIDEO 
authid current_user
AS

 
  --VIDEO ATTRIBUTES ACCESSORS
  FUNCTION  getFormat(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
                   RETURN VARCHAR2;

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         name IN VARCHAR2) RETURN VARCHAR2;

  PROCEDURE getFrameSize(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         width OUT INTEGER,
                         height OUT INTEGER);

  FUNCTION  getFrameResolution(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getFrameRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getVideoDuration(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;
  FUNCTION  getNumberOfFrames(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo) 
            RETURN INTEGER;

  FUNCTION  getCompressionType(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN VARCHAR2;

  FUNCTION  getNumberOfColors(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;

  FUNCTION  getBitRate(ctx IN OUT RAW, obj IN ORDSYS.ORDVideo)
            RETURN INTEGER;
  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDVideo,
                          setComments IN NUMBER := 0);
  FUNCTION checkProperties(ctx IN OUT RAW, obj IN OUT NOCOPY ORDSYS.ORDVideo) 
  RETURN NUMBER;

  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW, 
                             obj IN ORDSYS.ORDVideo,
                             attributes IN OUT NOCOPY CLOB);
 
  -- VIDEO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDVideo,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
				 result OUT RAW)
             RETURN RAW;
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameSize, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameResolution, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getFrameRate, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getVideoDuration, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfFrames, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getNumberOfColors, WNDS, WNPS, RNDS, RNPS);
  PRAGMA RESTRICT_REFERENCES(getBitRate, WNDS, WNPS, RNDS, RNPS);

END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_ASF_VIDEO 
authid current_user
AS

  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         name IN VARCHAR2) RETURN VARCHAR2;

  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDVideo,
                          setComments IN NUMBER := 0);

  FUNCTION checkProperties(ctx IN OUT RAW,obj IN OUT NOCOPY ORDSYS.ORDVideo) 
  RETURN NUMBER;

  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW, 
                             obj IN ORDSYS.ORDVideo,
                             attributes IN OUT NOCOPY CLOB);
 
  -- VIDEO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDVideo,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
END;
/
show errors;

CREATE OR REPLACE PACKAGE ORDX_MP4_VIDEO 
authid current_user
AS

  -- VIDEO ATTRIBUTES ACCESSORS
  FUNCTION  getAttribute(ctx IN OUT RAW,
                         obj IN ORDSYS.ORDVideo,
                         name IN VARCHAR2) RETURN VARCHAR2;

  PROCEDURE setProperties(ctx IN OUT RAW, 
                          obj IN OUT NOCOPY ORDSYS.ORDVideo,
                          setComments IN NUMBER := 0);

  FUNCTION checkProperties(ctx IN OUT RAW,obj IN OUT NOCOPY ORDSYS.ORDVideo) 
  RETURN NUMBER;

  -- must return name=value; name=value; ...  pairs
  PROCEDURE getAllAttributes(ctx IN OUT RAW, 
                             obj IN ORDSYS.ORDVideo,
                             attributes IN OUT NOCOPY CLOB);
 
  -- VIDEO PROCESSING METHODS
  FUNCTION  processCommand(
                                 ctx       IN OUT RAW,
                                 obj       IN OUT NOCOPY ORDSYS.ORDVideo,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result OUT RAW)
             RETURN RAW;

  PRAGMA RESTRICT_REFERENCES(getAttribute, WNDS, WNPS, RNDS, RNPS);
END;
/
show errors;

--reload 101 ORDX_FILE_SOURCE

CREATE OR REPLACE PACKAGE ORDX_FILE_SOURCE 
authid current_user
AS
 
  -- functions/procedures
  FUNCTION processCommand(
                    obj  IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx  IN OUT RAW,
                    cmd  IN VARCHAR2,
                    arglist IN VARCHAR2,
                    result  OUT RAW)
           RETURN RAW;

  PROCEDURE import( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx      IN OUT RAW,
                    mimetype OUT VARCHAR2,
                    format   OUT VARCHAR2);

  PROCEDURE import( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx      IN OUT RAW,
                    dlob     IN OUT NOCOPY BLOB,
                    mimetype OUT VARCHAR2,
                    format   OUT VARCHAR2);

  PROCEDURE importFrom( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                        ctx      IN OUT RAW,
                        mimetype OUT VARCHAR2,
                        format   OUT VARCHAR2,
                        loc      IN VARCHAR2,
                        name     IN VARCHAR2);

  PROCEDURE importFrom( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                        ctx      IN OUT RAW,
                        dlob     IN OUT NOCOPY BLOB,
                        mimetype OUT VARCHAR2,
                        format   OUT VARCHAR2,
                        loc      IN VARCHAR2,
                        name     IN VARCHAR2);
 
  PROCEDURE export( obj  IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx  IN OUT RAW,
                    slob IN OUT NOCOPY BLOB,
                    loc  IN VARCHAR2,
                    name IN VARCHAR2);
 
  FUNCTION  getContentLength(obj  IN ORDSYS.ORDSource,
                             ctx  IN OUT RAW) 
            RETURN INTEGER;
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS);

  FUNCTION  getSourceAddress(obj  IN ORDSYS.ORDSource,
                             ctx  IN OUT RAW,
                             userData IN VARCHAR2) 
            RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES(getSourceAddress, WNDS, WNPS, RNDS, RNPS);

  FUNCTION open(obj IN OUT NOCOPY ORDSYS.ORDSource,
                userArg IN RAW,
                ctx OUT RAW) RETURN INTEGER;
  FUNCTION close(obj IN OUT NOCOPY ORDSYS.ORDSource,
                 ctx IN OUT RAW) RETURN INTEGER;
  FUNCTION trim(obj    IN OUT NOCOPY ORDSYS.ORDSource,
                       ctx IN OUT RAW,
                       newlen IN INTEGER) RETURN INTEGER;
 
  PROCEDURE read(obj      IN OUT NOCOPY ORDSYS.ORDSource,
                 ctx      IN OUT RAW,
                 startPos IN INTEGER,
                 numBytes IN OUT INTEGER,
                 buffer   OUT RAW);
 
  PROCEDURE write(obj      IN OUT NOCOPY ORDSYS.ORDSource,
                  ctx      IN OUT RAW,
                  startPos IN INTEGER,
                  numBytes IN OUT INTEGER,
                  buffer   IN RAW);

--
--  Procedures below this comment are not part of the documented
--  ORDSource Plug-in API.  They are support routines which may
--  be called from the above procedures.
--

  PROCEDURE writeBlobToFile(
		data IN BLOB,
		dirPath IN VARCHAR2,
                fileName IN VARCHAR2,
                exceptionCode OUT NUMBER);
  PRAGMA RESTRICT_REFERENCES(writeBlobToFile, WNDS, WNPS, RNDS, RNPS);

END ORDX_FILE_SOURCE;
/
show errors;

-- reload 101 ORDX_HTTP_SOURCE

CREATE OR REPLACE PACKAGE ORDX_HTTP_SOURCE 
authid current_user
AS

  -- functions/procedures
  FUNCTION processCommand(
                    obj  IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx  IN OUT RAW,
                    cmd  IN VARCHAR2,
                    arglist IN VARCHAR2,
                    result  OUT RAW)
           RETURN RAW;
 
  PROCEDURE import( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx      IN OUT RAW,
                    mimetype OUT VARCHAR2,
                    format   OUT VARCHAR2);

  PROCEDURE import( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx      IN OUT RAW,
                    dlob     IN OUT NOCOPY BLOB,
                    mimetype OUT VARCHAR2,
                    format   OUT VARCHAR2);

  PROCEDURE importFrom( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                        ctx      IN OUT RAW,
                        mimetype OUT VARCHAR2,
                        format   OUT VARCHAR2,
                        loc      IN VARCHAR2,
                        name     IN VARCHAR2);

  PROCEDURE importFrom( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                        ctx      IN OUT RAW,
                        dlob     IN OUT NOCOPY BLOB,
                        mimetype OUT VARCHAR2,
                        format   OUT VARCHAR2,
                        loc      IN VARCHAR2,
                        name     IN VARCHAR2);
 
  PROCEDURE export( obj  IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx  IN OUT RAW,
                    dlob IN OUT NOCOPY BLOB,
                    loc  IN VARCHAR2,
                    name IN VARCHAR2);
 
  FUNCTION  getContentLength(obj  IN ORDSYS.ORDSource,
                             ctx  IN OUT RAW) 
            RETURN INTEGER;
  -- TRUST added to enable use of new UTL_HTTP API
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS, TRUST);
 
  FUNCTION  getSourceAddress(obj  IN ORDSYS.ORDSource,
                             ctx  IN OUT RAW,
                             userData IN VARCHAR2) 
            RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES(getSourceAddress, WNDS, WNPS, RNDS, RNPS);

  FUNCTION open(obj IN OUT NOCOPY ORDSYS.ORDSource,
                userArg IN RAW,
                ctx OUT RAW) RETURN INTEGER;
  FUNCTION close(obj IN OUT NOCOPY ORDSYS.ORDSource,
                 ctx IN OUT RAW) RETURN INTEGER;
  FUNCTION trim(obj    IN OUT NOCOPY ORDSYS.ORDSource,
                       ctx IN OUT RAW,
                       newlen IN INTEGER) RETURN INTEGER;
 
  PROCEDURE read(obj      IN OUT NOCOPY ORDSYS.ORDSource,
                 ctx      IN OUT RAW,
                 startPos IN INTEGER,
                 numBytes IN OUT INTEGER,
                 buffer   OUT RAW);
 
  PROCEDURE write(obj      IN OUT NOCOPY ORDSYS.ORDSource,
                  ctx      IN OUT RAW,
                  startPos IN INTEGER,
                  numBytes IN OUT INTEGER,
                  buffer   OUT RAW);

END ORDX_HTTP_SOURCE;
/
show errors;

-- Grant the privileges back to the functions and types that are part
-- of the image matching indextype implementation (those that haven't
-- been dropped).

alter session set current_schema="ORDSYS";

BEGIN
   EXECUTE IMMEDIATE
     'grant execute on ORDImgIdxMethods to public';
   EXECUTE IMMEDIATE
     'grant execute on ORDImageIndexStats to public';
END;
/

-- Drop Image Indexing components that were modified in 10.2 so they can
-- be reloaded in earlier versions to avoid PLS-00908, PLS-00114, PLS-00707
-- errors in the earlier version (bug 6809006).
--
-- This script also drops all user indexes of type ORDImageIndex.

DECLARE
  cursor imgidx_curs is select index_name, owner from all_indexes
    where index_type = 'DOMAIN' and ityp_name = 'ORDIMAGEINDEX';
  index_name VARCHAR2(30);
  index_owner VARCHAR2(30);
  idxcurs integer;

BEGIN
-- 
-- Drop user indexes of type ORDImageIndex
-- 
    idxcurs := dbms_sql.open_cursor;
    open imgidx_curs;
    loop
        begin
          fetch imgidx_curs into index_name, index_owner;
          exit when imgidx_curs%NOTFOUND;

          -- Note: these drop statements are executed immediately upon parse
          -- thus the class name needs to be specified, but no execute is
          --  required
          --
          -- drop the domain index
          dbms_sql.parse(idxcurs, 'drop index ' || index_owner || '.' ||
                         index_name || ' force',
                         dbms_sql.native);
          -- drop associated table
          dbms_sql.parse(idxcurs, 'drop table ' || index_owner || '.' ||
                         index_name || '_FT$',
                         dbms_sql.native);
          exception when others then
            exit;
        end;
    end loop;
    close imgidx_curs;
    dbms_sql.close_cursor(idxcurs);
    begin
      EXECUTE IMMEDIATE 'drop indextype ordsys.ORDImageIndex';
    exception when others then
      null;
    end;
    begin
      EXECUTE IMMEDIATE 'drop type body ORDIMGIDXMethods';
    exception when others then
      null;
    end;
    begin
      EXECUTE IMMEDIATE 'drop operator IMGScore';
    exception when others then
      null;
    end;
    begin
      EXECUTE IMMEDIATE 'drop operator IMGSimilar';
    exception when others then
      null;
    end;
    begin
      EXECUTE IMMEDIATE 'drop function ScoreFunc';
    exception when others then
      null;
    end;
    begin
      EXECUTE IMMEDIATE 'drop function SimilarFunc';
    exception when others then
      null;
    end;
    begin
      EXECUTE IMMEDIATE 'drop type ORDImageIndexStats';
    exception when others then
      null;
    end;
    begin
      EXECUTE IMMEDIATE 'drop type ORDIMGIDXMethods';
    exception when others then
      null;
    end;

END;
/

--
-- Restore 10.1 ORDIMGIDXMethods type spec and ORDImageIndexStats since
-- they are not reloaded
--
CREATE OR REPLACE TYPE ORDIMGIDXMethods
   AUTHID CURRENT_USER
   AS OBJECT
   (
   scanctx RAW(4),

   STATIC FUNCTION ODCIGetInterfaces(ifclist OUT SYS.ODCIOBJECTLIST)
   RETURN NUMBER,

   STATIC FUNCTION IndexCreateFunc(origtablename VARCHAR2,
				   colname       VARCHAR2,
				   tablename     VARCHAR2,
				   schemaname    VARCHAR2)
   RETURN PLS_INTEGER,

   STATIC FUNCTION ODCIIndexCreate (ia    SYS.ODCIINDEXINFO,
				    parms VARCHAR2,
				    env   SYS.ODCIENV)
   RETURN NUMBER,

   STATIC FUNCTION ODCIIndexDrop (ia  SYS.ODCIINDEXINFO,
				  env SYS.ODCIEnv)
   RETURN NUMBER,

   STATIC FUNCTION ODCIIndexInsert(ia        SYS.ODCIINDEXINFO,
				   rid       VARCHAR2,
				   newsig IN ORDSYS.ORDImageSignature,
				   env       SYS.ODCIEnv)
   RETURN NUMBER,

   STATIC FUNCTION ODCIIndexUpdate(ia        SYS.ODCIINDEXINFO,
				   rid       VARCHAR2,
				   oldsig IN ORDSYS.ORDImageSignature,
				   newsig IN ORDSYS.ORDImageSignature,
				   env       SYS.ODCIEnv)
   RETURN NUMBER,

   STATIC FUNCTION ODCIIndexDelete(ia        SYS.ODCIINDEXINFO,
				   rid       VARCHAR2,
                                   oldsig IN ORDSYS.ORDImageSignature,
				   env       SYS.ODCIEnv)
   RETURN NUMBER,

   STATIC FUNCTION ODCIIndexStart(sctx IN OUT ORDSYS.ORDIMGIDXMETHODS,
				  ia SYS.ODCIINDEXINFO,
				  pi SYS.ODCIPREDINFO,
				  qi SYS.ODCIQUERYINFO,
				  strt NUMBER,
				  stop NUMBER,
				  querysig     IN ORDSYS.ORDImageSignature,
				  weightstring IN VARCHAR2, 
				  threshold    IN FLOAT,
				  env              SYS.ODCIEnv)
   RETURN NUMBER,

   MEMBER FUNCTION ODCIIndexFetch(nrows IN NUMBER,
  		  rids OUT SYS.ODCIRIDLIST,
		  env      SYS.ODCIEnv)
   RETURN NUMBER
   IS Language C
   NAME "kidiidx_fetch" LIBRARY ORDIMLIBT
   WITH CONTEXT
   PARAMETERS(
             CONTEXT,
             self,
             self     INDICATOR STRUCT,
             nrows,
             nrows    INDICATOR,
             rids,
             rids     INDICATOR,
	     env,
	     env      INDICATOR STRUCT,
             RETURN   OCINumber
  ),

   MEMBER FUNCTION ODCIIndexClose(env SYS.ODCIEnv)
   RETURN NUMBER
   IS Language C
   NAME "kidiidx_close" LIBRARY ORDIMLIBT
   WITH CONTEXT
   PARAMETERS(
	     CONTEXT,
	     self,
	     self     INDICATOR STRUCT,
	     env,
	     env      INDICATOR STRUCT,
	     RETURN   OCINumber
   )
		 
   );
/
show errors;

grant execute on ORDImgIdxMethods to public;



CREATE OR REPLACE TYPE ORDImageIndexStats 
   AUTHID CURRENT_USER
   AS OBJECT
   (
     dummy NUMBER(6),

     STATIC FUNCTION ODCIGetInterfaces(ifclist OUT SYS.ODCIOBJECTLIST)
     RETURN NUMBER,

     STATIC FUNCTION ODCIStatsCollect(ia      SYS.ODCIIndexInfo,
                                      options SYS.ODCIStatsOptions,
                                      stats   OUT RAW,
                                      env     SYS.ODCIEnv)
     RETURN NUMBER,

     STATIC FUNCTION ODCIStatsDelete(ia       SYS.ODCIIndexInfo,
                                     stats    OUT RAW,
                                     env      SYS.ODCIEnv)
     RETURN NUMBER,

     STATIC FUNCTION ODCIStatsSelectivity(pred       SYS.ODCIPredInfo,
                                          sel        OUT NUMBER,
                                          args       SYS.ODCIARGDESCLIST,
                                          strt       NUMBER,
                                          stop       NUMBER,
                                          sigcol     ORDSYS.ORDImageSignature,
                                          qsig       ORDSYS.ORDImageSignature,
                                          wstr       VARCHAR2,
                                          thresh     NUMBER,
                                          env        SYS.ODCIEnv)
     RETURN NUMBER,

     PRAGMA RESTRICT_REFERENCES(ODCIStatsSelectivity, WNDS, WNPS)

);
/
show errors;
         
grant execute on ORDImageIndexStats to public;


-- executed as ORDSYS
EXECUTE dbms_registry.downgraded('ORDIM', '10.1.0');

alter session set current_schema="SYS";
