Rem Copyright (c) 2006, 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      ime102.sql
Rem
Rem    DESCRIPTION
Rem      runs as SYS
Rem
Rem      Internal downgrade script for Oracle Multimedia to 10.2.0.
Rem
Rem    NOTES
Rem      This script deletes all objects and types that have been added 
Rem       between 10.2 and 11.1. After this script is run, the imrelod.sql script
Rem       is run to reload 10.2 Oracle Multimedia in the downgraded database.
Rem

WHENEVER SQLERROR EXIT;

REM 
REM Make sure Oracle Multimedia schemas exist.
REM
REM Note - it is forbidden to exit in a downgrade script.  
REM However, it is an assumed impossible condition that we exist in the 
REM registry (which is the only way this script should be called) and our
REM schemas don't exist.  Therefore, we will exit here if our schemas don't
REM exist so we can figure out how we got in this situation.
REM 

@@imchksch.sql

WHENEVER SQLERROR CONTINUE;
alter session set current_schema="ORDSYS";
EXECUTE dbms_registry.downgrading('ORDIM', 'Oracle interMedia');

REM Invoke 11.1 script to go from 11.2 to 11.1 (downgrade scripts run as SYS)
alter session set current_schema="SYS";
@@ime111.sql

REM
REM Set component name back to Oracle interMedia
REM 
alter session set current_schema="ORDSYS";
EXECUTE dbms_registry.downgrading('ORDIM', 'Oracle interMedia');

-- Revoke privs needed to load native library 
-- enable SYS
call dbms_java.grant_permission
     ('SYS', 
      'SYS:oracle.aurora.rdbms.security.PolicyTablePermission', 
      '0:java.lang.RuntimePermission#loadLibrary.ordim11', 
      null);
call dbms_java.grant_permission
     ('SYS', 
      'SYS:oracle.aurora.rdbms.security.PolicyTablePermission', 
      '0:java.lang.RuntimePermission#loadLibrary.oraordim11', 
      null);

-- revoke from ORDSYS
call dbms_java.revoke_permission
     ('ORDSYS', 'SYS:java.lang.RuntimePermission', 
      'loadLibrary.ordim11', '');
call dbms_java.revoke_permission
     ('ORDSYS', 'SYS:java.lang.RuntimePermission', 
      'loadLibrary.oraordim11', '');
call dbms_java.revoke_permission
     ('ORDSYS', 'SYS:java.util.logging.LoggingPermission',
      'control','');
--revoke from SYS
call dbms_java.revoke_permission
     ('SYS', 
      'SYS:oracle.aurora.rdbms.security.PolicyTablePermission', 
      '0:java.lang.RuntimePermission#loadLibrary.ordim11', 
      null);
call dbms_java.revoke_permission
     ('SYS', 
      'SYS:oracle.aurora.rdbms.security.PolicyTablePermission', 
      '0:java.lang.RuntimePermission#loadLibrary.oraordim11', 
      null);

--
-- Remove DICOM
--
revoke execute on dbms_lock from ordsys;

-- Drop public synonym to public views
drop PUBLIC SYNONYM orddcm_documents;
drop PUBLIC SYNONYM orddcm_document_types;
drop PUBLIC SYNONYM orddcm_document_refs;
drop PUBLIC SYNONYM ORDDCM_CONFORMANCE_VLD_MSGS;
drop PUBLIC SYNONYM ORDDCM_CONSTRAINT_NAMES;

-- Drop Tables and Views with associated sequences, indexes and types
drop view ORDDCM_DOCUMENT_TYPES;
drop view ORDDCM_DOCUMENTS;
drop view ORDDCM_CONSTRAINT_NAMES;
drop view ORDDCM_DOCUMENT_REFS;
drop view ORDDCM_CONFORMANCE_VLD_MSGS;

---------------drop _usr views
drop VIEW ORDDCM_DOCS_USR;
drop VIEW ORDDCM_DOC_REFS_USR;
drop VIEW ORDDCM_STD_ATTRS_USR; 
drop VIEW ORDDCM_PRV_ATTRS_USR; 
drop VIEW ORDDCM_DICT_ATTRS_USR; 
drop VIEW ORDDCM_MAPPING_DOCS_USR; 
drop VIEW ORDDCM_MAPPED_PATHS_USR; 
drop VIEW ORDDCM_ANON_RULES_USR; 
drop VIEW ORDDCM_ANON_ATTRS_USR; 
drop VIEW ORDDCM_RT_PREF_PARAMS_USR; 
drop VIEW ORDDCM_UID_DEFS_USR; 
drop view ORDDCM_CT_PRED_USR;
drop view ORDDCM_CT_PRED_OPRD_USR;
drop view ORDDCM_CT_PRED_SET_USR;
drop view ORDDCM_CT_PRED_PAR_USR;
drop view ORDDCM_CT_ACTION_USR;


---------- drop _wrk tables
-- drop table also drops assoc indexes
drop table ORDDCM_CT_ACTION_WRK purge;
drop table ORDDCM_CT_PRED_PAR_WRK purge;
drop table ORDDCM_CT_MACRO_PAR_WRK purge;
drop table ORDDCM_CT_PRED_SET_WRK purge;
drop table ORDDCM_CT_PRED_OPRD_WRK purge;
drop table ORDDCM_CT_PRED_WRK purge;
drop table ORDDCM_DATA_MODEL_WRK purge;
drop table ORDDCM_UID_DEFS_WRK purge;
drop table ORDDCM_RT_PREF_PARAMS_WRK purge;
drop table ORDDCM_ANON_ATTRS_WRK purge;
drop table ORDDCM_ANON_RULES_WRK purge;
drop table ORDDCM_MAPPED_PATHS_WRK purge;
drop table ORDDCM_MAPPING_DOCS_WRK purge;
drop table ORDDCM_CT_DAREFS_WRK purge;
drop table ORDDCM_DICT_ATTRS_WRK purge;
drop table ORDDCM_PRV_ATTRS_WRK purge;
drop table ORDDCM_STD_ATTRS_WRK purge;
drop table ORDDCM_DOC_REFS_WRK purge;
drop table ORDDCM_DOCS_WRK purge;

-------------- drop global temporary  tables
--- this does not need purge option
DROP TABLE ORDDCM_CT_ACTION_TMP;
DROP TABLE ORDDCM_CT_PRED_PAR_TMP;
DROP TABLE ORDDCM_CT_PRED_SET_TMP;
DROP TABLE ORDDCM_CT_PRED_OPRD_TMP;
DROP TABLE ORDDCM_CT_PRED_TMP;
DROP TABLE ORDDCM_UID_DEFS_TMP;
DROP TABLE ORDDCM_RT_PREF_PARAMS_TMP;
DROP TABLE ORDDCM_ANON_ATTRS_TMP;
DROP TABLE ORDDCM_ANON_RULES_TMP;
DROP TABLE ORDDCM_MAPPED_PATHS_TMP;
DROP TABLE ORDDCM_MAPPING_DOCS_TMP;
DROP TABLE ORDDCM_DICT_ATTRS_TMP;
DROP TABLE ORDDCM_PRV_ATTRS_TMP;
DROP TABLE ORDDCM_STD_ATTRS_TMP;
DROP TABLE ORDDCM_DOC_REFS_TMP;
DROP TABLE ORDDCM_DOCS_TMP;

------------- drop sequences
drop sequence ORDDCM_DOCS_ID_SEQ;
drop sequence orddcm_std_a_sa_id_SEQ;
drop sequence orddcm_prv_a_pa_id_SEQ;
drop sequence orddcm_dict_a_da_id_SEQ;
drop sequence orddcm_mpd_p_mpid_seq;
drop sequence orddcm_anon_attrs_seq;
drop sequence orddcm_rt_pref_p_ppid_seq;
drop sequence orddcm_uid_defs_udid_seq;
drop sequence orddcm_data_model_SEQ;
drop sequence ORDDCM_CT_PRED_SEQ;
drop sequence ORDDCM_CT_PRED_SET_SEQ;


---------- drop  master tables 
-- drop table also drops assoc indexes
DROP TABLE ORDDCM_CT_VLD_MSG purge;
DROP TABLE ORDDCM_CT_ACTION purge;
DROP TABLE ORDDCM_CT_PRED_PAR purge;
DROP TABLE ORDDCM_CT_MACRO_PAR purge;
DROP TABLE ORDDCM_CT_PRED_SET purge;
DROP TABLE ORDDCM_CT_PRED_OPRD purge;
DROP TABLE ORDDCM_CT_PRED purge;
drop table orddcm_data_model purge;
drop table orddcm_uid_defs purge;
drop table orddcm_RT_pref_params purge;
drop table orddcm_prefs_lookup purge;
drop table orddcm_anon_attrs purge;
drop table orddcm_anon_rules purge;
drop table orddcm_anon_rule_types purge;
drop table orddcm_anon_action_types purge;
drop table orddcm_mapped_paths purge;
drop table orddcm_mapping_docs purge;
drop table orddcm_ct_darefs purge;
drop table  orddcm_dict_attrs purge;
drop table orddcm_prv_attrs purge;
drop table orddcm_std_attrs purge;
drop table orddcm_vr_dt_map purge;
drop table orddcm_doc_refs purge;
drop table orddcm_docs purge; 
drop table orddcm_install_docs purge;
drop table orddcm_doc_types purge;

---------drop types
drop type ORD_STR_LIST force;
drop type ORD_NUM_LIST force;

-- Remove Admin role
drop role ORDADMIN;

-- Uninstall common error package
drop package ORDError;

-- Drop DICOM packages
drop package ord_dicom_pkg;
drop package ord_datasource_pkg;
drop package ord_dicom;
drop package ord_dicom_ct;
drop package ord_dicom_admin_prv;
drop package ord_dicom_admin;

-- Drop DICOM types
drop type orddicom force;
drop type orddatasource force;

-- Drop synonyms
drop public synonym ord_dicom;
drop public synonym orddatasource;
drop public synonym orddicom;
drop public synonym ord_dicom_admin;

-- Drop DICOM java library
call dbms_java.dropjava('-synonym -schema ORDSYS ord/jlib/ordimdcm.jar');

--delete 11g dicom schemas
@@imdrg102.sql

--
-- Drop the getcontentlength methods in orddoc  
-- in order to reload the orddoc spec. otherwise got 22314 error.
--
begin
      execute immediate 'ALTER TYPE ORDDoc 
        DROP MEMBER FUNCTION getContentLength 
            RETURN INTEGER CASCADE';
end;
/
show errors;

--
-- reload the spec from 10.2
--
ALTER TYPE ORDDoc
REPLACE 
authid current_user
AS OBJECT
(
   source   ORDSYS.ORDSource,
   format   VARCHAR2(80),
   mimeType VARCHAR2(80),
   contentLength integer,
   -- a place holder for annotations stored in the above attributes +
   -- anything which is not covered by the above fields, in a XML format.
   comments CLOB,
  -- CONSTRUCTORS
  STATIC FUNCTION init RETURN ORDDoc,
  STATIC FUNCTION init( srcType IN VARCHAR2,
                        srcLocation IN VARCHAR2,
                        srcName IN VARCHAR2 ) RETURN ORDDoc,
  -- MIMETYPE RELATED METHODS
  MEMBER FUNCTION  getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setMimeType(mime IN VARCHAR2),
  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setUpdateTime(SELF IN OUT NOCOPY ORDDoc,
                                 current_time DATE),
  -- FORMAT RELATED METHODS
  MEMBER FUNCTION  getFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setFormat(knownFormat IN VARCHAR2),
  -- SOURCE RELATED METHODS
  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDDoc),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDDoc),
  MEMBER PROCEDURE setSource(source_type     IN VARCHAR2,
                             source_location IN VARCHAR2,
                             source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSource RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSource, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDDoc, ctx IN OUT RAW,
				 setComments IN BOOLEAN),
  MEMBER FUNCTION getBFILE RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFILE, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE import(SELF IN OUT NOCOPY ORDDoc,
			  ctx IN OUT RAW, set_prop IN BOOLEAN),
  MEMBER PROCEDURE importFrom(SELF IN OUT NOCOPY ORDDoc,
			      ctx IN OUT RAW,
			      source_type IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name IN VARCHAR2,
			      set_prop IN BOOLEAN),
  MEMBER PROCEDURE export( SELF IN OUT NOCOPY ORDDoc,
                          ctx      IN OUT RAW,
			  source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  MEMBER FUNCTION openSource(SELF IN OUT NOCOPY ORDDoc,
                             userArg IN RAW,
			     ctx OUT RAW) RETURN INTEGER,
  MEMBER FUNCTION closeSource(SELF IN OUT NOCOPY ORDDoc,
		      	      ctx IN OUT RAW)
  RETURN INTEGER,
  MEMBER FUNCTION trimSource(SELF IN OUT NOCOPY ORDDoc, ctx IN OUT RAW,
                             newlen IN INTEGER) RETURN INTEGER,
  MEMBER PROCEDURE readFromSource(SELF IN OUT NOCOPY ORDDoc,
				  ctx IN OUT RAW,
                                  startPos IN INTEGER,
                                  numBytes IN OUT INTEGER,
                                  buffer OUT RAW),
  MEMBER PROCEDURE writeToSource(SELF IN OUT NOCOPY ORDDoc,
				 ctx IN OUT RAW,
                                 startPos IN INTEGER,
                                 numBytes IN OUT INTEGER,
                                 buffer IN RAW),
  MEMBER FUNCTION  getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
  -- This method will copy data in the LOB provided, if the data is not
  -- stored in internal LOB it will be imported and returned in the LOB
  -- provided
  MEMBER PROCEDURE getContentInLob(SELF IN OUT NOCOPY ORDDoc,
                                   ctx IN OUT RAW,
                                   dest_lob IN OUT NOCOPY BLOB,
                                   mimeType OUT VARCHAR2,
                                   format OUT VARCHAR2),
  MEMBER FUNCTION  getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDDoc),
 -- source related methods
  MEMBER FUNCTION  processSourceCommand(
                            SELF      IN OUT NOCOPY ORDDoc,
                            ctx       IN OUT RAW,
                            cmd       IN VARCHAR2,
                            arguments IN VARCHAR2,
                            result    OUT RAW)
                   RETURN RAW,
  --
  --
  -- Static Methods for the relational functional interface
  STATIC PROCEDURE export(ctx             IN OUT RAW,
                          local_data      IN BLOB,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2,
                              format          OUT VARCHAR2,
                              mime_type       OUT VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 docBlob        IN BLOB,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format         IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx              IN OUT RAW,
                                 docBlob          IN BLOB,
                                 attributes       IN OUT NOCOPY CLOB,
                                 mimeType         OUT VARCHAR2,
                                 format           IN OUT VARCHAR2,
                                 contentLength    OUT INTEGER),
 --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 docBfile       IN OUT NOCOPY BFILE,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format         IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx                IN OUT RAW,
                                 docBfile           IN OUT NOCOPY BFILE,
                                 attributes         IN OUT NOCOPY CLOB,
                                 mimeType           OUT VARCHAR2,
                                 format             IN OUT VARCHAR2,
                                 contentLength      OUT INTEGER)
);
show errors;

--
-- Drop the getcontentlength methods in ordvideo  
-- in order to reload the ordvideo spec. otherwise got 22314 error.
--
begin
      execute immediate 'ALTER TYPE ORDVideo 
        DROP MEMBER FUNCTION getContentLength( ctx IN OUT RAW) 
            RETURN INTEGER CASCADE';

      execute immediate 'ALTER TYPE ORDVideo 
        DROP MEMBER FUNCTION getContentLength 
            RETURN INTEGER CASCADE';

end;
/
show errors;

--
-- reload the 10.2 ordvideo spec. to add the pragma back
--
ALTER TYPE ORDVideo
REPLACE 
authid current_user
AS OBJECT
(
---------------------------
-- ATTRIBUTES
---------------------------
  description VARCHAR2(4000),
  source      ORDSource,
  format      VARCHAR2(31),
  mimeType    VARCHAR2(4000),
  comments    CLOB,
--
--
---------------------------
-- Video Related Attributes
---------------------------
  width             INTEGER,
  height            INTEGER,
  frameResolution   INTEGER,
  frameRate         INTEGER,
  videoDuration     INTEGER,
  numberOfFrames    INTEGER,
  compressionType   VARCHAR2(4000),
  numberOfColors    INTEGER,
  bitRate           INTEGER,
--
--
  ---------------------------
  -- METHODS
  ---------------------------
  -- CONSTRUCTORS
  STATIC FUNCTION init RETURN ORDVideo,
  STATIC FUNCTION init( srcType IN VARCHAR2,
            srcLocation IN VARCHAR2,
            srcName IN VARCHAR2 ) RETURN ORDVideo,
  --
  --
  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setUpdateTime(SELF IN OUT NOCOPY ORDVideo, current_time DATE),
  --
  -- TITLE RELATED METHODS
  MEMBER PROCEDURE setDescription(SELF IN OUT NOCOPY ORDVideo, user_description IN VARCHAR2),
  MEMBER FUNCTION  getDescription RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getDescription, WNDS, WNPS, RNDS, RNPS),
  --
  -- MIMETYPE RELATED METHODS
  MEMBER FUNCTION  getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setMimeType(SELF IN OUT NOCOPY ORDVideo, mime IN VARCHAR2),
  --
  --
  -- SOURCE RELATED METHODS
  MEMBER FUNCTION  processSourceCommand(
                            SELF      IN OUT NOCOPY ORDVideo,
                            ctx       IN OUT RAW,
                            cmd       IN VARCHAR2,
                            arguments IN VARCHAR2,
                            result    OUT RAW)
                   RETURN RAW,
  MEMBER FUNCTION  getSourceObject RETURN ORDSource,
  PRAGMA RESTRICT_REFERENCES(getSourceObject, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDVideo),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDVideo),
  MEMBER PROCEDURE setSource(SELF IN OUT NOCOPY ORDVideo,
                             source_type     IN VARCHAR2,
                             source_location IN VARCHAR2,
                             source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSource RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSource, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE import(SELF IN OUT NOCOPY ORDVideo,
                          ctx IN OUT RAW),
  MEMBER PROCEDURE importFrom(SELF IN OUT NOCOPY ORDVideo,
                          ctx IN OUT RAW,
                          source_type IN VARCHAR2,
                          source_location IN VARCHAR2,
                      source_name IN VARCHAR2),
  MEMBER PROCEDURE export(SELF IN OUT NOCOPY ORDVideo,
                          ctx      IN OUT RAW,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  MEMBER FUNCTION  getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getContentLength(ctx IN OUT RAW) RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
  --
  -- This method will copy data in the LOB provided, if the data is not
  -- stored in internal LOB it will be imported and returned in the LOB
  -- provided
  MEMBER PROCEDURE getContentInLob(SELF IN OUT NOCOPY ORDVideo,
                                   ctx IN OUT RAW,
                                   dest_lob IN OUT NOCOPY BLOB,
                                   mimeType OUT VARCHAR2,
                                   format OUT VARCHAR2),
  --
  MEMBER FUNCTION  getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDVideo),
  --
  --
  -- FILE OPERATIONS on the source
  MEMBER FUNCTION openSource(SELF IN OUT NOCOPY ORDVideo, 
                             userArg IN RAW,
                             ctx OUT RAW) 
  RETURN INTEGER,
  --
  MEMBER FUNCTION closeSource(SELF IN OUT NOCOPY ORDVideo, ctx IN OUT RAW) 
  RETURN INTEGER,
  --
  MEMBER FUNCTION trimSource(SELF IN OUT NOCOPY ORDVideo, ctx IN OUT RAW,
                             newlen IN INTEGER) RETURN INTEGER,
  --
  MEMBER PROCEDURE readFromSource(SELF IN OUT NOCOPY ORDVideo,
                                  ctx IN OUT RAW,
                                  startPos IN INTEGER,
                                  numBytes IN OUT INTEGER,
                                  buffer OUT RAW),
  --
  MEMBER PROCEDURE writeToSource(SELF IN OUT NOCOPY ORDVideo,
                                 ctx IN OUT RAW,
                                 startPos IN INTEGER,
                                 numBytes IN OUT INTEGER,
                                 buffer IN RAW),
  --
  --
  --
  -- COMMENT RELATED METHODS
  MEMBER PROCEDURE appendToComments(SELF IN OUT NOCOPY ORDVideo,
                                    amount IN BINARY_INTEGER,
                                    buffer IN VARCHAR2),
  MEMBER PROCEDURE writeToComments(SELF IN OUT NOCOPY ORDVideo,
                                   offset IN INTEGER,
                                   amount IN BINARY_INTEGER,
                                   buffer IN VARCHAR2),
  MEMBER FUNCTION readFromComments(offset IN INTEGER,
                                   amount IN BINARY_INTEGER := 32767)
         RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(readFromComments, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION locateInComments(pattern IN VARCHAR2,
                                   offset IN INTEGER := 1,
                                   occurence IN INTEGER := 1)
         RETURN INTEGER,
  --
  MEMBER PROCEDURE trimComments(SELF IN OUT NOCOPY ORDVideo, newlen IN INTEGER),
  -- erase:
  MEMBER PROCEDURE eraseFromComments(SELF IN OUT NOCOPY ORDVideo,
                                     amount IN OUT NOCOPY INTEGER,
                                     offset IN            INTEGER := 1),
  --
  MEMBER PROCEDURE deleteComments(SELF IN OUT NOCOPY ORDVideo),
  --
  MEMBER PROCEDURE loadCommentsFromFile(SELF IN OUT NOCOPY ORDVideo,
                                        fileobj IN BFILE,
                                        amount IN INTEGER,
                                        from_loc IN INTEGER := 1,
                                        to_loc IN INTEGER := 1),
  --
  MEMBER PROCEDURE copyCommentsOut( SELF IN OUT NOCOPY ORDVideo,
                                    dest IN OUT NOCOPY CLOB,
                                    amount IN INTEGER,
                                    from_loc IN INTEGER := 1,
                                    to_loc IN INTEGER := 1),
  --
  MEMBER FUNCTION compareComments(compare_with_lob IN CLOB,
                                  amount IN INTEGER:= 4294967295,
                                  starting_pos_in_comment IN INTEGER := 1,
                                  starting_pos_in_compare IN INTEGER := 1)
         RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(compareComments, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION getCommentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getCommentLength, WNDS, WNPS, RNDS, RNPS),
  --
  --
  --VIDEO ATTRIBUTES ACCESSORS
  MEMBER PROCEDURE setFormat(SELF IN OUT NOCOPY ORDVideo,
                             knownFormat IN VARCHAR2),
  MEMBER FUNCTION  getFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setFrameSize(SELF IN OUT NOCOPY ORDVideo,
                                knownWidth IN INTEGER, knownHeight IN INTEGER),
  MEMBER PROCEDURE getFrameSize(SELF IN OUT NOCOPY ORDVideo,
                                retWidth OUT INTEGER, retHeight OUT INTEGER),
  PRAGMA RESTRICT_REFERENCES(getFrameSize, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setFrameResolution(SELF IN OUT NOCOPY ORDVideo,
                                      knownFrameResolution IN INTEGER),
  MEMBER FUNCTION  getFrameResolution RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getFrameResolution, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setFrameRate(SELF IN OUT NOCOPY ORDVideo,
                                knownFrameRate IN INTEGER),
  MEMBER FUNCTION  getFrameRate RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getFrameRate, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setVideoDuration(SELF IN OUT NOCOPY ORDVideo,
                                    knownVideoDuration IN INTEGER),
  MEMBER FUNCTION  getVideoDuration RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getVideoDuration, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setNumberOfFrames(SELF IN OUT NOCOPY ORDVideo,
                                     knownNumberOfFrames IN INTEGER),
  MEMBER FUNCTION  getNumberOfFrames RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getNumberOfFrames, WNDS, WNPS, RNDS, RNPS),
  --                            
  MEMBER PROCEDURE setCompressionType(SELF IN OUT NOCOPY ORDVideo,
                                      knownCompressionType IN VARCHAR2),
  MEMBER FUNCTION  getCompressionType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setNumberOfColors(SELF IN OUT NOCOPY ORDVideo,
                                     knownNumberOfColors IN INTEGER),
  MEMBER FUNCTION  getNumberOfColors RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getNumberOfColors, WNDS, WNPS, RNDS, RNPS),
  --
  --
  MEMBER PROCEDURE setBitRate(SELF IN OUT NOCOPY ORDVideo,
                              knownBitRate IN INTEGER),
  MEMBER FUNCTION  getBitRate RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getBitRate, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION getBFILE RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFILE, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setKnownAttributes( SELF IN OUT NOCOPY ORDVideo,
                                       knownFormat IN VARCHAR2,
                                       knownWidth IN INTEGER,
                                       knownHeight IN INTEGER,
                                       knownFrameResolution IN INTEGER,
                                       knownFrameRate IN INTEGER,
                                       knownVideoDuration IN INTEGER,
                                       knownNumberOfFrames IN INTEGER,
                                       knownCompressionType IN VARCHAR,
                                       knownNumberOfColors IN INTEGER,
                                       knownBitRate IN INTEGER),
  --
  --
  -- Format processor must set all the properties
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDVideo, ctx IN OUT RAW),
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDVideo, 
                                 ctx IN OUT RAW,
                                 setComments IN BOOLEAN),
  MEMBER FUNCTION checkProperties(SELF IN OUT NOCOPY ORDVideo, ctx IN OUT RAW) 
  RETURN BOOLEAN,
  MEMBER FUNCTION  getAttribute(ctx IN OUT RAW,
                                name IN VARCHAR2) RETURN VARCHAR2,
  --
  MEMBER PROCEDURE getAllAttributes(SELF IN OUT NOCOPY ORDVideo,
                                    ctx IN OUT RAW, 
                                    attributes IN OUT NOCOPY CLOB), 
  --
  -- VIDEO PROCESSING METHODS
  MEMBER FUNCTION  processVideoCommand(
                                 SELF      IN OUT NOCOPY ORDVideo,
                                 ctx       IN OUT RAW,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result    OUT RAW)
                   RETURN RAW,
  --
  --
  -- Static Methods for the relational functional interface
  STATIC PROCEDURE export(ctx             IN OUT RAW,
                          local_data      IN BLOB,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2,
                              format          OUT VARCHAR2,
                              mime_type       OUT VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 videoBlob      IN BLOB,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format            IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx              IN OUT RAW,
                                 videoBlob        IN BLOB,
                                 attributes       IN OUT NOCOPY CLOB,
                                 mimeType         OUT VARCHAR2,
                                 format           IN OUT VARCHAR2,
                                 width            OUT INTEGER,
                                 height           OUT INTEGER,
                                 frameResolution  OUT INTEGER,
                                 frameRate        OUT INTEGER,
                                 videoDuration    OUT INTEGER,
                                 numberOfFrames   OUT INTEGER,
                                 compressionType  OUT VARCHAR2,
                                 numberOfColors   OUT INTEGER,
                                 bitRate          OUT INTEGER),
 --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 videoBfile     IN OUT NOCOPY BFILE,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format            IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx              IN OUT RAW,
                                 videoBfile       IN OUT NOCOPY BFILE,
                                 attributes       IN OUT NOCOPY CLOB,
                                 mimeType         OUT VARCHAR2,
                                 format           IN OUT VARCHAR2,
                                 width            OUT INTEGER,
                                 height           OUT INTEGER,
                                 frameResolution  OUT INTEGER,
                                 frameRate        OUT INTEGER,
                                 videoDuration    OUT INTEGER,
                                 numberOfFrames   OUT INTEGER,
                                 compressionType  OUT VARCHAR2,
                                 numberOfColors   OUT INTEGER,
                                 bitRate          OUT INTEGER)
);
show errors;

--
-- Drop the getcontentlength methods in ordaudio  
-- in order to reload the ordaudio spec. otherwise got 22314 error.
--
begin
      execute immediate 'ALTER TYPE ORDAudio 
        DROP MEMBER FUNCTION getContentLength( ctx IN OUT RAW) 
            RETURN INTEGER CASCADE';

      execute immediate 'ALTER TYPE ORDAudio 
        DROP MEMBER FUNCTION getContentLength 
            RETURN INTEGER CASCADE';

end;
/
show errors;

--
-- reload the 10.2 ordaudio spec to add the pragma back
--

ALTER TYPE ORDAudio
REPLACE 
authid current_user
AS OBJECT
(
---------------------------
-- ATTRIBUTES
---------------------------
  description VARCHAR2(4000),
  source      ORDSource,
  format      VARCHAR2(31),
  mimeType    VARCHAR2(4000),
  comments    CLOB,
--
---------------------------
-- Audio Related Attributes
---------------------------
--
  encoding         VARCHAR2(256),
  numberOfChannels INTEGER,
  samplingRate     INTEGER,
  sampleSize       INTEGER,
  compressionType  VARCHAR2(4000),
  audioDuration    INTEGER, 
---------------------------
-- METHODS
---------------------------
  -- CONSTRUCTORS
  STATIC FUNCTION init RETURN ORDAudio,
  STATIC FUNCTION init( srcType IN VARCHAR2,
            srcLocation IN VARCHAR2,
            srcName IN VARCHAR2 ) RETURN ORDAudio,
--
  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setUpdateTime(SELF IN OUT NOCOPY ORDAudio,
                                 current_time DATE),
  --
  -- DESCRIPTION RELATED METHODS
  MEMBER PROCEDURE setDescription(SELF IN OUT NOCOPY ORDAudio,
                                  user_description IN VARCHAR2), 
  MEMBER FUNCTION  getDescription RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getDescription, WNDS, WNPS, RNDS, RNPS),
  --
  -- MIMETYPE RELATED METHODS
  MEMBER FUNCTION  getMimeType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getMimeType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setMimeType(SELF IN OUT NOCOPY ORDAudio,
                               mime IN VARCHAR2),
  --
  --
  -- SOURCE RELATED METHODS
  MEMBER FUNCTION  processSourceCommand(
                            SELF      IN OUT NOCOPY ORDAudio,
                            ctx       IN OUT RAW,
                            cmd       IN VARCHAR2,
                            arguments IN VARCHAR2,
                            result    OUT RAW)
                   RETURN RAW,
  --
  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDAudio),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDAudio),
  MEMBER PROCEDURE setSource(SELF IN OUT NOCOPY ORDAudio,
                             source_type     IN VARCHAR2, 
                             source_location IN VARCHAR2, 
                             source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSource RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSource, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE import(SELF IN OUT NOCOPY ORDAudio,
                          ctx IN OUT RAW),
  MEMBER PROCEDURE importFrom(SELF IN OUT NOCOPY ORDAudio,
                          ctx IN OUT RAW,
                          source_type IN VARCHAR2,
                          source_location IN VARCHAR2,
              source_name IN VARCHAR2),
  MEMBER PROCEDURE export(SELF IN OUT NOCOPY ORDAudio,
                          ctx      IN OUT RAW,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  MEMBER FUNCTION  getContentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
  MEMBER FUNCTION  getContentLength(ctx IN OUT RAW) RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
  --
  -- This method will copy data in the LOB provided, if the data is not 
  -- stored in internal LOB it will be imported and returned in the LOB 
  -- provided
  MEMBER PROCEDURE getContentInLob(SELF IN OUT NOCOPY ORDAudio,
                                   ctx IN OUT RAW,
                                   dest_lob IN OUT NOCOPY BLOB,
                                   mimeType OUT VARCHAR2,
                                   format OUT VARCHAR2),
  --
  MEMBER FUNCTION  getContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getContent, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE deleteContent(SELF IN OUT NOCOPY ORDAudio),
  --
  -- FILE OPERATIONS on the source
  MEMBER FUNCTION openSource(SELF IN OUT NOCOPY ORDAudio, 
                             userArg IN RAW,
                             ctx  OUT RAW) RETURN INTEGER,
  --
  MEMBER FUNCTION closeSource(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW) 
  RETURN INTEGER,
  --
  MEMBER FUNCTION trimSource(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW, 
                             newlen IN INTEGER) RETURN INTEGER,
  --
  MEMBER PROCEDURE readFromSource(SELF IN OUT NOCOPY ORDAudio,
                                  ctx IN OUT RAW,
                                  startPos IN INTEGER,
                                  numBytes IN OUT INTEGER,
                                  buffer OUT RAW),
  --
  MEMBER PROCEDURE writeToSource(SELF IN OUT NOCOPY ORDAudio,
                                 ctx IN OUT RAW,
                                 startPos IN INTEGER,
                                 numBytes IN OUT INTEGER,
                                 buffer IN RAW),
  --
  -- COMMENT RELATED METHODS
  MEMBER PROCEDURE appendToComments(SELF IN OUT NOCOPY ORDAudio,
                                    amount IN BINARY_INTEGER, 
                                    buffer IN VARCHAR2),
  --
  MEMBER PROCEDURE writeToComments(SELF IN OUT NOCOPY ORDAudio,
                                   offset IN INTEGER, 
                                   amount IN BINARY_INTEGER, 
                                   buffer IN VARCHAR2),
  --
  MEMBER FUNCTION readFromComments(offset IN INTEGER,
                                   amount IN BINARY_INTEGER := 32767)
         RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(readFromComments, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION locateInComments(pattern IN VARCHAR2,
                                   offset IN INTEGER := 1,
                                   occurrence IN INTEGER := 1)
         RETURN INTEGER,
  --
  MEMBER PROCEDURE trimComments(SELF IN OUT NOCOPY ORDAudio,
                                newlen IN INTEGER),
  --
  MEMBER PROCEDURE eraseFromComments(SELF IN OUT NOCOPY ORDAudio,
                                     amount IN OUT NOCOPY INTEGER,
                                     offset IN            INTEGER := 1),
  MEMBER PROCEDURE deleteComments(SELF IN OUT NOCOPY ORDAudio),
  --
  MEMBER PROCEDURE loadCommentsFromFile(SELF IN OUT NOCOPY ORDAudio,
                                        fileobj IN BFILE,
                                        amount IN INTEGER,
                                        from_loc IN INTEGER := 1,
                                        to_loc IN INTEGER := 1),
  --
  MEMBER PROCEDURE copyCommentsOut( SELF IN OUT NOCOPY ORDAudio,
                                    dest IN OUT NOCOPY CLOB,
                                    amount IN INTEGER,
                                    from_loc IN INTEGER := 1,
                                    to_loc IN INTEGER := 1),
  --
  MEMBER FUNCTION compareComments(compare_with_lob IN CLOB,
                                  amount IN INTEGER:= 4294967295,
                                  starting_pos_in_comment IN INTEGER := 1,
                                  starting_pos_in_compare IN INTEGER := 1) 
         RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(compareComments, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION getCommentLength RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getCommentLength, WNDS, WNPS, RNDS, RNPS),
  --
  -- AUDIO ATTRIBUTES RELATED METHOD
  MEMBER PROCEDURE setFormat(SELF IN OUT NOCOPY ORDAudio,
                             knownFormat IN VARCHAR2),
  MEMBER FUNCTION  getFormat RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getFormat, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setEncoding(SELF IN OUT NOCOPY ORDAudio,
                               knownEncoding IN VARCHAR2),
  MEMBER FUNCTION  getEncoding RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getEncoding, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setNumberOfChannels(SELF IN OUT NOCOPY ORDAudio,
                                       knownNumberOfChannels IN INTEGER),
  MEMBER FUNCTION  getNumberOfChannels RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getNumberOfChannels, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setSamplingRate(SELF IN OUT NOCOPY ORDAudio,
                                   knownSamplingRate IN INTEGER),
  MEMBER FUNCTION  getSamplingRate RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getSamplingRate, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setSampleSize(SELF IN OUT NOCOPY ORDAudio,
                                 knownSampleSize IN INTEGER),
  MEMBER FUNCTION  getSampleSize RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getSampleSize, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setCompressionType(SELF IN OUT NOCOPY ORDAudio,
                                      knownCompressionType IN VARCHAR2),
  MEMBER FUNCTION  getCompressionType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getCompressionType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setAudioDuration(SELF IN OUT NOCOPY ORDAudio,
                                    knownAudioDuration IN INTEGER),
  MEMBER FUNCTION  getAudioDuration RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getAudioDuration, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION getBFILE RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFILE, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setKnownAttributes( SELF IN OUT NOCOPY ORDAudio,
                                       knownFormat IN VARCHAR2,
                                       knownEncoding IN VARCHAR2,
                                       knownNumberOfChannels IN INTEGER,
                                       knownSamplingRate IN INTEGER,
                                       knownSampleSize IN INTEGER,
                                       knownCompressionType IN VARCHAR2,
                                       knownAudioDuration IN INTEGER), 
  --
  -- Format processor must set all the properties
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW),
  MEMBER PROCEDURE setProperties(SELF IN OUT NOCOPY ORDAudio, 
                                 ctx IN OUT RAW,
                                 setComments IN BOOLEAN),
  --
  -- Format processor will get a copy of the SELF, they should
  -- check the validity of the properties and return TRUE if the
  -- properties are Ok, FALSE otherwise
  MEMBER FUNCTION checkProperties(SELF IN OUT NOCOPY ORDAudio, ctx IN OUT RAW) 
  RETURN BOOLEAN,
  --
  MEMBER FUNCTION  getAttribute(ctx IN OUT RAW,
                                name IN VARCHAR2) RETURN VARCHAR2,
  --
  MEMBER PROCEDURE getAllAttributes(SELF IN OUT NOCOPY ORDAudio,
                                    ctx IN OUT RAW, 
                                    attributes IN OUT NOCOPY CLOB),
  --
  --
  -- AUDIO PROCESSING METHODS
  MEMBER FUNCTION  processAudioCommand(
                                 SELF      IN OUT NOCOPY ORDAudio,
                                 ctx       IN OUT RAW,
                                 cmd       IN VARCHAR2,
                                 arguments IN VARCHAR2,
                                 result    OUT RAW)
                   RETURN RAW,
  --
  --
  -- Static Methods for the relational functional interface
  STATIC PROCEDURE export(ctx             IN OUT RAW,
                          local_data      IN BLOB,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2),
  --
  STATIC PROCEDURE importFrom(ctx             IN OUT RAW,
                              local_data      IN OUT NOCOPY BLOB,
                              source_type     IN VARCHAR2,
                              source_location IN VARCHAR2,
                              source_name     IN VARCHAR2,
                              format          OUT VARCHAR2,
                              mime_type       OUT VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 audioBlob      IN BLOB,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format            IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx              IN OUT RAW,
                                 audioBlob        IN BLOB,
                                 attributes       IN OUT NOCOPY CLOB,
                                 mimeType         OUT VARCHAR2,
                                  format           IN OUT VARCHAR2,
                                 encoding         OUT VARCHAR2,
                                 numberOfChannels OUT INTEGER,
                                 samplingRate     OUT INTEGER,
                                 sampleSize       OUT INTEGER,
                                 compressionType  OUT VARCHAR2,
                                 audioDuration    OUT INTEGER),
 --
  STATIC PROCEDURE getProperties(ctx            IN OUT RAW,
                                 audioBfile     IN OUT NOCOPY BFILE,
                                 attributes     IN OUT NOCOPY CLOB,
                                 format            IN VARCHAR2),
  --
  STATIC PROCEDURE getProperties(ctx                IN OUT RAW,
                                 audioBfile         IN OUT NOCOPY BFILE,
                                 attributes         IN OUT NOCOPY CLOB,
                                 mimeType         OUT VARCHAR2,
                                 format           IN OUT VARCHAR2,
                                 encoding         OUT VARCHAR2,
                                 numberOfChannels OUT INTEGER,
                                 samplingRate     OUT INTEGER,
                                 sampleSize       OUT INTEGER,
                                 compressionType  OUT VARCHAR2,
                                 audioDuration    OUT INTEGER)
);
show errors;

--
-- Drop the getcontentlength and getsourceaddress methods in ordsource  
-- in order to reload the ordsource spec. otherwise got 22314 error.
--
begin
      execute immediate 'ALTER TYPE ORDSource 
        DROP MEMBER FUNCTION getContentLength( ctx IN OUT RAW) 
            RETURN INTEGER CASCADE';

      execute immediate 'ALTER TYPE ORDSource 
        DROP MEMBER FUNCTION getSourceAddress( 
                                ctx IN OUT RAW, 
                                userData IN VARCHAR2) 
            RETURN VARCHAR2 CASCADE';
end;
/
show errors;

--
-- reload the 10.2 ordsource spec to add the pragma restriction back. 
--

ALTER TYPE ORDSource REPLACE
  authid current_user
  AS OBJECT
(
-------------
-- Attributes
-------------
  --
  -- storage for data within oracle. Every operation 
  -- for the data stored in this field will be under
  -- the control of transaction within which the
  -- methods are called. This means that all the changes can
  -- either be commited or rolled back as desired by the
  -- user
  localData   BLOB,
  --
  --
  -- srcType, srcLocation and srcName are limited to 4K
  -- due to system limitation on the size of varchar2 field
  --
  srcType     VARCHAR2(4000),
  srcLocation VARCHAR2(4000),
  srcName     VARCHAR2(4000),
  --
  -- updateTime maintains the time when the users updated either
  -- source or the object containing the source last. This attribute
  -- is not updated when import is called, but importFrom updates
  -- this method since the source information is changed.
  --
  -- For recoding updates when the top level objevt changes, users
  -- must call set method at appropriate time.
  updateTime  DATE,
  --
  -- 1 or NULL means data is in LOB
  -- 0 means that the data is in external sources
  local       NUMBER,
  --
---------- 
-- Methods 
----------
  --
  -- METHODS RELATED TO 'local' FIELD 
  MEMBER PROCEDURE setLocal(SELF IN OUT NOCOPY ORDSource),
  MEMBER PROCEDURE clearLocal(SELF IN OUT NOCOPY ORDSource),
  MEMBER FUNCTION  isLocal RETURN BOOLEAN,
  PRAGMA RESTRICT_REFERENCES(isLocal, WNDS, WNPS, RNDS, RNPS),
  --
  -- DATE RELATED METHODS
  MEMBER FUNCTION  getUpdateTime RETURN DATE,
  PRAGMA RESTRICT_REFERENCES(getUpdateTime, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE setUpdateTime(SELF IN OUT NOCOPY ORDSource,
                                 current_time DATE),
  --
  -- SOURCE INFORMATION
  MEMBER PROCEDURE setSourceInformation(SELF IN OUT NOCOPY ORDSource,
                                        source_type   IN VARCHAR2,
                                        source_location IN VARCHAR2,
                                        source_name     IN VARCHAR2),
  MEMBER FUNCTION  getSourceInformation 
                   RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceInformation, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceType RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceType, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceLocation RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceLocation, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceName RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceName, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getBFile RETURN BFILE,
  PRAGMA RESTRICT_REFERENCES(getBFile, WNDS, WNPS, RNDS, RNPS),
  --
  -- SOURCE IMPORT/EXPORT OPERATIONS
  MEMBER PROCEDURE import(
                          SELF     IN OUT NOCOPY ORDSource,
                          ctx      IN OUT RAW,
                          mimetype OUT VARCHAR2,
                          format   OUT VARCHAR2),
  MEMBER PROCEDURE import(
                          SELF     IN OUT NOCOPY ORDSource,
                          ctx      IN OUT RAW,
                          dlob     IN OUT NOCOPY BLOB,
                          mimetype OUT VARCHAR2,
                          format   OUT VARCHAR2),
  MEMBER PROCEDURE importFrom( SELF            IN OUT NOCOPY ORDSource,
                               ctx             IN OUT RAW,
                               mimetype        OUT VARCHAR2,
                               format          OUT VARCHAR2,
                               source_type     IN VARCHAR2,
                               source_location IN VARCHAR2,
			       source_name     IN VARCHAR2),
  MEMBER PROCEDURE importFrom( SELF            IN OUT NOCOPY ORDSource,
                               ctx             IN OUT RAW,
                               dlob            IN OUT NOCOPY BLOB,
                               mimetype        OUT VARCHAR2,
                               format          OUT VARCHAR2,
                               source_type     IN VARCHAR2,
                               source_location IN VARCHAR2,
			       source_name     IN VARCHAR2),
  MEMBER PROCEDURE export(SELF            IN OUT NOCOPY ORDSource,
                          ctx             IN OUT RAW,
                          source_type     IN VARCHAR2,
                          source_location IN VARCHAR2,
                          source_name     IN VARCHAR2),
  --
  -- SOURCE CONTENT RELATED OPERATIONS
  MEMBER FUNCTION  getContentLength(ctx IN OUT RAW) RETURN INTEGER,
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getSourceAddress(ctx IN OUT RAW, 
                                    userData IN VARCHAR2) RETURN VARCHAR2,
  PRAGMA RESTRICT_REFERENCES(getSourceAddress, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER FUNCTION  getLocalContent RETURN BLOB,
  PRAGMA RESTRICT_REFERENCES(getLocalContent, WNDS, WNPS, RNDS, RNPS),
  --
  MEMBER PROCEDURE getContentInTempLob(
                                       SELF IN OUT NOCOPY ORDSource,
                                       ctx      IN OUT RAW,
                                       tempLob  IN OUT NOCOPY BLOB,
                                       mimetype OUT VARCHAR2,
                                       format   OUT  VARCHAR2,
                                       duration IN PLS_INTEGER := 10,
                                       cache    IN BOOLEAN := TRUE),
  MEMBER PROCEDURE deleteLocalContent,
  --
  -- SOURCE ACCESS METHODS
  MEMBER FUNCTION open(
                       SELF IN OUT NOCOPY ORDSource,
                       userArg IN RAW,
                       ctx OUT RAW) RETURN INTEGER,
  MEMBER FUNCTION close(
                       SELF IN OUT NOCOPY ORDSource,
                       ctx IN OUT RAW) RETURN INTEGER,
  MEMBER FUNCTION trim(SELF    IN OUT NOCOPY ORDSource,
                       ctx     IN OUT RAW, 
                       newlen  IN INTEGER) RETURN INTEGER,
  --
  -- CONTENT READ/WRITE OPERATIONS
  MEMBER PROCEDURE read(SELF     IN OUT NOCOPY ORDSource,
                        ctx      IN OUT RAW,
                        startPos IN     INTEGER,
                        numBytes IN OUT INTEGER,
                        buffer   OUT    RAW),
  MEMBER PROCEDURE write(SELF IN OUT NOCOPY ORDSource,
                         ctx      IN OUT RAW,
                         startPos IN INTEGER,
                         numBytes IN OUT INTEGER,
                         buffer   IN RAW),
  --
  -- SEND OFF ANY COMMAND TO THE EXTERNAL SOURCE PLUGIN
  MEMBER FUNCTION processCommand(
                      SELF    IN OUT NOCOPY ORDSource,
                      ctx     IN OUT RAW,
                      command IN VARCHAR2,
                      arglist IN VARCHAR2,
                      result  OUT RAW) RETURN RAW
  --
);
/
show errors;
-- End ORDSource spec reloading 

-- revoke permission granted for feature usage
revoke select on dba_tab_cols from ordsys;

-- drop the feature usage table
drop table ORD_USAGE_RECS purge;

-- drop common private package
drop package ordutil_prv;

drop package orddoc_pkg;

-- The following should be at the end of the file
-- executed as ORDSYS
EXECUTE dbms_registry.downgraded('ORDIM', '10.2.0');

REM
REM Downgrade Locator if Spatial is not installed
REM
alter session set current_schema="SYS";

COLUMN :script_name NEW_VALUE comp_file NOPRINT
Variable script_name varchar2(50)

declare
  mdsyscnt NUMBER := 0;
begin
  -- Check whether Locator is installed.
  -- If not, Do not downgrade Locator
  select count(*) into mdsyscnt from all_objects 
      where owner='MDSYS' and object_name = 'SDO_GEOMETRY';

  -- Check whether SDO is installed.
  -- If not, downgrade Locator
  if ((dbms_registry.is_valid('SDO') is NULL) and (mdsyscnt > 0)) then
    :script_name := '?/md/admin/loce102.sql';
  else
    :script_name := '?/rdbms/admin/nothing.sql';
  end if;
end;
/

REM Invoke Locator downgrade script

select :script_name from dual;
@&comp_file

alter session set current_schema="SYS";

