Rem Copyright (c) 2002, 2008, Oracle. All rights reserved.  
Rem  All Rights Reserved.
Rem
Rem    NAME
Rem      immedins.sql 
Rem
Rem    DESCRIPTION
Rem      This script is used by the common schema to install just the media
Rem      portions of Oracle Multimedia.
Rem
Rem    NOTES
REM      You must connect as SYSDBA prior to running this script
REM      You must run ordinst.sql prior to running this script
REM

alter session set current_schema="ORDSYS";
EXECUTE dbms_registry.loading('ORDIM','Oracle Multimedia','validate_ordim','ORDSYS', dbms_registry.schema_list_t('ORDPLUGINS','SI_INFORMTN_SCHEMA', 'ORDDATA'));

EXECUTE dbms_registry.set_required_comps('ORDIM',dbms_registry.comp_depend_list_t('JAVAVM','XDB','XML'));

Rem
Rem Invoke imxreg.sql to register new XML Schemas if XDB is installed
Rem
COLUMN file_name NEW_VALUE comp_file NOPRINT;
SELECT dbms_registry.script('XDB','@imxreg.sql') AS file_name FROM DUAL;
@&comp_file

REM Invoke Oracle Multimedia install script w/o ncomp
@@immednnc.sql

REM Invoke NCOMP init script
REM Uncomment the following script invocation if JIT is not enabled for your platform
--@@initimnc.sql

Rem
Rem Invoke imxrepos.sql to load ORDSYS folder in XML DB Repository
Rem
COLUMN file_name NEW_VALUE comp_file NOPRINT;
SELECT dbms_registry.script('XDB','@imxrepos.sql') AS file_name FROM DUAL;
@&comp_file

Rem
Rem Clear the table for recording feature usage
Rem
delete from ORDSYS.ORD_USAGE_RECS;

EXECUTE dbms_registry.loaded('ORDIM');

alter session set current_schema="SYS";

