Rem Copyright (c) 2003, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
REM
Rem    NAME
Rem      impatch.sql 
Rem
REM You must connect as SYSDBA prior to running this script
REM
REM This patch script applies bug fixes for Oracle Multimedia
REM

whenever sqlerror exit;
execute dbms_registry.check_server_instance;

REM 
REM Make sure Oracle Multimedia schemas exist.
REM
REM Note - it is forbidden to exit in a patch script.  
REM However, it is an assumed impossible condition that we exist in the 
REM registry (which is the only way this script should be called) and our
REM schemas don't exist.  Therefore, we will exit here if our schemas don't
REM exist so we can figure out how we got in this situation.
REM 

@@imchksch.sql

whenever sqlerror continue;

REM Reload ORDSYS components
alter session set current_schema="ORDSYS";
EXECUTE sys.dbms_registry.loading('ORDIM','Oracle Multimedia','validate_ordim','ORDSYS', sys.dbms_registry.schema_list_t('ORDPLUGINS','SI_INFORMTN_SCHEMA', 'ORDDATA'));

Rem Clean out previous Java objects
@@imclnjav.sql

REM Reload public modifed packages
@@impbs.sql

REM Reload private packages, procedures, functions and views
@@impvs.sql

REM Reload Views
@@imview.sql

REM Reload type and package bodies
@@imtyb.sql
@@implb.sql

REM Reload Java classes
@@initim.sql

execute sys.dbms_registry.loaded('ORDIM');

alter session set current_schema="SYS";

REM recompile invalid ORDSYS types
execute sys.dbms_session.reset_package;
execute sys.utl_recomp.recomp_serial('ORDSYS');

REM
REM Invoke Locator patch and register MDSYS if SDO is not installed 
REM and MDSYS schema exists.  Note - if MDSYS does not exist
REM this is most likely an internal test scenario and we
REM should not attempt to invoke Locator patch script.
REM
COLUMN :script_name NEW_VALUE comp_file NOPRINT
Variable script_name varchar2(50)

declare
  mdsyscnt NUMBER := 0;
begin
  -- Check whether MDSYS exists.
  -- If not, Do not upgrade Locator and register MDSYS
  select count(*) into mdsyscnt from sys.dba_users where username='MDSYS';
  -- Check whether SDO is installed.
  -- If not, patch Locator
  if ((sys.dbms_registry.is_valid('SDO') is NULL) and (mdsyscnt > 0)) then
    :script_name := '?/md/admin/locpatch.sql';
    dbms_registry.loading
        ('ORDIM', 'Oracle Multimedia', 
         'validate_ordim', 'ORDSYS', 
         sys.dbms_registry.schema_list_t('ORDPLUGINS','SI_INFORMTN_SCHEMA',
                                     'MDSYS', 'ORDDATA'));
  else
    :script_name := sys.dbms_registry.nothing_script;
  end if;
end;
/

select :script_name from dual;
@&comp_file

alter session set current_schema="SYS";

REM Install Oracle Multimedia verification procedure
REM and validate Oracle Multimedia Installation
@@imvalid.sql
