Rem Copyright (c) 2003, 2006, Oracle. All rights reserved.  
REM 
REM Internal installation script for Oracle Multimedia 
REM   Install public packages specifications, procedures, and functions
REM 

REM Install Oracle Multimedia ORDSYS packages

REM Install Oracle Multimedia common error handling Specification
@@ordzpksp.plb
grant execute on OrdImErrorCodes to ORDSYS;
grant execute on OrdIMErrorCodes to ORDPLUGINS;
grant execute on IM to public;
grant execute on ORDUtil to public;
grant execute on OrdPlsGwyUtil to public;
CREATE OR REPLACE PUBLIC SYNONYM OrdPlsGwyUtil FOR ORDSYS.OrdPlsGwyUtil;

REM Install ORDSource Package
@@ordascex.sql
grant execute on ORDSourceExceptions to public;

REM Install Oracle Multimedia Image Packages
@@ordipksp.plb
@@ordimpks.plb
@@ordispbs.plb
grant execute on ORDSYS.ORDIMG_PKG to PUBLIC;
grant execute on ORDSYS.ORDImageConstants to PUBLIC;
grant execute on ORDSYS.ORDImgExtCodec_Pkg to PUBLIC;

REM Install Oracle Multimedia Audio Package
@@ordapksp.plb
grant execute on ORDAudio_Pkg to public;

REM Install Oracle Multimedia Video Package
@@ordvpksp.plb
grant execute on ORDVideo_Pkg to public;

REM Install Oracle Multimedia ORDDoc Package
@@orddpksp.plb
grant execute on ORDDoc_Pkg to public;
grant execute on ORDDocExceptions to public;

REM Install DICOM Packages
@@ordcpksp.sql
grant execute on ordsys.ord_dicom       to public;
@@ordcrpsp.sql
grant execute on ordsys.ord_dicom_admin to ordadmin;

REM Create public synonyms
create or replace public synonym ord_dicom       for ordsys.ord_dicom;
create or replace public synonym ord_dicom_admin for ordsys.ord_dicom_admin;

REM Install ORDPLUGINS Packages
alter session set current_schema="ORDPLUGINS";

REM Install Source Plugin Specifications
@@ordahtsp.sql
@@ordabfsp.sql
grant execute on ORDX_HTTP_SOURCE to public;
grant execute on ORDX_FILE_SOURCE to public;

REM Install Oracle Multimedia Audio format plugin Specifications
@@ordadfs.sql
grant execute on ORDX_DEFAULT_AUDIO to public;

REM Install Oracle Multimedia Video format plugin specifications
@@ordvdfs.sql
grant execute on ORDX_DEFAULT_VIDEO to public;

REM Install Oracle Multimedia Doc format plugin specifications
@@ordddfs.sql
grant execute on ORDX_DEFAULT_DOC to public;

alter session set current_schema="ORDSYS";


