Rem Copyright (c) 2003, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
REM 
REM Internal installation script for Multimedia 
REM   Create/Replace package bodies under ORDSYS and ORDPLUGINS schemas
REM   This script assumes we're connected as ORDSYS.

REM Install Multimedia common private package
@@ordzimbd.plb

REM Install Multimedia common error handling components
@@ordzpkbd.plb
@@ordzepbd.plb
@@ordcscpk.plb

REM Install Multimedia Image Package Bodies
@@ordipkbd.plb
@@ordisplb.plb

REM Install Multimedia Audio Package Bodies
@@ordapkbd.plb

REM Install Multimedia Video Package Bodies
@@ordvpkbd.plb

REM Install Multimedia Doc Package Bodies
@@orddpkbd.plb

REM
REM Install Multimedia DICOM Package Bodies if XDB is installed
REM
COLUMN file_name NEW_VALUE comp_file NOPRINT;
SELECT dbms_registry.script('XDB','@imcplb') AS file_name FROM DUAL;
@&comp_file

REM 
REM   Create/Replace package bodies under ORDPLUGINS schema.
REM

alter session set current_schema="ORDPLUGINS";
REM Install Source Plugins
@@ordahtbd.plb
@@ordabfbd.plb

REM Install Multimedia Audio format plugins
REM Only the default plug-in is installed.
@@ordadfb.plb

REM Install Multimedia Video format plugins
REM Only the default plug-in is installed.
@@ordvdfb.plb

REM Install Multimedia Doc format plugins
@@ordddfb.plb

alter session set current_schema="ORDSYS";
