Rem $Header: ordim/admin/imprv.sql /main/24 2009/02/17 18:31:48 myalavar Exp $
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      imprv.sql
Rem
Rem    DESCRIPTION
Rem      This script grants the privs required by the media components
Rem      of Oracle Multimedia (not Locator).
Rem
Rem    NOTES
REM      You must connect as SYSDBA prior to running this script
REM

--
-- Privs needed by SYS
--
grant create any operator to SYS;
grant create any indextype to SYS;
grant drop any indextype to SYS;
grant drop any operator to SYS;
grant javauserpriv to SYS;
begin
  dbms_java.grant_permission ('SYSTEM', 'java.io.FilePermission', 
                              '<<ALL FILES>>', 'read');
end;
/


-- 
-- Privs needed by ORDSYS 
--
--  SYS privs
grant unlimited tablespace to ORDSYS;
--  ROLES
grant javauserpriv to ordsys;
--  OBJECT privs
grant execute on dbms_lock to ordsys;
--
-- Grants needed for ORDSYS views
-- 
grant select on dba_views         to ordsys with grant option;
grant select on dba_tables        to ordsys with grant option;
grant select on dba_object_tables to ordsys with grant option;
grant select on dba_tab_cols      to ordsys;
grant select on dba_indexes       to ordsys;

begin
  dbms_java.grant_permission('ORDSYS','SYS:java.lang.RuntimePermission',
                             'getClassLoader', '');
  dbms_java.grant_permission('ORDSYS', 'SYS:java.util.logging.LoggingPermission',
                             'control','');
end;
/

  -- Privs needed to load native library 
  -- enable SYS
begin
  dbms_java.grant_permission
     ('SYS', 
      'SYS:oracle.aurora.rdbms.security.PolicyTablePermission', 
      '0:java.lang.RuntimePermission#loadLibrary.ordim11', 
      null);
  dbms_java.grant_permission
     ('SYS', 
      'SYS:oracle.aurora.rdbms.security.PolicyTablePermission', 
      '0:java.lang.RuntimePermission#loadLibrary.oraordim11', 
      null);

  -- grant to ORDSYS
  dbms_java.grant_permission
     ('ORDSYS', 'SYS:java.lang.RuntimePermission', 
      'loadLibrary.ordim11', '');
  dbms_java.grant_permission
     ('ORDSYS', 'SYS:java.lang.RuntimePermission', 
      'loadLibrary.oraordim11', '');
end;
/

begin
  --revoke from SYS
  dbms_java.revoke_permission
     ('SYS', 
      'SYS:oracle.aurora.rdbms.security.PolicyTablePermission', 
      '0:java.lang.RuntimePermission#loadLibrary.ordim11', 
      null);
  dbms_java.revoke_permission
     ('SYS', 
      'SYS:oracle.aurora.rdbms.security.PolicyTablePermission', 
      '0:java.lang.RuntimePermission#loadLibrary.oraordim11', 
      null);
end;
/
-- END privs need for native library

--
-- Privs needed for ORDSYS to use import/export extensibility
--
grant insert on sys.exppkgobj$ to ORDSYS; 
grant insert on sys.exppkgact$ to ORDSYS; 
grant insert on sys.expdepobj$ to ORDSYS; 
grant insert on sys.expdepact$ to ORDSYS; 
grant delete on sys.exppkgobj$ to ORDSYS; 
grant delete on sys.exppkgact$ to ORDSYS; 
grant delete on sys.expdepobj$ to ORDSYS; 
grant delete on sys.expdepact$ to ORDSYS; 

--
-- grants to ORDDATA
--
--  SYS privs
grant unlimited tablespace to ORDDATA;

--
-- Privs needed by ORDPLUGINS 
--
--  No SYS privs

--
-- Grants needed by SI_INFORMTN_SCHEMA user
--
--  SYS privs
grant unlimited tablespace to  SI_INFORMTN_SCHEMA;

--==========================================================================
-- CREATE ROLE for the dicom administrator
--
--==========================================================================
create role ORDADMIN;
