Rem
Rem $Header: ordim/admin/imremchk.sql /main/3 2009/03/16 08:32:06 smavris Exp $
Rem
Rem imremchk.sql
Rem
Rem Copyright (c) 2007, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      imremchk.sql - Oracle Multimedia installation check script
Rem
Rem    DESCRIPTION
Rem      This script checks to see if Oracle Multimedia is being used.
Rem
Rem    NOTES
Rem      - must be run as sysdba
Rem      - must be run with serveroutput on to see results
Rem      - This script checks to see if anyone is using our object 
Rem        types or XML schemas.  It does not check to see if dependent 
Rem        products such as Oracle Spatial are installed.
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smavris     03/05/09 - Invoke locator removal script
Rem    smavris     10/11/07 - Use correct recyclebin view name (bug 6510142)
Rem    smavris     06/04/07 - Checks for the use of Oracle Multimedia
Rem    smavris     05/29/07 - Oracle Multimedia installation check script
Rem    smavris     05/29/07 - Created
Rem

SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100


declare
  tablecnt  NUMBER := 0;
  schemacnt NUMBER := 0;
  mdsyscnt  NUMBER := 0;
  loctblcnt NUMBER := 0;

begin
--
-- First check to see if anyone is using our object types
-- 
  select count(unique u.table_name) into tablecnt from sys.dba_tab_columns u 
  where u.table_name not in (select object_name from sys.dba_recyclebin)
  and u.data_type IN ('ORDIMAGE','ORDIMAGESIGNATURE','ORDAUDIO','ORDVIDEO',
                      'ORDDOC','ORDSOURCE','ORDDICOM','ORDDATASOURCE',
                      'SI_STILLIMAGE','SI_COLOR','SI_AVERAGECOLOR',
                      'SI_POSITIONALCOLOR','SI_TEXTURE','SI_COLORHISTOGRAM',
                      'SI_FEATURELIST')
  and (u.data_type_owner IN ('ORDSYS', 'PUBLIC'))
  and (u.owner <> 'PM');

--
-- Next check to see if there are any dependencies on our XML schemas
--

  select count(1) into schemacnt
  from (select d.owner, 
        case when d.type = 'XML SCHEMA' then 
           (select s2.schema_url from sys.dba_xml_schemas s2 
            where s2.int_objname=d.name and s2.owner <> 'ORDSYS') 
        else d.name 
        end NAME, d.type 
  from sys.dba_dependencies d, sys.dba_xml_schemas s 
  where d.referenced_name=s.int_objname 
  and d.name not in (select object_name from sys.dba_recyclebin)
  and (s.schema_url = 'http://xmlns.oracle.com/ord/dicom/anonymity_1_0' 
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/datatype_1_0' 
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/constraint_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/rpdatatype_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/metadata_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/mddatatype_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/mapping_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/preference_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/orddicom_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/meta/dicomImage'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/meta/exif'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/meta/ordimage'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/meta/iptc'
   or  s.schema_url = 'http://xmlns.oracle.com/ord/meta/xmp'))
  res where res.name is not null;

--
-- Lastly, check if Locator is being used (SDO_GEOMETRY with no SDO installed)
--
  select count(*) into mdsyscnt from sys.dba_users where username='MDSYS';
  if ((dbms_registry.is_valid('SDO') is NULL) and (mdsyscnt > 0)) then
    select count(unique u.table_name) into loctblcnt 
      from sys.dba_tab_columns u 
      where u.table_name not in (select object_name from sys.dba_recyclebin)
      and u.data_type = 'SDO_GEOMETRY'
      and (u.data_type_owner IN ('MDSYS','PUBLIC'))
      and (u.owner not in ('PM','MDSYS'));
  end if;

  if tablecnt > 0 then
    dbms_output.put_line('Oracle Multimedia object types are being used');
  end if;

  IF schemacnt > 0 then
    dbms_output.put_line('Oracle Multimedia XML Schemas are being used');
  end if;

  if loctblcnt > 0 then
    dbms_output.put_line('Oracle Multimedia Locator is being used');
  end if;

  if tablecnt = 0 and schemacnt = 0 and loctblcnt = 0 then
    dbms_output.put_line('Oracle Multimedia is not being used');
  end if;
end;
/
