Rem
Rem $Header: ordim/admin/imremov.sql /main/3 2009/03/18 18:15:50 smavris Exp $
Rem
Rem imremov.sql
Rem
Rem Copyright (c) 2007, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      imremov.sql - Oracle Multimedia installation removal script
Rem
Rem    DESCRIPTION
Rem      This script deinstalls Oracle Multimedia
Rem
Rem    NOTES
Rem      - must be run as sysdba
Rem      - This script first checks to see if anyone is using our object 
Rem        types and XML Schemas.
Rem      - It then prompts the user to see if they really want to remove
Rem      - If yes, imremdo is invoked to do the actual removal
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smavris     03/16/09 - Remove Spatial comment
Rem    smavris     01/15/09 - Set serveroutput on so users can see message
Rem                           about mm installed or not
Rem    smavris     01/17/07 - Oracle Multimedia installation removal script
Rem    smavris     01/17/07 - Created
Rem

SET NUMWIDTH 10
SET LINESIZE 80
SET TRIMSPOOL ON
SET TAB OFF
SET PAGESIZE 100

WHENEVER SQLERROR CONTINUE;
SET SERVEROUTPUT ON;
Rem
Rem First check to see if anyone is using our object types
Rem 
prompt About to remove Oracle Multimedia.
prompt Checking to see if anyone is using Oracle Multimedia.
prompt 
@@imremchk
accept remove_mm char format a3 prompt "Are you sure you want to remove Oracle Multimedia (Y/N): "

COLUMN :script_name NEW_VALUE comp_file NOPRINT
Variable script_name varchar2(50)

BEGIN
  IF (substr(UPPER('&remove_mm'),1,1) = 'Y') THEN
    :script_name := '?/ord/im/admin/imremdo.sql';
  ELSE 
    :script_name := '?/rdbms/admin/nothing.sql';
  END IF;
END;
/

select :script_name from dual;
@&comp_file

