Rem $Header: ordim/admin/imtyp.sql /main/9 2009/03/27 20:51:30 smavris Exp $
Rem
Rem Copyright (c) 2002, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      imtyp.sql
Rem
Rem    DESCRIPTION
Rem      Internal installation script for Oracle Multimedia 
Rem      Create/Replace type specifications under ORDSYS schema.
Rem
Rem    NOTES
REM      You must alter session to ORDSYS prior to running this script
REM
REM

REM Install Oracle Multimedia Source Types
@@ordsrcsp.sql
grant execute on ORDSource to public;
@@ordcscsp.sql
grant execute on ordsys.orddatasource to public;

REM Install Oracle Multimedia Image Types
@@ordispec.sql
@@ordimssp.sql
@@ordisits.sql
grant execute on ORDSYS.ORDImage to PUBLIC;
grant execute on ORDSYS.ORDImageExceptions to PUBLIC;

REM Install Oracle Multimedia Audio Type
@@ordaspec.sql
grant execute on ORDAudio to public;
grant execute on ORDAudioExceptions to public;

REM Install Oracle Multimedia Video Type
@@ordvspec.sql
grant execute on ORDVideo to public;
grant execute on ORDVideoExceptions to public;

REM Install Oracle Multimedia Doc Type
@@orddspec.sql
grant execute on ORDDoc to public;

REM Install Oracle Multimedia DICOM Type
@@ordcspec.sql
grant execute on ordsys.orddicom to public;

REM Create public synonyms for the ORD object types
create or replace public synonym ORDAudio for ORDSYS.ORDAudio;
create or replace public synonym ORDImage for ORDSYS.ORDImage;
create or replace public synonym ORDVideo for ORDSYS.ORDVideo;
create or replace public synonym ORDDoc   for ORDSYS.ORDDoc;
create or replace public synonym ORDImageSignature for ORDSYS.ORDImageSignature;
create or replace public synonym orddicom      for ordsys.orddicom;
create or replace public synonym orddatasource for ordsys.orddatasource;
