Rem
Rem $Header: imu111m.sql 19-mar-2008.15:09:10 myalavar Exp $
Rem
Rem imu111m.sql
Rem
Rem Copyright (c) 2008, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      imu111m.sql 
Rem
Rem    DESCRIPTION
Rem       runs as SYS
Rem       
Rem       Part of the internal upgrade script for Oracle Mutlimedia from 11.1
Rem       Migrates user-defined documents from DICOM repository
Rem       in ORDSYS schema to ORDData schema. This script is invoked
Rem       by imdbmig.sql.
Rem
Rem    NOTES
Rem     
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    myalavar    02/01/08 - 11.1 repos user-doc migration
Rem    myalavar    02/01/08 - Created
Rem

--
-- If upgrading from 11.1.0, copy the user documents in the DICOM 
-- repository from ORDSYS to ORDData.
--
declare
 l_ordsys_cnt  number := 0;
 l_orddata_cnt number := 0;
 doc_exists_ex exception;
 pragma exception_init(doc_exists_ex, -53002);
begin
  if (substr(dbms_registry.version('ORDIM'), 1, 6) = '11.1.0') then
    
    --check if ORDSYS contains user-defined documents
    select count(*) into l_ordsys_cnt
    from ordsys.orddcm_docs 
    where oracle_install = 0;

    -- check if ORDData contains user-docs 
    select count(*) into l_orddata_cnt
    from orddata.orddcm_docs
    where oracle_install=0;


    -- if user-docs exist in ORDSYS
    -- install user-docs from ORDSYS into ORDData schema
    -- leave content unchanged in ORDSYS schema
    if (l_ordsys_cnt > 0) then
      -- editDataModel is a commit operation
      ord_dicom_admin.editDataModel;

      -- install user-docs from ORDSYS into ORDData schema
      for cur in (select od.doc_name, odt.doc_type, od.doc_content
                 from ordsys.orddcm_docs od, ordsys.orddcm_doc_types odt
                 where od.doc_type_id = odt.doc_type_id
                 and od.oracle_install=0
                 order by od.doc_id asc) loop
        begin
         -- document will be inserted into repos in ORDData schema
         ord_dicom_admin.insertDocument(cur.doc_name,
                                        cur.doc_type,
                                        cur.doc_content);
          exception 
          when doc_exists_ex then
           --ignore ORA-53002 documents exists exception
           null;
        end;
      end loop;
                   
       -- publish is a commit operation
       ord_dicom_admin.publishDataModel;
    end if;
  end if;
end;
/









