Rem
Rem imxreg.sql
Rem
Rem Copyright (c) 2004, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      imxreg.sql
Rem
Rem    DESCRIPTION
Rem      This script registers the Oracle Multimedia XSD schemas with XDB. 
Rem
Rem      *!*!*!*!* This script is autogenerated by ordim/utl/setupview.pl *!*!*!*!*
Rem       Do not edit it unless you know what you are doing. Edit setup_view.pl
Rem
Rem    NOTES
Rem      Before running this script user must be connected as a user
Rem       with authority to register xml schemas 
Rem      
Rem     


-- Register orddcmim.xsd with XDB under http://xmlns.oracle.com/ord/meta/dicomImage
declare 
 old_s sys.XMLType;
 new_s sys.XMLType;
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/meta/dicomImage" targetNamespace="http://xmlns.oracle.com/ord/meta/dicomImage"  xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xdb="http://xmlns.oracle.com/xdb" elementFormDefault="qualified" attributeFormDefault="unqualified">	' ||
'' ||
'<xs:annotation>' ||
'  <xs:documentation>' ||
'    Date: 21 Sept 2005' ||
'    Version: 10gR2_release_10.2.0.2' ||
'    Name: dicomImage.xsd' ||
'    Author: Dongbai Guo' ||
'' ||
'    Introduction' ||
'      This schema defines the set of DICOM metadata for' ||
'      ORDImage function getDicomMetadata().' ||
'      The purpose of this set of functions is to extract from a DICOM image a set of' ||
'      attributes to describe the image in XML, allowing easy browsing and retrieval.' ||
'    ' ||
'      Question mark "?" means optional items' ||
'    ' ||
'     The DICOM schema does not enforce the DICOM standard.  By default, conformance ' ||
'     is enforced by the getDicomMetadata code.  If DICOM conformance is disabled by ' ||
'     invoking the setDicomValidation method,we will extract metadata from ' ||
'     images with missing or null mandatory DICOM attributes, and/or non-conformant ' ||
'     DICOM attributes.  For attributes with non-conformant values, the raw data ' ||
'     will be placed in the rawValue attribute of the tag.' ||
'' ||
'    Structure Overview' ||
'      DICOM_IMAGE' ||
'        ORD_DICOM_HEADER' ||
'          VERSION' ||
'          DICOM_STANDARD_VERSION' ||
'          DICOM_STANDARD_RELEASE' ||
'        FILE_META_HEADER' ||
'          MEDIA_STORAGE_SOP_CLASS_UID' ||
'          MEDIA_STORAGE_SOP_INSTANCE_UID' ||
'          TRANSFER_SYNTAX_UID' ||
'          IMPLEMENTATION_CLASS_UID' ||
'          IMPLEMENTATION_VERSION_NAME' ||
'          SOURCE_APPLICATION_ENTITY_TITLE' ||
'        PATIENT' ||
'          NAME' ||
'          ID' ||
'          BIRTH_DATE' ||
'          SEX' ||
'        GENERAL_STUDY' ||
'          INSTANCE_UID' ||
'          DATE' ||
'          TIME' ||
'          REFERING_PHYSICIANS_NAME' ||
'          ID' ||
'          ACCESSION_NUMBER' ||
'          DESCRIPTION?' ||
'        PATIENT_STUDY?' ||
'          ADMITTING_DIAGNOSES_DESCRIPTION' ||
'          ADMITTING_DIAGNOSES_CODE_SEQUENCE' ||
'        GENERAL_SERIES' ||
'          MODALITY' ||
'          INSTANCE_UID' ||
'          DATE' ||
'          TIME' ||
'          PERFORMING_PHYSICIANS_NAME' ||
'          BODY_PART_EXAMINED' ||
'          PATIENT_POSITION' ||
'          PERFORMED_PROCEDURE_STEP_ID' ||
'          PERFORMED_PROCEDURE_STEP_START_DATE' ||
'          PERFORMED_PROCEDURE_STEP_START_TIME' ||
'          PERFORMED_PROCEDURE_STEP_DESCRIPTION' ||
'          PERFORMED_PROTOCOL_CODE_SEQUENCE' ||
'        GENERAL_EQUIPMENT?' ||
'          MANUFACTURER' ||
'        GENERAL_IMAGE?' ||
'          INSTANCE_NUMBER' ||
'          ACQUISITION_NUMBER' ||
'          ACQUISITION_DATE' ||
'          ACQUISITION_TIME' ||
'          ACQUISITION_DATETIME' ||
'          PATIENT_ORIENTATION' ||
'          FRAME_LATERALITY' ||
'          ANATOMIC_REGION' ||
'        IMAGE_PIXEL?' ||
'          SAMPLES_PER_PIXEL' ||
'          PHOTOMETRIC_INTERPRETATION' ||
'          ROWS' ||
'          COLUMNS' ||
'          BIT_ALLOCATED' ||
'          BIT_STORED' ||
'          HIGH_BIT' ||
'          PIXEL_REPRESENTATION' ||
'       		PLANAR_CONFIGURATION' ||
'          PIXEL_ASPECT_RATIO' ||
'' ||
'        SOP_COMMON' ||
'          CLASS_UID' ||
'          INSTANCE_UID						' ||
'          SPECIFIC_CHARACTER_SET' ||
'' ||
'    List of DICOM attribute tags appeared in this schema' ||
'      (0002, 0002)  MEDIA_STORAGE_SOP_CLASS_UID' ||
'      (0002, 0003)  MEDIA_STORAGE_SOP_INSTANCE_UID' ||
'      (0002, 0010)  TRANSFER_SYNTAX_UID' ||
'      (0002, 0012)  IMPLEMENTATION_CLASS_UID' ||
'      (0002, 0013)  IMPLEMENTATION_VERSION_NAME' ||
'      (0002, 0016)  SOURCE_APPLICATION_ENTITY_TITLE' ||
'' ||
'' ||
'      (0008, 0005)  SPECIFIC_CHARACTER_SET' ||
'      (0008, 0016)  SOP CLASS_UID' ||
'      (0008, 0018)  SOP INSTANCE_UID' ||
'      (0008, 0020)  STUDY DATE' ||
'      (0008, 0021)  SERIES DATE' ||
'      (0008, 0022)  ACQUISITION_DATE' ||
'      (0008, 002A)  ACQUISITION_DATETIME' ||
'      (0008, 0030)  STUDY TIME' ||
'      (0008, 0031)  SERIES TIME' ||
'      (0008, 0032)  ACQUISITION_TIME' ||
'      (0008, 0050)  ACCESSION_NUMBER' ||
'      (0008, 0060)  MODALITY' ||
'      (0008, 0070)  MANUFACTURER' ||
'      (0008, 0090)  REFERING_PHYSICIANS_NAME' ||
'      (0008, 1030)  STUDY DESCRIPTION' ||
'      (0008, 1050)  PERFORMING_PHYSICIANS_NAME' ||
'      (0008, 1080)  ADMITTING_DIAGNOSES_DESCRIPTION' ||
'      (0008, 1084)  ADMITTING_DIAGNOSES_CODE_SEQUENCE' ||
'      (0008, 2218)  ANATOMIC_REGION' ||
'' ||
'      (0010, 0010)  PATIENT NAME' ||
'      (0010, 0020)  PATIENT ID' ||
'      (0010, 0030)  PATIENT BIRTH_DATE' ||
'      (0010, 0040)  PATIENT SEX' ||
'' ||
'      (0018, 0015)  BODY_PART_EXAMINED' ||
'      (0018, 5100)  PATIENT_POSITION' ||
'    ' ||
'      (0020, 000D)  STUDY INSTANCE_UID' ||
'      (0020, 000E)  SERIES INSTANCE_UID' ||
'      (0020, 0010)  STUDY ID' ||
'      (0020, 0012)  ACQUISITION_NUMBER' ||
'      (0020, 0013)  INSTANCE_NUMBER' ||
'      (0020, 0020)  PATIENT_ORIENTATION' ||
'      (0020, 9072)  FRAME_LATERALITY' ||
'' ||
'      (0028, 0002)  SAMPLES_PER_PIXEL' ||
'      (0028, 0004)  PHOTOMETRIC_INTERPRETATION' ||
'      (0028, 0006)  PLANAR_CONFIGURATION' ||
'      (0028, 0010)  ROWS' ||
'      (0028, 0011)  COLUMNS' ||
'      (0028, 0034)  PIXEL_ASPECT_RATIO' ||
'      (0028, 0100)  BIT_ALLOCATED' ||
'      (0028, 0101)  BIT_STORED' ||
'      (0028, 0102)  HIGH_BIT' ||
'      (0028, 0103)  PIXEL_REPRESENTATION' ||
'' ||
'      (0040, 0244)  PERFORMED_PROCEDURE_STEP_START_DATE' ||
'      (0040, 0245)  PERFORMED_PROCEDURE_STEP_START_TIME' ||
'      (0040, 0253)  PERFORMED_PROCEDURE_STEP_ID' ||
'      (0040, 0254)  PERFORMED_PROCEDURE_STEP_DESCRIPTION' ||
'      (0040, 0260)  PERFORMED_PROTOCOL_CODE_SEQUENCE' ||
'' ||
'        ' ||
'  </xs:documentation>' ||
'</xs:annotation>' ||
'' ||
'' ||
'<xs:element name="DICOM_IMAGE" xdb:defaultTable="">' ||
'  <xs:complexType>' ||
'  <xs:sequence>' ||
'    <xs:element name="ORD_DICOM_HEADER">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- XML document version number is "1.0" for database release 10gR2 -->' ||
'        <xs:element name="VERSION" type="SH"/>' ||
'        <!-- The DICOM Base Standard version this XML document is derived from is "3". -->' ||
'        <xs:element name="DICOM_STANDARD_VERSION" type="SH"/>' ||
'        <!-- The DICOM Base Standard this XML document is derived from is 2004. -->' ||
'        <xs:element name="DICOM_STANDARD_RELEASE" type="SH"/>' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'    <xs:element name="FILE_META_HEADER" minOccurs="0">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- (0002, 0002), mandatory-->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null -->' ||
'        <xs:element name="MEDIA_STORAGE_SOP_CLASS_UID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="UI">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0002, 0003), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="MEDIA_STORAGE_SOP_INSTANCE_UID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="UI">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0002, 0010), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="TRANSFER_SYNTAX_UID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="UI">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0002, 0012), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="IMPLEMENTATION_CLASS_UID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="UI">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0002, 0013), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="IMPLEMENTATION_VERSION_NAME" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="SH">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0002, 0016), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="SOURCE_APPLICATION_ENTITY_TITLE" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="AE">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'    <xs:element name="PATIENT" minOccurs="0">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- (0010, 0010), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="NAME" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="PN">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0010, 0020), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="LO">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0010, 0030), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="BIRTH_DATE" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="DA">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0010, 0040), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="SEX" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="CS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'    <xs:element name="GENERAL_STUDY" minOccurs="0">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- (0020, 000D) mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="INSTANCE_UID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="UI">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0020), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="DATE" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="DA">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0030), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="TIME" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="TM">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0090), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="REFERING_PHYSICIANS_NAME" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="PN">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0020, 0010), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="SH">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0050), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ACCESSION_NUMBER" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="SH">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 1030) optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="DESCRIPTION" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="LO">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'    <xs:element name="PATIENT_STUDY" minOccurs="0">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- (0008, 1080), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ADMITTING_DIAGNOSES_DESCRIPTION" minOccurs="0" maxOccurs="unbounded" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="LO">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 1084), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ADMITTING_DIAGNOSES_CODE_SEQUENCE" minOccurs="0" nillable="true" type="CODE_SQ">' ||
'        </xs:element>' ||
' ' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'' ||
'' ||
'    <xs:element name="GENERAL_SERIES" minOccurs="0">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- (0008, 0060), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="MODALITY" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="CS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0020, 000E), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="INSTANCE_UID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="UI">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0021), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="DATE" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="DA">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0031), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="TIME" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="TM">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 1050), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PERFORMING_PHYSICIANS_NAME" minOccurs="0" maxOccurs="unbounded" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="PN">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0018, 0015), optional -->' ||
'        <!-- Note will not replace with modality specific values -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="BODY_PART_EXAMINED" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="CS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0018, 5100), conditional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PATIENT_POSITION" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="CS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0040, 0253), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PERFORMED_PROCEDURE_STEP_ID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="SH">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0040, 0244), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PERFORMED_PROCEDURE_STEP_START_DATE" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="DA">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0040, 0245), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PERFORMED_PROCEDURE_STEP_START_TIME" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="TM">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0040, 0254), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PERFORMED_PROCEDURE_STEP_DESCRIPTION" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="LO">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0040, 0260), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PERFORMED_PROTOCOL_CODE_SEQUENCE" minOccurs="0" nillable="true" type="CODE_SQ">' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'' ||
'    <xs:element name="GENERAL_EQUIPMENT" minOccurs="0">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- (0008, 0070), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="MANUFACTURER" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="LO">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'' ||
'    <xs:element name="GENERAL_IMAGE" minOccurs="0">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- (0020, 0013), nullable -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="INSTANCE_NUMBER" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="IS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0020, 0012), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ACQUISITION_NUMBER" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="IS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0022), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ACQUISITION_DATE" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="DA">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0032), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ACQUISITION_TIME" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="TM">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 002A), optional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ACQUISITION_DATETIME" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="DT">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0020, 0020), conditional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PATIENT_ORIENTATION" minOccurs="0" maxOccurs="2" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="CS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0020, 9072) conditional-->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="FRAME_LATERALITY" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="CS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 2218) Frame anatomy macro, conditional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="ANATOMIC_REGION" minOccurs="0" nillable="true" type="CODE_SQ">' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'' ||
'    <xs:element name="IMAGE_PIXEL" minOccurs="0">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- (0028, 0002), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="SAMPLES_PER_PIXEL" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="US">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0028, 0004), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PHOTOMETRIC_INTERPRETATION" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="CS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0028, 0010), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ;

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

  ordSchema := 
'        <xs:element name="ROWS" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="US">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0028, 0011), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="COLUMNS" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="US">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0028, 0100), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="BIT_ALLOCATED" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="US">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0028, 0101), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="BIT_STORED" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="US">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0028, 0102), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="HIGH_BIT" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="US">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0028, 0103), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PIXEL_REPRESENTATION" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="US">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (7FE0, 0010) PIXEL_DATA, not included -->' ||
'        <!-- (0028, 0006), conditional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PLANAR_CONFIGURATION" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="US">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0028, 0034), conditional -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="PIXEL_ASPECT_RATIO" minOccurs="0" maxOccurs="2" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="IS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'' ||
'    <xs:element name="SOP_COMMON" minOccurs="0">' ||
'       <xs:complexType>' ||
'      <xs:sequence>' ||
'        <!-- (0008, 0016), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="CLASS_UID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="UI">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0018), mandatory -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="INSTANCE_UID" minOccurs="0" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="UI">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <!-- (0008, 0005) -->' ||
'        <!-- DICOM standard requires this attribute to be mandatory and not null --> ' ||
'        <xs:element name="SPECIFIC_CHARACTER_SET" minOccurs="0" maxOccurs="unbounded" nillable="true">' ||
'          <xs:complexType>' ||
'             <xs:simpleContent>' ||
'             <xs:extension base="CS">' ||
'             <xs:attribute name="rawValue" type="xs:string"/>' ||
'             </xs:extension>' ||
'             </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'       </xs:complexType>' ||
'    </xs:element>' ||
'' ||
'  </xs:sequence>' ||
'  </xs:complexType>' ||
'</xs:element>' ||
'' ||
'' ||
'<!-- Complex data type -->' ||
'<!-- code sequence -->' ||
'<xs:complexType name="CODE_SQ">' ||
'  <xs:sequence>' ||
'    <xs:element name="CODE_SEQUENCE" type="CODE_SEQUENCE" maxOccurs="unbounded"/>' ||
'  </xs:sequence>' ||
'  <xs:attribute name="rawValue" type="xs:string"/>' ||
'</xs:complexType>' ||
'' ||
'<xs:complexType name="CODE_SEQUENCE">' ||
'  <xs:sequence>' ||
'    <xs:element name="ITEM_NUMBER" type="xs:positiveInteger"/>' ||
'    <xs:element name="CODE_VALUE" type="xs:string"/>' ||
'    <xs:element name="CODING_SCHEME" type="xs:string"/>' ||
'    <xs:element name="CODING_SCHEME_VERSION" type="xs:string" minOccurs="0"/>' ||
'    <xs:element name="CODING_MEANING" type="xs:string" minOccurs="0"/>' ||
'  </xs:sequence>' ||
'</xs:complexType>' ||
'' ||
'' ||
'' ||
'' ||
'<!-- Simple data types -->' ||
'<!-- Application Entity -->' ||
'<xs:simpleType name="AE">' ||
'  <xs:restriction base="xs:string">' ||
'    <xs:maxLength value="16"/>' ||
'  </xs:restriction>' ||
'</xs:simpleType>' ||
'' ||
'<!-- Coded String -->' ||
'<xs:simpleType name="CS">' ||
'  <xs:restriction base="xs:token">' ||
'    <xs:maxLength value="16"/>' ||
'  </xs:restriction>' ||
'</xs:simpleType>' ||
'' ||
'<!-- DAte -->' ||
'<xs:simpleType name="DA">' ||
'  <xs:restriction base="xs:date"/>' ||
'</xs:simpleType>' ||
'' ||
'<!-- DateTime -->' ||
'<xs:simpleType name="DT">' ||
'  <xs:restriction base="xs:dateTime"/>' ||
'</xs:simpleType>' ||
'' ||
'<!-- Integer String -->' ||
'<xs:simpleType name="IS">' ||
'  <xs:restriction base="xs:integer"/>' ||
'</xs:simpleType>' ||
'' ||
'<!-- LOng string -->' ||
'<xs:simpleType name="LO">' ||
'  <xs:restriction base="xs:string">' ||
'    <xs:maxLength value="64"/>' ||
'  </xs:restriction>' ||
'</xs:simpleType>' ||
'' ||
'<!-- Person Name -->' ||
'<xs:simpleType name="PN">' ||
'  <xs:restriction base="xs:token">' ||
'    <xs:maxLength value="64"/>' ||
'  </xs:restriction>' ||
'</xs:simpleType>' ||
'' ||
'<!-- SHort String -->' ||
'<xs:simpleType name="SH">' ||
'  <xs:restriction base="xs:string">' ||
'    <xs:maxLength value="16"/>' ||
'  </xs:restriction>' ||
'</xs:simpleType>' ||
'' ||
'<!-- Short String -->' ||
'<xs:simpleType name="SS">' ||
'  <xs:restriction base="xs:short"/>' ||
'</xs:simpleType>' ||
'' ||
'<!-- TiMe -->' ||
'<xs:simpleType name="TM">' ||
'  <xs:restriction base="xs:time"/>' ||
'</xs:simpleType>' ||
'' ||
'<!-- UId -->' ||
'<xs:simpleType name="UI">' ||
'  <xs:restriction base="xs:token">' ||
'    <xs:maxLength value="64"/>' ||
'    <xs:pattern value=''([0-9]+\.)*[0-9]+''/>' ||
'  </xs:restriction>' ||
'</xs:simpleType>' ||
'' ||
'' ||
'<!-- Unsigned Short -->' ||
'<xs:simpleType name="US">' ||
'  <xs:restriction base="xs:unsignedShort"/>' ||
'</xs:simpleType>' ||
'' ||
'' ||
'</xs:schema>';
  sys.dbms_lob.writeAppend(ordClob, length(ordSchema), ordSchema);

exception
 when others then
  raise;
end;

begin
 begin
   select schema into old_s 
   from sys.dba_xml_schemas 
   where owner='ORDSYS' and
         schema_url='http://xmlns.oracle.com/ord/meta/dicomImage';

   if (old_s.existsNode('/schema/complexType/attribute[@name="rawValue"]') = 0) then
     new_s := sys.XMLType(ordClob);
     xdb.dbms_xmlschema.copyEvolve
     (schemaURLs=>xdb.xdb$string_list_t('http://xmlns.oracle.com/ord/meta/dicomImage'),
      newSchemas=>sys.XMLSequenceType(new_s),
      transforms=>NULL,
      preserveOldDocs=>FALSE,
      mapTabName=>NULL,
      generateTables=>TRUE,
      force=>FALSE,
      schemaOwners=>xdb.xdb$string_list_t('ORDSYS') 
     );
   end if;
   sys.dbms_lob.freeTemporary(ordClob);
 exception
   when no_data_found then
     xdb.dbms_xmlschema.registerSchema
     (schemaURL=>'http://xmlns.oracle.com/ord/meta/dicomImage',
      schemaDoc=>ordClob,
      local=>FALSE,
      genTypes=>TRUE,
      genBean=>FALSE,
      genTables=>FALSE,
      force=>FALSE,
      owner=>'ORDSYS'
     );
   when others then
     raise;
 end;

exception
  when ex then 
    null;
  when others then
    raise;
end;
end;
/


-- Register ordexif.xsd with XDB under http://xmlns.oracle.com/ord/meta/exif
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2004, 2008, Oracle and/or its affiliates.' ||
'All rights reserved. -->' ||
'<xsd:schema targetNamespace="http://xmlns.oracle.com/ord/meta/exif"' ||
'            xmlns="http://xmlns.oracle.com/ord/meta/exif"' ||
'            xmlns:xsd="http://www.w3.org/2001/XMLSchema"' ||
'            elementFormDefault="qualified"' ||
'            attributeFormDefault="unqualified"' ||
'            version="1.0">' ||
'' ||
'  <xsd:annotation>' ||
'    <xsd:documentation>' ||
'      Change History' ||
'        rabbott   11/06/2008      -- Make GPSVersionID optional' ||
'        rabbott    2/10/2005      -- Add more comments' ||
'        rabbott    6/10/2004      -- Created' ||
'    ' ||
'      Introduction' ||
'' ||
'        This is the Oracle Multimedia schema for image metadata stored' ||
'        in the EXIF format for digital still cameras. This schema supports' ||
'        tags defined up to EXIF version 2.21' ||
'' ||
'        Metadata extracted only from the 0th IFD. For JPEG images, this means' ||
'        that the metadata comes from the main image in the file. Metadata is not' ||
'        extracted for the thumbnail image (1st IFD).' ||
'' ||
'      Structure' ||
'' ||
'        This schema defines a single global element exifMetadata which' ||
'        contains up to four child elements. Each child element contains tags' ||
'        from a TIFF IFD directory as defined by the EXIF standard.' ||
'' ||
'              TiffIfd contains tags from the TIFF IFD. ' ||
'              ExifIfd contains tags from the EXIF IFD. ' ||
'              GpsIfd  contains tags from the GPS IFD. ' ||
'              InteroperabilityIfd contains tags from the Interoperability IFD.' ||
'' ||
'        All elements that derive directly from EXIF tags contain a required ' ||
'        "tag" attribute. The value of this attribute is the Tag ID value as' ||
'        defined in the EXIF standard.' ||
'   ' ||
'      Unsupported tags' ||
'        The table below lists tags that are defined by the EXIF standard' ||
'        but which the current version of Oracle Multimedia does not ' ||
'        read from image files. Note that this schema does define data ' ||
'        models for these tags and future versions of Oracle' ||
'        Multimedia may parse these fields from image files. Those tags ' ||
'        could be represented by documents conforming to this schema.' ||
'' ||
'          These tags are from the TIFF IFD' ||
'          tag   301:  TransferFunction' ||
'          tag   318:  WhitePoint' ||
'          tag   319:  PrimaryChromaticities' ||
'          tag   529:  YCbCrCoefficients' ||
'          tag   532:  ReferenceWhiteBlack' ||
'' ||
'          tag   273:  StripOffsets' ||
'          tag   278:  RowsPerStrip' ||
'          tag   279:  StripByteCounts' ||
'          tag   513:  JPEGInterChangeFormat' ||
'          tag   514:  JPEGInterChangeFormatLength' ||
'' ||
'          These tags are from the EXIF IFD' ||
'' ||
'          tag 34855:  ISOSpeedRatings' ||
'          tag 34856:  OECF' ||
'          tag 37396:  SubjectArea' ||
'          tag 37500:  MakerNote' ||
'          tag 41484:  SpatialFrequencyResponse' ||
'          tag 41492:  SubjectLocation' ||
'          tag 41730:  CFAPattern' ||
'          tag 41995:  DeviceSettingsDescription' ||
'          tag 42016:  ImageUniqueID' ||
'' ||
'    </xsd:documentation>' ||
'  </xsd:annotation>' ||
'' ||
'' ||
'  <!-- ' ||
'    ATTRIBUTE DEFINITIONS ' ||
'   -->' ||
'  <xsd:attributeGroup name="exifAttrs">' ||
'    <xsd:annotation>' ||
'      <xsd:documentation>' ||
'         This attribute group defines a single attribute that is required' ||
'         for all elements. The tag attribute value is the TIFF tag value ' ||
'         (in decimal) that is the datasource  for the tag.' ||
'      </xsd:documentation>' ||
'    </xsd:annotation>' ||
'    <xsd:attribute name="tag" type="xsd:nonNegativeInteger" use="required"/>' ||
'  </xsd:attributeGroup>' ||
'' ||
'' ||
'  <!-- BASE TYPE DEFINITIONS' ||
'         Base types are formed from the simple XML schema types.' ||
'         Sometimes restrictions are added.' ||
'         They are extended with the required "tag" attribute' ||
'   -->' ||
'  <xsd:complexType name="positiveIntegerType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="xsd:positiveInteger">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="nonNegativeIntegerType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="xsd:nonNegativeInteger">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="stringType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="xsd:string">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="nonNegativeRealType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="nonNegativeReal">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="nonNegativeReal">' ||
'    <xsd:restriction base="xsd:float">' ||
'      <xsd:minInclusive value="0"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="realType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="xsd:float">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="dateType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="xsd:date">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="dateTimeType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="xsd:dateTime">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="timeType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="xsd:time">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'' ||
'' ||
'  <!-- EXIF TYPE DEFINITIONS' ||
'       Generally these types are formed from a simple type that is restricted.' ||
'       The simple type is extended with the required ''tag'' attribute' ||
'       These types form the basis for the document elements' ||
'    -->' ||
'  <xsd:complexType name="colorSpaceType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="colorSpace_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="colorSpace_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="sRGB"/>' ||
'      <xsd:enumeration value="Uncalibrated"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="exposureProgramType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="exposureProgram_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="exposureProgram_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Not defined"/>' ||
'      <xsd:enumeration value="Manual"/>' ||
'      <xsd:enumeration value="Normal program"/>' ||
'      <xsd:enumeration value="Aperture priority"/>' ||
'      <xsd:enumeration value="Shutter priority"/>' ||
'      <xsd:enumeration value="Creative program"/>' ||
'      <xsd:enumeration value="Action program"/>' ||
'      <xsd:enumeration value="Portrait mode"/>' ||
'      <xsd:enumeration value="Landscape mode"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="meteringModeType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="meteringMode_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="meteringMode_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="unknown"/>' ||
'      <xsd:enumeration value="Average"/>' ||
'      <xsd:enumeration value="Center Weighted Average"/>' ||
'      <xsd:enumeration value="Spot"/>' ||
'      <xsd:enumeration value="MultiSpot"/>' ||
'      <xsd:enumeration value="Pattern"/>' ||
'      <xsd:enumeration value="Partial"/>' ||
'      <xsd:enumeration value="other"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="lightSourceType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="lightSource_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="lightSource_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="unknown"/>' ||
'      <xsd:enumeration value="Daylight"/>' ||
'      <xsd:enumeration value="Fluorescent"/>' ||
'      <xsd:enumeration value="Tungsten"/>' ||
'      <xsd:enumeration value="Flash"/>' ||
'      <xsd:enumeration value="Fine weather"/>' ||
'      <xsd:enumeration value="Cloudy weather"/>' ||
'      <xsd:enumeration value="Shade"/>' ||
'      <xsd:enumeration value="Daylight fluorescent"/>' ||
'      <xsd:enumeration value="Day white fluorescent"/>' ||
'      <xsd:enumeration value="Cool white fluorescent"/>' ||
'      <xsd:enumeration value="Standard light A"/>' ||
'      <xsd:enumeration value="Standard light B"/>' ||
'      <xsd:enumeration value="Standard light C"/>' ||
'      <xsd:enumeration value="D55"/>' ||
'      <xsd:enumeration value="D65"/>' ||
'      <xsd:enumeration value="D75"/>' ||
'      <xsd:enumeration value="D50"/>' ||
'      <xsd:enumeration value="ISO studio tungsten"/>' ||
'      <xsd:enumeration value="other light source"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="flashType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="Fired" type="yesNo_t"/>' ||
'      <xsd:element name="Return" type="flashReturn_t" minOccurs="0"/>' ||
'      <xsd:element name="Mode" type="flashMode_t" minOccurs="0"/>' ||
'      <xsd:element name="Function" type="yesNo_t" minOccurs="0"/>' ||
'      <xsd:element name="RedEyeReduction" type="yesNo_t" minOccurs="0"/>' ||
'    </xsd:sequence>' ||
'    <xsd:attributeGroup ref="exifAttrs"/>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="yesNo_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Yes"/>' ||
'      <xsd:enumeration value="No"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'  <xsd:simpleType name="flashReturn_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="No strobe return function"/>' ||
'      <xsd:enumeration value="Strobe return not detected"/>' ||
'      <xsd:enumeration value="Strobe return detected"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'  <xsd:simpleType name="flashMode_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="unknown"/>' ||
'      <xsd:enumeration value="Compulsory firing"/>' ||
'      <xsd:enumeration value="Compulsory suppression"/>' ||
'      <xsd:enumeration value="Auto"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="resolutionType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="resolution_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="resolution_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="inches"/>' ||
'      <xsd:enumeration value="centimeters"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="sensingMethodType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="sensingMethod_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="sensingMethod_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Not defined"/>' ||
'      <xsd:enumeration value="One-chip color area"/>' ||
'      <xsd:enumeration value="Two-chip color area"/>' ||
'      <xsd:enumeration value="Three-chip color area"/>' ||
'      <xsd:enumeration value="Color-sequential area"/>' ||
'      <xsd:enumeration value="Trilinear"/>' ||
'      <xsd:enumeration value="Color sequential linear"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="fileSourceType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="fileSource_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="fileSource_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="others"/>' ||
'      <xsd:enumeration value="scanner of transparent type"/>' ||
'      <xsd:enumeration value="scanner of reflex type"/>' ||
'      <xsd:enumeration value="DSC"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="bitsPerSampleType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="bitsPerSample_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="bitsPerSample_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="8,8,8"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="compressionType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="compression_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="compression_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="uncompressed"/>' ||
'      <xsd:enumeration value="JPEG"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="photometricInterpretationType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="photometricInterpretation_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="photometricInterpretation_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="RGB"/>' ||
'      <xsd:enumeration value="YCbCr"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="orientationType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="orientation_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="orientation_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="top left"/>' ||
'      <xsd:enumeration value="top right"/>' ||
'      <xsd:enumeration value="bottom right"/>' ||
'      <xsd:enumeration value="bottom left"/>' ||
'      <xsd:enumeration value="left top"/>' ||
'      <xsd:enumeration value="right top"/>' ||
'      <xsd:enumeration value="right bottom"/>' ||
'      <xsd:enumeration value="left bottom"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="planarConfigurationType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="planarConfiguration_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="planarConfiguration_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="chunky"/>' ||
'      <xsd:enumeration value="planar"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="yCbCrSubSamplingType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="yCbCrSubSampling_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="yCbCrSubSampling_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="4:2:2"/>' ||
'      <xsd:enumeration value="4:2:0"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="yCbCrPositioningType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="yCbCrPositioning_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="yCbCrPositioning_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="centered"/>' ||
'      <xsd:enumeration value="co-sited"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="stripOffsetsType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="StripOffset" maxOccurs="unbounded">' ||
'        <xsd:complexType>' ||
'          <xsd:sequence>' ||
'            <xsd:element name="Index" type="xsd:nonNegativeInteger"/>' ||
'            <xsd:element name="Offset" type="xsd:positiveInteger"/>' ||
'          </xsd:sequence>' ||
'        </xsd:complexType>' ||
'      </xsd:element>' ||
'    </xsd:sequence>' ||
'    <xsd:attributeGroup ref="exifAttrs"/>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="stripByteCountsType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="StripByteCount" maxOccurs="unbounded">' ||
'        <xsd:complexType>' ||
'          <xsd:sequence>' ||
'            <xsd:element name="Index" type="xsd:nonNegativeInteger"/>' ||
'            <xsd:element name="Bytes" type="xsd:positiveInteger"/>' ||
'          </xsd:sequence>' ||
'        </xsd:complexType>' ||
'      </xsd:element>' ||
'    </xsd:sequence>' ||
'    <xsd:attributeGroup ref="exifAttrs"/>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="whitePointType">' ||
'    <xsd:complexContent>' ||
'      <xsd:extension base="chromaticity">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:complexContent>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="primaryChromaticitiesType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="Color_1" type="chromaticity"/>' ||
'      <xsd:element name="Color_2" type="chromaticity"/>' ||
'      <xsd:element name="Color_3" type="chromaticity"/>' ||
'    </xsd:sequence>' ||
'    <xsd:attributeGroup ref="exifAttrs"/>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="chromaticity">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="X" type="nonNegativeReal"/>' ||
'      <xsd:element name="Y" type="nonNegativeReal"/>' ||
'    </xsd:sequence>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="yCbCrCoefficientsType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="Coefficient_1" type="nonNegativeReal"/>' ||
'      <xsd:element name="Coefficient_2" type="nonNegativeReal"/>' ||
'      <xsd:element name="Coefficient_3" type="nonNegativeReal"/>' ||
'    </xsd:sequence>' ||
'    <xsd:attributeGroup ref="exifAttrs"/>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="subjectLocationType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="CenterX" type="xsd:nonNegativeInteger"/>' ||
'      <xsd:element name="CenterY" type="xsd:nonNegativeInteger"/>' ||
'    </xsd:sequence>' ||
'    <xsd:attributeGroup ref="exifAttrs"/>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="subjectAreaType">' ||
'    <xsd:complexContent>' ||
'      <xsd:extension base="subjectLocationType">' ||
'        <xsd:choice>' ||
'          <xsd:element name="Diameter" type="xsd:positiveInteger"/>' ||
'          <xsd:sequence>' ||
'            <xsd:element name="Width" type="xsd:positiveInteger"/>' ||
'            <xsd:element name="Height" type="xsd:positiveInteger"/>' ||
'          </xsd:sequence>' ||
'        </xsd:choice>' ||
'      </xsd:extension>' ||
'    </xsd:complexContent>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="customRenderedType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="customRendered_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="customRendered_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Normal process"/>' ||
'      <xsd:enumeration value="Custom process"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="exposureModeType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="exposureMode_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="exposureMode_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Auto exposure"/>' ||
'      <xsd:enumeration value="Manual exposure"/>' ||
'      <xsd:enumeration value="Auto bracket"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="whiteBalanceType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="whiteBalance_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="whiteBalance_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Auto"/>' ||
'      <xsd:enumeration value="Manual"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="sceneCaptureType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="sceneCapture_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="sceneCapture_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Standard"/>' ||
'      <xsd:enumeration value="Landscape"/>' ||
'      <xsd:enumeration value="Portrait"/>' ||
'      <xsd:enumeration value="Night scene"/>' ||
'      <xsd:enumeration value=""/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gainControlType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gainControl_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gainControl_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="None"/>' ||
'      <xsd:enumeration value="Low gain up"/>' ||
'      <xsd:enumeration value="High gain up"/>' ||
'      <xsd:enumeration value="Low gain down"/>' ||
'      <xsd:enumeration value="High gain down"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="contrastType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="contrast_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="contrast_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Normal"/>' ||
'      <xsd:enumeration value="Soft"/>' ||
'      <xsd:enumeration value="Hard"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="saturationType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="saturation_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="saturation_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Normal"/>' ||
'      <xsd:enumeration value="Low saturation"/>' ||
'      <xsd:enumeration value="High saturation"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="sharpnessType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="contrast_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="subjectDistanceRangeType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="subjectDistanceRange_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="subjectDistanceRange_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="unknown"/>' ||
'      <xsd:enumeration value="Macro"/>' ||
'      <xsd:enumeration value="Close view"/>' ||
'      <xsd:enumeration value="Distant view"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="uuidType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="uuid_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="uuid_t">' ||
'    <xsd:restriction base="xsd:hexBinary">' ||
'      <xsd:pattern value=".{8}-.{4}-.{4}-.{4}-.{12}"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <!-- ' ||
'       TYPES FOR THE GPS IFD ' ||
'   -->' ||
'  <xsd:complexType name="gpsLatitudeRefType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsLatitudeRef_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsLatitudeRef_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="North latitude"/>' ||
'      <xsd:enumeration value="South latitude"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsAltitudeRefType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsAltitudeRef_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsAltitudeRef_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Sea level"/>' ||
'      <xsd:enumeration value="Sea level reference"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsLatitudeType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsLatitude_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsLatitude_t">' ||
'    <xsd:restriction base="xsd:float">' ||
'      <xsd:minInclusive value="0.0"/>' ||
'      <xsd:maxInclusive value="90.0"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsLongitudeRefType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsLongitudeRef_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsLongitudeRef_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="East longitude"/>' ||
'      <xsd:enumeration value="West longitude"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsLongitudeType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsLongitude_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsLongitude_t">' ||
'    <xsd:restriction base="xsd:float">' ||
'      <xsd:minInclusive value="0.0"/>' ||
'      <xsd:maxInclusive value="180.0"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsBearingType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsBearing_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsBearing_t">' ||
'    <xsd:restriction base="xsd:float">' ||
'      <xsd:minInclusive value="0.0"/>' ||
'      <xsd:maxExclusive value="360.0"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsStatusType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsStatus_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsStatus_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Measurement in progress"/>' ||
'      <xsd:enumeration value="Measurement interoperability"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsMeasureModeType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsMeasureMode_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ;

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

  ordSchema := 
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsMeasureMode_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="2-dimensional measurement"/>' ||
'      <xsd:enumeration value="3-dimensional measurement"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsSpeedRefType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsSpeedRef_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsSpeedRef_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Kilometers per hour"/>' ||
'      <xsd:enumeration value="Miles per hour"/>' ||
'      <xsd:enumeration value="Knots"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsDirectionType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsDirection_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsDirection_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="True direction"/>' ||
'      <xsd:enumeration value="Magnetic direction"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsDistanceRefType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsDistanceRef_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsDistanceRef_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Kilometers"/>' ||
'      <xsd:enumeration value="Miles"/>' ||
'      <xsd:enumeration value="Knots"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <xsd:complexType name="gpsDifferentialType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="gpsDifferential_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="gpsDifferential_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="Measurement without differential correction"/>' ||
'      <xsd:enumeration value="Differential correction applied"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'  <!-- ' ||
'       TYPES FOR THE INTEROPERABILTY IFD' ||
'     -->' ||
'  <xsd:complexType name="interoperabilityType">' ||
'    <xsd:simpleContent>' ||
'      <xsd:extension base="interoperability_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:simpleContent>' ||
'  </xsd:complexType>' ||
'  <xsd:simpleType name="interoperability_t">' ||
'    <xsd:restriction base="xsd:string">' ||
'      <xsd:enumeration value="R98"/>' ||
'      <xsd:enumeration value="THM"/>' ||
'      <xsd:enumeration value="R03"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'' ||
'' ||
'  <!-- GENERIC TYPE' ||
'' ||
'        A generic type to hold any type of tag data. ' ||
'        Defines a name, value, datatype triplet ' ||
'        Datatype values refer to types as defined by XML Schema.' ||
'' ||
'        singleFieldType is for EXIF tag that define a single ' ||
'        value, the common case.' ||
'' ||
'        repeatedFieldTyp is for the uncommon case where many' ||
'        data items are defined in an EXIF tag.' ||
'' ||
'    -->' ||
'  <xsd:complexType name="singleFieldType">' ||
'    <xsd:complexContent>' ||
'      <xsd:extension base="singleField_t">' ||
'        <xsd:attributeGroup ref="exifAttrs"/>' ||
'      </xsd:extension>' ||
'    </xsd:complexContent>' ||
'  </xsd:complexType>' ||
'    ' ||
'  <xsd:complexType name="repeatedFieldType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="Field" type="singleField_t" minOccurs="1" maxOccurs="unbounded"/>' ||
'    </xsd:sequence>' ||
'    <xsd:attributeGroup ref="exifAttrs"/>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:complexType name="singleField_t">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="Name" type="xsd:string"/>' ||
'      <xsd:element name="Value" type="xsd:string"/>' ||
'      <xsd:element name="Datatype">' ||
'        <xsd:simpleType>' ||
'          <xsd:annotation>' ||
'            <xsd:documentation>The enumerated datatype values refer to types ' ||
'                defined by XML Schema' ||
'            </xsd:documentation>' ||
'          </xsd:annotation>' ||
'          <xsd:restriction base="xsd:string">' ||
'            <xsd:enumeration value="string"/>' ||
'            <xsd:enumeration value="integer"/>' ||
'            <xsd:enumeration value="float"/>' ||
'            <xsd:enumeration value="date"/>' ||
'            <xsd:enumeration value="time"/>' ||
'            <xsd:enumeration value="dateTime"/>' ||
'            <xsd:enumeration value="hexBinary"/>' ||
'          </xsd:restriction>' ||
'        </xsd:simpleType>' ||
'      </xsd:element>' ||
'    </xsd:sequence>' ||
'  </xsd:complexType>' ||
'' ||
'  <!-- END TYPE DEFINITIONS -->' ||
'' ||
'  <!-- ' ||
'       THE GLOBAL ELEMENT' ||
'    -->' ||
'  <xsd:element name="exifMetadata">' ||
'    <xsd:complexType>' ||
'      <xsd:sequence>' ||
'        <xsd:element name="TiffIfd" minOccurs="0">' ||
'          <xsd:annotation>' ||
'            <xsd:documentation>Tags from the TIFF IFD</xsd:documentation>' ||
'          </xsd:annotation>' ||
'          <xsd:complexType>' ||
'            <xsd:all>' ||
'' ||
'              <!-- Tags relating to image data structure -->' ||
'              <xsd:element name="ImageWidth" type="positiveIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="ImageLength" type="positiveIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="BitsPerSample" type="bitsPerSampleType" minOccurs="0"/>' ||
'              <xsd:element name="Compression" type="compressionType" minOccurs="0"/>' ||
'              <xsd:element name="PhotometricInterpretation" type="photometricInterpretationType" minOccurs="0"/>' ||
'              <xsd:element name="Orientation" type="orientationType" minOccurs="0"/>' ||
'              <xsd:element name="SamplesPerPixel" type="positiveIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="PlanarConfiguration" type="planarConfigurationType" minOccurs="0"/>' ||
'              <xsd:element name="YCbCrSubSampling" type="yCbCrSubSamplingType" minOccurs="0"/>' ||
'              <xsd:element name="YCbCrPositioning" type="yCbCrPositioningType" minOccurs="0"/>' ||
'              <xsd:element name="XResolution" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>Unit is pixels per ResolutionUnit</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="YResolution" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>Unit is pixels per Resolution Unit</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="ResolutionUnit" type="resolutionType" minOccurs="0"/>' ||
'' ||
'              <!--Tags relating to recording offset -->' ||
'              <xsd:element name="StripOffsets" type="stripOffsetsType" minOccurs="0"/>' ||
'              <xsd:element name="RowsPerStrip" type="positiveIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="StripByteCounts" type="stripByteCountsType" minOccurs="0"/>' ||
'              <xsd:element name="JPEGInterChangeFormat" type="positiveIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="JPEGInterChangeFormatLength" type="positiveIntegerType" minOccurs="0"/>' ||
'' ||
'              <!-- Tags relating to image data characteristics -->' ||
'              <xsd:element name="TransferFunction" type="xsd:anyType" minOccurs="0"/>' ||
'              <xsd:element name="WhitePoint" type="whitePointType" minOccurs="0"/>' ||
'              <xsd:element name="PrimaryChromaticities" type="primaryChromaticitiesType" minOccurs="0"/>' ||
'              <xsd:element name="YCbCrCoefficients" type="yCbCrCoefficientsType" minOccurs="0"/>' ||
'              <xsd:element name="ReferenceBlackWhite" type="primaryChromaticitiesType" minOccurs="0"/>' ||
'' ||
'              <!--Other tags -->' ||
'              <xsd:element name="DateTime" type="dateTimeType" minOccurs="0"/>' ||
'              <xsd:element name="ImageDescription" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="Make" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="Model" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="Software" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="Artist" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="Copyright" type="stringType" minOccurs="0"/>' ||
'' ||
'              <!-- Placeholder tags for future tags that may be defined -->' ||
'              <xsd:element name="TiffField1" type="singleFieldType" minOccurs="0"/>' ||
'              <xsd:element name="TiffField2" type="singleFieldType" minOccurs="0"/>' ||
'              <xsd:element name="TiffField3" type="repeatedFieldType" minOccurs="0"/>' ||
'' ||
'            </xsd:all>' ||
'          </xsd:complexType>' ||
'        </xsd:element>' ||
'' ||
'        <xsd:element name="ExifIfd">' ||
'          <xsd:annotation>' ||
'            <xsd:documentation>Tags from the EXIF IFD</xsd:documentation>' ||
'          </xsd:annotation>' ||
'          <xsd:complexType>' ||
'            <xsd:all>' ||
'' ||
'              <!-- Tags releating to version -->' ||
'              <xsd:element name="ExifVersion" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="FlashpixVersion" type="stringType" minOccurs="0"/>' ||
'' ||
'              <!-- Tags relating to image data characteristics -->' ||
'              <xsd:element name="ColorSpace" type="colorSpaceType" minOccurs="0"/>' ||
'' ||
'              <!-- Tags relating to image configuration -->' ||
'              <xsd:element name="ComponentsConfiguration" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="CompressedBitsPerPixel" type="nonNegativeRealType" minOccurs="0"/>' ||
'              <xsd:element name="PixelXDimension" type="nonNegativeIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="PixelYDimension" type="nonNegativeIntegerType" minOccurs="0"/>' ||
'' ||
'              <!-- Tags relating to user information -->' ||
'              <xsd:element name="MakerNote" type="repeatedFieldType" minOccurs="0"/>' ||
'              <xsd:element name="UserComment" type="stringType" minOccurs="0"/>' ||
'' ||
'              <!-- Tag relating to related file information -->' ||
'              <xsd:element name="RelatedSoundFile" type="stringType" minOccurs="0"/>' ||
'' ||
'              <!-- Tags relating to date and time -->' ||
'              <xsd:element name="DateTimeOriginal" type="dateTimeType" minOccurs="0"/>' ||
'              <xsd:element name="DateTimeDigitized" type="dateTimeType" minOccurs="0"/>' ||
'              <xsd:element name="SubSecTime" type="nonNegativeIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="SubSecTimeOriginal" type="nonNegativeIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="SubSecTimeDigitized" type="nonNegativeIntegerType" minOccurs="0"/>' ||
'' ||
'              <!-- Tags relating to picture taking conditions -->' ||
'              <xsd:element name="ExposureTime" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>Units is seconds</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="FNumber" type="nonNegativeRealType" minOccurs="0"/>' ||
'              <xsd:element name="ExposureProgram" type="exposureProgramType" minOccurs="0"/>' ||
'              <xsd:element name="SpectralSensitivity" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="ISOSpeedRatings" type="nonNegativeIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="OECF" type="repeatedFieldType" minOccurs="0"/>' ||
'              <xsd:element name="ShutterSpeedValue" type="realType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The unit is the APEX Value</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="ApertureValue" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The  unit is the APEX value</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="BrightnessValue" type="realType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The unit is the APEX value</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="ExposureBiasValue" type="realType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The unit is the APEX value</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="MaxApertureValue" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The unit is the APEX value</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="SubjectDistance" type="stringType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The unit is meters</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="MeteringMode" type="meteringModeType" minOccurs="0"/>' ||
'              <xsd:element name="LightSource" type="lightSourceType" minOccurs="0"/>' ||
'              <xsd:element name="Flash" type="flashType" minOccurs="0"/>' ||
'              <xsd:element name="FocalLength" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The unit is millimeters.</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="SubjectArea" type="subjectAreaType" minOccurs="0"/>' ||
'              <xsd:element name="FlashEnergy" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The unit is Beam Candle Power Seconds</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="SpatialFrequencyResponse" type="repeatedFieldType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>Not implemented</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="FocalPlaneXResolution" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The unit is pixels</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="FocalPlaneYResolution" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>The unit is pixels</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="FocalPlaneResolutionUnit" type="resolutionType" minOccurs="0"/>' ||
'              <xsd:element name="SubjectLocation" type="subjectLocationType" minOccurs="0"/>' ||
'              <xsd:element name="ExposureIndex" type="nonNegativeRealType" minOccurs="0"/>' ||
'              <xsd:element name="SensingMethod" type="sensingMethodType" minOccurs="0"/>' ||
'              <xsd:element name="FileSource" type="fileSourceType" minOccurs="0"/>' ||
'              <xsd:element name="SceneType" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="CFAPattern" type="repeatedFieldType" minOccurs="0"/>' ||
'              <xsd:element name="CustomRendered" type="customRenderedType" minOccurs="0"/>' ||
'              <xsd:element name="ExposureMode" type="exposureModeType" minOccurs="0"/>' ||
'              <xsd:element name="WhiteBalance" type="whiteBalanceType" minOccurs="0"/>' ||
'              <xsd:element name="DigitalZoomRatio" type="nonNegativeRealType" minOccurs="0"/>' ||
'              <xsd:element name="FocalLengthIn35mmFilm" type="positiveIntegerType" minOccurs="0"/>' ||
'              <xsd:element name="SceneCaptureType" type="sceneCaptureType" minOccurs="0"/>' ||
'              <xsd:element name="GainControl" type="gainControlType" minOccurs="0"/>' ||
'              <xsd:element name="Contrast" type="contrastType" minOccurs="0"/>' ||
'              <xsd:element name="Saturation" type="saturationType" minOccurs="0"/>' ||
'              <xsd:element name="Sharpness" type="sharpnessType" minOccurs="0"/>' ||
'              <xsd:element name="DeviceSettingDescription" type="repeatedFieldType" minOccurs="0"/>' ||
'              <xsd:element name="SubjectDistanceRange" type="subjectDistanceRangeType" minOccurs="0"/>' ||
'              <xsd:element name="ImageUniqueID" type="uuidType" minOccurs="0"/>' ||
'              <xsd:element name="Gamma" type="nonNegativeRealType" minOccurs="0"/>' ||
'' ||
'              <!-- Placeholder tags for future tags that may be defined -->' ||
'              <xsd:element name="ExifField1" type="singleFieldType" minOccurs="0"/>' ||
'              <xsd:element name="ExifField2" type="singleFieldType" minOccurs="0"/>' ||
'              <xsd:element name="ExifField3" type="repeatedFieldType" minOccurs="0"/>' ||
'' ||
'            </xsd:all>' ||
'            <xsd:attributeGroup ref="exifAttrs"/>' ||
'          </xsd:complexType>' ||
'        </xsd:element>' ||
'' ||
'        <xsd:element name="GpsIfd" minOccurs="0">' ||
'          <xsd:annotation>' ||
'            <xsd:documentation>Tags from the GPS IFD</xsd:documentation>' ||
'          </xsd:annotation>' ||
'          <xsd:complexType>' ||
'            <xsd:all>' ||
'              <xsd:element name="GPSVersionID" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="GPSLatitudeRef" type="gpsLatitudeRefType" minOccurs="0"/>' ||
'              <xsd:element name="GPSLatitude" type="gpsLatitudeType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>Unit is decimal degrees</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="GPSLongitudeRef" type="gpsLongitudeRefType" minOccurs="0"/>' ||
'              <xsd:element name="GPSLongitude" type="gpsLongitudeType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>Unit is decimal degrees</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="GPSAltitudeRef" type="gpsAltitudeRefType" minOccurs="0"/>' ||
'              <xsd:element name="GPSAltitude" type="nonNegativeRealType" minOccurs="0">' ||
'                <xsd:annotation>' ||
'                  <xsd:documentation>Unit is meters</xsd:documentation>' ||
'                </xsd:annotation>' ||
'              </xsd:element>' ||
'              <xsd:element name="GPSTimeStamp" type="timeType" minOccurs="0"/>' ||
'              <xsd:element name="GPSSatellites" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="GPSStatus" type="gpsStatusType" minOccurs="0"/>' ||
'              <xsd:element name="GPSMeasureMode" type="gpsMeasureModeType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDOP" type="nonNegativeRealType" minOccurs="0"/>' ||
'              <xsd:element name="GPSSpeedRef" type="gpsSpeedRefType" minOccurs="0"/>' ||
'              <xsd:element name="GPSSpeed" type="nonNegativeRealType" minOccurs="0"/>' ||
'              <xsd:element name="GPSTrackRef" type="gpsDirectionType" minOccurs="0"/>' ||
'              <xsd:element name="GPSTrack" type="gpsBearingType" minOccurs="0"/>' ||
'              <xsd:element name="GPSImgDirectionRef" type="gpsDirectionType" minOccurs="0"/>' ||
'              <xsd:element name="GPSImgDirection" type="gpsBearingType" minOccurs="0"/>' ||
'              <xsd:element name="GPSMapDatum" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDestLatitudeRef" type="gpsLatitudeRefType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDestLatitude" type="gpsLatitudeType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDestLongitudeRef" type="gpsLongitudeRefType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDestLongitude" type="gpsLongitudeType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDestBearingRef" type="gpsDirectionType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDestBearing" type="gpsBearingType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDestDistanceRef" type="gpsDistanceRefType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDestDistance" type="nonNegativeRealType" minOccurs="0"/>' ||
'              <xsd:element name="GPSProcessingMethod" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="GPSAreaInformation" type="stringType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDateStamp" type="dateType" minOccurs="0"/>' ||
'              <xsd:element name="GPSDifferential" type="gpsDifferentialType" minOccurs="0"/>' ||
'' ||
'              <!-- Placeholder tags for future tags that may be defined -->' ||
'              <xsd:element name="GPSField1" type="singleFieldType" minOccurs="0"/>' ||
'              <xsd:element name="GPSField2" type="singleFieldType" minOccurs="0"/>' ||
'              <xsd:element name="GPSField3" type="repeatedFieldType" minOccurs="0"/>' ||
'            </xsd:all>' ||
'            <xsd:attributeGroup ref="exifAttrs"/>' ||
'          </xsd:complexType>' ||
'        </xsd:element>' ||
'' ||
'        <xsd:element name="InteroperabilityIfd" minOccurs="0">' ||
'          <xsd:annotation>' ||
'            <xsd:documentation>Tags from the Interoperability IFD</xsd:documentation>' ||
'          </xsd:annotation>' ||
'          <xsd:complexType>' ||
'            <xsd:all>' ||
'              <xsd:element name="InteroperabilityIndex" type="interoperabilityType" minOccurs="0"/>' ||
'            </xsd:all>' ||
'            <xsd:attributeGroup ref="exifAttrs"/>' ||
'          </xsd:complexType>' ||
'        </xsd:element>' ||
'' ||
'      </xsd:sequence>' ||
'    </xsd:complexType>' ||
'  </xsd:element>' ||
'</xsd:schema>';
  sys.dbms_lob.writeAppend(ordClob, length(ordSchema), ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/meta/exif',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmdts.xsd with XDB under http://xmlns.oracle.com/ord/dicom/rpdatatype_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. ' ||
'' ||
'   NAME' ||
'     ordcmdts.xsd - XML schema for DICOM standard data types ' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   fechen      01/23/09 - remove the patten in the locatorpath' ||
'   dolin       10/17/08 - allow [*] for locator path' ||
'   fechen      09/23/08 - sync the schema change in ordcmmddt.xsd' ||
'   dolin       06/06/07 - doc editor comments' ||
'   myalavar    04/10/07 - doc comments' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'-->' ||
'' ||
'<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xdb="http://xmlns.oracle.com/xdb" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'    Introduction' ||
'      This schema defines the DICOM standard data types that are used ' ||
'      by all other DICOM XML schema definitions.' ||
'      ' ||
'    Naming conventions:' ||
'    All DICOM value representation (VR) types are named with a ' ||
'    2-character string, such as "AE" and "CS".' ||
'    All DICOM attribute type definitions are named as VR_ATTR_T, ' ||
'    where VR is replaced by the attribute''s 2-character VR.' ||
'    ' ||
'    Note that each item of a sequence type (SQ) is of DATASET_T type.' ||
'    The DATASET_T type can recursively contain more attributes.' ||
'    The element name of an attribute is its value representation (VR)' ||
'    name. Oracle uses value representation names defined' ||
'    by the DICOM standard part 5. The element' ||
'    name to VR mappings are:' ||
'      APPLICATION_ENTITY     ---   AE' ||
'      AGE_STRING     ---  AS' ||
'      ATTRIBUTE_TAG     ---  AT' ||
'      CODE_STRING     ---  CS' ||
'      DATE     ---  DA' ||
'      DECIMAL_STRING     ---  DS' ||
'      FLOAT_SINGLE     ---  FL' ||
'      FLOAT_DOUBLE     ---  FD' ||
'      INTEGER_STRING     ---  IS' ||
'      LONG_STRING     ---  LO' ||
'      LONG_TEXT     ---  LT' ||
'      OTHER_BYTE     ---  OB' ||
'      OTHER_FLOAT     ---  OF' ||
'      OTHER_WORD     ---  OW' ||
'      OTHER_WORD     ---  OWB' ||
'      PERSON_NAME     ---  PN' ||
'      SHORT_STRING     ---  SH' ||
'      SIGNED_LONG     ---  SL' ||
'      SEQUENCE     ---  SQ' ||
'      SIGNED_SHORT     ---  SS' ||
'      SHORT_TEXT     ---  ST' ||
'      TIME     ---  TM' ||
'      UNIQUE_ID     ---  UI' ||
'      UNSIGNED_LONG     ---  UL' ||
'      UNKNOWN     ---  UN' ||
'      UNSIGNED_SHORT     ---  US' ||
'      SIGNED_SHORT       ---  USS' ||
'      UNLIMITED_TEXT     ---  UT' ||
'      EXTENDED_TYPE     ---  EXT' ||
'      EXCEPTION_TYPE     ---  EXP' ||
'      The VR types "OWB'', "EXT", "EXP" and "USS" are ' ||
'      Oracle-defined extensions.' ||
'      Please refer to the individual data type documentation for ' ||
'      more explanation.' ||
'    </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:simpleType name="AE">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Value representation Application Entity</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="16"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="AS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Value representation Age String. ' ||
'        The age string can be expressed either in DICOM string ' ||
'        format, or in number of days. When metadata is extracted ' ||
'        from a DICOM object, both elements will be populated.' ||
'        XML documents can represent age by either format.  ' ||
'        Age in number of days is converted into an age string when ' ||
'        XML metadata is encoded into a DICOM object.' ||
'        To convert from age string into the number of days:  ' ||
'          365 * number_of_year or 31 * number_of_month.  ' ||
'        Because AGE_STRING is mandatory, it is not necessary to ' ||
'        convert from the number of days into an age string. ' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="VALUE" nillable="true">' ||
'        <xs:simpleType>' ||
'          <xs:restriction base="xs:token">' ||
'            <xs:pattern value="[0-9]{3}(D|W|M|Y)"/>' ||
'          </xs:restriction>' ||
'        </xs:simpleType>' ||
'      </xs:element>' ||
'      <xs:element name="AGE_IN_DAYS" type="xs:unsignedInt" minOccurs="0"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="AT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type Attribute Tag. An attribute tag is expressed as two ' ||
'        big-endian 2-byte hexadecimal number (group number followed by ' ||
'        element number with no separator).' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:hexBinary">' ||
'      <xs:minLength value="4"/>' ||
'      <xs:maxLength value="4"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="CS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Code String</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="16"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="DA">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type DAte</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:date"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="DS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Decimal String</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:float"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="DT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Data Time</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:dateTime"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="FL">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type FLoating-point single</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:float"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="FD">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Floating-point Double</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:double"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="IS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Integer String</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:integer"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="LO">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type LOng string</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="64"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="LT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Long Text</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="10240"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="OB">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Other Byte</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:base64Binary"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="OF">' ||
'    <xs:annotation>' ||
'      <xs:documentation> VR type Other Float </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:float"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="OW">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type Other Word in base64binary encoding.' ||
'        The mandatory attribute endian specifies the byte ' ||
'        order of the binary value.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="xs:base64Binary">' ||
'        <xs:attribute name="endian" use="required">' ||
'          <xs:simpleType>' ||
'            <xs:restriction base="xs:token">' ||
'              <xs:enumeration value="big"/>' ||
'              <xs:enumeration value="little"/>' ||
'            </xs:restriction>' ||
'          </xs:simpleType>' ||
'        </xs:attribute>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="PN">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type Person Name. Person Name can be' ||
'        expressed either in component format or as a single ' ||
'        concatentated string. When metadata is extracted from a ' ||
'        DICOM object, the person name type is encoded with' ||
'        both formats. Users can index and search DICOM ' ||
'        metadata with either the component format or the ' ||
'        concatenated string format.' ||
'        In component format, a name has an optional "type" attribute that' ||
'        indicates its encoding type. The value of the "type" attribute ' ||
'        can be "unibyte", "ideographic" or "phonetic". A name may ' ||
'        have up to five components: "FAMILY", "GIVEN", "MIDDLE",' ||
'        "PREFIX", and "SUFFIX".' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="NAME" minOccurs="0" maxOccurs="3" nillable="true">' ||
'        <xs:complexType>' ||
'          <xs:sequence>' ||
'            <xs:element name="FAMILY" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="GIVEN" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="MIDDLE" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="PREFIX" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="SUFFIX" type="xs:string" minOccurs="0" nillable="true"/>' ||
'          </xs:sequence>' ||
'          <xs:attribute name="type" default="unibyte">' ||
'            <xs:simpleType>' ||
'              <xs:restriction base="xs:token">' ||
'                <xs:enumeration value="unibyte"/>' ||
'                <xs:enumeration value="ideographic"/>' ||
'                <xs:enumeration value="phonetic"/>' ||
'              </xs:restriction>' ||
'            </xs:simpleType>' ||
'          </xs:attribute>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'      <xs:element name="VALUE" minOccurs="0" nillable="true">' ||
'        <xs:simpleType>' ||
'          <xs:restriction base="xs:token">' ||
'            <xs:maxLength value="64"/>' ||
'          </xs:restriction>' ||
'        </xs:simpleType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="SH">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type SHort string</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="16"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="SL">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Signed Long</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:integer"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="SQ">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type SeQuence. ' ||
'        Note that item number can be explicitly encoded in XML. ' ||
'        Number counts from 1 up.' ||
'        Each item is a DATASET_T type, which may contain ' ||
'        any combination of DICOM attributes.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence maxOccurs="unbounded">' ||
'      <xs:element name="ITEM" type="DATASET_T" minOccurs="0" nillable="true"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="SS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Signed Short</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:integer"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="ST">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Short Text</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="1024"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="TM">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type TiMe</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:time"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="UI">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unique Identifier</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="128"/>' ||
'      <xs:pattern value="[0-9\.]+"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="UL">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unsigned Long</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:unsignedInt"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="UN">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type UNknown.' ||
'        This type contains a base64 dump of its binary content. The mandatory' ||
'        attribute "endian" specifies the byte order of this encoding.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="xs:base64Binary">' ||
'        <xs:attribute name="endian" use="required">' ||
'          <xs:simpleType>' ||
'            <xs:restriction base="xs:token">' ||
'              <xs:enumeration value="big"/>' ||
'              <xs:enumeration value="little"/>' ||
'            </xs:restriction>' ||
'          </xs:simpleType>' ||
'        </xs:attribute>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="US">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unsigned Short</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:unsignedShort"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="UT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unlimited Text</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="EXT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Extension type ' ||
'        This type does not have direct mapping to any value ' ||
'        representation (VR) types defined in Part 5 of the ' ||
'        DICOM standard.   ' ||
'        It can accommodate future extensions to DICOM VR' ||
'        types without modification to the XML schema definitions.' ||
'        The VR element specifies the value representation.' ||
'        The VALUE element specifies the XML value for the' ||
'        corresponding data element. The exact XML schema ' ||
'        definition can be introduced in the future.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="VR" type="xs:token"/>' ||
'      <xs:element name="VALUE" type="xs:anyType" nillable="true"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="EXP">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Exception type.' ||
'        This type does not have direct mapping to any value ' ||
'        representation (VR) types defined in Part 5 of the ' ||
'        DICOM standard.   ' ||
'        It indicates an error situation. It is equivalent to ' ||
'        an exception in the Java language.' ||
'        The value of this data type is the original byte ' ||
'        array of the data type in the DICOM object.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:base64Binary"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="DATASET_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        The dataset type maps the DICOM concept dataset ' ||
'        into an XML schema type(See the DICOM standard P3-5) .' ||
'        A dataset may contain any number of DICOM attributes.' ||
'        Each type of attribute has a name that reflects' ||
'        the DICOM value representation of the attribute.' ||
'        Each attribute is strongly typed, and its type matches its DICOM' ||
'        VR. Note that DICOM attribute type SQ (sequence) may ' ||
'        recursively contain items that are also of the dataset type.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:choice maxOccurs="unbounded" minOccurs="0">' ||
'      <xs:element name="APPLICATION_ENTITY" type="AE_ATTR_T" nillable="true"/>' ||
'      <xs:element name="AGE_STRING" type="AS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="ATTRIBUTE_TAG" type="AT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="CODE_STRING" type="CS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="DATE" type="DA_ATTR_T" nillable="true"/>' ||
'      <xs:element name="DATE_TIME" type="DT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="DECIMAL_STRING" type="DS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="FLOAT_SINGLE" type="FL_ATTR_T" nillable="true"/>' ||
'      <xs:element name="FLOAT_DOUBLE" type="FD_ATTR_T" nillable="true"/>' ||
'      <xs:element name="INTEGER_STRING" type="IS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="LONG_STRING" type="LO_ATTR_T" nillable="true"/>' ||
'      <xs:element name="LONG_TEXT" type="LT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="OTHER_BYTE" type="OB_ATTR_T" nillable="true"/>' ||
'      <xs:element name="OTHER_FLOAT" type="OF_ATTR_T" nillable="true"/>' ||
'      <xs:element name="OTHER_WORD" type="OW_ATTR_T" nillable="true"/>' ||
'      <xs:element name="PERSON_NAME" type="PN_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SHORT_STRING" type="SH_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SIGNED_LONG" type="SL_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SEQUENCE" type="SQ_ATTR_T" nillable="true" xdb:SQLType="CLOB" xdb:SQLName="SEQUENCE"/>' ||
'      <xs:element name="SIGNED_SHORT" type="SS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SHORT_TEXT" type="ST_ATTR_T" nillable="true"/>' ||
'      <xs:element name="TIME" type="TM_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNIQUE_ID" type="UI_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNSIGNED_LONG" type="UL_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNKNOWN" type="UN_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNSIGNED_SHORT" type="US_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNLIMITED_TEXT" type="UT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="EXTENDED_TYPE" type="EXT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="EXCEPTION_TYPE" type="EXP_ATTR_T" nillable="true"/>' ||
'    </xs:choice>' ||
'    <xs:attribute name="number" type="xs:long" use="optional" default="1"/>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ATTR_VALUE_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Attribute value type (ATTR_VALUE_T) maps to a single DICOM' ||
'        attribute value. Each type of attribute has a name that reflects' ||
'        the DICOM value representation of the attribute.' ||
'        Each attribute is strongly typed, and its type matches its DICOM' ||
'        VR. Certain DICOM configuration files, such as constraint ' ||
'        documents, use ATTR_VALUE_T.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:choice>' ||
'      <xs:element name="APPLICATION_ENTITY" type="AE"/>' ||
'      <xs:element name="AGE_STRING" type="AS"/>' ||
'      <xs:element name="ATTRIBUTE_TAG" type="AT"/>' ||
'      <xs:element name="CODE_STRING" type="CS"/>' ||
'      <xs:element name="DATE" type="DA"/>' ||
'      <xs:element name="DATE_TIME" type="DT"/>' ||
'      <xs:element name="DECIMAL_STRING" type="DS"/>' ||
'      <xs:element name="FLOAT_SINGLE" type="FL"/>' ||
'      <xs:element name="FLOAT_DOUBLE" type="FD"/>' ||
'      <xs:element name="INTEGER_STRING" type="IS"/>' ||
'      <xs:element name="LONG_STRING" type="LO"/>' ||
'      <xs:element name="LONG_TEXT" type="LT"/>' ||
'      <xs:element name="OTHER_BYTE" type="OB"/>' ||
'      <xs:element name="OTHER_FLOAT" type="OF"/>' ||
'      <xs:element name="OTHER_WORD" type="OW"/>' ||
'      <xs:element name="PERSON_NAME" type="PN"/>' ||
'      <xs:element name="SHORT_STRING" type="SH"/>' ||
'      <xs:element name="SIGNED_LONG" type="SL"/>' ||
'      <xs:element name="SEQUENCE" type="SQ"/>' ||
'      <xs:element name="SIGNED_SHORT" type="SS"/>' ||
'      <xs:element name="SHORT_TEXT" type="ST"/>' ||
'      <xs:element name="TIME" type="TM"/>' ||
'      <xs:element name="UNIQUE_ID" type="UI"/>' ||
'      <xs:element name="UNSIGNED_LONG" type="UL"/>' ||
'      <xs:element name="UNKNOWN" type="UN"/>' ||
'      <xs:element name="UNSIGNED_SHORT" type="US"/>' ||
'      <xs:element name="UNLIMITED_TEXT" type="UT"/>' ||
'      <xs:element name="EXTENDED_TYPE" type="EXT"/>' ||
'      <xs:element name="EXCEPTION_TYPE" type="EXP"/>' ||
'    </xs:choice>' ||
'  </xs:complexType>' ||
'  <xs:attributeGroup name="ATTR_GRP_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Attribute group type (ATTR_GRP_T) is used by all DICOM attribute ' ||
'        definitions. It defines XML attributes that are used by all DICOM' ||
'        attribute types.' ||
'        The "tag" attribute defines DICOM attributes in little-endian encoding.' ||
'        The "definer" attribute specifies the organization that has' ||
'        created the attribute. By default, all DICOM standard ' ||
'        attributes have the definer name "DICOM".' ||
'        The "name" attribute specifies the canonical attribute name' ||
'        as defined by the data dictionary. For example, in ' ||
'        an XML metadata schema definition, you can choose a tag' ||
'        PATIENT_DATE_OF_BIRTH or "DOB" for DICOM attribute ' ||
'        (0010,0030), but its name attribute should match that of the' ||
'        DICOM standard: "Patient''s Birth Date".' ||
'        The "number" attribute is an optional attribute to indicate the' ||
'        ordering of a multivalued attributes.  Number counts from 1 up.' ||
'        The "truncated" attribute takes a Boolean value. If it is true,' ||
'        it indicates that the original length of the DICOM attribute' ||
'        exceeds the maximum length allowed for this XML value;therefore,' ||
'        it is truncated in XML. When this attribute is true, ' ||
'        xsi:nill="true" for this attribute.' ||
'        Optionally, the "rawValue" attribute can be used to store ' ||
'        values that do not conform to the DICOM standard.   The ' ||
'        associated attribute "byteOrderLE" specifies the byte order' ||
'        of the byte stream for the "rawValue" attribute.' ||
'        "offset" and "length" are Oracle-reserved attributes.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:attribute name="tag" type="AT" use="required"/>' ||
'    <xs:attribute name="definer" type="LO" default="DICOM"/>' ||
'    <xs:attribute name="name" type="SHORT_STRING_T"/>' ||
'    <xs:attribute name="number" type="xs:long" use="optional" default="1"/>' ||
'    <xs:attribute name="offset" type="xs:long"/>' ||
'    <xs:attribute name="length" type="xs:long"/>' ||
'    <xs:attribute name="truncated" type="xs:boolean" default="false"/>' ||
'    <xs:attribute name="rawValue" type="xs:base64Binary"/>' ||
'    <xs:attribute name="byteOrderLE" type="xs:boolean" default="true"/>' ||
'  </xs:attributeGroup>' ||
'  <xs:complexType name="AE_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="AE">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="AS_ATTR_T">' ||
'    <xs:complexContent>' ||
'      <xs:extension base="AS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="AT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="AT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="CS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="CS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DA_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="DA">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="DS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="DT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="FD_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="FD">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="FL_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="FL">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="IS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="IS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="LO_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="LO">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="LT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="LT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="OB_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="OB">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="OF_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="OF">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="OW_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="OW">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="PN_ATTR_T">' ||
'    <xs:complexContent>' ||
'      <xs:extension base="PN">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SH_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="SH">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SL_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="SL">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SQ_ATTR_T">' ||
'    <xs:complexContent>' ||
'      <xs:extension base="SQ">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="SS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ST_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="ST">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="TM_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="TM">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UI_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UI">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UL_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UL">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UN_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UN">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ;

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

  ordSchema := 
'  </xs:complexType>' ||
'  <xs:complexType name="US_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="US">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="EXT_ATTR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        This attribute is useful for representing attributes whose' ||
'        VR types are not supported natively by Oracle.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:complexContent>' ||
'      <xs:extension base="EXT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="EXP_ATTR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        This attribute type is useful for representing attributes that' ||
'        are present in a DICOM object, but whose definition cannot' ||
'        be found in the data dictionary. Such' ||
'        attributes cannot be parsed or interpreted.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="EXP">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DOCUMENT_HEADER_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'         Each time the XML configuration document is modified, ' ||
'         a new element, DOCUMENT_CHANGE_LOG, is ' ||
'         added to the DOCUMENT_HEADER.' ||
'         The change log describes who made what type of change to the ' ||
'         XML document on which date. It also describes what DICOM' ||
'         standard document the modification is based upon, either' ||
'         a DICOM change proposal (CP) or a DICOM supplement. ' ||
'         ' ||
'         DOCUMENT_MODIFIER identifies the modifier of the present ' ||
'         XML document. If it is generated by software, specify the name ' ||
'         and version of the software.' ||
'         DOCUMENT_MODIFICATION_DATE specifies the date when' ||
'         this XML document is modified.' ||
'         DOCUMENT_VERSION specifies the version of the document after ' ||
'         the modification.' ||
'         MODIFICATION_COMMENT briefly describes the modification.' ||
'         BASE_DOCUMENT describes the document or DICOM standard' ||
'         that the modification is based upon.' ||
'         BASE_DOCUMENT_RELEASE_DATE specifies the release date of ' ||
'         the base document.' ||
'         BASE_DOCUMENT_DESCRIPTION briefly describes the base' ||
'         document.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="DOCUMENT_CHANGE_LOG" maxOccurs="unbounded">' ||
'        <xs:complexType>' ||
'          <xs:sequence>' ||
'            <xs:element name="DOCUMENT_MODIFIER" type="SHORT_STRING_T"/>' ||
'            <xs:element name="DOCUMENT_MODIFICATION_DATE" type="SHORT_STRING_T"/>' ||
'            <xs:element name="DOCUMENT_VERSION" type="SHORT_STRING_T" minOccurs="0"/>' ||
'            <xs:element name="MODIFICATION_COMMENT" type="SHORT_TEXT_T" minOccurs="0"/>' ||
'            <xs:element name="BASE_DOCUMENT" type="SHORT_STRING_T" minOccurs="0"/>' ||
'            <xs:element name="BASE_DOCUMENT_RELEASE_DATE" type="xs:date" minOccurs="0"/>' ||
'            <xs:element name="BASE_DOCUMENT_DESCRIPTION" type="SHORT_TEXT_T" minOccurs="0"/>' ||
'          </xs:sequence>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ATTR_DEFINERS_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Attribute definer is identified by its name and UID.  ' ||
'        In Oracle''s implementation, the DICOM standard is given the' ||
'        definer name "DICOM" and the UID "1.2.840.10008.1".  ' ||
'        All DICOM standard attributes are given the definer name "DICOM".' ||
'        Users can introduce private attributes of their own and encode them' ||
'        in an XML document. These private attributes are identified' ||
'        with the definer''s name and UID. Oracle recommends that all DICOM ' ||
'        private attributes be associated with a UID-qualified name.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence maxOccurs="unbounded">' ||
'      <xs:element name="ATTR_DEFINER">' ||
'        <xs:complexType>' ||
'          <xs:sequence>' ||
'            <xs:element name="NAME" type="LO" maxOccurs="unbounded"/>' ||
'            <xs:element name="UID" type="UI" minOccurs="0"/>' ||
'          </xs:sequence>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <!-- Attribute Tag (allowing x wildcard)-->' ||
'  <xs:simpleType name="ATTR_TAG_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation> ' ||
'        The attribute tag type differs from DICOM VR ' ||
'        type AT in that it allows the wildcard character ''x''.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:pattern value="([0-9a-fA-FxX]{8})"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="ATTR_RANGE_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        The attribute range type defines a range of DICOM attributes. ' ||
'        This data type is used in private attribute definitions.' ||
'        Certain private attributes accept a range of attribute tags.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="STARTING_TAG" type="ATTR_TAG_T"/>' ||
'      <xs:element name="ENDING_TAG" type="ATTR_TAG_T"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="VALUE_LOCATOR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        The DICOM value locator type identifies a particular' ||
'        DICOM attribute by "xxxxxxxx(definer)", where ' ||
'        "xxxxxxxx" is the attribute tag and "definer" is the' ||
'        attribute definer, which can be the DICOM standard' ||
'        (DICOM) or other private sources. ' ||
'        A locator path can also identify a particular ' ||
'        descendent of a container type attribute (SQ).' ||
'        The n-th item of a sequence attribute is denoted by' ||
'        "xxxxxxxxx(definer)[n]".    ' ||
'        By default, the definer suffix "(definer)" can be ' ||
'        omitted if the attribute is a DICOM standard tag.  ' ||
'        The index "n" of an item address "[n]" must be a ' ||
'        positive integer. The item address suffix can be ' ||
'        omitted if the item it pointed to is the first item ' ||
'        of a sequence. ' ||
'        For example, 00080096.00401101.00080100 is the code ' ||
'        that identifies the first referring physician. The ' ||
'        above value locator is equivalent to:' ||
'          00080096(DICOM)[1].00401101(DICOM)[1].00080100(DICOM)' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="VALUE_LOCATOR_MACRO_T"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="VALUE_LOCATOR_MACRO_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        VALUE_LOCATOR_MACRO_T is similar to the value locator' ||
'        type, except that it permits the use of a macro within' ||
'        the locator string.' ||
'        So, the macro locator string can be:' ||
'          ${TAG}(DICOM)[2].00080100' ||
'        This string indicates the code value (0008,0100) of the second ' ||
'        item of a sequence attribute identified by ${TAG}.' ||
'        The macro parameter TAG can be replaced by a ' ||
'        compatible attribute tag (code sequence attribute)' ||
'        later.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="SHORT_TEXT_T"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="VM_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM value multiplicity (VM) specification. ' ||
'        This type is used in DICOM dictionary documents. ' ||
'        Patterns of valid specifications are:' ||
'        "k", "k-j", "k-n", "n", "k-kn".' ||
'        In these patterns, k and j are integers, k is less ' ||
'        than j, and n is the letter n.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="SHORT_STRING_T">' ||
'      <xs:pattern value="(([0-9]+)-)?(([0-9]*n|([0-9]+)))"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="VR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM value representation types.' ||
'        In the DICOM standard, VR for certain attributes ' ||
'        is defined as "other word or byte", "US or SS", or' ||
'        "See Note". Oracle has extended the list of VR types and ' ||
'        introduced OWB (for "other word or byte"), ' ||
'        USS (for "US or SS"), and ' ||
'        EXP (where VR definition does not apply).' ||
'        When an attribute of USS type is encoded into XML, it is' ||
'        automatically encoded as a signed short type.' ||
'        When an attribute of OWB type is encoded into XML, it is' ||
'        automatically encoded into other word type.' ||
'        An example of an attribute with VR type of EXP is' ||
'        the sequence item (FFFE, E000).' ||
'        For compatibility with future DICOM releases, if a new ' ||
'        DICOM VR is introduced by the DICOM standard, ' ||
'        users can mark such attributes as type "EXT??", ' ||
'        where "??" should be replaced by the new VR name.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:pattern value="AE"/>' ||
'      <xs:pattern value="AS"/>' ||
'      <xs:pattern value="AT"/>' ||
'      <xs:pattern value="CS"/>' ||
'      <xs:pattern value="DA"/>' ||
'      <xs:pattern value="DS"/>' ||
'      <xs:pattern value="DT"/>' ||
'      <xs:pattern value="FL"/>' ||
'      <xs:pattern value="FD"/>' ||
'      <xs:pattern value="IS"/>' ||
'      <xs:pattern value="LO"/>' ||
'      <xs:pattern value="LT"/>' ||
'      <xs:pattern value="OB"/>' ||
'      <xs:pattern value="OF"/>' ||
'      <xs:pattern value="OW"/>' ||
'      <xs:pattern value="PN"/>' ||
'      <xs:pattern value="SH"/>' ||
'      <xs:pattern value="SL"/>' ||
'      <xs:pattern value="SQ"/>' ||
'      <xs:pattern value="SS"/>' ||
'      <xs:pattern value="ST"/>' ||
'      <xs:pattern value="TM"/>' ||
'      <xs:pattern value="UI"/>' ||
'      <xs:pattern value="UL"/>' ||
'      <xs:pattern value="UN"/>' ||
'      <xs:pattern value="US"/>' ||
'      <xs:pattern value="UT"/>' ||
'      <xs:pattern value="USS"/>' ||
'      <xs:pattern value="OWB"/>' ||
'      <xs:pattern value="EXP"/>' ||
'      <xs:pattern value="EXT[A-Z]{2}"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="SHORT_TEXT_T">' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="1999"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="MIXED_TEXT_T" mixed="true">' ||
'   <xs:complexContent mixed="true">' ||
'      <xs:extension base="xs:anyType">' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="SHORT_STRING_T">' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="128"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="SHORT_NAME_T">' ||
'      <xs:restriction base="xs:NCName">' ||
'         <xs:maxLength value="128"/>' ||
'      </xs:restriction>' ||
'   </xs:simpleType>' ||
'  <xs:simpleType name="SHORT_ID_T">' ||
'    <xs:restriction base="xs:ID">' ||
'      <xs:maxLength value="64"/>' ||
'      <xs:pattern value="[^\.]+"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'</xs:schema>';
  sys.dbms_lob.writeAppend(ordClob, length(ordSchema), ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/rpdatatype_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmrdt.xsd with XDB under http://xmlns.oracle.com/ord/dicom/datatype_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. ' ||
'' ||
'   NAME' ||
'     ordcmrdt.xsd - XML schema for DICOM standard data types. ' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   fechen      01/23/09 - remove the patten in the locatorpath' ||
'   fechen      09/23/08 - sync the schema change in ordcmmddt.xsd' ||
'   dolin       06/20/07 - doc comments' ||
'   myalavar    04/10/07 - copyright' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        04/03/05 - Created' ||
'' ||
'-->' ||
'' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xdb="http://xmlns.oracle.com/xdb" targetNamespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'    Introduction' ||
'      This schema defines the DICOM standard data types that are used ' ||
'      by all other DICOM XML schema definitions.' ||
'      ' ||
'    Naming conventions:' ||
'    All DICOM value representation (VR) types are named with a ' ||
'    2-character string, such as "AE" and "CS".' ||
'    All DICOM attribute type definitions are named as VR_ATTR_T, ' ||
'    where VR is replaced by the attribute''s 2-character VR.' ||
'    ' ||
'    Note that each item of a sequence type (SQ) is of DATASET_T type.' ||
'    The DATASET_T type can recursively contain more attributes.' ||
'    The element name of an attribute is its value representation (VR)' ||
'    name. Oracle uses value representation names defined' ||
'    by the DICOM standard part 5. The element' ||
'    name to VR mappings are:' ||
'      APPLICATION_ENTITY     ---   AE' ||
'      AGE_STRING     ---  AS' ||
'      ATTRIBUTE_TAG     ---  AT' ||
'      CODE_STRING     ---  CS' ||
'      DATE     ---  DA' ||
'      DECIMAL_STRING     ---  DS' ||
'      FLOAT_SINGLE     ---  FL' ||
'      FLOAT_DOUBLE     ---  FD' ||
'      INTEGER_STRING     ---  IS' ||
'      LONG_STRING     ---  LO' ||
'      LONG_TEXT     ---  LT' ||
'      OTHER_BYTE     ---  OB' ||
'      OTHER_FLOAT     ---  OF' ||
'      OTHER_WORD     ---  OW' ||
'      OTHER_WORD     ---  OWB' ||
'      PERSON_NAME     ---  PN' ||
'      SHORT_STRING     ---  SH' ||
'      SIGNED_LONG     ---  SL' ||
'      SEQUENCE     ---  SQ' ||
'      SIGNED_SHORT     ---  SS' ||
'      SHORT_TEXT     ---  ST' ||
'      TIME     ---  TM' ||
'      UNIQUE_ID     ---  UI' ||
'      UNSIGNED_LONG     ---  UL' ||
'      UNKNOWN     ---  UN' ||
'      UNSIGNED_SHORT     ---  US' ||
'      SIGNED_SHORT       ---  USS' ||
'      UNLIMITED_TEXT     ---  UT' ||
'      EXTENDED_TYPE     ---  EXT' ||
'      EXCEPTION_TYPE     ---  EXP' ||
'      The VR types "OWB'', "EXT", "EXP" and "USS" are ' ||
'      Oracle-defined extensions.' ||
'      Please refer to the individual data type documentation for ' ||
'      more explanation.' ||
'    </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:simpleType name="AE">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Value representation Application Entity</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="16"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="AS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Value representation Age String. ' ||
'        The age string can be expressed either in DICOM string ' ||
'        format, or in number of days. When metadata is extracted ' ||
'        from a DICOM object, both elements will be populated.' ||
'        XML documents can represent age by either format.  ' ||
'        Age in number of days is converted into an age string when ' ||
'        XML metadata is encoded into a DICOM object.' ||
'        To convert from age string into the number of days:  ' ||
'          365 * number_of_year or 31 * number_of_month.  ' ||
'        Because AGE_STRING is mandatory, it is not necessary to ' ||
'        convert from the number of days into an age string. ' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="VALUE" nillable="true">' ||
'        <xs:simpleType>' ||
'          <xs:restriction base="xs:token">' ||
'            <xs:pattern value="[0-9]{3}(D|W|M|Y)"/>' ||
'          </xs:restriction>' ||
'        </xs:simpleType>' ||
'      </xs:element>' ||
'      <xs:element name="AGE_IN_DAYS" type="xs:unsignedInt" minOccurs="0"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="AT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type Attribute Tag. An attribute tag is expressed as two ' ||
'        big-endian 2-byte hexadecimal number (group number followed by ' ||
'        element number with no separator).' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:hexBinary">' ||
'      <xs:minLength value="4"/>' ||
'      <xs:maxLength value="4"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="CS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Code String</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="16"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="DA">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type DAte</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:date"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="DS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Decimal String</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:float"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="DT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Data Time</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:dateTime"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="FL">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type FLoating-point single</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:float"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="FD">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Floating-point Double</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:double"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="IS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Integer String</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:integer"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="LO">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type LOng string</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="64"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="LT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Long Text</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="10240"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="OB">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Other Byte</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:base64Binary"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="OF">' ||
'    <xs:annotation>' ||
'      <xs:documentation> VR type Other Float </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:float"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="OW">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type Other Word in base64binary encoding.' ||
'        The mandatory attribute endian specifies the byte ' ||
'        order of the binary value.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="xs:base64Binary">' ||
'        <xs:attribute name="endian" use="required">' ||
'          <xs:simpleType>' ||
'            <xs:restriction base="xs:token">' ||
'              <xs:enumeration value="big"/>' ||
'              <xs:enumeration value="little"/>' ||
'            </xs:restriction>' ||
'          </xs:simpleType>' ||
'        </xs:attribute>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="PN">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type Person Name. Person Name can be' ||
'        expressed either in component format or as a single ' ||
'        concatentated string. When metadata is extracted from a ' ||
'        DICOM object, the person name type is encoded with' ||
'        both formats. Users can index and search DICOM ' ||
'        metadata with either the component format or the ' ||
'        concatenated string format.' ||
'        In component format, a name has an optional "type" attribute that' ||
'        indicates its encoding type. The value of the "type" attribute ' ||
'        can be "unibyte", "ideographic" or "phonetic". A name may ' ||
'        have up to five components: "FAMILY", "GIVEN", "MIDDLE",' ||
'        "PREFIX", and "SUFFIX".' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="NAME" minOccurs="0" maxOccurs="3" nillable="true">' ||
'        <xs:complexType>' ||
'          <xs:sequence>' ||
'            <xs:element name="FAMILY" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="GIVEN" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="MIDDLE" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="PREFIX" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="SUFFIX" type="xs:string" minOccurs="0" nillable="true"/>' ||
'          </xs:sequence>' ||
'          <xs:attribute name="type" default="unibyte">' ||
'            <xs:simpleType>' ||
'              <xs:restriction base="xs:token">' ||
'                <xs:enumeration value="unibyte"/>' ||
'                <xs:enumeration value="ideographic"/>' ||
'                <xs:enumeration value="phonetic"/>' ||
'              </xs:restriction>' ||
'            </xs:simpleType>' ||
'          </xs:attribute>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'      <xs:element name="VALUE" minOccurs="0" nillable="true">' ||
'        <xs:simpleType>' ||
'          <xs:restriction base="xs:token">' ||
'            <xs:maxLength value="64"/>' ||
'          </xs:restriction>' ||
'        </xs:simpleType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="SH">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type SHort string</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="16"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="SL">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Signed Long</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:integer"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="SQ">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type SeQuence. ' ||
'        Note that item number can be explicitly encoded in XML. ' ||
'        Number counts from 1 up.' ||
'        Each item is a DATASET_T type, which may contain ' ||
'        any combination of DICOM attributes.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence maxOccurs="unbounded">' ||
'      <xs:element name="ITEM" type="DATASET_T" minOccurs="0" nillable="true"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="SS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Signed Short</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:integer"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="ST">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Short Text</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="1024"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="TM">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type TiMe</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:time"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="UI">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unique Identifier</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="128"/>' ||
'      <xs:pattern value="[0-9\.]+"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="UL">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unsigned Long</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:unsignedInt"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="UN">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type UNknown.' ||
'        This type contains a base64 dump of its binary content. The mandatory' ||
'        attribute "endian" specifies the byte order of this encoding.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="xs:base64Binary">' ||
'        <xs:attribute name="endian" use="required">' ||
'          <xs:simpleType>' ||
'            <xs:restriction base="xs:token">' ||
'              <xs:enumeration value="big"/>' ||
'              <xs:enumeration value="little"/>' ||
'            </xs:restriction>' ||
'          </xs:simpleType>' ||
'        </xs:attribute>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="US">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unsigned Short</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:unsignedShort"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="UT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unlimited Text</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="EXT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Extension type ' ||
'        This type does not have direct mapping to any value ' ||
'        representation (VR) types defined in Part 5 of the ' ||
'        DICOM standard.   ' ||
'        It can accommodate future extensions to DICOM VR' ||
'        types without modification to the XML schema definitions.' ||
'        The VR element specifies the value representation.' ||
'        The VALUE element specifies the XML value for the' ||
'        corresponding data element. The exact XML schema ' ||
'        definition can be introduced in the future.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="VR" type="xs:token"/>' ||
'      <xs:element name="VALUE" type="xs:anyType" nillable="true"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="EXP">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Exception type.' ||
'        This type does not have direct mapping to any value ' ||
'        representation (VR) types defined in Part 5 of the ' ||
'        DICOM standard.   ' ||
'        It indicates an error situation. It is equivalent to ' ||
'        an exception in the Java language.' ||
'        The value of this data type is the original byte ' ||
'        array of the data type in the DICOM object.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:base64Binary"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="DATASET_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        The dataset type maps the DICOM concept dataset ' ||
'        into an XML schema type(See the DICOM standard P3-5) .' ||
'        A dataset may contain any number of DICOM attributes.' ||
'        Each type of attribute has a name that reflects' ||
'        the DICOM value representation of the attribute.' ||
'        Each attribute is strongly typed, and its type matches its DICOM' ||
'        VR. Note that DICOM attribute type SQ (sequence) may ' ||
'        recursively contain items that are also of the dataset type.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:choice maxOccurs="unbounded" minOccurs="0">' ||
'      <xs:element name="APPLICATION_ENTITY" type="AE_ATTR_T" nillable="true"/>' ||
'      <xs:element name="AGE_STRING" type="AS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="ATTRIBUTE_TAG" type="AT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="CODE_STRING" type="CS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="DATE" type="DA_ATTR_T" nillable="true"/>' ||
'      <xs:element name="DATE_TIME" type="DT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="DECIMAL_STRING" type="DS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="FLOAT_SINGLE" type="FL_ATTR_T" nillable="true"/>' ||
'      <xs:element name="FLOAT_DOUBLE" type="FD_ATTR_T" nillable="true"/>' ||
'      <xs:element name="INTEGER_STRING" type="IS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="LONG_STRING" type="LO_ATTR_T" nillable="true"/>' ||
'      <xs:element name="LONG_TEXT" type="LT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="OTHER_BYTE" type="OB_ATTR_T" nillable="true"/>' ||
'      <xs:element name="OTHER_FLOAT" type="OF_ATTR_T" nillable="true"/>' ||
'      <xs:element name="OTHER_WORD" type="OW_ATTR_T" nillable="true"/>' ||
'      <xs:element name="PERSON_NAME" type="PN_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SHORT_STRING" type="SH_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SIGNED_LONG" type="SL_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SEQUENCE" type="SQ_ATTR_T" nillable="true" xdb:SQLType="CLOB"/>' ||
'      <xs:element name="SIGNED_SHORT" type="SS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SHORT_TEXT" type="ST_ATTR_T" nillable="true"/>' ||
'      <xs:element name="TIME" type="TM_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNIQUE_ID" type="UI_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNSIGNED_LONG" type="UL_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNKNOWN" type="UN_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNSIGNED_SHORT" type="US_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNLIMITED_TEXT" type="UT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="EXTENDED_TYPE" type="EXT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="EXCEPTION_TYPE" type="EXP_ATTR_T" nillable="true"/>' ||
'    </xs:choice>' ||
'    <xs:attribute name="number" type="xs:long" use="optional" default="1"/>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ATTR_VALUE_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Attribute value type (ATTR_VALUE_T) maps to a single DICOM' ||
'        attribute value. Each type of attribute has a name that reflects' ||
'        the DICOM value representation of the attribute.' ||
'        Each attribute is strongly typed, and its type matches its DICOM' ||
'        VR. Certain DICOM configuration files, such as constraint ' ||
'        documents, use ATTR_VALUE_T.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:choice>' ||
'      <xs:element name="APPLICATION_ENTITY" type="AE"/>' ||
'      <xs:element name="AGE_STRING" type="AS"/>' ||
'      <xs:element name="ATTRIBUTE_TAG" type="AT"/>' ||
'      <xs:element name="CODE_STRING" type="CS"/>' ||
'      <xs:element name="DATE" type="DA"/>' ||
'      <xs:element name="DATE_TIME" type="DT"/>' ||
'      <xs:element name="DECIMAL_STRING" type="DS"/>' ||
'      <xs:element name="FLOAT_SINGLE" type="FL"/>' ||
'      <xs:element name="FLOAT_DOUBLE" type="FD"/>' ||
'      <xs:element name="INTEGER_STRING" type="IS"/>' ||
'      <xs:element name="LONG_STRING" type="LO"/>' ||
'      <xs:element name="LONG_TEXT" type="LT"/>' ||
'      <xs:element name="OTHER_BYTE" type="OB"/>' ||
'      <xs:element name="OTHER_FLOAT" type="OF"/>' ||
'      <xs:element name="OTHER_WORD" type="OW"/>' ||
'      <xs:element name="PERSON_NAME" type="PN"/>' ||
'      <xs:element name="SHORT_STRING" type="SH"/>' ||
'      <xs:element name="SIGNED_LONG" type="SL"/>' ||
'      <xs:element name="SEQUENCE" type="SQ"/>' ||
'      <xs:element name="SIGNED_SHORT" type="SS"/>' ||
'      <xs:element name="SHORT_TEXT" type="ST"/>' ||
'      <xs:element name="TIME" type="TM"/>' ||
'      <xs:element name="UNIQUE_ID" type="UI"/>' ||
'      <xs:element name="UNSIGNED_LONG" type="UL"/>' ||
'      <xs:element name="UNKNOWN" type="UN"/>' ||
'      <xs:element name="UNSIGNED_SHORT" type="US"/>' ||
'      <xs:element name="UNLIMITED_TEXT" type="UT"/>' ||
'      <xs:element name="EXTENDED_TYPE" type="EXT"/>' ||
'      <xs:element name="EXCEPTION_TYPE" type="EXP"/>' ||
'    </xs:choice>' ||
'  </xs:complexType>' ||
'  <xs:attributeGroup name="ATTR_GRP_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Attribute group type (ATTR_GRP_T) is used by all DICOM attribute ' ||
'        definitions. It defines XML attributes that are used by all DICOM' ||
'        attribute types.' ||
'        The "tag" attribute defines DICOM attributes in little-endian encoding.' ||
'        The "definer" attribute specifies the organization that has' ||
'        created the attribute. By default, all DICOM standard ' ||
'        attributes have the definer name "DICOM".' ||
'        The "name" attribute specifies the canonical attribute name' ||
'        as defined by the data dictionary. For example, in ' ||
'        an XML metadata schema definition, you can choose a tag' ||
'        PATIENT_DATE_OF_BIRTH or "DOB" for DICOM attribute ' ||
'        (0010,0030), but its name attribute should match that of the' ||
'        DICOM standard: "Patient''s Birth Date".' ||
'        The "number" attribute is an optional attribute to indicate the' ||
'        ordering of a multivalued attributes.  Number counts from 1 up.' ||
'        The "truncated" attribute takes a Boolean value. If it is true,' ||
'        it indicates that the original length of the DICOM attribute' ||
'        exceeds the maximum length allowed for this XML value;therefore,' ||
'        it is truncated in XML. When this attribute is true, ' ||
'        xsi:nill="true" for this attribute.' ||
'        Optionally, the "rawValue" attribute can be used to store ' ||
'        values that do not conform to the DICOM standard.   The ' ||
'        associated attribute "byteOrderLE" specifies the byte order' ||
'        of the byte stream for the "rawValue" attribute.' ||
'        "offset" and "length" are Oracle-reserved attributes.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:attribute name="tag" type="AT" use="required"/>' ||
'    <xs:attribute name="definer" type="LO" default="DICOM"/>' ||
'    <xs:attribute name="name" type="SHORT_STRING_T"/>' ||
'    <xs:attribute name="number" type="xs:long" use="optional" default="1"/>' ||
'    <xs:attribute name="offset" type="xs:long"/>' ||
'    <xs:attribute name="length" type="xs:long"/>' ||
'    <xs:attribute name="truncated" type="xs:boolean" default="false"/>' ||
'    <xs:attribute name="rawValue" type="xs:base64Binary"/>' ||
'    <xs:attribute name="byteOrderLE" type="xs:boolean" default="true"/>' ||
'  </xs:attributeGroup>' ||
'  <xs:complexType name="AE_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="AE">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="AS_ATTR_T">' ||
'    <xs:complexContent>' ||
'      <xs:extension base="AS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="AT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="AT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="CS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="CS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DA_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="DA">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="DS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="DT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="FD_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="FD">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="FL_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="FL">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="IS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="IS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="LO_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="LO">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="LT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="LT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="OB_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="OB">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="OF_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="OF">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="OW_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="OW">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="PN_ATTR_T">' ||
'    <xs:complexContent>' ||
'      <xs:extension base="PN">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SH_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="SH">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SL_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="SL">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SQ_ATTR_T">' ||
'    <xs:complexContent>' ||
'      <xs:extension base="SQ">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="SS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ST_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="ST">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="TM_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="TM">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UI_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UI">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UL_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UL">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UN_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UN">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ;

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

  ordSchema := 
'  <xs:complexType name="US_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="US">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="EXT_ATTR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        This attribute is useful for representing attributes whose' ||
'        VR types are not supported natively by Oracle.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:complexContent>' ||
'      <xs:extension base="EXT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="EXP_ATTR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        This attribute type is useful for representing attributes that' ||
'        are present in a DICOM object, but whose definition cannot' ||
'        be found in the data dictionary. Such' ||
'        attributes cannot be parsed or interpreted.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="EXP">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DOCUMENT_HEADER_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'         Each time the XML configuration document is modified, ' ||
'         a new element, DOCUMENT_CHANGE_LOG, is ' ||
'         added to the DOCUMENT_HEADER.' ||
'         The change log describes who made what type of change to the ' ||
'         XML document on which date. It also describes what DICOM' ||
'         standard document the modification is based upon, either' ||
'         a DICOM change proposal (CP) or a DICOM supplement. ' ||
'         ' ||
'         DOCUMENT_MODIFIER identifies the modifier of the present ' ||
'         XML document. If it is generated by software, specify the name ' ||
'         and version of the software.' ||
'         DOCUMENT_MODIFICATION_DATE specifies the date when' ||
'         this XML document is modified.' ||
'         DOCUMENT_VERSION specifies the version of the document after ' ||
'         the modification.' ||
'         MODIFICATION_COMMENT briefly describes the modification.' ||
'         BASE_DOCUMENT describes the document or DICOM standard' ||
'         that the modification is based upon.' ||
'         BASE_DOCUMENT_RELEASE_DATE specifies the release date of ' ||
'         the base document.' ||
'         BASE_DOCUMENT_DESCRIPTION briefly describes the base' ||
'         document.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="DOCUMENT_CHANGE_LOG" maxOccurs="unbounded">' ||
'        <xs:complexType>' ||
'          <xs:sequence>' ||
'            <xs:element name="DOCUMENT_MODIFIER" type="SHORT_STRING_T"/>' ||
'            <xs:element name="DOCUMENT_MODIFICATION_DATE" type="SHORT_STRING_T"/>' ||
'            <xs:element name="DOCUMENT_VERSION" type="SHORT_STRING_T" minOccurs="0"/>' ||
'            <xs:element name="MODIFICATION_COMMENT" type="SHORT_TEXT_T" minOccurs="0"/>' ||
'            <xs:element name="BASE_DOCUMENT" type="SHORT_STRING_T" minOccurs="0"/>' ||
'            <xs:element name="BASE_DOCUMENT_RELEASE_DATE" type="xs:date" minOccurs="0"/>' ||
'            <xs:element name="BASE_DOCUMENT_DESCRIPTION" type="SHORT_TEXT_T" minOccurs="0"/>' ||
'          </xs:sequence>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ATTR_DEFINERS_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Attribute definer is identified by its name and UID.  ' ||
'        In Oracle''s implementation, the DICOM standard is given the' ||
'        definer name "DICOM" and the UID "1.2.840.10008.1".  ' ||
'        All DICOM standard attributes are given the definer name "DICOM".' ||
'        Users can introduce private attributes of their own and encode them' ||
'        in an XML document. These private attributes are identified' ||
'        with the definer''s name and UID. Oracle recommends that all DICOM ' ||
'        private attributes be associated with a UID-qualified name.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence maxOccurs="unbounded">' ||
'      <xs:element name="ATTR_DEFINER">' ||
'        <xs:complexType>' ||
'          <xs:sequence>' ||
'            <xs:element name="NAME" type="LO" maxOccurs="unbounded"/>' ||
'            <xs:element name="UID" type="UI" minOccurs="0"/>' ||
'          </xs:sequence>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <!-- Attribute Tag (allowing x wildcard)-->' ||
'  <xs:simpleType name="ATTR_TAG_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation> ' ||
'        The attribute tag type differs from DICOM VR ' ||
'        type AT in that it allows the wildcard character ''x''.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:pattern value="([0-9a-fA-FxX]{8})"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="ATTR_RANGE_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        The attribute range type defines a range of DICOM attributes. ' ||
'        This data type is used in private attribute definitions.' ||
'        Certain private attributes accept a range of attribute tags.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="STARTING_TAG" type="ATTR_TAG_T"/>' ||
'      <xs:element name="ENDING_TAG" type="ATTR_TAG_T"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="VALUE_LOCATOR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        The DICOM value locator type identifies a particular' ||
'        DICOM attribute by "xxxxxxxx(definer)", where ' ||
'        "xxxxxxxx" is the attribute tag and "definer" is the' ||
'        attribute definer, which can be the DICOM standard' ||
'        (DICOM) or other private sources. ' ||
'        A locator path can also identify a particular ' ||
'        descendent of a container type attribute (SQ).' ||
'        The n-th item of a sequence attribute is denoted by' ||
'        "xxxxxxxxx(definer)[n]".    ' ||
'        By default, the definer suffix "(definer)" can be ' ||
'        omitted if the attribute is a DICOM standard tag.  ' ||
'        The index "n" of an item address "[n]" must be a ' ||
'        positive integer. The item address suffix can be ' ||
'        omitted if the item it pointed to is the first item ' ||
'        of a sequence. ' ||
'        For example, 00080096.00401101.00080100 is the code ' ||
'        that identifies the first referring physician. The ' ||
'        above value locator is equivalent to:' ||
'          00080096(DICOM)[1].00401101(DICOM)[1].00080100(DICOM)' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="VALUE_LOCATOR_MACRO_T"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="VALUE_LOCATOR_MACRO_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        VALUE_LOCATOR_MACRO_T is similar to the value locator' ||
'        type, except that it permits the use of a macro within' ||
'        the locator string.' ||
'        So, the macro locator string can be:' ||
'          ${TAG}(DICOM)[2].00080100' ||
'        This string indicates the code value (0008,0100) of the second ' ||
'        item of a sequence attribute identified by ${TAG}.' ||
'        The macro parameter TAG can be replaced by a ' ||
'        compatible attribute tag (code sequence attribute)' ||
'        later.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="SHORT_TEXT_T"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="VM_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM value multiplicity (VM) specification. ' ||
'        This type is used in DICOM dictionary documents. ' ||
'        Patterns of valid specifications are:' ||
'        "k", "k-j", "k-n", "n", "k-kn".' ||
'        In these patterns, k and j are integers, k is less ' ||
'        than j, and n is the letter n.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="SHORT_STRING_T">' ||
'      <xs:pattern value="(([0-9]+)-)?(([0-9]*n|([0-9]+)))"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="VR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM value representation types.' ||
'        In the DICOM standard, VR for certain attributes ' ||
'        is defined as "other word or byte", "US or SS", or' ||
'        "See Note". Oracle has extended the list of VR types and ' ||
'        introduced OWB (for "other word or byte"), ' ||
'        USS (for "US or SS"), and ' ||
'        EXP (where VR definition does not apply).' ||
'        When an attribute of USS type is encoded into XML, it is' ||
'        automatically encoded as a signed short type.' ||
'        When an attribute of OWB type is encoded into XML, it is' ||
'        automatically encoded into other word type.' ||
'        An example of an attribute with VR type of EXP is' ||
'        the sequence item (FFFE, E000).' ||
'        For compatibility with future DICOM releases, if a new ' ||
'        DICOM VR is introduced by the DICOM standard, ' ||
'        users can mark such attributes as type "EXT??", ' ||
'        where "??" should be replaced by the new VR name.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:pattern value="AE"/>' ||
'      <xs:pattern value="AS"/>' ||
'      <xs:pattern value="AT"/>' ||
'      <xs:pattern value="CS"/>' ||
'      <xs:pattern value="DA"/>' ||
'      <xs:pattern value="DS"/>' ||
'      <xs:pattern value="DT"/>' ||
'      <xs:pattern value="FL"/>' ||
'      <xs:pattern value="FD"/>' ||
'      <xs:pattern value="IS"/>' ||
'      <xs:pattern value="LO"/>' ||
'      <xs:pattern value="LT"/>' ||
'      <xs:pattern value="OB"/>' ||
'      <xs:pattern value="OF"/>' ||
'      <xs:pattern value="OW"/>' ||
'      <xs:pattern value="PN"/>' ||
'      <xs:pattern value="SH"/>' ||
'      <xs:pattern value="SL"/>' ||
'      <xs:pattern value="SQ"/>' ||
'      <xs:pattern value="SS"/>' ||
'      <xs:pattern value="ST"/>' ||
'      <xs:pattern value="TM"/>' ||
'      <xs:pattern value="UI"/>' ||
'      <xs:pattern value="UL"/>' ||
'      <xs:pattern value="UN"/>' ||
'      <xs:pattern value="US"/>' ||
'      <xs:pattern value="UT"/>' ||
'      <xs:pattern value="USS"/>' ||
'      <xs:pattern value="OWB"/>' ||
'      <xs:pattern value="EXP"/>' ||
'      <xs:pattern value="EXT[A-Z]{2}"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="SHORT_TEXT_T">' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="1999"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="MIXED_TEXT_T" mixed="true">' ||
'   <xs:complexContent mixed="true">' ||
'      <xs:extension base="xs:anyType">' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="SHORT_STRING_T">' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="128"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="SHORT_NAME_T">' ||
'      <xs:restriction base="xs:NCName">' ||
'         <xs:maxLength value="128"/>' ||
'      </xs:restriction>' ||
'   </xs:simpleType>' ||
'  <xs:simpleType name="SHORT_ID_T">' ||
'    <xs:restriction base="xs:ID">' ||
'      <xs:maxLength value="64"/>' ||
'      <xs:pattern value="[^\.]+"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'</xs:schema>';
  sys.dbms_lob.writeAppend(ordClob, length(ordSchema), ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/datatype_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmmddt.xsd with XDB under http://xmlns.oracle.com/ord/dicom/mddatatype_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. ' ||
'' ||
'   NAME' ||
'     ordcmmddt.xsd - XML schema for metadata data types ' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   fechen      01/23/09 - remove the patten in the locatorpath' ||
'   dolin       10/17/08 - allow [*] for locator path' ||
'   fechen      09/16/08 - make DATASET_T minOccurs=0 and ' ||
'                          add optional number attr to DATASET_T and ATTR_GRP_T' ||
'   dolin       06/12/07 - update comments' ||
'   dolin       06/06/07 - doc editor comments' ||
'   myalavar    04/10/07 - doc comments' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'-->' ||
'' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/dicom/metadata_1_0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xdb="http://xmlns.oracle.com/xdb" targetNamespace="http://xmlns.oracle.com/ord/dicom/metadata_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'    Introduction' ||
'      This schema defines the data types that are used ' ||
'      by DICOM metadata schemas.' ||
'      ' ||
'    Naming conventions:' ||
'    All DICOM value representation (VR) types are named with a ' ||
'    2-character string, such as "AE" and "CS".' ||
'    All DICOM attribute type definitions are named as VR_ATTR_T, ' ||
'    where VR is replaced by the attribute''s 2-character VR.' ||
'    ' ||
'    Note that each item of a sequence type (SQ) is of DATASET_T type.' ||
'    The DATASET_T type can recursively contain more attributes.' ||
'    The element name of an attribute is its value representation (VR)' ||
'    name. Oracle uses value representation names defined' ||
'    by the DICOM standard part 5. The element' ||
'    name to VR mappings are:' ||
'      APPLICATION_ENTITY     ---   AE' ||
'      AGE_STRING     ---  AS' ||
'      ATTRIBUTE_TAG     ---  AT' ||
'      CODE_STRING     ---  CS' ||
'      DATE     ---  DA' ||
'      DECIMAL_STRING     ---  DS' ||
'      FLOAT_SINGLE     ---  FL' ||
'      FLOAT_DOUBLE     ---  FD' ||
'      INTEGER_STRING     ---  IS' ||
'      LONG_STRING     ---  LO' ||
'      LONG_TEXT     ---  LT' ||
'      OTHER_BYTE     ---  OB' ||
'      OTHER_FLOAT     ---  OF' ||
'      OTHER_WORD     ---  OW' ||
'      OTHER_WORD     ---  OWB' ||
'      PERSON_NAME     ---  PN' ||
'      SHORT_STRING     ---  SH' ||
'      SIGNED_LONG     ---  SL' ||
'      SEQUENCE     ---  SQ' ||
'      SIGNED_SHORT     ---  SS' ||
'      SHORT_TEXT     ---  ST' ||
'      TIME     ---  TM' ||
'      UNIQUE_ID     ---  UI' ||
'      UNSIGNED_LONG     ---  UL' ||
'      UNKNOWN     ---  UN' ||
'      UNSIGNED_SHORT     ---  US' ||
'      SIGNED_SHORT       ---  USS' ||
'      UNLIMITED_TEXT     ---  UT' ||
'      EXTENDED_TYPE     ---  EXT' ||
'      EXCEPTION_TYPE     ---  EXP' ||
'      The VR types "OWB'', "EXT", "EXP" and "USS" are ' ||
'      Oracle-defined extensions.' ||
'      Please refer to the individual data type documentation for ' ||
'      more explanation.' ||
'    </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:simpleType name="AE">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Value representation Application Entity</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="16"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="AS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Value representation Age String. ' ||
'        The age string can be expressed either in DICOM string ' ||
'        format, or in number of days. When metadata is extracted ' ||
'        from a DICOM object, both elements will be populated.' ||
'        XML documents can represent age by either format.  ' ||
'        Age in number of days is converted into an age string when ' ||
'        XML metadata is encoded into a DICOM object.' ||
'        To convert from age string into the number of days:  ' ||
'          365 * number_of_year or 31 * number_of_month.  ' ||
'        Because AGE_STRING is mandatory, it is not necessary to ' ||
'        convert from the number of days into an age string. ' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="VALUE" nillable="true">' ||
'        <xs:simpleType>' ||
'          <xs:restriction base="xs:token">' ||
'            <xs:pattern value="[0-9]{3}(D|W|M|Y)"/>' ||
'          </xs:restriction>' ||
'        </xs:simpleType>' ||
'      </xs:element>' ||
'      <xs:element name="AGE_IN_DAYS" type="xs:unsignedInt" minOccurs="0"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="AT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type Attribute Tag. An attribute tag is expressed as two ' ||
'        big-endian 2-byte hexadecimal number (group number followed by ' ||
'        element number with no separator).' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:hexBinary">' ||
'      <xs:minLength value="4"/>' ||
'      <xs:maxLength value="4"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="CS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Code String</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="16"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="DA">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type DAte</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:date"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="DS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Decimal String</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:float"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="DT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Data Time</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:dateTime"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="FL">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type FLoating-point single</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:float"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="FD">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Floating-point Double</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:double"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="IS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Integer String</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:integer"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="LO">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type LOng string</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="64"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="LT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Long Text</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="10240"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="OB">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Other Byte</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:base64Binary"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="OF">' ||
'    <xs:annotation>' ||
'      <xs:documentation> VR type Other Float </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:float"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="OW">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type Other Word in base64binary encoding.' ||
'        The mandatory attribute endian specifies the byte ' ||
'        order of the binary value.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="xs:base64Binary">' ||
'        <xs:attribute name="endian" use="required">' ||
'          <xs:simpleType>' ||
'            <xs:restriction base="xs:token">' ||
'              <xs:enumeration value="big"/>' ||
'              <xs:enumeration value="little"/>' ||
'            </xs:restriction>' ||
'          </xs:simpleType>' ||
'        </xs:attribute>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="PN">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type Person Name. Person Name can be' ||
'        expressed either in component format or as a single ' ||
'        concatentated string. When metadata is extracted from a ' ||
'        DICOM object, the person name type is encoded with' ||
'        both formats. Users can index and search DICOM ' ||
'        metadata with either the component format or the ' ||
'        concatenated string format.' ||
'        In component format, a name has an optional "type" attribute that' ||
'        indicates its encoding type. The value of the "type" attribute ' ||
'        can be "unibyte", "ideographic" or "phonetic". A name may ' ||
'        have up to five components: "FAMILY", "GIVEN", "MIDDLE",' ||
'        "PREFIX", and "SUFFIX".' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="NAME" minOccurs="0" maxOccurs="3" nillable="true">' ||
'        <xs:complexType>' ||
'          <xs:sequence>' ||
'            <xs:element name="FAMILY" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="GIVEN" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="MIDDLE" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="PREFIX" type="xs:string" minOccurs="0" nillable="true"/>' ||
'            <xs:element name="SUFFIX" type="xs:string" minOccurs="0" nillable="true"/>' ||
'          </xs:sequence>' ||
'          <xs:attribute name="type" default="unibyte">' ||
'            <xs:simpleType>' ||
'              <xs:restriction base="xs:token">' ||
'                <xs:enumeration value="unibyte"/>' ||
'                <xs:enumeration value="ideographic"/>' ||
'                <xs:enumeration value="phonetic"/>' ||
'              </xs:restriction>' ||
'            </xs:simpleType>' ||
'          </xs:attribute>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'      <xs:element name="VALUE" minOccurs="0" nillable="true">' ||
'        <xs:simpleType>' ||
'          <xs:restriction base="xs:token">' ||
'            <xs:maxLength value="64"/>' ||
'          </xs:restriction>' ||
'        </xs:simpleType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="SH">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type SHort string</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="16"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="SL">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Signed Long</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:integer"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="SQ">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type SeQuence. ' ||
'        Note that item number can be explicitly encoded in XML. ' ||
'        Number counts from 1 up.' ||
'        Each item is a DATASET_T type, which may contain ' ||
'        any combination of DICOM attributes.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence maxOccurs="unbounded">' ||
'      <xs:element name="ITEM" type="DATASET_T" minOccurs="0" nillable="true"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="SS">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Signed Short</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:integer"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="ST">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Short Text</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'      <xs:maxLength value="1024"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="TM">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type TiMe</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:time"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="UI">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unique Identifier</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="128"/>' ||
'      <xs:pattern value="[0-9\.]+"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="UL">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unsigned Long</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:unsignedInt"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="UN">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM VR type UNknown.' ||
'        This type contains a base64 dump of its binary content. The mandatory' ||
'        attribute "endian" specifies the byte order of this encoding.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="xs:base64Binary">' ||
'        <xs:attribute name="endian" use="required">' ||
'          <xs:simpleType>' ||
'            <xs:restriction base="xs:token">' ||
'              <xs:enumeration value="big"/>' ||
'              <xs:enumeration value="little"/>' ||
'            </xs:restriction>' ||
'          </xs:simpleType>' ||
'        </xs:attribute>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="US">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unsigned Short</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:unsignedShort"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="UT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM VR type Unlimited Text</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="EXT">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Extension type ' ||
'        This type does not have direct mapping to any value ' ||
'        representation (VR) types defined in Part 5 of the ' ||
'        DICOM standard.   ' ||
'        It can accommodate future extensions to DICOM VR' ||
'        types without modification to the XML schema definitions.' ||
'        The VR element specifies the value representation.' ||
'        The VALUE element specifies the XML value for the' ||
'        corresponding data element. The exact XML schema ' ||
'        definition can be introduced in the future.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="VR" type="xs:token"/>' ||
'      <xs:element name="VALUE" type="xs:anyType" nillable="true"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="EXP">' ||
'    <xs:annotation>' ||
'      <xs:documentation>DICOM Exception type.' ||
'        This type does not have direct mapping to any value ' ||
'        representation (VR) types defined in Part 5 of the ' ||
'        DICOM standard.   ' ||
'        It indicates an error situation. It is equivalent to ' ||
'        an exception in the Java language.' ||
'        The value of this data type is the original byte ' ||
'        array of the data type in the DICOM object.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:base64Binary"/>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="DATASET_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        The dataset type maps the DICOM concept dataset ' ||
'        into an XML schema type(See the DICOM standard P3-5) .' ||
'        A dataset may contain any number of DICOM attributes.' ||
'        Each type of attribute has a name that reflects' ||
'        the DICOM value representation of the attribute.' ||
'        Each attribute is strongly typed, and its type matches its DICOM' ||
'        VR. Note that DICOM attribute type SQ (sequence) may ' ||
'        recursively contain items that are also of the dataset type.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:choice maxOccurs="unbounded" minOccurs="0">' ||
'      <xs:element name="APPLICATION_ENTITY" type="AE_ATTR_T" nillable="true"/>' ||
'      <xs:element name="AGE_STRING" type="AS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="ATTRIBUTE_TAG" type="AT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="CODE_STRING" type="CS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="DATE" type="DA_ATTR_T" nillable="true"/>' ||
'      <xs:element name="DATE_TIME" type="DT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="DECIMAL_STRING" type="DS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="FLOAT_SINGLE" type="FL_ATTR_T" nillable="true"/>' ||
'      <xs:element name="FLOAT_DOUBLE" type="FD_ATTR_T" nillable="true"/>' ||
'      <xs:element name="INTEGER_STRING" type="IS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="LONG_STRING" type="LO_ATTR_T" nillable="true"/>' ||
'      <xs:element name="LONG_TEXT" type="LT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="OTHER_BYTE" type="OB_ATTR_T" nillable="true"/>' ||
'      <xs:element name="OTHER_FLOAT" type="OF_ATTR_T" nillable="true"/>' ||
'      <xs:element name="OTHER_WORD" type="OW_ATTR_T" nillable="true"/>' ||
'      <xs:element name="PERSON_NAME" type="PN_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SHORT_STRING" type="SH_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SIGNED_LONG" type="SL_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SEQUENCE" type="SQ_ATTR_T" nillable="true" xdb:SQLType="CLOB" xdb:SQLName="SEQUENCE"/>' ||
'      <xs:element name="SIGNED_SHORT" type="SS_ATTR_T" nillable="true"/>' ||
'      <xs:element name="SHORT_TEXT" type="ST_ATTR_T" nillable="true"/>' ||
'      <xs:element name="TIME" type="TM_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNIQUE_ID" type="UI_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNSIGNED_LONG" type="UL_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNKNOWN" type="UN_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNSIGNED_SHORT" type="US_ATTR_T" nillable="true"/>' ||
'      <xs:element name="UNLIMITED_TEXT" type="UT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="EXTENDED_TYPE" type="EXT_ATTR_T" nillable="true"/>' ||
'      <xs:element name="EXCEPTION_TYPE" type="EXP_ATTR_T" nillable="true"/>' ||
'    </xs:choice>' ||
'    <xs:attribute name="number" type="xs:long" use="optional" default="1"/>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ATTR_VALUE_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Attribute value type (ATTR_VALUE_T) maps to a single DICOM' ||
'        attribute value. Each type of attribute has a name that reflects' ||
'        the DICOM value representation of the attribute.' ||
'        Each attribute is strongly typed, and its type matches its DICOM' ||
'        VR. Certain DICOM configuration files, such as constraint ' ||
'        documents, use ATTR_VALUE_T.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:choice>' ||
'      <xs:element name="APPLICATION_ENTITY" type="AE"/>' ||
'      <xs:element name="AGE_STRING" type="AS"/>' ||
'      <xs:element name="ATTRIBUTE_TAG" type="AT"/>' ||
'      <xs:element name="CODE_STRING" type="CS"/>' ||
'      <xs:element name="DATE" type="DA"/>' ||
'      <xs:element name="DATE_TIME" type="DT"/>' ||
'      <xs:element name="DECIMAL_STRING" type="DS"/>' ||
'      <xs:element name="FLOAT_SINGLE" type="FL"/>' ||
'      <xs:element name="FLOAT_DOUBLE" type="FD"/>' ||
'      <xs:element name="INTEGER_STRING" type="IS"/>' ||
'      <xs:element name="LONG_STRING" type="LO"/>' ||
'      <xs:element name="LONG_TEXT" type="LT"/>' ||
'      <xs:element name="OTHER_BYTE" type="OB"/>' ||
'      <xs:element name="OTHER_FLOAT" type="OF"/>' ||
'      <xs:element name="OTHER_WORD" type="OW"/>' ||
'      <xs:element name="PERSON_NAME" type="PN"/>' ||
'      <xs:element name="SHORT_STRING" type="SH"/>' ||
'      <xs:element name="SIGNED_LONG" type="SL"/>' ||
'      <xs:element name="SEQUENCE" type="SQ"/>' ||
'      <xs:element name="SIGNED_SHORT" type="SS"/>' ||
'      <xs:element name="SHORT_TEXT" type="ST"/>' ||
'      <xs:element name="TIME" type="TM"/>' ||
'      <xs:element name="UNIQUE_ID" type="UI"/>' ||
'      <xs:element name="UNSIGNED_LONG" type="UL"/>' ||
'      <xs:element name="UNKNOWN" type="UN"/>' ||
'      <xs:element name="UNSIGNED_SHORT" type="US"/>' ||
'      <xs:element name="UNLIMITED_TEXT" type="UT"/>' ||
'      <xs:element name="EXTENDED_TYPE" type="EXT"/>' ||
'      <xs:element name="EXCEPTION_TYPE" type="EXP"/>' ||
'    </xs:choice>' ||
'  </xs:complexType>' ||
'  <xs:attributeGroup name="ATTR_GRP_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Attribute group type (ATTR_GRP_T) is used by all DICOM attribute ' ||
'        definitions. It defines XML attributes that are used by all DICOM' ||
'        attribute types.' ||
'        The "tag" attribute defines DICOM attributes in little-endian encoding.' ||
'        The "definer" attribute specifies the organization that has' ||
'        created the attribute. By default, all DICOM standard ' ||
'        attributes have the definer name "DICOM".' ||
'        The "name" attribute specifies the canonical attribute name' ||
'        as defined by the data dictionary. For example, in ' ||
'        an XML metadata schema definition, you can choose a tag' ||
'        PATIENT_DATE_OF_BIRTH or "DOB" for DICOM attribute ' ||
'        (0010,0030), but its name attribute should match that of the' ||
'        DICOM standard: "Patient''s Birth Date".' ||
'        The "number" attribute is an optional attribute to indicate the' ||
'        ordering of a multivalued attributes.  Number counts from 1 up.' ||
'        The "truncated" attribute takes a Boolean value. If it is true,' ||
'        it indicates that the original length of the DICOM attribute' ||
'        exceeds the maximum length allowed for this XML value;therefore,' ||
'        it is truncated in XML. When this attribute is true, ' ||
'        xsi:nill="true" for this attribute.' ||
'        Optionally, the "rawValue" attribute can be used to store ' ||
'        values that do not conform to the DICOM standard. The ' ||
'        associated attribute "byteOrderLE" specifies the byte order' ||
'        of the byte stream for the "rawValue" attribute.' ||
'        "offset" and "length" are Oracle-reserved attributes.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:attribute name="tag" type="AT" use="required"/>' ||
'    <xs:attribute name="definer" type="LO" default="DICOM"/>' ||
'    <xs:attribute name="name" type="SHORT_STRING_T"/>' ||
'    <xs:attribute name="number" type="xs:long" use="optional" default="1"/>' ||
'    <xs:attribute name="offset" type="xs:long"/>' ||
'    <xs:attribute name="length" type="xs:long"/>' ||
'    <xs:attribute name="truncated" type="xs:boolean" default="false"/>' ||
'    <xs:attribute name="rawValue" type="xs:base64Binary"/>' ||
'    <xs:attribute name="byteOrderLE" type="xs:boolean" default="true"/>' ||
'  </xs:attributeGroup>' ||
'  <xs:complexType name="AE_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="AE">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="AS_ATTR_T">' ||
'    <xs:complexContent>' ||
'      <xs:extension base="AS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="AT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="AT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="CS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="CS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DA_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="DA">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="DS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="DT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="FD_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="FD">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="FL_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="FL">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="IS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="IS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="LO_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="LO">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="LT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="LT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="OB_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="OB">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="OF_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="OF">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="OW_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="OW">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="PN_ATTR_T">' ||
'    <xs:complexContent>' ||
'      <xs:extension base="PN">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SH_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="SH">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SL_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="SL">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SQ_ATTR_T">' ||
'    <xs:complexContent>' ||
'      <xs:extension base="SQ">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="SS_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="SS">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ST_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="ST">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="TM_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="TM">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UI_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UI">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UL_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UL">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ;

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

  ordSchema := 
'  <xs:complexType name="UN_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UN">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="US_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="US">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="UT_ATTR_T">' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="UT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="EXT_ATTR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        This attribute is useful for representing attributes whose' ||
'        VR types are not supported natively by Oracle.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:complexContent>' ||
'      <xs:extension base="EXT">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="EXP_ATTR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        This attribute type is useful for representing attributes that' ||
'        are present in a DICOM object, but whose definition cannot' ||
'        be found in the data dictionary. Such' ||
'        attributes cannot be parsed or interpreted.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="EXP">' ||
'        <xs:attributeGroup ref="ATTR_GRP_T"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="DOCUMENT_HEADER_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'         Each time the XML configuration document is modified, ' ||
'         a new element, DOCUMENT_CHANGE_LOG, is ' ||
'         added to the DOCUMENT_HEADER.' ||
'         The change log describes who made what type of change to the ' ||
'         XML document on which date. It also describes what DICOM' ||
'         standard document the modification is based upon, either' ||
'         a DICOM change proposal (CP) or a DICOM supplement. ' ||
'         ' ||
'         DOCUMENT_MODIFIER identifies the modifier of the present ' ||
'         XML document. If it is generated by software, specify the name ' ||
'         and version of the software.' ||
'         DOCUMENT_MODIFICATION_DATE specifies the date when' ||
'         this XML document is modified.' ||
'         DOCUMENT_VERSION specifies the version of the document after ' ||
'         the modification.' ||
'         MODIFICATION_COMMENT briefly describes the modification.' ||
'         BASE_DOCUMENT describes the document or DICOM standard' ||
'         that the modification is based upon.' ||
'         BASE_DOCUMENT_RELEASE_DATE specifies the release date of ' ||
'         the base document.' ||
'         BASE_DOCUMENT_DESCRIPTION briefly describes the base' ||
'         document.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="DOCUMENT_CHANGE_LOG" maxOccurs="unbounded">' ||
'        <xs:complexType>' ||
'          <xs:sequence>' ||
'            <xs:element name="DOCUMENT_MODIFIER" type="SHORT_STRING_T"/>' ||
'            <xs:element name="DOCUMENT_MODIFICATION_DATE" type="SHORT_STRING_T"/>' ||
'            <xs:element name="DOCUMENT_VERSION" type="SHORT_STRING_T" minOccurs="0"/>' ||
'            <xs:element name="MODIFICATION_COMMENT" type="SHORT_TEXT_T" minOccurs="0"/>' ||
'            <xs:element name="BASE_DOCUMENT" type="SHORT_STRING_T" minOccurs="0"/>' ||
'            <xs:element name="BASE_DOCUMENT_RELEASE_DATE" type="xs:date" minOccurs="0"/>' ||
'            <xs:element name="BASE_DOCUMENT_DESCRIPTION" type="SHORT_TEXT_T" minOccurs="0"/>' ||
'          </xs:sequence>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ATTR_DEFINERS_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Attribute definer is identified by its name and UID.  ' ||
'        In Oracle''s implementation, the DICOM standard is given the' ||
'        definer name "DICOM" and the UID "1.2.840.10008.1".  ' ||
'        All DICOM standard attributes are given the definer name "DICOM".' ||
'        Users can introduce private attributes of their own and encode them' ||
'        in an XML document. These private attributes are identified' ||
'        with the definer''s name and UID. Oracle recommends that all DICOM ' ||
'        private attributes be associated with a UID-qualified name.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence maxOccurs="unbounded">' ||
'      <xs:element name="ATTR_DEFINER">' ||
'        <xs:complexType>' ||
'          <xs:sequence>' ||
'            <xs:element name="NAME" type="LO" maxOccurs="unbounded"/>' ||
'            <xs:element name="UID" type="UI" minOccurs="0"/>' ||
'          </xs:sequence>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <!-- Attribute Tag (allowing x wildcard)-->' ||
'  <xs:simpleType name="ATTR_TAG_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation> ' ||
'        The attribute tag type differs from DICOM VR ' ||
'        type AT in that it allows the wildcard character ''x''.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:pattern value="([0-9a-fA-FxX]{8})"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="ATTR_RANGE_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        The attribute range type defines a range of DICOM attributes. ' ||
'        This data type is used in private attribute definitions.' ||
'        Certain private attributes accept a range of attribute tags.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="STARTING_TAG" type="ATTR_TAG_T"/>' ||
'      <xs:element name="ENDING_TAG" type="ATTR_TAG_T"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="VALUE_LOCATOR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        The DICOM value locator type identifies a particular' ||
'        DICOM attribute by "xxxxxxxx(definer)", where ' ||
'        "xxxxxxxx" is the attribute tag and "definer" is the' ||
'        attribute definer, which can be the DICOM standard' ||
'        (DICOM) or other private sources. ' ||
'        A locator path can also identify a particular ' ||
'        descendent of a container type attribute (SQ).' ||
'        The n-th item of a sequence attribute is denoted by' ||
'        "xxxxxxxxx(definer)[n]".    ' ||
'        By default, the definer suffix "(definer)" can be ' ||
'        omitted if the attribute is a DICOM standard tag.  ' ||
'        The index "n" of an item address "[n]" must be a ' ||
'        positive integer. The item address suffix can be ' ||
'        omitted if the item it pointed to is the first item ' ||
'        of a sequence. ' ||
'        For example, 00080096.00401101.00080100 is the code ' ||
'        that identifies the first referring physician. The ' ||
'        above value locator is equivalent to:' ||
'          00080096(DICOM)[1].00401101(DICOM)[1].00080100(DICOM)' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="VALUE_LOCATOR_MACRO_T"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="VALUE_LOCATOR_MACRO_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        VALUE_LOCATOR_MACRO_T is similar to the value locator' ||
'        type, except that it permits the use of a macro within' ||
'        the locator string.' ||
'        So, the macro locator string can be:' ||
'          ${TAG}(DICOM)[2].00080100' ||
'        This string indicates the code value (0008,0100) of the second ' ||
'        item of a sequence attribute identified by ${TAG}.' ||
'        The macro parameter TAG can be replaced by a ' ||
'        compatible attribute tag (code sequence attribute)' ||
'        later.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="SHORT_TEXT_T"/>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="VM_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM value multiplicity (VM) specification. ' ||
'        This type is used in DICOM dictionary documents. ' ||
'        Patterns of valid specifications are:' ||
'        "k", "k-j", "k-n", "n", "k-kn".' ||
'        In these patterns, k and j are integers, k is less ' ||
'        than j, and n is the letter n.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="SHORT_STRING_T">' ||
'      <xs:pattern value="(([0-9]+)-)?(([0-9]*n|([0-9]+)))"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="VR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        DICOM value representation types.' ||
'        In the DICOM standard, VR for certain attributes ' ||
'        is defined as "other word or byte", "US or SS", or' ||
'        "See Note". Oracle has extended the list of VR types and ' ||
'        introduced OWB (for "other word or byte"), ' ||
'        USS (for "US or SS"), and ' ||
'        EXP (where VR definition does not apply).' ||
'        When an attribute of USS type is encoded into XML, it is' ||
'        automatically encoded as a signed short type.' ||
'        When an attribute of OWB type is encoded into XML, it is' ||
'        automatically encoded into other word type.' ||
'        An example of an attribute with VR type of EXP is' ||
'        the sequence item (FFFE, E000).' ||
'        For compatibility with future DICOM releases, if a new ' ||
'        DICOM VR is introduced by the DICOM standard, ' ||
'        users can mark such attributes as type "EXT??", ' ||
'        where "??" should be replaced by the new VR name.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:pattern value="AE"/>' ||
'      <xs:pattern value="AS"/>' ||
'      <xs:pattern value="AT"/>' ||
'      <xs:pattern value="CS"/>' ||
'      <xs:pattern value="DA"/>' ||
'      <xs:pattern value="DS"/>' ||
'      <xs:pattern value="DT"/>' ||
'      <xs:pattern value="FL"/>' ||
'      <xs:pattern value="FD"/>' ||
'      <xs:pattern value="IS"/>' ||
'      <xs:pattern value="LO"/>' ||
'      <xs:pattern value="LT"/>' ||
'      <xs:pattern value="OB"/>' ||
'      <xs:pattern value="OF"/>' ||
'      <xs:pattern value="OW"/>' ||
'      <xs:pattern value="PN"/>' ||
'      <xs:pattern value="SH"/>' ||
'      <xs:pattern value="SL"/>' ||
'      <xs:pattern value="SQ"/>' ||
'      <xs:pattern value="SS"/>' ||
'      <xs:pattern value="ST"/>' ||
'      <xs:pattern value="TM"/>' ||
'      <xs:pattern value="UI"/>' ||
'      <xs:pattern value="UL"/>' ||
'      <xs:pattern value="UN"/>' ||
'      <xs:pattern value="US"/>' ||
'      <xs:pattern value="UT"/>' ||
'      <xs:pattern value="USS"/>' ||
'      <xs:pattern value="OWB"/>' ||
'      <xs:pattern value="EXP"/>' ||
'      <xs:pattern value="EXT[A-Z]{2}"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="SHORT_TEXT_T">' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="1999"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="MIXED_TEXT_T" mixed="true">' ||
'   <xs:complexContent mixed="true">' ||
'      <xs:extension base="xs:anyType">' ||
'      </xs:extension>' ||
'    </xs:complexContent>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="SHORT_STRING_T">' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:maxLength value="128"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:simpleType name="SHORT_NAME_T">' ||
'      <xs:restriction base="xs:NCName">' ||
'         <xs:maxLength value="128"/>' ||
'      </xs:restriction>' ||
'   </xs:simpleType>' ||
'  <xs:simpleType name="SHORT_ID_T">' ||
'    <xs:restriction base="xs:ID">' ||
'      <xs:maxLength value="64"/>' ||
'      <xs:pattern value="[^\.]+"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'</xs:schema>';
  sys.dbms_lob.writeAppend(ordClob, length(ordSchema), ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/mddatatype_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordimage.xsd with XDB under http://xmlns.oracle.com/ord/meta/ordimage
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright 2004, 2005 Oracle.  All rights reserved. -->' ||
'<xsd:schema xmlns="http://xmlns.oracle.com/ord/meta/ordimage" ' ||
'     targetNamespace="http://xmlns.oracle.com/ord/meta/ordimage" ' ||
'     xmlns:xsd="http://www.w3.org/2001/XMLSchema" ' ||
'     elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'' ||
'  <xsd:annotation>' ||
'    <xsd:documentation>' ||
'      Change History' ||
'        rabbott    2/10/2005      -- Add more comments' ||
'        rabbott    6/10/2004      -- Created' ||
'' ||
'      Introduction' ||
'        Oracle Multimedia schema for ORDSYS.ORDImage attributes' ||
'        Elements are optional and can appear in any order.' ||
'    </xsd:documentation>' ||
'  </xsd:annotation>' ||
'' ||
'  <xsd:complexType name="ordImageAttributesType">' ||
'    <xsd:all minOccurs="0">' ||
'      <xsd:element name="height" type="xsd:positiveInteger" minOccurs="0"/>' ||
'      <xsd:element name="width" type="xsd:positiveInteger" minOccurs="0"/>' ||
'      <xsd:element name="contentLength" type="xsd:positiveInteger" minOccurs="0"/>' ||
'      <xsd:element name="fileFormat" type="xsd:string" minOccurs="0"/>' ||
'      <xsd:element name="contentFormat" type="xsd:string" minOccurs="0"/>' ||
'      <xsd:element name="compressionFormat" type="xsd:string" minOccurs="0"/>' ||
'      <xsd:element name="mimeType" type="xsd:string" minOccurs="0"/>' ||
'    </xsd:all>' ||
'  </xsd:complexType>' ||
'' ||
'  <xsd:element name="ordImageAttributes" type="ordImageAttributesType"/>' ||
'</xsd:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/meta/ordimage',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordiptc.xsd with XDB under http://xmlns.oracle.com/ord/meta/iptc
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2004, 2008, Oracle. All rights reserved.  -->' ||
'<xsd:schema  xmlns="http://xmlns.oracle.com/ord/meta/iptc" ' ||
'     targetNamespace="http://xmlns.oracle.com/ord/meta/iptc" ' ||
'     xmlns:xsd="http://www.w3.org/2001/XMLSchema" ' ||
'     elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'' ||
'  <xsd:annotation>' ||
'    <xsd:documentation>' ||
'      Change History' ||
'        rabbott    1/25/2005      -- Add more comments' ||
'        rabbott    6/10/2004      -- Created' ||
'    ' ||
'      Introduction' ||
'        This is the Oracle Multimedia schema for metadata stored in Application' ||
'        record sets of the IPTC-NAA Information Interchange Model Version 4.' ||
'        This metadata is often referred to as ''IPTC'' tags.' ||
'' ||
'        For the JPEG file format, IPTC metadata is parsed from the APP13 marker.' ||
'        For the TIFF file format, IPTC metadata is parsed from tag 33723.' ||
'' ||
'        All tags with string values are decoded using the ISO-8859-1 character' ||
'        set. The resulting strings may contain characters that are legal in the' ||
'        character set but are illegal in XML documents. Illegal XML characters' ||
'        are replaced with the space (0x20) character.' ||
'' ||
'      Supported datasets' ||
'        The following datasets from the application record are extracted.' ||
'       ' ||
'          2:00  recordVersion' ||
'          2:05  objectName' ||
'          2:07  editStatus' ||
'          2:10  urgency' ||
'          2:15  category' ||
'          2:20  supplementalCategory' ||
'          2:22  fixtureIdentifer' ||
'          2:25  keyword' ||
'          2:26  contentLocation:code' ||
'          2:27  contentLocation:name' ||
'          2:40  instructions' ||
'          2:55  dateCreated' ||
'          2:60  timeCreated' ||
'          2:62  digitalCreationDate' ||
'          2:63  digitalCreationTime' ||
'          2:80  byline:author' ||
'          2:85  byline:authorTitle' ||
'          2:90  city' ||
'          2:92  subLocation' ||
'          2:95  provinceState' ||
'          2:100 country' ||
'          2:101 location' ||
'          2:103 transmissionReference' ||
'          2:105 headline' ||
'          2:110 credit' ||
'          2:115 source' ||
'          2:116 copyright' ||
'          2:118 contact' ||
'          2:120 caption' ||
'          2:122 captionWriter' ||
'          2:135 languageId' ||
'      ' ||
'      Structure' ||
'        The schema defines a number of types, both simple and complex,' ||
'        to represent some of the IPTC tags. The itpcMetadataType is defined ' ||
'        as a sequence of all the supported IPTC tags. This type is used to define' ||
'        a single global element that can appear in an instance document.' ||
'' ||
'    </xsd:documentation>' ||
'  </xsd:annotation>' ||
'' ||
'  <!-- Basic type definitions  -->' ||
'  <xsd:simpleType name="urgencyType">' ||
'    <xsd:restriction base="xsd:positiveInteger">' ||
'      <xsd:minExclusive value="1"/>' ||
'      <xsd:maxInclusive value="8"/>' ||
'    </xsd:restriction>' ||
'  </xsd:simpleType>' ||
'  <xsd:complexType name="locationType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="code" type="xsd:string"/>' ||
'      <xsd:element name="name" type="xsd:string"/>' ||
'    </xsd:sequence>' ||
'  </xsd:complexType>' ||
'  <xsd:complexType name="bylineType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="author" type="xsd:string"/>' ||
'      <xsd:element name="authorTitle" minOccurs="0" type="xsd:string"/>' ||
'    </xsd:sequence>' ||
'  </xsd:complexType>' ||
'' ||
'  <!-- Type definition for the global element  -->' ||
'  <xsd:complexType name="iptcMetadataType">' ||
'    <xsd:sequence>' ||
'      <xsd:element name="recordVersion" minOccurs="0" type="xsd:integer"/>' ||
'      <xsd:element name="objectName" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="editStatus" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="urgency" minOccurs="0" type="urgencyType"/>' ||
'      <xsd:element name="category" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="supplementalCategory" minOccurs="0" maxOccurs="unbounded" type="xsd:string"/>' ||
'      <xsd:element name="fixtureIdentifier" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="keyword" minOccurs="0" maxOccurs="unbounded" type="xsd:string"/>' ||
'      <xsd:element name="contentLocation" minOccurs="0" maxOccurs="unbounded" type="locationType"/>' ||
'      <xsd:element name="instructions" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="dateCreated" minOccurs="0" type="xsd:date"/>' ||
'      <xsd:element name="timeCreated" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="digitalCreationDate" minOccurs="0"   type="xsd:date"/>' ||
'      <xsd:element name="digitalCreationTime" minOccurs="0"  type="xsd:string"/>' ||
'      <xsd:element name="byline" minOccurs="0" maxOccurs="unbounded" type="bylineType"/>' ||
'      <xsd:element name="city" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="subLocation" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="provinceState" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="country" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="location" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="transmissionReference" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="headline" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="credit" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="source" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="copyright" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="contact" minOccurs="0" maxOccurs="unbounded" type="xsd:string"/>' ||
'      <xsd:element name="caption" minOccurs="0" type="xsd:string"/>' ||
'      <xsd:element name="captionWriter" minOccurs="0" maxOccurs="unbounded" type="xsd:string"/>' ||
'      <xsd:element name="languageId" minOccurs="0" type="xsd:string"/>' ||
'    </xsd:sequence>' ||
'  </xsd:complexType>' ||
'' ||
'  <!-- The gobal element -->' ||
'  <xsd:element name="iptcMetadata" type="iptcMetadataType"/>' ||
'' ||
'</xsd:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/meta/iptc',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordxmp.xsd with XDB under http://xmlns.oracle.com/ord/meta/xmp
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2004, 2007, Oracle. All rights reserved.  -->' ||
'<xsd:schema xmlns="http://xmlns.oracle.com/ord/meta/xmp" ' ||
'     xmlns:xsd="http://www.w3.org/2001/XMLSchema" ' ||
'     xmlns:xdb="http://xmlns.oracle.com/xdb"' ||
'     targetNamespace="http://xmlns.oracle.com/ord/meta/xmp" ' ||
'     elementFormDefault="qualified"  ' ||
'     attributeFormDefault="unqualified">' ||
'' ||
'  <xsd:annotation>' ||
'    <xsd:documentation>' ||
'      Change History' ||
'        rabbott    1/25/2005      -- Add more comments' ||
'        rabbott    6/10/2004      -- Created' ||
'    ' ||
'      Introduction' ||
'       This is the Oracle Multimedia schema for metadata embedded in XMP packets.' ||
'        The schema provides for a single element from the RDF namespace.' ||
'        As defined in the January 2004 version of the XMP specification, ' ||
'        this element should be an rdf:RDF element. ' ||
'        XMP is defined by Adobe Systems Incorporated. For more information' ||
'        about XMP, see the XMP Specification at the Adobe website.' ||
'    </xsd:documentation>' ||
'  </xsd:annotation>' ||
'' ||
'  <xsd:complexType name="xmpMetadataType" mixed="false">' ||
'    <xsd:sequence>' ||
'      <xsd:any namespace="http://www.w3.org/1999/02/22-rdf-syntax-ns#"' ||
'           xdb:SQLType="CLOB"' ||
'           processContents="skip" minOccurs="1" maxOccurs="1"/>' ||
'    </xsd:sequence>' ||
'  </xsd:complexType>' ||
'  <xsd:element name="xmpMetadata" type="xmpMetadataType"/>' ||
'</xsd:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/meta/xmp',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcman.xsd with XDB under http://xmlns.oracle.com/ord/dicom/anonymity_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'' ||
'   NAME' ||
'     ordcman.xsd - XML schema for DICOM anonymity documents' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   myalavar    06/06/07 - review comments' ||
'   myalavar    04/10/07 - copyright ' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        04/03/05 - Created' ||
'' ||
'-->' ||
'' ||
'<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="http://xmlns.oracle.com/ord/dicom/anonymity_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" targetNamespace="http://xmlns.oracle.com/ord/dicom/anonymity_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/>' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'     Introduction ' ||
'      This schema defines the DICOM anonymity document.' ||
'      ' ||
'       Structure Overview' ||
'        Question mark "?" means optional items.' ||
'        Plus "+" means one or more items.' ||
'        Asterisk "*" means zero or more items.' ||
'        ' ||
'        ANONYMITY_RULE_DOCUMENT' ||
'        DOCUMENT_HEADER?' ||
'         DOCUMENT_CHANGE_LOG*' ||
'          DOCUMENT_MODIFIER' ||
'          DOCUMENT_MODIFICATION_DATE' ||
'          DOCUMENT_VERSION?' ||
'          MODIFICATION_COMMENT?' ||
'          BASE_DOCUMENT?' ||
'          BASE_DOCUMENT_RELEASE_DATE?' ||
'          BASE_DOCUMENT_DESCRIPTION?' ||
'       PRIVATE_ATTRIBUTES' ||
'       UNDEFINED_STANDARD_ATTRIBUTES' ||
'       UNDEFINED_PRIVATE_ATTRIBUTES' ||
'       INDIVIDUAL_ATTRIBUTE*' ||
'       ' ||
'       The preceding element values specify the actions required to make ' ||
'       a DICOM attribute, or a selected group of DICOM attributes, ' ||
'       anonymous.' ||
'       ' ||
'      </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="ANONYMITY_RULE_DOCUMENT">' ||
'    <xs:complexType>' ||
'      <xs:sequence>' ||
'        <xs:element name="DOCUMENT_HEADER" type="dt:DOCUMENT_HEADER_T" nillable="true" minOccurs="0"/>' ||
'        <xs:element name="PRIVATE_ATTRIBUTES" type="ANONYM_G_T">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'              Specify the action required to make all private ' ||
'              attributes anonymous.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'        </xs:element>' ||
'        <xs:element name="UNDEFINED_STANDARD_ATTRIBUTES" type="ANONYM_G_T">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'            Specify the action required to make all undefined ' ||
'            standard attributes anonymous. Undefined standard ' ||
'            attributes are not defined by the standard data dictionaries' ||
'            when makeAnonymous or isAnonymous functions are invoked.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'        </xs:element>' ||
'        <xs:element name="UNDEFINED_PRIVATE_ATTRIBUTES" type="ANONYM_G_T">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'              Specify the action required to make all undefined private ' ||
'              attributes anonymous. Undefined private attributes are ' ||
'              not defined by the private data dictionaries when ' ||
'              makeAnonymous or isAnonymous functions are invoked. ' ||
'              This element takes priority over the previous ' ||
'              element PRIVATE_ATTRIBUTES.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'        </xs:element>' ||
'        <xs:element name="INDIVIDUAL_ATTRIBUTE" minOccurs="0" maxOccurs="unbounded">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'              Specify the action required to make an attribute anonymous.' ||
'              This element overwrites the group specifications' ||
'              specified in the preceding elements.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'          <xs:complexType>' ||
'            <xs:sequence>' ||
'              <xs:element name="ATTRIBUTE_TAG" type="dt:VALUE_LOCATOR_T"/>' ||
'              <xs:element name="DESCRIPTION" type="dt:SHORT_TEXT_T" minOccurs="0"/>' ||
'              <xs:element name="ANONYMITY_ACTION" type="ANONYM_T" nillable="true"/>' ||
'            </xs:sequence>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'    </xs:complexType>' ||
'  </xs:element>' ||
'  <xs:complexType name="ANONYM_T">' ||
'    <xs:simpleContent>' ||
'      <xs:annotation>' ||
'        <xs:documentation>' ||
'          The anonymity action type has an attribute action, ' ||
'          which defines the action used to make an' ||
'          attribute anonymous.' ||
'          If the value of the action attribute is "none", no' ||
'          action will be taken.' ||
'          If the value of the action attribute is "remove", then ' ||
'          the element does not require a value.(The default value' ||
'          of the action attribute is "remove").' ||
'          The selected candidate attribute will be removed from ' ||
'          the DICOM object to make it anonymous.' ||
'          If the value of the action attribute is "replace", then ' ||
'          the string value encoded in the attribute will be cast ' ||
'          into the corresponding type of the attribute and the' ||
'          new value replaces the original.' ||
'          If the value of the action attribute is "empty" , then the' ||
'          attribute will be changed into zero length attribute (for future' ||
'          use only).' ||
'          If the value of the action attribute is "encrypt", then the string ' ||
'          value encoded in the action attribute will be replaced with an' ||
'          encrypted value (for future use only).' ||
'        </xs:documentation>' ||
'      </xs:annotation>' ||
'      <xs:extension base="dt:SHORT_STRING_T">' ||
'        <xs:attribute name="action" default="remove">' ||
'          <xs:simpleType>' ||
'            <xs:restriction base="xs:token">' ||
'              <xs:enumeration value="none"/>' ||
'              <xs:enumeration value="remove"/>' ||
'              <xs:enumeration value="replace"/>' ||
'              <xs:enumeration value="empty"/>' ||
'              <xs:enumeration value="encrypt"/>' ||
'            </xs:restriction>' ||
'          </xs:simpleType>' ||
'        </xs:attribute>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ANONYM_G_T">' ||
'    <xs:simpleContent>' ||
'      <xs:annotation>' ||
'        <xs:documentation>' ||
'          The anonymity action type for a group attribute is similar to' ||
'          ANONYM_T except that it does not allow "replace" action.' ||
'        </xs:documentation>' ||
'      </xs:annotation>' ||
'      <xs:extension base="dt:SHORT_STRING_T">' ||
'        <xs:attribute name="action" default="remove">' ||
'          <xs:simpleType>' ||
'            <xs:restriction base="xs:token">' ||
'              <xs:enumeration value="none"/>' ||
'              <xs:enumeration value="remove"/>' ||
'              <xs:enumeration value="empty"/>' ||
'              <xs:enumeration value="encrypt"/>' ||
'            </xs:restriction>' ||
'          </xs:simpleType>' ||
'        </xs:attribute>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/anonymity_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmct.xsd with XDB under http://xmlns.oracle.com/ord/dicom/constraint_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'' ||
'<!--' ||
' Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'' ||
'   NAME' ||
'     ordcmct.xsd - XML schema for DICOM constraint documents' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dolin       06/06/07 - doc editor comments' ||
'   myalavar    04/10/07 - doc comments' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dolin       04/03/07 - associate action with predicate instead of predicate' ||
'                          set, bug5949967' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'-->' ||
'<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="http://xmlns.oracle.com/ord/dicom/constraint_1_0" xmlns:ct="http://xmlns.oracle.com/ord/dicom/constraint_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" targetNamespace="http://xmlns.oracle.com/ord/dicom/constraint_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/>' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'' ||
'    Introduction' ||
'      This schema defines the DICOM constraint document.' ||
'      ' ||
'      A DICOM constraint document defines rules ' ||
'      to check the conformance of a DICOM content with respect to ' ||
'      the DICOM standard and other organization-wide guidelines.  ' ||
'      This XML schema document defines the XML schema constraining ' ||
'      constraint documents.' ||
'      ' ||
'      A constraint document defines one or more constraint rules.  ' ||
'      A constraint rule is the unit of invocation for conformance checking.' ||
'      At run time, a user may invoke a PL/SQL' ||
'      or Java function to check the conformance of a DICOM content' ||
'      with respect to a particular rule. Each invocable rule' ||
'      is defined as a GLOBAL_RULE, which can reference other global ' ||
'      rules internally.  ' ||
'      A constraint rule can be decomposed into individual predicates.  ' ||
'      A predicate can be a logical statement, a relational statement ' ||
'      comparing values, a function call evaluation that returns a' ||
'      Boolean type, or a reference to other predicate definitions.   ' ||
'      Predicate definitions are recursive. A predicate can be a logical' ||
'      statement, which includes the logical OR of two other predicates. ' ||
'      Each predicate can be a relational predicate. For example:' ||
'      (patientName=="Joe Smith"  AND patientSex=="M")' ||
'      After being translated into a predicate, the preceding example becomes:     ' ||
'      <PREDICATE>' ||
'        <DESCRIPTION>An example to find an object that has' ||
'              (patientName="Joe Smith" AND patientSex=="M")' ||
'         </DESCRIPTION>' ||
'        <LOGICAL operator="and">' ||
'          <PREDICATE>' ||
'            <RELATIONAL operator="eq">' ||
'              <DICOM_ATTRIBUTE>00100010</DICOM_ATTRIBUTE>' ||
'              <XML_VALUE>' ||
'                <dt:PERSON_NAME>' ||
'                  <dt:NAME>' ||
'                    <dt:FAMILY>Smith</dt:FAMILY>' ||
'                    <dt:GIVEN>Joe</dt:GIVEN>' ||
'                  </dt:NAME>' ||
'                </dt:PERSON_NAME>' ||
'              </XML_VALUE>' ||
'            </RELATIONAL>' ||
'          </PREDICATE>' ||
'          <PREDICATE>' ||
'            <RELATIONAL operator="eq">' ||
'              <DICOM_ATTRIBUTE>00100040</DICOM_ATTRIBUTE>' ||
'              <XML_VALUE>' ||
'                <dt:CODE_STRING>M</dt:CODE_STRING>' ||
'              </XML_VALUE>' ||
'            </RELATIONAL>' ||
'          </PREDICATE>' ||
'        </LOGICAL>' ||
'      </PREDICATE>' ||
' ' ||
'      Constraint macros can be used to simplify the definition of ' ||
'      complex constraint rules. Constraint macros follow the same predicate ' ||
'      definition grammar as constraint rules. The operands in ' ||
'      constraint macros can be variables rather than fixed values, as they are ' ||
'      in constraint rules. The variables in a macro are substituted when the ' ||
'      macro is invoked. For example, you can define a macro to compare' ||
'      patient names ( patientName == $NAME ). When this macro is invoked,' ||
'      the parameter NAME is assigned the value "Joe Smith" and the macro is' ||
'      transformed into the predicate:( patientName == "Joe Smith").' ||
'      As another example, you can define a macro to check if a DICOM attribute' ||
'      is a code sequence attribute. A code sequence attribute must contain the' ||
'      mandatory child attributes, code value and code scheme. This macro' ||
'      checks whether the specified code sequence attribute contains these' ||
'      mandatory child attributes. ' ||
'' ||
'' ||
'      <GLOBAL_MACRO name="CSMacro">' ||
'        <DESCRIPTION>' ||
'          A subset of Code Sequence Macro defined in DICOM standard, ' ||
'          PS3.3-2007, Table 8.8-1' ||
'        </DESCRIPTION>' ||
'        <PARAMETER_DECLARATION>' ||
'          CodeAttr' ||
'        </PARAMETER_DECLARATION>' ||
'        <PREDICATE>' ||
'          <DESCRIPTION>Code value must not be empty</DESCRIPTION>' ||
'          <BOOLEAN_FUNC operator="notEmpty">' ||
'            <DICOM_ATTRIBUTE>${CodeAttr}.00080100' ||
'            </DICOM_ATTRIBUTE>' ||
'          </BOOLEAN_FUNC>' ||
'        </PREDICATE>' ||
'        <PREDICATE>' ||
'          <DESCRIPTION>Code scheme designator must not be empty' ||
'          </DESCRIPTION>' ||
'          <BOOLEAN_FUNC operator="notEmpty">' ||
'            <DICOM_ATTRIBUTE>${CodeAttr}.00080102' ||
'            </DICOM_ATTRIBUTE>' ||
'          </BOOLEAN_FUNC>' ||
'        </PREDICATE>' ||
'        <!-- other predicates follow -->' ||
'      </GLOBAL_MACRO>' ||
'       ' ||
'      You can separate a constraint definition into multiple files.  ' ||
'      Each file defines one or more constraint rules or macros.  ' ||
'      A file can import the macros and constraint rules that are ' ||
'      defined in a difference file. You must specify the set of ' ||
'      external rules or macros before referencing them in a file.' ||
'      EXTERNAL_RULE_INCLUDE and EXTERNAL_MACRO_INCLUDE' ||
'      statements serve this purpose.' ||
'      ' ||
'     Structure Overview' ||
'      Question mark "?" means optional items.' ||
'      Plus "+" means one or more items.' ||
'      Asterisk "*" means zero or more items.' ||
'' ||
'      ' ||
'    CONFORMANCE_CONSTRAINT_DEFINITION' ||
'      DOCUMENT_HEADER?' ||
'        DOCUMENT_CHANGE_LOG+' ||
'          DOCUMENT_MODIFIER' ||
'          DOCUMENT_MODIFICATION_DATE' ||
'          DOCUMENT_VERSION?' ||
'          MODIFICATION_COMMENT?' ||
'          BASE_DOCUMENT?' ||
'          BASE_DOCUMENT_RELEASE_DATE?' ||
'          BASE_DOCUMENT_DESCRIPTION?' ||
'    EXTERNAL_MACRO_INCLUDE*' ||
'    EXTERNAL_RULE_INCLUDE*' ||
'    (GLOBAL_MACRO|GLOBAL_RULE)+' ||
'    ' ||
'    GLOBAL_RULE (name) | PREDICATE_DEFINITION (name)' ||
'      DESCRIPTION?' ||
'      PREDICATE_DEFINITION*' ||
'      PREDICATE+' ||
'      ACTION (when, action)*' ||
'        ' ||
'    GLOBAL_MACRO (name)' ||
'      DESCRIPTION?' ||
'      PARAMETER_DECLARATION+' ||
'      PREDICATE_DEFINITION*' ||
'      PREDICATE+' ||
'      ACTION (when, action)*' ||
'      ' ||
'    PREDICATE' ||
'      DESCRIPTION?' ||
'      (LOGICAL|RELATIONAL|BOOLEAN_FUNC|INVOKE_MACRO|PREDICATE_REF|GLOBAL_RULE_REF)' ||
'      ACTION (when, action)*' ||
'      ' ||
'    LOGICAL(operator)' ||
'      PREDICATE+' ||
'' ||
'    RELATIONAL(operator)' ||
'      (ATTRIBUTE_TAG|FUNCTION)(ATTRIBUTE_TAG|STRING_VALUE|XML_VALUE|FUNCTION)+' ||
'' ||
'    BOOLEAN_FUNC(operator)' ||
'      (ATTRIBUTE_TAG|STRING_VALUE|XML_VALUE|FUNCTION)*' ||
'' ||
'    INVOKE_MACRO' ||
'      MACRO_NAME' ||
'      PARAMETER+' ||
'        NAME' ||
'        VALUE' ||
'' ||
'    FUNCTION(operator)' ||
'      (ATTRIBUTE_TAG|STRING_VALUE|XML_VALUE|FUNCTION)*' ||
'' ||
'    </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="CONFORMANCE_CONSTRAINT_DEFINITION">' ||
'    <xs:annotation>' ||
'      <xs:documentation>A constraint document defines groups of predicates to validate the conformance of a DICOM content or a DICOM metadata document.</xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:complexType>' ||
'      <xs:sequence>' ||
'        <xs:element name="DOCUMENT_HEADER" type="dt:DOCUMENT_HEADER_T" minOccurs="0"/>' ||
'        <xs:element name="EXTERNAL_MACRO_INCLUDE" minOccurs="0" maxOccurs="unbounded">' ||
'          <xs:complexType>' ||
'            <xs:simpleContent>' ||
'              <xs:extension base="dt:SHORT_TEXT_T">' ||
'                <xs:attribute name="name" type="dt:SHORT_ID_T" use="required"/>' ||
'              </xs:extension>' ||
'            </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <xs:element name="EXTERNAL_RULE_INCLUDE" minOccurs="0" maxOccurs="unbounded">' ||
'          <xs:complexType>' ||
'            <xs:simpleContent>' ||
'              <xs:extension base="dt:SHORT_TEXT_T">' ||
'                <xs:attribute name="name" type="dt:SHORT_ID_T" use="required"/>' ||
'              </xs:extension>' ||
'            </xs:simpleContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'        <xs:choice maxOccurs="unbounded">' ||
'          <xs:element name="GLOBAL_MACRO" type="PREDICATE_MACRO_T">' ||
'            <xs:key name="LOCAL_PRED_KEY1">' ||
'              <xs:selector xpath="ct:PREDICATES_DEFINITION"/>' ||
'              <xs:field xpath="@name"/>' ||
'            </xs:key>' ||
'            <xs:keyref name="LOCAL_PREDICATE_REF1" refer="ct:LOCAL_PRED_KEY1">' ||
'              <xs:selector xpath=".//ct:LOGICAL"/>' ||
'              <xs:field xpath=".//ct:PREDICATE_REF"/>' ||
'            </xs:keyref>' ||
'          </xs:element>' ||
'          <xs:element name="GLOBAL_RULE" type="PREDICATE_GROUP_T">' ||
'            <xs:key name="LOCAL_PRED_KEY2">' ||
'              <xs:selector xpath="ct:PREDICATES_DEFINITION"/>' ||
'              <xs:field xpath="@name"/>' ||
'            </xs:key>' ||
'            <xs:keyref name="LOCAL_PREDICATE_REF2" refer="ct:LOCAL_PRED_KEY2">' ||
'              <xs:selector xpath=".//ct:LOGICAL"/>' ||
'              <xs:field xpath=".//ct:PREDICATE_REF"/>' ||
'            </xs:keyref>' ||
'          </xs:element>' ||
'        </xs:choice>' ||
'      </xs:sequence>' ||
'    </xs:complexType>' ||
'    <!-- predicate group defined under the root element is global -->' ||
'    <xs:key name="GLOBAL_PRED1">' ||
'      <xs:selector xpath="ct:GLOBAL_RULE|ct:EXTERNAL_RULE_INCLUDE"/>' ||
'      <xs:field xpath="@name"/>' ||
'    </xs:key>' ||
'    <xs:keyref name="PREDICATE_REF1" refer="ct:GLOBAL_PRED1">' ||
'      <xs:selector xpath=".//ct:LOGICAL"/>' ||
'      <xs:field xpath="ct:GLOBAL_RULE_REF"/>' ||
'    </xs:keyref>' ||
'    <xs:key name="GLOBAL_MACRO1">' ||
'      <xs:selector xpath="ct:GLOBAL_MACRO|ct:EXTERNAL_MACRO_INCLUDE"/>' ||
'      <xs:field xpath="@name"/>' ||
'    </xs:key>' ||
'    <xs:keyref name="MACRO_USE1" refer="ct:GLOBAL_MACRO1">' ||
'      <xs:selector xpath=".//ct:INVOKE_MACRO"/>' ||
'      <xs:field xpath="ct:MACRONAME"/>' ||
'    </xs:keyref>' ||
'  </xs:element>' ||
'  <xs:complexType name="PREDICATE_GROUP_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>A predicate group is the logical AND ' ||
'      of a collection of predicates or predicate groups. ' ||
'      Each predicate group has a name that is unique within ' ||
'      its parent. Any other predicates can reference' ||
'      this predicate group by its name. The value of the reference ' ||
'      is the Boolean of the predicate group.' ||
'      Optionally, a predicate group can contain a set of ' ||
'      predicate definitions. These definitions are not part of the' ||
'      logical AND component of the predicate group, but they' ||
'      are meant to be referenced within the predicate group.' ||
'      A predicate group has an optional action element that' ||
'      specifies what action to take when the predicate evaluates to true' ||
'      or false.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="DESCRIPTION" type="dt:SHORT_TEXT_T" minOccurs="0"/>' ||
'      <xs:element name="PREDICATES_DEFINITION" type="PREDICATE_GROUP_T" minOccurs="0" maxOccurs="unbounded"/>' ||
'      <xs:choice maxOccurs="unbounded">' ||
'        <xs:element name="PREDICATE" type="PREDICATE_T"/>' ||
'      </xs:choice>' ||
'      <xs:element name="ACTION" type="ACTION_T" nillable="true" minOccurs="0" maxOccurs="unbounded"/>' ||
'    </xs:sequence>' ||
'    <xs:attribute name="name" type="dt:SHORT_ID_T"/>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="PREDICATE_MACRO_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:sequence>' ||
'      <xs:element name="DESCRIPTION" type="dt:SHORT_TEXT_T" minOccurs="0"/>' ||
'      <xs:element name="PARAMETER_DECLARATION" type="dt:SHORT_NAME_T" nillable="false" maxOccurs="unbounded"/>' ||
'      <xs:element name="PREDICATES_DEFINITION" type="PREDICATE_GROUP_T" minOccurs="0" maxOccurs="unbounded"/>' ||
'      <xs:choice maxOccurs="unbounded">' ||
'        <xs:element name="PREDICATE" type="PREDICATE_T"/>' ||
'      </xs:choice>' ||
'      <xs:element name="ACTION" type="ACTION_T" nillable="true" minOccurs="0" maxOccurs="unbounded"/>' ||
'    </xs:sequence>' ||
'    <xs:attribute name="name" type="dt:SHORT_ID_T"/>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="ACTION_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        A type to specify an action for a predicate value.' ||
'        The "when" attribute specifies the predicate value.' ||
'        The "action" attribute specifies the type of action.' ||
'        When the action type is "log", "warning", or "error",' ||
'        the string value of this attribute is returned' ||
'        in a log file or as part of warning or error message.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:simpleContent>' ||
'      <xs:extension base="dt:SHORT_TEXT_T">' ||
'        <xs:attribute name="when" type="xs:boolean" use="required"/>' ||
'        <xs:attribute name="action" type="ACTION_LIST_T" use="required"/>' ||
'      </xs:extension>' ||
'    </xs:simpleContent>' ||
'  </xs:complexType>' ||
'  <xs:simpleType name="ACTION_LIST_T">' ||
'    <xs:restriction base="xs:token">' ||
'      <xs:enumeration value="none"/>' ||
'      <xs:enumeration value="log"/>' ||
'      <xs:enumeration value="warning"/>' ||
'      <xs:enumeration value="error"/>' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
'  <xs:complexType name="PREDICATE_T">' ||
'    <xs:sequence>' ||
'      <xs:element name="DESCRIPTION" type="dt:SHORT_TEXT_T" minOccurs="0"/>' ||
'      <xs:choice>' ||
'        <xs:element name="LOGICAL" type="LOGICAL_PREDICATE_T"/>' ||
'        <xs:element name="RELATIONAL" type="RELATIONAL_PREDICATE_T"/>' ||
'        <xs:element name="BOOLEAN_FUNC" type="BOOLEAN_FUNC_PREDICATE_T"/>' ||
'        <xs:element name="INVOKE_MACRO" type="MACRO_USE_T"/>' ||
'        <xs:element name="PREDICATE_REF" type="xs:IDREF"/>' ||
'        <xs:element name="GLOBAL_RULE_REF" type="xs:IDREF"/>' ||
'      </xs:choice>' ||
'      <xs:element name="ACTION" type="ACTION_T" nillable="true" minOccurs="0" maxOccurs="unbounded"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="MACRO_USE_T">' ||
'    <xs:sequence>' ||
'      <xs:element name="MACRO_NAME" type="xs:IDREF"/>' ||
'      <xs:element name="PARAMETER" maxOccurs="unbounded">' ||
'        <xs:complexType>' ||
'          <xs:sequence maxOccurs="unbounded">' ||
'            <xs:element name="NAME" type="dt:SHORT_STRING_T" nillable="false"/>' ||
'            <xs:element name="VALUE" type="dt:SHORT_TEXT_T"/>' ||
'          </xs:sequence>' ||
'        </xs:complexType>' ||
'      </xs:element>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="LOGICAL_PREDICATE_T">' ||
'    <xs:sequence maxOccurs="unbounded">' ||
'      <!--Boolean type, static  inline predicate definition -->' ||
'      <xs:element name="PREDICATE" type="PREDICATE_T"/>' ||
'    </xs:sequence>' ||
'    <xs:attribute name="operator" use="required">' ||
'      <xs:simpleType>' ||
'        <xs:restriction base="xs:token">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'              A derive B   ( (NOT A)  OR B )' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'          <xs:enumeration value="and"/>' ||
'          <xs:enumeration value="or"/>' ||
'          <xs:enumeration value="derive"/>' ||
'          <xs:enumeration value="not"/>' ||
'          <xs:enumeration value="xor"/>' ||
'        </xs:restriction>' ||
'      </xs:simpleType>' ||
'    </xs:attribute>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="RELATIONAL_PREDICATE_T">' ||
'    <xs:sequence>' ||
'      <xs:choice>' ||
'        <xs:element name="ATTRIBUTE_TAG" type="dt:VALUE_LOCATOR_MACRO_T"/>' ||
'        <xs:element name="FUNCTION" type="FUNCTION_T"/>' ||
'      </xs:choice>' ||
'      <xs:choice maxOccurs="unbounded">' ||
'        <xs:element name="ATTRIBUTE_TAG" type="dt:VALUE_LOCATOR_MACRO_T"/>' ||
'        <xs:element name="STRING_VALUE" type="dt:MIXED_TEXT_T"/>' ||
'        <xs:element name="XML_VALUE" type="dt:ATTR_VALUE_T"/>' ||
'        <xs:element name="FUNCTION" type="FUNCTION_T"/>' ||
'      </xs:choice>' ||
'    </xs:sequence>' ||
'    <xs:attribute name="operator" use="required">' ||
'      <xs:simpleType>' ||
'        <xs:restriction base="xs:token">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'            gt     greater than' ||
'            ge     greater than or equal to' ||
'            lt     less than' ||
'            le     less than or equal to' ||
'            eq     equal to' ||
'            ne     not equal to' ||
'            in     value in the set of' ||
'            match  attribute value matches pattern' ||
'              The second operand must be a Java regular expression ' ||
'              pattern as specified by JDK1.5 java.lang.String class ' ||
'              documentation. The first operator should be a DICOM ' ||
'              attribute tag. The tag should identify an attribute' ||
'              that belongs to one of the following value representation ' ||
'              types:' ||
'                 AE, AS, AT, CS, DA, DT, LO, LT, PN,' ||
'                 SH, ST, TM, UI and UT' ||
'            Note that the operands must be compatible with each other ' ||
'            when a predicate invokes relational operator. For example, ' ||
'            (patientAge > 005M) is a valid predicate. But ' ||
'            (patientAge > "Joe Smith") is not a valid predicate, because ' ||
'            the operand "Joe Smith" cannot be cast into an instance ' ||
'            of the patient age attribute.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'          <xs:enumeration value="gt"/>' ||
'          <xs:enumeration value="ge"/>' ||
'          <xs:enumeration value="lt"/>' ||
'          <xs:enumeration value="le"/>' ||
'          <xs:enumeration value="eq"/>' ||
'          <xs:enumeration value="ne"/>' ||
'          <xs:enumeration value="in"/>' ||
'          <xs:enumeration value="match"/>' ||
'        </xs:restriction>' ||
'      </xs:simpleType>' ||
'    </xs:attribute>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="BOOLEAN_FUNC_PREDICATE_T">' ||
'    <xs:choice maxOccurs="unbounded" minOccurs="0">' ||
'      <xs:element name="ATTRIBUTE_TAG" type="dt:VALUE_LOCATOR_MACRO_T"/>' ||
'      <xs:element name="STRING_VALUE" type="dt:MIXED_TEXT_T"/>' ||
'      <xs:element name="XML_VALUE" type="dt:ATTR_VALUE_T"/>' ||
'      <xs:element name="FUNCTION" type="FUNCTION_T"/>' ||
'    </xs:choice>' ||
'    <xs:attribute name="operator" use="required">' ||
'      <xs:annotation>' ||
'        <xs:documentation>' ||
'          To allow future extensions, the set of allowed operators for Boolean ' ||
'          function types are not fixed. Operator names are case-sensitive.' ||
'          The current values for this operator ' ||
'          are: "notEmpty", "occurs", "true", and "false". ' ||
'          "occurs" takes a single operand ATTRIBUTE_TAG, ' ||
'          and returns true if an attribute matching the tag exists. (The ' ||
'          attribute value can be an empty string or null. For example, ' ||
'          a DICOM type 2 attribute may be empty.); Otherwise, it returns' ||
'          false.' ||
'          "notEmpty" takes a single operand ATTRIBUTE_TAG. ' ||
'          It returns true if an attribute matching the tag exists in ' ||
'          a DICOM content and has a non-null value (e.g. a DICOM type 1 ' ||
'          attribute); otherwise, it returns false.' ||
'          "true" takes no operand and it always returns true.' ||
'          "false" takes no operand and it always returns false.' ||
'        </xs:documentation>' ||
'      </xs:annotation>' ||
'      <xs:simpleType>' ||
'        <xs:restriction base="xs:token">' ||
'          <xs:maxLength value="64"/>' ||
'        </xs:restriction>' ||
'      </xs:simpleType>' ||
'    </xs:attribute>' ||
'  </xs:complexType>' ||
'  <xs:complexType name="FUNCTION_T">' ||
'    <xs:choice minOccurs="0" maxOccurs="unbounded">' ||
'      <xs:element name="ATTRIBUTE_TAG" type="dt:VALUE_LOCATOR_MACRO_T"/>' ||
'      <xs:element name="STRING_VALUE" type="dt:MIXED_TEXT_T"/>' ||
'      <xs:element name="XML_VALUE" type="dt:ATTR_VALUE_T"/>' ||
'      <xs:element name="FUNCTION" type="FUNCTION_T"/>' ||
'    </xs:choice>' ||
'    <xs:attribute name="operator" use="required">' ||
'      <xs:annotation>' ||
'        <xs:documentation>' ||
'          To allow future extensions, the set of allowed operators for ' ||
'          function types are not fixed. Operator names are case-sensitive.' ||
'          This feature is not supported for Oracle Database 11g Release 1.' ||
'        </xs:documentation>' ||
'      </xs:annotation>' ||
'      <xs:simpleType>' ||
'        <xs:restriction base="xs:token">' ||
'          <xs:maxLength value="64"/>' ||
'        </xs:restriction>' ||
'      </xs:simpleType>' ||
'    </xs:attribute>' ||
'  </xs:complexType>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/constraint_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmmd.xsd with XDB under http://xmlns.oracle.com/ord/dicom/metadata_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'' ||
'   NAME' ||
'     ordcmmd.xsd - XML schema for default DICOM metadata documents' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   myalavar    04/10/07 - copyright' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'-->' ||
'' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/dicom/metadata_1_0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:dt="http://xmlns.oracle.com/ord/dicom/metadata_1_0" targetNamespace="http://xmlns.oracle.com/ord/dicom/metadata_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:include schemaLocation="http://xmlns.oracle.com/ord/dicom/mddatatype_1_0"/>' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'    Introduction' ||
'      This schema defines the default DICOM metadata schema used' ||
'      by the ORDDicom object attribute (XMLType metadata).' ||
'  </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="DICOM_OBJECT" type="dt:DATASET_T"/>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/metadata_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmmp.xsd with XDB under http://xmlns.oracle.com/ord/dicom/mapping_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'' ||
'   NAME' ||
'     ordcmmp.xsd - XML schema for DICOM mapping documents' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dolin       06/06/07 - ' ||
'   myalavar    06/06/07 - review comments' ||
'   fechen      05/08/07 - fix the comments ' ||
'   myalavar    04/10/07 - copyright' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'-->' ||
'' ||
'<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="http://xmlns.oracle.com/ord/dicom/mapping_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" targetNamespace="http://xmlns.oracle.com/ord/dicom/mapping_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/>' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'      This schema defines the DICOM (XML) mapping document.' ||
'      It defines how each DICOM attribute maps to an element of the ' ||
'      DICOM metadata document.' ||
'      ' ||
'      The mapping document is used by the metadata encoder to produce ' ||
'      a DICOM metadata document. Each DICOM attribute is identified by ' ||
'      a 4-byte hexadecimal attribute tag. Each DICOM attribute is mapped ' ||
'      to an element of the XML metadata document designated by the PATH ' ||
'      element. By default, a DICOM attribute can be null and is optional.' ||
'      ' ||
'      XML_MAPPING_DOCUMENT' ||
'        Question mark "?" means optional items.' ||
'        Plus "+" means one or more items.' ||
'        Asterisk "*" means zero or more items.' ||
'' ||
'      DOCUMENT_HEADER?' ||
'        DOCUMENT_CHANGE_LOG*' ||
'         DOCUMENT_MODIFIER' ||
'         DOCUMENT_MODIFICATION_DATE' ||
'         DOCUMENT_VERSION?' ||
'         MODIFICATION_COMMENT?' ||
'         BASE_DOCUMENT?' ||
'         BASE_DOCUMENT_RELEASE_DATE?' ||
'         BASE_DOCUMENT_DESCRIPTION?' ||
'      NAMESPACE?' ||
'      ROOT_ELEM_TAG' ||
'      UNMAPPED_ELEM' ||
'      MAPPED_ELEM' ||
'      MAPPED_PATH+ (occurs?, notEmpty?, writeTag?, writeDefiner?, writeName?, writeRawValue)' ||
'         {ATTRIBUTE_TAG(definer), PATH}+' ||
'       ' ||
'    </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="XML_MAPPING_DOCUMENT">' ||
'    <xs:complexType>' ||
'      <xs:sequence>' ||
'        <xs:element name="DOCUMENT_HEADER" type="dt:DOCUMENT_HEADER_T" minOccurs="0"/>' ||
'        <xs:element name="NAMESPACE" type="dt:SHORT_TEXT_T">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'              The namespace of the XML metadata schema on which a mapping ' ||
'              document is based. Metadata from a DICOM object can be' ||
'              mapped into an XML document constrained by this XML' ||
'              metadata schema. If the value of this element is an empty string,' ||
'              the extracted XML metadata document is not ' ||
'              associated with an XML schema.' ||
'              The order of the MAPPED_PATH elements' ||
'              MUST match the sequence of the corresponding XML ' ||
'              elements in this namespace.              ' ||
'              </xs:documentation>' ||
'          </xs:annotation>' ||
'        </xs:element>' ||
'        <xs:element name="ROOT_ELEM_TAG" type="dt:SHORT_STRING_T">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'              This element specifies the root element tag of ' ||
'              an XML metadata document.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'        </xs:element>' ||
'        <xs:element name="UNMAPPED_ELEM" type="dt:SHORT_STRING_T" nillable="true" minOccurs="0">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'            This element specifies the XML path (appended to ' ||
'            ROOT_ELEM_TAG) for unmapped attributes, that is, the set' ||
'            of DICOM attributes that are present in a DICOM object, ' ||
'            but whose mappings have not been defined by the' ||
'            MAPPED_PATH elements of an XML mapping document.' ||
'            This element is optional. If this element is omitted or empty, ' ||
'            the unmapped attributes are appended to ROOT_ELEM_TAG. ' ||
'            If an XML schema is used to constrain the metadata document,' ||
'            the XML schema element pointed to by this element should' ||
'            be of type dt:DATASET_T. See the DICOM data type definition' ||
'            schema "http://xmlns.oracle.com/ord/dicom/datatype_1_0"' ||
'            and dt:DATASET_T for more information.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'        </xs:element>' ||
'        <xs:element name="MAPPED_ELEM" type="dt:SHORT_STRING_T" nillable="true" minOccurs="0">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'            This element specifies the XML path for all mapped ' ||
'            attributes, that is,  the set of DICOM attributes that are ' ||
'            present in a DICOM object, and whose mappings' ||
'            are defined by the MAPPED_XPATH elements ' ||
'            of an XML mapping document. This element' ||
'            specifies a relative path from ROOT_ELEM_TAG.' ||
'            For example, to map a DICOM attribute (0010,0010) to' ||
'            the XML element at "/DICOM_METADATA/PATIENT/NAME",' ||
'            specify the following ' ||
'            The ROOT_ELEM_TAG element value is "DICOM_METADATA".' ||
'            The MAPPED_ELEM element value is "PATIENT" and ' ||
'            The MAPPED_PATH/PATH element value should be "NAME".' ||
'            Alternatively, ' ||
'            if the value of element MAPPED_ELEM is an empty string,' ||
'            then the value of the element MAPPED_PATH/PATH' ||
'            should be "PATIENT/NAME".' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'        </xs:element>' ||
'        <xs:element name="MAPPED_PATH" minOccurs="0" maxOccurs="unbounded">' ||
'          <xs:complexType>' ||
'            <xs:sequence>' ||
'              <xs:annotation>' ||
'                <xs:documentation>' ||
'                  A MAPPED_PATH element contains attribute tag and' ||
'                  path pairs.' ||
'                  An attribute tag uniquely identifies an attribute within the' ||
'                  data dictionary. Wildcards are not allowed in an attribute' ||
'                  tag specification in this release.' ||
'                  The path consists of slash "/"-concatenated element names.' ||
'                  A path specifies the destination of an attribute in the ' ||
'                  DICOM XML metadata document. The mapped path' ||
'                  is the relative path from ROOT_ELEM_TAG and' ||
'                  MAPPED_ELEM. The absolute path is:' ||
'                  "${ROOT_ELEM_TAG} / ${MAPPED_ELEM} / ' ||
'                  ${MAPPED_PATH}".' ||
'                  The optional attribute "occurs" specifies whether the' ||
'                  attribute must exist in the original DICOM content.' ||
'                  (The attribute tag must exist, but the attribute value' ||
'                  can be an empty string, for example, a DICOM  type 2 ' ||
'                  attribute.)' ||
'                  The optional attribute "notEmpty" specifies ' ||
'                  whether the attribute must have a value in ' ||
'                  the original DICOM content (type 1 in DICOM terms).' ||
'                  Depending on the run-time preferences, if the ' ||
'                  above "occurs'' or "notEmpty" condition is not ' ||
'                  met, an error may be thrown at run-time.' ||
'                  The optional attribute "writeTag" specifies whether to' ||
'                  add the attribute "tag" when writing the element.' ||
'                  The tag attribute is of type "dt:AT". The value of this' ||
'                  attribute is the DICOM attribute tag in little-endian ' ||
'                  encoding.' ||
'                  The optional attribute "writeDefiner" specifies whether' ||
'                  to add the attribute "definer" when writing the element.' ||
'                  The definer attribute is of type "dt:LO". The value of' ||
'                  this attribute is the same as the definer attribute of' ||
'                  ATTRIBUTE_TAG element of the mapping document.' ||
'                  The optional attribute "writeName" specifies whether' ||
'                  to add the attribute "name" when writing the element.' ||
'                  The name attribute is of type "dt:SHORT_STRING_T".' ||
'                  The value of this element is the attribute name' ||
'                  defined by the data dictionary.' ||
'                  The optional attribute "writeRawValue" specifies whether' ||
'                  to add the attribute "rawValue" when writing the element.' ||
'                  The raw value attribute is of type "xs:hexBinary".' ||
'                  This attribute only occurs when there is a parsing error' ||
'                  for this attribute and no XML value can be extracted for' ||
'                  the element. The value of this attribute is the ' ||
'                  hexadecimal dump of the original byte stream.' ||
'                </xs:documentation>' ||
'              </xs:annotation>' ||
'              <xs:element name="ATTRIBUTE_TAG" type="dt:VALUE_LOCATOR_T"/>' ||
'              <xs:element name="PATH" type="dt:SHORT_TEXT_T"/>' ||
'            </xs:sequence>' ||
'            <xs:attribute name="occurs" type="xs:boolean" default="false"/>' ||
'            <xs:attribute name="notEmpty" type="xs:boolean" default="false"/>' ||
'            <xs:attribute name="writeTag" type="xs:boolean" default="false"/>' ||
'            <xs:attribute name="writeDefiner" type="xs:boolean" default="false"/>' ||
'            <xs:attribute name="writeName" type="xs:boolean" default="false"/>' ||
'            <xs:attribute name="writeRawValue" type="xs:boolean" default="false"/>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'    </xs:complexType>' ||
'  </xs:element>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/mapping_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmpf.xsd with XDB under http://xmlns.oracle.com/ord/dicom/preference_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, 2009, Oracle and/or its affiliates.All rights reserved. ' ||
'   NAME' ||
'     ordcmpf.xsd - XML Schema for DICOM preference documents.' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dnoblet     02/09/09   - add BINARY_SKIP_INVALID_ATTR' ||
'   rabbott     12/19/08   - add SPECIFIC_CHARACTER_SET' ||
'   myalavar    11/14/08   - add param SQ_WRITE_LEN' ||
'   myalavar    11/03/08   - add PARSE_ERR to IGNORE_EXP_LIST' ||
'   myalavar    10/28/08   - add param MANDATE_ATTR_TAGS_IN_STL' ||
'   dolin       10/27/08   - add param MAX_RECURSION_DEPTH' ||
'   dolin       06/06/07   - doc editor comments' ||
'   dguo        05/18/07   - change product name' ||
'   myalavar    04/10/07   - Review comments' ||
'   dguo        03/03/2006 - Created' ||
'-->' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/dicom/preference_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" targetNamespace="http://xmlns.oracle.com/ord/dicom/preference_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/>' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'    Introduction' ||
'      This schema defines the run-time preference settings for ' ||
'      Oracle Multimedia DICOM features.' ||
'' ||
'    Structure Overview' ||
'      Question mark "?" means optional items.' ||
'      Plus "+" means one or more items.' ||
'      Asterisk "*" means zero or more items.' ||
'' ||
'      DICOM_RUNTIME_PREFERENCES' ||
'        DOCUMENT_HEADER?' ||
'          DOCUMENT_CHANGE_LOG*' ||
'              DOCUMENT_MODIFIER' ||
'              DOCUMENT_MODIFICATION_DATE' ||
'              DOCUMENT_VERSION?' ||
'              MODIFICATION_COMMENT?' ||
'              BASE_DOCUMENT?' ||
'              BASE_DOCUMENT_RELEASE_DATE?' ||
'              BASE_DOCUMENT_DESCRIPTION?' ||
'        PREFERENCE_DEF+' ||
'          PARAMETER' ||
'          DESCRIPTION' ||
'          VALUE' ||
'        The allowed values for the PARAMETER element of a ' ||
'        PREFERENCE_DEF entry and its corresponding ' ||
'        VALUE element are as follows:' ||
'        ' ||
'        PARAMETER: XML_SKIP_ATTR' ||
'        VALUE: an integer type (default 512,  128~ 32767)' ||
'        DESCRIPTION: When encoding a DICOM attribute into XML, skip ' ||
'               attributes whose (child) XML element sizes (in bytes) are ' ||
'               larger than XML_SKIP_ATTR.' ||
'               If an attribute is of simple type, this limit applies to the' ||
'               whole attribute.' ||
'               If the attribute type is SQ, this limit applies to its child ' ||
'               items.' ||
'               For example, if an attribute is of type SQ and it contains  ' ||
'               child items of type OB, the limit applies to ' ||
'               each child instance of type OB. ' ||
'               The smallest value allowed for this parameter is 128.' ||
'        ' ||
'        PARAMETER: AVG_ATTR_NUM' ||
'        VALUE: an integer type (default 200, 20~2000)' ||
'        DESCRIPTION: The average number of root-level attributes per ' ||
'        DICOM object. This is a hint to the DICOM implementation.' ||
'        Finding the optimal value for a database helps improve storage ' ||
'        efficiency and performance. Too large a value may lead to wasted' ||
'        memory, and too small a value may lead to poor performance. An' ||
'        ideal value is one where most (suggested 95%) DICOM images' ||
'        have less than $VALUE number of attributes.' ||
'        The smallest value allowed for this parameter is 20.' ||
'        The largest number allowed for this parameter is ' ||
'        the total number of not retired standard attributes defined.' ||
'        ' ||
'        PARAMETER: CONFORMANCE_LEVEL' ||
'        VALUE: enum { leastConform, ignoreException(default), mostConform}' ||
'        DESCRIPTION: ' ||
'        The option "leastConform" means that all functions try to ' ||
'        maximize the processing of a DICOM object and ignore' ||
'        any errors and exceptions.' ||
'        "ignoreException" means that all functions ignore the' ||
'        types of exceptions given in the parameter "IGNORED_EXP_LIST".' ||
'        The default set of ignored exceptions includes: MISSING_ATTR, ' ||
'        INVALID_LENGTH, MISSING_MAGIC, MISSING_HEADER, INVALID_VR, ' ||
'        INVALID_VM, and PARSE_ERR.' ||
'        "mostConform" means that all functions throw an exception' ||
'        if a DICOM object contains nonconformant content. This does' ||
'        not include backward compatibility cases allowed by ' ||
'        the DICOM standard.' ||
'        Note: By choosing an option other than "mostConform",' ||
'        you risk accepting invalid DICOM objects, possibly getting' ||
'        incorrect results. In this case, Oracle recommends setting the' ||
'        LOGGING_LEVEL parameter to "warning" or a more detailed level, ' ||
'        and then examining the log file for possible errors.' ||
'        ' ||
'        PARAMETER: IGNORED_EXP_LIST' ||
'        VALUE: EmptySpace-separated exception names from the ' ||
'        following list:' ||
'                {MISSING_MAGIC, MISSING_HEADER, MISSING_ATTR,' ||
'                FAULTY_VALUE, INVALID_LENGTH, ' ||
'                INVALID_VM, INVALID_VR, UNSUPPORT_VALUE,' ||
'                UNDEFINED_VALUE, NOT_AN_IMAGE, PARSE_ERR}' ||
'                ' ||
'        Default: {MISSING_ATTR INVALID_LENGTH MISSING_MAGIC' ||
'                 MISSING_HEADER INVALID_VR INVALID_VM PARSE_ERR}.' ||
'        DESCRIPTION: This parameter is only effective when the value of' ||
'        the CONFORMANCE_LEVEL parameter is "ignoreException". If' ||
'        this is the case, the exceptions in the ignore exception list are' ||
'        ignored at run time. However, if the LOGGING_LEVEL parameter' ||
'        is set to "warning" or a more detailed level, the exception is ' ||
'        logged. The program continues and skips the part ' ||
'        of the DICOM object that has triggered an exception.' ||
'        These exceptions are defined as follows:' ||
'        MISSING_MAGIC: a DICOM object does not contain the file ' ||
'            magic number "DICM".' ||
'        MISSING_HEADER: a DICOM object does not have the file' ||
'            meta header (not conformant to the DICOM standard part 10).' ||
'        MISSING_ATTR: a DICOM object does not have the mandatory' ||
'            attributes (type 1) required by the DICOM standard.' ||
'        FAULTY_VALUE: a DICOM object has attribute values ' ||
'            that lead to parsing errors.' ||
'        INVALID_LENGTH: a DICOM object contains a length value that ' ||
'          is not consistent with the DICOM encoding rules or a length ' ||
'          that is not permitted by the DICOM data dictionary.' ||
'        INVALID_VM: an attribute of a DICOM object has an invalid Value ' ||
'            Multiplicity value (not consistent with the dictionary definition).' ||
'        INVALID_VR: an attribute of a DICOM object has an invalid Value' ||
'            Representation value, which can either conflict with the data' ||
'            dictionary or has not been defined by the data dictionary.' ||
'        UNSUPPORTED_VALUE: a DICOM object contains attribute' ||
'            values that are outside of the supported range; ' ||
'            for example, an unsupported pixel representation value.' ||
'        UNDEFINED_VALUE: a DICOM object contains attribute' ||
'            values that are not defined by the data model; for example,' ||
'            an undefined transfer syntax UID, an undefined SOP' ||
'            class UID, and so on.' ||
'        NOT_AN_IMAGE: When an image content processing function' ||
'            is invoked on a DICOM object, if the object''s SOP class UID is' ||
'            defined but its classification is not "storageClass", or its' ||
'            content type is not "image", an exception is thrown. It may' ||
'            mean that the UID definition document is not up-to-date. An ' ||
'            administrator can update the document to define the' ||
'            SOP class UID as a "storageClass" of "image" type.' ||
'        PARSE_ERR: When a DICOM object contains invalid data, a parse exception' ||
'           is thrown. This exception is ignored, and the parsing process' ||
'           continues.  ' ||
'        ' ||
'        PARAMETER: OUTPUT_RAW_VALUE' ||
'        VALUE: an integer value (default to 0, no output) (-1 ~ 32767)' ||
'        DESCRIPTION: What to output in an XML metadata document' ||
'        when the parsing of a DICOM object fails. The base64 encoding ' ||
'        of the attribute''s byte value can be returned in the rawValue ' ||
'        attribute of a DICOM XML element. The VALUE element specifies' ||
'        the maximal length allowed for the rawValue attribute. ' ||
'        If $VALUE == -1, (not recommended), the entire attribute up to 32k' ||
'        is saved in the rawValue attribute in base64 encoding.' ||
'        If $VALUE == 0, an empty string is saved in the rawValue ' ||
'        attribute (recommended for production systems).' ||
'        If $VALUE == N > 0, only the first N bytes of the attribute are' ||
'        saved in the rawValue attribute.' ||
'        A nonzero value for this parameter is useful for debugging ' ||
'        purposes. For a production system, do NOT pick a value' ||
'        larger than 64. The value -1 should never be used outside of' ||
'        a development environment.' ||
'        ' ||
'        PARAMETER: LOGGING_LEVEL' ||
'        VALUE: enum {debug, conformance, warning(default), error, none }' ||
'        DESCRIPTION:   The logging level, if ordered by the level of ' ||
'        detail from the most to the least is: "debug", "conformance", ' ||
'        "warning", "error", and "none".' ||
'         "debug" means extensive logging of all steps; it should ' ||
'        only be used for debugging purposes. ' ||
'         "conformance" means to log all nonstandard conformance ' ||
'        problems that are discovered. In general, nonconformance is very ' ||
'        common for a DICOM object repository containing DICOM ' ||
'        objects from different sources, for example, a hospital or an imaging ' ||
'        center. This logging level may lead to large log files for ' ||
'        most scenarios, and lower performance. ' ||
'         "warning" means to log all recoverable messages that require ' ||
'        operator attention. For example, if a user invokes an ' ||
'        image processing function on a DICOM object and ' ||
'        Oracle does not recognize this DICOM object as an image, ' ||
'        a warning message is logged stating that this DICOM object ' ||
'        is not defined as an image. The processing of the image ' ||
'        content may continue if the CONFORMANCE_LEVEL' ||
'        parameter is set to ignore "NOT_AN_IMAGE" exception. ' ||
'        "error" means to log only irrecoverable messages. ' ||
'        "none" means that logging is disabled. ' ||
'        Note: Do not use the "debug" option for a deployed system. ' ||
'        It adds significant overhead and slows down all ' ||
'        DICOM related functions.' ||
'        ' ||
'        PARAMETER: VALIDATE_METADATA' ||
'        VALUE: Boolean{true, false(default)}' ||
'        DESCRIPTION: The DICOM function extractMetadata takes a ' ||
'        mapping document as an input parameter. A mapping document' ||
'        contains a namespace parameter (which can be empty). If an' ||
'        XML schema is registered at this namespace, and the value of' ||
'        the VALIDATE_METADATA parameter is true, the extractMetadata' ||
'        function validates the resulting XML document against the' ||
'        designated schema.' ||
'        If the value of this parameter is false, the resulting XML document' ||
'        is not validated.' ||
'        ' ||
'        PARAMETER: EXP_IF_NULL_ATTR_IN_CONSTRAINT' ||
'        VALUE: Boolean{true(default), false}' ||
'        DESCRIPTION: A DICOM object may not contain certain attributes' ||
'        that are used in a constraint predicate. The object may' ||
'        contain an attribute, but its value is empty. Both cases' ||
'        result to a null value attribute. So a constraint' ||
'        predicate involving this attribute has a null ' ||
'        parameter value such as (null== MY_VALUE). ' ||
'        If this preference parameter is set to true,' ||
'        an exception is thrown if the first occurrence of a ' ||
'        a null-value attribute is not guarded by the "notEmpty" ' ||
'        Boolean function. If this parameter is set to false, ' ||
'        no exception is thrown and the predicate evaluates to ' ||
'        false. To avoid confusion, it is always better to guard an ' ||
'        attribute with "notEmpty" Boolean functions before using' ||
'        the attribute value in a predicate.' ||
'         ' ||
'        PARAMETER: MAX_RECURSION_DEPTH' ||
'        VALUE: an integer type (default 16, 1 ~ 32767)' ||
'        DESCRIPTION: This parameter restricts the number of levels of ' ||
'        recursions when evaluating a recursive constraint on a DICOM' ||
'        object. If the recursion level exceeds this number, an exception' ||
'        is thrown. ' ||
'         ' ||
'' ||
'        PARAMETER: MANDATE_ATTR_TAGS_IN_STL ' ||
'        VALUE: Boolean{false(default), true}' ||
'        DESCRIPTION: This parameter is used to enforce that all tags ' ||
'        used by the constraint and mapping documents must be listed in the' ||
'        STORED_TAG_LIST(STL) document. This rule is not enforced by default.' ||
'        If this preference parameter is set to true, the rule is enforced. ' ||
'        If an existing STL document does not satisfy this rule,' ||
'        the preference value cannot be set to true until the' ||
'        STL document is deleted. ' ||
'' ||
'        PARAMETER: SQ_WRITE_LEN' ||
'        VALUE: boolean{true(default), false}' ||
'        DESCRIPTION: This parameter determines how the DICOM' ||
'        sequence (SQ) types are encoded by the DICOM function writeMetadata().' ||
'        If the value of this parameter is true, the SQ types are encoded' ||
'        with explicit length and without item or sequence delimitors.' ||
'        This is the default behavior and allows DICOM viewers to skip' ||
'        the sequence attributes easily.' ||
'        If the value of this parameter is false, the SQ types are encoded' ||
'        with variable (or undefined) length and terminated with' ||
'        sequence delimitors. This allows backward compatibility with some' ||
'        older DICOM viewers and Dicom applications as they only support' ||
'        undefined length for SQ types.' ||
'' ||
'        PARAMETER: SPECIFIC_CHARACTER_SET' ||
'        VALUE: enum {ASCII(default), ISO_IR 100, ISO_IR 101, ISO_IR 109, ' ||
'                     ISO_IR 110, ISO_IR 144, ISO_IR 127, ISO_IR 126,' ||
'                     ISO_IR 138, ISO_IR 148, ISO_IR 13, ISO_IR 166,' ||
'                     ISO_IR 192, GB18030}' ||
'        DESCRIPTION: This parameter determines how data elements with value' ||
'        representations of SH (Short String), LO (Long String), ST (Short Text)' ||
'        LT (Long Text), PN (Person Name) or UT (Unlimited Text) are decoded' ||
'        when the Specific Character Set (0008,0005) Attribute is missing.' ||
'        The DICOM standard states that the default character set ' ||
'        (ISO-IR 6, or ASCII) shall be used for decoding when the Specific' ||
'        Character Set (0008,0005) Attribute is not specified. This parameter' ||
'        allows an application to specify a different character set to ' ||
'        use in these cases.' ||
'' ||
'        PARAMETER: BINARY_SKIP_INVALID_ATTR' ||
'        VALUE: boolean{false(default), true}' ||
'        DESCRIPTION: It is possible that a DICOM object contains one or more' ||
'        attribute values that do not conform to the DICOM specification. In the ' ||
'        event that such an attribute is present in a DICOM object, this ' ||
'        parameter determines whether or not to "skip" (i.e. not include) the ' ||
'        value of that attribute in the binary output when making a copy of the' ||
'        object in question. The default behavior, specified by setting this' ||
'        parameter to "false", is to not skip these values and to include them' ||
'        as-is in the coresponding output. When an attribute is skipped, its' ||
'        value is included in the output truncated to length 0.' ||
' ' ||
'  </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="DICOM_RUNTIME_PREFERENCES">' ||
'    <xs:complexType>' ||
'      <xs:sequence>' ||
'        <xs:element name="DOCUMENT_HEADER" type="dt:DOCUMENT_HEADER_T" minOccurs="0"/>' ||
'        <xs:element name="PREFERENCE_DEF" maxOccurs="unbounded">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'                  Each PREFERENCE_DEF entry describes one parameter' ||
'                  that a repository administrator may modify to adjust the' ||
'                  run-time behavior of the DICOM functionality.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'          <xs:complexType>' ||
'            <xs:sequence>' ||
'              <xs:element name="PARAMETER" type="dt:SHORT_ID_T"/>' ||
'              <xs:element name="DESCRIPTION" type="dt:SHORT_TEXT_T" minOccurs="0"/>' ||
'              <xs:element name="VALUE">' ||
'                <xs:simpleType>' ||
'                  <xs:restriction base="dt:SHORT_TEXT_T">' ||
'                    <xs:pattern value="[ 0-9_a-zA-Z]+"/>' ||
'                  </xs:restriction>' ||
'                </xs:simpleType>' ||
'              </xs:element>' ||
'            </xs:sequence>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'    </xs:complexType>' ||
'  </xs:element>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/preference_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmpv.xsd with XDB under http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'' ||
'   NAME' ||
'     ordcmpv.xsd - XML schema for DICOM private dictionary documents' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   myalavar    06/06/07 - review comments' ||
'   myalavar    04/10/07 - doc comments' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        04/03/05 - Created' ||
'' ||
'-->' ||
'' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xs="http://www.w3.org/2001/XMLSchema" targetNamespace="http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/>' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'    Introduction' ||
'      This schema defines the private attributes created by modality ' ||
'      manufacturers or organizations other than the DICOM ' ||
'      standard committee.' ||
'' ||
'    Structure Overview' ||
'      Question mark "?" means optional items.' ||
'      Plus "+" means one or more items.' ||
'      Asterisk "*" means zero or more items.' ||
'' ||
'      DICOM_PRIVATE_ATTRIBUTES' ||
'        DOCUMENT_HEADER?' ||
'      DOCUMENT_CHANGE_LOG*' ||
'        DOCUMENT_MODIFIER' ||
'        DOCUMENT_MODIFICATION_DATE' ||
'        DOCUMENT_VERSION?' ||
'        MODIFICATION_COMMENT?' ||
'            BASE_DOCUMENT?' ||
'            BASE_DOCUMENT_RELEASE_DATE?' ||
'        BASE_DOCUMENT_DESCRIPTION?' ||
'    ATTRIBUTE_DEFINERS?' ||
'      DEFINER+' ||
'        NAME' ||
'        ID?' ||
'        PRIVATE_ATTRIBUTE_DEFINITION+' ||
'      (TAG|TAG_RANGE)' ||
'      NAME' ||
'      DEFINER' ||
'      VR?' ||
'          VM?' ||
'          RETIRED?' ||
'  DOCUMENT_HEADER is an optional header to specify the' ||
'  modification history. See dt:DOCUMENT_HEADER_T' ||
'  for more information.' ||
'  ATTRIBUTE_DEFINERS specify the owner of each' ||
'  private attribute. See dt:ATTR_DEFINER_T for more' ||
'  information.' ||
'' ||
'  A private dictionary contains one or more private attribute' ||
'  definitions.' ||
'  Each private attribute specification takes a tag specification,' ||
'  a name, a value representation type, a value multiplicity' ||
'  type, and a retired flag. See dt:VR_T dt:VM_T for the allowed' ||
'  values for the value representation and value multiplicity elements.' ||
'  ' ||
'    Note: Private attribute tags allow three specification types.' ||
'    The tag can be a 4-byte hexadecimal number, a ' ||
'    wildcard type such as "0039xx01", or a range type such' ||
'    as "0039xx01~0041xx01".' ||
'    ' ||
'    Multiple attribute definitions cannot be associated with' ||
'    the same definer-tag pair in a dictionary. For example, a simple ' ||
'    attribute definition ("oracle", 60100010) matches a wildcard ' ||
'    attribute ("oracle", 60xx0010), they cannot coexist in the private ' ||
'    dictionary. Similarly, a range attribute definition ("Oracle", {6000-60FF})' ||
'    overlaps a range attribute definition ("Oracle", {6010-6020}), they ' ||
'    cannot coexist in the private dictionary. As a rule, an attribute ' ||
'    must not match two entries in the dictionary.' ||
'    ' ||
'  </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="DICOM_PRIVATE_ATTRIBUTES">' ||
'    <xs:complexType>' ||
'      <xs:sequence>' ||
'        <xs:element name="DOCUMENT_HEADER" type="dt:DOCUMENT_HEADER_T" minOccurs="0"/>' ||
'        <xs:element name="ATTRIBUTE_DEFINERS" type="dt:ATTR_DEFINERS_T" minOccurs="0"/>' ||
'        <xs:element name="PRIVATE_ATTRIBUTE_DEFINITION" maxOccurs="unbounded">' ||
'          <xs:complexType>' ||
'            <xs:sequence>' ||
'              <xs:choice>' ||
'                <xs:element name="TAG" type="dt:ATTR_TAG_T"/>' ||
'                <xs:element name="TAG_RANGE" type="dt:ATTR_RANGE_T"/>' ||
'              </xs:choice>' ||
'              <xs:element name="NAME" type="dt:SHORT_STRING_T"/>' ||
'              <xs:element name="DEFINER" type="dt:LO"/>' ||
'              <xs:element name="VR" type="dt:VR_T" minOccurs="0"/>' ||
'              <xs:element name="VM" type="dt:VM_T" minOccurs="0"/>' ||
'              <xs:element name="RETIRED" type="xs:boolean" default="false" minOccurs="0"/>' ||
'            </xs:sequence>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'    </xs:complexType>' ||
'  </xs:element>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmsd.xsd with XDB under http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'    NAME' ||
'      ordcmsd.xsd - XML Schema for DICOM standard dictionary document. ' ||
'' ||
'    ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   myalavar    06/06/07 - review comments' ||
'   myalavar    04/10/07 - doc comments' ||
'   dguo        04/02/05 -  Created' ||
'-->' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" targetNamespace="http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/>' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'    Introduction' ||
'      This schema defines the data dictionary that lists the DICOM ' ||
'      standard attributes as published by the DICOM standard committee.' ||
'      No other attributes, such as those defined by a modality ' ||
'      manufacturer or an organization other than NEMA,' ||
'      should be included in the standard data dictionary.' ||
'' ||
'    Structure Overview' ||
'      Question mark "?" means optional items.' ||
'      Plus "+" means one or more items.' ||
'      Asterisk "*" means zero or more items.' ||
'' ||
'      DICOM_STANDARD_ATTRIBUTES' ||
'        DOCUMENT_HEADER?' ||
'      DOCUMENT_CHANGE_LOG*' ||
'        DOCUMENT_MODIFIER' ||
'        DOCUMENT_MODIFICATION_DATE' ||
'        DOCUMENT_VERSION?' ||
'        MODIFICATION_COMMENT?' ||
'            BASE_DOCUMENT?' ||
'            BASE_DOCUMENT_RELEASE_DATE?' ||
'        BASE_DOCUMENT_DESCRIPTION?' ||
'    ATTRIBUTE_DEFINERS?' ||
'      DEFINER+' ||
'        NAME' ||
'        ID?' ||
'        STANDARD_ATTRIBUTE_DEFINITION+' ||
'      TAG' ||
'      NAME' ||
'      VR?' ||
'          VM?' ||
'          RETIRED?' ||
'    ' ||
'    DOCUMENT_HEADER is an optional header to specify the' ||
'    modification history. See dt:DOCUMENT_HEADER_T' ||
'    for more information.' ||
'' ||
'    ATTRIBUTE_DEFINERS specify the owner of each' ||
'    attribute. See dt:ATTR_DEFINER_T for more' ||
'    information. All DICOM standard attributes must have' ||
'    definer name "DICOM" and UID "1.2.840.10008.1".' ||
'' ||
'    A standard dictionary contains one or more standard attribute' ||
'    definitions.' ||
'' ||
'    Each standard attribute specification takes a tag specification,' ||
'    a name, a value representation type, a value multiplicity' ||
'    type, and a retired flag. See DICOM P3-6 2007 for a ' ||
'    description of these elements. See dt:VR_T dt:VM_T for the allowed ' ||
'    values of value representation and value multiplicity elements.' ||
'    ' ||
'    Note: Wildcard character "x" can be used to specify' ||
'    standard attribute tags (for example, 60xx0010 for overlay rows).' ||
'      ' ||
'    Multiple attribute definitions must not be associated with' ||
'    the same tag in a standard dictionary. For example, the' ||
'    attribute definition 60100010 matches the wildcard ' ||
'    attribute 60xx0010, they cannot coexist in ' ||
'    the dictionary. As a rule, an attribute must not match two ' ||
'    entries in the dictionary.' ||
'  </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="DICOM_STANDARD_ATTRIBUTES">' ||
'    <xs:complexType>' ||
'      <xs:sequence>' ||
'        <xs:element name="DOCUMENT_HEADER" type="dt:DOCUMENT_HEADER_T" minOccurs="0"/>' ||
'        <xs:element name="ATTRIBUTE_DEFINERS" type="dt:ATTR_DEFINERS_T" minOccurs="0"/>' ||
'        <xs:element name="STANDARD_ATTRIBUTE_DEFINITION" maxOccurs="unbounded">' ||
'          <xs:complexType>' ||
'            <xs:sequence>' ||
'              <xs:element name="TAG" type="dt:ATTR_TAG_T"/>' ||
'              <xs:element name="NAME" type="dt:SHORT_STRING_T"/>' ||
'              <xs:element name="VR" type="dt:VR_T" minOccurs="0"/>' ||
'              <xs:element name="VM" type="dt:VM_T" minOccurs="0"/>' ||
'              <xs:element name="RETIRED" type="xs:boolean" minOccurs="0"/>' ||
'            </xs:sequence>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'    </xs:complexType>' ||
'  </xs:element>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmss.xsd with XDB under http://xmlns.oracle.com/ord/dicom/orddicom_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, Oracle. All rights reserved. ' ||
'    NAME' ||
'      ordcmss.xsd - XML Schema for Oracle-reserved data types. ' ||
'' ||
'    ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   myalavar    04/10/07 - doc comments' ||
'   dguo        04/02/05 -  Created' ||
'-->' ||
'' ||
'<xs:schema xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns="http://xmlns.oracle.com/ord/dicom/orddicom_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" targetNamespace="http://xmlns.oracle.com/ord/dicom/orddicom_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/>' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'     Introduction' ||
'       This is the ORDDicom schema for Oracle-reserved data types.' ||
'    </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="ANY_ATTR" type="ANY_ATTR_T" nillable="true"/>' ||
'  <xs:complexType name="ANY_ATTR_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Any attribute type (ANY_ATTR_T) maps to a single DICOM' ||
'        attribute type.  Each attribute type has a name that reflects' ||
'        the DICOM value representation of the attribute.' ||
'        Each attribute is strongly typed and its type matches its DICOM' ||
'        VR.  Certain DICOM configuration files, such as constraint ' ||
'        document, use ANY_ATTR_T.' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:choice>' ||
'      <xs:element name="APPLICATION_ENTITY" type="dt:AE_ATTR_T"/>' ||
'      <xs:element name="AGE_STRING" type="dt:AS_ATTR_T"/>' ||
'      <xs:element name="ATTRIBUTE_TAG" type="dt:AT_ATTR_T"/>' ||
'      <xs:element name="CODE_STRING" type="dt:CS_ATTR_T"/>' ||
'      <xs:element name="DATE" type="dt:DA_ATTR_T"/>' ||
'      <xs:element name="DECIMAL_STRING" type="dt:DS_ATTR_T"/>' ||
'      <xs:element name="FLOAT_SINGLE" type="dt:FL_ATTR_T"/>' ||
'      <xs:element name="FLOAT_DOUBLE" type="dt:FD_ATTR_T"/>' ||
'      <xs:element name="INTEGER_STRING" type="dt:IS_ATTR_T"/>' ||
'      <xs:element name="LONG_STRING" type="dt:LO_ATTR_T"/>' ||
'      <xs:element name="LONG_TEXT" type="dt:LT_ATTR_T"/>' ||
'      <xs:element name="OTHER_BYTE" type="dt:OB_ATTR_T"/>' ||
'      <xs:element name="OTHER_FLOAT" type="dt:OF_ATTR_T"/>' ||
'      <xs:element name="OTHER_WORD" type="dt:OW_ATTR_T"/>' ||
'      <xs:element name="PERSON_NAME" type="dt:PN_ATTR_T"/>' ||
'      <xs:element name="SHORT_STRING" type="dt:SH_ATTR_T"/>' ||
'      <xs:element name="SIGNED_LONG" type="dt:SL_ATTR_T"/>' ||
'      <xs:element name="SEQUENCE" type="dt:SQ_ATTR_T"/>' ||
'      <xs:element name="SIGNED_SHORT" type="dt:SS_ATTR_T"/>' ||
'      <xs:element name="SHORT_TEXT" type="dt:ST_ATTR_T"/>' ||
'      <xs:element name="TIME" type="dt:TM_ATTR_T"/>' ||
'      <xs:element name="UNIQUE_ID" type="dt:UI_ATTR_T"/>' ||
'      <xs:element name="UNSIGNED_LONG" type="dt:UL_ATTR_T"/>' ||
'      <xs:element name="UNKNOWN" type="dt:UN_ATTR_T"/>' ||
'      <xs:element name="UNSIGNED_SHORT" type="dt:US_ATTR_T"/>' ||
'      <xs:element name="UNLIMITED_TEXT" type="dt:UT_ATTR_T"/>' ||
'      <xs:element name="EXTENDED_TYPE" type="dt:EXT_ATTR_T"/>' ||
'      <xs:element name="EXCEPTION_TYPE" type="dt:EXP_ATTR_T"/>' ||
'    </xs:choice>' ||
'  </xs:complexType>' ||
'  <xs:element name="CT_OPERAND_T">' ||
'    <xs:annotation>' ||
'      <xs:documentation>' ||
'        Database table storage type for constraint operand' ||
'      </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:complexType>' ||
'      <xs:choice>' ||
'        <xs:element name="STRING_VALUE" type="dt:MIXED_TEXT_T"/>' ||
'        <xs:element name="XML_VALUE" type="dt:ATTR_VALUE_T"/>' ||
'        <xs:element name="ATTRIBUTE_TAG" type="dt:VALUE_LOCATOR_MACRO_T"/>' ||
'      </xs:choice>' ||
'    </xs:complexType>' ||
'  </xs:element>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/orddicom_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmui.xsd with XDB under http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'' ||
'   NAME' ||
'     ordcmui.xsd - XML schema for DICOM UID definition documents. ' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   fechen      05/23/08 - change the meaning of isCompressed attribute to' ||
'                          image content only. ' ||
'   dolin       06/06/07 - ' ||
'   myalavar    06/06/07 - review comments' ||
'   myalavar    04/10/07 - doc comments' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        04/03/05 - Created' ||
'' ||
'-->' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xs="http://www.w3.org/2001/XMLSchema" targetNamespace="http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/>' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'    Introduction' ||
'      This schema defines DICOM UIDs. ' ||
'      User can update this file to support new DICOM object types.' ||
'' ||
'    Structure Overview' ||
'      Question mark "?" means optional items.' ||
'      Plus "+" means one or more items.' ||
'      Asterisk "*" means zero or more items.' ||
'' ||
'      DICOM_UID_DEFINITIONS' ||
'        DOCUMENT_HEADER?' ||
'          DOCUMENT_CHANGE_LOG*' ||
'            DOCUMENT_MODIFIER' ||
'            DOCUMENT_MODIFICATION_DATE' ||
'            DOCUMENT_VERSION?' ||
'            MODIFICATION_COMMENT?' ||
'                BASE_DOCUMENT?' ||
'                BASE_DOCUMENT_RELEASE_DATE?' ||
'                BASE_DOCUMENT_DESCRIPTION?' ||
'        UID_DEF (classification, isLE?, isEVR?, isCompressed?,retired?, contentType?)+' ||
'          UID' ||
'          NAME' ||
'          DESCRIPTION?' ||
'' ||
'      A UID_DEF entry describes a UID value.' ||
'      The mandatory classification attribute specifies what' ||
'      a UID is. Its value can be "transferSyntax", "storageClass",' ||
'      "frameOfRef", "ldapOID", "entityID", or "other".' ||
'      "transferSyntax" means that the UID identifies transfer syntax.' ||
'      "storageClass" means that the UID identifies a storage class.' ||
'      "frameOfRef" means that the UID is a well-known frame of reference.' ||
'      "ldapOID" means that the UID is an LDAP OID.' ||
'      "entityID" means that the UID identifies an entity, which can be' ||
'       an organization or a device manufacturer.' ||
'      "other" means that the UID does not fall into any of the previous ' ||
'       categories.' ||
'                ' ||
'      For entries that have a classification type of ' ||
'      "transferSyntax", the attributes "isLE", "isEVR", and ' ||
'      "isCompressed" further define the transfer syntax. These ' ||
'      attributes are ignored for all other classification types.' ||
'      The "isLE" attribute specifies whether the binary stream' ||
'      will be encoded with little-endian byte order(defaults to true). ' ||
'      The "isEVR" attribute specifies whether the binary stream ' ||
'      will use the explicit VR encoding rule (defaults to true). ' ||
'      The "isCompressed" attribute specifies whether the ' ||
'      transfer syntax means that the image content is compressed ' ||
'      (defaults to true).' ||
'        ' ||
'      If an entry has a classification type of "storageClass", ' ||
'      the "contentType" attribute further specifies the primary' ||
'      content of a DICOM object belonging to this class. ' ||
'      The value of this attribute can be "image", "waveform",' ||
'      "report" or "other".' ||
'      "image" can be single-frame, multi-frame images, or video. ' ||
'      "waveform" can be ECG, EEG, or any other 1D signal. ' ||
'      "report" means a structured report. ' ||
'      "other" means overlay, GSPS, KO, or any other object types that ' ||
'              do not belong to the previous categories.' ||
'      For example "Ultrasound Multi-frame Image Storage" SOP' ||
'      class has a UID of "1.2.840.10008.5.1.4.1.1.3.1". Its ' ||
'      primary content is image.' ||
'    ' ||
'  </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="DICOM_UID_DEFINITIONS">' ||
'    <xs:complexType>' ||
'      <xs:sequence> ' ||
'        <xs:element name="DOCUMENT_HEADER" type="dt:DOCUMENT_HEADER_T" nillable="true" minOccurs="0"/>' ||
'        <xs:element name="UID_DEF" maxOccurs="unbounded">' ||
'          <xs:complexType>' ||
'            <xs:complexContent>' ||
'              <xs:extension base="UID_ENTRY_T">' ||
'                <xs:attribute name="classification" use="required">' ||
'                  <xs:simpleType>' ||
'                    <xs:restriction base="xs:token">' ||
'                      <xs:enumeration value="transferSyntax"/>' ||
'                      <xs:enumeration value="storageClass"/>' ||
'                      <xs:enumeration value="frameOfRef"/>' ||
'                      <xs:enumeration value="ldapOID"/>' ||
'                      <xs:enumeration value="entityID"/>' ||
'                      <xs:enumeration value="other"/>' ||
'                    </xs:restriction>' ||
'                  </xs:simpleType>' ||
'                </xs:attribute>' ||
'                <xs:attribute name="isLE" type="xs:boolean" default="true"/>' ||
'                <xs:attribute name="isEVR" type="xs:boolean" default="true"/>' ||
'                <xs:attribute name="isCompressed" type="xs:boolean" default="true"/>' ||
'                <xs:attribute name="retired" type="xs:boolean" default="false"/>' ||
'                <xs:attribute name="contentType" default="image">' ||
'                  <xs:simpleType>' ||
'                    <xs:restriction base="xs:token">' ||
'                      <xs:enumeration value="image"/>' ||
'                      <xs:enumeration value="waveform"/>' ||
'                      <xs:enumeration value="report"/>' ||
'                      <xs:enumeration value="other"/>' ||
'                    </xs:restriction>' ||
'                  </xs:simpleType>' ||
'                </xs:attribute>' ||
'              </xs:extension>' ||
'            </xs:complexContent>' ||
'          </xs:complexType>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'    </xs:complexType>' ||
'  </xs:element>' ||
'  <xs:complexType name="UID_ENTRY_T">' ||
'    <xs:sequence>' ||
'      <xs:element name="UID" type="dt:UI"/>' ||
'      <xs:element name="NAME" type="dt:SHORT_STRING_T"/>' ||
'      <xs:element name="DESCRIPTION" type="dt:SHORT_TEXT_T" minOccurs="0"/>' ||
'    </xs:sequence>' ||
'  </xs:complexType>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>TRUE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmstl.xsd with XDB under http://xmlns.oracle.com/ord/dicom/attributeTag_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!--' ||
' Copyright (c) 2008, Oracle and/or its affiliates. All rights reserved. ' ||
'' ||
'   NAME' ||
'     ordcmstl.xsd - XML schema for the DICOM STORED_TAG_LIST document' ||
'' ||
'   MODIFIED   (MM/DD/YY)' ||
'   fechen      07/14/08 - Created' ||
'' ||
'-->' ||
'' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/dicom/attributeTag_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xs="http://www.w3.org/2001/XMLSchema" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" targetNamespace="http://xmlns.oracle.com/ord/dicom/attributeTag_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/> ' ||
'   <xs:annotation>' ||
'     <xs:documentation>' ||
'     Introduction' ||
'       This schema defines the STORED_TAG_LIST document. ' ||
'       This document lists the attribute tags that are' ||
'       persistently stored in the metadata attribute of the ORDDICOM object.' ||
'' ||
'     Structure Overview:' ||
'        Question mark "?" means optional items.' ||
'        Plus "+" means one or more items.' ||
'        Asterisk "*" means zero or more items.' ||
'' ||
'        ATTRIBUTE_TAG_LIST' ||
'          DOCUMENT_HEADER?' ||
'            DOCUMENT_CHANGE_LOG*' ||
'            DOCUMENT_MODIFIER' ||
'            DOCUMENT_MODIFICATION_DATE' ||
'            DOCUMENT_VERSION?' ||
'            MODIFICATION_COMMENT?' ||
'            BASE_DOCUMENT?' ||
'            BASE_DOCUMENT_RELEASE_DATE?' ||
'            BASE_DOCUMENT_DESCRIPTION?' ||
'          ATTRIBUTE_TAG+' ||
'    </xs:documentation>' ||
'  </xs:annotation>' ||
'  <xs:element name="ATTRIBUTE_TAG_LIST">' ||
'    <xs:complexType>' ||
'      <xs:sequence>' ||
'        <xs:element name="DOCUMENT_HEADER" type="dt:DOCUMENT_HEADER_T" minOccurs="0"/>' ||
'        <xs:element name="ATTRIBUTE_TAG" type="dt:VALUE_LOCATOR_T" minOccurs="1" maxOccurs="unbounded" >' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'               Each ATTRIBUTE_TAG entry describes one locator path of a' ||
'               DICOM attribute in the list.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'        </xs:element> ' ||
'      </xs:sequence>' ||
'    </xs:complexType>' ||
'  </xs:element>' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/attributeTag_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>FALSE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/


-- Register ordcmmft.xsd with XDB under http://xmlns.oracle.com/ord/dicom/manifest_1_0
declare 
 ordSchema varchar2(32767);
 ordClob   clob := null;
 ex exception;
 pragma exception_init( ex, -31085 );
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordSchema :=
 '<?xml version="1.0" encoding="UTF-8"?>' ||
'<xs:schema xmlns="http://xmlns.oracle.com/ord/dicom/manifest_1_0" ' ||
'xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xs="http://www.w3.org/2001/XMLSchema" targetNamespace="http://xmlns.oracle.com/ord/dicom/manifest_1_0" elementFormDefault="qualified" attributeFormDefault="unqualified">' ||
'  <xs:import namespace="http://xmlns.oracle.com/ord/dicom/datatype_1_0" schemaLocation="http://xmlns.oracle.com/ord/dicom/datatype_1_0"/>' ||
'' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'      This schema defines a DICOM manifest file. This file specifies the' ||
'      document name, type, and the order in which the configuration ' ||
'      documents are loaded into the DICOM data model repository. ' ||
'      This manifest file is created by the exportDataModel procedure ' ||
'      and is used by the importDataModel procedure in the data model ' ||
'      repository (ord_dicom_admin) API.' ||
'' ||
'      The DOCUMENT_VERSION in the DOCUMENT_HEADER represents the repository' ||
'      version. This value identifies a set of configuration documents in ' ||
'      the repository. This value is for future use when we may maintain and' ||
'      export multiple versions of the data model repository.' ||
'        ' ||
'      DICOM_MANIFEST' ||
'        DOCUMENT_HEADER?' ||
'           DOCUMENT_CHANGE_LOG*' ||
'           DOCUMENT_MODIFIER' ||
'           DOCUMENT_MODIFICATION_DATE' ||
'           DOCUMENT_VERSION?' ||
'           MODIFICATION_COMMENT?' ||
'           BASE_DOCUMENT?' ||
'          BASE_DOCUMENT_RELEASE_DATE?' ||
'          BASE_DOCUMENT_DESCRIPTION?' ||
'' ||
'        DOCUMENT_DEF+' ||
'          NAME' ||
'          TYPE' ||
'          LOAD_ORDER' ||
'        ' ||
'' ||
'    </xs:documentation>' ||
'  </xs:annotation>' ||
'	' ||
'  <xs:simpleType name="DOCUMENT_NAME_T">' ||
'    <xs:annotation>' ||
'       <xs:documentation>' ||
'         Name of a document in the dicom data model repository.' ||
'         This is the file name of the XML document that has been ' ||
'         exported from the repository or is being loaded into ' ||
'         the repository. ' ||
'       </xs:documentation>' ||
'    </xs:annotation>' ||
'    <xs:restriction base="xs:string">	 ' ||
'      <xs:maxLength value="100"/>	' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
' ' ||
'  <xs:simpleType name="DOCUMENT_TYPE_T">' ||
'  <xs:annotation>' ||
'    <xs:documentation>' ||
'      The document types supported in the data model repository.' ||
'    </xs:documentation>' ||
'  </xs:annotation>' ||
'    <xs:restriction base="xs:string">' ||
'       <xs:enumeration value="STANDARD_DICTIONARY" />' ||
'       <xs:enumeration value="PRIVATE_DICTIONARY" />' ||
'       <xs:enumeration value="MAPPING" />' ||
'       <xs:enumeration value="ANONYMITY" />' ||
'       <xs:enumeration value="PREFERENCE" />' ||
'       <xs:enumeration value="CONSTRAINT" />' ||
'       <xs:enumeration value="UID_DEFINITION" />' ||
'       <xs:enumeration value="STORED_TAG_LIST" />' ||
'    </xs:restriction>' ||
'  </xs:simpleType>' ||
' ' ||
'     ' ||
'  <xs:element name="DICOM_MANIFEST">' ||
'    <xs:complexType>' ||
'      <xs:sequence>' ||
'        <xs:element name="DOCUMENT_HEADER" type="dt:DOCUMENT_HEADER_T" nillable="true" minOccurs="0"/>' ||
'        <xs:element name="DOCUMENT_DEF" maxOccurs="unbounded">' ||
'          <xs:annotation>' ||
'            <xs:documentation>' ||
'              Each document definition defines a document that to be' ||
'              inserted into or exported from the data model repository.' ||
'            </xs:documentation>' ||
'          </xs:annotation>' ||
'          <xs:complexType>' ||
'            <xs:sequence>' ||
'              <xs:element name="NAME" type="DOCUMENT_NAME_T"/>' ||
'              <xs:element name="TYPE" type="DOCUMENT_TYPE_T"/>' ||
'              <xs:element name="LOAD_ORDER" type="xs:integer"/>' ||
'            </xs:sequence>' ||
'          </xs:complexType>' ||
'          <xs:unique name="docName">' ||
'            <xs:selector xpath="NAME"/>' ||
'            <xs:field xpath="."/>' ||
'          </xs:unique>' ||
'        </xs:element>' ||
'      </xs:sequence>' ||
'    </xs:complexType>' ||
'  </xs:element>	' ||
'' ||
'' ||
'</xs:schema>';

 sys.dbms_lob.write(ordClob, length(ordSchema), 1, ordSchema);

 xdb.dbms_xmlschema.registerSchema
  (schemaURL=>'http://xmlns.oracle.com/ord/dicom/manifest_1_0',
   schemaDoc=>ordClob,
   local=>FALSE,
   genTypes=>FALSE,
   genBean=>FALSE,
   genTables=>FALSE,
   force=>FALSE,
   owner=>'ORDSYS'
  );
 sys.dbms_lob.freeTemporary(ordClob);
 ordClob := null;

 -- ignore duplicate registration
 exception 
 when ex then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
  when others then
   if(ordCLob is not null) then 
     sys.dbms_lob.freeTemporary(ordClob); 
     ordClob := null;
   end if;
   raise;
end;
/

