Rem
Rem imxrins.sql
Rem
Rem Copyright (c) 2004, 2009, Oracle and/or its affiliates. 
Rem All rights reserved. 
Rem
Rem    NAME
Rem      imxrins.sql
Rem
Rem    DESCRIPTION
Rem      This script inserts the oracle default documents into the 
Rem      dicom repository
Rem
Rem      *!*!*!*!* This script is autogenerated by ordim/utl/setupview.pl *!*!*!*!*
Rem       Do not edit it unless you know what you are doing. Edit setup_view.pl
Rem
Rem    NOTES
Rem      Before running this script user must be connected as a user
Rem       with authority to insert dicom repository documents.
Rem      
Rem     

exec ordsys.ord_dicom_admin.editdatamodel;


-- insert the ordcmsd.xml into the dicom repos
declare 
 xt sys.XMLtype;
 ex exception;
 pragma exception_init(ex, -53002);
 ordcmXml varchar2(32767);
 ordClob   clob;
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordcmXml := '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'  NAME' ||
'  ordcmsd.xml - Oracle Multimedia DICOM standard dictionary document' ||
'  ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dolin       06/06/07 - ' ||
'   dguo        05/18/07 - change product name' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'' ||
'-->' ||
'' ||
'<DICOM_STANDARD_ATTRIBUTES xmlns="http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0  http://xmlns.oracle.com/ord/dicom/standardDictionary_1_0">' ||
' <DOCUMENT_HEADER>' ||
'    <dt:DOCUMENT_CHANGE_LOG>' ||
'      <dt:DOCUMENT_MODIFIER>Dongbai Guo</dt:DOCUMENT_MODIFIER>' ||
'      <dt:DOCUMENT_MODIFICATION_DATE>2007-04-09</dt:DOCUMENT_MODIFICATION_DATE>' ||
'      <dt:DOCUMENT_VERSION>1.0</dt:DOCUMENT_VERSION>' ||
'      <dt:MODIFICATION_COMMENT>Oracle standard dictionary</dt:MODIFICATION_COMMENT>' ||
'      <dt:BASE_DOCUMENT>DICOM Base Standard 2007, Part 6</dt:BASE_DOCUMENT>' ||
'      <dt:BASE_DOCUMENT_RELEASE_DATE>2007-01-01</dt:BASE_DOCUMENT_RELEASE_DATE>' ||
'      <dt:BASE_DOCUMENT_DESCRIPTION>Downloadable from http://medical.nema.org/</dt:BASE_DOCUMENT_DESCRIPTION>' ||
'   </dt:DOCUMENT_CHANGE_LOG>' ||
' </DOCUMENT_HEADER>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080001</TAG>' ||
'   <NAME>Length to End</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080005</TAG>' ||
'   <NAME>Specific Character Set</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080008</TAG>' ||
'   <NAME>Image Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080010</TAG>' ||
'   <NAME>Recognition Code</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080012</TAG>' ||
'   <NAME>Instance Creation Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080013</TAG>' ||
'   <NAME>Instance Creation Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080014</TAG>' ||
'   <NAME>Instance Creator UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080016</TAG>' ||
'   <NAME>SOP Class UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080018</TAG>' ||
'   <NAME>SOP Instance UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008001A</TAG>' ||
'   <NAME>Related General SOP Class UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008001B</TAG>' ||
'   <NAME>Original Specialized SOP Class UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080020</TAG>' ||
'   <NAME>Study Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080021</TAG>' ||
'   <NAME>Series Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080022</TAG>' ||
'   <NAME>Acquisition Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080023</TAG>' ||
'   <NAME>Content Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080024</TAG>' ||
'   <NAME>Overlay Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080025</TAG>' ||
'   <NAME>Curve Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008002A</TAG>' ||
'   <NAME>Acquisition Datetime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080030</TAG>' ||
'   <NAME>Study Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080031</TAG>' ||
'   <NAME>Series Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080032</TAG>' ||
'   <NAME>Acquisition Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080033</TAG>' ||
'   <NAME>Content Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080034</TAG>' ||
'   <NAME>Overlay Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080035</TAG>' ||
'   <NAME>Curve Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080040</TAG>' ||
'   <NAME>Data Set Type</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080041</TAG>' ||
'   <NAME>Data Set Subtype</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080042</TAG>' ||
'   <NAME>Nuclear Medicine Series Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080050</TAG>' ||
'   <NAME>Accession Number</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080052</TAG>' ||
'   <NAME>Query/Retrieve Level</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080054</TAG>' ||
'   <NAME>Retrieve AE Title</NAME>' ||
'   <VR>AE</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080056</TAG>' ||
'   <NAME>Instance Availability</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080058</TAG>' ||
'   <NAME>Failed SOP Instance UID List</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080060</TAG>' ||
'   <NAME>Modality</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080061</TAG>' ||
'   <NAME>Modalities in Study</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080062</TAG>' ||
'   <NAME>SOP Classes in Study</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080064</TAG>' ||
'   <NAME>Conversion Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080068</TAG>' ||
'   <NAME>Presentation Intent Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080070</TAG>' ||
'   <NAME>Manufacturer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080080</TAG>' ||
'   <NAME>Institution Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080081</TAG>' ||
'   <NAME>Institution Address</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080082</TAG>' ||
'   <NAME>Institution Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080090</TAG>' ||
'   <NAME>Referring Physician''s Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080092</TAG>' ||
'   <NAME>Referring Physician''s Address</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080094</TAG>' ||
'   <NAME>Referring Physician''s Telephone Numbers</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080096</TAG>' ||
'   <NAME>Referring Physician Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080100</TAG>' ||
'   <NAME>Code Value</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080102</TAG>' ||
'   <NAME>Coding Scheme Designator</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080103</TAG>' ||
'   <NAME>Coding Scheme Version</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080104</TAG>' ||
'   <NAME>Code Meaning</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080105</TAG>' ||
'   <NAME>Mapping Resource</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080106</TAG>' ||
'   <NAME>Context Group Version</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080107</TAG>' ||
'   <NAME>Context Group Local Version</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008010B</TAG>' ||
'   <NAME>Context Group Extension Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008010C</TAG>' ||
'   <NAME>Coding Scheme UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008010D</TAG>' ||
'   <NAME>Context Group Extension Creator UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008010F</TAG>' ||
'   <NAME>Context Identifier</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080110</TAG>' ||
'   <NAME>Coding Scheme Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080112</TAG>' ||
'   <NAME>Coding Scheme Registry</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080114</TAG>' ||
'   <NAME>Coding Scheme External ID</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080115</TAG>' ||
'   <NAME>Coding Scheme Name</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080116</TAG>' ||
'   <NAME>Responsible Organization</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00080201</TAG>' ||
'   <NAME>Timezone Offset From UTC</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081000</TAG>' ||
'   <NAME>Network ID</NAME>' ||
'   <VR>AE</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081010</TAG>' ||
'   <NAME>Station Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081030</TAG>' ||
'   <NAME>Study Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081032</TAG>' ||
'   <NAME>Procedure Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008103E</TAG>' ||
'   <NAME>Series Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081040</TAG>' ||
'   <NAME>Institutional Department Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081048</TAG>' ||
'   <NAME>Physician(s) of Record</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081049</TAG>' ||
'   <NAME>Physician(s) of Record Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081050</TAG>' ||
'   <NAME>Performing Physician''s Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081052</TAG>' ||
'   <NAME>Performing Physician Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081060</TAG>' ||
'   <NAME>Name of Physician(s) Reading Study</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081062</TAG>' ||
'   <NAME>Physician(s) Reading Study Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081070</TAG>' ||
'   <NAME>Operators'' Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081072</TAG>' ||
'   <NAME>Operator Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081080</TAG>' ||
'   <NAME>Admitting Diagnoses Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081084</TAG>' ||
'   <NAME>Admitting Diagnoses Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081090</TAG>' ||
'   <NAME>Manufacturer''s Model Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081100</TAG>' ||
'   <NAME>Referenced Results Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081110</TAG>' ||
'   <NAME>Referenced Study Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081111</TAG>' ||
'   <NAME>Referenced Performed Procedure Step Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081115</TAG>' ||
'   <NAME>Referenced Series Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081120</TAG>' ||
'   <NAME>Referenced Patient Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081125</TAG>' ||
'   <NAME>Referenced Visit Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081130</TAG>' ||
'   <NAME>Referenced Overlay Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008113A</TAG>' ||
'   <NAME>Referenced Waveform Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081140</TAG>' ||
'   <NAME>Referenced Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081145</TAG>' ||
'   <NAME>Referenced Curve Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008114A</TAG>' ||
'   <NAME>Referenced Instance Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008114B</TAG>' ||
'   <NAME>Referenced Real World Value Mapping Instance Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081150</TAG>' ||
'   <NAME>Referenced SOP Class UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081155</TAG>' ||
'   <NAME>Referenced SOP Instance UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008115A</TAG>' ||
'   <NAME>SOP Classes Supported</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081160</TAG>' ||
'   <NAME>Referenced Frame Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081195</TAG>' ||
'   <NAME>Transaction UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081197</TAG>' ||
'   <NAME>Failure Reason</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081198</TAG>' ||
'   <NAME>Failed SOP Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081199</TAG>' ||
'   <NAME>Referenced SOP Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081200</TAG>' ||
'   <NAME>Studies Containing Other Referenced Instances Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00081250</TAG>' ||
'   <NAME>Related Series Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082110</TAG>' ||
'   <NAME>Lossy Image Compression</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082111</TAG>' ||
'   <NAME>Derivation Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082112</TAG>' ||
'   <NAME>Source Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082120</TAG>' ||
'   <NAME>Stage Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082122</TAG>' ||
'   <NAME>Stage Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082124</TAG>' ||
'   <NAME>Number of Stages</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082127</TAG>' ||
'   <NAME>View Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082128</TAG>' ||
'   <NAME>View Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082129</TAG>' ||
'   <NAME>Number of Event Timers</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0008212A</TAG>' ||
'   <NAME>Number of Views in Stage</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082130</TAG>' ||
'   <NAME>Event Elapsed Time(s)</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082132</TAG>' ||
'   <NAME>Event Timer Name(s)</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082142</TAG>' ||
'   <NAME>Start Trim</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082143</TAG>' ||
'   <NAME>Stop Trim</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082144</TAG>' ||
'   <NAME>Recommended Display Frame Rate</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082200</TAG>' ||
'   <NAME>Transducer Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082204</TAG>' ||
'   <NAME>Transducer Orientation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082208</TAG>' ||
'   <NAME>Anatomic Structure</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082218</TAG>' ||
'   <NAME>Anatomic Region Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082220</TAG>' ||
'   <NAME>Anatomic Region Modifier Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082228</TAG>' ||
'   <NAME>Primary Anatomic Structure Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082229</TAG>' ||
'   <NAME>Anatomic Structure, Space or Region Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082230</TAG>' ||
'   <NAME>Primary Anatomic Structure Modifier Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082240</TAG>' ||
'   <NAME>Transducer Position Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082242</TAG>' ||
'   <NAME>Transducer Position Modifier Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082244</TAG>' ||
'   <NAME>Transducer Orientation Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00082246</TAG>' ||
'   <NAME>Transducer Orientation Modifier Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00083001</TAG>' ||
'   <NAME>Alternate Representation Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00083010</TAG>' ||
'   <NAME>Irradiation Event UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00084000</TAG>' ||
'   <NAME>Identifying Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089007</TAG>' ||
'   <NAME>Frame Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>4</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089092</TAG>' ||
'   <NAME>Referenced Image Evidence Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089121</TAG>' ||
'   <NAME>Referenced Raw Data Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089123</TAG>' ||
'   <NAME>Creator-Version UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089124</TAG>' ||
'   <NAME>Derivation Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089154</TAG>' ||
'   <NAME>Source Image Evidence Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089205</TAG>' ||
'   <NAME>Pixel Presentation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089206</TAG>' ||
'   <NAME>Volumetric Properties</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089207</TAG>' ||
'   <NAME>Volume Based Calculation Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089208</TAG>' ||
'   <NAME>Complex Image Component</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089209</TAG>' ||
'   <NAME>Acquisition Contrast</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089215</TAG>' ||
'   <NAME>Derivation Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089237</TAG>' ||
'   <NAME>Referenced Grayscale Presentation State Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089410</TAG>' ||
'   <NAME>Referenced Other Plane Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089458</TAG>' ||
'   <NAME>Frame Display Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089459</TAG>' ||
'   <NAME>Recommended Display Frame Rate in Float</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00089460</TAG>' ||
'   <NAME>Skip Frame Range Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ;

 sys.dbms_lob.write(ordClob, length(ordcmXml), 1, ordcmXml);

  ordcmXml := 
'   <TAG>00100010</TAG>' ||
'   <NAME>Patient''s Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00100020</TAG>' ||
'   <NAME>Patient ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00100021</TAG>' ||
'   <NAME>Issuer of Patient ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00100022</TAG>' ||
'   <NAME>Type of Patient ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00100030</TAG>' ||
'   <NAME>Patient''s Birth Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00100032</TAG>' ||
'   <NAME>Patient''s Birth Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00100040</TAG>' ||
'   <NAME>Patient''s Sex</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00100050</TAG>' ||
'   <NAME>Patient''s Insurance Plan Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00100101</TAG>' ||
'   <NAME>Patient''s Primary Language Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00100102</TAG>' ||
'   <NAME>Patient''s Primary Language Code Modifier Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101000</TAG>' ||
'   <NAME>Other Patient IDs</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101001</TAG>' ||
'   <NAME>Other Patient Names</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101002</TAG>' ||
'   <NAME>Other Patient IDs Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101005</TAG>' ||
'   <NAME>Patient''s Birth Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101010</TAG>' ||
'   <NAME>Patient''s Age</NAME>' ||
'   <VR>AS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101020</TAG>' ||
'   <NAME>Patient''s Size</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101030</TAG>' ||
'   <NAME>Patient''s Weight</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101040</TAG>' ||
'   <NAME>Patient''s Address</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101050</TAG>' ||
'   <NAME>Insurance Plan Identification</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101060</TAG>' ||
'   <NAME>Patient''s Mother''s Birth Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101080</TAG>' ||
'   <NAME>Military Rank</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101081</TAG>' ||
'   <NAME>Branch of Service</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00101090</TAG>' ||
'   <NAME>Medical Record Locator</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102000</TAG>' ||
'   <NAME>Medical Alerts</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102110</TAG>' ||
'   <NAME>Contrast Allergies</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102150</TAG>' ||
'   <NAME>Country of Residence</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102152</TAG>' ||
'   <NAME>Region of Residence</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102154</TAG>' ||
'   <NAME>Patient''s Telephone Numbers</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102160</TAG>' ||
'   <NAME>Ethnic Group</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102180</TAG>' ||
'   <NAME>Occupation</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>001021A0</TAG>' ||
'   <NAME>Smoking Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>001021B0</TAG>' ||
'   <NAME>Additional Patient History</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>001021C0</TAG>' ||
'   <NAME>Pregnancy Status</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>001021D0</TAG>' ||
'   <NAME>Last Menstrual Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>001021F0</TAG>' ||
'   <NAME>Patient''s Religious Preference</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102201</TAG>' ||
'   <NAME>Patient Species Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102202</TAG>' ||
'   <NAME>Patient Species Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102203</TAG>' ||
'   <NAME>Patient''s Sex Neutered</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102292</TAG>' ||
'   <NAME>Patient Breed Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102293</TAG>' ||
'   <NAME>Patient Breed Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102294</TAG>' ||
'   <NAME>Breed Registration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102295</TAG>' ||
'   <NAME>Breed Registration Number</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102296</TAG>' ||
'   <NAME>Breed Registry Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102297</TAG>' ||
'   <NAME>Responsible Person</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102298</TAG>' ||
'   <NAME>Responsible Person Role</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00102299</TAG>' ||
'   <NAME>Responsible Organization</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00104000</TAG>' ||
'   <NAME>Patient Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00109431</TAG>' ||
'   <NAME>Examined Body Thickness</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120010</TAG>' ||
'   <NAME>Clinical Trial Sponsor Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120020</TAG>' ||
'   <NAME>Clinical Trial Protocol ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120021</TAG>' ||
'   <NAME>Clinical Trial Protocol Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120030</TAG>' ||
'   <NAME>Clinical Trial Site ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120031</TAG>' ||
'   <NAME>Clinical Trial Site Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120040</TAG>' ||
'   <NAME>Clinical Trial Subject ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120042</TAG>' ||
'   <NAME>Clinical Trial Subject Reading ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120050</TAG>' ||
'   <NAME>Clinical Trial Time Point ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120051</TAG>' ||
'   <NAME>Clinical Trial Time Point Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120060</TAG>' ||
'   <NAME>Clinical Trial Coordinating Center Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120062</TAG>' ||
'   <NAME>Patient Identity Removed</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120063</TAG>' ||
'   <NAME>De-identification Method</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00120064</TAG>' ||
'   <NAME>De-identification Method Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180010</TAG>' ||
'   <NAME>Contrast/Bolus Agent</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180012</TAG>' ||
'   <NAME>Contrast/Bolus Agent Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180014</TAG>' ||
'   <NAME>Contrast/Bolus Administration Route Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180015</TAG>' ||
'   <NAME>Body Part Examined</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180020</TAG>' ||
'   <NAME>Scanning Sequence</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180021</TAG>' ||
'   <NAME>Sequence Variant</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180022</TAG>' ||
'   <NAME>Scan Options</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180023</TAG>' ||
'   <NAME>MR Acquisition Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180024</TAG>' ||
'   <NAME>Sequence Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180025</TAG>' ||
'   <NAME>Angio Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180026</TAG>' ||
'   <NAME>Intervention Drug Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180027</TAG>' ||
'   <NAME>Intervention Drug Stop Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180028</TAG>' ||
'   <NAME>Intervention Drug Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180029</TAG>' ||
'   <NAME>Intervention Drug Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018002A</TAG>' ||
'   <NAME>Additional Drug Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180030</TAG>' ||
'   <NAME>Radionuclide</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180031</TAG>' ||
'   <NAME>Radiopharmaceutical</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180032</TAG>' ||
'   <NAME>Energy Window Centerline</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180033</TAG>' ||
'   <NAME>Energy Window Total Width</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180034</TAG>' ||
'   <NAME>Intervention Drug Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180035</TAG>' ||
'   <NAME>Intervention Drug Start Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180036</TAG>' ||
'   <NAME>Intervention Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180037</TAG>' ||
'   <NAME>Therapy Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180038</TAG>' ||
'   <NAME>Intervention Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180039</TAG>' ||
'   <NAME>Therapy Description</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018003A</TAG>' ||
'   <NAME>Intervention Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180040</TAG>' ||
'   <NAME>Cine Rate</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180050</TAG>' ||
'   <NAME>Slice Thickness</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180060</TAG>' ||
'   <NAME>KVP</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180070</TAG>' ||
'   <NAME>Counts Accumulated</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180071</TAG>' ||
'   <NAME>Acquisition Termination Condition</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180072</TAG>' ||
'   <NAME>Effective Duration</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180073</TAG>' ||
'   <NAME>Acquisition Start Condition</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180074</TAG>' ||
'   <NAME>Acquisition Start Condition Data</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180075</TAG>' ||
'   <NAME>Acquisition Termination Condition Data</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180080</TAG>' ||
'   <NAME>Repetition Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180081</TAG>' ||
'   <NAME>Echo Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180082</TAG>' ||
'   <NAME>Inversion Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180083</TAG>' ||
'   <NAME>Number of Averages</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180084</TAG>' ||
'   <NAME>Imaging Frequency</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180085</TAG>' ||
'   <NAME>Imaged Nucleus</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180086</TAG>' ||
'   <NAME>Echo Number(s)</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180087</TAG>' ||
'   <NAME>Magnetic Field Strength</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180088</TAG>' ||
'   <NAME>Spacing Between Slices</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180089</TAG>' ||
'   <NAME>Number of Phase Encoding Steps</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180090</TAG>' ||
'   <NAME>Data Collection Diameter</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180091</TAG>' ||
'   <NAME>Echo Train Length</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180093</TAG>' ||
'   <NAME>Percent Sampling</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180094</TAG>' ||
'   <NAME>Percent Phase Field of View</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00180095</TAG>' ||
'   <NAME>Pixel Bandwidth</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181000</TAG>' ||
'   <NAME>Device Serial Number</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181002</TAG>' ||
'   <NAME>Device UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181003</TAG>' ||
'   <NAME>Device ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181004</TAG>' ||
'   <NAME>Plate ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181005</TAG>' ||
'   <NAME>Generator ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181006</TAG>' ||
'   <NAME>Grid ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181007</TAG>' ||
'   <NAME>Cassette ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181008</TAG>' ||
'   <NAME>Gantry ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181010</TAG>' ||
'   <NAME>Secondary Capture Device ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181011</TAG>' ||
'   <NAME>Hardcopy Creation Device ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181012</TAG>' ||
'   <NAME>Date of Secondary Capture</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181014</TAG>' ||
'   <NAME>Time of Secondary Capture</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181016</TAG>' ||
'   <NAME>Secondary Capture Device Manufacturer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181017</TAG>' ||
'   <NAME>Hardcopy Device Manufacturer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181018</TAG>' ||
'   <NAME>Secondary Capture Device Manufacturer''s Model Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181019</TAG>' ||
'   <NAME>Secondary Capture Device Software Version(s)</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018101A</TAG>' ||
'   <NAME>Hardcopy Device Software Version</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018101B</TAG>' ||
'   <NAME>Hardcopy Device Manufacturer''s Model Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181020</TAG>' ||
'   <NAME>Software Version(s)</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181022</TAG>' ||
'   <NAME>Video Image Format Acquired</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181023</TAG>' ||
'   <NAME>Digital Image Format Acquired</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181030</TAG>' ||
'   <NAME>Protocol Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181040</TAG>' ||
'   <NAME>Contrast/Bolus Route</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181041</TAG>' ||
'   <NAME>Contrast/Bolus Volume</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181042</TAG>' ||
'   <NAME>Contrast/Bolus Start Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181043</TAG>' ||
'   <NAME>Contrast/Bolus Stop Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181044</TAG>' ||
'   <NAME>Contrast/Bolus Total Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181045</TAG>' ||
'   <NAME>Syringe Counts</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181046</TAG>' ||
'   <NAME>Contrast Flow Rate</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181047</TAG>' ||
'   <NAME>Contrast Flow Duration</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181048</TAG>' ||
'   <NAME>Contrast/Bolus Ingredient</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181049</TAG>' ||
'   <NAME>Contrast/Bolus Ingredient Concentration</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181050</TAG>' ||
'   <NAME>Spatial Resolution</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181060</TAG>' ||
'   <NAME>Trigger Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181061</TAG>' ||
'   <NAME>Trigger Source or Type</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181062</TAG>' ||
'   <NAME>Nominal Interval</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181063</TAG>' ||
'   <NAME>Frame Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181064</TAG>' ||
'   <NAME>Framing Type</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181065</TAG>' ||
'   <NAME>Frame Time Vector</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181066</TAG>' ||
'   <NAME>Frame Delay</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181067</TAG>' ||
'   <NAME>Image Trigger Delay</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181068</TAG>' ||
'   <NAME>Multiplex Group Time Offset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181069</TAG>' ||
'   <NAME>Trigger Time Offset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018106A</TAG>' ||
'   <NAME>Synchronization Trigger</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018106C</TAG>' ||
'   <NAME>Synchronization Channel</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018106E</TAG>' ||
'   <NAME>Trigger Sample Position</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181070</TAG>' ||
'   <NAME>Radiopharmaceutical Route</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181071</TAG>' ||
'   <NAME>Radiopharmaceutical Volume</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181072</TAG>' ||
'   <NAME>Radiopharmaceutical Start Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'   <TAG>00181073</TAG>' ||
'   <NAME>Radiopharmaceutical Stop Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181074</TAG>' ||
'   <NAME>Radionuclide Total Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181075</TAG>' ||
'   <NAME>Radionuclide Half Life</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181076</TAG>' ||
'   <NAME>Radionuclide Positron Fraction</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181077</TAG>' ||
'   <NAME>Radiopharmaceutical Specific Activity</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181078</TAG>' ||
'   <NAME>Radiopharmaceutical Start Datetime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181079</TAG>' ||
'   <NAME>Radiopharmaceutical Stop Datetime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181080</TAG>' ||
'   <NAME>Beat Rejection Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181081</TAG>' ||
'   <NAME>Low R-R Value</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181082</TAG>' ||
'   <NAME>High R-R Value</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181083</TAG>' ||
'   <NAME>Intervals Acquired</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181084</TAG>' ||
'   <NAME>Intervals Rejected</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181085</TAG>' ||
'   <NAME>PVC Rejection</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181086</TAG>' ||
'   <NAME>Skip Beats</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181088</TAG>' ||
'   <NAME>Heart Rate</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181090</TAG>' ||
'   <NAME>Cardiac Number of Images</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181094</TAG>' ||
'   <NAME>Trigger Window</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181100</TAG>' ||
'   <NAME>Reconstruction Diameter</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181110</TAG>' ||
'   <NAME>Distance Source to Detector</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181111</TAG>' ||
'   <NAME>Distance Source to Patient</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181114</TAG>' ||
'   <NAME>Estimated Radiographic Magnification Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181120</TAG>' ||
'   <NAME>Gantry/Detector Tilt</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181121</TAG>' ||
'   <NAME>Gantry/Detector Slew</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181130</TAG>' ||
'   <NAME>Table Height</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181131</TAG>' ||
'   <NAME>Table Traverse</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181134</TAG>' ||
'   <NAME>Table Motion</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181135</TAG>' ||
'   <NAME>Table Vertical Increment</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181136</TAG>' ||
'   <NAME>Table Lateral Increment</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181137</TAG>' ||
'   <NAME>Table Longitudinal Increment</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181138</TAG>' ||
'   <NAME>Table Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018113A</TAG>' ||
'   <NAME>Table Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181140</TAG>' ||
'   <NAME>Rotation Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181141</TAG>' ||
'   <NAME>Angular Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181142</TAG>' ||
'   <NAME>Radial Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181143</TAG>' ||
'   <NAME>Scan Arc</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181144</TAG>' ||
'   <NAME>Angular Step</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181145</TAG>' ||
'   <NAME>Center of Rotation Offset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181146</TAG>' ||
'   <NAME>Rotation Offset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181147</TAG>' ||
'   <NAME>Field of View Shape</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181149</TAG>' ||
'   <NAME>Field of View Dimension(s)</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181150</TAG>' ||
'   <NAME>Exposure Time</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181151</TAG>' ||
'   <NAME>X-ray Tube Current</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181152</TAG>' ||
'   <NAME>Exposure</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181153</TAG>' ||
'   <NAME>Exposure in uAs</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181154</TAG>' ||
'   <NAME>Average Pulse Width</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181155</TAG>' ||
'   <NAME>Radiation Setting</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181156</TAG>' ||
'   <NAME>Rectification Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018115A</TAG>' ||
'   <NAME>Radiation Mode</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018115E</TAG>' ||
'   <NAME>Image and Fluoroscopy Area Dose Product</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181160</TAG>' ||
'   <NAME>Filter Type</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181161</TAG>' ||
'   <NAME>Type of Filters</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181162</TAG>' ||
'   <NAME>Intensifier Size</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181164</TAG>' ||
'   <NAME>Imager Pixel Spacing</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181166</TAG>' ||
'   <NAME>Grid</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181170</TAG>' ||
'   <NAME>Generator Power</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181180</TAG>' ||
'   <NAME>Collimator/grid Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181181</TAG>' ||
'   <NAME>Collimator Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181182</TAG>' ||
'   <NAME>Focal Distance</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181183</TAG>' ||
'   <NAME>X Focus Center</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181184</TAG>' ||
'   <NAME>Y Focus Center</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181190</TAG>' ||
'   <NAME>Focal Spot(s)</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181191</TAG>' ||
'   <NAME>Anode Target Material</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>001811A0</TAG>' ||
'   <NAME>Body Part Thickness</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>001811A2</TAG>' ||
'   <NAME>Compression Force</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181200</TAG>' ||
'   <NAME>Date of Last Calibration</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181201</TAG>' ||
'   <NAME>Time of Last Calibration</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181210</TAG>' ||
'   <NAME>Convolution Kernel</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181240</TAG>' ||
'   <NAME>Upper/Lower Pixel Values</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181242</TAG>' ||
'   <NAME>Actual Frame Duration</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181243</TAG>' ||
'   <NAME>Count Rate</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181244</TAG>' ||
'   <NAME>Preferred Playback Sequencing</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181250</TAG>' ||
'   <NAME>Receive Coil Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181251</TAG>' ||
'   <NAME>Transmit Coil Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181260</TAG>' ||
'   <NAME>Plate Type</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181261</TAG>' ||
'   <NAME>Phosphor Type</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181300</TAG>' ||
'   <NAME>Scan Velocity</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181301</TAG>' ||
'   <NAME>Whole Body Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181302</TAG>' ||
'   <NAME>Scan Length</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181310</TAG>' ||
'   <NAME>Acquisition Matrix</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>4</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181312</TAG>' ||
'   <NAME>In-plane Phase Encoding Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181314</TAG>' ||
'   <NAME>Flip Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181315</TAG>' ||
'   <NAME>Variable Flip Angle Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181316</TAG>' ||
'   <NAME>SAR</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181318</TAG>' ||
'   <NAME>dB/dt</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181400</TAG>' ||
'   <NAME>Acquisition Device Processing Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181401</TAG>' ||
'   <NAME>Acquisition Device Processing Code</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181402</TAG>' ||
'   <NAME>Cassette Orientation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181403</TAG>' ||
'   <NAME>Cassette Size</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181404</TAG>' ||
'   <NAME>Exposures on Plate</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181405</TAG>' ||
'   <NAME>Relative X-ray Exposure</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181450</TAG>' ||
'   <NAME>Column Angulation</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181460</TAG>' ||
'   <NAME>Tomo Layer Height</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181470</TAG>' ||
'   <NAME>Tomo Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181480</TAG>' ||
'   <NAME>Tomo Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181490</TAG>' ||
'   <NAME>Tomo Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181491</TAG>' ||
'   <NAME>Tomo Class</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181495</TAG>' ||
'   <NAME>Number of Tomosynthesis Source Images</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181500</TAG>' ||
'   <NAME>Positioner Motion</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181508</TAG>' ||
'   <NAME>Positioner Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181510</TAG>' ||
'   <NAME>Positioner Primary Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181511</TAG>' ||
'   <NAME>Positioner Secondary Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181520</TAG>' ||
'   <NAME>Positioner Primary Angle Increment</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181521</TAG>' ||
'   <NAME>Positioner Secondary Angle Increment</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181530</TAG>' ||
'   <NAME>Detector Primary Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181531</TAG>' ||
'   <NAME>Detector Secondary Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181600</TAG>' ||
'   <NAME>Shutter Shape</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181602</TAG>' ||
'   <NAME>Shutter Left Vertical Edge</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181604</TAG>' ||
'   <NAME>Shutter Right Vertical Edge</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181606</TAG>' ||
'   <NAME>Shutter Upper Horizontal Edge</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181608</TAG>' ||
'   <NAME>Shutter Lower Horizontal Edge</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181610</TAG>' ||
'   <NAME>Center of Circular Shutter</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181612</TAG>' ||
'   <NAME>Radius of Circular Shutter</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181620</TAG>' ||
'   <NAME>Vertices of the Polygonal Shutter</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>2-2n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181622</TAG>' ||
'   <NAME>Shutter Presentation Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181623</TAG>' ||
'   <NAME>Shutter Overlay Group</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181624</TAG>' ||
'   <NAME>Shutter Presentation Color CIELab Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181700</TAG>' ||
'   <NAME>Collimator Shape</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181702</TAG>' ||
'   <NAME>Collimator Left Vertical Edge</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181704</TAG>' ||
'   <NAME>Collimator Right Vertical Edge</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181706</TAG>' ||
'   <NAME>Collimator Upper Horizontal Edge</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181708</TAG>' ||
'   <NAME>Collimator Lower Horizontal Edge</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181710</TAG>' ||
'   <NAME>Center of Circular Collimator</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181712</TAG>' ||
'   <NAME>Radius of Circular Collimator</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181720</TAG>' ||
'   <NAME>Vertices of the Polygonal Collimator</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>2-2n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181800</TAG>' ||
'   <NAME>Acquisition Time Synchronized</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181801</TAG>' ||
'   <NAME>Time Source</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181802</TAG>' ||
'   <NAME>Time Distribution Protocol</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00181803</TAG>' ||
'   <NAME>NTP Source Address</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00182001</TAG>' ||
'   <NAME>Page Number Vector</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00182002</TAG>' ||
'   <NAME>Frame Label Vector</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00182003</TAG>' ||
'   <NAME>Frame Primary Angle Vector</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00182004</TAG>' ||
'   <NAME>Frame Secondary Angle Vector</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00182005</TAG>' ||
'   <NAME>Slice Location Vector</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00182006</TAG>' ||
'   <NAME>Display Window Label Vector</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00182010</TAG>' ||
'   <NAME>Nominal Scanned Pixel Spacing</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00182020</TAG>' ||
'   <NAME>Digitizing Device Transport Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00182030</TAG>' ||
'   <NAME>Rotation of Scanned Film</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00183100</TAG>' ||
'   <NAME>IVUS Acquisition</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00183101</TAG>' ||
'   <NAME>IVUS Pullback Rate</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00183102</TAG>' ||
'   <NAME>IVUS Gated Rate</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00183103</TAG>' ||
'   <NAME>IVUS Pullback Start Frame Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00183104</TAG>' ||
'   <NAME>IVUS Pullback Stop Frame Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00183105</TAG>' ||
'   <NAME>Lesion Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00184000</TAG>' ||
'   <NAME>Acquisition Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185000</TAG>' ||
'   <NAME>Output Power</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185010</TAG>' ||
'   <NAME>Transducer Data</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185012</TAG>' ||
'   <NAME>Focus Depth</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185020</TAG>' ||
'   <NAME>Processing Function</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185021</TAG>' ||
'   <NAME>Postprocessing Function</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185022</TAG>' ||
'   <NAME>Mechanical Index</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185024</TAG>' ||
'   <NAME>Bone Thermal Index</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185026</TAG>' ||
'   <NAME>Cranial Thermal Index</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185027</TAG>' ||
'   <NAME>Soft Tissue Thermal Index</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185028</TAG>' ||
'   <NAME>Soft Tissue-focus Thermal Index</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185029</TAG>' ||
'   <NAME>Soft Tissue-surface Thermal Index</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185030</TAG>' ||
'   <NAME>Dynamic Range</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185040</TAG>' ||
'   <NAME>Total Gain</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185050</TAG>' ||
'   <NAME>Depth of Scan Field</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185100</TAG>' ||
'   <NAME>Patient Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185101</TAG>' ||
'   <NAME>View Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185104</TAG>' ||
'   <NAME>Projection Eponymous Name Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185210</TAG>' ||
'   <NAME>Image Transformation Matrix</NAME>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'   <VR>DS</VR>' ||
'   <VM>6</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00185212</TAG>' ||
'   <NAME>Image Translation Vector</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186000</TAG>' ||
'   <NAME>Sensitivity</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186011</TAG>' ||
'   <NAME>Sequence of Ultrasound Regions</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186012</TAG>' ||
'   <NAME>Region Spatial Format</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186014</TAG>' ||
'   <NAME>Region Data Type</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186016</TAG>' ||
'   <NAME>Region Flags</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186018</TAG>' ||
'   <NAME>Region Location Min X0</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018601A</TAG>' ||
'   <NAME>Region Location Min Y0</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018601C</TAG>' ||
'   <NAME>Region Location Max X1</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018601E</TAG>' ||
'   <NAME>Region Location Max Y1</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186020</TAG>' ||
'   <NAME>Reference Pixel X0</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186022</TAG>' ||
'   <NAME>Reference Pixel Y0</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186024</TAG>' ||
'   <NAME>Physical Units X Direction</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186026</TAG>' ||
'   <NAME>Physical Units Y Direction</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186028</TAG>' ||
'   <NAME>Reference Pixel Physical Value X</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018602A</TAG>' ||
'   <NAME>Reference Pixel Physical Value Y</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018602C</TAG>' ||
'   <NAME>Physical Delta X</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018602E</TAG>' ||
'   <NAME>Physical Delta Y</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186030</TAG>' ||
'   <NAME>Transducer Frequency</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186031</TAG>' ||
'   <NAME>Transducer Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186032</TAG>' ||
'   <NAME>Pulse Repetition Frequency</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186034</TAG>' ||
'   <NAME>Doppler Correction Angle</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186036</TAG>' ||
'   <NAME>Steering Angle</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186038</TAG>' ||
'   <NAME>Doppler Sample Volume X Position</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186039</TAG>' ||
'   <NAME>Doppler Sample Volume X Position</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018603A</TAG>' ||
'   <NAME>Doppler Sample Volume Y Position</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018603B</TAG>' ||
'   <NAME>Doppler Sample Volume Y Position</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018603C</TAG>' ||
'   <NAME>TM-Line Position X0</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018603D</TAG>' ||
'   <NAME>TM-Line Position X0</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018603E</TAG>' ||
'   <NAME>TM-Line Position Y0</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018603F</TAG>' ||
'   <NAME>TM-Line Position Y0</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186040</TAG>' ||
'   <NAME>TM-Line Position X1</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186041</TAG>' ||
'   <NAME>TM-Line Position X1</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186042</TAG>' ||
'   <NAME>TM-Line Position Y1</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186043</TAG>' ||
'   <NAME>TM-Line Position Y1</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186044</TAG>' ||
'   <NAME>Pixel Component Organization</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186046</TAG>' ||
'   <NAME>Pixel Component Mask</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186048</TAG>' ||
'   <NAME>Pixel Component Range Start</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018604A</TAG>' ||
'   <NAME>Pixel Component Range Stop</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018604C</TAG>' ||
'   <NAME>Pixel Component Physical Units</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018604E</TAG>' ||
'   <NAME>Pixel Component Data Type</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186050</TAG>' ||
'   <NAME>Number of Table Break Points</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186052</TAG>' ||
'   <NAME>Table of X Break Points</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186054</TAG>' ||
'   <NAME>Table of Y Break Points</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186056</TAG>' ||
'   <NAME>Number of Table Entries</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186058</TAG>' ||
'   <NAME>Table of Pixel Values</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018605A</TAG>' ||
'   <NAME>Table of Parameter Values</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00186060</TAG>' ||
'   <NAME>R Wave Time Vector</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187000</TAG>' ||
'   <NAME>Detector Conditions Nominal Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187001</TAG>' ||
'   <NAME>Detector Temperature</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187004</TAG>' ||
'   <NAME>Detector Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187005</TAG>' ||
'   <NAME>Detector Configuration</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187006</TAG>' ||
'   <NAME>Detector Description</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187008</TAG>' ||
'   <NAME>Detector Mode</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018700A</TAG>' ||
'   <NAME>Detector ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018700C</TAG>' ||
'   <NAME>Date of Last Detector Calibration</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018700E</TAG>' ||
'   <NAME>Time of Last Detector Calibration</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187010</TAG>' ||
'   <NAME>Exposures on Detector Since Last Calibration</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187011</TAG>' ||
'   <NAME>Exposures on Detector Since Manufactured</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187012</TAG>' ||
'   <NAME>Detector Time Since Last Exposure</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187014</TAG>' ||
'   <NAME>Detector Active Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187016</TAG>' ||
'   <NAME>Detector Activation Offset From Exposure</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018701A</TAG>' ||
'   <NAME>Detector Binning</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187020</TAG>' ||
'   <NAME>Detector Element Physical Size</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187022</TAG>' ||
'   <NAME>Detector Element Spacing</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187024</TAG>' ||
'   <NAME>Detector Active Shape</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187026</TAG>' ||
'   <NAME>Detector Active Dimension(s)</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187028</TAG>' ||
'   <NAME>Detector Active Origin</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018702A</TAG>' ||
'   <NAME>Detector Manufacturer Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018702B</TAG>' ||
'   <NAME>Detector Manufacturer''s Model Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187030</TAG>' ||
'   <NAME>Field of View Origin</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187032</TAG>' ||
'   <NAME>Field of View Rotation</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187034</TAG>' ||
'   <NAME>Field of View Horizontal Flip</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187040</TAG>' ||
'   <NAME>Grid Absorbing Material</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187041</TAG>' ||
'   <NAME>Grid Spacing Material</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187042</TAG>' ||
'   <NAME>Grid Thickness</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187044</TAG>' ||
'   <NAME>Grid Pitch</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187046</TAG>' ||
'   <NAME>Grid Aspect Ratio</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187048</TAG>' ||
'   <NAME>Grid Period</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018704C</TAG>' ||
'   <NAME>Grid Focal Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187050</TAG>' ||
'   <NAME>Filter Material</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187052</TAG>' ||
'   <NAME>Filter Thickness Minimum</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187054</TAG>' ||
'   <NAME>Filter Thickness Maximum</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187060</TAG>' ||
'   <NAME>Exposure Control Mode</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187062</TAG>' ||
'   <NAME>Exposure Control Mode Description</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187064</TAG>' ||
'   <NAME>Exposure Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00187065</TAG>' ||
'   <NAME>Phototimer Setting</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00188150</TAG>' ||
'   <NAME>Exposure Time in microseconds</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00188151</TAG>' ||
'   <NAME>X-Ray Tube Current in microamps</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189004</TAG>' ||
'   <NAME>Content Qualification</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189005</TAG>' ||
'   <NAME>Pulse Sequence Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189006</TAG>' ||
'   <NAME>MR Imaging Modifier Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189008</TAG>' ||
'   <NAME>Echo Pulse Sequence</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189009</TAG>' ||
'   <NAME>Inversion Recovery</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189010</TAG>' ||
'   <NAME>Flow Compensation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189011</TAG>' ||
'   <NAME>Multiple Spin Echo</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189012</TAG>' ||
'   <NAME>Multi-planar Excitation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189014</TAG>' ||
'   <NAME>Phase Contrast</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189015</TAG>' ||
'   <NAME>Time of Flight Contrast</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189016</TAG>' ||
'   <NAME>Spoiling</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189017</TAG>' ||
'   <NAME>Steady State Pulse Sequence</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189018</TAG>' ||
'   <NAME>Echo Planar Pulse Sequence</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189019</TAG>' ||
'   <NAME>Tag Angle First Axis</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189020</TAG>' ||
'   <NAME>Magnetization Transfer</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189021</TAG>' ||
'   <NAME>T2 Preparation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189022</TAG>' ||
'   <NAME>Blood Signal Nulling</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189024</TAG>' ||
'   <NAME>Saturation Recovery</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189025</TAG>' ||
'   <NAME>Spectrally Selected Suppression</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189026</TAG>' ||
'   <NAME>Spectrally Selected Excitation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189027</TAG>' ||
'   <NAME>Spatial Pre-saturation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189028</TAG>' ||
'   <NAME>Tagging</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189029</TAG>' ||
'   <NAME>Oversampling Phase</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189030</TAG>' ||
'   <NAME>Tag Spacing First Dimension</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189032</TAG>' ||
'   <NAME>Geometry of k-Space Traversal</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189033</TAG>' ||
'   <NAME>Segmented k-Space Traversal</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189034</TAG>' ||
'   <NAME>Rectilinear Phase Encode Reordering</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189035</TAG>' ||
'   <NAME>Tag Thickness</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189036</TAG>' ||
'   <NAME>Partial Fourier Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189037</TAG>' ||
'   <NAME>Cardiac Synchronization Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189041</TAG>' ||
'   <NAME>Receive Coil Manufacturer Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189042</TAG>' ||
'   <NAME>MR Receive Coil Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189043</TAG>' ||
'   <NAME>Receive Coil Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189044</TAG>' ||
'   <NAME>Quadrature Receive Coil</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189045</TAG>' ||
'   <NAME>Multi-Coil Definition Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189046</TAG>' ||
'   <NAME>Multi-Coil Configuration</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189047</TAG>' ||
'   <NAME>Multi-Coil Element Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189048</TAG>' ||
'   <NAME>Multi-Coil Element Used</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189049</TAG>' ||
'   <NAME>MR Transmit Coil Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189050</TAG>' ||
'   <NAME>Transmit Coil Manufacturer Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189051</TAG>' ||
'   <NAME>Transmit Coil Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189052</TAG>' ||
'   <NAME>Spectral Width</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189053</TAG>' ||
'   <NAME>Chemical Shift Reference</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189054</TAG>' ||
'   <NAME>Volume Localization Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189058</TAG>' ||
'   <NAME>MR Acquisition Frequency Encoding Steps</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189059</TAG>' ||
'   <NAME>De-coupling</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189060</TAG>' ||
'   <NAME>De-coupled Nucleus</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189061</TAG>' ||
'   <NAME>De-coupling Frequency</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189062</TAG>' ||
'   <NAME>De-coupling Method</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189063</TAG>' ||
'   <NAME>De-coupling Chemical Shift Reference</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189064</TAG>' ||
'   <NAME>k-space Filtering</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189065</TAG>' ||
'   <NAME>Time Domain Filtering</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189066</TAG>' ||
'   <NAME>Number of Zero fills</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189067</TAG>' ||
'   <NAME>Baseline Correction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189069</TAG>' ||
'   <NAME>Parallel Reduction Factor In-plane</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189070</TAG>' ||
'   <NAME>Cardiac R-R Interval Specified</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189073</TAG>' ||
'   <NAME>Acquisition Duration</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189074</TAG>' ||
'   <NAME>Frame Acquisition Datetime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189075</TAG>' ||
'   <NAME>Diffusion Directionality</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189076</TAG>' ||
'   <NAME>Diffusion Gradient Direction Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189077</TAG>' ||
'   <NAME>Parallel Acquisition</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189078</TAG>' ||
'   <NAME>Parallel Acquisition Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189079</TAG>' ||
'   <NAME>Inversion Times</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189080</TAG>' ||
'   <NAME>Metabolite Map Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189081</TAG>' ||
'   <NAME>Partial Fourier</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189082</TAG>' ||
'   <NAME>Effective Echo Time</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189083</TAG>' ||
'   <NAME>Metabolite Map Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189084</TAG>' ||
'   <NAME>Chemical Shift Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189085</TAG>' ||
'   <NAME>Cardiac Signal Source</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189087</TAG>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'   <NAME>Diffusion b-value</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189089</TAG>' ||
'   <NAME>Diffusion Gradient Orientation</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189090</TAG>' ||
'   <NAME>Velocity Encoding Direction</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189091</TAG>' ||
'   <NAME>Velocity Encoding Minimum Value</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189093</TAG>' ||
'   <NAME>Number of k-Space Trajectories</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189094</TAG>' ||
'   <NAME>Coverage of k-Space</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189095</TAG>' ||
'   <NAME>Spectroscopy Acquisition Phase Rows</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189098</TAG>' ||
'   <NAME>Transmitter Frequency</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189100</TAG>' ||
'   <NAME>Resonant Nucleus</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189101</TAG>' ||
'   <NAME>Frequency Correction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189103</TAG>' ||
'   <NAME>MR Spectroscopy FOV/Geometry Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189104</TAG>' ||
'   <NAME>Slab Thickness</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189105</TAG>' ||
'   <NAME>Slab Orientation</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189106</TAG>' ||
'   <NAME>Mid Slab Position</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189107</TAG>' ||
'   <NAME>MR Spatial Saturation Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189112</TAG>' ||
'   <NAME>MR Timing and Related Parameters Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189114</TAG>' ||
'   <NAME>MR Echo Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189115</TAG>' ||
'   <NAME>MR Modifier Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189117</TAG>' ||
'   <NAME>MR Diffusion Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189118</TAG>' ||
'   <NAME>Cardiac Trigger Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189119</TAG>' ||
'   <NAME>MR Averages Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189125</TAG>' ||
'   <NAME>MR FOV/Geometry Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189126</TAG>' ||
'   <NAME>Volume Localization Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189127</TAG>' ||
'   <NAME>Spectroscopy Acquisition Data Columns</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189147</TAG>' ||
'   <NAME>Diffusion Anisotropy Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189151</TAG>' ||
'   <NAME>Frame Reference Datetime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189152</TAG>' ||
'   <NAME>MR Metabolite Map Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189155</TAG>' ||
'   <NAME>Parallel Reduction Factor out-of-plane</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189159</TAG>' ||
'   <NAME>Spectroscopy Acquisition Out-of-plane Phase Steps</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189166</TAG>' ||
'   <NAME>Bulk Motion Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189168</TAG>' ||
'   <NAME>Parallel Reduction Factor Second In-plane</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189169</TAG>' ||
'   <NAME>Cardiac Beat Rejection Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189170</TAG>' ||
'   <NAME>Respiratory Motion Compensation Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189171</TAG>' ||
'   <NAME>Respiratory Signal Source</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189172</TAG>' ||
'   <NAME>Bulk Motion Compensation Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189173</TAG>' ||
'   <NAME>Bulk Motion Signal Source</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189174</TAG>' ||
'   <NAME>Applicable Safety Standard Agency</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189175</TAG>' ||
'   <NAME>Applicable Safety Standard Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189176</TAG>' ||
'   <NAME>Operating Mode Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189177</TAG>' ||
'   <NAME>Operating Mode Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189178</TAG>' ||
'   <NAME>Operating Mode</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189179</TAG>' ||
'   <NAME>Specific Absorption Rate Definition</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189180</TAG>' ||
'   <NAME>Gradient Output Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189181</TAG>' ||
'   <NAME>Specific Absorption Rate Value</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189182</TAG>' ||
'   <NAME>Gradient Output</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189183</TAG>' ||
'   <NAME>Flow Compensation Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189184</TAG>' ||
'   <NAME>Tagging Delay</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189185</TAG>' ||
'   <NAME>Respiratory Motion Compensation Technique Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189186</TAG>' ||
'   <NAME>Respiratory Signal Source ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189195</TAG>' ||
'   <NAME>Chemical Shifts Minimum Integration Limit in Hz</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189196</TAG>' ||
'   <NAME>Chemical Shifts Maximum Integration Limit in Hz</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189197</TAG>' ||
'   <NAME>MR Velocity Encoding Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189198</TAG>' ||
'   <NAME>First Order Phase Correction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189199</TAG>' ||
'   <NAME>Water Referenced Phase Correction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189200</TAG>' ||
'   <NAME>MR Spectroscopy Acquisition Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189214</TAG>' ||
'   <NAME>Respiratory Cycle Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189217</TAG>' ||
'   <NAME>Velocity Encoding Maximum Value</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189218</TAG>' ||
'   <NAME>Tag Spacing Second Dimension</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189219</TAG>' ||
'   <NAME>Tag Angle Second Axis</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189220</TAG>' ||
'   <NAME>Frame Acquisition Duration</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189226</TAG>' ||
'   <NAME>MR Image Frame Type Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189227</TAG>' ||
'   <NAME>MR Spectroscopy Frame Type Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189231</TAG>' ||
'   <NAME>MR Acquisition Phase Encoding Steps in-plane</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189232</TAG>' ||
'   <NAME>MR Acquisition Phase Encoding Steps out-of-plane</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189234</TAG>' ||
'   <NAME>Spectroscopy Acquisition Phase Columns</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189236</TAG>' ||
'   <NAME>Cardiac Cycle Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189239</TAG>' ||
'   <NAME>Specific Absorption Rate Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189240</TAG>' ||
'   <NAME>RF Echo Train Length</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189241</TAG>' ||
'   <NAME>Gradient Echo Train Length</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189295</TAG>' ||
'   <NAME>Chemical Shifts Minimum Integration Limit in ppm</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189296</TAG>' ||
'   <NAME>Chemical Shifts Maximum Integration Limit in ppm</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189301</TAG>' ||
'   <NAME>CT Acquisition Type Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189302</TAG>' ||
'   <NAME>Acquisition Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189303</TAG>' ||
'   <NAME>Tube Angle</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189304</TAG>' ||
'   <NAME>CT Acquisition Details Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189305</TAG>' ||
'   <NAME>Revolution Time</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189306</TAG>' ||
'   <NAME>Single Collimation Width</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189307</TAG>' ||
'   <NAME>Total Collimation Width</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189308</TAG>' ||
'   <NAME>CT Table Dynamics Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189309</TAG>' ||
'   <NAME>Table Speed</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189310</TAG>' ||
'   <NAME>Table Feed per Rotation</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189311</TAG>' ||
'   <NAME>Spiral Pitch Factor</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189312</TAG>' ||
'   <NAME>CT Geometry Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189313</TAG>' ||
'   <NAME>Data Collection Center (Patient)</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189314</TAG>' ||
'   <NAME>CT Reconstruction Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189315</TAG>' ||
'   <NAME>Reconstruction Algorithm</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189316</TAG>' ||
'   <NAME>Convolution Kernel Group</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189317</TAG>' ||
'   <NAME>Reconstruction Field of View</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189318</TAG>' ||
'   <NAME>Reconstruction Target Center (Patient)</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189319</TAG>' ||
'   <NAME>Reconstruction Angle</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189320</TAG>' ||
'   <NAME>Image Filter</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189321</TAG>' ||
'   <NAME>CT Exposure Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189322</TAG>' ||
'   <NAME>Reconstruction Pixel Spacing</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189323</TAG>' ||
'   <NAME>Exposure Modulation Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189324</TAG>' ||
'   <NAME>Estimated Dose Saving</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189325</TAG>' ||
'   <NAME>CT X-ray Details Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189326</TAG>' ||
'   <NAME>CT Position Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189327</TAG>' ||
'   <NAME>Table Position</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189328</TAG>' ||
'   <NAME>Exposure Time in ms</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189329</TAG>' ||
'   <NAME>CT Image Frame Type Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189330</TAG>' ||
'   <NAME>X-Ray Tube Current in mA</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189332</TAG>' ||
'   <NAME>Exposure in mAs</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189333</TAG>' ||
'   <NAME>Constant Volume Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189334</TAG>' ||
'   <NAME>Fluoroscopy Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189335</TAG>' ||
'   <NAME>Distance Source to Data Collection Center</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189337</TAG>' ||
'   <NAME>Contrast/Bolus Agent Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189338</TAG>' ||
'   <NAME>Contrast/Bolus Ingredient Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189340</TAG>' ||
'   <NAME>Contrast Administration Profile Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189341</TAG>' ||
'   <NAME>Contrast/Bolus Usage Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189342</TAG>' ||
'   <NAME>Contrast/Bolus Agent Administered</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189343</TAG>' ||
'   <NAME>Contrast/Bolus Agent Detected</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189344</TAG>' ||
'   <NAME>Contrast/Bolus Agent Phase</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189345</TAG>' ||
'   <NAME>CTDIvol</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189401</TAG>' ||
'   <NAME>Projection Pixel Calibration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189402</TAG>' ||
'   <NAME>Distance Source to Isocenter</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189403</TAG>' ||
'   <NAME>Distance Object to Table Top</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189404</TAG>' ||
'   <NAME>Object Pixel Spacing in Center of Beam</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189405</TAG>' ||
'   <NAME>Positioner Position Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189406</TAG>' ||
'   <NAME>Table Position Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189407</TAG>' ||
'   <NAME>Collimator Shape Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189412</TAG>' ||
'   <NAME>XA/XRF Frame Characteristics Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189417</TAG>' ||
'   <NAME>Frame Acquisition Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189420</TAG>' ||
'   <NAME>X-Ray Receptor Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189423</TAG>' ||
'   <NAME>Acquisition Protocol Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189424</TAG>' ||
'   <NAME>Acquisition Protocol Description</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189425</TAG>' ||
'   <NAME>Contrast/Bolus Ingredient Opaque</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189426</TAG>' ||
'   <NAME>Distance Receptor Plane to Detector Housing</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189427</TAG>' ||
'   <NAME>Intensifier Active Shape</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189428</TAG>' ||
'   <NAME>Intensifier Active Dimension(s)</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189429</TAG>' ||
'   <NAME>Physical Detector Size</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189430</TAG>' ||
'   <NAME>Position of Isocenter Projection</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189432</TAG>' ||
'   <NAME>Field of View Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189433</TAG>' ||
'   <NAME>Field of View Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189434</TAG>' ||
'   <NAME>Exposure Control Sensing Regions Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189435</TAG>' ||
'   <NAME>Exposure Control Sensing Region Shape</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189436</TAG>' ||
'   <NAME>Exposure Control Sensing Region Left Vertical Edge</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189437</TAG>' ||
'   <NAME>Exposure Control Sensing Region Right Vertical Edge</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189438</TAG>' ||
'   <NAME>Exposure Control Sensing Region Upper Horizontal Edge</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189439</TAG>' ||
'   <NAME>Exposure Control Sensing Region Lower Horizontal Edge</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189440</TAG>' ||
'   <NAME>Center of Circular Exposure Control Sensing Region</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189441</TAG>' ||
'   <NAME>Radius of Circular Exposure Control Sensing Region</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189442</TAG>' ||
'   <NAME>Vertices of the Polygonal Exposure Control Sensing Region</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>2-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189445</TAG>' ||
'   <NAME>no_name</NAME>' ||
'   <RETIRED>true</RETIRED>' ||
' </STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189447</TAG>' ||
'   <NAME>Column Angulation (Patient)</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189449</TAG>' ||
'   <NAME>Beam Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189451</TAG>' ||
'   <NAME>Frame Detector Parameters Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189452</TAG>' ||
'   <NAME>Calculated Anatomy Thickness</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189455</TAG>' ||
'   <NAME>Calibration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189456</TAG>' ||
'   <NAME>Object Thickness Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189457</TAG>' ||
'   <NAME>Plane Identification</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189461</TAG>' ||
'   <NAME>Field of View Dimension(s) in Float</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189462</TAG>' ||
'   <NAME>Isocenter Reference System Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189463</TAG>' ||
'   <NAME>Positioner Isocenter Primary Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189464</TAG>' ||
'   <NAME>Positioner Isocenter Secondary Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189465</TAG>' ||
'   <NAME>Positioner Isocenter Detector Rotation Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189466</TAG>' ||
'   <NAME>Table X Position to Isocenter</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189467</TAG>' ||
'   <NAME>Table Y Position to Isocenter</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189468</TAG>' ||
'   <NAME>Table Z Position to Isocenter</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189469</TAG>' ||
'   <NAME>Table Horizontal Rotation Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189470</TAG>' ||
'   <NAME>Table Head Tilt Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189471</TAG>' ||
'   <NAME>Table Cradle Tilt Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189472</TAG>' ||
'   <NAME>Frame Display Shutter Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189473</TAG>' ||
'   <NAME>Acquired Image Area Dose Product</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189474</TAG>' ||
'   <NAME>C-arm Positioner Tabletop Relationship</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189476</TAG>' ||
'   <NAME>X-Ray Geometry Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00189477</TAG>' ||
'   <NAME>Irradiation Event Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018A001</TAG>' ||
'   <NAME>Contributing Equipment Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018A002</TAG>' ||
'   <NAME>Contribution Date Time</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0018A003</TAG>' ||
'   <NAME>Contribution Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0020000D</TAG>' ||
'   <NAME>Study Instance UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0020000E</TAG>' ||
'   <NAME>Series Instance UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200010</TAG>' ||
'   <NAME>Study ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200011</TAG>' ||
'   <NAME>Series Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200012</TAG>' ||
'   <NAME>Acquisition Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200013</TAG>' ||
'   <NAME>Instance Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200014</TAG>' ||
'   <NAME>Isotope Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200015</TAG>' ||
'   <NAME>Phase Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200016</TAG>' ||
'   <NAME>Interval Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200017</TAG>' ||
'   <NAME>Time Slot Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200018</TAG>' ||
'   <NAME>Angle Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200019</TAG>' ||
'   <NAME>Item Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200020</TAG>' ||
'   <NAME>Patient Orientation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200022</TAG>' ||
'   <NAME>Overlay Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200024</TAG>' ||
'   <NAME>Curve Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200026</TAG>' ||
'   <NAME>Lookup Table Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200030</TAG>' ||
'   <NAME>Image Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200032</TAG>' ||
'   <NAME>Image Position (Patient)</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200035</TAG>' ||
'   <NAME>Image Orientation</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>6</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200037</TAG>' ||
'   <NAME>Image Orientation (Patient)</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>6</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200050</TAG>' ||
'   <NAME>Location</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200052</TAG>' ||
'   <NAME>Frame of Reference UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200060</TAG>' ||
'   <NAME>Laterality</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200062</TAG>' ||
'   <NAME>Image Laterality</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200070</TAG>' ||
'   <NAME>Image Geometry Type</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200080</TAG>' ||
'   <NAME>Masking Image</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200100</TAG>' ||
'   <NAME>Temporal Position Identifier</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200105</TAG>' ||
'   <NAME>Number of Temporal Positions</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200110</TAG>' ||
'   <NAME>Temporal Resolution</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00200200</TAG>' ||
'   <NAME>Synchronization Frame of Reference UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201000</TAG>' ||
'   <NAME>Series in Study</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201001</TAG>' ||
'   <NAME>Acquisitions in Series</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201002</TAG>' ||
'   <NAME>Images in Acquisition</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201003</TAG>' ||
'   <NAME>Images in Series</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201004</TAG>' ||
'   <NAME>Acquisitions in Study</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201005</TAG>' ||
'   <NAME>Images in Study</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201020</TAG>' ||
'   <NAME>Reference</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201040</TAG>' ||
'   <NAME>Position Reference Indicator</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201041</TAG>' ||
'   <NAME>Slice Location</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201070</TAG>' ||
'   <NAME>Other Study Numbers</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201200</TAG>' ||
'   <NAME>Number of Patient Related Studies</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201202</TAG>' ||
'   <NAME>Number of Patient Related Series</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201204</TAG>' ||
'   <NAME>Number of Patient Related Instances</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201206</TAG>' ||
'   <NAME>Number of Study Related Series</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201208</TAG>' ||
'   <NAME>Number of Study Related Instances</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00201209</TAG>' ||
'   <NAME>Number of Series Related Instances</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>002031xx</TAG>' ||
'   <NAME>Source Image IDs</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00203401</TAG>' ||
'   <NAME>Modifying Device ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00203402</TAG>' ||
'   <NAME>Modified Image ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00203403</TAG>' ||
'   <NAME>Modified Image Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00203404</TAG>' ||
'   <NAME>Modifying Device Manufacturer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00203405</TAG>' ||
'   <NAME>Modified Image Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00203406</TAG>' ||
'   <NAME>Modified Image Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00204000</TAG>' ||
'   <NAME>Image Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00205000</TAG>' ||
'   <NAME>Original Image Identification</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00205002</TAG>' ||
'   <NAME>Original Image Identification Nomenclature</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209056</TAG>' ||
'   <NAME>Stack ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209057</TAG>' ||
'   <NAME>In-Stack Position Number</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209071</TAG>' ||
'   <NAME>Frame Anatomy Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209072</TAG>' ||
'   <NAME>Frame Laterality</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209111</TAG>' ||
'   <NAME>Frame Content Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209113</TAG>' ||
'   <NAME>Plane Position Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209116</TAG>' ||
'   <NAME>Plane Orientation Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209128</TAG>' ||
'   <NAME>Temporal Position Index</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209153</TAG>' ||
'   <NAME>Cardiac Trigger Delay Time</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209156</TAG>' ||
'   <NAME>Frame Acquisition Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209157</TAG>' ||
'   <NAME>Dimension Index Values</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209158</TAG>' ||
'   <NAME>Frame Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209161</TAG>' ||
'   <NAME>Concatenation UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209162</TAG>' ||
'   <NAME>In-concatenation Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209163</TAG>' ||
'   <NAME>In-concatenation Total Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209164</TAG>' ||
'   <NAME>Dimension Organization UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209165</TAG>' ||
'   <NAME>Dimension Index Pointer</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209167</TAG>' ||
'   <NAME>Functional Group Pointer</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209213</TAG>' ||
'   <NAME>Dimension Index Private Creator</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209221</TAG>' ||
'   <NAME>Dimension Organization Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209222</TAG>' ||
'   <NAME>Dimension Index Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209228</TAG>' ||
'   <NAME>Concatenation Frame Offset Number</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209238</TAG>' ||
'   <NAME>Functional Group Private Creator</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209251</TAG>' ||
'   <NAME>R - R Interval Time Measured</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209253</TAG>' ||
'   <NAME>Respiratory Trigger Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209254</TAG>' ||
'   <NAME>Respiratory Interval Time</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209255</TAG>' ||
'   <NAME>Respiratory Trigger Delay Time</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209256</TAG>' ||
'   <NAME>Respiratory Trigger Delay Threshold</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209421</TAG>' ||
'   <NAME>Dimension Description Label</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209450</TAG>' ||
'   <NAME>Patient Orientation in Frame Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00209453</TAG>' ||
'   <NAME>Frame Label</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220001</TAG>' ||
'   <NAME>Light Path Filter Pass-Through Wavelength</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220002</TAG>' ||
'   <NAME>Light Path Filter Pass Band</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220003</TAG>' ||
'   <NAME>Image Path Filter Pass-Through Wavelength</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220004</TAG>' ||
'   <NAME>Image Path Filter Pass Band</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220005</TAG>' ||
'   <NAME>Patient Eye Movement Commanded</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220006</TAG>' ||
'   <NAME>Patient Eye Movement Command Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220007</TAG>' ||
'   <NAME>Spherical Lens Power</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220008</TAG>' ||
'   <NAME>Cylinder Lens Power</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220009</TAG>' ||
'   <NAME>Cylinder Axis</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0022000A</TAG>' ||
'   <NAME>Emmetropic Magnification</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0022000B</TAG>' ||
'   <NAME>Intra Ocular Pressure</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0022000C</TAG>' ||
'   <NAME>Horizontal Field of View</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0022000D</TAG>' ||
'   <NAME>Pupil Dilated</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0022000E</TAG>' ||
'   <NAME>Degree of Dilation</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220010</TAG>' ||
'   <NAME>Stereo Baseline Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220011</TAG>' ||
'   <NAME>Stereo Baseline Displacement</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220012</TAG>' ||
'   <NAME>Stereo Horizontal Pixel Offset</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220013</TAG>' ||
'   <NAME>Stereo Vertical Pixel Offset</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220014</TAG>' ||
'   <NAME>Stereo Rotation</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220015</TAG>' ||
'   <NAME>Acquisition Device Type Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220016</TAG>' ||
'   <NAME>Illumination Type Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220017</TAG>' ||
'   <NAME>Light Path Filter Type Stack Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220018</TAG>' ||
'   <NAME>Image Path Filter Type Stack Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220019</TAG>' ||
'   <NAME>Lenses Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0022001A</TAG>' ||
'   <NAME>Channel Description Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0022001B</TAG>' ||
'   <NAME>Refractive State Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0022001C</TAG>' ||
'   <NAME>Mydriatic Agent Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0022001D</TAG>' ||
'   <NAME>Relative Image Position Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220020</TAG>' ||
'   <NAME>Stereo Pairs Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220021</TAG>' ||
'   <NAME>Left Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00220022</TAG>' ||
'   <NAME>Right Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280002</TAG>' ||
'   <NAME>Samples per Pixel</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280003</TAG>' ||
'   <NAME>Samples per Pixel Used</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280004</TAG>' ||
'   <NAME>Photometric Interpretation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280005</TAG>' ||
'   <NAME>Image Dimensions</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280006</TAG>' ||
'   <NAME>Planar Configuration</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280008</TAG>' ||
'   <NAME>Number of Frames</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280009</TAG>' ||
'   <NAME>Frame Increment Pointer</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0028000A</TAG>' ||
'   <NAME>Frame Dimension Pointer</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280010</TAG>' ||
'   <NAME>Rows</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280011</TAG>' ||
'   <NAME>Columns</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280012</TAG>' ||
'   <NAME>Planes</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280014</TAG>' ||
'   <NAME>Ultrasound Color Data Present</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280030</TAG>' ||
'   <NAME>Pixel Spacing</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280031</TAG>' ||
'   <NAME>Zoom Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280032</TAG>' ||
'   <NAME>Zoom Center</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280034</TAG>' ||
'   <NAME>Pixel Aspect Ratio</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280040</TAG>' ||
'   <NAME>Image Format</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280050</TAG>' ||
'   <NAME>Manipulated Image</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280051</TAG>' ||
'   <NAME>Corrected Image</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280060</TAG>' ||
'   <NAME>Compression Code</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280100</TAG>' ||
'   <NAME>Bits Allocated</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280101</TAG>' ||
'   <NAME>Bits Stored</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280102</TAG>' ||
'   <NAME>High Bit</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280103</TAG>' ||
'   <NAME>Pixel Representation</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280104</TAG>' ||
'   <NAME>Smallest Valid Pixel Value</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280105</TAG>' ||
'   <NAME>Largest Valid Pixel Value</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280106</TAG>' ||
'   <NAME>Smallest Image Pixel Value</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280107</TAG>' ||
'   <NAME>Largest Image Pixel Value</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280108</TAG>' ||
'   <NAME>Smallest Pixel Value in Series</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280109</TAG>' ||
'   <NAME>Largest Pixel Value in Series</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280110</TAG>' ||
'   <NAME>Smallest Image Pixel Value in Plane</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280111</TAG>' ||
'   <NAME>Largest Image Pixel Value in Plane</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280120</TAG>' ||
'   <NAME>Pixel Padding Value</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280200</TAG>' ||
'   <NAME>Image Location</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280300</TAG>' ||
'   <NAME>Quality Control Image</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280301</TAG>' ||
'   <NAME>Burned In Annotation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280402</TAG>' ||
'   <NAME>Pixel Spacing Calibration Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00280404</TAG>' ||
'   <NAME>Pixel Spacing Calibration Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281040</TAG>' ||
'   <NAME>Pixel Intensity Relationship</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281041</TAG>' ||
'   <NAME>Pixel Intensity Relationship Sign</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281050</TAG>' ||
'   <NAME>Window Center</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281051</TAG>' ||
'   <NAME>Window Width</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281052</TAG>' ||
'   <NAME>Rescale Intercept</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281053</TAG>' ||
'   <NAME>Rescale Slope</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281054</TAG>' ||
'   <NAME>Rescale Type</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281055</TAG>' ||
'   <NAME>Window Center and Width Explanation</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281056</TAG>' ||
'   <NAME>VOI LUT Function</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281080</TAG>' ||
'   <NAME>Gray Scale</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281090</TAG>' ||
'   <NAME>Recommended Viewing Mode</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281100</TAG>' ||
'   <NAME>Gray Lookup Table Descriptor</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>3</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281101</TAG>' ||
'   <NAME>Red Palette Color Lookup Table Descriptor</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281102</TAG>' ||
'   <NAME>Green Palette Color Lookup Table Descriptor</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281103</TAG>' ||
'   <NAME>Blue Palette Color Lookup Table Descriptor</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281199</TAG>' ||
'   <NAME>Palette Color Lookup Table UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281200</TAG>' ||
'   <NAME>Gray Lookup Table Data</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281201</TAG>' ||
'   <NAME>Red Palette Color Lookup Table Data</NAME>' ||
'   <VR>OW</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281202</TAG>' ||
'   <NAME>Green Palette Color Lookup Table Data</NAME>' ||
'   <VR>OW</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281203</TAG>' ||
'   <NAME>Blue Palette Color Lookup Table Data</NAME>' ||
'   <VR>OW</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281221</TAG>' ||
'   <NAME>Segmented Red Palette Color Lookup Table Data</NAME>' ||
'   <VR>OW</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281222</TAG>' ||
'   <NAME>Segmented Green Palette Color Lookup Table Data</NAME>' ||
'   <VR>OW</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281223</TAG>' ||
'   <NAME>Segmented Blue Palette Color Lookup Table Data</NAME>' ||
'   <VR>OW</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281300</TAG>' ||
'   <NAME>Implant Present</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281350</TAG>' ||
'   <NAME>Partial View</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281351</TAG>' ||
'   <NAME>Partial View Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00281352</TAG>' ||
'   <NAME>Partial View Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0028135A</TAG>' ||
'   <NAME>Spatial Locations Preserved</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00282000</TAG>' ||
'   <NAME>ICC Profile</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00282110</TAG>' ||
'   <NAME>Lossy Image Compression</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00282112</TAG>' ||
'   <NAME>Lossy Image Compression Ratio</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00282114</TAG>' ||
'   <NAME>Lossy Image Compression Method</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00283000</TAG>' ||
'   <NAME>Modality LUT Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00283002</TAG>' ||
'   <NAME>LUT Descriptor</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00283003</TAG>' ||
'   <NAME>LUT Explanation</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00283004</TAG>' ||
'   <NAME>Modality LUT Type</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00283006</TAG>' ||
'   <NAME>LUT Data</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00283010</TAG>' ||
'   <NAME>VOI LUT Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00283110</TAG>' ||
'   <NAME>Softcopy VOI LUT Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00284000</TAG>' ||
'   <NAME>Image Presentation Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00285000</TAG>' ||
'   <NAME>Bi-Plane Acquisition Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286010</TAG>' ||
'   <NAME>Representative Frame Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286020</TAG>' ||
'   <NAME>Frame Numbers of Interest (FOI)</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286022</TAG>' ||
'   <NAME>Frame(s) of Interest Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286023</TAG>' ||
'   <NAME>Frame of Interest Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286030</TAG>' ||
'   <NAME>Mask Pointer(s)</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286040</TAG>' ||
'   <NAME>R Wave Pointer</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286100</TAG>' ||
'   <NAME>Mask Subtraction Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286101</TAG>' ||
'   <NAME>Mask Operation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286102</TAG>' ||
'   <NAME>Applicable Frame Range</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>2-2n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286110</TAG>' ||
'   <NAME>Mask Frame Numbers</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286112</TAG>' ||
'   <NAME>Contrast Frame Averaging</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286114</TAG>' ||
'   <NAME>Mask Sub-pixel Shift</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286120</TAG>' ||
'   <NAME>TID Offset</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00286190</TAG>' ||
'   <NAME>Mask Operation Explanation</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00287FE0</TAG>' ||
'   <NAME>Pixel Data Provider URL</NAME>' ||
'   <VR>UT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289001</TAG>' ||
'   <NAME>Data Point Rows</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289002</TAG>' ||
'   <NAME>Data Point Columns</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289003</TAG>' ||
'   <NAME>Signal Domain Columns</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289099</TAG>' ||
'   <NAME>Largest Monochrome Pixel Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289108</TAG>' ||
'   <NAME>Data Representation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289110</TAG>' ||
'   <NAME>Pixel Measures Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289132</TAG>' ||
'   <NAME>Frame VOI LUT Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289145</TAG>' ||
'   <NAME>Pixel Value Transformation Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289235</TAG>' ||
'   <NAME>Signal Domain Rows</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289411</TAG>' ||
'   <NAME>Display Filter Percentage</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289415</TAG>' ||
'   <NAME>Frame Pixel Shift Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289416</TAG>' ||
'   <NAME>Subtraction Item ID</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289422</TAG>' ||
'   <NAME>Pixel Intensity Relationship LUT Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289443</TAG>' ||
'   <NAME>Frame Pixel Data Properties Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289444</TAG>' ||
'   <NAME>Geometrical Properties</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289445</TAG>' ||
'   <NAME>Geometric Maximum Distortion</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289446</TAG>' ||
'   <NAME>Image Processing Applied</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289454</TAG>' ||
'   <NAME>Mask Selection Mode</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00289474</TAG>' ||
'   <NAME>LUT Function</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0032000A</TAG>' ||
'   <NAME>Study Status ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0032000C</TAG>' ||
'   <NAME>Study Priority ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00320012</TAG>' ||
'   <NAME>Study ID Issuer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00320032</TAG>' ||
'   <NAME>Study Verified Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00320033</TAG>' ||
'   <NAME>Study Verified Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00320034</TAG>' ||
'   <NAME>Study Read Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00320035</TAG>' ||
'   <NAME>Study Read Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321000</TAG>' ||
'   <NAME>Scheduled Study Start Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321001</TAG>' ||
'   <NAME>Scheduled Study Start Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321010</TAG>' ||
'   <NAME>Scheduled Study Stop Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321011</TAG>' ||
'   <NAME>Scheduled Study Stop Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321020</TAG>' ||
'   <NAME>Scheduled Study Location</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321021</TAG>' ||
'   <NAME>Scheduled Study Location AE Title</NAME>' ||
'   <VR>AE</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321030</TAG>' ||
'   <NAME>Reason for Study</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321031</TAG>' ||
'   <NAME>Requesting Physician Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321032</TAG>' ||
'   <NAME>Requesting Physician</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321033</TAG>' ||
'   <NAME>Requesting Service</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321040</TAG>' ||
'   <NAME>Study Arrival Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321041</TAG>' ||
'   <NAME>Study Arrival Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321050</TAG>' ||
'   <NAME>Study Completion Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321051</TAG>' ||
'   <NAME>Study Completion Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321055</TAG>' ||
'   <NAME>Study Component Status ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321060</TAG>' ||
'   <NAME>Requested Procedure Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321064</TAG>' ||
'   <NAME>Requested Procedure Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00321070</TAG>' ||
'   <NAME>Requested Contrast Agent</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00324000</TAG>' ||
'   <NAME>Study Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380004</TAG>' ||
'   <NAME>Referenced Patient Alias Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380008</TAG>' ||
'   <NAME>Visit Status ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380010</TAG>' ||
'   <NAME>Admission ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380011</TAG>' ||
'   <NAME>Issuer of Admission ID</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380016</TAG>' ||
'   <NAME>Route of Admissions</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0038001A</TAG>' ||
'   <NAME>Scheduled Admission Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0038001B</TAG>' ||
'   <NAME>Scheduled Admission Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0038001C</TAG>' ||
'   <NAME>Scheduled Discharge Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0038001D</TAG>' ||
'   <NAME>Scheduled Discharge Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0038001E</TAG>' ||
'   <NAME>Scheduled Patient Institution Residence</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380020</TAG>' ||
'   <NAME>Admitting Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380021</TAG>' ||
'   <NAME>Admitting Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380030</TAG>' ||
'   <NAME>Discharge Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380032</TAG>' ||
'   <NAME>Discharge Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380040</TAG>' ||
'   <NAME>Discharge Diagnosis Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380044</TAG>' ||
'   <NAME>Discharge Diagnosis Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380050</TAG>' ||
'   <NAME>Special Needs</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380100</TAG>' ||
'   <NAME>Pertinent Documents Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380300</TAG>' ||
'   <NAME>Current Patient Location</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380400</TAG>' ||
'   <NAME>Patient''s Institution Residence</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380500</TAG>' ||
'   <NAME>Patient State</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00380502</TAG>' ||
'   <NAME>Patient Clinical Trial Participation Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00384000</TAG>' ||
'   <NAME>Visit Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0004</TAG>' ||
'   <NAME>Waveform Originality</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0005</TAG>' ||
'   <NAME>Number of Waveform Channels</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0010</TAG>' ||
'   <NAME>Number of Waveform Samples</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A001A</TAG>' ||
'   <NAME>Sampling Frequency</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0020</TAG>' ||
'   <NAME>Multiplex Group Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0200</TAG>' ||
'   <NAME>Channel Definition Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0202</TAG>' ||
'   <NAME>Waveform Channel Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0203</TAG>' ||
'   <NAME>Channel Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0205</TAG>' ||
'   <NAME>Channel Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0208</TAG>' ||
'   <NAME>Channel Source Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0209</TAG>' ||
'   <NAME>Channel Source Modifiers Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A020A</TAG>' ||
'   <NAME>Source Waveform Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A020C</TAG>' ||
'   <NAME>Channel Derivation Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0210</TAG>' ||
'   <NAME>Channel Sensitivity</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0211</TAG>' ||
'   <NAME>Channel Sensitivity Units Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'   <TAG>003A0212</TAG>' ||
'   <NAME>Channel Sensitivity Correction Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0213</TAG>' ||
'   <NAME>Channel Baseline</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0214</TAG>' ||
'   <NAME>Channel Time Skew</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0215</TAG>' ||
'   <NAME>Channel Sample Skew</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0218</TAG>' ||
'   <NAME>Channel Offset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A021A</TAG>' ||
'   <NAME>Waveform Bits Stored</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0220</TAG>' ||
'   <NAME>Filter Low Frequency</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0221</TAG>' ||
'   <NAME>Filter High Frequency</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0222</TAG>' ||
'   <NAME>Notch Filter Frequency</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0223</TAG>' ||
'   <NAME>Notch Filter Bandwidth</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0300</TAG>' ||
'   <NAME>Multiplexed Audio Channels Description Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0301</TAG>' ||
'   <NAME>Channel Identification Code</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>003A0302</TAG>' ||
'   <NAME>Channel Mode</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400001</TAG>' ||
'   <NAME>Scheduled Station AE Title</NAME>' ||
'   <VR>AE</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400002</TAG>' ||
'   <NAME>Scheduled Procedure Step Start Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400003</TAG>' ||
'   <NAME>Scheduled Procedure Step Start Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400004</TAG>' ||
'   <NAME>Scheduled Procedure Step End Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400005</TAG>' ||
'   <NAME>Scheduled Procedure Step End Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400006</TAG>' ||
'   <NAME>Scheduled Performing Physician''s Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400007</TAG>' ||
'   <NAME>Scheduled Procedure Step Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400008</TAG>' ||
'   <NAME>Scheduled Protocol Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400009</TAG>' ||
'   <NAME>Scheduled Procedure Step ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040000A</TAG>' ||
'   <NAME>Stage Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040000B</TAG>' ||
'   <NAME>Scheduled Performing Physician Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400010</TAG>' ||
'   <NAME>Scheduled Station Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400011</TAG>' ||
'   <NAME>Scheduled Procedure Step Location</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400012</TAG>' ||
'   <NAME>Pre-Medication</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400020</TAG>' ||
'   <NAME>Scheduled Procedure Step Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400100</TAG>' ||
'   <NAME>Scheduled Procedure Step Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400220</TAG>' ||
'   <NAME>Referenced Non-Image Composite SOP Instance Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400241</TAG>' ||
'   <NAME>Performed Station AE Title</NAME>' ||
'   <VR>AE</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400242</TAG>' ||
'   <NAME>Performed Station Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400243</TAG>' ||
'   <NAME>Performed Location</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400244</TAG>' ||
'   <NAME>Performed Procedure Step Start Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400245</TAG>' ||
'   <NAME>Performed Procedure Step Start Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400250</TAG>' ||
'   <NAME>Performed Procedure Step End Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400251</TAG>' ||
'   <NAME>Performed Procedure Step End Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400252</TAG>' ||
'   <NAME>Performed Procedure Step Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400253</TAG>' ||
'   <NAME>Performed Procedure Step ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400254</TAG>' ||
'   <NAME>Performed Procedure Step Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400255</TAG>' ||
'   <NAME>Performed Procedure Type Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400260</TAG>' ||
'   <NAME>Performed Protocol Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400270</TAG>' ||
'   <NAME>Scheduled Step Attributes Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400275</TAG>' ||
'   <NAME>Request Attributes Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400280</TAG>' ||
'   <NAME>Comments on the Performed Procedure Step</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400281</TAG>' ||
'   <NAME>Performed Procedure Step Discontinuation Reason Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400293</TAG>' ||
'   <NAME>Quantity Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400294</TAG>' ||
'   <NAME>Quantity</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400295</TAG>' ||
'   <NAME>Measuring Units Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400296</TAG>' ||
'   <NAME>Billing Item Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400300</TAG>' ||
'   <NAME>Total Time of Fluoroscopy</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400301</TAG>' ||
'   <NAME>Total Number of Exposures</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400302</TAG>' ||
'   <NAME>Entrance Dose</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400303</TAG>' ||
'   <NAME>Exposed Area</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400306</TAG>' ||
'   <NAME>Distance Source to Entrance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400307</TAG>' ||
'   <NAME>Distance Source to Support</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040030E</TAG>' ||
'   <NAME>Exposure Dose Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400310</TAG>' ||
'   <NAME>Comments on Radiation Dose</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400312</TAG>' ||
'   <NAME>X-Ray Output</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400314</TAG>' ||
'   <NAME>Half Value Layer</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400316</TAG>' ||
'   <NAME>Organ Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400318</TAG>' ||
'   <NAME>Organ Exposed</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400320</TAG>' ||
'   <NAME>Billing Procedure Step Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400321</TAG>' ||
'   <NAME>Film Consumption Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400324</TAG>' ||
'   <NAME>Billing Supplies and Devices Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400330</TAG>' ||
'   <NAME>Referenced Procedure Step Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400340</TAG>' ||
'   <NAME>Performed Series Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400400</TAG>' ||
'   <NAME>Comments on the Scheduled Procedure Step</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400440</TAG>' ||
'   <NAME>Protocol Context Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400441</TAG>' ||
'   <NAME>Content Item Modifier Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040050A</TAG>' ||
'   <NAME>Specimen Accession Number</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400550</TAG>' ||
'   <NAME>Specimen Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400551</TAG>' ||
'   <NAME>Specimen Identifier</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400555</TAG>' ||
'   <NAME>Acquisition Context Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00400556</TAG>' ||
'   <NAME>Acquisition Context Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040059A</TAG>' ||
'   <NAME>Specimen Type Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>004006FA</TAG>' ||
'   <NAME>Slide Identifier</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040071A</TAG>' ||
'   <NAME>Image Center Point Coordinates Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040072A</TAG>' ||
'   <NAME>X offset in Slide Coordinate System</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040073A</TAG>' ||
'   <NAME>Y offset in Slide Coordinate System</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040074A</TAG>' ||
'   <NAME>Z offset in Slide Coordinate System</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>004008D8</TAG>' ||
'   <NAME>Pixel Spacing Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>004008DA</TAG>' ||
'   <NAME>Coordinate System Axis Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>004008EA</TAG>' ||
'   <NAME>Measurement Units Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401001</TAG>' ||
'   <NAME>Requested Procedure ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401002</TAG>' ||
'   <NAME>Reason for the Requested Procedure</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401003</TAG>' ||
'   <NAME>Requested Procedure Priority</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401004</TAG>' ||
'   <NAME>Patient Transport Arrangements</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401005</TAG>' ||
'   <NAME>Requested Procedure Location</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401006</TAG>' ||
'   <NAME>Placer Order Number / Procedure</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401007</TAG>' ||
'   <NAME>Filler Order Number / Procedure</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401008</TAG>' ||
'   <NAME>Confidentiality Code</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401009</TAG>' ||
'   <NAME>Reporting Priority</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040100A</TAG>' ||
'   <NAME>Reason for Requested Procedure Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401010</TAG>' ||
'   <NAME>Names of Intended Recipients of Results</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401011</TAG>' ||
'   <NAME>Intended Recipients of Results Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401101</TAG>' ||
'   <NAME>Person Identification Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401102</TAG>' ||
'   <NAME>Person''s Address</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401103</TAG>' ||
'   <NAME>Person''s Telephone Numbers</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00401400</TAG>' ||
'   <NAME>Requested Procedure Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402001</TAG>' ||
'   <NAME>Reason for the Imaging Service Request</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402004</TAG>' ||
'   <NAME>Issue Date of Imaging Service Request</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402005</TAG>' ||
'   <NAME>Issue Time of Imaging Service Request</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402006</TAG>' ||
'   <NAME>Placer Order Number / Imaging Service Request</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402007</TAG>' ||
'   <NAME>Filler Order Number / Imaging Service Request</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402008</TAG>' ||
'   <NAME>Order Entered By</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402009</TAG>' ||
'   <NAME>Order Enterer''s Location</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402010</TAG>' ||
'   <NAME>Order Callback Phone Number</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402016</TAG>' ||
'   <NAME>Placer Order Number / Imaging Service Request</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402017</TAG>' ||
'   <NAME>Filler Order Number / Imaging Service Request</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00402400</TAG>' ||
'   <NAME>Imaging Service Request Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00403001</TAG>' ||
'   <NAME>Confidentiality Constraint on Patient Data Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404001</TAG>' ||
'   <NAME>General Purpose Scheduled Procedure Step Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404002</TAG>' ||
'   <NAME>General Purpose Performed Procedure Step Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404003</TAG>' ||
'   <NAME>General Purpose Scheduled Procedure Step Priority</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404004</TAG>' ||
'   <NAME>Scheduled Processing Applications Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404005</TAG>' ||
'   <NAME>Scheduled Procedure Step Start Date and Time</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404006</TAG>' ||
'   <NAME>Multiple Copies Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404007</TAG>' ||
'   <NAME>Performed Processing Applications Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404009</TAG>' ||
'   <NAME>Human Performer Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404010</TAG>' ||
'   <NAME>Scheduled Procedure Step Modification Date and Time</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404011</TAG>' ||
'   <NAME>Expected Completion Date and Time</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404015</TAG>' ||
'   <NAME>Resulting General Purpose Performed Procedure Steps Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404016</TAG>' ||
'   <NAME>Referenced General Purpose Scheduled Procedure Step Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404018</TAG>' ||
'   <NAME>Scheduled Workitem Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404019</TAG>' ||
'   <NAME>Performed Workitem Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404020</TAG>' ||
'   <NAME>Input Availability Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404021</TAG>' ||
'   <NAME>Input Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404022</TAG>' ||
'   <NAME>Relevant Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404023</TAG>' ||
'   <NAME>Referenced General Purpose Scheduled Procedure Step Transaction UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404025</TAG>' ||
'   <NAME>Scheduled Station Name Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404026</TAG>' ||
'   <NAME>Scheduled Station Class Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404027</TAG>' ||
'   <NAME>Scheduled Station Geographic Location Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404028</TAG>' ||
'   <NAME>Performed Station Name Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404029</TAG>' ||
'   <NAME>Performed Station Class Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404030</TAG>' ||
'   <NAME>Performed Station Geographic Location Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404031</TAG>' ||
'   <NAME>Requested Subsequent Workitem Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404032</TAG>' ||
'   <NAME>Non-DICOM Output Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404033</TAG>' ||
'   <NAME>Output Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404034</TAG>' ||
'   <NAME>Scheduled Human Performers Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404035</TAG>' ||
'   <NAME>Actual Human Performers Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404036</TAG>' ||
'   <NAME>Human Performer''s Organization</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00404037</TAG>' ||
'   <NAME>Human Performer''s Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00408302</TAG>' ||
'   <NAME>Entrance Dose in mGy</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00409094</TAG>' ||
'   <NAME>Referenced Image Real World Value Mapping Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00409096</TAG>' ||
'   <NAME>Real World Value Mapping Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00409098</TAG>' ||
'   <NAME>Pixel Value Mapping Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00409210</TAG>' ||
'   <NAME>LUT Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00409211</TAG>' ||
'   <NAME>Real World Value Last Value Mapped</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00409212</TAG>' ||
'   <NAME>Real World Value LUT Data</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00409216</TAG>' ||
'   <NAME>Real World Value First Value Mapped</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00409224</TAG>' ||
'   <NAME>Real World Value Intercept</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00409225</TAG>' ||
'   <NAME>Real World Value Slope</NAME>' ||
'   <VR>FD</VR>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A010</TAG>' ||
'   <NAME>Relationship Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A027</TAG>' ||
'   <NAME>Verifying Organization</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A030</TAG>' ||
'   <NAME>Verification Date Time</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A032</TAG>' ||
'   <NAME>Observation Date Time</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A040</TAG>' ||
'   <NAME>Value Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A043</TAG>' ||
'   <NAME>Concept Name Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A050</TAG>' ||
'   <NAME>Continuity Of Content</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A073</TAG>' ||
'   <NAME>Verifying Observer Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A075</TAG>' ||
'   <NAME>Verifying Observer Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A078</TAG>' ||
'   <NAME>Author Observer Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A07A</TAG>' ||
'   <NAME>Participant Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A07C</TAG>' ||
'   <NAME>Custodial Organization Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A080</TAG>' ||
'   <NAME>Participation Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A082</TAG>' ||
'   <NAME>Participation Datetime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A084</TAG>' ||
'   <NAME>Observer Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A088</TAG>' ||
'   <NAME>Verifying Observer Identification Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A090</TAG>' ||
'   <NAME>Equivalent CDA Document Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A0B0</TAG>' ||
'   <NAME>Referenced Waveform Channels</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>2-2n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A120</TAG>' ||
'   <NAME>DateTime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A121</TAG>' ||
'   <NAME>Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A122</TAG>' ||
'   <NAME>Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A123</TAG>' ||
'   <NAME>Person Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A124</TAG>' ||
'   <NAME>UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A130</TAG>' ||
'   <NAME>Temporal Range Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A132</TAG>' ||
'   <NAME>Referenced Sample Positions</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A136</TAG>' ||
'   <NAME>Referenced Frame Numbers</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A138</TAG>' ||
'   <NAME>Referenced Time Offsets</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A13A</TAG>' ||
'   <NAME>Referenced Datetime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A160</TAG>' ||
'   <NAME>Text Value</NAME>' ||
'   <VR>UT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A168</TAG>' ||
'   <NAME>Concept Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A170</TAG>' ||
'   <NAME>Purpose of Reference Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A180</TAG>' ||
'   <NAME>Annotation Group Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A195</TAG>' ||
'   <NAME>Modifier Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A300</TAG>' ||
'   <NAME>Measured Value Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A301</TAG>' ||
'   <NAME>Numeric Value Qualifier Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A30A</TAG>' ||
'   <NAME>Numeric Value</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A360</TAG>' ||
'   <NAME>Predecessor Documents Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A370</TAG>' ||
'   <NAME>Referenced Request Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A372</TAG>' ||
'   <NAME>Performed Procedure Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A375</TAG>' ||
'   <NAME>Current Requested Procedure Evidence Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A385</TAG>' ||
'   <NAME>Pertinent Other Evidence Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A390</TAG>' ||
'   <NAME>HL7 Structured Document Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A491</TAG>' ||
'   <NAME>Completion Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A492</TAG>' ||
'   <NAME>Completion Flag Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A493</TAG>' ||
'   <NAME>Verification Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A504</TAG>' ||
'   <NAME>Content Template Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A525</TAG>' ||
'   <NAME>Identical Documents Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040A730</TAG>' ||
'   <NAME>Content Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040B020</TAG>' ||
'   <NAME>Annotation Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040DB00</TAG>' ||
'   <NAME>Template Identifier</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040DB06</TAG>' ||
'   <NAME>Template Version</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040DB07</TAG>' ||
'   <NAME>Template Local Version</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040DB0B</TAG>' ||
'   <NAME>Template Extension Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040DB0C</TAG>' ||
'   <NAME>Template Extension Organization UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040DB0D</TAG>' ||
'   <NAME>Template Extension Creator UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040DB73</TAG>' ||
'   <NAME>Referenced Content Item Identifier</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040E001</TAG>' ||
'   <NAME>HL7 Instance Identifier</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040E004</TAG>' ||
'   <NAME>HL7 Document Effective Time</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040E006</TAG>' ||
'   <NAME>HL7 Document Type Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0040E010</TAG>' ||
'   <NAME>Retrieve URI</NAME>' ||
'   <VR>UT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00420010</TAG>' ||
'   <NAME>Document Title</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00420011</TAG>' ||
'   <NAME>Encapsulated Document</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00420012</TAG>' ||
'   <NAME>MIME Type of Encapsulated Document</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00420013</TAG>' ||
'   <NAME>Source Instance Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00500004</TAG>' ||
'   <NAME>Calibration Image</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00500010</TAG>' ||
'   <NAME>Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00500014</TAG>' ||
'   <NAME>Device Length</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00500016</TAG>' ||
'   <NAME>Device Diameter</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00500017</TAG>' ||
'   <NAME>Device Diameter Units</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00500018</TAG>' ||
'   <NAME>Device Volume</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00500019</TAG>' ||
'   <NAME>Intermarker Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00500020</TAG>' ||
'   <NAME>Device Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540010</TAG>' ||
'   <NAME>Energy Window Vector</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540011</TAG>' ||
'   <NAME>Number of Energy Windows</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540012</TAG>' ||
'   <NAME>Energy Window Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540013</TAG>' ||
'   <NAME>Energy Window Range Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540014</TAG>' ||
'   <NAME>Energy Window Lower Limit</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540015</TAG>' ||
'   <NAME>Energy Window Upper Limit</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540016</TAG>' ||
'   <NAME>Radiopharmaceutical Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540017</TAG>' ||
'   <NAME>Residual Syringe Counts</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540018</TAG>' ||
'   <NAME>Energy Window Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540020</TAG>' ||
'   <NAME>Detector Vector</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540021</TAG>' ||
'   <NAME>Number of Detectors</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540022</TAG>' ||
'   <NAME>Detector Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540030</TAG>' ||
'   <NAME>Phase Vector</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540031</TAG>' ||
'   <NAME>Number of Phases</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540032</TAG>' ||
'   <NAME>Phase Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540033</TAG>' ||
'   <NAME>Number of Frames in Phase</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540036</TAG>' ||
'   <NAME>Phase Delay</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540038</TAG>' ||
'   <NAME>Pause Between Frames</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540039</TAG>' ||
'   <NAME>Phase Description</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540050</TAG>' ||
'   <NAME>Rotation Vector</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540051</TAG>' ||
'   <NAME>Number of Rotations</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540052</TAG>' ||
'   <NAME>Rotation Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540053</TAG>' ||
'   <NAME>Number of Frames in Rotation</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540060</TAG>' ||
'   <NAME>R-R Interval Vector</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540061</TAG>' ||
'   <NAME>Number of R-R Intervals</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540062</TAG>' ||
'   <NAME>Gated Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540063</TAG>' ||
'   <NAME>Data Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540070</TAG>' ||
'   <NAME>Time Slot Vector</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540071</TAG>' ||
'   <NAME>Number of Time Slots</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540072</TAG>' ||
'   <NAME>Time Slot Information Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540073</TAG>' ||
'   <NAME>Time Slot Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540080</TAG>' ||
'   <NAME>Slice Vector</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540081</TAG>' ||
'   <NAME>Number of Slices</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540090</TAG>' ||
'   <NAME>Angular View Vector</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540100</TAG>' ||
'   <NAME>Time Slice Vector</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540101</TAG>' ||
'   <NAME>Number of Time Slices</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540200</TAG>' ||
'   <NAME>Start Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540202</TAG>' ||
'   <NAME>Type of Detector Motion</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540210</TAG>' ||
'   <NAME>Trigger Vector</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540211</TAG>' ||
'   <NAME>Number of Triggers in Phase</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540220</TAG>' ||
'   <NAME>View Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540222</TAG>' ||
'   <NAME>View Modifier Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540300</TAG>' ||
'   <NAME>Radionuclide Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540302</TAG>' ||
'   <NAME>Administration Route Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540304</TAG>' ||
'   <NAME>Radiopharmaceutical Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540306</TAG>' ||
'   <NAME>Calibration Data Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540308</TAG>' ||
'   <NAME>Energy Window Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540400</TAG>' ||
'   <NAME>Image ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540410</TAG>' ||
'   <NAME>Patient Orientation Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540412</TAG>' ||
'   <NAME>Patient Orientation Modifier Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540414</TAG>' ||
'   <NAME>Patient Gantry Relationship Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00540500</TAG>' ||
'   <NAME>Slice Progression Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541000</TAG>' ||
'   <NAME>Series Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541001</TAG>' ||
'   <NAME>Units</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541002</TAG>' ||
'   <NAME>Counts Source</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541004</TAG>' ||
'   <NAME>Reprojection Method</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541100</TAG>' ||
'   <NAME>Randoms Correction Method</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541101</TAG>' ||
'   <NAME>Attenuation Correction Method</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541102</TAG>' ||
'   <NAME>Decay Correction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541103</TAG>' ||
'   <NAME>Reconstruction Method</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541104</TAG>' ||
'   <NAME>Detector Lines of Response Used</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541105</TAG>' ||
'   <NAME>Scatter Correction Method</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541200</TAG>' ||
'   <NAME>Axial Acceptance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541201</TAG>' ||
'   <NAME>Axial Mash</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541202</TAG>' ||
'   <NAME>Transverse Mash</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541203</TAG>' ||
'   <NAME>Detector Element Size</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541210</TAG>' ||
'   <NAME>Coincidence Window Width</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541220</TAG>' ||
'   <NAME>Secondary Counts Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541300</TAG>' ||
'   <NAME>Frame Reference Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541310</TAG>' ||
'   <NAME>Primary (Prompts) Counts Accumulated</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541311</TAG>' ||
'   <NAME>Secondary Counts Accumulated</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541320</TAG>' ||
'   <NAME>Slice Sensitivity Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541321</TAG>' ||
'   <NAME>Decay Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541322</TAG>' ||
'   <NAME>Dose Calibration Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541323</TAG>' ||
'   <NAME>Scatter Fraction Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541324</TAG>' ||
'   <NAME>Dead Time Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541330</TAG>' ||
'   <NAME>Image Index</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541400</TAG>' ||
'   <NAME>Counts Included</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00541401</TAG>' ||
'   <NAME>Dead Time Correction Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00603000</TAG>' ||
'   <NAME>Histogram Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00603002</TAG>' ||
'   <NAME>Histogram Number of Bins</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00603004</TAG>' ||
'   <NAME>Histogram First Bin Value</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00603006</TAG>' ||
'   <NAME>Histogram Last Bin Value</NAME>' ||
'   <VR>USS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00603008</TAG>' ||
'   <NAME>Histogram Bin Width</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00603010</TAG>' ||
'   <NAME>Histogram Explanation</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00603020</TAG>' ||
'   <NAME>Histogram Data</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00620001</TAG>' ||
'   <NAME>Segmentation Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00620002</TAG>' ||
'   <NAME>Segment Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00620003</TAG>' ||
'   <NAME>Segmented Property Category Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00620004</TAG>' ||
'   <NAME>Segment Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00620005</TAG>' ||
'   <NAME>Segment Label</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00620006</TAG>' ||
'   <NAME>Segment Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00620008</TAG>' ||
'   <NAME>Segment Algorithm Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00620009</TAG>' ||
'   <NAME>Segment Algorithm Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0062000A</TAG>' ||
'   <NAME>Segment Identification Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0062000B</TAG>' ||
'   <NAME>Referenced Segment Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0062000C</TAG>' ||
'   <NAME>Recommended Display Grayscale Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0062000D</TAG>' ||
'   <NAME>Recommended Display CIELab Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0062000E</TAG>' ||
'   <NAME>Maximum Fractional Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0062000F</TAG>' ||
'   <NAME>Segmented Property Type Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00620010</TAG>' ||
'   <NAME>Segmentation Fractional Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00640002</TAG>' ||
'   <NAME>Deformable Registration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00640003</TAG>' ||
'   <NAME>Source Frame of Reference UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00640005</TAG>' ||
'   <NAME>Deformable Registration Grid Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00640007</TAG>' ||
'   <NAME>Grid Dimensions</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00640008</TAG>' ||
'   <NAME>Grid Resolution</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00640009</TAG>' ||
'   <NAME>Vector Grid Data</NAME>' ||
'   <VR>OF</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0064000F</TAG>' ||
'   <NAME>Pre Deformation Matrix Registration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00640010</TAG>' ||
'   <NAME>Post Deformation Matrix Registration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700001</TAG>' ||
'   <NAME>Graphic Annotation Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700002</TAG>' ||
'   <NAME>Graphic Layer</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700003</TAG>' ||
'   <NAME>Bounding Box Annotation Units</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700004</TAG>' ||
'   <NAME>Anchor Point Annotation Units</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700005</TAG>' ||
'   <NAME>Graphic Annotation Units</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700006</TAG>' ||
'   <NAME>Unformatted Text Value</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700008</TAG>' ||
'   <NAME>Text Object Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700009</TAG>' ||
'   <NAME>Graphic Object Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700010</TAG>' ||
'   <NAME>Bounding Box Top Left Hand Corner</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700011</TAG>' ||
'   <NAME>Bounding Box Bottom Right Hand Corner</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700012</TAG>' ||
'   <NAME>Bounding Box Text Horizontal Justification</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700014</TAG>' ||
'   <NAME>Anchor Point</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700015</TAG>' ||
'   <NAME>Anchor Point Visibility</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700020</TAG>' ||
'   <NAME>Graphic Dimensions</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700021</TAG>' ||
'   <NAME>Number of Graphic Points</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700022</TAG>' ||
'   <NAME>Graphic Data</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>2-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700023</TAG>' ||
'   <NAME>Graphic Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700024</TAG>' ||
'   <NAME>Graphic Filled</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700041</TAG>' ||
'   <NAME>Image Horizontal Flip</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700042</TAG>' ||
'   <NAME>Image Rotation</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700052</TAG>' ||
'   <NAME>Displayed Area Top Left Hand Corner</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700053</TAG>' ||
'   <NAME>Displayed Area Bottom Right Hand Corner</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0070005A</TAG>' ||
'   <NAME>Displayed Area Selection Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700060</TAG>' ||
'   <NAME>Graphic Layer Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700062</TAG>' ||
'   <NAME>Graphic Layer Order</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700066</TAG>' ||
'   <NAME>Graphic Layer Recommended Display Grayscale Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700067</TAG>' ||
'   <NAME>Graphic Layer Recommended Display RGB Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>3</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700068</TAG>' ||
'   <NAME>Graphic Layer Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700080</TAG>' ||
'   <NAME>Content Label</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700081</TAG>' ||
'   <NAME>Content Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700082</TAG>' ||
'   <NAME>Presentation Creation Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700083</TAG>' ||
'   <NAME>Presentation Creation Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700084</TAG>' ||
'   <NAME>Content Creator''s Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700086</TAG>' ||
'   <NAME>Content Creator''s Identification Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700100</TAG>' ||
'   <NAME>Presentation Size Mode</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700101</TAG>' ||
'   <NAME>Presentation Pixel Spacing</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700102</TAG>' ||
'   <NAME>Presentation Pixel Aspect Ratio</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700103</TAG>' ||
'   <NAME>Presentation Pixel Magnification Ratio</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700306</TAG>' ||
'   <NAME>Shape Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700308</TAG>' ||
'   <NAME>Registration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700309</TAG>' ||
'   <NAME>Matrix Registration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0070030A</TAG>' ||
'   <NAME>Matrix Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0070030C</TAG>' ||
'   <NAME>Frame of Reference Transformation Matrix Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0070030D</TAG>' ||
'   <NAME>Registration Type Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0070030F</TAG>' ||
'   <NAME>Fiducial Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700310</TAG>' ||
'   <NAME>Fiducial Identifier</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700311</TAG>' ||
'   <NAME>Fiducial Identifier Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700312</TAG>' ||
'   <NAME>Contour Uncertainty Radius</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700314</TAG>' ||
'   <NAME>Used Fiducials Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700318</TAG>' ||
'   <NAME>Graphic Coordinates Data Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0070031A</TAG>' ||
'   <NAME>Fiducial UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0070031C</TAG>' ||
'   <NAME>Fiducial Set Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0070031E</TAG>' ||
'   <NAME>Fiducial Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700401</TAG>' ||
'   <NAME>Graphic Layer Recommended Display CIELab Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700402</TAG>' ||
'   <NAME>Blending Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700403</TAG>' ||
'   <NAME>Relative Opacity</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700404</TAG>' ||
'   <NAME>Referenced Spatial Registration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00700405</TAG>' ||
'   <NAME>Blending Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720002</TAG>' ||
'   <NAME>Hanging Protocol Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720004</TAG>' ||
'   <NAME>Hanging Protocol Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720006</TAG>' ||
'   <NAME>Hanging Protocol Level</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720008</TAG>' ||
'   <NAME>Hanging Protocol Creator</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072000A</TAG>' ||
'   <NAME>Hanging Protocol Creation Datetime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072000C</TAG>' ||
'   <NAME>Hanging Protocol Definition Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072000E</TAG>' ||
'   <NAME>Hanging Protocol User Identification Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720010</TAG>' ||
'   <NAME>Hanging Protocol User Group Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720012</TAG>' ||
'   <NAME>Source Hanging Protocol Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720014</TAG>' ||
'   <NAME>Number of Priors Referenced</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720020</TAG>' ||
'   <NAME>Image Sets Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720022</TAG>' ||
'   <NAME>Image Set Selector Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720024</TAG>' ||
'   <NAME>Image Set Selector Usage Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720026</TAG>' ||
'   <NAME>Selector Attribute</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720028</TAG>' ||
'   <NAME>Selector Value Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720030</TAG>' ||
'   <NAME>Time Based Image Sets Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720032</TAG>' ||
'   <NAME>Image Set Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720034</TAG>' ||
'   <NAME>Image Set Selector Category</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720038</TAG>' ||
'   <NAME>Relative Time</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072003A</TAG>' ||
'   <NAME>Relative Time Units</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072003C</TAG>' ||
'   <NAME>Abstract Prior Value</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072003E</TAG>' ||
'   <NAME>Abstract Prior Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720040</TAG>' ||
'   <NAME>Image Set Label</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720050</TAG>' ||
'   <NAME>Selector Attribute VR</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720052</TAG>' ||
'   <NAME>Selector Sequence Pointer</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720054</TAG>' ||
'   <NAME>Selector Sequence Pointer Private Creator</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720056</TAG>' ||
'   <NAME>Selector Attribute Private Creator</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720060</TAG>' ||
'   <NAME>Selector AT Value</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720062</TAG>' ||
'   <NAME>Selector CS Value</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720064</TAG>' ||
'   <NAME>Selector IS Value</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720066</TAG>' ||
'   <NAME>Selector LO Value</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720068</TAG>' ||
'   <NAME>Selector LT Value</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072006A</TAG>' ||
'   <NAME>Selector PN Value</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072006C</TAG>' ||
'   <NAME>Selector SH Value</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072006E</TAG>' ||
'   <NAME>Selector ST Value</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720070</TAG>' ||
'   <NAME>Selector UT Value</NAME>' ||
'   <VR>UT</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720072</TAG>' ||
'   <NAME>Selector DS Value</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720074</TAG>' ||
'   <NAME>Selector FD Value</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720076</TAG>' ||
'   <NAME>Selector FL Value</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720078</TAG>' ||
'   <NAME>Selector UL Value</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072007A</TAG>' ||
'   <NAME>Selector US Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072007C</TAG>' ||
'   <NAME>Selector SL Value</NAME>' ||
'   <VR>SL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072007E</TAG>' ||
'   <NAME>Selector SS Value</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720080</TAG>' ||
'   <NAME>Selector Code Sequence Value</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720100</TAG>' ||
'   <NAME>Number of Screens</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720102</TAG>' ||
'   <NAME>Nominal Screen Definition Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720104</TAG>' ||
'   <NAME>Number of Vertical Pixels</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720106</TAG>' ||
'   <NAME>Number of Horizontal Pixels</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720108</TAG>' ||
'   <NAME>Display Environment Spatial Position</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>4</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072010A</TAG>' ||
'   <NAME>Screen Minimum Grayscale Bit Depth</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072010C</TAG>' ||
'   <NAME>Screen Minimum Color Bit Depth</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0072010E</TAG>' ||
'   <NAME>Application Maximum Repaint Time</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720200</TAG>' ||
'   <NAME>Display Sets Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720202</TAG>' ||
'   <NAME>Display Set Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720203</TAG>' ||
'   <NAME>Display Set Label</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720204</TAG>' ||
'   <NAME>Display Set Presentation Group</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720206</TAG>' ||
'   <NAME>Display Set Presentation Group Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720208</TAG>' ||
'   <NAME>Partial Data Display Handling</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720210</TAG>' ||
'   <NAME>Synchronized Scrolling Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720212</TAG>' ||
'   <NAME>Display Set Scrolling Group</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>2-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720214</TAG>' ||
'   <NAME>Navigation Indicator Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720216</TAG>' ||
'   <NAME>Navigation Display Set</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720218</TAG>' ||
'   <NAME>Reference Display Sets</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720300</TAG>' ||
'   <NAME>Image Boxes Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720302</TAG>' ||
'   <NAME>Image Box Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720304</TAG>' ||
'   <NAME>Image Box Layout Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720306</TAG>' ||
'   <NAME>Image Box Tile Horizontal Dimension</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720308</TAG>' ||
'   <NAME>Image Box Tile Vertical Dimension</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720310</TAG>' ||
'   <NAME>Image Box Scroll Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720312</TAG>' ||
'   <NAME>Image Box Small Scroll Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720314</TAG>' ||
'   <NAME>Image Box Small Scroll Amount</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720316</TAG>' ||
'   <NAME>Image Box Large Scroll Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720318</TAG>' ||
'   <NAME>Image Box Large Scroll Amount</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720320</TAG>' ||
'   <NAME>Image Box Overlap Priority</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720330</TAG>' ||
'   <NAME>Cine Relative to Real-Time</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720400</TAG>' ||
'   <NAME>Filter Operations Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720402</TAG>' ||
'   <NAME>Filter-by Category</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720404</TAG>' ||
'   <NAME>Filter-by Attribute Presence</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720406</TAG>' ||
'   <NAME>Filter-by Operator</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720500</TAG>' ||
'   <NAME>Blending Operation Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720510</TAG>' ||
'   <NAME>Reformatting Operation Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720512</TAG>' ||
'   <NAME>Reformatting Thickness</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720514</TAG>' ||
'   <NAME>Reformatting Interval</NAME>' ||
'   <VR>FD</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720516</TAG>' ||
'   <NAME>Reformatting Operation Initial View Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720520</TAG>' ||
'   <NAME>3D Rendering Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720600</TAG>' ||
'   <NAME>Sorting Operations Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720602</TAG>' ||
'   <NAME>Sort-by Category</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720604</TAG>' ||
'   <NAME>Sorting Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720700</TAG>' ||
'   <NAME>Display Set Patient Orientation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720702</TAG>' ||
'   <NAME>VOI Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720704</TAG>' ||
'   <NAME>Pseudo-color Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720706</TAG>' ||
'   <NAME>Show Grayscale Inverted</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720710</TAG>' ||
'   <NAME>Show Image True Size Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720712</TAG>' ||
'   <NAME>Show Graphic Annotation Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720714</TAG>' ||
'   <NAME>Show Patient Demographics Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720716</TAG>' ||
'   <NAME>Show Acquisition Techniques Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720717</TAG>' ||
'   <NAME>Display Set Horizontal Justification</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00720718</TAG>' ||
'   <NAME>Display Set Vertical Justification</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00880130</TAG>' ||
'   <NAME>Storage Media File-set ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00880140</TAG>' ||
'   <NAME>Storage Media File-set UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00880200</TAG>' ||
'   <NAME>Icon Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00880904</TAG>' ||
'   <NAME>Topic Title</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00880906</TAG>' ||
'   <NAME>Topic Subject</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00880910</TAG>' ||
'   <NAME>Topic Author</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00880912</TAG>' ||
'   <NAME>Topic Keywords</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-32</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>01000410</TAG>' ||
'   <NAME>SOP Instance Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>01000420</TAG>' ||
'   <NAME>SOP Authorization Date and Time</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>01000424</TAG>' ||
'   <NAME>SOP Authorization Comment</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>01000426</TAG>' ||
'   <NAME>Authorization Equipment Certification Number</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000005</TAG>' ||
'   <NAME>MAC ID Number</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000010</TAG>' ||
'   <NAME>MAC Calculation Transfer Syntax UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000015</TAG>' ||
'   <NAME>MAC Algorithm</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000020</TAG>' ||
'   <NAME>Data Elements Signed</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000100</TAG>' ||
'   <NAME>Digital Signature UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000105</TAG>' ||
'   <NAME>Digital Signature DateTime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000110</TAG>' ||
'   <NAME>Certificate Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000115</TAG>' ||
'   <NAME>Certificate of Signer</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000120</TAG>' ||
'   <NAME>Signature</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000305</TAG>' ||
'   <NAME>Certified Timestamp Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000310</TAG>' ||
'   <NAME>Certified Timestamp</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000401</TAG>' ||
'   <NAME>Digital Signature Purpose Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000402</TAG>' ||
'   <NAME>Referenced Digital Signature Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000403</TAG>' ||
'   <NAME>Referenced SOP Instance MAC Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000404</TAG>' ||
'   <NAME>MAC</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000500</TAG>' ||
'   <NAME>Encrypted Attributes Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000510</TAG>' ||
'   <NAME>Encrypted Content Transfer Syntax UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000520</TAG>' ||
'   <NAME>Encrypted Content</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000550</TAG>' ||
'   <NAME>Modified Attributes Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000561</TAG>' ||
'   <NAME>Original Attributes Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000562</TAG>' ||
'   <NAME>Attribute Modification Datetime</NAME>' ||
'   <VR>DT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000563</TAG>' ||
'   <NAME>Modifying System</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000564</TAG>' ||
'   <NAME>Source of Previous Values</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>04000565</TAG>' ||
'   <NAME>Reason for the Attribute Modification</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000010</TAG>' ||
'   <NAME>Number of Copies</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>2000001E</TAG>' ||
'   <NAME>Printer Configuration Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000020</TAG>' ||
'   <NAME>Print Priority</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000030</TAG>' ||
'   <NAME>Medium Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000040</TAG>' ||
'   <NAME>Film Destination</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000050</TAG>' ||
'   <NAME>Film Session Label</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000060</TAG>' ||
'   <NAME>Memory Allocation</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000061</TAG>' ||
'   <NAME>Maximum Memory Allocation</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000062</TAG>' ||
'   <NAME>Color Image Printing Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000063</TAG>' ||
'   <NAME>Collation Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000065</TAG>' ||
'   <NAME>Annotation Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000067</TAG>' ||
'   <NAME>Image Overlay Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000069</TAG>' ||
'   <NAME>Presentation LUT Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>2000006A</TAG>' ||
'   <NAME>Image Box Presentation LUT Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>200000A0</TAG>' ||
'   <NAME>Memory Bit Depth</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>200000A1</TAG>' ||
'   <NAME>Printing Bit Depth</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>200000A2</TAG>' ||
'   <NAME>Media Installed Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>200000A4</TAG>' ||
'   <NAME>Other Media Available Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>200000A8</TAG>' ||
'   <NAME>Supported Image Display Formats Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000500</TAG>' ||
'   <NAME>Referenced Film Box Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20000510</TAG>' ||
'   <NAME>Referenced Stored Print Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100010</TAG>' ||
'   <NAME>Image Display Format</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100030</TAG>' ||
'   <NAME>Annotation Display Format ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100040</TAG>' ||
'   <NAME>Film Orientation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100050</TAG>' ||
'   <NAME>Film Size ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100052</TAG>' ||
'   <NAME>Printer Resolution ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100054</TAG>' ||
'   <NAME>Default Printer Resolution ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100060</TAG>' ||
'   <NAME>Magnification Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100080</TAG>' ||
'   <NAME>Smoothing Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>201000A6</TAG>' ||
'   <NAME>Default Magnification Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>201000A7</TAG>' ||
'   <NAME>Other Magnification Types Available</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>201000A8</TAG>' ||
'   <NAME>Default Smoothing Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>201000A9</TAG>' ||
'   <NAME>Other Smoothing Types Available</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100100</TAG>' ||
'   <NAME>Border Density</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100110</TAG>' ||
'   <NAME>Empty Image Density</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100120</TAG>' ||
'   <NAME>Min Density</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100130</TAG>' ||
'   <NAME>Max Density</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100140</TAG>' ||
'   <NAME>Trim</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100150</TAG>' ||
'   <NAME>Configuration Information</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100152</TAG>' ||
'   <NAME>Configuration Information Description</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100154</TAG>' ||
'   <NAME>Maximum Collated Films</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>2010015E</TAG>' ||
'   <NAME>Illumination</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100160</TAG>' ||
'   <NAME>Reflected Ambient Light</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100376</TAG>' ||
'   <NAME>Printer Pixel Spacing</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100500</TAG>' ||
'   <NAME>Referenced Film Session Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100510</TAG>' ||
'   <NAME>Referenced Image Box Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20100520</TAG>' ||
'   <NAME>Referenced Basic Annotation Box Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20200010</TAG>' ||
'   <NAME>Image Position</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20200020</TAG>' ||
'   <NAME>Polarity</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20200030</TAG>' ||
'   <NAME>Requested Image Size</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20200040</TAG>' ||
'   <NAME>Requested Decimate/Crop Behavior</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20200050</TAG>' ||
'   <NAME>Requested Resolution ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>202000A0</TAG>' ||
'   <NAME>Requested Image Size Flag</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>202000A2</TAG>' ||
'   <NAME>Decimate/Crop Result</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20200110</TAG>' ||
'   <NAME>Basic Grayscale Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20200111</TAG>' ||
'   <NAME>Basic Color Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20200130</TAG>' ||
'   <NAME>Referenced Image Overlay Box Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20200140</TAG>' ||
'   <NAME>Referenced VOI LUT Box Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20300010</TAG>' ||
'   <NAME>Annotation Position</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20300020</TAG>' ||
'   <NAME>Text String</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400010</TAG>' ||
'   <NAME>Referenced Overlay Plane Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400011</TAG>' ||
'   <NAME>Referenced Overlay Plane Groups</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-99</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400020</TAG>' ||
'   <NAME>Overlay Pixel Data Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400060</TAG>' ||
'   <NAME>Overlay Magnification Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400070</TAG>' ||
'   <NAME>Overlay Smoothing Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400072</TAG>' ||
'   <NAME>Overlay or Image Magnification</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400074</TAG>' ||
'   <NAME>Magnify to Number of Columns</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400080</TAG>' ||
'   <NAME>Overlay Foreground Density</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400082</TAG>' ||
'   <NAME>Overlay Background Density</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400090</TAG>' ||
'   <NAME>Overlay Mode</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400100</TAG>' ||
'   <NAME>Threshold Density</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20400500</TAG>' ||
'   <NAME>Referenced Image Box Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20500010</TAG>' ||
'   <NAME>Presentation LUT Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20500020</TAG>' ||
'   <NAME>Presentation LUT Shape</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>20500500</TAG>' ||
'   <NAME>Referenced Presentation LUT Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000010</TAG>' ||
'   <NAME>Print Job ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000020</TAG>' ||
'   <NAME>Execution Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000030</TAG>' ||
'   <NAME>Execution Status Info</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000040</TAG>' ||
'   <NAME>Creation Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000050</TAG>' ||
'   <NAME>Creation Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000070</TAG>' ||
'   <NAME>Originator</NAME>' ||
'   <VR>AE</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000140</TAG>' ||
'   <NAME>Destination AE</NAME>' ||
'   <VR>AE</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000160</TAG>' ||
'   <NAME>Owner ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000170</TAG>' ||
'   <NAME>Number of Films</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21000500</TAG>' ||
'   <NAME>Referenced Print Job Sequence (Pull Stored Print)</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21100010</TAG>' ||
'   <NAME>Printer Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21100020</TAG>' ||
'   <NAME>Printer Status Info</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21100030</TAG>' ||
'   <NAME>Printer Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21100099</TAG>' ||
'   <NAME>Print Queue ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21200010</TAG>' ||
'   <NAME>Queue Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21200050</TAG>' ||
'   <NAME>Print Job Description Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21200070</TAG>' ||
'   <NAME>Referenced Print Job Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21300010</TAG>' ||
'   <NAME>Print Management Capabilities Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21300015</TAG>' ||
'   <NAME>Printer Characteristics Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21300030</TAG>' ||
'   <NAME>Film Box Content Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21300040</TAG>' ||
'   <NAME>Image Box Content Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21300050</TAG>' ||
'   <NAME>Annotation Content Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21300060</TAG>' ||
'   <NAME>Image Overlay Box Content Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>21300080</TAG>' ||
'   <NAME>Presentation LUT Content Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>213000A0</TAG>' ||
'   <NAME>Proposed Study Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>213000C0</TAG>' ||
'   <NAME>Original Image Sequence</NAME>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000001</TAG>' ||
'   <NAME>Label Using Information Extracted From Instances</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000002</TAG>' ||
'   <NAME>Label Text</NAME>' ||
'   <VR>UT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000003</TAG>' ||
'   <NAME>Label Style Selection</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000004</TAG>' ||
'   <NAME>Media Disposition</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000005</TAG>' ||
'   <NAME>Barcode Value</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000006</TAG>' ||
'   <NAME>Barcode Symbology</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000007</TAG>' ||
'   <NAME>Allow Media Splitting</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000008</TAG>' ||
'   <NAME>Include Non-DICOM Objects</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000009</TAG>' ||
'   <NAME>Include Display Application</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>2200000A</TAG>' ||
'   <NAME>Preserve Composite Instances After Media Creation</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>2200000B</TAG>' ||
'   <NAME>Total Number of Pieces of Media Created</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>2200000C</TAG>' ||
'   <NAME>Requested Media Application Profile</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>2200000D</TAG>' ||
'   <NAME>Referenced Storage Media Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>2200000E</TAG>' ||
'   <NAME>Failure Attributes</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>2200000F</TAG>' ||
'   <NAME>Allow Lossy Compression</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>22000020</TAG>' ||
'   <NAME>Request Priority</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020002</TAG>' ||
'   <NAME>RT Image Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020003</TAG>' ||
'   <NAME>RT Image Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020004</TAG>' ||
'   <NAME>RT Image Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3002000A</TAG>' ||
'   <NAME>Reported Values Origin</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3002000C</TAG>' ||
'   <NAME>RT Image Plane</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3002000D</TAG>' ||
'   <NAME>X-Ray Image Receptor Translation</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3002000E</TAG>' ||
'   <NAME>X-Ray Image Receptor Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020010</TAG>' ||
'   <NAME>RT Image Orientation</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>6</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020011</TAG>' ||
'   <NAME>Image Plane Pixel Spacing</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020012</TAG>' ||
'   <NAME>RT Image Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020020</TAG>' ||
'   <NAME>Radiation Machine Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020022</TAG>' ||
'   <NAME>Radiation Machine SAD</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020024</TAG>' ||
'   <NAME>Radiation Machine SSD</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020026</TAG>' ||
'   <NAME>RT Image SID</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020028</TAG>' ||
'   <NAME>Source to Reference Object Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020029</TAG>' ||
'   <NAME>Fraction Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020030</TAG>' ||
'   <NAME>Exposure Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020032</TAG>' ||
'   <NAME>Meterset Exposure</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020034</TAG>' ||
'   <NAME>Diaphragm Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>4</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020040</TAG>' ||
'   <NAME>Fluence Map Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020041</TAG>' ||
'   <NAME>Fluence Data Source</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30020042</TAG>' ||
'   <NAME>Fluence Data Scale</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040001</TAG>' ||
'   <NAME>DVH Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040002</TAG>' ||
'   <NAME>Dose Units</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040004</TAG>' ||
'   <NAME>Dose Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040006</TAG>' ||
'   <NAME>Dose Comment</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040008</TAG>' ||
'   <NAME>Normalization Point</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3004000A</TAG>' ||
'   <NAME>Dose Summation Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3004000C</TAG>' ||
'   <NAME>Grid Frame Offset Vector</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3004000E</TAG>' ||
'   <NAME>Dose Grid Scaling</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040010</TAG>' ||
'   <NAME>RT Dose ROI Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040012</TAG>' ||
'   <NAME>Dose Value</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040014</TAG>' ||
'   <NAME>Tissue Heterogeneity Correction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040040</TAG>' ||
'   <NAME>DVH Normalization Point</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040042</TAG>' ||
'   <NAME>DVH Normalization Dose Value</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040050</TAG>' ||
'   <NAME>DVH Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040052</TAG>' ||
'   <NAME>DVH Dose Scaling</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040054</TAG>' ||
'   <NAME>DVH Volume Units</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040056</TAG>' ||
'   <NAME>DVH Number of Bins</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040058</TAG>' ||
'   <NAME>DVH Data</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2-2n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040060</TAG>' ||
'   <NAME>DVH Referenced ROI Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040062</TAG>' ||
'   <NAME>DVH ROI Contribution Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040070</TAG>' ||
'   <NAME>DVH Minimum Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040072</TAG>' ||
'   <NAME>DVH Maximum Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30040074</TAG>' ||
'   <NAME>DVH Mean Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060002</TAG>' ||
'   <NAME>Structure Set Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060004</TAG>' ||
'   <NAME>Structure Set Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060006</TAG>' ||
'   <NAME>Structure Set Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060008</TAG>' ||
'   <NAME>Structure Set Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060009</TAG>' ||
'   <NAME>Structure Set Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060010</TAG>' ||
'   <NAME>Referenced Frame of Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060012</TAG>' ||
'   <NAME>RT Referenced Study Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060014</TAG>' ||
'   <NAME>RT Referenced Series Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060016</TAG>' ||
'   <NAME>Contour Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060020</TAG>' ||
'   <NAME>Structure Set ROI Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060022</TAG>' ||
'   <NAME>ROI Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060024</TAG>' ||
'   <NAME>Referenced Frame of Reference UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060026</TAG>' ||
'   <NAME>ROI Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060028</TAG>' ||
'   <NAME>ROI Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3006002A</TAG>' ||
'   <NAME>ROI Display Color</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3006002C</TAG>' ||
'   <NAME>ROI Volume</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060030</TAG>' ||
'   <NAME>RT Related ROI Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060033</TAG>' ||
'   <NAME>RT ROI Relationship</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060036</TAG>' ||
'   <NAME>ROI Generation Algorithm</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060038</TAG>' ||
'   <NAME>ROI Generation Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060039</TAG>' ||
'   <NAME>ROI Contour Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060040</TAG>' ||
'   <NAME>Contour Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060042</TAG>' ||
'   <NAME>Contour Geometric Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060044</TAG>' ||
'   <NAME>Contour Slab Thickness</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060045</TAG>' ||
'   <NAME>Contour Offset Vector</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060046</TAG>' ||
'   <NAME>Number of Contour Points</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060048</TAG>' ||
'   <NAME>Contour Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060049</TAG>' ||
'   <NAME>Attached Contours</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060050</TAG>' ||
'   <NAME>Contour Data</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3-3n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060080</TAG>' ||
'   <NAME>RT ROI Observations Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060082</TAG>' ||
'   <NAME>Observation Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060084</TAG>' ||
'   <NAME>Referenced ROI Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060085</TAG>' ||
'   <NAME>ROI Observation Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060086</TAG>' ||
'   <NAME>RT ROI Identification Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30060088</TAG>' ||
'   <NAME>ROI Observation Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600A0</TAG>' ||
'   <NAME>Related RT ROI Observations Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600A4</TAG>' ||
'   <NAME>RT ROI Interpreted Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600A6</TAG>' ||
'   <NAME>ROI Interpreter</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600B0</TAG>' ||
'   <NAME>ROI Physical Properties Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600B2</TAG>' ||
'   <NAME>ROI Physical Property</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600B4</TAG>' ||
'   <NAME>ROI Physical Property Value</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600C0</TAG>' ||
'   <NAME>Frame of Reference Relationship Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600C2</TAG>' ||
'   <NAME>Related Frame of Reference UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600C4</TAG>' ||
'   <NAME>Frame of Reference Transformation Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600C6</TAG>' ||
'   <NAME>Frame of Reference Transformation Matrix</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>16</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300600C8</TAG>' ||
'   <NAME>Frame of Reference Transformation Comment</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080010</TAG>' ||
'   <NAME>Measured Dose Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080012</TAG>' ||
'   <NAME>Measured Dose Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080014</TAG>' ||
'   <NAME>Measured Dose Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080016</TAG>' ||
'   <NAME>Measured Dose Value</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080020</TAG>' ||
'   <NAME>Treatment Session Beam Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080021</TAG>' ||
'   <NAME>Treatment Session Ion Beam Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080022</TAG>' ||
'   <NAME>Current Fraction Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080024</TAG>' ||
'   <NAME>Treatment Control Point Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080025</TAG>' ||
'   <NAME>Treatment Control Point Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008002A</TAG>' ||
'   <NAME>Treatment Termination Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008002B</TAG>' ||
'   <NAME>Treatment Termination Code</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008002C</TAG>' ||
'   <NAME>Treatment Verification Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080030</TAG>' ||
'   <NAME>Referenced Treatment Record Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080032</TAG>' ||
'   <NAME>Specified Primary Meterset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080033</TAG>' ||
'   <NAME>Specified Secondary Meterset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080036</TAG>' ||
'   <NAME>Delivered Primary Meterset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080037</TAG>' ||
'   <NAME>Delivered Secondary Meterset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008003A</TAG>' ||
'   <NAME>Specified Treatment Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008003B</TAG>' ||
'   <NAME>Delivered Treatment Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080040</TAG>' ||
'   <NAME>Control Point Delivery Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080041</TAG>' ||
'   <NAME>Ion Control Point Delivery Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080042</TAG>' ||
'   <NAME>Specified Meterset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080044</TAG>' ||
'   <NAME>Delivered Meterset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080045</TAG>' ||
'   <NAME>Meterset Rate Set</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080046</TAG>' ||
'   <NAME>Meterset Rate Delivered</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080047</TAG>' ||
'   <NAME>Scan Spot Metersets Delivered</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080048</TAG>' ||
'   <NAME>Dose Rate Delivered</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080050</TAG>' ||
'   <NAME>Treatment Summary Calculated Dose Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080052</TAG>' ||
'   <NAME>Cumulative Dose to Dose Reference</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080054</TAG>' ||
'   <NAME>First Treatment Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080056</TAG>' ||
'   <NAME>Most Recent Treatment Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008005A</TAG>' ||
'   <NAME>Number of Fractions Delivered</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080060</TAG>' ||
'   <NAME>Override Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080061</TAG>' ||
'   <NAME>Parameter Sequence Pointer</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080062</TAG>' ||
'   <NAME>Override Parameter Pointer</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080063</TAG>' ||
'   <NAME>Parameter Item Index</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080064</TAG>' ||
'   <NAME>Measured Dose Reference Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080065</TAG>' ||
'   <NAME>Parameter Pointer</NAME>' ||
'   <VR>AT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080066</TAG>' ||
'   <NAME>Override Reason</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080068</TAG>' ||
'   <NAME>Corrected Parameter Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008006A</TAG>' ||
'   <NAME>Correction Value</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080070</TAG>' ||
'   <NAME>Calculated Dose Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080072</TAG>' ||
'   <NAME>Calculated Dose Reference Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080074</TAG>' ||
'   <NAME>Calculated Dose Reference Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080076</TAG>' ||
'   <NAME>Calculated Dose Reference Dose Value</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080078</TAG>' ||
'   <NAME>Start Meterset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008007A</TAG>' ||
'   <NAME>End Meterset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080080</TAG>' ||
'   <NAME>Referenced Measured Dose Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080082</TAG>' ||
'   <NAME>Referenced Measured Dose Reference Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080090</TAG>' ||
'   <NAME>Referenced Calculated Dose Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080092</TAG>' ||
'   <NAME>Referenced Calculated Dose Reference Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300800A0</TAG>' ||
'   <NAME>Beam Limiting Device Leaf Pairs Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'   <TAG>300800B0</TAG>' ||
'   <NAME>Recorded Wedge Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300800C0</TAG>' ||
'   <NAME>Recorded Compensator Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300800D0</TAG>' ||
'   <NAME>Recorded Block Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300800E0</TAG>' ||
'   <NAME>Treatment Summary Measured Dose Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300800F0</TAG>' ||
'   <NAME>Recorded Snout Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300800F2</TAG>' ||
'   <NAME>Recorded Range Shifter Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300800F4</TAG>' ||
'   <NAME>Recorded Lateral Spreading Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300800F6</TAG>' ||
'   <NAME>Recorded Range Modulator Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080100</TAG>' ||
'   <NAME>Recorded Source Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080105</TAG>' ||
'   <NAME>Source Serial Number</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080110</TAG>' ||
'   <NAME>Treatment Session Application Setup Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080116</TAG>' ||
'   <NAME>Application Setup Check</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080120</TAG>' ||
'   <NAME>Recorded Brachy Accessory Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080122</TAG>' ||
'   <NAME>Referenced Brachy Accessory Device Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080130</TAG>' ||
'   <NAME>Recorded Channel Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080132</TAG>' ||
'   <NAME>Specified Channel Total Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080134</TAG>' ||
'   <NAME>Delivered Channel Total Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080136</TAG>' ||
'   <NAME>Specified Number of Pulses</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080138</TAG>' ||
'   <NAME>Delivered Number of Pulses</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008013A</TAG>' ||
'   <NAME>Specified Pulse Repetition Interval</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>3008013C</TAG>' ||
'   <NAME>Delivered Pulse Repetition Interval</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080140</TAG>' ||
'   <NAME>Recorded Source Applicator Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080142</TAG>' ||
'   <NAME>Referenced Source Applicator Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080150</TAG>' ||
'   <NAME>Recorded Channel Shield Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080152</TAG>' ||
'   <NAME>Referenced Channel Shield Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080160</TAG>' ||
'   <NAME>Brachy Control Point Delivered Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080162</TAG>' ||
'   <NAME>Safe Position Exit Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080164</TAG>' ||
'   <NAME>Safe Position Exit Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080166</TAG>' ||
'   <NAME>Safe Position Return Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080168</TAG>' ||
'   <NAME>Safe Position Return Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080200</TAG>' ||
'   <NAME>Current Treatment Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080202</TAG>' ||
'   <NAME>Treatment Status Comment</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080220</TAG>' ||
'   <NAME>Fraction Group Summary Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080223</TAG>' ||
'   <NAME>Referenced Fraction Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080224</TAG>' ||
'   <NAME>Fraction Group Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080230</TAG>' ||
'   <NAME>Beam Stopper Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080240</TAG>' ||
'   <NAME>Fraction Status Summary Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080250</TAG>' ||
'   <NAME>Treatment Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>30080251</TAG>' ||
'   <NAME>Treatment Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0002</TAG>' ||
'   <NAME>RT Plan Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0003</TAG>' ||
'   <NAME>RT Plan Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0004</TAG>' ||
'   <NAME>RT Plan Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0006</TAG>' ||
'   <NAME>RT Plan Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0007</TAG>' ||
'   <NAME>RT Plan Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0009</TAG>' ||
'   <NAME>Treatment Protocols</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A000A</TAG>' ||
'   <NAME>Plan Intent</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A000B</TAG>' ||
'   <NAME>Treatment Sites</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A000C</TAG>' ||
'   <NAME>RT Plan Geometry</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A000E</TAG>' ||
'   <NAME>Prescription Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0010</TAG>' ||
'   <NAME>Dose Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0012</TAG>' ||
'   <NAME>Dose Reference Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0013</TAG>' ||
'   <NAME>Dose Reference UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0014</TAG>' ||
'   <NAME>Dose Reference Structure Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0015</TAG>' ||
'   <NAME>Nominal Beam Energy Unit</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0016</TAG>' ||
'   <NAME>Dose Reference Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0018</TAG>' ||
'   <NAME>Dose Reference Point Coordinates</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A001A</TAG>' ||
'   <NAME>Nominal Prior Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0020</TAG>' ||
'   <NAME>Dose Reference Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0021</TAG>' ||
'   <NAME>Constraint Weight</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0022</TAG>' ||
'   <NAME>Delivery Warning Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0023</TAG>' ||
'   <NAME>Delivery Maximum Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0025</TAG>' ||
'   <NAME>Target Minimum Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0026</TAG>' ||
'   <NAME>Target Prescription Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0027</TAG>' ||
'   <NAME>Target Maximum Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0028</TAG>' ||
'   <NAME>Target Underdose Volume Fraction</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A002A</TAG>' ||
'   <NAME>Organ at Risk Full-volume Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A002B</TAG>' ||
'   <NAME>Organ at Risk Limit Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A002C</TAG>' ||
'   <NAME>Organ at Risk Maximum Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A002D</TAG>' ||
'   <NAME>Organ at Risk Overdose Volume Fraction</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0040</TAG>' ||
'   <NAME>Tolerance Table Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0042</TAG>' ||
'   <NAME>Tolerance Table Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0043</TAG>' ||
'   <NAME>Tolerance Table Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0044</TAG>' ||
'   <NAME>Gantry Angle Tolerance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0046</TAG>' ||
'   <NAME>Beam Limiting Device Angle Tolerance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0048</TAG>' ||
'   <NAME>Beam Limiting Device Tolerance Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A004A</TAG>' ||
'   <NAME>Beam Limiting Device Position Tolerance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A004B</TAG>' ||
'   <NAME>Snout Position Tolerance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A004C</TAG>' ||
'   <NAME>Patient Support Angle Tolerance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A004E</TAG>' ||
'   <NAME>Table Top Eccentric Angle Tolerance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A004F</TAG>' ||
'   <NAME>Table Top Pitch Angle Tolerance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0050</TAG>' ||
'   <NAME>Table Top Roll Angle Tolerance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0051</TAG>' ||
'   <NAME>Table Top Vertical Position Tolerance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0052</TAG>' ||
'   <NAME>Table Top Longitudinal Position Tolerance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0053</TAG>' ||
'   <NAME>Table Top Lateral Position Tolerance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0055</TAG>' ||
'   <NAME>RT Plan Relationship</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0070</TAG>' ||
'   <NAME>Fraction Group Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0071</TAG>' ||
'   <NAME>Fraction Group Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0072</TAG>' ||
'   <NAME>Fraction Group Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0078</TAG>' ||
'   <NAME>Number of Fractions Planned</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0079</TAG>' ||
'   <NAME>Number of Fraction Pattern Digits Per Day</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A007A</TAG>' ||
'   <NAME>Repeat Fraction Cycle Length</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A007B</TAG>' ||
'   <NAME>Fraction Pattern</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0080</TAG>' ||
'   <NAME>Number of Beams</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0082</TAG>' ||
'   <NAME>Beam Dose Specification Point</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0084</TAG>' ||
'   <NAME>Beam Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0086</TAG>' ||
'   <NAME>Beam Meterset</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0088</TAG>' ||
'   <NAME>Beam Dose Point Depth</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0089</TAG>' ||
'   <NAME>Beam Dose Point Equivalent Depth</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A008A</TAG>' ||
'   <NAME>Beam Dose Point SSD</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00A0</TAG>' ||
'   <NAME>Number of Brachy Application Setups</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00A2</TAG>' ||
'   <NAME>Brachy Application Setup Dose Specification Point</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00A4</TAG>' ||
'   <NAME>Brachy Application Setup Dose</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00B0</TAG>' ||
'   <NAME>Beam Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00B2</TAG>' ||
'   <NAME>Treatment Machine Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00B3</TAG>' ||
'   <NAME>Primary Dosimeter Unit</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00B4</TAG>' ||
'   <NAME>Source-Axis Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00B6</TAG>' ||
'   <NAME>Beam Limiting Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00B8</TAG>' ||
'   <NAME>RT Beam Limiting Device Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00BA</TAG>' ||
'   <NAME>Source to Beam Limiting Device Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00BB</TAG>' ||
'   <NAME>Isocenter to Beam Limiting Device Distance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00BC</TAG>' ||
'   <NAME>Number of Leaf/Jaw Pairs</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00BE</TAG>' ||
'   <NAME>Leaf Position Boundaries</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00C0</TAG>' ||
'   <NAME>Beam Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00C2</TAG>' ||
'   <NAME>Beam Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00C3</TAG>' ||
'   <NAME>Beam Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00C4</TAG>' ||
'   <NAME>Beam Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00C6</TAG>' ||
'   <NAME>Radiation Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00C7</TAG>' ||
'   <NAME>High-Dose Technique Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00C8</TAG>' ||
'   <NAME>Reference Image Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00CA</TAG>' ||
'   <NAME>Planned Verification Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00CC</TAG>' ||
'   <NAME>Imaging Device-Specific Acquisition Parameters</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00CE</TAG>' ||
'   <NAME>Treatment Delivery Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D0</TAG>' ||
'   <NAME>Number of Wedges</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D1</TAG>' ||
'   <NAME>Wedge Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D2</TAG>' ||
'   <NAME>Wedge Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D3</TAG>' ||
'   <NAME>Wedge Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D4</TAG>' ||
'   <NAME>Wedge ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D5</TAG>' ||
'   <NAME>Wedge Angle</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D6</TAG>' ||
'   <NAME>Wedge Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D7</TAG>' ||
'   <NAME>Total Wedge Tray Water-Equivalent Thickness</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D8</TAG>' ||
'   <NAME>Wedge Orientation</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00D9</TAG>' ||
'   <NAME>Isocenter to Wedge Tray Distance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00DA</TAG>' ||
'   <NAME>Source to Wedge Tray Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00DB</TAG>' ||
'   <NAME>Wedge Thin Edge Position</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00DC</TAG>' ||
'   <NAME>Bolus ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00DD</TAG>' ||
'   <NAME>Bolus Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E0</TAG>' ||
'   <NAME>Number of Compensators</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E1</TAG>' ||
'   <NAME>Material ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E2</TAG>' ||
'   <NAME>Total Compensator Tray Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E3</TAG>' ||
'   <NAME>Compensator Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E4</TAG>' ||
'   <NAME>Compensator Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E5</TAG>' ||
'   <NAME>Compensator ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E6</TAG>' ||
'   <NAME>Source to Compensator Tray Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E7</TAG>' ||
'   <NAME>Compensator Rows</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E8</TAG>' ||
'   <NAME>Compensator Columns</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00E9</TAG>' ||
'   <NAME>Compensator Pixel Spacing</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00EA</TAG>' ||
'   <NAME>Compensator Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00EB</TAG>' ||
'   <NAME>Compensator Transmission Data</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00EC</TAG>' ||
'   <NAME>Compensator Thickness Data</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00ED</TAG>' ||
'   <NAME>Number of Boli</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00EE</TAG>' ||
'   <NAME>Compensator Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00F0</TAG>' ||
'   <NAME>Number of Blocks</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00F2</TAG>' ||
'   <NAME>Total Block Tray Factor</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00F3</TAG>' ||
'   <NAME>Total Block Tray Water-Equivalent Thickness</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00F4</TAG>' ||
'   <NAME>Block Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00F5</TAG>' ||
'   <NAME>Block Tray ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00F6</TAG>' ||
'   <NAME>Source to Block Tray Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00F7</TAG>' ||
'   <NAME>Isocenter to Block Tray Distance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00F8</TAG>' ||
'   <NAME>Block Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00F9</TAG>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'   <NAME>Accessory Code</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00FA</TAG>' ||
'   <NAME>Block Divergence</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00FB</TAG>' ||
'   <NAME>Block Mounting Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00FC</TAG>' ||
'   <NAME>Block Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A00FE</TAG>' ||
'   <NAME>Block Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0100</TAG>' ||
'   <NAME>Block Thickness</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0102</TAG>' ||
'   <NAME>Block Transmission</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0104</TAG>' ||
'   <NAME>Block Number of Points</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0106</TAG>' ||
'   <NAME>Block Data</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2-2n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0107</TAG>' ||
'   <NAME>Applicator Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0108</TAG>' ||
'   <NAME>Applicator ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0109</TAG>' ||
'   <NAME>Applicator Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A010A</TAG>' ||
'   <NAME>Applicator Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A010C</TAG>' ||
'   <NAME>Cumulative Dose Reference Coefficient</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A010E</TAG>' ||
'   <NAME>Final Cumulative Meterset Weight</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0110</TAG>' ||
'   <NAME>Number of Control Points</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0111</TAG>' ||
'   <NAME>Control Point Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0112</TAG>' ||
'   <NAME>Control Point Index</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0114</TAG>' ||
'   <NAME>Nominal Beam Energy</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0115</TAG>' ||
'   <NAME>Dose Rate Set</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0116</TAG>' ||
'   <NAME>Wedge Position Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0118</TAG>' ||
'   <NAME>Wedge Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A011A</TAG>' ||
'   <NAME>Beam Limiting Device Position Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A011C</TAG>' ||
'   <NAME>Leaf/Jaw Positions</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>2-2n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A011E</TAG>' ||
'   <NAME>Gantry Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A011F</TAG>' ||
'   <NAME>Gantry Rotation Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0120</TAG>' ||
'   <NAME>Beam Limiting Device Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0121</TAG>' ||
'   <NAME>Beam Limiting Device Rotation Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0122</TAG>' ||
'   <NAME>Patient Support Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0123</TAG>' ||
'   <NAME>Patient Support Rotation Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0124</TAG>' ||
'   <NAME>Table Top Eccentric Axis Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0125</TAG>' ||
'   <NAME>Table Top Eccentric Angle</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0126</TAG>' ||
'   <NAME>Table Top Eccentric Rotation Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0128</TAG>' ||
'   <NAME>Table Top Vertical Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0129</TAG>' ||
'   <NAME>Table Top Longitudinal Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A012A</TAG>' ||
'   <NAME>Table Top Lateral Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A012C</TAG>' ||
'   <NAME>Isocenter Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A012E</TAG>' ||
'   <NAME>Surface Entry Point</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0130</TAG>' ||
'   <NAME>Source to Surface Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0134</TAG>' ||
'   <NAME>Cumulative Meterset Weight</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0140</TAG>' ||
'   <NAME>Table Top Pitch Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0142</TAG>' ||
'   <NAME>Table Top Pitch Rotation Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0144</TAG>' ||
'   <NAME>Table Top Roll Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0146</TAG>' ||
'   <NAME>Table Top Roll Rotation Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0148</TAG>' ||
'   <NAME>Head Fixation Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A014A</TAG>' ||
'   <NAME>Gantry Pitch Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A014C</TAG>' ||
'   <NAME>Gantry Pitch Rotation Direction</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A014E</TAG>' ||
'   <NAME>Gantry Pitch Angle Tolerance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0180</TAG>' ||
'   <NAME>Patient Setup Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0182</TAG>' ||
'   <NAME>Patient Setup Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0183</TAG>' ||
'   <NAME>Patient Setup Label</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0184</TAG>' ||
'   <NAME>Patient Additional Position</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0190</TAG>' ||
'   <NAME>Fixation Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0192</TAG>' ||
'   <NAME>Fixation Device Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0194</TAG>' ||
'   <NAME>Fixation Device Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0196</TAG>' ||
'   <NAME>Fixation Device Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0198</TAG>' ||
'   <NAME>Fixation Device Position</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0199</TAG>' ||
'   <NAME>Fixation Device Pitch Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A019A</TAG>' ||
'   <NAME>Fixation Device Roll Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01A0</TAG>' ||
'   <NAME>Shielding Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01A2</TAG>' ||
'   <NAME>Shielding Device Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01A4</TAG>' ||
'   <NAME>Shielding Device Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01A6</TAG>' ||
'   <NAME>Shielding Device Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01A8</TAG>' ||
'   <NAME>Shielding Device Position</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01B0</TAG>' ||
'   <NAME>Setup Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01B2</TAG>' ||
'   <NAME>Setup Technique Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01B4</TAG>' ||
'   <NAME>Setup Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01B6</TAG>' ||
'   <NAME>Setup Device Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01B8</TAG>' ||
'   <NAME>Setup Device Label</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01BA</TAG>' ||
'   <NAME>Setup Device Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01BC</TAG>' ||
'   <NAME>Setup Device Parameter</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01D0</TAG>' ||
'   <NAME>Setup Reference Description</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01D2</TAG>' ||
'   <NAME>Table Top Vertical Setup Displacement</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01D4</TAG>' ||
'   <NAME>Table Top Longitudinal Setup Displacement</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A01D6</TAG>' ||
'   <NAME>Table Top Lateral Setup Displacement</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0200</TAG>' ||
'   <NAME>Brachy Treatment Technique</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0202</TAG>' ||
'   <NAME>Brachy Treatment Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0206</TAG>' ||
'   <NAME>Treatment Machine Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0210</TAG>' ||
'   <NAME>Source Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0212</TAG>' ||
'   <NAME>Source Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0214</TAG>' ||
'   <NAME>Source Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0216</TAG>' ||
'   <NAME>Source Manufacturer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0218</TAG>' ||
'   <NAME>Active Source Diameter</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A021A</TAG>' ||
'   <NAME>Active Source Length</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0222</TAG>' ||
'   <NAME>Source Encapsulation Nominal Thickness</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0224</TAG>' ||
'   <NAME>Source Encapsulation Nominal Transmission</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0226</TAG>' ||
'   <NAME>Source Isotope Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0228</TAG>' ||
'   <NAME>Source Isotope Half Life</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0229</TAG>' ||
'   <NAME>Source Strength Units</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A022A</TAG>' ||
'   <NAME>Reference Air Kerma Rate</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A022B</TAG>' ||
'   <NAME>Source Strength</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A022C</TAG>' ||
'   <NAME>Source Strength Reference Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A022E</TAG>' ||
'   <NAME>Source Strength Reference Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0230</TAG>' ||
'   <NAME>Application Setup Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0232</TAG>' ||
'   <NAME>Application Setup Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0234</TAG>' ||
'   <NAME>Application Setup Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0236</TAG>' ||
'   <NAME>Application Setup Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0238</TAG>' ||
'   <NAME>Application Setup Manufacturer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0240</TAG>' ||
'   <NAME>Template Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0242</TAG>' ||
'   <NAME>Template Type</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0244</TAG>' ||
'   <NAME>Template Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0250</TAG>' ||
'   <NAME>Total Reference Air Kerma</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0260</TAG>' ||
'   <NAME>Brachy Accessory Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0262</TAG>' ||
'   <NAME>Brachy Accessory Device Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0263</TAG>' ||
'   <NAME>Brachy Accessory Device ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0264</TAG>' ||
'   <NAME>Brachy Accessory Device Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0266</TAG>' ||
'   <NAME>Brachy Accessory Device Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A026A</TAG>' ||
'   <NAME>Brachy Accessory Device Nominal Thickness</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A026C</TAG>' ||
'   <NAME>Brachy Accessory Device Nominal Transmission</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0280</TAG>' ||
'   <NAME>Channel Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0282</TAG>' ||
'   <NAME>Channel Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0284</TAG>' ||
'   <NAME>Channel Length</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0286</TAG>' ||
'   <NAME>Channel Total Time</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0288</TAG>' ||
'   <NAME>Source Movement Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A028A</TAG>' ||
'   <NAME>Number of Pulses</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A028C</TAG>' ||
'   <NAME>Pulse Repetition Interval</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0290</TAG>' ||
'   <NAME>Source Applicator Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0291</TAG>' ||
'   <NAME>Source Applicator ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0292</TAG>' ||
'   <NAME>Source Applicator Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0294</TAG>' ||
'   <NAME>Source Applicator Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0296</TAG>' ||
'   <NAME>Source Applicator Length</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0298</TAG>' ||
'   <NAME>Source Applicator Manufacturer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A029C</TAG>' ||
'   <NAME>Source Applicator Wall Nominal Thickness</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A029E</TAG>' ||
'   <NAME>Source Applicator Wall Nominal Transmission</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02A0</TAG>' ||
'   <NAME>Source Applicator Step Size</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02A2</TAG>' ||
'   <NAME>Transfer Tube Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02A4</TAG>' ||
'   <NAME>Transfer Tube Length</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02B0</TAG>' ||
'   <NAME>Channel Shield Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02B2</TAG>' ||
'   <NAME>Channel Shield Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02B3</TAG>' ||
'   <NAME>Channel Shield ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02B4</TAG>' ||
'   <NAME>Channel Shield Name</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02B8</TAG>' ||
'   <NAME>Channel Shield Nominal Thickness</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02BA</TAG>' ||
'   <NAME>Channel Shield Nominal Transmission</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02C8</TAG>' ||
'   <NAME>Final Cumulative Time Weight</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02D0</TAG>' ||
'   <NAME>Brachy Control Point Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02D2</TAG>' ||
'   <NAME>Control Point Relative Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02D4</TAG>' ||
'   <NAME>Control Point 3D Position</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>3</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02D6</TAG>' ||
'   <NAME>Cumulative Time Weight</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02E0</TAG>' ||
'   <NAME>Compensator Divergence</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02E1</TAG>' ||
'   <NAME>Compensator Mounting Position</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02E2</TAG>' ||
'   <NAME>Source to Compensator Distance</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02E3</TAG>' ||
'   <NAME>Total Compensator Tray Water-Equivalent Thickness</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02E4</TAG>' ||
'   <NAME>Isocenter to Compensator Tray Distance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02E5</TAG>' ||
'   <NAME>Compensator Column Offset</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02E6</TAG>' ||
'   <NAME>Isocenter to Compensator Distances</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02E7</TAG>' ||
'   <NAME>Compensator Relative Stopping Power Ratio</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02E8</TAG>' ||
'   <NAME>Compensator Milling Tool Diameter</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A02EA</TAG>' ||
'   <NAME>Ion Range Compensator Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0302</TAG>' ||
'   <NAME>Radiation Mass Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0304</TAG>' ||
'   <NAME>Radiation Atomic Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0306</TAG>' ||
'   <NAME>Radiation Charge State</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0308</TAG>' ||
'   <NAME>Scan Mode</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A030A</TAG>' ||
'   <NAME>Virtual Source-Axis Distances</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A030C</TAG>' ||
'   <NAME>Snout Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A030D</TAG>' ||
'   <NAME>Snout Position</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A030F</TAG>' ||
'   <NAME>Snout ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0312</TAG>' ||
'   <NAME>Number of Range Shifters</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0314</TAG>' ||
'   <NAME>Range Shifter Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0316</TAG>' ||
'   <NAME>Range Shifter Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0318</TAG>' ||
'   <NAME>Range Shifter ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0320</TAG>' ||
'   <NAME>Range Shifter Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0322</TAG>' ||
'   <NAME>Range Shifter Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0330</TAG>' ||
'   <NAME>Number of Lateral Spreading Devices</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0332</TAG>' ||
'   <NAME>Lateral Spreading Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0334</TAG>' ||
'   <NAME>Lateral Spreading Device Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0336</TAG>' ||
'   <NAME>Lateral Spreading Device ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0338</TAG>' ||
'   <NAME>Lateral Spreading Device Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A033A</TAG>' ||
'   <NAME>Lateral Spreading Device Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A033C</TAG>' ||
'   <NAME>Lateral Spreading Device Water Equivalent Thickness</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0340</TAG>' ||
'   <NAME>Number of Range Modulators</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0342</TAG>' ||
'   <NAME>Range Modulator Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0344</TAG>' ||
'   <NAME>Range Modulator Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0346</TAG>' ||
'   <NAME>Range Modulator ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0348</TAG>' ||
'   <NAME>Range Modulator Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A034A</TAG>' ||
'   <NAME>Range Modulator Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A034C</TAG>' ||
'   <NAME>Beam Current Modulation ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0350</TAG>' ||
'   <NAME>Patient Support Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0352</TAG>' ||
'   <NAME>Patient Support ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0354</TAG>' ||
'   <NAME>Patient Support Accessory Code</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0356</TAG>' ||
'   <NAME>Fixation Light Azimuthal Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0358</TAG>' ||
'   <NAME>Fixation Light Polar Angle</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A035A</TAG>' ||
'   <NAME>Meterset Rate</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0360</TAG>' ||
'   <NAME>Range Shifter Settings Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0362</TAG>' ||
'   <NAME>Range Shifter Setting</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0364</TAG>' ||
'   <NAME>Isocenter to Range Shifter Distance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0366</TAG>' ||
'   <NAME>Range Shifter Water Equivalent Thickness</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0370</TAG>' ||
'   <NAME>Lateral Spreading Device Settings Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0372</TAG>' ||
'   <NAME>Lateral Spreading Device Setting</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0374</TAG>' ||
'   <NAME>Isocenter to Lateral Spreading Device Distance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0380</TAG>' ||
'   <NAME>Range Modulator Settings Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0382</TAG>' ||
'   <NAME>Range Modulator Gating Start Value</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0384</TAG>' ||
'   <NAME>Range Modulator Gating Stop Value</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0386</TAG>' ||
'   <NAME>Range Modulator Gating Start Water Equivalent Thickness</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0388</TAG>' ||
'   <NAME>Range Modulator Gating Stop Water Equivalent Thickness</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A038A</TAG>' ||
'   <NAME>Isocenter to Range Modulator Distance</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0390</TAG>' ||
'   <NAME>Scan Spot Tune ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0392</TAG>' ||
'   <NAME>Number of Scan Spot Positions</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0394</TAG>' ||
'   <NAME>Scan Spot Position Map</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0396</TAG>' ||
'   <NAME>Scan Spot Meterset Weights</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0398</TAG>' ||
'   <NAME>Scanning Spot Size</NAME>' ||
'   <VR>FL</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A039A</TAG>' ||
'   <NAME>Number of Paintings</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A03A0</TAG>' ||
'   <NAME>Ion Tolerance Table Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A03A2</TAG>' ||
'   <NAME>Ion Beam Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A03A4</TAG>' ||
'   <NAME>Ion Beam Limiting Device Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A03A6</TAG>' ||
'   <NAME>Ion Block Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A03A8</TAG>' ||
'   <NAME>Ion Control Point Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A03AA</TAG>' ||
'   <NAME>Ion Wedge Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A03AC</TAG>' ||
'   <NAME>Ion Wedge Position Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0401</TAG>' ||
'   <NAME>Referenced Setup Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0402</TAG>' ||
'   <NAME>Setup Image Comment</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300A0410</TAG>' ||
'   <NAME>Motion Synchronization Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0002</TAG>' ||
'   <NAME>Referenced RT Plan Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0004</TAG>' ||
'   <NAME>Referenced Beam Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0006</TAG>' ||
'   <NAME>Referenced Beam Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0007</TAG>' ||
'   <NAME>Referenced Reference Image Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0008</TAG>' ||
'   <NAME>Start Cumulative Meterset Weight</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0009</TAG>' ||
'   <NAME>End Cumulative Meterset Weight</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C000A</TAG>' ||
'   <NAME>Referenced Brachy Application Setup Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C000C</TAG>' ||
'   <NAME>Referenced Brachy Application Setup Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C000E</TAG>' ||
'   <NAME>Referenced Source Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0020</TAG>' ||
'   <NAME>Referenced Fraction Group Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0022</TAG>' ||
'   <NAME>Referenced Fraction Group Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0040</TAG>' ||
'   <NAME>Referenced Verification Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0042</TAG>' ||
'   <NAME>Referenced Reference Image Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0050</TAG>' ||
'   <NAME>Referenced Dose Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0051</TAG>' ||
'   <NAME>Referenced Dose Reference Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0055</TAG>' ||
'   <NAME>Brachy Referenced Dose Reference Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0060</TAG>' ||
'   <NAME>Referenced Structure Set Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C006A</TAG>' ||
'   <NAME>Referenced Patient Setup Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0080</TAG>' ||
'   <NAME>Referenced Dose Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C00A0</TAG>' ||
'   <NAME>Referenced Tolerance Table Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C00B0</TAG>' ||
'   <NAME>Referenced Bolus Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C00C0</TAG>' ||
'   <NAME>Referenced Wedge Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C00D0</TAG>' ||
'   <NAME>Referenced Compensator Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C00E0</TAG>' ||
'   <NAME>Referenced Block Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C00F0</TAG>' ||
'   <NAME>Referenced Control Point Index</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C00F2</TAG>' ||
'   <NAME>Referenced Control Point Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C00F4</TAG>' ||
'   <NAME>Referenced Start Control Point Index</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C00F6</TAG>' ||
'   <NAME>Referenced Stop Control Point Index</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0100</TAG>' ||
'   <NAME>Referenced Range Shifter Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0102</TAG>' ||
'   <NAME>Referenced Lateral Spreading Device Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300C0104</TAG>' ||
'   <NAME>Referenced Range Modulator Number</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300E0002</TAG>' ||
'   <NAME>Approval Status</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300E0004</TAG>' ||
'   <NAME>Review Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300E0005</TAG>' ||
'   <NAME>Review Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>300E0008</TAG>' ||
'   <NAME>Reviewer Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40000010</TAG>' ||
'   <NAME>Arbitrary</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40004000</TAG>' ||
'   <NAME>Text Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080040</TAG>' ||
'   <NAME>Results ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080042</TAG>' ||
'   <NAME>Results ID Issuer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080050</TAG>' ||
'   <NAME>Referenced Interpretation Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080100</TAG>' ||
'   <NAME>Interpretation Recorded Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080101</TAG>' ||
'   <NAME>Interpretation Recorded Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080102</TAG>' ||
'   <NAME>Interpretation Recorder</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080103</TAG>' ||
'   <NAME>Reference to Recorded Sound</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080108</TAG>' ||
'   <NAME>Interpretation Transcription Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080109</TAG>' ||
'   <NAME>Interpretation Transcription Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>4008010A</TAG>' ||
'   <NAME>Interpretation Transcriber</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>4008010B</TAG>' ||
'   <NAME>Interpretation Text</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>4008010C</TAG>' ||
'   <NAME>Interpretation Author</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080111</TAG>' ||
'   <NAME>Interpretation Approver Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080112</TAG>' ||
'   <NAME>Interpretation Approval Date</NAME>' ||
'   <VR>DA</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080113</TAG>' ||
'   <NAME>Interpretation Approval Time</NAME>' ||
'   <VR>TM</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080114</TAG>' ||
'   <NAME>Physician Approving Interpretation</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080115</TAG>' ||
'   <NAME>Interpretation Diagnosis Description</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080117</TAG>' ||
'   <NAME>Interpretation Diagnosis Code Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080118</TAG>' ||
'   <NAME>Results Distribution List Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080119</TAG>' ||
'   <NAME>Distribution Name</NAME>' ||
'   <VR>PN</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>4008011A</TAG>' ||
'   <NAME>Distribution Address</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080200</TAG>' ||
'   <NAME>Interpretation ID</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080202</TAG>' ||
'   <NAME>Interpretation ID Issuer</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080210</TAG>' ||
'   <NAME>Interpretation Type ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080212</TAG>' ||
'   <NAME>Interpretation Status ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40080300</TAG>' ||
'   <NAME>Impressions</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>40084000</TAG>' ||
'   <NAME>Results Comments</NAME>' ||
'   <VR>ST</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>4FFE0001</TAG>' ||
'   <NAME>MAC Parameters Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0005</TAG>' ||
'   <NAME>Curve Dimensions</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0010</TAG>' ||
'   <NAME>Number of Points</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0020</TAG>' ||
'   <NAME>Type of Data</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0022</TAG>' ||
'   <NAME>Curve Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0030</TAG>' ||
'   <NAME>Axis Units</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0040</TAG>' ||
'   <NAME>Axis Labels</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0103</TAG>' ||
'   <NAME>Data Value Representation</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0104</TAG>' ||
'   <NAME>Minimum Coordinate Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0105</TAG>' ||
'   <NAME>Maximum Coordinate Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0106</TAG>' ||
'   <NAME>Curve Range</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0110</TAG>' ||
'   <NAME>Curve Data Descriptor</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0112</TAG>' ||
'   <NAME>Coordinate Start Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx0114</TAG>' ||
'   <NAME>Coordinate Step Value</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx1001</TAG>' ||
'   <NAME>Curve Activation Layer</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx2000</TAG>' ||
'   <NAME>Audio Type</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx2002</TAG>' ||
'   <NAME>Audio Sample Format</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx2004</TAG>' ||
'   <NAME>Number of Channels</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx2006</TAG>' ||
'   <NAME>Number of Samples</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx2008</TAG>' ||
'   <NAME>Sample Rate</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx200A</TAG>' ||
'   <NAME>Total Time</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx200C</TAG>' ||
'   <NAME>Audio Sample Data</NAME>' ||
'   <VR>OWB</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx200E</TAG>' ||
'   <NAME>Audio Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx2500</TAG>' ||
'   <NAME>Curve Label</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx2600</TAG>' ||
'   <NAME>Curve Referenced Overlay Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx2610</TAG>' ||
'   <NAME>Curve Referenced Overlay Group</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>50xx3000</TAG>' ||
'   <NAME>Curve Data</NAME>' ||
'   <VR>OWB</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>52009229</TAG>' ||
'   <NAME>Shared Functional Groups Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>52009230</TAG>' ||
'   <NAME>Per-frame Functional Groups Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>54000100</TAG>' ||
'   <NAME>Waveform Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>54000110</TAG>' ||
'   <NAME>Channel Minimum Value</NAME>' ||
'   <VR>OWB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>54000112</TAG>' ||
'   <NAME>Channel Maximum Value</NAME>' ||
'   <VR>OWB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>54001004</TAG>' ||
'   <NAME>Waveform Bits Allocated</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>54001006</TAG>' ||
'   <NAME>Waveform Sample Interpretation</NAME>' ;
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

  ordcmXml := 
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>5400100A</TAG>' ||
'   <NAME>Waveform Padding Value</NAME>' ||
'   <VR>OWB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>54001010</TAG>' ||
'   <NAME>Waveform Data</NAME>' ||
'   <VR>OWB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>56000010</TAG>' ||
'   <NAME>First Order Phase Correction Angle</NAME>' ||
'   <VR>OF</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>56000020</TAG>' ||
'   <NAME>Spectroscopy Data</NAME>' ||
'   <VR>OF</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0010</TAG>' ||
'   <NAME>Overlay Rows</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0011</TAG>' ||
'   <NAME>Overlay Columns</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0012</TAG>' ||
'   <NAME>Overlay Planes</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0015</TAG>' ||
'   <NAME>Number of Frames in Overlay</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0022</TAG>' ||
'   <NAME>Overlay Description</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0040</TAG>' ||
'   <NAME>Overlay Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0045</TAG>' ||
'   <NAME>Overlay Subtype</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0050</TAG>' ||
'   <NAME>Overlay Origin</NAME>' ||
'   <VR>SS</VR>' ||
'   <VM>2</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0051</TAG>' ||
'   <NAME>Image Frame Origin</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0052</TAG>' ||
'   <NAME>Overlay Plane Origin</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0060</TAG>' ||
'   <NAME>Overlay Compression Code</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0100</TAG>' ||
'   <NAME>Overlay Bits Allocated</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0102</TAG>' ||
'   <NAME>Overlay Bit Position</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0110</TAG>' ||
'   <NAME>Overlay Format</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx0200</TAG>' ||
'   <NAME>Overlay Location</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1001</TAG>' ||
'   <NAME>Overlay Activation Layer</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1100</TAG>' ||
'   <NAME>Overlay Descriptor - Gray</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1101</TAG>' ||
'   <NAME>Overlay Descriptor - Red</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1102</TAG>' ||
'   <NAME>Overlay Descriptor - Green</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1103</TAG>' ||
'   <NAME>Overlay Descriptor - Blue</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1200</TAG>' ||
'   <NAME>Overlays- Gray</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1201</TAG>' ||
'   <NAME>Overlays - Red</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1202</TAG>' ||
'   <NAME>Overlays - Green</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1203</TAG>' ||
'   <NAME>Overlays- Blue</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1-n</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1301</TAG>' ||
'   <NAME>ROI Area</NAME>' ||
'   <VR>IS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1302</TAG>' ||
'   <NAME>ROI Mean</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1303</TAG>' ||
'   <NAME>ROI Standard Deviation</NAME>' ||
'   <VR>DS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx1500</TAG>' ||
'   <NAME>Overlay Label</NAME>' ||
'   <VR>LO</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx3000</TAG>' ||
'   <NAME>Overlay Data</NAME>' ||
'   <VR>OWB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>60xx4000</TAG>' ||
'   <NAME>Overlay Comments</NAME>' ||
'   <VR>LT</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>7FE00010</TAG>' ||
'   <NAME>Pixel Data</NAME>' ||
'   <VR>OWB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>FFFAFFFA</TAG>' ||
'   <NAME>Digital Signatures Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>FFFCFFFC</TAG>' ||
'   <NAME>Data Set Trailing Padding</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>FFFEE000</TAG>' ||
'   <NAME>Item</NAME>' ||
'   <VR>EXP</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>FFFEE00D</TAG>' ||
'   <NAME>Item Delimitation Item</NAME>' ||
'   <VR>EXP</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>FFFEE0DD</TAG>' ||
'   <NAME>Sequence Delimitation Item</NAME>' ||
'   <VR>EXP</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020000</TAG>' ||
'   <NAME>Group Length</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020001</TAG>' ||
'   <NAME>File Meta Information Version</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020002</TAG>' ||
'   <NAME>Media Storage SOP Class UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020003</TAG>' ||
'   <NAME>Media Storage SOP Instance UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020010</TAG>' ||
'   <NAME>Transfer Syntax UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020012</TAG>' ||
'   <NAME>Implementation Class UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020013</TAG>' ||
'   <NAME>Implementation Version Name</NAME>' ||
'   <VR>SH</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020016</TAG>' ||
'   <NAME>Source Application Entity Title</NAME>' ||
'   <VR>AE</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020100</TAG>' ||
'   <NAME>Private Information Creator UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00020102</TAG>' ||
'   <NAME>Private Information</NAME>' ||
'   <VR>OB</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00040000</TAG>' ||
'   <NAME>Group Length</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041130</TAG>' ||
'   <NAME>File-set ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041141</TAG>' ||
'   <NAME>File-set Descriptor File ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-8</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041142</TAG>' ||
'   <NAME>Specific Character Set of File-set Descriptor File</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041200</TAG>' ||
'   <NAME>Offset of the First Directory Record of the Root Directory Entity</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041202</TAG>' ||
'   <NAME>Offset of the Last Directory Record of the Root Directory Entity</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041212</TAG>' ||
'   <NAME>File-set Consistency Flag</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041220</TAG>' ||
'   <NAME>Directory Record Sequence</NAME>' ||
'   <VR>SQ</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041400</TAG>' ||
'   <NAME>Offset of the Next Directory Record</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041410</TAG>' ||
'   <NAME>Record In-use Flag</NAME>' ||
'   <VR>US</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041420</TAG>' ||
'   <NAME>Offset of Referenced Lower-Level Directory Entity</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041430</TAG>' ||
'   <NAME>Directory Record Type</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041432</TAG>' ||
'   <NAME>Private Record UID</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041500</TAG>' ||
'   <NAME>Referenced File ID</NAME>' ||
'   <VR>CS</VR>' ||
'   <VM>1-8</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041504</TAG>' ||
'   <NAME>MRDR Directory Record Offset</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041510</TAG>' ||
'   <NAME>Referenced SOP Class UID in File</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041511</TAG>' ||
'   <NAME>Referenced SOP Instance UID in File</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041512</TAG>' ||
'   <NAME>Referenced Transfer Syntax UID in File</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>0004151A</TAG>' ||
'   <NAME>Referenced Related General SOP Class UID in File</NAME>' ||
'   <VR>UI</VR>' ||
'   <VM>1-n</VM>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'<STANDARD_ATTRIBUTE_DEFINITION>' ||
'   <TAG>00041600</TAG>' ||
'   <NAME>Number of References</NAME>' ||
'   <VR>UL</VR>' ||
'   <VM>1</VM>' ||
'   <RETIRED>true</RETIRED>' ||
'</STANDARD_ATTRIBUTE_DEFINITION>' ||
'</DICOM_STANDARD_ATTRIBUTES>';
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

 xt := new sys.XMLType(ordClob);
 ordsys.ord_dicom_admin.insertDocument('ordcmsd.xml','STANDARD_DICTIONARY',xt);
 sys.dbms_lob.freeTemporary(ordClob);

 exception
   --suppress 53002: doc exists error for oracle installed docs
   when ex then
     null;

end;
/


-- insert the ordcmpv.xml into the dicom repos
declare 
 xt sys.XMLtype;
 ex exception;
 pragma exception_init(ex, -53002);
 ordcmXml varchar2(32767);
 ordClob   clob;
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordcmXml := '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2007, 2009, Oracle and/or its affiliates.' ||
'All rights reserved. ' ||
'  NAME' ||
'  ordcmpv.xml - Oracle Multimedia DICOM private dictionary document' ||
'  ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dolin       02/20/09 - add magic tag' ||
'   myalavar    11/14/08 - add oracle definer uid' ||
'   dguo        05/18/07 - change product name' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'' ||
'-->' ||
'' ||
'<DICOM_PRIVATE_ATTRIBUTES xmlns="http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0 http://xmlns.oracle.com/ord/dicom/privateDictionary_1_0">' ||
' <DOCUMENT_HEADER>' ||
'  <dt:DOCUMENT_CHANGE_LOG>' ||
'   <dt:DOCUMENT_MODIFIER>Dongbai Guo</dt:DOCUMENT_MODIFIER>' ||
'   <dt:DOCUMENT_MODIFICATION_DATE>2007-04-09</dt:DOCUMENT_MODIFICATION_DATE>' ||
'   <dt:DOCUMENT_VERSION>1.0</dt:DOCUMENT_VERSION>' ||
'   <dt:MODIFICATION_COMMENT>Oracle Private Dictionary</dt:MODIFICATION_COMMENT>' ||
'  </dt:DOCUMENT_CHANGE_LOG>' ||
' </DOCUMENT_HEADER>' ||
' <ATTRIBUTE_DEFINERS>' ||
'  <dt:ATTR_DEFINER>' ||
'   <dt:NAME>ORACLE</dt:NAME>' ||
'   <dt:UID>1.2.826.0.1.3680043.2.1170.9</dt:UID>' ||
'  </dt:ATTR_DEFINER>' ||
' </ATTRIBUTE_DEFINERS> ' ||
' <PRIVATE_ATTRIBUTE_DEFINITION>' ||
'  <TAG>FFFF1001</TAG>' ||
'  <NAME>locator macro tag</NAME>' ||
'  <DEFINER>ORACLE</DEFINER>' ||
'  <VR>SQ</VR>' ||
'  <VM>1</VM>' ||
' </PRIVATE_ATTRIBUTE_DEFINITION>' ||
' <PRIVATE_ATTRIBUTE_DEFINITION>' ||
'  <TAG>FFFF1002</TAG>' ||
'  <NAME>unknown attribute tag</NAME>' ||
'  <DEFINER>ORACLE</DEFINER>' ||
'  <VR>UN</VR>' ||
'  <VM>1</VM>' ||
' </PRIVATE_ATTRIBUTE_DEFINITION>' ||
' <PRIVATE_ATTRIBUTE_DEFINITION>' ||
'  <TAG>FFFF1003</TAG>' ||
'  <NAME>magic tag</NAME>' ||
'  <DEFINER>ORACLE</DEFINER>' ||
'  <VR>SQ</VR>' ||
'  <VM>1</VM>' ||
' </PRIVATE_ATTRIBUTE_DEFINITION>' ||
'</DICOM_PRIVATE_ATTRIBUTES>';

 sys.dbms_lob.write(ordClob, length(ordcmXml), 1, ordcmXml);

 xt := new sys.XMLType(ordClob);
 ordsys.ord_dicom_admin.insertDocument('ordcmpv.xml','PRIVATE_DICTIONARY',xt);
 sys.dbms_lob.freeTemporary(ordClob);

 exception
   --suppress 53002: doc exists error for oracle installed docs
   when ex then
     null;

end;
/


-- insert the ordcmmp.xml into the dicom repos
declare 
 xt sys.XMLtype;
 ex exception;
 pragma exception_init(ex, -53002);
 ordcmXml varchar2(32767);
 ordClob   clob;
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordcmXml := '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'  NAME' ||
'  ordcmmp.xml - Oracle Multimedia DICOM default mapping document' ||
'  ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dguo        05/18/07 - change product name' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'' ||
'-->' ||
'' ||
'<XML_MAPPING_DOCUMENT xmlns="http://xmlns.oracle.com/ord/dicom/mapping_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://xmlns.oracle.com/ord/dicom/mapping_1_0 http://xmlns.oracle.com/ord/dicom/mapping_1_0">' ||
' <DOCUMENT_HEADER>' ||
'  <dt:DOCUMENT_CHANGE_LOG>' ||
'   <dt:DOCUMENT_MODIFIER>Dongbai Guo</dt:DOCUMENT_MODIFIER>' ||
'   <dt:DOCUMENT_MODIFICATION_DATE>2007-04-09</dt:DOCUMENT_MODIFICATION_DATE>' ||
'   <dt:DOCUMENT_VERSION>1.0</dt:DOCUMENT_VERSION>' ||
'   <dt:MODIFICATION_COMMENT>Oracle default Mapping document</dt:MODIFICATION_COMMENT>' ||
'  </dt:DOCUMENT_CHANGE_LOG>' ||
' </DOCUMENT_HEADER>' ||
' <NAMESPACE>http://xmlns.oracle.com/ord/dicom/metadata_1_0</NAMESPACE>' ||
' <ROOT_ELEM_TAG>DICOM_OBJECT</ROOT_ELEM_TAG>' ||
' <UNMAPPED_ELEM></UNMAPPED_ELEM>' ||
' <MAPPED_ELEM></MAPPED_ELEM>' ||
'</XML_MAPPING_DOCUMENT>';

 sys.dbms_lob.write(ordClob, length(ordcmXml), 1, ordcmXml);

 xt := new sys.XMLType(ordClob);
 ordsys.ord_dicom_admin.insertDocument('ordcmmp.xml','MAPPING',xt);
 sys.dbms_lob.freeTemporary(ordClob);

 exception
   --suppress 53002: doc exists error for oracle installed docs
   when ex then
     null;

end;
/


-- insert the ordcman.xml into the dicom repos
declare 
 xt sys.XMLtype;
 ex exception;
 pragma exception_init(ex, -53002);
 ordcmXml varchar2(32767);
 ordClob   clob;
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordcmXml := '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'  NAME' ||
'    ordcman.xml - Oracle Multimedia DICOM default anonymity document' ||
'  ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dguo        05/18/07 - change product name' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'' ||
'-->' ||
'' ||
'<ANONYMITY_RULE_DOCUMENT xmlns="http://xmlns.oracle.com/ord/dicom/anonymity_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://xmlns.oracle.com/ord/dicom/anonymity_1_0 http://xmlns.oracle.com/ord/dicom/anonymity_1_0">' ||
' <DOCUMENT_HEADER>' ||
'    <dt:DOCUMENT_CHANGE_LOG>' ||
'      <dt:DOCUMENT_MODIFIER>Dongbai Guo</dt:DOCUMENT_MODIFIER>' ||
'      <dt:DOCUMENT_MODIFICATION_DATE>2007-04-09</dt:DOCUMENT_MODIFICATION_DATE>' ||
'      <dt:DOCUMENT_VERSION>1.0</dt:DOCUMENT_VERSION>' ||
'      <dt:MODIFICATION_COMMENT>Oracle default anonymity document</dt:MODIFICATION_COMMENT>' ||
'      <dt:BASE_DOCUMENT>DICOM standard Part 15 : A subset of Basic application level confidentiality profile attributes</dt:BASE_DOCUMENT>' ||
'      <dt:BASE_DOCUMENT_RELEASE_DATE>2007-01-01</dt:BASE_DOCUMENT_RELEASE_DATE>' ||
'      <dt:BASE_DOCUMENT_DESCRIPTION>Downloadable from http://medical.nema.org/</dt:BASE_DOCUMENT_DESCRIPTION>' ||
'   </dt:DOCUMENT_CHANGE_LOG>' ||
' </DOCUMENT_HEADER>' ||
' <PRIVATE_ATTRIBUTES action="remove"></PRIVATE_ATTRIBUTES>' ||
' <UNDEFINED_STANDARD_ATTRIBUTES action="remove"></UNDEFINED_STANDARD_ATTRIBUTES>' ||
' <UNDEFINED_PRIVATE_ATTRIBUTES action="remove"></UNDEFINED_PRIVATE_ATTRIBUTES>' ||
'' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00080050</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Accession Number </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="replace">anonymous</ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00080080</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Institution Name </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="replace">anonymous</ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00080081</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Institution Address </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00080090</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Referring Physician''s Name </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="replace">anonymous</ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00080092</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Referring Physician''s Address </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00080094</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Referring Physician''s Telephone Numbers</DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00081010</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Station Name </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00081030</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Study Description </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>0008103E</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Series Description </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00081040</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Institutional Department Name </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00081048</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Physician(s) of Record </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00081050</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Performing Physicians'' Name </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00081060</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Name of Physician(s) Reading Study </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00081070</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Operators'' Name </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="replace">anonymous</ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00081080</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Admitting Diagnoses Description </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00082111</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Derivation Description </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00100010</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Patient''s Name </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="replace">anonymous</ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00100020</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Patient ID </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="replace">anonymous</ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00100030</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Patient''s Birth Date </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00100032</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Patient''s Birth Time </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00100040</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Patient''s Sex </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00101000</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Other Patient Ids </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00101001</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Other Patient Names </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00101010</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Patient''s Age </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00101020</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Patient''s Size </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00101030</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Patient''s Weight </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00101090</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Medical Record Locator </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00102160</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Ethnic Group </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00102180</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Occupation </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>001021B0</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Additional Patient''s History </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00104000</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Patient Comments </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00181000</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Device Serial Number </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00181030</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Protocol Name </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00200010</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Study ID </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="replace">anonymous</ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00204000</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Image Comments </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>00400275</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Request Attributes Sequence </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'  <INDIVIDUAL_ATTRIBUTE>' ||
'    <ATTRIBUTE_TAG>0040A730</ATTRIBUTE_TAG>' ||
'    <DESCRIPTION>Content Sequence </DESCRIPTION>' ||
'    <ANONYMITY_ACTION action="remove"></ANONYMITY_ACTION>' ||
'  </INDIVIDUAL_ATTRIBUTE>' ||
'' ||
'' ||
'</ANONYMITY_RULE_DOCUMENT>';

 sys.dbms_lob.write(ordClob, length(ordcmXml), 1, ordcmXml);

 xt := new sys.XMLType(ordClob);
 ordsys.ord_dicom_admin.insertDocument('ordcman.xml','ANONYMITY',xt);
 sys.dbms_lob.freeTemporary(ordClob);

 exception
   --suppress 53002: doc exists error for oracle installed docs
   when ex then
     null;

end;
/


-- insert the ordcmpf.xml into the dicom repos
declare 
 xt sys.XMLtype;
 ex exception;
 pragma exception_init(ex, -53002);
 ordcmXml varchar2(32767);
 ordClob   clob;
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordcmXml := '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2007, 2009, Oracle and/or its affiliates. ' ||
'All rights reserved. -->' ||
'' ||
'<!-- ' ||
'  NAME' ||
'  ordcmpf.xml - Oracle Multimedia DICOM default preference document' ||
'  ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dnoblet     06/04/09 - XbranchMerge dnoblet_bug-8560941 from main' ||
'   dnoblet     06/02/09 - Set default value of VALIDATE_METADATA to false' ||
'   dnoblet     02/09/09 - add BINARY_SKIP_INVALID_ATTR' ||
'   rabbott     01/08/09 - add SPECIFIC_CHARACTER_SET' ||
'   myalavar    11/14/08 - add SQ_WRITE_LEN' ||
'   myalavar    11/08/08 - add PARSE_ERR   ' ||
'   myalavar    10/23/08 - add mandate_attr_tags_in_stl' ||
'   dolin       10/23/08 - add max recursion depth' ||
'   dguo        05/18/07 - change product name' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'' ||
'-->' ||
'' ||
'' ||
'<DICOM_RUNTIME_PREFERENCES xmlns="http://xmlns.oracle.com/ord/dicom/preference_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://xmlns.oracle.com/ord/dicom/preference_1_0 http://xmlns.oracle.com/ord/dicom/preference_1_0">' ||
' <DOCUMENT_HEADER>' ||
'  <dt:DOCUMENT_CHANGE_LOG>' ||
'   <dt:DOCUMENT_MODIFIER>Dongbai Guo</dt:DOCUMENT_MODIFIER>' ||
'   <dt:DOCUMENT_MODIFICATION_DATE>2007-04-09</dt:DOCUMENT_MODIFICATION_DATE>' ||
'   <dt:DOCUMENT_VERSION>1.0</dt:DOCUMENT_VERSION>' ||
'   <dt:MODIFICATION_COMMENT>Oracle default preference document</dt:MODIFICATION_COMMENT>' ||
'  </dt:DOCUMENT_CHANGE_LOG>' ||
' </DOCUMENT_HEADER>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>XML_SKIP_ATTR</PARAMETER>' ||
'  <DESCRIPTION>When encoding a DICOM attribute into XML, skip the data type components whose sizes are greater than 512 bytes</DESCRIPTION>' ||
'  <VALUE>512</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>AVG_ATTR_NUM</PARAMETER>' ||
'  <DESCRIPTION>The average number of attributes expected in a DICOM object</DESCRIPTION>' ||
'  <VALUE>200</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>CONFORMANCE_LEVEL</PARAMETER>' ||
'  <DESCRIPTION>ignore selected exceptions</DESCRIPTION>' ||
'  <VALUE>ignoreException</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>IGNORED_EXP_LIST</PARAMETER>' ||
'  <DESCRIPTION>will not throw exception if mandatory attributes are missing from a DICOM object (MISSING_ATTR), attribute length is incorrect (INVALID_LENGTH), the value multiplicity is incorrect (INVALID_VM) or error during parsing(PARSE_ERR)</DESCRIPTION>' ||
'  <VALUE>MISSING_ATTR INVALID_LENGTH MISSING_MAGIC MISSING_HEADER INVALID_VR INVALID_VM PARSE_ERR</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>OUTPUT_RAW_VALUE</PARAMETER>' ||
'  <DESCRIPTION>Whether to set rawValue attribute if an attribute fails to parse</DESCRIPTION>' ||
'  <VALUE>0</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>LOGGING_LEVEL</PARAMETER>' ||
'  <DESCRIPTION>Document warnings in log</DESCRIPTION>' ||
'  <VALUE>warning</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>VALIDATE_METADATA</PARAMETER>' ||
'  <DESCRIPTION>Validate XML Metadata document</DESCRIPTION>' ||
'  <VALUE>false</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>EXP_IF_NULL_ATTR_IN_CONSTRAINT</PARAMETER>' ||
'  <DESCRIPTION>Whether to throw exception if null attribute value is encountered during conformance validation. When EXP_IF_NULL_ATTR_IN_CONSTRAINT is false, exception will not be thrown and when null attribute value is encountered when evaluating a predicate, the predicate returns false.</DESCRIPTION>' ||
'  <VALUE>true</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>MAX_RECURSION_DEPTH</PARAMETER>' ||
'  <DESCRIPTION>The maximum level of recursion when evaluating a recursive constraint during conformation validation</DESCRIPTION>' ||
'  <VALUE>16</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>MANDATE_ATTR_TAGS_IN_STL</PARAMETER>' ||
'  <DESCRIPTION>All tags in the constraint and mapping docs must be listed in the STORED_TAG_LIST document</DESCRIPTION>' ||
'  <VALUE>false</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>SQ_WRITE_LEN</PARAMETER>' ||
'  <DESCRIPTION>All sequence types are encoded in XML with explicit length and without sequence delimtors</DESCRIPTION>' ||
'  <VALUE>true</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>SPECIFIC_CHARACTER_SET</PARAMETER>' ||
'  <DESCRIPTION>This parameter determines how data elements SH (Short String), LO (Long String), ST (Short Text), LT (Long Text), PN (Person Name) or UT (Unlimited Text) are decoded when the Specific Character Set (0008,0005) Attribute is missing</DESCRIPTION>' ||
'  <VALUE>ASCII</VALUE>' ||
' </PREFERENCE_DEF>' ||
' <PREFERENCE_DEF>' ||
'  <PARAMETER>BINARY_SKIP_INVALID_ATTR</PARAMETER>' ||
'  <DESCRIPTION>Attribute values that violate the DICOM specification are truncated to length 0 in binary output resulting from a copy</DESCRIPTION>' ||
'  <VALUE>false</VALUE>' ||
' </PREFERENCE_DEF>' ||
'</DICOM_RUNTIME_PREFERENCES>';

 sys.dbms_lob.write(ordClob, length(ordcmXml), 1, ordcmXml);

 xt := new sys.XMLType(ordClob);
 ordsys.ord_dicom_admin.insertDocument('ordcmpf.xml','PREFERENCE',xt);
 sys.dbms_lob.freeTemporary(ordClob);

 exception
   --suppress 53002: doc exists error for oracle installed docs
   when ex then
     null;

end;
/


-- insert the ordcmui.xml into the dicom repos
declare 
 xt sys.XMLtype;
 ex exception;
 pragma exception_init(ex, -53002);
 ordcmXml varchar2(32767);
 ordClob   clob;
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordcmXml := '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'  NAME' ||
'   ordcmui.xml - Oracle Multimedia DICOM default uid definition document' ||
'  ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   fechen      05/23/08 - change the deflated transfer syntax UID attribute. ' ||
'   dolin       06/06/07 - ' ||
'   dguo        05/18/07 - change product name' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'' ||
'-->' ||
'' ||
'<DICOM_UID_DEFINITIONS xmlns="http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0 http://xmlns.oracle.com/ord/dicom/UIDdefinition_1_0">' ||
'  <DOCUMENT_HEADER>' ||
'    <dt:DOCUMENT_CHANGE_LOG>' ||
'      <dt:DOCUMENT_MODIFIER>Dongbai Guo</dt:DOCUMENT_MODIFIER>' ||
'      <dt:DOCUMENT_MODIFICATION_DATE>2007-04-09</dt:DOCUMENT_MODIFICATION_DATE>' ||
'      <dt:DOCUMENT_VERSION>1.0</dt:DOCUMENT_VERSION>' ||
'      <dt:MODIFICATION_COMMENT>Oracle default uid definition document</dt:MODIFICATION_COMMENT>' ||
'      <dt:BASE_DOCUMENT>DICOM Base Standard 2007 - Part 6</dt:BASE_DOCUMENT>' ||
'      <dt:BASE_DOCUMENT_DESCRIPTION>Downloadable from http://medical.nema.org/</dt:BASE_DOCUMENT_DESCRIPTION>' ||
'    </dt:DOCUMENT_CHANGE_LOG>' ||
'  </DOCUMENT_HEADER>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.1.1</UID>' ||
'    <NAME>Verification SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isEVR="false" isLE="true" isCompressed="false">' ||
'    <UID>1.2.840.10008.1.2</UID>' ||
'    <NAME>Implicit VR Little Endian: Default Transfer Syntax for DICOM</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isEVR="true" isLE="true" isCompressed="false">' ||
'    <UID>1.2.840.10008.1.2.1</UID>' ||
'    <NAME>Explicit VR Little Endian</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isEVR="true" isLE="true" isCompressed="false">' ||
'    <UID>1.2.840.10008.1.2.1.99</UID>' ||
'    <NAME>Deflated Explicit VR Little Endian</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isEVR="true" isLE="false" isCompressed="false">' ||
'    <UID>1.2.840.10008.1.2.2</UID>' ||
'    <NAME>Explicit VR Big Endian</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isEVR="true" isLE="true" isCompressed="true">' ||
'    <UID>1.2.840.10008.1.2.4.50</UID>' ||
'    <NAME>JPEG Baseline (Process 1): Default Transfer Syntax for Lossy JPEG 8 Bit Image Compression</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.51</UID>' ||
'    <NAME>JPEG Extended (Process 2  and 4): Default Transfer Syntax for Lossy JPEG 12 Bit Image Compression (Process 4 only)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.52</UID>' ||
'    <NAME>JPEG Extended (Process 3 and 5) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.53</UID>' ||
'    <NAME>JPEG Spectral Selection, Non-Hierarchical (Process 6 and 8) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.54</UID>' ||
'    <NAME>JPEG Spectral Selection, Non-Hierarchical (Process 7 and 9) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.55</UID>' ||
'    <NAME>JPEG Full Progression, Non-Hierarchical (Process 10 and 12) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.56</UID>' ||
'    <NAME>JPEG Full Progression, Non-Hierarchical (Process 11 and 13) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.57</UID>' ||
'    <NAME>JPEG Lossless, Non-Hierarchical(Process 14)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.58</UID>' ||
'    <NAME>JPEG Lossless, Non-Hierarchical(Process 15) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.59</UID>' ||
'    <NAME>JPEG Extended, Hierarchical (Process 16 and 18) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.60</UID>' ||
'    <NAME>JPEG Extended, Hierarchical (Process 17 and 19) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.61</UID>' ||
'    <NAME>JPEG Spectral Selection, Hierarchical (Process 20 and 22) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.62</UID>' ||
'    <NAME>JPEG Spectral Selection, Hierarchical (Process 21 and 23) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.63</UID>' ||
'    <NAME>JPEG Full Progression, Hierarchical (Process 24 and 26)(Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.64</UID>' ||
'    <NAME>JPEG Full Progression, Hierarchical (Process 25 and 27) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.65</UID>' ||
'    <NAME>JPEG Lossless, Hierarchical (Process 28) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true" retired="true">' ||
'    <UID>1.2.840.10008.1.2.4.66</UID>' ||
'    <NAME>JPEG Lossless, Hierarchical (Process 29) (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.70</UID>' ||
'    <NAME>JPEG Lossless, Non-Hierarchical, First-Order Prediction (Process 14) </NAME>' ||
'    <DESCRIPTION>JPEG Lossless, Non-Hierarchical, First-Order Prediction (Process 14 [Selection Value 1]): Default Transfer Syntax for Lossless JPEG Image Compression</DESCRIPTION>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.80</UID>' ||
'    <NAME>JPEG-LS Lossless Image Compression</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.81</UID>' ||
'    <NAME>JPEG-LS Lossy (Near-Lossless) Image Compression</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.90</UID>' ||
'    <NAME>JPEG 2000 Image Compression (Lossless Only)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.91</UID>' ||
'    <NAME>JPEG 2000 Image Compression</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.92</UID>' ||
'    <NAME>JPEG 2000 Part 2 Multi-component Image Compression (Lossless Only)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.93</UID>' ||
'    <NAME>JPEG 2000 Part 2 Multi-component Image Compression</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.94</UID>' ||
'    <NAME>JPIP Referenced</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.95</UID>' ||
'    <NAME>JPIP Referenced Deflate</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.4.100</UID>' ||
'    <NAME>MPEG2 Main Profile @ Main Level</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.5</UID>' ||
'    <NAME>RLE Lossless</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="transferSyntax" isCompressed="true" isEVR="true" isLE="true">' ||
'    <UID>1.2.840.10008.1.2.6.1</UID>' ||
'    <NAME>RFC 2557 MIME encapsulation</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.1.3.10</UID>' ||
'    <NAME>Media Storage Directory Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.1</UID>' ||
'    <NAME>Talairach Brain Atlas Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.2</UID>' ||
'    <NAME>SPM2 T1 Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.3</UID>' ||
'    <NAME>SPM2 T2 Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.4</UID>' ||
'    <NAME>SPM2 PD Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.5</UID>' ||
'    <NAME>SPM2 EPI Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.6</UID>' ||
'    <NAME>SPM2 FIL T1 Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.7</UID>' ||
'    <NAME>SPM2 PET Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.8</UID>' ||
'    <NAME>SPM2 TRANSM Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.9</UID>' ||
'    <NAME>SPM2 SPECT Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.10</UID>' ||
'    <NAME>SPM2 GRAY Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.11</UID>' ||
'    <NAME>SPM2 WHITE Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.12</UID>' ||
'    <NAME>SPM2 CSF Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.13</UID>' ||
'    <NAME>SPM2 BRAINMASK Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.14</UID>' ||
'    <NAME>SPM2 AVG305T1 Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.15</UID>' ||
'    <NAME>SPM2 AVG152T1 Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.16</UID>' ||
'    <NAME>SPM2 AVG152T2 Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.17</UID>' ||
'    <NAME>SPM2 AVG152PD Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.1.18</UID>' ||
'    <NAME>SPM2 SINGLESUBJT1 Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.2.1</UID>' ||
'    <NAME>ICBM 452 T1 Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="frameOfRef">' ||
'    <UID>1.2.840.10008.1.4.2.2</UID>' ||
'    <NAME>ICBM Single Subject MRI Frame of Reference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.1.9</UID>' ||
'    <NAME>Basic Study Content Notification SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.1.20.1</UID>' ||
'    <NAME>Storage Commitment Push Model SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.1.20.1.1</UID>' ||
'    <NAME>Storage Commitment Push Model SOP Instance</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.1.20.2</UID>' ||
'    <NAME>Storage Commitment Pull Model SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.1.20.2.1</UID>' ||
'    <NAME>Storage Commitment Pull Model SOP Instance (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.1.40</UID>' ||
'    <NAME>Procedural Event Logging SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.1.40.1</UID>' ||
'    <NAME>Procedural Event Logging SOP Instance</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.2.6.1</UID>' ||
'    <NAME>DICOM UID Registry</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.2.16.4</UID>' ||
'    <NAME>DICOM Controlled Terminology</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.3.1.1.1</UID>' ||
'    <NAME>DICOM Application Context Name</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.3.1.2.1.1</UID>' ||
'    <NAME>Detached Patient Management SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.3.1.2.1.4</UID>' ||
'    <NAME>Detached Patient Management Meta SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.3.1.2.2.1</UID>' ||
'    <NAME>Detached Visit Management SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.3.1.2.3.1</UID>' ||
'    <NAME>Detached Study Management SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.3.1.2.3.2</UID>' ||
'    <NAME>Study Component Management SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.3.1.2.3.3</UID>' ||
'    <NAME>Modality Performed Procedure Step SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.3.1.2.3.4</UID>' ||
'    <NAME>Modality Performed Procedure Step Retrieve SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.3.1.2.3.5</UID>' ||
'    <NAME>Modality Performed Procedure Step Notification SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.3.1.2.5.1</UID>' ||
'    <NAME>Detached Results Management SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.3.1.2.5.4</UID>' ||
'    <NAME>Detached Results Management Meta SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.3.1.2.5.5</UID>' ||
'    <NAME>Detached Study Management Meta SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.3.1.2.6.1</UID>' ||
'    <NAME>Detached Interpretation Management SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.4.2</UID>' ||
'    <NAME>Storage Service Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.1</UID>' ||
'    <NAME>Basic Film Session SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.2</UID>' ||
'    <NAME>Basic Film Box SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.4</UID>' ||
'    <NAME>Basic Grayscale Image Box SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.4.1</UID>' ||
'    <NAME>Basic Color Image Box SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.4.2</UID>' ||
'    <NAME>Referenced Image Box SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.9</UID>' ||
'    <NAME>Basic Grayscale Print Management Meta SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.9.1</UID>' ||
'    <NAME>Referenced Grayscale Print Management Meta SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.14</UID>' ||
'    <NAME>Print Job SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.15</UID>' ||
'    <NAME>Basic Annotation Box SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.16</UID>' ||
'    <NAME>Printer SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.16.376</UID>' ||
'    <NAME>Printer Configuration Retrieval SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.17</UID>' ||
'    <NAME>Printer SOP Instance</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.17.376</UID>' ||
'    <NAME>Printer Configuration Retrieval SOP Instance</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.18</UID>' ||
'    <NAME>Basic Color Print Management Meta SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.18.1</UID>' ||
'    <NAME>Referenced Color Print Management Meta SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.22</UID>' ||
'    <NAME>VOI LUT Box SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.1.23</UID>' ||
'    <NAME>Presentation LUT SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.24</UID>' ||
'    <NAME>Image Overlay Box SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.24.1</UID>' ||
'    <NAME>Basic Print Image Overlay Box SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.25</UID>' ||
'    <NAME>Print Queue SOP Instance (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.26</UID>' ||
'    <NAME>Print Queue Management SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.27</UID>' ||
'    <NAME>Stored Print Storage SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.29</UID>' ||
'    <NAME>Hardcopy Grayscale Image Storage SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.30</UID>' ||
'    <NAME>Hardcopy Color Image Storage SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.31</UID>' ||
'    <NAME>Pull Print Request SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.1.32</UID>' ||
'    <NAME>Pull Stored Print Management Meta SOP Class (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.1.33</UID>' ||
'    <NAME>Media Creation Management SOP Class UID</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.1</UID>' ||
'    <NAME>Computed Radiography Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.1.1</UID>' ||
'    <NAME>Digital X-Ray Image Storage For Presentation</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.1.1.1</UID>' ||
'    <NAME>Digital X-Ray Image Storage For Processing</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.1.2</UID>' ||
'    <NAME>Digital Mammography X-Ray Image Storage For Presentation</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.1.2.1</UID>' ||
'    <NAME>Digital Mammography X-Ray Image Storage For Processing</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.1.3</UID>' ||
'    <NAME>Digital Intra-oral X-Ray Image Storage For Presentation</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.1.3.1</UID>' ||
'    <NAME>Digital Intra-oral X-Ray Image Storage For Processing</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.2</UID>' ||
'    <NAME>CT Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.2.1</UID>' ||
'    <NAME>Enhanced CT Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.3</UID>' ||
'    <NAME>Ultrasound Multi-frame Image Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.3.1</UID>' ||
'    <NAME>Ultrasound Multi-frame Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.4</UID>' ||
'    <NAME>MR Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.4.1</UID>' ||
'    <NAME>Enhanced MR Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.4.2</UID>' ||
'    <NAME>MR Spectroscopy Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.5</UID>' ||
'    <NAME>Nuclear Medicine Image Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.6</UID>' ||
'    <NAME>Ultrasound Image Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.6.1</UID>' ||
'    <NAME>Ultrasound Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.7</UID>' ||
'    <NAME>Secondary Capture Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.7.1</UID>' ||
'    <NAME>Multi-frame Single Bit Secondary Capture Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.7.2</UID>' ||
'    <NAME>Multi-frame Grayscale Byte Secondary Capture Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.7.3</UID>' ||
'    <NAME>Multi-frame Grayscale Word Secondary Capture Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.7.4</UID>' ||
'    <NAME>Multi-frame True Color Secondary Capture Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.8</UID>' ||
'    <NAME>Standalone Overlay Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.9</UID>' ||
'    <NAME>Standalone Curve Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.9.1.1</UID>' ||
'    <NAME>12-lead ECG Waveform Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.9.1.2</UID>' ||
'    <NAME>General ECG Waveform Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.9.1.3</UID>' ||
'    <NAME>Ambulatory ECG Waveform Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.9.2.1</UID>' ||
'    <NAME>Hemodynamic Waveform Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.9.3.1</UID>' ||
'    <NAME>Cardiac Electrophysiology Waveform Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.9.4.1</UID>' ||
'    <NAME>Basic Voice Audio Waveform Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.10</UID>' ||
'    <NAME>Standalone Modality LUT Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.11</UID>' ||
'    <NAME>Standalone VOI LUT Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.11.1</UID>' ||
'    <NAME>Grayscale Softcopy Presentation State Storage SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.11.2</UID>' ||
'    <NAME>Color Softcopy Presentation State Storage SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.11.3</UID>' ||
'    <NAME>Pseudo-Color Softcopy Presentation State Storage SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.11.4</UID>' ||
'    <NAME>Blending Softcopy Presentation State Storage SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.12.1</UID>' ||
'    <NAME>X-Ray Angiographic Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.12.1.1</UID>' ||
'    <NAME>Enhanced XA Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.12.2</UID>' ||
'    <NAME>X-Ray Radiofluoroscopic Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.12.2.1</UID>' ||
'    <NAME>Enhanced XRF Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.12.3</UID>' ||
'    <NAME>X-Ray Angiographic Bi-Plane Image Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.20</UID>' ||
'    <NAME>Nuclear Medicine Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ;

 sys.dbms_lob.write(ordClob, length(ordcmXml), 1, ordcmXml);

  ordcmXml := 
'    <UID>1.2.840.10008.5.1.4.1.1.66</UID>' ||
'    <NAME>Raw Data Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.66.1</UID>' ||
'    <NAME>Spatial Registration Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.66.2</UID>' ||
'    <NAME>Spatial Fiducials Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.66.3</UID>' ||
'    <NAME>Deformable Spatial Registration Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.66.4</UID>' ||
'    <NAME>Segmentation Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.67</UID>' ||
'    <NAME>Real World Value Mapping Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1</UID>' ||
'    <NAME>VL Image Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.2</UID>' ||
'    <NAME>VL Multi-frame Image Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.1</UID>' ||
'    <NAME>VL Endoscopic Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.1.1</UID>' ||
'    <NAME>Video Endoscopic Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.2</UID>' ||
'    <NAME>VL Microscopic Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.2.1</UID>' ||
'    <NAME>Video Microscopic Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.3</UID>' ||
'    <NAME>VL Slide-Coordinates Microscopic Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.4</UID>' ||
'    <NAME>VL Photographic Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.4.1</UID>' ||
'    <NAME>Video Photographic Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.5.1</UID>' ||
'    <NAME>Ophthalmic Photography 8 Bit Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.5.2</UID>' ||
'    <NAME>Ophthalmic Photography 16 Bit Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.77.1.5.3</UID>' ||
'    <NAME>Stereometric Relationship Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="report">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.88.11</UID>' ||
'    <NAME>Basic Text SR</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="report">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.88.22</UID>' ||
'    <NAME>Enhanced SR</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="report">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.88.33</UID>' ||
'    <NAME>Comprehensive SR</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.88.40</UID>' ||
'    <NAME>Procedure Log Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="report">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.88.50</UID>' ||
'    <NAME>Mammography CAD SR</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.88.59</UID>' ||
'    <NAME>Key Object Selection Document</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="report">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.88.65</UID>' ||
'    <NAME>Chest CAD SR</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="report">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.88.67</UID>' ||
'    <NAME>X-Ray Radiation Dose SR</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.104.1</UID>' ||
'    <NAME>Encapsulated PDF Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.128</UID>' ||
'    <NAME>Positron Emission Tomography Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.129</UID>' ||
'    <NAME>Standalone PET Curve Storage (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.481.1</UID>' ||
'    <NAME>RT Image Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.481.2</UID>' ||
'    <NAME>RT Dose Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.481.3</UID>' ||
'    <NAME>RT Structure Set Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.481.4</UID>' ||
'    <NAME>RT Beams Treatment Record Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.481.5</UID>' ||
'    <NAME>RT Plan Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.481.6</UID>' ||
'    <NAME>RT Brachy Treatment Record Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.481.7</UID>' ||
'    <NAME>RT Treatment Summary Record Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="image">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.481.8</UID>' ||
'    <NAME>RT Ion Plan Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.1.481.9</UID>' ||
'    <NAME>RT Ion Beams Treatment Record Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.2.1.1</UID>' ||
'    <NAME>Patient Root Query/Retrieve Information Model - FIND</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.2.1.2</UID>' ||
'    <NAME>Patient Root Query/Retrieve Information Model - MOVE</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.2.1.3</UID>' ||
'    <NAME>Patient Root Query/Retrieve Information Model - GET</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.2.2.1</UID>' ||
'    <NAME>Study Root Query/Retrieve Information Model - FIND</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.2.2.2</UID>' ||
'    <NAME>Study Root Query/Retrieve Information Model - MOVE</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.1.2.2.3</UID>' ||
'    <NAME>Study Root Query/Retrieve Information Model - GET</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.2.3.1</UID>' ||
'    <NAME>Patient/Study Only Query/Retrieve Information Model - FIND (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.2.3.2</UID>' ||
'    <NAME>Patient/Study Only Query/Retrieve Information Model - MOVE (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other" retired="true">' ||
'    <UID>1.2.840.10008.5.1.4.1.2.3.3</UID>' ||
'    <NAME>Patient/Study Only Query/Retrieve Information Model - GET (Retired)</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.31</UID>' ||
'    <NAME>Modality Worklist Information Model - FIND</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.32.1</UID>' ||
'    <NAME>General Purpose Worklist Information Model - FIND</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.32.2</UID>' ||
'    <NAME>General Purpose Scheduled Procedure Step SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.32.3</UID>' ||
'    <NAME>General Purpose Performed Procedure Step SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.32</UID>' ||
'    <NAME>General Purpose Worklist Management Meta SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.33</UID>' ||
'    <NAME>Instance Availability Notification SOP Class</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.37.1</UID>' ||
'    <NAME>General Relevant Patient Information Query</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.37.2</UID>' ||
'    <NAME>Breast Imaging Relevant Patient Information Query</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.37.3</UID>' ||
'    <NAME>Cardiac Relevant Patient Information Query</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="storageClass" contentType="other">' ||
'    <UID>1.2.840.10008.5.1.4.38.1</UID>' ||
'    <NAME>Hanging Protocol Storage</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.38.2</UID>' ||
'    <NAME>Hanging Protocol Information Model - FIND</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="other">' ||
'    <UID>1.2.840.10008.5.1.4.38.3</UID>' ||
'    <NAME>Hanging Protocol Information Model - MOVE</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.1</UID>' ||
'    <NAME>dicomDeviceName</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.2</UID>' ||
'    <NAME>dicomDescription</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.3</UID>' ||
'    <NAME>dicomManufacturer</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.4</UID>' ||
'    <NAME>dicomManufacturerModelName</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.5</UID>' ||
'    <NAME>dicomSoftwareVersion</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.6</UID>' ||
'    <NAME>dicomVendorData</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.7</UID>' ||
'    <NAME>dicomAETitle</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.8</UID>' ||
'    <NAME>dicomNetworkConnectionReference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.9</UID>' ||
'    <NAME>dicomApplicationCluster</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.10</UID>' ||
'    <NAME>dicomAssociationInitiator</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.11</UID>' ||
'    <NAME>dicomAssociationAcceptor</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.12</UID>' ||
'    <NAME>dicomHostname</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.13</UID>' ||
'    <NAME>dicomPort</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.14</UID>' ||
'    <NAME>dicomSOPClass</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.15</UID>' ||
'    <NAME>dicomTransferRole</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.16</UID>' ||
'    <NAME>dicomTransferSyntax</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.17</UID>' ||
'    <NAME>dicomPrimaryDeviceType</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.18</UID>' ||
'    <NAME>dicomRelatedDeviceReference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.19</UID>' ||
'    <NAME>dicomPreferredCalledAETitle</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.20</UID>' ||
'    <NAME>dicomTLSCyphersuite</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.21</UID>' ||
'    <NAME>dicomAuthorizedNodeCertificateReference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.22</UID>' ||
'    <NAME>dicomThisNodeCertificateReference</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.23</UID>' ||
'    <NAME>dicomInstalled</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.24</UID>' ||
'    <NAME>dicomStationName</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.25</UID>' ||
'    <NAME>dicomDeviceSerialNumber</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.26</UID>' ||
'    <NAME>dicomInstitutionName</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.27</UID>' ||
'    <NAME>dicomInstitutionAddress</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.28</UID>' ||
'    <NAME>dicomInstitutionDepartmentName</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.29</UID>' ||
'    <NAME>dicomIssuerOfPatientID</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.30</UID>' ||
'    <NAME>dicomPreferredCallingAETitle</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.3.31</UID>' ||
'    <NAME>dicomSupportedCharacterSet</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.4.1</UID>' ||
'    <NAME>dicomConfigurationRoot</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.4.2</UID>' ||
'    <NAME>dicomDevicesRoot</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.4.3</UID>' ||
'    <NAME>dicomUniqueAETitlesRegistryRoot</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.4.4</UID>' ||
'    <NAME>dicomDevice</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.4.5</UID>' ||
'    <NAME>dicomNetworkAE</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.4.6</UID>' ||
'    <NAME>dicomNetworkConnection</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.4.7</UID>' ||
'    <NAME>dicomUniqueAETitle</NAME>' ||
'  </UID_DEF>' ||
'  <UID_DEF classification="ldapOID">' ||
'    <UID>1.2.840.10008.15.0.4.8</UID>' ||
'    <NAME>dicomTransferCapability</NAME>' ||
'  </UID_DEF>' ||
'</DICOM_UID_DEFINITIONS>';
  sys.dbms_lob.writeAppend(ordClob, length(ordcmXml), ordcmXml);

 xt := new sys.XMLType(ordClob);
 ordsys.ord_dicom_admin.insertDocument('ordcmui.xml','UID_DEFINITION',xt);
 sys.dbms_lob.freeTemporary(ordClob);

 exception
   --suppress 53002: doc exists error for oracle installed docs
   when ex then
     null;

end;
/


-- insert the ordcmcmc.xml into the dicom repos
declare 
 xt sys.XMLtype;
 ex exception;
 pragma exception_init(ex, -53002);
 ordcmXml varchar2(32767);
 ordClob   clob;
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordcmXml := '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'  NAME' ||
'  ordcmcmc.xml - Oracle Multimedia DICOM default constraint macro ' ||
'                 definition document' ||
'  ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dolin       06/06/07 - ' ||
'   dguo        05/18/07 - change product name' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'' ||
'-->' ||
'' ||
'<CONFORMANCE_CONSTRAINT_DEFINITION xmlns="http://xmlns.oracle.com/ord/dicom/constraint_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://xmlns.oracle.com/ord/dicom/constraint_1_0 http://xmlns.oracle.com/ord/dicom/constraint_1_0">' ||
'  <DOCUMENT_HEADER>' ||
'    <dt:DOCUMENT_CHANGE_LOG>' ||
'      <dt:DOCUMENT_MODIFIER>Dongbai Guo</dt:DOCUMENT_MODIFIER>' ||
'      <dt:DOCUMENT_MODIFICATION_DATE>2007-04-09</dt:DOCUMENT_MODIFICATION_DATE>' ||
'      <dt:DOCUMENT_VERSION>1.0</dt:DOCUMENT_VERSION>' ||
'      <dt:MODIFICATION_COMMENT>Oracle default constraint macro definition</dt:MODIFICATION_COMMENT>' ||
'      <dt:BASE_DOCUMENT>DICOM Base Standard 2007, Part 3.3</dt:BASE_DOCUMENT>' ||
'      <dt:BASE_DOCUMENT_RELEASE_DATE>2007-01-01</dt:BASE_DOCUMENT_RELEASE_DATE>' ||
'      <dt:BASE_DOCUMENT_DESCRIPTION>Downloadable from http://medical.nema.org/</dt:BASE_DOCUMENT_DESCRIPTION>' ||
'    </dt:DOCUMENT_CHANGE_LOG>' ||
'  </DOCUMENT_HEADER>' ||
'' ||
' <GLOBAL_MACRO name="CodeSequenceMacro">' ||
'   <DESCRIPTION>' ||
'     A subset of Code Sequence Macro defined in DICOM standard, ' ||
'     PS 3.3-2007, Table 8.8-1' ||
'   </DESCRIPTION>' ||
'  <PARAMETER_DECLARATION>CodeAttr</PARAMETER_DECLARATION>' ||
'  <PREDICATE>' ||
'   <DESCRIPTION>Code value must not be empty</DESCRIPTION>' ||
'   <BOOLEAN_FUNC operator="notEmpty">' ||
'    <ATTRIBUTE_TAG>${CodeAttr}.00080100</ATTRIBUTE_TAG>' ||
'   </BOOLEAN_FUNC>' ||
'  </PREDICATE>' ||
'  <PREDICATE>' ||
'   <DESCRIPTION>Coding scheme designator must not be empty</DESCRIPTION>' ||
'   <BOOLEAN_FUNC operator="notEmpty">' ||
'    <ATTRIBUTE_TAG>${CodeAttr}.00080102</ATTRIBUTE_TAG>' ||
'   </BOOLEAN_FUNC>' ||
'  </PREDICATE>' ||
' </GLOBAL_MACRO>' ||
' <GLOBAL_MACRO name="PersonIdentifierMacro">' ||
'   <DESCRIPTION>' ||
'     A subset of Person Identifier Macro defined in DICOM standard, ' ||
'     PS 3.3-2007, Table 10-1' ||
'   </DESCRIPTION>' ||
'  <PARAMETER_DECLARATION>PersonIDAttr</PARAMETER_DECLARATION>' ||
'  <PREDICATE>' ||
'   <INVOKE_MACRO>' ||
'    <MACRO_NAME>CodeSequenceMacro</MACRO_NAME>' ||
'    <PARAMETER>' ||
'     <NAME>CodeAttr</NAME>' ||
'     <VALUE>${PersonIDAttr}.00401101</VALUE>' ||
'    </PARAMETER>' ||
'   </INVOKE_MACRO>' ||
'  </PREDICATE>' ||
' </GLOBAL_MACRO>' ||
'</CONFORMANCE_CONSTRAINT_DEFINITION>';

 sys.dbms_lob.write(ordClob, length(ordcmXml), 1, ordcmXml);

 xt := new sys.XMLType(ordClob);
 ordsys.ord_dicom_admin.insertDocument('ordcmcmc.xml','CONSTRAINT',xt);
 sys.dbms_lob.freeTemporary(ordClob);

 exception
   --suppress 53002: doc exists error for oracle installed docs
   when ex then
     null;

end;
/


-- insert the ordcmcmd.xml into the dicom repos
declare 
 xt sys.XMLtype;
 ex exception;
 pragma exception_init(ex, -53002);
 ordcmXml varchar2(32767);
 ordClob   clob;
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordcmXml := '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'  NAME' ||
'  ordcmcmd.xml - Oracle Multimedia DICOM default constraint ' ||
'                 module definition document' ||
'  ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dolin       06/06/07 - ' ||
'   dguo        05/18/07 - change product name' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'' ||
'-->' ||
'' ||
'<CONFORMANCE_CONSTRAINT_DEFINITION xmlns="http://xmlns.oracle.com/ord/dicom/constraint_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://xmlns.oracle.com/ord/dicom/constraint_1_0 http://xmlns.oracle.com/ord/dicom/constraint_1_0">' ||
' <DOCUMENT_HEADER>' ||
'  <dt:DOCUMENT_CHANGE_LOG>' ||
'   <dt:DOCUMENT_MODIFIER>Dongbai Guo</dt:DOCUMENT_MODIFIER>' ||
'   <dt:DOCUMENT_MODIFICATION_DATE>2007-04-09</dt:DOCUMENT_MODIFICATION_DATE>' ||
'   <dt:DOCUMENT_VERSION>1.0</dt:DOCUMENT_VERSION>' ||
'   <dt:MODIFICATION_COMMENT>Oracle default constraint module definition</dt:MODIFICATION_COMMENT>' ||
'   <dt:BASE_DOCUMENT>DICOM Base Standard 2007 Part 3.3</dt:BASE_DOCUMENT>' ||
'   <dt:BASE_DOCUMENT_RELEASE_DATE>2007-01-01</dt:BASE_DOCUMENT_RELEASE_DATE>' ||
'   <dt:BASE_DOCUMENT_DESCRIPTION>Downloadable from http://medical.nema.org/</dt:BASE_DOCUMENT_DESCRIPTION>' ||
'  </dt:DOCUMENT_CHANGE_LOG>' ||
' </DOCUMENT_HEADER>' ||
'' ||
' <EXTERNAL_MACRO_INCLUDE name="CodeSequenceMacro">Defines a code sequence macro</EXTERNAL_MACRO_INCLUDE>' ||
' <EXTERNAL_MACRO_INCLUDE name="PersonIdentifierMacro">Defines a person identification macro</EXTERNAL_MACRO_INCLUDE>' ||
' <GLOBAL_RULE name="PatientModule">' ||
'   <DESCRIPTION>' ||
'     A subset of Patient Module defined in DICOM standard, ' ||
'     PS 3.3-2007, Table C.7-1' ||
'   </DESCRIPTION>' ||
'   <PREDICATE>' ||
'     <BOOLEAN_FUNC operator="notEmpty">' ||
'       <ATTRIBUTE_TAG>00100040</ATTRIBUTE_TAG>' ||
'     </BOOLEAN_FUNC>' ||
'   </PREDICATE>' ||
'   <PREDICATE>' ||
'     <DESCRIPTION>Patient''s Sex</DESCRIPTION>' ||
'     <RELATIONAL operator="in">' ||
'       <ATTRIBUTE_TAG>00100040</ATTRIBUTE_TAG>' ||
'       <STRING_VALUE>M</STRING_VALUE>' ||
'       <STRING_VALUE>F</STRING_VALUE>' ||
'       <STRING_VALUE>O</STRING_VALUE>' ||
'     </RELATIONAL>' ||
'   </PREDICATE>' ||
'   <PREDICATE>' ||
'     <DESCRIPTION>Referenced patient sequence constraint</DESCRIPTION>' ||
'     <LOGICAL operator="derive">' ||
'       <PREDICATE>' ||
'         <BOOLEAN_FUNC operator="occurs">' ||
'           <ATTRIBUTE_TAG>00081120</ATTRIBUTE_TAG>' ||
'         </BOOLEAN_FUNC>' ||
'       </PREDICATE>' ||
'       <PREDICATE>' ||
'         <LOGICAL operator="and">' ||
'           <PREDICATE>' ||
'             <BOOLEAN_FUNC operator="notEmpty">' ||
'               <ATTRIBUTE_TAG>00081120.00081150</ATTRIBUTE_TAG>' ||
'             </BOOLEAN_FUNC>' ||
'           </PREDICATE>' ||
'           <PREDICATE>' ||
'             <BOOLEAN_FUNC operator="notEmpty">' ||
'               <ATTRIBUTE_TAG>00081120.00081155</ATTRIBUTE_TAG>' ||
'             </BOOLEAN_FUNC>' ||
'           </PREDICATE>    ' ||
'         </LOGICAL>' ||
'       </PREDICATE>' ||
'     </LOGICAL>' ||
'   </PREDICATE>' ||
'   <ACTION action="log" when="false">Validation error: missing mandatory attribute for patient module</ACTION>' ||
'   <ACTION action="warning" when="false">Warning: validation failure</ACTION>' ||
' </GLOBAL_RULE>' ||
' ' ||
' <GLOBAL_RULE name="GeneralStudyModule">' ||
'   <DESCRIPTION>' ||
'     A subset of General Study Module defined in DICOM standard, ' ||
'     PS 3.3-2007, Table C.7-3' ||
'   </DESCRIPTION>' ||
'   <PREDICATE>' ||
'     <DESCRIPTION>Referring Physician Identification Sequence</DESCRIPTION>' ||
'     <LOGICAL operator="derive">' ||
'       <PREDICATE>' ||
'         <BOOLEAN_FUNC operator="occurs">' ||
'           <ATTRIBUTE_TAG>00080096</ATTRIBUTE_TAG>' ||
'         </BOOLEAN_FUNC>' ||
'       </PREDICATE>' ||
'       <PREDICATE>' ||
'         <INVOKE_MACRO>' ||
'           <MACRO_NAME>PersonIdentifierMacro</MACRO_NAME>' ||
'           <PARAMETER>' ||
'             <NAME>PersonIDAttr</NAME>' ||
'             <VALUE>00080096</VALUE>' ||
'           </PARAMETER>' ||
'         </INVOKE_MACRO>' ||
'       </PREDICATE>' ||
'     </LOGICAL>' ||
'   </PREDICATE>' ||
'   <PREDICATE>' ||
'     <DESCRIPTION>Study Instance UID</DESCRIPTION>' ||
'     <BOOLEAN_FUNC operator="notEmpty">' ||
'       <ATTRIBUTE_TAG>0020000D</ATTRIBUTE_TAG>' ||
'     </BOOLEAN_FUNC>' ||
'   </PREDICATE>' ||
' </GLOBAL_RULE>' ||
'  ' ||
'  <GLOBAL_RULE name="GeneralSeriesModule">' ||
'    <DESCRIPTION>' ||
'      A subset of General Series Module defined in DICOM standard,' ||
'      PS 3.3-2007, Table C.7-5a' ||
'    </DESCRIPTION>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00080060</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'      <ACTION action="warning" when="false">' ||
'        missing attribute 00080060 ' ||
'      </ACTION>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>0020000E</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'      <ACTION action="warning" when="false">' ||
'        missing attribute 0020000E ' ||
'      </ACTION>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <LOGICAL operator="derive">' ||
'        <PREDICATE>' ||
'          <BOOLEAN_FUNC operator="notEmpty">' ||
'            <ATTRIBUTE_TAG>00400260</ATTRIBUTE_TAG>' ||
'          </BOOLEAN_FUNC>' ||
'        </PREDICATE>' ||
'        <PREDICATE>' ||
'          <INVOKE_MACRO>' ||
'            <MACRO_NAME>CodeSequenceMacro</MACRO_NAME>' ||
'            <PARAMETER>' ||
'              <NAME>CodeAttr</NAME>' ||
'              <VALUE>00400260</VALUE>' ||
'            </PARAMETER>' ||
'          </INVOKE_MACRO>' ||
'          <ACTION action="warning" when="false">' ||
'            missing attribute 00400260.00080100 or 00400260.00080102 ' ||
'          </ACTION>' ||
'        </PREDICATE>' ||
'      </LOGICAL>' ||
'    </PREDICATE>' ||
'    <ACTION action="warning" when="false">' ||
'      GeneralSeriesModule is not satisfied' ||
'    </ACTION>' ||
'  </GLOBAL_RULE>  ' ||
'' ||
'  <GLOBAL_RULE name="SOPCommonModule">' ||
'    <DESCRIPTION>' ||
'      A subset of SOP Common Module defined in DICOM standard,' ||
'      PS 3.3-2007, Table C.12-1' ||
'    </DESCRIPTION>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00080016</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00080018</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'    </PREDICATE>' ||
'  </GLOBAL_RULE>' ||
'  ' ||
'  <GLOBAL_RULE name="ImagePixelMacro">' ||
'    <DESCRIPTION>' ||
'      A subset of Image Pixel Macro defined in DICOM standard,' ||
'      PS 3.3-2007, Table C.7-11b' ||
'    </DESCRIPTION>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00280002</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00280004</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <RELATIONAL operator="in">' ||
'        <ATTRIBUTE_TAG>00280004</ATTRIBUTE_TAG>' ||
'        <STRING_VALUE>MONOCHROME1</STRING_VALUE>' ||
'        <STRING_VALUE>MONOCHROME2</STRING_VALUE>' ||
'        <STRING_VALUE>PALETTE COLOR</STRING_VALUE>' ||
'        <STRING_VALUE>RGB</STRING_VALUE>' ||
'      </RELATIONAL>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00280010</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00280011</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <RELATIONAL operator="in">' ||
'        <ATTRIBUTE_TAG>00280100</ATTRIBUTE_TAG>' ||
'        <STRING_VALUE>8</STRING_VALUE>' ||
'        <STRING_VALUE>12</STRING_VALUE>' ||
'        <STRING_VALUE>16</STRING_VALUE>' ||
'        <STRING_VALUE>24</STRING_VALUE>' ||
'      </RELATIONAL>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00280101</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00280102</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <BOOLEAN_FUNC operator="notEmpty">' ||
'        <ATTRIBUTE_TAG>00280103</ATTRIBUTE_TAG>' ||
'      </BOOLEAN_FUNC>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <LOGICAL operator="derive">' ||
'        <PREDICATE>' ||
'          <LOGICAL operator="not">' ||
'            <PREDICATE>' ||
'              <BOOLEAN_FUNC operator="occurs">' ||
'                <ATTRIBUTE_TAG>00287FE0</ATTRIBUTE_TAG>' ||
'              </BOOLEAN_FUNC>' ||
'            </PREDICATE>' ||
'          </LOGICAL>' ||
'        </PREDICATE>' ||
'        <PREDICATE>' ||
'          <BOOLEAN_FUNC operator="notEmpty">' ||
'            <ATTRIBUTE_TAG>7FE00010</ATTRIBUTE_TAG>' ||
'          </BOOLEAN_FUNC>' ||
'        </PREDICATE>' ||
'      </LOGICAL>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <LOGICAL operator="derive">' ||
'        <PREDICATE>' ||
'          <RELATIONAL operator="gt">' ||
'            <ATTRIBUTE_TAG>00280002</ATTRIBUTE_TAG>' ||
'            <STRING_VALUE>1</STRING_VALUE>' ||
'          </RELATIONAL>' ||
'        </PREDICATE>' ||
'        <PREDICATE>' ||
'          <BOOLEAN_FUNC operator="notEmpty">' ||
'            <ATTRIBUTE_TAG>00280006</ATTRIBUTE_TAG>' ||
'          </BOOLEAN_FUNC>' ||
'        </PREDICATE>' ||
'      </LOGICAL>' ||
'    </PREDICATE>' ||
'    <PREDICATE>' ||
'      <LOGICAL operator="derive">' ||
'        <PREDICATE>' ||
'          <LOGICAL operator="or">' ||
'            <PREDICATE>' ||
'              <RELATIONAL operator="eq">' ||
'                <ATTRIBUTE_TAG>00280004</ATTRIBUTE_TAG>' ||
'                <STRING_VALUE>PALETTE COLOR</STRING_VALUE>' ||
'              </RELATIONAL>' ||
'            </PREDICATE>' ||
'            <PREDICATE>' ||
'              <LOGICAL operator="and">' ||
'                <PREDICATE>' ||
'                  <BOOLEAN_FUNC operator="notEmpty">' ||
'                    <ATTRIBUTE_TAG>00089205</ATTRIBUTE_TAG>' ||
'                  </BOOLEAN_FUNC>' ||
'                </PREDICATE>' ||
'                <PREDICATE>' ||
'                  <RELATIONAL operator="in">' ||
'                    <ATTRIBUTE_TAG>00089205</ATTRIBUTE_TAG>' ||
'                    <STRING_VALUE>COLOR</STRING_VALUE>' ||
'                    <STRING_VALUE>MIXED</STRING_VALUE>' ||
'                  </RELATIONAL>' ||
'                </PREDICATE>' ||
'              </LOGICAL>' ||
'            </PREDICATE>' ||
'          </LOGICAL>' ||
'        </PREDICATE>' ||
'        <PREDICATE>' ||
'          <LOGICAL operator="and">' ||
'            <PREDICATE>' ||
'              <BOOLEAN_FUNC operator="notEmpty">' ||
'                <ATTRIBUTE_TAG>00281101</ATTRIBUTE_TAG>' ||
'              </BOOLEAN_FUNC>' ||
'            </PREDICATE>' ||
'            <PREDICATE>' ||
'              <BOOLEAN_FUNC operator="notEmpty">' ||
'                <ATTRIBUTE_TAG>00281102</ATTRIBUTE_TAG>' ||
'              </BOOLEAN_FUNC>' ||
'            </PREDICATE>' ||
'            <PREDICATE>' ||
'              <BOOLEAN_FUNC operator="notEmpty">' ||
'                <ATTRIBUTE_TAG>00281103</ATTRIBUTE_TAG>' ||
'              </BOOLEAN_FUNC>' ||
'            </PREDICATE>' ||
'            <PREDICATE>' ||
'              <BOOLEAN_FUNC operator="notEmpty">' ||
'                <ATTRIBUTE_TAG>00281201</ATTRIBUTE_TAG>' ||
'              </BOOLEAN_FUNC>' ||
'            </PREDICATE>      ' ||
'            <PREDICATE>' ||
'              <BOOLEAN_FUNC operator="notEmpty">' ||
'                <ATTRIBUTE_TAG>00281202</ATTRIBUTE_TAG>' ||
'              </BOOLEAN_FUNC>' ||
'            </PREDICATE>      ' ||
'            <PREDICATE>' ||
'              <BOOLEAN_FUNC operator="notEmpty">' ||
'                <ATTRIBUTE_TAG>00281203</ATTRIBUTE_TAG>' ||
'              </BOOLEAN_FUNC>' ||
'            </PREDICATE>' ||
'          </LOGICAL>' ||
'        </PREDICATE>' ||
'      </LOGICAL>' ||
'    </PREDICATE>   ' ||
'  </GLOBAL_RULE>' ||
'' ||
'</CONFORMANCE_CONSTRAINT_DEFINITION>';

 sys.dbms_lob.write(ordClob, length(ordcmXml), 1, ordcmXml);

 xt := new sys.XMLType(ordClob);
 ordsys.ord_dicom_admin.insertDocument('ordcmcmd.xml','CONSTRAINT',xt);
 sys.dbms_lob.freeTemporary(ordClob);

 exception
   --suppress 53002: doc exists error for oracle installed docs
   when ex then
     null;

end;
/


-- insert the ordcmct.xml into the dicom repos
declare 
 xt sys.XMLtype;
 ex exception;
 pragma exception_init(ex, -53002);
 ordcmXml varchar2(32767);
 ordClob   clob;
begin
 sys.dbms_lob.createTemporary( ordClob, true, sys.dbms_lob.call );
 ordcmXml := '<?xml version="1.0" encoding="UTF-8"?>' ||
'<!-- Copyright (c) 2007, Oracle. All rights reserved.  ' ||
'  NAME' ||
'  ordcmct.xml - Oracle Multimedia DICOM default constraint document' ||
'  ' ||
'   MODIFIED   (MM/DD/YY)' ||
'   dolin       06/06/07 - ' ||
'   dguo        05/18/07 - change product name' ||
'   myalavar    04/09/07 - add major_minor version' ||
'   dguo        08/01/06 - Beta release 1' ||
'   dguo        04/03/05 - Created' ||
'' ||
'' ||
'-->' ||
'' ||
'<CONFORMANCE_CONSTRAINT_DEFINITION xmlns="http://xmlns.oracle.com/ord/dicom/constraint_1_0" xmlns:dt="http://xmlns.oracle.com/ord/dicom/datatype_1_0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="http://xmlns.oracle.com/ord/dicom/constraint_1_0 http://xmlns.oracle.com/ord/dicom/constraint_1_0">' ||
'  <DOCUMENT_HEADER>' ||
'    <dt:DOCUMENT_CHANGE_LOG>' ||
'      <dt:DOCUMENT_MODIFIER>Dongbai Guo</dt:DOCUMENT_MODIFIER>' ||
'      <dt:DOCUMENT_MODIFICATION_DATE>2007-04-09</dt:DOCUMENT_MODIFICATION_DATE>' ||
'      <dt:DOCUMENT_VERSION>1.0</dt:DOCUMENT_VERSION>' ||
'      <dt:MODIFICATION_COMMENT>Oracle default constraint rules</dt:MODIFICATION_COMMENT>' ||
'    </dt:DOCUMENT_CHANGE_LOG>' ||
'  </DOCUMENT_HEADER>' ||
' <EXTERNAL_RULE_INCLUDE name="ImagePixelMacro">' ||
'   A subset of Image Pixel Macro defined in DICOM standard,' ||
'   PS 3.3-2007, Table C.7-11b' ||
' </EXTERNAL_RULE_INCLUDE>' ||
' <EXTERNAL_RULE_INCLUDE name="GeneralStudyModule">' ||
'   A subset of General Study Module defined in DICOM standard, ' ||
'   PS 3.3-2007, Table C.7-3' ||
' </EXTERNAL_RULE_INCLUDE>   ' ||
' <EXTERNAL_RULE_INCLUDE name="GeneralSeriesModule">' ||
'   A subset of General Series Module defined in DICOM standard,' ||
'   PS 3.3-2007, Table C.7-5a' ||
' </EXTERNAL_RULE_INCLUDE> ' ||
' <EXTERNAL_RULE_INCLUDE  name="SOPCommonModule">' ||
'   A subset of SOP Common Module defined in DICOM standard,' ||
'   PS 3.3-2007, Table C.12-1' ||
' </EXTERNAL_RULE_INCLUDE>' ||
'' ||
' <GLOBAL_RULE name="OracleOrdDicomImage">' ||
'   <PREDICATE>' ||
'     <GLOBAL_RULE_REF>ImagePixelMacro</GLOBAL_RULE_REF>' ||
'   </PREDICATE>' ||
'   <ACTION action="warning" when="false">missing mandatory image attribute</ACTION>' ||
' </GLOBAL_RULE>' ||
' ' ||
' <GLOBAL_RULE name="OracleOrdObject">' ||
'  <PREDICATE>' ||
'    <GLOBAL_RULE_REF>SOPCommonModule</GLOBAL_RULE_REF>' ||
'  </PREDICATE>' ||
'  <PREDICATE>' ||
'    <GLOBAL_RULE_REF>GeneralSeriesModule</GLOBAL_RULE_REF>' ||
'  </PREDICATE>' ||
'  <PREDICATE>' ||
'    <GLOBAL_RULE_REF>GeneralStudyModule</GLOBAL_RULE_REF>' ||
'  </PREDICATE>  ' ||
' </GLOBAL_RULE>' ||
'</CONFORMANCE_CONSTRAINT_DEFINITION>';

 sys.dbms_lob.write(ordClob, length(ordcmXml), 1, ordcmXml);

 xt := new sys.XMLType(ordClob);
 ordsys.ord_dicom_admin.insertDocument('ordcmct.xml','CONSTRAINT',xt);
 sys.dbms_lob.freeTemporary(ordClob);

 exception
   --suppress 53002: doc exists error for oracle installed docs
   when ex then
     null;

end;
/

-- publishDataModel
exec ordsys.ord_dicom_admin.publishDataModel;
