Rem initimj.sql
Rem
Rem Copyright (c) 2004, 2009, Oracle and/or its affiliates.
Rem All rights reserved. 
Rem
Rem    NAME
Rem      initimj.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      Internal installation script for Oracle Multimedia.  Load Java 
Rem      classes under ORDSYS schema.
Rem
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smavris     03/02/09 - Remove -force on loadjava
Rem    dolin       02/06/08 - restricting permission to load classes into MM's
Rem                           packages
Rem    dolin       01/31/08 - add definer's right for DicomCtValidator inner
Rem                           class IcvMsgLogger to avoid granting logging
Rem                           permission to every user
Rem    dolin       01/28/08 - move definer rights to an inner private class 
Rem    rabbott     01/11/08 - Remove authid definer from javax.media.jai.JAI
Rem    smavris     09/11/07 - Change interMedia to Oracle Multimedia
Rem    smavris     02/15/07 - Add dbms_java.endsession to avoid ora-29549 on
Rem                           upgrade
Rem    rabbott     07/27/06 - remove definer rights from JAI classes 
Rem    smavris     06/12/06 - Install DICOM 
Rem    rabbott     11/09/05 - bug 4627986 
Rem    rabbott     09/21/05 - Special handling for native lib on Windows 
Rem    alamb       03/03/05 - make grants less permiscuous 
Rem    alamb       03/03/05 - add policy permission changes 
Rem    alamb       03/01/05 - make Operations definers rights so it can load 
Rem                           libordim10.so 
Rem    rchopra     09/23/04 - rchopra_use_install_scripts_in_testsys_040822
Rem    rchopra     09/22/04 - Created

alter session set current_schema="SYS";

REM Commence loading
set serveroutput on size 10000;

execute dbms_java.loadjava('-synonym -schema ORDSYS -resolve -grant PUBLIC ord/jlib/ordimann.jar');

Rem ordimasf.jar is only available via download from the 
Rem Oracle Technology Network website. Go to the Oracle Multimedia section of
Rem http://otn.oracle.com.
Rem
Rem Uncomment the following lines after downloading ordimasf.jar.

-- BEGIN 
-- dbms_java.loadjava('-synonym -schema ORDSYS -resolve -grant PUBLIC ord/jlib/ordimasf.jar');
-- EXCEPTION
-- WHEN OTHERS THEN
--   NULL;
-- END;
-- /

-- Note: ordimimg.jar redefines the registryFile.jai property file 
-- and thus must be loaded after jai_core.jar
-- Note: Now that 11.2 loads without -definer's rights, and as long as the
-- upgrade script cleans jars, we no longer need -force (re bug 5415304)
execute dbms_java.loadjava('-grant PUBLIC -schema ORDSYS ord/jlib/mlibwrapper_jai.jar');
execute dbms_java.loadjava('-grant PUBLIC -schema ORDSYS ord/jlib/jai_core.jar');
execute dbms_java.loadjava('-grant PUBLIC -schema ORDSYS ord/jlib/jai_codec.jar');
execute dbms_java.loadjava('-grant PUBLIC -schema ORDSYS ord/jlib/ordimimg.jar');

execute dbms_java.loadjava('-synonym -resolve -schema ORDSYS ord/jlib/jai_core.jar ord/jlib/mlibwrapper_jai.jar ord/jlib/jai_codec.jar ord/jlib/ordimimg.jar');

execute dbms_java.loadjava('-r -g PUBLIC -synonym -schema ORDSYS ord/jlib/ordimdcm.jar');

-- Restrict public permission to load classes into Oracle Multimedia Java packages
exec dbms_java.restrict_permission('PUBLIC', 'SYS:oracle.aurora.security.JServerPermission', 'LoadClassInPackage.oracle.ord.*', null);

REM Reset Java session to workaround upgrade issues
select dbms_java.endsession from dual;

set serveroutput off

REM Back to ORDSYS for remainder of install
alter session set current_schema="ORDSYS";

REM these classes require definer rights
alter java class "oracle.ord.media.img.Operations"      authid definer;
alter java class "oracle.ord.dicom.ct.DicomCtLogHandler$DBWriter" authid definer;
alter java class "oracle.ord.dicom.ct.DicomCtValidator$IcvMsgLogger" authid definer;
