Rem
Rem initimnc.sql
Rem
Rem Copyright (c) 2003, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      initimnc.sql - INIT InterMedia NComp
Rem
Rem    DESCRIPTION
Rem      Internal installation script for Oracle Multimedia (formerly
Rem      interMedia).
Rem      Loads NCOMPed Java classes into ORDSYS scheme.
Rem
Rem    NOTES
Rem      This script is intended to be called by initim.sql and ordlib.sql.
Rem

alter session set current_schema="SYS";

REM Grant loading related privs temporarily
grant JAVA_DEPLOY to ORDSYS;

REM Commence loading
set serveroutput on size 10000;

REM load NCOMP jarfiles
REM comment out the following lines to disable NCOMP usage (currently enabled)

REM create reset procedure
create or replace procedure java_reset(value IN NUMBER)
as LANGUAGE JAVA
name 'java.lang.System.exit(int)';
/

create or replace procedure reset_jvm(value IN NUMBER) is
begin
  java_reset(value);
  exception
    when others then
      if sqlcode not in (-29515) then raise; end if;
end;
/

execute reset_jvm(0);
execute dbms_java.loadjava('-resolve -schema ORDSYS ord/jlib/jai_core_depl.jar');

execute reset_jvm(0);
execute dbms_java.loadjava('-resolve -schema ORDSYS ord/jlib/jai_codec_depl.jar');

execute reset_jvm(0);
execute dbms_java.loadjava('-resolve -schema ORDSYS ord/jlib/ordimimg_depl.jar');

execute reset_jvm(0);
drop procedure reset_jvm;
drop procedure java_reset;

REM end of section to load NCOMP jarfiles


REM Now that Java and NCOMP load are completed, we can drop related privs
revoke JAVA_DEPLOY from ORDSYS;
REM End drop Java and NCOMP load privs

REM Back to ORDSYS for remainder of install
alter session set current_schema="ORDSYS";


REM Clean up NCOMP litter (invalid or zero timestamp installer classes)
declare
  -- note that we need both cursors here because some java files are
  -- compiled within the javavm, so you can't drop those derived classes
  -- directly
  cursor src_curs is 
   select object_name
   from all_objects,javasnm
   where owner = 'ORDSYS' and 
         object_type = 'JAVA SOURCE' and
         short(+) = object_name and
         (nvl(longname, object_name) like 'oracle/jaccelerator%' or
          nvl(longname, object_name) like 'oracle/aurora/deploy%');

  cursor cls_curs is 
   select object_name
   from all_objects,javasnm
   where owner = 'ORDSYS' and 
         object_type = 'JAVA CLASS' and
         short(+) = object_name and
         (nvl(longname, object_name) like 'oracle/jaccelerator%' or
          nvl(longname, object_name) like 'oracle/aurora/deploy%');
begin
  for rec in src_curs loop
    -- drop java source files
    execute immediate 'drop java source "' || rec.object_name || '"';
  end loop;

  for rec in cls_curs loop
    -- drop java class files
    execute immediate 'drop java class "' || rec.object_name || '"';
   end loop;

  commit;
end;
/

Rem
Rem Drop the definer-rights functions left by NCOMP
Rem
declare
  cursor curs is 
   select object_name
   from all_procedures
   where owner = 'ORDSYS' and 
         authid='DEFINER' and 
         object_name like 'JACCELERATOR%';
begin
  for rec in curs loop
     execute immediate 'drop function ' || rec.object_name;
  end loop;

  commit;
end;
/



set serveroutput off;
