Rem
Rem $Header: initjp2.sql 22-oct-2007.10:06:49 smavris Exp $
Rem
Rem initjp2.sql
Rem
Rem Copyright (c) 2005, 2007, Oracle. All rights reserved.  
Rem
Rem    NAME
Rem      initjp2.sql - Initializes Oracle Multimedia to use the JPEG2000 codec
Rem
Rem    DESCRIPTION
Rem      Imports the JPEG2000 codec as supplied by the Sun JAI ImageIO Tools
Rem       jar (jai_imageio.jar and clibwrapper_jiio.jar) into the database 
Rem       which enables Oracle Multimedia processing (read/write) of JPEG2000 
Rem       images.
Rem
Rem    NOTES
Rem      Oracle does not distribute a JPEG2000 implementation. 
Rem
Rem      Installation steps to enable JPEG2000 processing in Oracle:
Rem       1. Download the "CLASSPATH Install" of the "Java Advanced 
Rem           Imaging Image I/O Tools" package from 
Rem           http://java.sun.com/products/java-media/jai/
Rem
Rem       2. Extract the file jai_imageio.jar and clibwrapper_jiio.jar
Rem           to $ORACLE_HOME/ord/jlib 
Rem
Rem       3. Run this script (initjp2.sql) while connected as SYSTEM, 
Rem           SYS or SYSDBA to install the JPEG2000 codec into the 
Rem           ORDJP2K schema.
Rem
Rem       Because something in Suns implementation of J2KWriter calls 
Rem        java.io.File.createTempFile, it is necessary to grant the
Rem        read/write/delete permissions on java.io.tmpdir to ORDJP2K, 
Rem        ORDSYS.
Rem
Rem       In addition, arrangements must be made for users who wish to 
Rem        write JPEG2000 files to have permissions on the temporary directory.
Rem        These permissions can be granted in one of two ways:
Rem
Rem       1. Explicitly grant read/write/delete permissions on java.io.tmpdir
Rem           to every database schema that will call 
Rem           ORDSYS.ORDImage.processCopy to write JPEG2000 images. 
Rem       2. Change J2KimageWriter to run with definers rights by connecting
Rem           as SYSDBA and running the following SQL commands: 
Rem
Rem          alter session set current_schema = "ORDJP2K";
Rem          alter java class 
Rem             "com.sun.media.imageioimpl.plugins.jpeg2000.J2KImageWriter" 
Rem             AUTHID DEFINER;
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    smavris     10/22/07 - Check to see if Oracle Multimedia schemas have
Rem                           been removed
Rem    smavris     06/09/07 - interMedia to Multimedia
Rem    smavris     08/07/06 - Make passwords case sensitive
Rem    dolin       05/11/05 - Add loading clibwrapper_jiio.jar 
Rem    alamb       03/03/05 - update comments 
Rem    alamb       02/04/05 - alamb_test_jpeg_2k_integration_050114
Rem    alamb       01/25/05 - Created
Rem

WHENEVER SQLERROR EXIT;

REM 
REM Make sure Oracle Multimedia schemas exist.
REM 

@@imchksch.sql

WHENEVER SQLERROR CONTINUE;

DEFINE JP2JAILOC = ord/jlib/jai_imageio.jar
DEFINE JP2LIBLOC = ord/jlib/clibwrapper_jiio.jar
DEFINE JP2SCHEMA = ORDJP2K
DEFINE JP2PASSWORD = 'ordjp2k'

CREATE USER &JP2SCHEMA identified by &JP2PASSWORD;
ALTER USER &JP2SCHEMA ACCOUNT LOCK;
ALTER USER &JP2SCHEMA PASSWORD EXPIRE;

-- now, load the java into the new user's schema (note public synonyms)
-- also note the generation of non-resolvable classes
CALL dbms_java.loadjava('-grant public ' ||
                        '-synonym ' ||
                        '-resolve ' ||
                        '-schema &JP2SCHEMA ' ||
                        '-verbose ' ||
                        '-genmissing ' ||
                        '&JP2JAILOC');

CALL dbms_java.loadjava('-grant public ' ||
                        '-synonym ' ||
                        '-resolve ' ||
                        '-schema &JP2SCHEMA ' ||
                        '-verbose ' ||
                        '-genmissing ' ||
                        '&JP2LIBLOC');


-- Save the original value of CURRENT_SCHEMA before change to ORDSYS
VARIABLE ORDORIGSCHEMA VARCHAR2(2000);
DECLARE 
  t varchar2(2000);
BEGIN
  SELECT sys_context('USERENV', 'CURRENT_SCHEMA') INTO t FROM dual;
  :ORDORIGSCHEMA := t;
END;
/

ALTER SESSION SET CURRENT_SCHEMA = "ORDSYS";

CREATE OR REPLACE FUNCTION ordGetJavaProp (propname varchar2) 
RETURN varchar2 
AS LANGUAGE JAVA
NAME 'java.lang.System.getProperty(java.lang.String) return java.lang.String';
/

-- Grant the write permissions on java.io.tmpdir to JP2KUSER
BEGIN
  dbms_java.grant_permission
    ('ORDSYS', 
     'SYS:java.io.FilePermission',
     ordGetJavaProp('java.io.tmpdir') || ordGetJavaProp('file.separator') || '*',
     'read,write,delete');

  dbms_java.grant_permission
    ('&JP2SCHEMA', 
     'SYS:java.io.FilePermission',
     ordGetJavaProp('java.io.tmpdir') || ordGetJavaProp('file.separator') || '*',
     'read,write,delete');
END;
/

DROP FUNCTION ordGetJavaProp;

-- restore the original CURRENT_SCHEMA value
BEGIN
  EXECUTE IMMEDIATE 'ALTER SESSION SET CURRENT_SCHEMA = "'||:ORDORIGSCHEMA||'"';
END;
/

