Rem
Rem $Header: ordabfsp.sql 20-sep-2004.12:09:30 rabbott Exp $
Rem
Rem ordabfsp.sql
Rem
Rem Copyright (c) 1998, 2004, Oracle. All rights reserved.  
Rem  All Rights Reserved.
Rem
Rem    NAME
Rem      ordabfsp.sql - <one-line expansion of the name>
Rem
Rem    DESCRIPTION
Rem      ORD A BFile SPecification - plugin for BFILES
Rem
Rem    NOTES
Rem      This plugin extends ORDSYS.ORDSource to look at BFILE
Rem      as a viable source. Since BFILES are READ ONLY
Rem      all WRITE or EXPORT operations will raise 
Rem      ORDSourceExceptions.METHOD_NOT_IMPLEMENTED
Rem
Rem      Implemented Methods are:
Rem         import
Rem         importFrom
Rem         getContentLength
Rem         getSourceAddress
Rem         open
Rem         close
Rem         read
Rem 
Rem
Rem    MODIFIED   (MM/DD/YY)
Rem    rabbott     09/20/04 - Move private routines
Rem    smavris     04/11/01 - Update copyright
Rem    dmullen     03/03/00 - Add simplified import to fix bug 949833
Rem    dmullen     10/07/99 - Implement export
Rem    rchatter    11/16/98 - rework context parameter
Rem    alsrivas    11/02/98 - fixing arg ordering in ctx and obj
Rem    alsrivas    08/27/98 - adding NOCOPY
Rem    alsrivas    08/05/98 - updating apis
Rem    alsrivas    06/12/98 - updating interfaces
Rem    alsrivas    06/08/98 - adding pragma
Rem    alsrivas    05/27/98 - adding authorization
Rem    alsrivas    05/25/98 - changes made per code review findings
Rem    alsrivas    05/11/98 - updating
Rem    alsrivas    04/27/98 - updating code for user-defined sources
Rem    alsrivas    04/27/98 - ORD Audio BFile SPecification
Rem    alsrivas    04/27/98 - Created
Rem

Rem
Rem ORD eXtension for bFILE SOURCE
Rem

CREATE OR REPLACE PACKAGE ORDX_FILE_SOURCE 
authid current_user
AS
 
  -- functions/procedures
  FUNCTION processCommand(
                    obj  IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx  IN OUT RAW,
                    cmd  IN VARCHAR2,
                    arglist IN VARCHAR2,
                    result  OUT RAW)
           RETURN RAW;

  PROCEDURE import( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx      IN OUT RAW,
                    mimetype OUT VARCHAR2,
                    format   OUT VARCHAR2);

  PROCEDURE import( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx      IN OUT RAW,
                    dlob     IN OUT NOCOPY BLOB,
                    mimetype OUT VARCHAR2,
                    format   OUT VARCHAR2);

  PROCEDURE importFrom( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                        ctx      IN OUT RAW,
                        mimetype OUT VARCHAR2,
                        format   OUT VARCHAR2,
                        loc      IN VARCHAR2,
                        name     IN VARCHAR2);

  PROCEDURE importFrom( obj      IN OUT NOCOPY ORDSYS.ORDSource,
                        ctx      IN OUT RAW,
                        dlob     IN OUT NOCOPY BLOB,
                        mimetype OUT VARCHAR2,
                        format   OUT VARCHAR2,
                        loc      IN VARCHAR2,
                        name     IN VARCHAR2);
 
  PROCEDURE export( obj  IN OUT NOCOPY ORDSYS.ORDSource,
                    ctx  IN OUT RAW,
                    slob IN OUT NOCOPY BLOB,
                    loc  IN VARCHAR2,
                    name IN VARCHAR2);
 
  FUNCTION  getContentLength(obj  IN ORDSYS.ORDSource,
                             ctx  IN OUT RAW) 
            RETURN INTEGER;
  PRAGMA RESTRICT_REFERENCES(getContentLength, WNDS, WNPS, RNDS, RNPS);

  FUNCTION  getSourceAddress(obj  IN ORDSYS.ORDSource,
                             ctx  IN OUT RAW,
                             userData IN VARCHAR2) 
            RETURN VARCHAR2;
  PRAGMA RESTRICT_REFERENCES(getSourceAddress, WNDS, WNPS, RNDS, RNPS);

  FUNCTION open(obj IN OUT NOCOPY ORDSYS.ORDSource,
                userArg IN RAW,
                ctx OUT RAW) RETURN INTEGER;
  FUNCTION close(obj IN OUT NOCOPY ORDSYS.ORDSource,
                 ctx IN OUT RAW) RETURN INTEGER;
  FUNCTION trim(obj    IN OUT NOCOPY ORDSYS.ORDSource,
                       ctx IN OUT RAW,
                       newlen IN INTEGER) RETURN INTEGER;
 
  PROCEDURE read(obj      IN OUT NOCOPY ORDSYS.ORDSource,
                 ctx      IN OUT RAW,
                 startPos IN INTEGER,
                 numBytes IN OUT INTEGER,
                 buffer   OUT RAW);
 
  PROCEDURE write(obj      IN OUT NOCOPY ORDSYS.ORDSource,
                  ctx      IN OUT RAW,
                  startPos IN INTEGER,
                  numBytes IN OUT INTEGER,
                  buffer   IN RAW);

END ORDX_FILE_SOURCE;
/
show errors;

